
// Glenn's StopLight POV-Ray Object File
// This file does not render.  #include "StopLight.inc" in another .pov file
// first concept 29-Sep-97  last update 29-Sep-97
// copyright 1997 Glenn McCarter

// A 4-way hanging stop light
// objects: Hanging4StopLight
// Intended scale is English system (inches)
// origin at hanging pivot point,
//
// Uses RH coord system

//===============================================
//             Variables
//===============================================

#declare LightColor = "red" // guess what this means?

//===============================================
//             Textures
//===============================================

#declare StopLightTex =
	texture {
		pigment { color rgb<.04,.04,.04> }
		normal { bumps 0.2 scale .1 }
		finish { ambient .02 specular .92 roughness .02 }
	}

#switch ( Color )
#case (1) // scene is in color
	#declare RedLightTex =
		texture {
			pigment { color rgb<.99,.20,.00> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .1 specular .6 roughness .02 reflection .1 }
		}
	#declare YellowLightTex =
		texture {
			pigment { color rgb<.22,.22,.00> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .1 specular .6 roughness .02 reflection .1 }
		}
	#declare GreenLightTex =
		texture {
			pigment { color rgb<.0,.33,.00> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .1 specular .6 roughness .02 reflection .1 }
		}
#break
#else // black & white, assumes Red light is on
	#declare RedLightTex =
		texture {
			pigment { color rgb<.66,.66,.66> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .2 specular .6 roughness .02 reflection .1 }
		}
	#declare YellowLightTex =
		texture {
			pigment { color rgb<.11,.11,.11> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .06 specular .6 roughness .02 reflection .1 }
		}
	#declare GreenLightTex =
		texture {
			pigment { color rgb<.11,.11,.11> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .06 specular .6 roughness .02 reflection .1 }
		}
#end



//===============================================
//             Objects
//===============================================

#declare Case =
	box {
		<-6,-4,-24>,<0,4,0>
		texture { StopLightTex }
	}

#declare Hood =
	intersection {
		cylinder { // main outer
			<0,0,0>,<8,0,0>,3
		}
		cylinder { // main inner
			<-0.1,0,0>,<8.1,0,0>,2.9
			inverse
		}
		cylinder { // cuts hood
			<-2,-4,4>,<-2,4,4>,8
		}
		texture { StopLightTex }
	}
#declare Ring =
		cylinder {
			<0,0,0>,<1,0,0>,3.5
			texture { StopLightTex }
		}
#declare RedLens =
	sphere {
		<0,0,0>,2.7
		scale <.3,1,1>
		texture { RedLightTex }
	}
#declare YellowLens =
	sphere {
		<0,0,0>,2.7
		scale <.3,1,1>
		texture { YellowLightTex }
	}
#declare GreenLens =
	sphere {
		<0,0,0>,2.7
		scale <.3,1,1>
		texture { GreenLightTex }
	}

#declare HangingPost =
	union {
		cylinder {
			<0,0,-4>,<0,0,12.2>,1.3
		}
		cylinder {
			<0,0,12>,<0,0,17>,1.9
		}
		texture { StopLightTex }
	}

//===============================================
//             StopLight
//===============================================

#declare StopLight =
	union {
		object { Case }
		object { Hood translate <.8,0,-5> }
		object { Hood translate <.8,0,-12> }
		object { Hood translate <.8,0,-19> }
		object { Ring translate <-.2,0,-5> }
		object { Ring translate <-.2,0,-12> }
		object { Ring translate <-.2,0,-19> }
		object { RedLens translate <1,0,-5> }
		object { YellowLens translate <1,0,-12> }
		object { GreenLens translate <1,0,-19> }
	}


//===============================================
//             StopLightAssy
//===============================================

#declare Hanging3StopLight =
	union {
		object { StopLight translate <12,0,0> rotate <0,0,0> }
		object { StopLight translate <12,0,0> rotate <0,0,90> }
		object { StopLight translate <12,0,0> rotate <0,0,180> }
		object { HangingPost }
	}

#declare Hanging4StopLight =
	union {
		object { StopLight translate <12,0,0> rotate <0,0,0> }
		object { StopLight translate <12,0,0> rotate <0,0,90> }
		object { StopLight translate <12,0,0> rotate <0,0,180> }
		object { StopLight translate <12,0,0> rotate <0,0,270> }
		object { HangingPost }
	}


