
// Glenn's StreetScene POV-Ray Object File
// This file does not render.  #include "StreetScene.inc" in another .pov file
// first concept 29-Sep-97  last update 20-Oct-97
// copyright 1997 Glenn McCarter

// Some objects commonly found around a city street
// Objects:
//		StreetSign
//		BusStopSign
//		ManHoleCover (complex version)
//		SManHoleCover (simple version)
//		ParkBench
//		OldBench
//		StreetCornerLight
//
// Intended scale is English system (inches)
// sign origin at base of signage (not the post!),
// extends upwards into +Z, with signs in +X and +Y
// Manhole cover origin at center, face sits at Z=0 plane
// Uses RH coord system

//===============================================
//             Variables
//===============================================

#declare Sign1Text = "Market St."
#declare Sign2Text = "Maple Ave."

//===============================================
//             Textures
//===============================================

#declare AmbientWhite =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .99 specular .2 roughness .005 }
	}

#declare Grey20 =
	texture {
		pigment { color rgb<.2,.2,.2> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}

#declare GreyRust =
	texture {
		pigment {
			agate
			color_map {
				[0.00 color rgb<.20,.19,.21> ] // iron
				[0.45 color rgb<.16,.13,.11> ] // light rust
				[0.50 color rgb<.04,.03,.04> ] // dark rust
				[0.55 color rgb<.16,.13,.11> ] // light rust
				[1.00 color rgb<.20,.19,.21> ] // iron
			}
			scale .3
		}
		finish { ambient .02 specular .1 roughness .14 }
	}

#declare SignPostTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0  color rgb<0.24,0.34,0.21> ]
				[ 0.5  color rgb<0.55,0.54,0.55> ]
				[ 1.0  color rgb<0.48,0.44,0.49> ]
			}
			scale <.09,.09,.52>
		}
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .95 roughness .005 metallic brilliance 3 }
	}

#declare WhitePaint = // for lettering
	texture {
		pigment { color rgb<.99,.99,.99> }
		normal { bumps 0.1 scale .05 }
		finish { ambient .12 specular .72 roughness .01 }
	}

#declare ParkBenchWoodTex =
	texture {
		pigment {
			wood
			color_map {
				[ 0.0  color rgb<0.32,0.34,0.32> ]
				[ 0.3  color rgb<0.65,0.65,0.66> ]
				[ 0.5  color rgb<0.22,0.22,0.22> ]
				[ 0.7  color rgb<0.53,0.54,0.53> ]
				[ 1.0  color rgb<0.32,0.34,0.32> ]
			}
    turbulence 0.04
    octaves 3
		rotate <0,90,0> // rings around x-axis
		scale <1,.1,.1>
		}
		normal { bumps 0.2 scale <2.0,.15,.15> }
		finish { ambient .02 specular .7 roughness .006 }
	}

#switch ( Wet )
#case (1) // wet
	#declare SignPostTex =
		texture {
			pigment { color rgb<.4,.4,.4> }
			normal { bumps 0.2 scale .1 }
			finish { ambient .02 specular .92 roughness .02 reflection .2 }
		}
	#declare SignTex =
		texture {
			pigment { color rgb<.04,.04,.04> }
			normal { bumps 0.1 scale .4 }
			finish { ambient .02 specular .92 roughness .01 reflection .2 }
		}
	#declare ManHoleCoverTex =
		texture {
			pigment { color rgb<.09,.09,.09> }
			normal { bumps 0.3 scale 2 }
			finish { ambient .02 specular .7 roughness .03 reflection .2 }
		}
#break // wet
#else // dry
	#declare SignPostTex =
		texture {
			pigment { color rgb<.7,.7,.7> }
			normal { bumps 0.3 scale .4 }
			finish { ambient .02 specular .75 roughness .08 }
		}
	#declare SignTex =
		texture {
			pigment { color rgb<.04,.04,.04> }
			normal { bumps 0.1 scale .4 }
			finish { ambient .02 specular .75 roughness .04 }
		}
	#declare ManHoleCoverTex =
		texture {
			pigment { color rgb<.09,.09,.09> }
//			pigment { color rgb<.9,.9,.9> } // test
			normal { bumps 0.4 scale .3 }
			finish { ambient .02 specular .7 roughness .03 }
		}
#end // dry



//===============================================
//             Signs
//===============================================

#declare Sign1 =
	union {
		box { // main
			<0,0,0>,<24,.12,6>
			texture { SignTex }
		}
			text {
				// NOTE: in RH reference system, the FRONT FACE
				// of text is extruded into +Z
				ttf "c:\Windows\Fonts\ARIAL.TTF",
				Sign1Text,
				0.12,     // THICKNESS_FLOAT
				0       //OFFSET_VECTOR
				texture { WhitePaint }
				scale <4,3.6,1>
				rotate <90,0,0> // upright into +Z
				translate <2.5,-.1,1.5>
			}
	}

#declare Sign2 =
	union {
		box { // main
			<0,0,0>,<24,.12,6>
			texture { SignTex }
		}
			text {
				// NOTE: in RH reference system, the FRONT FACE
				// of text is extruded into +Z
				ttf "c:\Windows\Fonts\ARIAL.TTF",
				Sign2Text,
				0.12,     // THICKNESS_FLOAT
				0       //OFFSET_VECTOR
				texture { WhitePaint }
				scale <4,3.6,1>
				rotate <90,0,0> // upright into +Z
				translate <2.5,-.1,1.5>
			}
	}

//===============================================
//             SignAssy
//===============================================

#declare Sign1Assy =
	union {
		object { Sign1 translate <0,0,-.12> }
		object { Sign1 rotate <0,0,180> translate <24,.12,0> }
		cylinder { // top edge
			<0,0,0>,<24.8,0,0>,.24
			scale <1,1,1.3>
			texture { SignPostTex }
			clipped_by { box { <0,-1,-.1>,<25,1,1> } }
			translate <0,0,5.8>
		}
		cylinder { // lower edge
			<0,0,0>,<24.8,0,0>,.24
			scale <1,1,1.3>
			texture { SignPostTex }
			clipped_by { box { <0,-1,-1>,<25,1,.1> } }
			translate <0,0,.2>
		}
		box { // bracket
			<-1,-.5,-.8>,<.1,.5,6.8>
			texture { SignPostTex }
		}
	}

#declare Sign2Assy =
	union {
		object { Sign2 translate <0,0,-.12> }
		object { Sign2 rotate <0,0,180> translate <24,.12,0> }
		cylinder { // top edge
			<0,0,0>,<24.8,0,0>,.24
			scale <1,1,1.3>
			texture { SignPostTex }
			clipped_by { box { <0,-1,-.1>,<25,1,1> } }
			translate <0,0,5.8>
		}
		cylinder { // lower edge
			<0,0,0>,<24.8,0,0>,.24
			scale <1,1,1.3>
			texture { SignPostTex }
			clipped_by { box { <0,-1,-1>,<25,1,.1> } }
			translate <0,0,.2>
		}
		box { // bracket
			<-1,-.5,-.8>,<.1,.5,6.8>
			texture { SignPostTex }
		}
	}

//===============================================
//             SignPost
//===============================================

#declare StreetSignPost =
	union {
		cylinder { // main
			<0,0,-14*Feet>,<0,0,9>,1.1
		}
		sphere { // top cap
			<0,0,0>,1.4
			scale <1,1,1.7>
			clipped_by { box { <-3,-3,-.4>,<3,3,3> } }
			translate <0,0,9>
		}
		texture { SignPostTex }
	}

//===============================================
//             StreetSign
//===============================================

#declare StreetSign =
	union {
		object { Sign1Assy translate <1.6,0,0> }
		object { Sign2Assy translate <1.6,0,0> rotate <0,0,90> }
		object { StreetSignPost }
	}

//===============================================
//             BusStopSign
//===============================================

#declare BusStopSignBoard =
	union {
		object { RoundedBox // main
			translate <0,.5,.5> // front face at origin
			scale <9,.17,16>
			texture { WhitePaint }
		}
		difference { // forms a black rect ring
			box {
				<-4,-.01,1>,<4,.05,15>
				texture { pigment { color rgb<0,0,0> } }
			}
			box {
				<-3.5,-1,1.5>,<3.5,1,14.5>
				texture { pigment { color rgb<0,0,0> } }
			}
		} // end difference
		text {
			// NOTE: in RH reference system, the FRONT FACE
			// of text is extruded into +Z
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"BUS",
			0.12,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { pigment { color rgb<0,0,0> } }
			scale <2.3,6,1>
			rotate <90,0,0> // upright into +Z
			translate <-1.9,-.1,9>
		}
		text {
			// NOTE: in RH reference system, the FRONT FACE
			// of text is extruded into +Z
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"STOP",
			0.12,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { pigment { color rgb<0,0,0> } }
			scale <2.0,6,1>
			rotate <90,0,0> // upright into +Z
			translate <-2.4,-.1,3>
		}
	}

#declare PostHeight = 7.6*Feet
#declare BusStopSignPost =
	union {
		difference { // hollow box
			box {
				<-1.3,0,0>,<1.3,1.5,PostHeight>
			}
			box {
				<-1.0,-1,-1>,<1.0,1.2,PostHeight+1>
			}
		} // end difference
		cylinder {
			<0,0,0>,<0,0,PostHeight>,1.3
			translate <0,1.5,0>
		}
		texture { SignPostTex }
	}

#declare BusStopSign = // sign is in XZ axis, faces -Y
	union {
		object { BusStopSignBoard translate <0,-.2,6*Feet> }
		object { BusStopSignPost }
	}

//===============================================
//             ManHoleCover
//===============================================

#declare SManHoleCover = // simple version
	cylinder { // main
		<0,0,-1>,<0,0,0>,11
		texture { ManHoleCoverTex }
	}

#declare ManHoleCover = // complex version
	union {
		difference { // the hole
			cylinder { // main rim
				<0,0,-5>,<0,0,-.1>,12
				texture { Grey20 }
			}
			cylinder { // rim hole
				<0,0,-6>,<0,0,1>,11.2
			}
		} // end difference
		difference { // the cover
			cylinder { // main rim
				<0,0,-2.3>,<0,0,0>,10.9
			}
			cylinder { // depression
				<0,0,-.4>,<0,0,1>,9.5
			}
		} // end difference
		box { // center bar
			<-.6,-7,-1>,<.6,7,0>
			translate <-3,0,0>
		}
		box { // another bar
			<-1,-4,-1>,<1,4,0>
			translate <-6,0,0>
		}
		#declare RowCount = 1
		#while ( RowCount < 4 )
			#declare ColCount = 1
			#while ( ColCount < 5 )
					box { // small cubes
					<-.5,-.5,-1>,<.5,.5,0>
					translate <-2+RowCount*3,-8+ColCount*3,0>
				}
				#declare ColCount = ColCount + 1
			#end
		#declare RowCount = RowCount + 1
		#end
		texture { ManHoleCoverTex }
	}

//===============================================
//             ParkBench
//             This version is chairlike
//===============================================

#declare BLength = 7*Feet
#declare WoodRail =
	box {
		<0,0,0>,<BLength,3.5,1.8>
		texture { ParkBenchWoodTex }
	}

#declare EndGroup =
	union {
		box { // front riser
			<-.8,-1.0,0>,<.8,1.0,20>
			translate <0,3,0>
		}
		box { // rear riser
			<-.8,-1.0,0>,<.8,1.0,36>
			translate <0,18,0>
		}
		box { // lower connector
			<-.8,0,0>,<.8,15,2>
			translate <0,3,8>
		}
		box { // upper connector
			<-.8,0,0>,<.8,18,2>
			translate <0,0,20>
		}
		texture { GreyRust }
	} // end union

#declare ParkBench =
	union {
		object { EndGroup translate <0,0,0> }
		object { EndGroup translate <BLength,0,0> }
		object { WoodRail rotate <12,0,0> translate <0,2,12> } // bottom front
		object { WoodRail rotate <0,0,0> translate <0,7,11.5> } // bottom middle
		object { WoodRail rotate <-8,0,0> translate <0,14,11> } // bottom rear
		object { WoodRail rotate <70,0,0> translate <0,19,31> } // rear top
		object { WoodRail rotate <84,0,0> translate <0,18,25> } // rear middle
		object { WoodRail rotate <90,0,0> translate <0,17,19> } // rear bottom
	}

//===============================================
//             ParkBench2
//             This version is fancier
//===============================================

#declare BLength = 7*Feet
#declare BottomWoodRail =
	box {
		<0,-.3,0>,<BLength,3.9,1.8>
		texture { ParkBenchWoodTex }
	}
#declare TieRail =
	box {
		<-2,-6.5,0>,<2,10,0.8>
		texture { ParkBenchWoodTex }
	}

#declare RR = .4 // rail radius
#declare RP = RR+.1 // trim
#declare R1 = 2
#declare R2 = 3
#declare R3 = 5
#declare L4 = 6
#declare R5 = 2
#declare L6 = 9
#declare R7 = 5
#declare R8 = 3
#declare R9 = 1.5
#declare T1 = torus { R1,RR clipped_by { box { <0,-RP,-R1-RP>,<R1+RP,RP,R1+RP> } } }
#declare T2 = torus { R2,RR clipped_by { box { <-R2-RP,-RP,-R2-RP>,<0,RP,R2+RP> } } }
#declare T3 = torus { R3,RR clipped_by { box { <0,-RP,-R3-RP>,<R3+RP,RP,R3+RP> } } }
#declare C4 = cylinder { <-L4,0,0>,<0,0,0>,RR translate <0,0,R3> }
#declare T5 = torus { R5,RR clipped_by { box { <-R5-RP,-RP,-R5-RP>,<0,RP,R5+RP> } } }
#declare C6 = cylinder { <0,0,0>,<L6,0,0>,RR translate <-L4,0,R3+R5*2> }
#declare T7 = torus { R7,RR clipped_by { box { <0,-RP,-R7-RP>,<R7+RP,RP,R7+RP> } } }
#declare T8 = torus { R8,RR clipped_by { box { <-R8-RP,-RP,-R8-RP>,<0,RP,R8+RP> } } }
#declare T9 = torus { R9,RR clipped_by { box { <0,-RP,-R9-RP>,<R9+RP,RP,R9+RP> } } }
#declare ExtraRing = torus { R8,RR }
#declare FootCurve = torus { 12,RR+.3 translate <0,0,-5.5> clipped_by { box { <-13,-2,0>,<13,2,13> } } texture { GreyRust } }
#declare FootBox = box { <-2,-2.6,0>,<2,2.6,1.1> texture { GreyRust } }

#declare EndCurve =
	union {
		object { T1 translate <0,0,-R1/2> }
		object { T2 translate <0,0,-R2+R1/2> }
		object { T3 }
		object { C4 }
		object { T5 translate <-L4,0,R3+R5> }
		object { C6 }
		object { T7 translate <-L4+L6,0,R3+R5*2+R7> }
		object { T8 translate <-L4+L6,0,R3+R5*2+R7*2-R8> }
		object { T9 translate <-L4+L6,0,R3+R5*2+R7*2-R8*2+R9> }
		object { ExtraRing translate <6.5,0,6> }
		texture { GreyRust }
	}
#declare EndShape =
	union {
		object { EndCurve scale <1.4,1,1.3> rotate <0,18,0> translate <0,0,14> }
		object { FootCurve }
	}
#declare CutOutEnd =
	union {
		object { EndShape }
		object { EndShape translate <0,1.2,0> }
		object { EndShape translate <0,-1.2,0> }
	}
#declare OldBenchEnd =
	union {
		object { CutOutEnd }
		object { FootBox translate <-10,0,0> }
		object { FootBox translate <10,0,0> }
	}
#declare OldBench =
	union {
		object { OldBenchEnd rotate z*90 translate <-4,0,0> }
		object { OldBenchEnd rotate z*90 translate <BLength+4,0,0> }
		object { BottomWoodRail rotate <10,0,0> translate <0,-7,11> } // bottom front
		object { BottomWoodRail rotate <0,0,0> translate <0,0,11.5> } // bottom middle
		object { BottomWoodRail rotate <6,0,0> translate <0,7,11> } // bottom rear
		object { TieRail rotate <0,0,0> translate <1,0,10.6> } // bottom support
		object { TieRail rotate <0,0,0> translate <BLength-1,0,10.6> } // bottom support
		object { WoodRail rotate <70,0,0> translate <0,13,32> } // back top
		object { WoodRail rotate <84,0,0> translate <0,12,26> } // back middle
		object { WoodRail rotate <90,0,0> translate <0,11,20> } // back bottom
	}

//===============================================
//             StreetCornerLight
//===============================================

#declare FadeXTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.00  color rgbt<1,1,1,1.0> ] // clear
				[ 0.05  color rgbt<1,1,1,1.0> ] // begin fade
				[ 0.50  color rgbt<1,1,1,0.1> ] // max color
				[ 0.95  color rgbt<1,1,1,1.0> ] // end fade
				[ 1.00  color rgbt<1,1,1,1.0> ] // clear
			}
		}
	}
#declare ClearTex =
	texture {
		pigment { color rgbt<1,1,1,1> }
	}
#declare FadeTex =
	texture {
		gradient y
			texture_map {
				[ 0.00 ClearTex ]
				[ 0.05 ClearTex ] // guarantees edges are clear
//				[ (.5-BYSpread/2+.05) FadeColor ]
				[ 0.50 FadeXTex ]
//				[ (.5+BYSpread/2-.05) FadeColor ]
				[ 0.95 ClearTex ] // guarantees edges are clear
//				[ 0.96 FrameBlackTex ] // for debugging
//				[ 1.00 FrameBlackTex ] // for debugging
				[ 1.00 ClearTex ]
			}
	}
#declare LightFadeCap =
	box {
		<0,0,0>,<1,1,.0001>
		texture { FadeTex scale <1,1,1> }
		scale <3,3,1>
		translate <-1.5,-1.5,0>
	}

#declare SCLHeight = 8*Feet // to center of bulb
#declare StreetCornerLightPost =
	union {
		cylinder { // main
			<0,0,8>,<0,0,SCLHeight-4.9>,2.0
		}
		torus { // ring at top
			2.3,0.4
			rotate <90,0,0>
			translate <0,0,SCLHeight-8>
		}
		torus { // ring at midlow
			3.0,0.4
			rotate <90,0,0>
			translate <0,0,36>
		}
		cylinder { // ring at midlow
			<0,0,0>,<0,0,.4>,3.0
			translate <0,0,36>
		}
		cylinder { // base
			<0,0,0>,<0,0,18>,3.4
		}
		torus { // base top
			3.0,0.4
			rotate <90,0,0>
			translate <0,0,18>
		}
		box { // baseplate
			<-5,-5,-.2>,<5,5,2.2>
		}
		object { LightFadeCap // blocks upper light
			translate <0,0,SCLHeight+2.5>
		}
		object { LightFadeCap // blocks lower light
			translate <0,0,SCLHeight-2.5>
		}
		texture { SignPostTex }
	}

#declare ShadeGlassShape =
	prism {
		linear_sweep
		0.0 // HEIGHT1,
		0.2 // HEIGHT2,
		4 // TOTAL_NUMBER_OF_POINTS,
		// points lie in xz plane, swept into +y
		<2,0>,<4,10>,<-4,10>,<-2,0>
//		texture { AmbientWhite }
  }
#declare ShadeGlass =
	union {
		object { ShadeGlassShape texture { AmbientWhite } }
//		object { ShadeGlassShape scale <1.1,1,1.1> translate <0,.1,-.3> texture { SignPostTex } }
		object { ShadeGlassShape scale <1.1,1,1.1> translate <0,.1,-.3> texture { GreyRust } }

	}
#declare StreetCornerLampShade =
	union {
		object { ShadeGlass rotate <15,0,0> translate <0,-2,-5> rotate <0,0,0> }
		object { ShadeGlass rotate <15,0,0> translate <0,-2,-5> rotate <0,0,90> }
		object { ShadeGlass rotate <15,0,0> translate <0,-2,-5> rotate <0,0,180> }
		object { ShadeGlass rotate <15,0,0> translate <0,-2,-5> rotate <0,0,270> }
		box { // bottom
			<-3.3,-3.3,0>,<3.3,3.3,1>
			translate <0,0,-5.5>
//			texture { SignPostTex }
			texture { GreyRust }
		}
		box { // top
			<-5.9,-5.9,0>,<5.9,5.9,1>
			translate <0,0,5>
			texture { GreyRust }
//			texture { SignPostTex }
		}
		cylinder { // lid
			<0,0,0>,<0,0,1>,3.8
			translate <0,0,6>
			texture { SignPostTex }
		}
		cylinder { // sphere support
			<0,0,0>,<0,0,2>,.8
			translate <0,0,7>
			texture { SignPostTex }
		}
		sphere {
			<0,0,0>,1.4
			translate <0,0,9>
			texture { SignPostTex }
		}
	}

#declare StreetCornerLightSource =
  light_source {
    <0,0,0>
    colour rgb <1.8,1.8,1.8>
		fade_distance 2.6*Feet
		fade_power 1
		looks_like {
			object { StreetCornerLampShade }
		}
  }

#declare StreetCornerLight =
	union {
		object { StreetCornerLightPost }
		object { StreetCornerLightSource translate <0,0,SCLHeight> }
	}
