
// Glenn's Umbrella POV-Ray Object File
// This file does not render.  #include "umbrella.inc" in another .pov file
// first concept 28-Sep-97  last update 28-Sep-97
// copyright 1997 Glenn McCarter

// an umbrella
// objects: OpenUmbrella
// Intended scale is English system (inches)
// origin at base of handle
// Uses RH coord system

//===============================================
//             Variables
//===============================================

#declare Panels = 12 // number of leaves around the umbrella

//===============================================
//             Textures
//===============================================

#switch ( Wet )
#case (1) // wet
	#declare UmbrellaTex =
		texture {
			pigment { color rgb<.036,.036,.038> }
			normal { bumps 0.2 scale 1 }
			finish { ambient .02 specular .85 roughness .03 reflection .2 }
		}
#break
#else // dry
	#declare UmbrellaTex =
		texture {
			pigment { color rgb<.11,.11,.13> }
			normal { bumps 0.3 scale 4 }
			finish { ambient .02 specular .6 roughness .005 }
		}
#end

#declare ShaftTex =
	texture {
		pigment { color rgb<.68,.68,.73> }
		normal { bumps 0.2 scale .8 }
		finish { ambient .02 diffuse .3 specular .95 roughness .0012 metallic reflection .6 }
	}


//===============================================
//             Umbrella Parts
//===============================================

#declare Shaft =
	cylinder {
		<0,0,-30>,<0,0,2.2>,.21
		texture { ShaftTex }
	}
#declare Handle =
	cylinder {
		<0,0,0>,<0,0,6>,.5
		texture { UmbrellaTex }
		translate <0,0,-30>
	}
#declare OpenLeaf =
	intersection {
		cylinder { // main outer surface
			<0,-10,0>,<0,10,0>,15
			translate <0,0,-15> // origin at ground level
		}
		cylinder { // main inner surface
			<0,-10,0>,<0,10,0>,14.93
			translate <0,0,-15> // origin at ground level
			inverse
		}
		box { // eliminate bottom half
			<-30,-30,-40>,<30,30,-15>
			inverse
		}
		box { // left edge
			<-30,-30,-30>,<30,0,30>
			rotate <0,0,360/(Panels*2)> // 1/16 of a circle = 8 panels
			inverse
		}
		box { // right edge
			<-30,0,-30>,<30,30,30>
			rotate <0,0,-360/(Panels*2)> // 1/16 of a circle = 8 panels
			inverse
		}
		cylinder { // rounded edge
//			<0,0,-30>,<0,0,40>,24 // for 8 panels
			<0,0,-30>,<0,0,40>,12 // for 12 panels
			rotate <0,-30,0>
//			translate <-38,0,-15> // origin at ground level // for 8 panels
			translate <-24,0,-15> // origin at ground level // for 12 panels
			inverse
		}
		texture { UmbrellaTex }
	} // end intersection

//===============================================
//             Umbrellas
//===============================================


#declare Umbrella =
	union {
		object { Shaft }
		object { Handle }
		#declare PanelCount =0
		#while ( PanelCount < Panels )
			object { OpenLeaf rotate z*PanelCount*360/Panels }
			#declare PanelCount = PanelCount + 1
		#end
		translate <0,0,30> // origin at base of handle
	} // end union

