/*
 * decal: a variant of paintedplastic that projects the texture onto the surface
 *        instead of wrapping it around the object
 */

/* Adapted from Pixar's show_xyz shader.  Its original credits: */
/* Copyrighted Pixar 1989 */
/* From the RenderMan Companion p.347 */
/* Listing 16.13  Shader mapping shader-space coordinates to colors */


/* Select component of point based on plane and index, and scale it */
float
selscl (float index,
              plane,
              c0min,
              c0max,
              c1min,
              c1max;
              point p)
{
  float cmpn, cmin, cmax, scale;

  if (index == 0)
    {
      if (plane == 0 || plane == 1)
        cmpn = xcomp (p);
      else if (plane == 2 || plane == 3)
        cmpn = ycomp (p);
      else if (plane == 4 || plane == 5)
        cmpn = zcomp (p);
      cmin = c0min;
      cmax = c0max;
    }
  else
    {
      if (plane == 3 || plane == 4)
        cmpn = xcomp (p);
      else if (plane == 0 || plane == 5)
        cmpn = ycomp (p);
      else if (plane == 1 || plane == 2)
        cmpn = zcomp (p);
      cmin = c1min;
      cmax = c1max;
    }

/* Given selected component, scale to fit texture coords */
   scale = 1 / (cmax - cmin);
   cmpn = (cmpn - cmin) * scale;
   if (index == 1)
     cmpn = 1 - cmpn;  /* invert vertical index, for convenience */
   return cmpn;
}


/* Plane specifies the mapping plane:  0=XY, 1=XZ, 2=YZ, 3=YX, 4=ZX, 5=ZY */
surface
CRDecal (float  Ka            = 1.0,
                Kd            = 0.5,
                Ks            = 0.5,
                roughness     = 0.1,
                plane         = 0,
                c0min         = -1,
                c0max         =  1,
                c1min         = -1,
                c1max         =  1;
         color  specularcolor = 1;
         string texturename   = "")
{
  point Nf, V, objP;
  color Ct;

  /* Check for valid component specs */
  if (plane != 0 && plane != 1 && plane != 2 && plane != 3 && plane != 4 && plane != 5)
    {
      printf ("bad mapping plane %f in decal()--must be 0..5", plane);
    }
  else
    {
      if (texturename != "")
        {
          objP = transform ("shader", P);
          Ct = color texture (texturename,
                              selscl (0, plane, c0min, c0max, c1min, c1max, objP),
                              selscl (1, plane, c0min, c0max, c1min, c1max, objP));
        }
      else
        Ct = 1;
      
      Nf = faceforward (normalize (N), I);
      V = -normalize (I);
      Oi = Os;
      Ci = Os * (Cs * Ct * (Ka * ambient () + Kd * diffuse (Nf)) +
                 specularcolor * Ks * specular (Nf, V, roughness));
    }
}
