// Persistence of Vision Raytracer
// Sol en parquet avec marquetterie

/******************************************************************************
   A faire:
******************************************************************************/



#ifndef (DALLE_COMMON)
   #ifndef (MAIN_POV)
      #include "common.inc"
   #end

/******************************************************************************

        textures

******************************************************************************/

#declare Dalle_T1=texture {Sol_T}

/******************************************************************************

        objets communs

******************************************************************************/

#declare Dalle_Eps1=0.25
#declare Dalle_Eps2=Dalle_Eps1*sqrt(2)

#declare Dalle_Prism=prism{
   linear_sweep
   linear_spline
   -1, 0,
   5,
   <15-Dalle_Eps1, 15-Dalle_Eps2>,
   <15-Dalle_Eps1, -15+Dalle_Eps2>,
   <10+Dalle_Eps1, -10+Dalle_Eps1>,
   <10+Dalle_Eps1, 10-Dalle_Eps1>,
   <15-Dalle_Eps1, 15-Dalle_Eps2>
   }

#declare Dalle_ii=0
#declare Dalle_Seed=seed(40)
#declare DALLE_COMMON=1
#end

/******************************************************************************

        reconstitution

******************************************************************************/

union {
   object {
      Dalle_Prism
      texture {
         Dalle_T1 translate <rand(Dalle_Seed)*100, rand(Dalle_Seed)*100, rand(Dalle_Seed)*100> scale 10
         }
      }
   object {
      Dalle_Prism
      texture {
         Dalle_T1 translate <rand(Dalle_Seed)*100, rand(Dalle_Seed)*100, rand(Dalle_Seed)*100> scale 10
         }
      rotate 90*y
      }
   object {
      Dalle_Prism
      texture {
         Dalle_T1 translate <rand(Dalle_Seed)*100, rand(Dalle_Seed)*100, rand(Dalle_Seed)*100> scale 10
         }
      rotate 180*y
      }
   object {
      Dalle_Prism
      texture {
         Dalle_T1 translate <rand(Dalle_Seed)*100, rand(Dalle_Seed)*100, rand(Dalle_Seed)*100> scale 10
         }
      rotate 270*y
      }
   object {
      box {<-10+Dalle_Eps1, -1, -10+Dalle_Eps1>, <10-Dalle_Eps1, 0, 10-Dalle_Eps1>}
      texture {
         Dalle_T1 translate <rand(Dalle_Seed)*100, rand(Dalle_Seed)*100, rand(Dalle_Seed)*100> scale 10
         rotate (45+90*Dalle_ii)*y
         }
      rotate 270*y
      }
   }

#declare Dalle_ii = Dalle_ii+1
