// Persistence of Vision Raytracer
// Theme "A & D" 07-08/97
// Sizes in cm
// Proportions pour cadrage classique 800x600

global_settings {
   max_trace_level 6
   adc_bailout 1/255
   assumed_gamma 1.9
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"

//#include "cadre.inc"
#include "sol.inc"
#include "metro.inc"

#render "Includes ok.\n"

//#declare WideLight = 1

#declare Vue_1= camera {
   perspective
   location  <100, 100, 1000>/3
   up        y
   right     -4/3 * x
   look_at   <-5, -8, 0>
   angle 30 //Attention: angle  la base et non sur la diagonale!
}

#declare Lampes=union{
   object {
      light_source {
         <-100, 500, 600>
         color White*1
         spotlight
         point_at <-100, 0, 0>
         radius 20//10
         falloff 30//15
         }
      }
   object {
      light_source {
         <100, 500, 600>
         color White*.6
         spotlight
         point_at <100, 0, 0>
         radius 20//10
         falloff 30//15
         }
      }
   }

#declare Lampes_E=union{
   object {
      light_source {
         <-100, 500, 600>
         color White
         spotlight
         point_at <-100, 0, 0>
         radius 10
         falloff 15
         area_light
         <30, 0, 0> <0, 30, 0> // lights spread out across this distance (x * y)
         4, 4
         adaptive 0 jitter
         }
      }
   object {
      light_source {
         <100, 500, 600>
         color White*.8
         spotlight
         point_at <100, 0, 0>
         radius 10
         falloff 15
         area_light
         <30, 0, 0> <0, 30, 0> // lights spread out across this distance (x * y)
         4, 4
         adaptive 0 jitter
         }
      }
   }

/******************************************************************************

        Scne complte

******************************************************************************/

#declare Sub_Scene1=union{
   object {Sol translate <0, 0, 0>}
   object {Metro}
   
#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
   }

#declare Scene1=union{
//   object {
//      Cadre scale <8, 6, .01> no_shadow
//      rotate 1.1*z
//      rotate 7*y
//      translate <100-1, 100-1.5, 1000>/3.145
//      }
   object {Sub_Scene1 rotate -30*y rotate 10*x translate <0, -20, 0> translate -50*z}
   }


camera {Vue_1}
object {Scene1 rotate 0*y}

