// Aeroplane.inc

// object aeroplane
// <0,0,0> is center of wing
// extends in z-dir, tail in -z

#declare wingpart =
union
{
	intersection {
		box { <-100,-10,0> <100,10,-100> rotate x*-5 }
		box { <-101,-10,0> <101,10,-100> rotate x*5  }
		translate z*50
	}
	cylinder { x*-100 x*100 10 translate z*50 }
}

#declare wing =
union
{
	object { wingpart scale <3.5,1,1> }
	object { wingpart scale <.25,1,1> translate x*-375 pigment { Red } }
	object { wingpart scale <.25,1,1> translate x*375  pigment { Red } }
}

#declare wingwrinkle =
union
{
	sphere { 0 10 }
	cone { 0 10 z*-100 0 }
	scale <.7,1.3,1.05>
	translate z*52.5
}

#declare tail_fin =
union {
	#declare TAIL_FIN_ANGLE = 10
	object
	{
		wingpart
		scale <.7,.4,.6>
		translate x*60
		rotate z*90
		rotate x*-TAIL_FIN_ANGLE
	}

	#declare c = 1
	#while (c < 4)
		object
		{
			wingwrinkle
			scale <.6.5,.6>
			rotate z*90
			translate y*c*30
			rotate x*-TAIL_FIN_ANGLE
		}
	#declare c = c + 1
	#end

	// positionlight
	sphere { 0 5 scale <.5,1,1> translate <0,133,30> rotate x*-TAIL_FIN_ANGLE pigment { Red } finish { ambient .7 } }
	sphere { 0 15 translate <0,133,30> rotate x*-TAIL_FIN_ANGLE pigment { color rgbft <1,.4,.4,1,.25> } }
	sphere { 0 25 translate <0,133,30> rotate x*-TAIL_FIN_ANGLE pigment { color rgbft <1,.6,.6,1,.20> } }
	sphere { 0 40 translate <0,133,30> rotate x*-TAIL_FIN_ANGLE pigment { color rgbft <1,.7,.7,1,.15> } }

	object
	{
		wingpart
		scale <.1,.40001,.6>
 		translate x*115
		rotate z*90
		rotate x*-TAIL_FIN_ANGLE
		pigment { Red }
	}
}

#declare mid_body =
difference
{
	cylinder { z*50 z*-100 50 }
	cylinder { z*51 z*-101 46 pigment { Gray90 } }
}

#declare front_windshield =
intersection
{
	sphere { 0 50.000001 scale <1,1,2> translate z*50 }
	box { <-100,10,70> <100,100,200> }
}

#declare side_windows =
union
{
	intersection
	{
		object { mid_body }
		cylinder { <-100,20,-30> <100,20,-30> 12 }
	}
	intersection
	{
		object { mid_body }
		cylinder { <-100,20,-80> <100,20,-80> 12 }
	}
}

#declare mid_section =
//union
//{
	difference
	{
		object { mid_body }
		cylinder { <-100,20,-30> <100,20,-30> 12 }
		cylinder { <-100,20,-70> <100,20,-70> 12 }
	}

// won't show in final render anyway
//		object { side_windows pigment { color <.9,.8,.6> filter 1 } finish { specular .4 } }
//}

#declare left_door =
intersection
{
	object { mid_section }
	box { <0,-20,-10> <-100,40,-50> }
}

#declare right_door =
intersection
{
	object { mid_section }
	box { <0,-20,-50> <-100,40,-90> }
}

#declare mid_section =
difference
{
	object { mid_section }
	box { <-100,40,-90> <0,-20,-10> }
}


#declare fuselage =
difference
{
	union
	{
		cone { z*230 20 <0,15,50> 50 translate y*-15 }
		sphere { 0 50 scale <1,1,.2> rotate x*5 translate z*50 }
		sphere { z*-100 50 clipped_by { plane { z,-85 } } }
		cone { z*-100 50 <0,40,-450> 10 }
		sphere { <0,40,-455> 10 }
		box { <-20,-30,50> <20,-47,220> }  // air intake
	}
	object { front_windshield scale 1.00001 }
	sphere { 0 46 scale <1,1,2> translate z*50 }
}

#declare aeroplane =
union
{
	// wing
	object { wing translate y*50 }
	#declare c = 0
	#while (c <= 10)
		object { wingwrinkle translate <350-c*70,50,0> }
		#if (mod(c,2)=0)
			object { wingwrinkle scale <.25,.5,.5> translate <70-c*14,50,-445> }	// tail wing
		#end
		#declare c = c + 1
	#end
	object { wingpart scale <.1,.2,.2> rotate z*90 translate <-60,65,0> }

	// nosecone + propeller
	cone { z*300 0 z*230 20 translate y*-15 pigment { Red } }
	sphere { 0 90 scale <1,1,.1> translate <0,-15,255> pigment { White filter .8 } }
	sphere { 0 90 scale <.1,1,.1> rotate z*60 translate <0,-15,255> pigment { White filter .75 } }
	sphere { 0 90 scale <.1,1,.1> rotate z*100 translate <0,-15,255> pigment { White filter .85 } }
	sphere { 0 90 scale <.1,1,.1> rotate z*140 translate <0,-15,255> pigment { White filter .875 } }

	// fuselage
	union
	{
		object { fuselage }
		object { mid_section }
		object { left_door translate <50,20,10> rotate y*10 translate <-50,-20,-10> }
		object { right_door translate <50,20,90> rotate y*-150 translate <-50,-20,-90> }

		pigment { image_map { tga "stripe2.tga" map_type 0 } rotate x*4 translate y*-.45 scale 100 }
		finish { phong .5 ambient .3 }
	}

	// nose section
	intersection
	{
		object { fuselage }
		box { <-50,5,130> <50,100,220> }
		pigment { Black }
		finish { specular .3 }
		scale 1.00001
	}
	object { front_windshield pigment { color <.9,.8,.6> filter 1 } finish { specular .4 } }

	// wing supports
	cylinder { 0 <-600,90,0> 10 scale <.2,.5,1> translate x*-50 }
	cylinder { 0 < 600,90,0> 10 scale <.2,.5,1> translate x*50  }

	// landing gear
	cylinder { 0 <-300,-100,0> 10 scale <.2,1,1> translate x*-50 }
	cylinder { 0 <-550,-50,0> 10 scale <.2,1,1> translate <0,-50,0> }
	torus { 15 10 rotate z*90 translate <-115,-100,0> pigment { Black } }		// tire
	cylinder { x*-7 x*7 14 translate <-115,-100,0> texture { T_Chrome_4A } }	// rim
	cylinder { 0 <300,-100,0> 10 scale <.2,1,1> translate x*50 }
	cylinder { 0 <550,-50,0> 10 scale <.2,1,1> translate <0,-50,0> }
	torus { 15 10 rotate z*90 translate <115,-100,0> pigment { Black } }		// tire
	cylinder { x*-7 x*7 14 translate <115,-100,0> texture { T_Chrome_4A } }		// rim

	// tail
	object { wing scale <.25,.5,.55> translate <0,45,-445> }
	object { tail_fin translate <0,50,-445> }
	cylinder { <-4,30,-420> <-4,10,-440> 4}
	torus { 7 5 rotate z*90 translate <0,10,-440> pigment { Black } }

	pigment { White }
	finish { phong .5 reflection .02 ambient .3 }
}
