// * ************************************** *
// * *                                    * *
// * *            GOLDEN EYE              * *
// * *                                    * *
// * *    scene made by Robert Fremin     * *
// * * for the 1997 sep/oct IRTC contest  * *
// * *                                    * *
// * *    compile using PovRay v.3.02     * *
// * *                                    * *
// * ************************************** *

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "STONES.INC"

#declare final	= 1
#declare blur	= 1
#declare jagged	= 1

#declare cam_pos = <-250, 100, 120>

#include "aeroplan.inc"
#include "motorcyc.inc"

global_settings { max_trace_level 30 }

camera
{
	location cam_pos look_at <-100, 0, 500>

#if (blur)
	focal_point <300,-900,2300>  //<0,0,0>
	aperture 2
	blur_samples 20
#end
}

light_source { <-5000, 5000, -200> color <1,1,.9> }
light_source { <-2000, 1000, -100> color Gray30 shadowless }

sky_sphere
{
	#if (final)
		pigment { image_map { tga "mountains.tga" map_type 0 once interpolate 2 } translate <-.4,-.9,0> scale <1.5,3,1.5> }
	#else
		pigment { SkyBlue }
	#end
}

// the concrete platform
#declare platform =
difference
{
	box { <-500,-1000,-200> <500,0,250> }
	#if (jagged)
		#declare c = 0
		#declare Rx = seed(1234)
		#declare Rr = seed(4321)
		#while (c < 100)
			sphere { 0 rand(Rr) scale <1,1,2> translate <c*6*rand(Rx)-300, 0, 250> }
			#declare c = c + 1
		#end
	#end
	pigment { granite color_map { [0 color <0,.4,0>][.05 Gray30][.5 Gray70] } }
	finish { specular .1 }
}

// definitions of body angles
#declare HipAngle	=	<  5,  0,  0>					// +x is forward
#declare NeckAngle	=	<  0,  0,  0>	+ HipAngle		// +x is forward
#declare LArmAngle	=	< -5+30,  0, -5-30>	+ HipAngle 		// -x is forward, -z is outwards
#declare LArmBend	=	<-10,  0,  0>	+ LArmAngle
#declare LHandAngle	=	<  0,180, 10>					// -x is upwards
#declare LGRIP		=	.1
#declare RArmAngle	=	< -5+30,  0,  5+30>	+ HipAngle		// -x is forwards, +z is outwards
#declare RArmBend	=	<-10+5,  0,  0>	+ RArmAngle
#declare RHandAngle	=	<  0, 50,-10>
#declare RGRIP		=	.1
#declare LLegAngle	=	<-10+20,  0, -5-20>					// -x is forward, -z is outwards
#declare LLegBend	=	< 20,	  0,  0+10>	+ LLegAngle
#declare LFootAngle	=	< -5+30,  0,  0>	+ LLegBend		// -x is upwards
#declare RLegAngle	=	<-10+20,  0,  5+20>					// -x is forward, +z is outwards
#declare RLegBend	=	< 20+20,  0,  0-10>	+ RLegAngle
#declare RFootAngle	=	< -5+30,  0,  0>	+ RLegBend		// -x is upwards

// Man seen from back (nose into +z)
// body dimensions
#declare Hip		=	<0, 93+5.5, 5>
#declare DNeck		=	vrotate(y*55, HipAngle) + Hip
#declare UNeck		=	vrotate(y*10, HipAngle+NeckAngle) + DNeck
#declare LShoulder	=	vrotate(<-18,-5,2>, <0,0,0>) + DNeck
#declare RShoulder	=	vrotate(< 18,-5,2>, <0,0,0>) + DNeck
#declare LElbow		=	vrotate(y*-30, LArmAngle) + LShoulder
#declare RElbow		=	vrotate(y*-30, RArmAngle) + RShoulder
#declare LForearm	=	vrotate(y*-30, LArmBend) + LElbow
#declare RForearm	=	vrotate(y*-30, RArmBend) + RElbow
#declare LHip		=	<-7,1,-2> + Hip
#declare RHip		=	< 7,1,-2> + Hip
#declare LKnee		=	vrotate(y*-47, LLegAngle) + LHip
#declare RKnee		=	vrotate(y*-47, RLegAngle) + RHip
#declare LHeel		=	vrotate(y*-46, LLegBend) + LKnee
#declare RHeel		=	vrotate(y*-46, RLegBend) + RKnee

#declare JamesBond =
union
{
	// head & neck
	sphere { 0 9 scale <1,1.3,1> translate UNeck+y*8 pigment { color <1,.63,.47> } }
	sphere { 0 9 scale <1,1.3,1> translate UNeck+y*10+z*-2
			 pigment { color <.1,.1,.1> } normal { bumps scale <1,1,2> turbulence .5} finish { specular .2 } }  // hair
	cone { UNeck 6 DNeck 6 pigment { color <1,.63,.47> } }
	cone { DNeck 6 LShoulder 6 }
	cone { DNeck 6 RShoulder 6 }

	// torso
	sphere { 0 8 scale <2.5,.5,1> translate DNeck }
	cone { DNeck 8 Hip 9 scale <2.5,1,1> }
	cone { DNeck-z*2 7 Hip-z*6 8 scale <2.5,1,1> } //
	cone { DNeck-z*5 6 Hip-z*12 7 scale <2.5,1,1> } //
	cone { Hip 5 LHip 7 }
	cone { Hip 5 RHip 7 }

	// left arm
	sphere { LShoulder 7 }
	cone { LShoulder 7 LElbow 6 }
	cone { LShoulder-z*3 6 LElbow-z*3 5 } //
	sphere { LElbow 6 }
	cone { LElbow 6 LForearm 5 }
	cone { LElbow-z*3 5 LForearm-z*3 4 } //
	superellipsoid { .3 scale <4,4,3> rotate LHandAngle translate y*-3 translate LForearm pigment { color <1,.63,.47> } }

	// right arm
	sphere { RShoulder 7 }
	cone { RShoulder 7 RElbow 6 }
	cone { RShoulder-z*3 6 RElbow-z*3 5 } //
	sphere { RElbow 6 }
	cone { RElbow 6 RForearm 5 }
	cone { RElbow-z*3 5 RForearm-z*3 4 } //
	superellipsoid { .3 scale <4,4,3> rotate RHandAngle translate y*-3 translate RForearm pigment { color <1,.63,.47> } }

	// left leg
	sphere { LHip 9 }
	sphere { LHip-z*5 9 } //
	cone { LHip 9 LKnee 8 }
	cone { LHip-z*3 9 LKnee-z*5 5 } //
	sphere { LKnee 8 }
	cone { LKnee 8 LHeel 8 }
	cone { LKnee-z*3 5 LHeel-z*2+y*8 6 } //
	superellipsoid { <.2,.5> translate z*.5 scale <5,3,15> rotate LFootAngle translate LHeel }

	// right leg
	sphere { RHip 9 }
	sphere { RHip-z*5 9 } //
	cone { RHip 9 RKnee 8 }
	cone { RHip-z*3 9 RKnee-z*5 5 } //
	sphere { RKnee 8 }
	cone { RKnee 8 RHeel 8 }
	cone { RKnee-z*3 5 RHeel-z*2+y*8 6 } //
	superellipsoid { <.2,.5> translate z*.5 scale <5,3,15> rotate RFootAngle translate RHeel }

	pigment { color <.1,.1,.1> }
	finish { specular .2 ambient 0 }
	normal { bumps scale <2,4,2> }
	scale 1.3
}

#declare snow =
blob
{
	threshold .3
	#declare c = 0
	#declare Rx = seed(6584)
	#declare Rz = seed(76435)
	#declare Rr = seed(31459876)
	#while (c < 100)
		sphere { 0 10+5*rand(Rr) 1 scale <1,.1+.3*rand(Rr),1> translate <70*rand(Rx),0,50*rand(Rz)> }
		#declare c = c + 1
	#end
	pigment { White }
	normal { granite normal_map { [0 bumps scale 2][1 dents] } scale 10 }
	finish { ambient .3 }
}

// final
object { aeroplane rotate <30,-20,-10> translate <100+200,-900,2500+200> }
object { JamesBond rotate <88,0,0+10> translate <200+200,-450,1100+150> }
object { motorcycle rotate y*90 rotate <40,-10,-15> translate <200+200,39-500,900+200> }
object { platform }
object { snow translate <-270,0,200> }
