// Motorcycle.inc
#include "metals.inc"

// object motorcycle
// rear wheel center at <0,0,0>
// extends into -x
// ground level at y*-39

#declare motorcycle =
union
{
	#declare mc_lights = 0	// light switch

	// back wheel
	torus { 33 6 rotate x*90 pigment { Black } }
	sphere { 0 30 scale <1,1,.2> pigment { White filter .7 } }
	cylinder { z*-8 z*10 9 }

	// front wheel
	torus { 33 6 rotate x*90 translate x*-150 pigment { Black } }
	sphere { 0 30 scale <1,1,.2> translate x*-150 pigment { White filter .7 } }
	cylinder { z*-10 z*10 5 translate x*-150 }

	// fork
	#declare crown = vrotate(y*60,z*-20) + x*-150
	cylinder { 0 y*60 4 rotate z*-20 translate <-150,0,-10> }
	cylinder { 0 y*60 4 rotate z*-20 translate <-150,0, 10> }
	cylinder { <0,0,-14> <0,0,14> 4 translate crown }

	// frame
	cylinder { crown <-80,-10,-20> 3 }
	cylinder { crown <-80,-10, 20> 3 }
	cylinder { <-80,-10,-20> <-80,-10,20> 3 }
	cylinder { <-80,-10,-20> z*-10 3 }
	cylinder { <-80,-10, 20> z*10  3 }
	cylinder { crown-y*10 <-50,45,-8> 3 }
	cylinder { crown-y*10 <-50,45, 8> 3 }
	cylinder { <-50,45,-8> z*-10 3 }
	cylinder { <-50,45, 8> z*10 3 }
	cylinder { <-35,30,-9> <-50,-7,-16> 2 }
	sphere { crown+x*10-y*10 10 }	// fill
	sphere { <-55,35,0> 15 }		// fill
	sphere { <-30,37,0> 8 }			// fill

	// tank
	sphere { 0 1.1 scale <25,15,18> translate <-90,42,0> }
	sphere { 0 6 scale <1,.3,1> translate <-95,58.6,0> texture { T_Chrome_3C } }

	// engine
	union {
		superellipsoid { .5 scale <30,15,10> translate <-70,5,0> }
		superellipsoid { .5 scale <18,15,8> translate <-85,15,0> }
		cylinder { z*-20 z*20 10 translate <-75,5,0> }
		cylinder { z*-17 z*17 5 translate <-55,8,0> }
		cylinder { z*-27 z*27 3 translate <-55,3,0> pigment { Black } }
		cylinder { <-60,0,8> <10,0,15> 5 }	// tailpipe
		cylinder { <10,0,15> <12,0,15> 2 pigment { Black } }	// tailpipe
		cylinder { z*-10 z*-8 10 }	// cog
		cylinder { <-60, 4,-7> <0, 9.5,-9> 1 }	// chain
		cylinder { <-60,-4,-7> <0,-9.5,-9> 1 }	// chain
		texture { T_Chrome_3C }
		normal { dents }
	}

	// steer
	cylinder { z*-40 z*40 2 translate crown+y*5 }
	cylinder { 0 z*-10 3 rotate y*-30 translate crown-z*40+y*5 pigment { Black } }
	cylinder { 0 z*10 3 rotate y*30 translate crown+z*40+y*5 pigment { Black } }
	cylinder { 0 y*8 7 rotate z*-20 translate crown+x*10-z*10 texture { T_Chrome_3C } }
	cylinder { 0 y*8 7 rotate z*-20 translate crown+x*10+z*10 texture { T_Chrome_3C } }

	// saddle
	sphere { 0 10 scale <3,1,1.5> translate <-35,50,0> pigment { color <.4,.3,.2> } normal { bumps } }

	// tail light
	sphere { <25,43,0> 3 pigment { Red } #if (mc_lights) finish { ambient 1} #end }

	// headlight
	union {
		difference { sphere { 0 10 } sphere { x*-5 10 texture { T_Chrome_3C } } }
		intersection { sphere { 0 10 } sphere { x*-5 10 texture { T_Chrome_3C } } pigment { White filter .7 } }
		#if (mc_lights)
			light_source { 0 White spotlight point_at -x radius 30 falloff 28 tightness 100 fade_distance 10000 fade_power 2 }
		#end
		translate crown-x*10+y*5
	}

	// back mudshield
	difference {
		cylinder { z*-8 z*8 40 }
		cylinder { z*-20 z*20 40 translate <2,-3,0> }
		translate y*8
	}

	// front mudshield
	difference {
		cylinder { z*-8 z*8 40 }
		cylinder { z*-20 z*20 40 translate <-2,-3,0> }
		translate x*-150+y*10
	}

	// number plate
	union {
		box { <-.5,-5,-10> <.5,5,10> pigment { White } }
		text { ttf "crystal.ttf" "242" .1 0 scale 10 translate <-7,-3,-1> rotate y*-90 pigment { Blue } }
		rotate z*60
		translate <15,48,0>
	}

	pigment { color <.2,.3,.1> }
	finish { specular .05 metallic }
}
