// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una reflexion sobre el futuro del arte.
//--
// This file contains:
//  A thought about art's future.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


global_settings {
    assumed_gamma 2.4
    max_trace_level 20
    ambient_light .1
}

#include "colors.inc"
#include "stones.inc"
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"


#declare Pic_A_X = .6
#declare Pic_A_Y = Pic_A_X * (925 / 775)
#declare Pic_A_png = "lan037.png"
#declare F_Pic_A =
    finish {
        ambient .3
        diffuse .5
    }
#declare N_Pic_A =
    normal {
        bumps .1
        scale .005
    }
#declare Pic_A_B = .8
#include "easel.inc"
object {
    Easel_A
    rotate -10 * y
    translate <0, 0, -2.5>
    rotate 20 * y
}


#declare Sculpture =
    difference {
        union {
            sphere { <0, 0, 0>, .5 }
            cone { <0, .4, .1>, .35, <-.2, .8, -.05>, .45 }
            cone { <-.1, .65, 0>, .4, <.05, 1.5, -.1>, .5 }
            cone { <-.05, 1.4, -.05>, .45, <-.1, 1.95, .15>, .3 }
            sphere { <.1, 2, .1>, .2 }
        }
        #declare Holes = 10
        #declare HolesSeed = seed (408)
        #while (Holes > 0)
            cylinder {
                <-2, 0, 0>, <2, 0, 0>, .1
                rotate (20 * rand (HolesSeed) - 10) * z
                rotate 180 * rand (HolesSeed) * y
//                rotate 360 * <rand (HolesSeed), rand (HolesSeed), rand (HolesSeed)>
                translate Holes * y * 1.8 / 10
            }
            #declare Holes = Holes - 1
        #end
        #declare Holes = 10
        #while (Holes > 0)
            box {
                <-2, -.09, -.09>, <2, .09, .09>
                rotate 90 * rand  (HolesSeed) * x
                rotate (20 * rand (HolesSeed) - 10) * z
                rotate 180 * rand (HolesSeed) * y
//                rotate 360 * <rand (HolesSeed), rand (HolesSeed), rand (HolesSeed)>
                translate Holes * y * 1.8 / 10
            }
            #declare Holes = Holes - 1
        #end
        #declare Holes = 10
        #while (Holes > 0)
            cylinder {
                <-2, 0, 0>, <2, 0, 0>, .05
                rotate (20 * rand (HolesSeed) - 10) * z
                rotate 180 * rand (HolesSeed) * y
                translate Holes * y * 1.8 / 10
            }
            #declare Holes = Holes - 1
        #end
        texture { T_Stone23 scale .25 }
        rotate y * -45
    }

object {
    Sculpture
    translate <1, .2, -1>
}


#declare Lock =
    superellipsoid {
        <.2, .2>
        scale .5 * <.02, .005, .03>
        translate <0, .0025, -.015>
        texture { T_Chrome_4D  }
    }

#declare T_PaintBox =
    texture { T_Wood7 scale .05 }
#declare PaintBox =
    union {
        box {
            <-.205, -.155, .045>, <.205, .155, .05>
            texture {
                T_PaintBox
                rotate 90 * y
                translate <0, 0, .05>
            }
        }
        box {
            <-.205, -.155, -.045>, <.205, .155, -.05>
            texture {
                T_PaintBox
                rotate 90 * y
                translate <0, 0, -.045>
            }
        }
        box { // Side (locks)
            <-.2, .14, -.045>, <.2, .15, .045>
            texture {
                T_PaintBox
                rotate -90 * y
                translate <0, .15, 0>
            }
        }
        box { // Side (rest place)
            <-.2, -.15, -.045>, <.2, -.14, .045>
            texture {
                T_PaintBox
                rotate -90 * y
                translate <0, -.14, 0>
            }
        }
        box { // Side
            <-.2, -.14, -.045>, <-.19, .14, .045>
            texture {
                T_PaintBox
                rotate <0, -90, 90>
                translate <-.2, 0, 0>
            }
        }
        box { // Side
            <.19, -.14, -.045>, <.2, .14, .045>
            texture {
                T_PaintBox
                rotate <0, -90, 90>
                translate <.19, 0, 0>
            }
        }
        torus { // Handle
            .075, .005
            scale <1, 2, .4>
            rotate 90 * x
            translate <0, .15, 0>
            texture {
                pigment { BakersChoc }
                finish { phong.25    phong_size 5 }
            }
        }
        object { Lock translate <-.11, .15, .045> }
        object { Lock translate <.11, .15, .045> }
        translate <0, .155, 0>
    }

object {
    PaintBox
    translate <0, 0, -2.75>
    rotate 20 * y
}


background { Gray20 }

camera {
    up <0, 1, 0>
    right <16/9, 0, 0>
    location <1, 1.7, -6>
    look_at <0, 1, 0>
//    angle 80
    angle 70
//    rotate -y*70
}

// Sun
light_source {
    100 * <-40, 20, 7> rgb <.9, .9, 1> * 1.1
}

// Fake reflection
light_source {
    2 * <-40, -20, 7> rgb <.9, .9, 1> * .5
    shadowless
}

// Tube
light_source {
    <0, 2, 0> Gray60
    shadowless
}

// Fill light, softens colors
light_source {
    <0, 1000, 0> Gray20
    shadowless
}

// Cornerlight
#declare Roomlight =
    union {
        union {
            cone { <0, 0, 0>, .2, <0, .1, 0>, 0 }
            cylinder { <0, 0, 0>, <0, 1.2, 0>, .01 }
            cone { <0, 1.1, 0>, 0, <0, 1.2, 0>, .1 }
            texture {
                T_Gold_3C
                normal { bumps .2 scale .001 }
            }
        }
        light_source {
            <0, 1.3, 0> rgb <1, 1, .9> * .5
            fade_power 2
            fade_distance 6
        }
        sphere {
            <0, 1.3, 0>, .15
            texture {
                pigment { White }
                finish { ambient .9 * 10 diffuse 0 }
            }
            no_shadow
        }
    }

object {
    Roomlight
    translate <2.5, 0, 2.5>
}

object {
    Roomlight
    translate <-2.5, 0, 2.5>
}

object {
    Roomlight
    translate <-.5, 0, -6.5>
}

object {
    Roomlight
    translate <.5, 0, -6.5>
}


// Global
#declare DoorHeight = 2
#declare WallHeight = 2.8
#declare BaseHeight = .1 // Baseboard, skirting board
#declare WindowBase = .5
#declare WindowHeight = 1.5
#declare F_Floor =
    finish { specular 1    roughness .001    reflection .15 }
#declare T_Wall =
    texture {
        pigment { Gray95 }
        finish { brilliance 1.5 }
        normal {
            bumps .2
            scale .01
        }
    }
#declare TwoLayer =
    texture { pigment { Gray20 } }
    texture {
        T_Grnt19a
        finish { F_Floor }
    }
#declare T_Baseboard =
    texture {
        checker
        texture { TwoLayer    scale .3 },
        texture { TwoLayer    scale .3    translate 100 }
        scale .4
    }
#declare T_Door =
    texture {
        pigment { Gray40 }
        finish { Dull }
        normal { granite .01    scale .001 }
    }
#declare N_Both =
    normal {
        bump_map {
            gif "tilebump.gif"
            bump_size 1
        }
        rotate 90 * x
    }
#declare T_Floor =
    texture {
        checker
        texture {
            T_Stone17
            normal { N_Both }
            finish { F_Floor }
        },
        texture {
            T_Grnt15
            normal { N_Both }
            finish { F_Floor }
        }
        scale 1/3
    }
#declare T_WindowGlass =
    texture { // pigment { Clear }
        T_Glass4
        normal {
            bump_map {
                gif "tilebump.gif"
                bump_size 1
            }
            scale .5
        }
        finish { caustics 1 }
    }
#declare T_WindowFrame =
    texture {
        pigment { Wheat }
        finish {
            specular 1
            roughness .001
            reflection .2
        }
    }

#include "room.inc"
object { Walls }
object { Baseboard }
object { Door }
object { Floor }
object { Ceiling }
object { ThreeWindows }

object {
    Door
    translate <-2, 0, -9.05>
    scale <-1, 1, 1>
    rotate 90 * y
    translate <3.05, 0, 0>
}


#declare T_Grass =
    texture {
        pigment {
            marble
            turbulence 1
            color_map {
                [ 0 color ForestGreen ]
                [ .7 color rgb <.15 , .4, .15> ]
                [ .9 color MediumForestGreen ]
                [ 1 color ForestGreen ]
            }
            scale .3
        }
        normal {
            bumps 1
            scale .01
        }
    }

// Ground (grass)
plane {
    y, -.5
    texture { T_Grass }
}


/*
// Halos for "atmosphere"
box {
    -1, 1
    hollow
    texture {
        pigment { rgbf <1, 1, 1, 1> }
        halo {
            dust    dust_type 4
            box_mapping    constant
            color_map {
                [ 0 rgbt <1, 1, 1, 1> ]
                [ 1 rgbt <1, 1, 1, .9> ]
            }
            samples 10    jitter .1
//            aa_level 3    aa_threshold .2
        }
    }
    scale .5*1.1
    translate .5
    scale <2, WallHeight, 6>
    translate <1, 0, 3>
}

box {
    -1, 1
    hollow
    texture {
        pigment { rgbf <1, 1, 1, 1> }
        halo {
            dust    dust_type 4
            box_mapping    constant
            color_map {
                [ 0 rgbt <1, 1, 1, 1> ]
                [ 1 rgbt <1, 1, 1, .95> ]
            }
            samples 30    jitter .1
//            aa_level 3    aa_threshold .2
        }
    }
    scale .5*1.1
    translate .5
    scale <6, WallHeight, 10>
    translate <-3, 0, -7>
}
*/


// Environment
#include "skies.inc"
plane {
    y, 1000
    texture { T_Cloud3 scale 1000 }
    translate -40*z
    hollow
}

sky_sphere { S_Cloud2 }

fog {
    fog_type 2
    distance 2000
    fog_offset -.5
    fog_alt 60
    color SkyBlue transmit .5
    turbulence 1
    turb_depth .5
}


// Garden
#declare Hedge =
    union {
        box { // Outter
            <-2.5, -.5, -.5>, <2.5, 1, .5>
            texture {
                pigment {
                    spotted
                    color_map {
                        [ 0 color Clear ]
                        [ .68 color Clear ]
                        [ .7 color DarkGreen filter 1 ]
                        [ .82 color DarkGreen filter .5 ]
                        [ .92 color ForestGreen ]
                    }
                    turbulence .2
                    scale .05 // .2 .3
                }
                normal {
                    bumps 3
                    scale .01
                }
            }
        }
        box { // Inner
            <-2.45, -.5, -.45>, <2.45, .95, .45>
            texture {
                pigment {
                    marble
                    turbulence 1
                    color_map {
                        [ 0 color ForestGreen ]
                        [ .7 color rgb <.15 , .4, .15> ]
                        [ .9 color DarkWood ]
                        [ 1 color DarkWood ]
                    }
                    scale .3
                }
                normal {
                    bumps 3
                    scale .01
                }
            }
        }
    }

object {
    Hedge
    translate <-2.5, 0, 9.5>
}

object {
    Hedge
    rotate 90 * y
    translate <-9.5, 0, 0>
}

object {
    Hedge
    rotate 90 * y
    translate <-9.5, 0, 5>
}


// Mountains
height_field {
    gif "mountain.gif"
    translate <-.5, 0, -.5>
    scale <1000, 50, 1000>
    translate <-900, -.5, 1000>
    texture {
        gradient y
        scale 55
        turbulence .1
        texture_map {
            [ 0 T_Grass ]
            [ .5 pigment { Brown } ]
        }
    }
}

height_field {
    gif "mountain.gif"
    translate <-.5, 0, -.5>
    scale <-200, 10, -200>
    translate <-225, -.5, 250>
    texture {
        gradient y
        scale 11
        turbulence .1
        texture_map {
            [ 0 T_Grass ]
            [ .5 pigment { Brown } ]
        }
    }
}


// Logo
height_field {
    gif "by-gsr.gif"
    water_level .001
    texture {
        pigment {
            bozo // gradient z+x
            color_map {
                [ 0 color rgb <.25, 1, 1> ]
                [ 1 color rgb <.1, .1, 1> ]
            }
            sine_wave
            scale .25
        }
        finish {
            ambient .2
            diffuse .4
        }
    }
    texture {
        pigment {
            crackle
            color_map {
                [ .05 Black ]
                [ .05 Clear ]
            }
            scale .2
            translate <.5, 0, .5> // To fix big black spots
        }
        finish {
            ambient .1
            diffuse .5
        }
    }
    translate <-.5, 0, -.5>
    scale .4
    rotate -90 * x    rotate 90 * z
    rotate 90 * y
    translate <2.99, 1.25, -1.6>
}



// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
