
// Persistence of Vision Ray Tracer Scene Description File
// File: mikado.pov
// Vers: 3
// Desc: Entry for IRTC competition Sept/Oct 1997
// Date: October 1997
// Auth: Ian Armstrong (iarmstrong@cix.co.uk)
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

#declare PovFile = 0    // get included .pov files to act as include files

#declare Full_Scenery = 1
#declare Use_Scene = 1
//#declare Area_Lights = 1
global_settings
{
//  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 3, -8.0>
//  location  <0.0, 13, -4.0>
//  direction 2.25*z
  right     4/3*x
  look_at   <0.0, 2.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source { < 0, 3, -8 > color White spotlight point_at <0,2.75,0> radius 10 falloff 20 }
light_source { < -3, 8, -8 > color rgb <1,0.7,0.2> spotlight point_at <0,3,0> radius 10 falloff 20 }
light_source { < 3, 8, -8 > color rgb <1,0.7,0.2> spotlight point_at <0,3,0> radius 10 falloff 20 }

light_source {< 100, 300, -200> color White		// Left Side Light
#ifdef (Area_Lights)
   area_light <0, 0, 100>, <0, 100, 0>, 3, 3
   adaptive 1
   jitter
#end
}
light_source {< -50, 300, -200> color White		// Left Side Light
#ifdef (Area_Lights)
   area_light <0, 0, 100>, <0, 100, 0>, 3, 3
   adaptive 1
   jitter
#end
}

// ----------------------------------------
#declare Brick_Texture =
texture {
    pigment {
        brick Gray65, Wheat*0.7
    }
    normal { brick normal{bumps 0.2}, normal{granite 0.5} }
    finish {
        crand 0.003
        diffuse 0.6 ambient 0.20
    }
    scale <0.6, 0.6, 0.3>
    translate 1*x
}
#declare Walls =
union {
#ifdef (Full_Scenery)
//  object { plane {-z,-12.5} texture { Brick_Texture }}   // Back (main) wall
  difference {
    box { <-100,-1,12.5>,<100,50,12.6> }
    box { <-5,0,12>,<5,8,13> }
    texture { Brick_Texture }
    no_shadow
  }
#else
  object { plane {-z,-12.5} pigment { Wheat } finish { Dull }}
#end
}

#declare Floor_Texture =
    texture {T_Wood7 finish { specular 0.15 roughness 0.025 ambient 0.25 reflection 0.15}}
#declare Floor =
intersection {
  plane { y,0
    texture {
#ifdef (Full_Scenery)
      Floor_Texture
      rotate y*90
      rotate <10, 0, 15>
      translate -2*x
      scale 0.5
#else
      pigment { Red } finish { Dull }
#end
    }
  }
  plane { -z,10 }
}

fog {color White distance 155 }

#declare Blue_Sky4 =
pigment {
    granite
    turbulence 0.1
    color_map {
        [0.0, 0.3 color rgb <0.5, 0.5, 1.0>
                  color rgb <0.5, 0.5, 1.0>]
        [0.3, 1.0 color rgb <0.5, 0.5, 1.0>
                  color rgb <1.0, 1.0, 1.0>]
    }
    scale .75
}


#declare Sky =
difference {
  sphere { <0,0,0>,1}
  sphere { <0,0,0>,0.98}

  texture {
    pigment { Blue_Sky3 }
    finish {reflection 0.0 diffuse 0.0 ambient 1.0}
  }
  scale <250,50,250>
  no_shadow
}

object { Sky }

// ==== Pagoda ====
#declare Pagoda_Wood = texture { T_Wood8 }
#declare R = 0.1
#declare Roof1 =                                                  // half of one side of roof
union {
  #declare X = R
  #while(X < 6)
    cylinder { <X,2,-6>,<X,0,-10>,R }                             // middle part
    #declare X = X + 2*R
  #end
  #while(X < 10)
    #declare Y2 = pow(X-6,3)/64
    #declare Y1 = 2-2*(X-6)/4+Y2
    #declare Z1 = -X
    cylinder { <X,Y1,Z1>,<X,Y2,-10>,R }                           // end part
    sphere { <X,Y1+2*R,Z1>,2*R }                                  // ridge
    #declare X = X + 2*R
  #end
  cylinder { <6,1.5,-6>,<6,-6,-6>,0.4 texture { Pagoda_Wood } }   // wall beams
  cylinder { <2,1.5,-6>,<2,-6,-6>,0.4 texture { Pagoda_Wood } }
  cylinder { <0,-2,-6>,<6,-2,-6>,0.2 texture { Pagoda_Wood } }

  cylinder { <0,-4.5,-10>,<10,-4.5,-10>,0.1 texture { Pagoda_Wood } }    // fence
  #declare X = 0
  #while (X <= 10)
    cylinder { <X,-4.5,-10>,<X,-6,-10>,0.1 texture { Pagoda_Wood } }
    #declare X = X + 2
  #end
  pigment { CadetBlue }
}
#declare Roof2 =                                                  // top of building
union {
  #declare X = R
  #while(X < 6)
    #declare Y1 = 5-X/2 + 2*pow(6-X,2)/6/6
    cylinder { <X,2,-6>,<X,Y1,-X>,R }
    sphere { <X,Y1+2*R,-X>,2*R }
    #declare X = X + 2*R
  #end
  pigment { CadetBlue }
}
#declare RoofQ =
union {
  object { Roof1 }
  object { Roof1 scale <-1,1,1> }
}
#declare Roof =
union {
  object { RoofQ }
  object { RoofQ rotate 90*y }
  object { RoofQ rotate 180*y }
  object { RoofQ rotate 270*y }
}
#declare TopRoof =
union {
  object { Roof2 }
  object { Roof2 scale <-1,1,1> }
  object { Roof2 rotate 90*y }
  object { Roof2 scale <-1,1,1> rotate 90*y }
  object { Roof2 rotate 180*y }
  object { Roof2 scale <-1,1,1> rotate 180*y }
  object { Roof2 rotate 270*y }
  object { Roof2 scale <-1,1,1> rotate 270*y }
  translate 7*y
}
#declare Storey =
union {
  box { <-10,0,-10>,<10,1,10> pigment { Gray75 } }
  box { <-6,0,-6>,<6,7,6> pigment { Cream } }
  object { Roof translate 7*y }
}
#declare Pagoda =
union {
  object { Storey }
  object { Storey scale <0.6,0.8,0.6> translate 8.5*y }
  object { Storey scale <0.36,0.6,0.36> translate 15.5*y }
  object { TopRoof scale <0.36,0.6,0.36> translate 15.5*y }
}

// ==== Bridge ====
#declare RB1 = 0.03
#declare RB2 = 0.025
#declare BridgeQ =
union {
  cylinder { <0.0,0.75,-0.25>,<0.5,0.75,-0.25>,RB1 }      // handrail
  sphere   { <0.5,0.75,-0.25>,RB1 }                       //    "
  cone     { <0.5,0.75,-0.25>,RB1,<1.0,0.5,-0.25>,RB2 }   //    "
  sphere   { <1.0,0.50,-0.25>,RB2 }                       //    "
  cylinder { <0.5,0.75,-0.25>,<0.5,0.25,-0.25>,RB1/2 }    // upright
  cylinder { <0.2,0.75,-0.25>,<0.2,0.25,-0.25>,RB1/2 }    // upright
  cylinder { <0.0,0.25,-0.25>,<0.5,0.25,-0.25>,RB1 }      // bottom rail
  sphere   { <0.5,0.25,-0.25>,RB1 }                       //    "
  cone     { <0.5,0.25,-0.25>,RB1,<1.0,0.0,-0.25>,RB2 }   //    "
  cylinder { <0.0,0.4,-0.25>,<0.5,0.4,-0.25>,RB1/2 }      // mid-rail
  cone     { <0.5,0.4,-0.25>,RB1/2,<1.0,0.15,-0.25>,RB2/2 } //    "
  sphere   { <1.0,0.15,-0.25>,RB2/2 }                       //    "
  cylinder { <0.9,0.55,-0.25>,<0.9,0.05,-0.25>,RB1/2 }    // upright
  box { <0,0,0>,<0.5,RB1,-0.25> translate <0,0.25+RB1,0>}
  box { <-0.08,0,-0.25>,<0.08,RB1/2,0> translate <0.575,0.2125,0> }
  box { <-0.08,0,-0.25>,<0.08,RB1/2,0> translate <0.725,0.1375,0> }
  box { <-0.08,0,-0.25>,<0.08,RB1/2,0> translate <0.875,0.0625,0> }
  pigment { color rgb <1.0, 1.0, 0.8> }
  normal { bumps 0.5 scale 0.1 }
}
#declare Bridge =
union {
  object { BridgeQ }
  object { BridgeQ scale <-1,1,1> }
  object { BridgeQ scale <1,1,-1> }
  object { BridgeQ scale <-1,1,-1> }
}
// ==== Pots ====
#declare Pot1 =
union {
  difference {
    superellipsoid { <0.15,0.25> }
    superellipsoid { <0.15,0.25> scale 0.8}
    plane { -y,0 }
  }
  pigment { White }
  normal{granite 1.0 }
  bounded_by { box { <-1.01,-1.01,-1.01>,<1.01,0.01,1.01> } }
  translate 1*y
}
#declare Pot2 =
union {
  difference {
    union {
      cylinder { <0,0,0>,<0,0.1,0>,0.3 }
      cylinder { <0,0.1,0>,<0,0.5,0>,0.15 }
      torus    { 0.25, 0.1 translate <0,0.55,0> }
      cone     { <0,0.55,0>,0.35,<0,1.3,0>,0.4 }
      cylinder { <0,1.3,0>,<0,1.4,0>,0.42 }
    }
    cone     { <0,0.6,0>,0.25,<0,1.41,0>,0.35 }
  }
  pigment { White }
  normal{granite 1.0 }
}
// ==== Flags ====
#declare Flag1 =
union {
  cylinder { <0,0,0>,<0,5.2,0>,0.05 }
  cylinder { <0,4.7,0>,<0,4.75,0>,0.1 }
  sphere { <0,4.9,0>,0.1 }
  cylinder { <0,5,0>,<0,5.05,0>,0.15 }
  cylinder { <-0.5,4.5,-0.15>,<0.5,4.5,-0.15>,0.025 }
  cylinder { <-0.5,4.5,-0.15>,<0,4.9,0>,0.01 }
  cylinder { <0,4.9,0>,<0.5,4.5,-0.15>,0.01 }
  union {
  #include "flag1.inc"
    scale 1
  	texture { pigment { White } }
    texture { pigment { image_map { gif "flag.gif" once interpolate 2 filter 1,1 } scale <0.5,2,1> translate <-0.25,-1,0> } }
    translate <0,3,-0.15>
  }
  cylinder { <-0.31,1.5,-0.15>,<-0.31,1.3,-0.15>,0.015 }
  cylinder { <-0.31,1.42,-0.15>,<-0.31,1.38,-0.15>,0.025 }
  cylinder { <0.32,1.5,-0.15>,<0.32,1.3,-0.15>,0.015 }
  cylinder { <0.32,1.42,-0.15>,<0.32,1.38,-0.15>,0.025 }
	pigment { Gold }
}

// ==== Dummy Scene details ====
#declare Tree = cylinder { <0,0,0>,<0,5,0>,0.2 pigment { Green } }
#declare Maid1 = cylinder { <0,0,0>,<0,2.5,0>,0.5 pigment { Orange } }
#declare Maid2 = cylinder { <0,0,0>,<0,2.5,0>,0.5 pigment { Blue } }
#declare Maid3 = cylinder { <0,0,0>,<0,2.5,0>,0.5 pigment { Yellow } }

#declare col_8  = colour red 0.2 green 0.7 blue 0.1
#declare col_13 = colour red 0.623529 green 0.623529 blue 0.372549
#declare l_base = object { cone { <0, 0, 0>,1,<0,1.4,0>,0.85 } }
#declare t_base = finish { ambient 0.3 diffuse 0.7 phong 1 }
#declare t_leaf = finish { ambient 0.3 diffuse 0.7 }

#ifdef (Use_Scene)
// ==== Trees ====
#declare Tree = union {
  mesh {
    #include "op1.pov"
    finish{t_leaf} pigment{color col_8}
  }

  #include "op2.pov"
  finish { t_base } pigment{color col_13}
  scale 0.001
}

#include "mik1.pov"
#end

#declare Scene =
union {
  object { Bridge scale 3 rotate 45*y translate <-3,0,0> }

  object { Pot2 scale 1 rotate 35*y translate <5.6,0,1.2> }
  object { Tree scale 0.2 rotate 33*y translate <5.6,0.5,1.2> }
  object { Pot2 scale 1 rotate 35*y translate <5.6,0,-1.2> }
  object { Tree scale 0.2 rotate 121*y translate <5.6,0.5,-1.2> }

  object { Flag1 scale 1 rotate 0*y translate <4.75,0,2> }

  object { Tree rotate 223*y scale <0.9,1,0.9> translate <-5.2,0,6.75> }
  object { Tree rotate 180*y scale <0.9,1,0.9> translate <0,0,8> }
  object { Tree rotate 57*y scale <0.95,1,1> translate <5.0,0,6.75> }
  object { Tree scale 0.1 rotate 157*y translate <-2.75,-0.05,-2.5> }
  object { Tree scale 0.1 rotate 77*y translate <-5.6,-0.075,0> }
  object { Tree scale 0.2 rotate 87*y translate <1.5,-0.35,1> }
  object { Tree scale 0.1 rotate 67*y translate <-1.5,-0.075,5> }

  object { Maid1 rotate 90*y translate <-2.5,0.93,-0.5> }
  object { Maid2 rotate 0*y translate <0.5,0,-2.5>}
  object { Maid3 rotate 45*y translate <2.5,0,-2.0> }

  object { Pagoda scale 0.7 rotate 25*y translate <-6,0,45> }
}

#declare Led =            // RGB projector LEDs
union {
  box { <-0.034,0,-0.011>,<0.034,0.012,0.011> pigment { Black } }
  box { <-0.032,0,-0.01>,<-0.012,0.013,0.01> pigment { Red } finish { ambient 1 specular 1} }
  box { <-0.01,0,-0.01>,<0.01,0.013,0.01> pigment { Green } finish { ambient 1 specular 1} }
  box { <0.012,0,-0.01>,<0.032,0.013,0.01> pigment { Blue } finish { ambient 1 specular 1} }
  rotate -45*x
  translate <0,0.025,0.03>
}
#declare LedQ =           // LEDs around quarter of unit
union {
//  object { Led rotate 10*y translate <0.4,0.2,0.60> }
  object { Led rotate 45*y translate <0.75,0.2,0.48> }
  object { Led rotate 87*y translate <0.83,0.2,0.2> }
}

// ==== Base Unit ====
// #declare Base_Texture = texture { pigment { Gray50 } finish { Dull } }

#declare Base_Texture =
texture {
  pigment {
    gradient z
    pigment_map {
      [0.0 Gray75 ]
      [0.7 Gray75 ]
      [0.8 color rgbt <1,1,1,0.8> ]
      [1.0 color rgbt <0,0,0,0.8> ]
    }
  }
//  finish { Dull }
  scale <1,1,1.4> translate <0,0,-0.7>
}

#declare Ground_Pigment =
pigment {
  wrinkles
  color_map {
    [0.0 color Sand ]
    [0.4 color SpringGreen ]
    [0.8  color DarkGreen ]
    [1.0  color Brown ]
  }
}
#declare Ground_Texture =
texture {
  pigment { Ground_Pigment }
//  normal { bumps 1 }
  scale 0.1
}
#declare Pig1 =
pigment {
  gradient x
  pigment_map {
    [0.0 Blue_Sky4 color rgbt <0,0,0,1> ]
    [0.5 Blue_Sky4 color rgbt <1,1,1,1> ]
    [0.82 Blue_Sky4 ]
    [0.84 Blue_Sky4 color rgbt <1,1,1,1> ]
    [1.0 Blue_Sky4 color rgbt <0,0,0,1> ]
  }
  scale <1,0.5,1>
}
#declare Pig2 =
pigment {
  gradient x
  pigment_map {
    [0.0 Blue_Sky4 ]
//    [0.5 Blue_Sky4 ]
    [0.82 Blue_Sky4 ]
    [0.84 Blue_Sky4 color rgbt <1,1,1,1> ]
    [1.0 Blue_Sky4 color rgbt <0,0,0,1> ]
  }
  scale <1,0.5,1>
}
#declare Pig3 =
pigment {
  gradient x
  pigment_map {
    [0.0 Ground_Pigment color rgbt <0,0,0,1> scale 0.07 ]
    [0.5 Ground_Pigment color rgbt <1,1,1,1> scale 0.07 ]
    [0.82 Ground_Pigment scale 0.07 ]
    [0.84 Ground_Pigment color rgbt <1,1,1,1> scale 0.07 ]
    [1.0 Ground_Pigment color rgbt <0,0,0,1> scale 0.07 ]
  }
}

#declare Base1 =
union {
  #include "base1.inc"                                                  // SPatch patches
/*
  union {
    #include "base2.inc"                                                  // SPatch patches
    texture { pigment { color rgbt <0,0,0,0.97> } finish { Dull } }
  }
*/
  difference {
    superellipsoid { <0.15,0.25> scale <0.4,0.085,0.2> translate <0,0.12,-0.57> }
    box { <-0.25,0.1,-0.8>,<0.25,0.14,0> pigment { Black } }            // cartridge slot
    box { <0.279,0.089,-0.8>,<0.341,0.151,0> pigment { Black } }        // eject button hole
    plane { -z,0.6 }
  }
  difference {
    box { <-0.24,0.102,-0.8>,<0.24,0.138,-0.7> }                        // cartridge in use
    box { <-0.23,0.106,-0.81>,<0.23,0.134,-0.795> }
    box { <-0.2,0.1,-0.82>,<-0.19,0.2,-0.795> }
    box { <0.2,0.1,-0.82>,<0.19,0.2,-0.795> }
    texture { pigment { Cream } finish { Dull } }
    texture { pigment { image_map { gif "Mikado_c2.gif" once interpolate 2 } scale <0.46,0.4/16,1> translate <-0.23,0.106,0> } finish { ambient 0.3 } }
  }

  text {                                                                // "3D" logo
    ttf "timrom.ttf",
    "3D"
    1,0
    scale <0.11,0.11,1>
    rotate <25,5,0>
    translate <-0.625,0.15,-0.72>
    pigment { Gold }
  }

  box { <0.3,0.17,-0.77>,<0.32,0.18,-0.5> pigment { Red } finish { ambient 1 specular 1 } }      // LED
  superellipsoid { <0.15,0.15> scale <0.03,0.03,0.03> translate <0.31,0.12,-0.75> }   // eject button

//  object { Led translate <0,0.2,0.62> }           // RGB Projectors
//  object { Led scale <1,1,-1> translate <0,0.2,-0.62> }
  object { LedQ }
  object { LedQ scale <-1,1,1> }
  object { LedQ scale <1,1,-1> }
  object { LedQ scale <-1,1,-1> }

  box { <-0.5,0.15,-0.65>,<0.5,0.195,-0.51> texture { Ground_Texture } }     // Unit floor

  box { <-0.85,0.15,0.66>,<0.85,0.205,500> texture { Ground_Texture} }      // floor "behind unit"
  box { <-500,0.15,3.5>,<500,0.205,500> texture { Ground_Texture} }      // floor "behind unit"
  height_field { gif "hf.gif" smooth scale <1.66,0.1,1.6> translate <-0.83,0.105,-0.56> texture { Ground_Texture } }
  box { <-0.85,0.15,-0.52>,<0.85,0.17,1> pigment { CadetBlue } normal { wrinkles 1 scale 0.05 } }     // river
  box { <-0.25,0.15,-0.66>,<0.5,0.203,-0.2> pigment { Gray } normal { crackle 0.3 scale 0.05 } }     // path
  box { <0.3,0.15,-0.5>,<0.85,0.203,0.0> pigment { Gray } normal { crackle 0.3 scale 0.05 } }     // path

  difference {                                                            // Sky background
    cylinder { <0,0,0>,<0,2,0>,0.85 }
    cylinder { <0,-0.1,0>,<0,2.001,0>,0.84 }
    plane { z,0 }
    texture {
      pigment {
        gradient y
        pigment_map {
          [0.0 Pig3 ]
          [0.3 Pig3 ]
          [0.35 Pig1 ]
          [0.65 Pig1 ]
          [0.75 Pig2 ]
          [0.84 Pig2 color rgbt <1,1,1,1> ]
          [1.0 Pig2 color rgbt <0,0,0,1> ]
        }
        scale <1,2,1>
      }
      finish {reflection 0.0 diffuse 0.0 ambient 1.0}
    }
    no_shadow
    scale <1,1,1.3>
  }

  texture { Base_Texture }
  texture { pigment { image_map { gif "label.gif" once interpolate 2 filter 1,1 } scale <0.3,0.071,1> translate <-0.72,0.05,0> } }
}

// ==== Speakers ====
#declare Speaker_Texture = texture { pigment { White } finish { Dull } }
#declare Speaker =
union {
  difference {
    superellipsoid { <0.15,0.15> scale <0.25,0.5,0.25> translate <0,0.55,0> }
    box { <-0.3,0.2,-0.3>,<0.3,0.975,-0.2> pigment { Gray15 } }                   // grille cutout
    cone { <0,0.42,0>,0.05,<0,0.42,-0.21>,0.23 pigment { Black } }                // bottom speaker cone
    cone { <-0.05,0.79,0>,0.05,<-0.05,0.79,-0.21>,0.15 pigment { Black } }        // top speaker cone
  }
  difference {
    intersection {
      superellipsoid { <0.15,0.15> scale <0.25,0.5,0.25> translate <0,0.55,0> }   // grille
      box { <-0.3,0.2,-0.3>,<0.3,0.975,-0.2> }
    }
    superellipsoid { <0.15,0.15> scale <0.24,0.5,0.24> translate <0,0.55,0> }   // back of grille
    pigment { colour rgbt <0,0,0,0.85> }
    finish { Dull }
  }
  sphere { <0,0,0>,0.1 scale <1,1,0.3> translate <0,0.42,0> texture { Chrome_Metal } }      // speaker centres
  sphere { <0,0,0>,0.1 scale <1,1,0.3> translate <-0.05,0.79,0> texture { Chrome_Metal } }  //   "        "
  difference {
    superellipsoid { <0.15,0.15> scale <0.2,0.5,0.2> translate <0,0,0> }          // base
    plane { y,0.01 }
    plane { -y,-0.1 }
  }
  texture { Speaker_Texture }
  texture { pigment { image_map { gif "sound.gif" once interpolate 2 filter 15,1 } scale <0.4,0.4/7,1> translate <-0.2,0.12,0> } }
}

// ==== CD / Cartridge ====
#declare CD =
union {
  difference {
    box { <-0.3,0,-0.25>,<0.25,0.04,0.25> }
    box { <-0.31,0.035,-0.24>,<0.24,0.05,0.24> }
    box { <-0.31,0.005,-0.26>,<0.26,0.035,-0.24> }
  }
  box { <-0.305,0.03,-0.24>,<-0.25,0.04,0.24> pigment { Gray30 } }
  box { <-0.26,0.02,-0.24>,<0.24,0.036,0.24>
      texture { pigment { White } }
      texture { pigment { image_map { gif "mikado_c.gif" once interpolate 2 } scale <0.5,0.5,1> rotate 90*x translate <-0.25,0,-0.25> } finish { ambient 0.3 } }
  }
  texture { Glass2 }
}


object { Floor }
object { Walls }
//   object { Speaker rotate -30*y scale 4 }
object { Base1 scale 4 translate <0,0,0> }

#ifdef (Use_Scene)
object { Speaker rotate -45*y scale 4 translate <-6.5,0,4> }
object { Speaker rotate 45*y scale 4 translate <6.5,0,4> }
object { CD rotate <-75,0,0> scale 4 translate <5.5,1,2> }
object { Scene scale 0.5 translate <0,0.8,-0.8> }
#end

