
/******************************************************************************************************/
//------------------------------------------------------------//--------------------------------------//
// Persistence of Vision Ray Tracer Include File              //  "A Machine for Living In"           //
// File: trumpet.inc                                          //  http://home1.gte.net/jmg/machine/   //
// Vers: 3.02 for Windows                                     //  e-mail: jmg@gte.net                 //
// Desc: A CSG Trumpet                                        //                                      //
// Date: October 1997                                         //  POVRAY: http://www.povray.org/      //
// Auth: Jason Perry                                          //                                      //
//------------------------------------------------------------//--------------------------------------//
/******************************************************************************************************/
//	The trumpet's 3D origin is located at the bottom of the center valve.


// ----- trumpet valve ------
#declare TrumpetValve = object {
union {
	cylinder { 0, 10*y, 1.0 }
	torus { 0.9, 0.1  translate 10*y }
	cylinder { -0.1*y, 10.1*y 0.9 }
	// ----- bottom piece -----
	union {
		torus { 1,0.1 }
		torus { 1,0.1 translate 0.5*y }
		cylinder { 0, 0.5*y, 1.1 }
	}
	// ----- valve key -----
	union {
		cylinder { 10*y, 11*y, 0.5 }
		cylinder { 11.1*y, 11.4*y 1.0 }
		cylinder { 11*y, 11.5*y 0.9 }
		torus { 0.9,0.1 translate 11.1*y }
		torus { 0.9,0.1 translate 11.4*y }
		// --- pearl inlay ---
		union {
			torus { 0.8,0.075 }
			cylinder { 11.5*y, 11.575*y, 0.8 }
			texture { TrumpetPearl scale 0.2 }
		}
	}
}}

#declare CenterValvePiece = object {
union {
	cylinder { 2*y, <0,2,-1.5> 0.6 }
	cylinder { 4*y, <0,4,-1.5> 0.6 }
	sphere { <0,2,-1.5> 0.6 }
	sphere { <0,4,-1.5> 0.6 }
	union { // second union so it can be translated/rotated
		cylinder { 2*y, <0,2,-0.5> 0.6 }
		cylinder { 4*y, <0,4,-0.5> 0.6 }
		torus { 1,0.6
			clipped_by { plane { z, 0 } }
			rotate 90*z
			translate <0,3,-0.5> }
		rotate 45*y
		translate -1.5*z
	}
}}

#declare FirstValvePiece = object {
union {
	cylinder { <-2.5,2,0><-3.5,2,-1.5> 0.6 }
	cylinder { <-2.5,4,0><-3.5,4,-1.5> 0.6 }
	sphere { <-3.5,2,-1.5> 0.6 }
	sphere { <-3.5,4,-1.5> 0.6 }
	cylinder { <-3.5,2,-1.5> <-7,2,-1.5> 0.6 }
	cylinder { <-3.5,4,-1.5> <-7,4,-1.5> 0.6 }
	torus { 1,0.6
		clipped_by { plane { z, 0 } }
		rotate <90,0,90>
		translate <-7,3,-1.5> }
	cylinder { <-5,2,-1.5><-5,4,-1.5> 0.3 }
}}

#declare MainValvePiece = object {
union {
	cylinder { <2.5,3,0><3.5,3,-1.5> 0.6 }
	sphere { <3.5,3,-1.5> 0.6 }
	cylinder { <3.5,3,-1.5><8,3,-1.5> 0.6 }
	torus { 3,0.6
		clipped_by { plane { -z, 0 } }
		rotate <90,0,90>
		translate <8,6,-1.5>
	}
	cylinder { <8,9,-1.5><-8,9,-1.5> 0.6 }
	// ----- for mouth piece
	cylinder { <-8,9,-1.5><-7,9,-1.5> 0.7 }
	torus { 0.6,0.1 rotate 90*z translate <-7,9,-1.5> }
	// ------ verticle bar
	cylinder { <7,3,-1.5><7,9,-1.5> 0.3 }
	cylinder { <7,3,-1.5><7,3.7,-1.5> 0.4 }
	torus { 0.3,0.1 translate <7,7.5,-1.5> }
	// ------ pieces connecting it to the three valves
	cylinder { <-2.5,9,0><-2.5,9,-1.5> 0.4 }
	cylinder { <0,9,0><0,9,-1.5> 0.4 }
	cylinder { <2.5,9,0><2.5,9,-1.5> 0.4 }
}}

#declare ThirdValvePiece = object {
union {
	cylinder { <7.5,2,2><-6,2,2> 0.6 }
	torus { 1.0,0.6
		rotate 90*x
		clipped_by { plane { -x, 0 }}
		translate <7.5,3,2>
	}
		cylinder { <2.5,4,0><3.5,4,2> 0.6 }
	sphere { <3.5,4,2> 0.6 }
	cylinder { <3.5,4,2><7.5,4,2> 0.6  }
	torus {
		3.5,0.6
		rotate 90*x
		clipped_by { plane { x, 0 }}
		translate <-6,5.5,2>
	}
	cylinder { <-5,9,2><-6,9,2> 0.6 }
	lathe {
		cubic_spline 11
  	<0.6,-1.0><0.6, 0.0><0.6, 1.0><0.6, 4.0>
		<0.7, 8.0><0.9,10.5><1.0,12.0><1.2,14.0>
		<2.4,17.5><4.0,19.0><4.0,19.5> sturm
		rotate 90*-z
		translate <-5,9,2>
	}
	torus {
		4,0.25
		scale <1,0.5,1>
		rotate 90*-z
		translate <14,9,2>
	}
}}

// ----- mouth piece -----
#declare MouthPiece = object {
union {
	cylinder { <-9,9,-1.5> <-8,9,-1.5> 0.5 }
	sphere { <0,0,0> 0.7 scale <1.5,1,1> translate <-9,9,-1.5> }
	cylinder { <-9,9,-1.5> <-10,9,-1.5> 0.8 }
	torus { 0.4,0.4 rotate 90*z translate <-10,9,-1.5> }
}}

#declare Trumpet = object {
union {
	object { TrumpetValve translate -2.5*x }
	object { TrumpetValve translate  0*x }
	object { TrumpetValve translate  2.5*x }
	object { CenterValvePiece }
	object { FirstValvePiece }
	object { MainValvePiece }
	object { ThirdValvePiece }
	object { MouthPiece }
	cylinder { <2.5,6.5,0> <-2.5,6.5,0> 0.4 } // bar connecting the 3 valves
	cylinder { <2.5,1.5,0> <-2.5,1.5,0> 0.4 } // bar connecting the 3 valves
	texture { TrumpetBrass }
}}
