#declare Steps = union
{
    #declare StepHeight=0.18
    #declare MyCount=0
    #while (MyCount < 14)
        #declare StepZ=(0.5+(MyCount*StepHeight))
        #declare StepY=(1.25+(MyCount*StepHeight))
        box { <1.2,-1,StepZ>,<15,StepY,(StepZ+StepHeight)> texture { MyStone2_T translate z*(rand(STZ))} }
        #declare MyCount = MyCount + 1
    #end
}

#declare MySky = union
{
    plane { z, 30 texture { MySky_T } scale 12 hollow }
    sphere { <0,0,0>, 200 texture { MySky_T scale 7 } scale 12 hollow }
}

#declare Floor = union
{
height_field
{
    tga "sand.tga"
    smooth
    translate <-0.5,-0.25,-0.5>
    scale <2,0.025,2>
    texture { SandwBlood_T }
    scale 12
}
height_field
{
    tga "sand.tga"
    smooth
    translate <-0.5,-0.25,-0.5>
    scale <2,0.025,2>
    texture { Sand_T }
    scale 12
    translate x*24
}
}
#declare ReliefTransform = transform
{
    translate <-0.5,-0.5,-0.5>
    scale <1,0.05,1>
    rotate x*90
    rotate y*180
    rotate z*180
    translate y*0.44
}

#declare Doorway = union
{
    union
    {
        box { <-1,-1,-0.05>,<-0.5,0.999999,0> }
#ifndef (TEST)
        height_field
        {
            tga "Snake1.tga"
            water_level 0.0001
            smooth
            transform ReliefTransform
            translate x*-0.7
            translate z*-0.055
        }
#end
        texture { MyStone1_T translate x*rand(R) scale 2 }
    }
    union
    {
        box { <0.5,-1,-0.05>,<1,0.999999,0> }
#ifndef (TEST)
    height_field
        {
            tga "Snake2.tga"
            water_level 0.0001
            smooth
            transform ReliefTransform
            translate x*0.7
            translate z*-0.055
        }
#end
        texture { MyStone1_T translate x*rand(R) scale 2 }
    }
    difference
    {
        box { <-1.000001,1,-0.05>,<1,1.5,0> }
#ifndef (TEST)
        text
        {
            ttf "c:\windows\fonts\simur.ttf",
            "agbas", 0.5, 0
            scale <0.16,0.15,1>
            translate x*0.725
            translate y*2.675
            translate z-1.535
            texture { T_Gold_3C scale 2 }
        }
        height_field
        {
            gif "relsun2.gif"
            water_level 0.001
            translate <-0.5,-0.5,-0.5>
            rotate x*90
            scale <0.25,0.25,0.125>//0.05>
            translate <0,1.25,-.1>
            texture { T_Gold_3C scale 2 }
        }
        text
        {
            ttf "c:\windows\fonts\simur.ttf",
            "woonis", 0.5, 0
            scale <0.14,0.15,1>
            translate x*1.7
            translate y*2.675
            translate z-1.535
            texture { T_Gold_3C scale 2 }
        }
#end
        texture { MyStone1_T rotate z*90 translate x*rand(R) scale 2 }
    }
}

#declare Bolts = union
{
    sphere { <0.05625,0.05625,0>, 0.014 }
    sphere { <0.01875,0.01875,0>, 0.014 }
    translate x*-0.49
    scale <1,1,0.75>
    translate z*0.1
}

#declare Beam = union
{
    box { <-0.49,0,0.1>,<0.49,0.075,0.125> }
#ifndef (TEST)
    #declare MyCount=0
    #while (MyCount < 5)
        object { Bolts texture { BlackMetal_T translate x*rand(R) } translate x*(MyCount*0.22875) }
    #declare MyCount = MyCount + 1
    #end
#end
}

#declare Bars = union
{
    #declare MyCount=0
    #while (MyCount < 4)
        object { Beam texture { BlackMetal_T translate x*rand(R) } translate y*(MyCount*0.3) }
    #declare MyCount = MyCount + 1
    #end

    #declare MyCount=0
    #while (MyCount < 5)
        box { <-0.495,-0.1,0.105>, <-0.42,1.1,0.12> texture { BlackMetal_T translate x*rand(R) }
                translate x*(MyCount*0.22875)}
    #declare MyCount = MyCount + 1
    #end

    texture { BlackMetal_T }
}

#declare Torches = union
{
    light_source { <-0.45,0.7,1> color Orange * 0.3 fade_distance 0.6 }
    light_source { <0.45,0.7,1> color Orange * 0.3 fade_distance 0.6 }
}



#declare WallPart = union
{
    difference
    {
        union
        {
            box { <-1.2,-1,0>, <14.8,3.5,0.5> }     //Wall
            difference
            {
                box { <-1.2,-1,0.5>, <4,3.5,4> }      //Corridor behind the Bars
                box { <1.5,-1,0.5>, <4,4,1.75> }      //Cutout for Steps
            }
            texture { Wall_T }
        }
        box { <-0.5,-1,-1>, <0.5,1,3> }             //Door
        box { <-0.5,-1,2>, <3,1,3> }                //Corridor
        box { <-0.495,0.9,0.095>, <0.495,2,0.13> }  //Cutout for Bars
        box { <1.2,1.5,-1>,<14.8,4,3>}                //Cutout for Steps
        texture { Wall_T }
    }
    object { Steps }
    object { Doorway }
    object { Bars }
    #ifndef (TEST)
    object { Torches }
    #end
}

#declare Wall = union
{
    object { WallPart }
    object { WallPart translate x*16 }
}


#declare Shattered_Bones = union
{
    object
    {
        Skull
        texture { Skull_T }
        scale 0.11
        rotate x*30
        rotate y*20
        rotate z*35
        translate <2.5,-0.05,-2>
    }
    object
    {
        Skull
        texture { Skull_T }
        scale 0.1
        rotate x*20
        rotate y*70
        rotate z*-27
        translate <-0.5,-0.05,-0.5>
    }
    object
    {
        Skull
        texture { Skull_T }
        scale 0.08
        rotate x*80
        translate <-1,-0.03275,-3.5>
    }
    object
    {
        Skull
        texture { Skull_T }
        scale 0.12
        rotate x*35
        rotate y*20
        rotate z*45
        translate <-0.5,0.02,-4>
    }
    object
    {
        Skull
        texture { Skull_T }
        scale 0.1
        rotate x*18
        rotate y*20
        rotate z*-25
        translate <0.5,-0.03,-3.6>
    }
    object
    {
        Skull
        texture { Skull_T }
        scale 0.09
        rotate x*30
        rotate y*40
        rotate z*35
        translate <-1.5,0.04,-4>
    }
    object
    {
        Skull
        texture { Skull_T }
        scale 0.08
        rotate x*21
        rotate y*-40
        rotate z*-37
        translate <0.5,-0.05,-2>
    }
}


