//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 14 lights, 34 textures and 545 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 10/17/1997    (17.10.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <41.820, -87.490, 20.810>
  direction <0.0,     0.0,  2.9380>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <48.871, 35.562, 13.890>
}

// *******  L I G H T S *******
light_source {   // Spotlight InsideLight
  <50.200, 71.170, 30.370>
  color  rgb <0.608, 0.506, 0.404>
  spotlight
    point_at  <50.200, 71.670, 29.504>
    falloff   32.4  // outer radius (in deg)
      radius    17.5  // inner radius
  fade_distance  30.0
  fade_power 2.0
}

light_source {   // Spotlight Spot3
  <40.350, 62.000, 30.700>
  color  rgb <1.000, 0.898, 0.796>
  spotlight
    point_at  <40.350, 62.906, 30.277>
    falloff   15.0  // outer radius (in deg)
      radius    10.1  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight Spot2
  <50.350, 62.000, 30.700>
  color  rgb <1.000, 0.898, 0.675>
  spotlight
    point_at  <50.350, 62.906, 30.277>
    falloff   15.0  // outer radius (in deg)
      radius    10.1  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight Spot1
  <60.350, 62.000, 30.700>
  color  rgb <0.898, 0.898, 0.898>
  spotlight
    point_at  <60.350, 62.906, 30.277>
    falloff   15.0  // outer radius (in deg)
      radius    10.1  // inner radius
}

light_source {   // LampLight1
  <65.000, 19.100, 23.740>
  color rgb <1.000, 1.000, 0.604>
  fade_distance  10.0
  fade_power 4.0
}

light_source {   // LampLight2
  <32.000, 19.200, 23.740>
  color rgb <1.000, 1.000, 0.604>
  fade_distance  10.0
  fade_power 4.0
}

light_source {   // CinemaLight1
  <49.600, 45.200, 31.050>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  15.0
  fade_power 3.0
  atmospheric_attenuation on
}

light_source {   // TicketLight
  <30.000, 45.100, 22.150>
  color rgb <0.796, 0.490, 0.082>
  fade_distance  20.0
  fade_power 3.0
}

light_source {   // PosterLight5
  <63.990, 38.990, 8.580>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 3.0
  atmospheric_attenuation on
}

light_source {   // PosterLight6
  <65.828, 37.151, 8.580>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 3.0
  atmospheric_attenuation on
}

light_source {   // PosterLight2
  <63.990, 38.990, 19.110>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 3.0
}

light_source {   // PosterLight4
  <62.151, 40.828, 8.580>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 3.0
}

light_source {   // PosterLight3
  <65.828, 37.151, 19.110>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 3.0
  atmospheric_attenuation on
}

light_source {   // PosterLight1
  <62.151, 40.828, 19.110>
  color rgb <1.004, 1.004, 1.004>
  fade_distance  10.0
  fade_power 3.0
}


// ********  TEXTURES  *******
//

#include "pavement.inc"



// ********  REFERENCED OBJECTS  *******

#declare BzPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, -1.271325, -0.948137>, <-0.489733, -0.822054, -0.344374>, <0.347540, -0.468497, -0.085841>, <1.499998, 0.000001, 0.000000>, 
      <-1.183902, -0.511945, -1.075466>, <-0.376310, -0.332766, -0.501753>, <0.432566, -0.201368, -0.198735>, <1.500000, 0.000009, 0.000000>, 
      <-1.183902, 0.500000, -1.078969>, <-0.376310, 0.356657, -0.501753>, <0.432566, 0.213313, -0.198735>, <1.499993, -0.000003, 0.000000>, 
      <-1.500000, 1.252430, -0.932073>, <-0.500000, 0.829918, -0.334406>, <0.318380, 0.486163, -0.079709>, <1.499998, 0.000000, 0.000000>
    }
  }
  translate  -1.5*x
}




// ********  OBJECTS  *******

#declare UmbHandy = difference {
  torus { // UmbHand
    0.3, 0.05  rotate -x*90
    rotate -90.0*x
    translate  <-0.3, 0.0, -3.7>
  }
  box { // UmbCut
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.6, 0.06, -2.7>
  }
}
#declare UmbAllStick = union {
  object { UmbHandy }
  cylinder { // UmbStick
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 3.7>
    translate  -3.7*z
  }
  texture {
    TUmbHand
  }
}
#declare Umbrella = union {
  object { // BzPtch8->BzPtch001
    BzPtch001
    rotate 45.0*z
  }
  object { // BzPtch7->BzPtch001
    BzPtch001
    rotate 90.0*z
  }
  object { // BzPtch6->BzPtch001
    BzPtch001
    rotate 135.0*z
  }
  object { // BzPtch5->BzPtch001
    BzPtch001
    rotate -180.0*z
  }
  object { // BzPtch2->BzPtch001
    BzPtch001
    rotate -45.0*z
  }
  object { // BzPtch3->BzPtch001
    BzPtch001
    rotate -90.0*z
  }
  object { // BzPtch4->BzPtch001
    BzPtch001
    rotate -135.0*z
  }
  object { BzPtch001 }
  texture {
    TUmbrella
  }
  scale <1.0, 1.0, 1.5>
}
#declare Umby = union {
  object { UmbAllStick }
  object { Umbrella }
  cone { // UmbPeak
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      TUmbPeak
    }
    scale <0.05, 0.05, 1.0>
    rotate 180.0*x
    translate  0.9*z
  }
  scale 1.3
  rotate 10.0*y
  translate  <43.499999, 23.429999, 17.7>
}
union { // ManAndUmb
  plane { // RainMan
    z,0
    texture {
      TRainMan
      scale <0.97, 1.7, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale 8.0
    rotate 90.0*x
    translate  <43.459999, 23.439999, 11.21>
  }
  object { Umby }
  translate  <-0.24, 0.04, -0.63>
}


plane { // Tickets
  z,0
  texture {
    TTickets
    scale <2.0, 0.7, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
  }
  scale 3.0
  rotate <90.0, 0.0, 45.0>
  translate  <34.359999, 40.649999, 18.81>
}




box { // NeonBackLight
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TCinemaNeonBright
    scale <0.39, 3.2, 1.0>
  translate <-0.640000, -1.740000, 0.000000>
  }
  no_shadow
  scale <20.0, 3.0, 0.02>
  rotate 90.0*x
  translate  <49.149999, 33.599999, 30.449999>
}


// Include contains 'Pool1'
#include "pavement.in1"

object {
  Pool1_Raw
  texture {
    TPool
  }
  scale <3.0, 4.0, 1.0>
  translate  <42.450001, 21.6, 2.5>
}


superellipsoid { // Wire2
  <1.0, 0.1>
  texture {
    TDoorKnob
  }
  scale <0.3, 0.3, 12.0>
  rotate -90.0*y
  translate  <49.700001, 51.600001, 23.175>
}


superellipsoid { // Wire1
  <1.0, 0.1>
  texture {
    TDoorKnob
  }
  scale <0.3, 0.3, 10.7>
  translate  <49.425, 51.600001, 12.5>
}








box { // Outlaw
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TOutlaw
    scale <2.0, -2.0, 1.0>
  translate <-1.000000, 1.000000, 0.000000>
  }
  scale <6.0, 4.5, 0.03>
  rotate -90.0*x
  translate  <50.100001, 88.900001, 16.9>
}


box { // Murder
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TMurder
    scale <2.0, -2.0, 1.0>
  translate <-1.000000, 1.000000, 0.000000>
  }
  scale <3.0, 4.5, 0.03>
  rotate -90.0*x
  translate  <40.150001, 88.900001, 17.0>
}


box { // Casablanca
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TCasablanca
    scale <2.0, -2.0, 1.0>
  translate <-1.000000, 1.000000, 0.000000>
  }
  scale <3.0, 4.5, 0.03>
  rotate -90.0*x
  translate  <60.0, 88.9, 17.0>
}


box { // CinemaWall
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TCinemaWall
  }
  scale <50.0, 1.0, 15.0>
  translate  <50.0, 90.0, 17.0>
}


#declare Pillows4 = union {
  superellipsoid { // ChairPillow9
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    rotate -100.0*x
    translate  <0.0, 1.05, 1.3>
  }
  superellipsoid { // ChairPillow10
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  texture {
    TChairPillow
  }
}
#declare ChairSides4 = union {
  box { // ChairSide9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <1.0, 0.25, 0.0>
  }
  box { // ChairSide10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-1.0, 0.25, 0.0>
  }
  texture {
    TChairSide
  }
}
#declare ChairPosts4 = union {
  superellipsoid { // ChairPost9
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <1.0, 0.25, 1.0>
  }
  superellipsoid { // ChairPost10
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <-1.0, 0.25, 1.0>
  }
  texture {
    TChairPost
  }
}
#declare CinemaChair4 = union {
  object { Pillows4 }
  object { ChairSides4 }
  object { ChairPosts4 }
  scale 2.5
  translate  <63.000001, 84.600001, 5.0>
}
#declare Pillows3 = union {
  superellipsoid { // ChairPillow7
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    rotate -100.0*x
    translate  <0.0, 1.05, 1.3>
  }
  superellipsoid { // ChairPillow8
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  texture {
    TChairPillow
  }
}
#declare ChairSides3 = union {
  box { // ChairSide7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <1.0, 0.25, 0.0>
  }
  box { // ChairSide8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-1.0, 0.25, 0.0>
  }
  texture {
    TChairSide
  }
}
#declare ChairPosts3 = union {
  superellipsoid { // ChairPost7
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <1.0, 0.25, 1.0>
  }
  superellipsoid { // ChairPost8
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <-1.0, 0.25, 1.0>
  }
  texture {
    TChairPost
  }
}
#declare CinemaChair3 = union {
  object { Pillows3 }
  object { ChairSides3 }
  object { ChairPosts3 }
  scale 2.5
  translate  <56.000001, 84.600001, 5.0>
}
#declare Pillows2 = union {
  superellipsoid { // ChairPillow5
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    rotate -100.0*x
    translate  <0.0, 1.05, 1.3>
  }
  superellipsoid { // ChairPillow6
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  texture {
    TChairPillow
  }
}
#declare ChairSides2 = union {
  box { // ChairSide5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <1.0, 0.25, 0.0>
  }
  box { // ChairSide6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-1.0, 0.25, 0.0>
  }
  texture {
    TChairSide
  }
}
#declare ChairPosts2 = union {
  superellipsoid { // ChairPost5
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <1.0, 0.25, 1.0>
  }
  superellipsoid { // ChairPost6
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <-1.0, 0.25, 1.0>
  }
  texture {
    TChairPost
  }
}
#declare CinemaChair2 = union {
  object { Pillows2 }
  object { ChairSides2 }
  object { ChairPosts2 }
  scale 2.5
  translate  <49.000001, 84.600001, 5.0>
}
#declare Pillows1 = union {
  superellipsoid { // ChairPillow3
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    rotate -100.0*x
    translate  <0.0, 1.05, 1.3>
  }
  superellipsoid { // ChairPillow4
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  texture {
    TChairPillow
  }
}
#declare ChairSides1 = union {
  box { // ChairSide3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <1.0, 0.25, 0.0>
  }
  box { // ChairSide4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-1.0, 0.25, 0.0>
  }
  texture {
    TChairSide
  }
}
#declare ChairPosts1 = union {
  superellipsoid { // ChairPost3
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <1.0, 0.25, 1.0>
  }
  superellipsoid { // ChairPost4
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <-1.0, 0.25, 1.0>
  }
  texture {
    TChairPost
  }
}
#declare CinemaChair1 = union {
  object { Pillows1 }
  object { ChairSides1 }
  object { ChairPosts1 }
  scale 2.5
  translate  <42.000001, 84.600001, 5.0>
}
#declare Pillows = union {
  superellipsoid { // ChairPillow1
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    rotate -100.0*x
    translate  <0.0, 1.05, 1.3>
  }
  superellipsoid { // ChairPillow2
    <0.01, 0.5>
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  texture {
    TChairPillow
  }
}
#declare ChairSides = union {
  box { // ChairSide2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <1.0, 0.25, 0.0>
  }
  box { // ChairSide1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-1.0, 0.25, 0.0>
  }
  texture {
    TChairSide
  }
}
#declare ChairPosts = union {
  superellipsoid { // ChairPost2
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <1.0, 0.25, 1.0>
  }
  superellipsoid { // ChairPost1
    <0.2, 0.2>
    scale <0.15, 1.1, 0.08>
    translate  <-1.0, 0.25, 1.0>
  }
  texture {
    TChairPost
  }
}
#declare CinemaChair5 = union {
  object { Pillows }
  object { ChairSides }
  object { ChairPosts }
  scale 2.5
  translate  <35.000001, 84.600001, 5.0>
}
union { // Chairs
  object { CinemaChair4 }
  object { CinemaChair3 }
  object { CinemaChair2 }
  object { CinemaChair1 }
  object { CinemaChair5 }
  translate  <0.8, 0.15, 0.0>
}


// The following include file contains the definition for LampTop
#include "pavement.in2"
#declare LampTop = object {
  LampTop_Raw
  no_shadow
  scale <0.55, 0.55, 0.3>
  rotate <-180.0, 0.0, -180.0>
  translate  7.7*z
}
//
// Include file contains 'LampPost'
//
#include "pavement.in3"
#declare LampPost = object {
  LampPost_Raw
  no_shadow
}
#declare LampBody = union {
  superellipsoid { // LampStick3
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, 135.0>
    translate  <-0.4, -0.4, 6.9>
  }
  superellipsoid { // LampStick1
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, -135.0>
    translate  <0.4, -0.4, 6.9>
  }
  superellipsoid { // LampBase
    <0.05, 0.05>
    no_shadow
    scale <0.4, 0.4, 0.04>
    translate  6.4*z
  }
  superellipsoid { // LampTopBase
    <0.05, 0.05>
    no_shadow
    scale <0.55, 0.55, 0.02>
    translate  7.38*z
  }
  superellipsoid { // LampStick
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, -45.0>
    translate  <0.4, 0.4, 6.9>
  }
  superellipsoid { // LampStick2
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, 45.0>
    translate  <-0.4, 0.4, 6.9>
  }
  object { LampTop }
  object { LampPost }
  cylinder { // LampBulbKeeper
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.04, 0.04, 0.52>
    translate  6.44*z
  }
  cylinder { // LampShadow
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.06>
    translate  6.4*z
  }
  box { // LampShadow1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.03, 0.5>
    rotate <-90.0, 0.0, -45.0>
    translate  6.4*z
  }
  box { // LampShadow2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.03, 0.5>
    rotate <-90.0, 0.0, -135.0>
    translate  6.4*z
  }
  texture {
    TLampPost
  }
}
#declare LampGlass = prism {
  conic_sweep
  linear_spline
  0.8,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    TLampGlass
  }
  hollow
  scale <0.45, 0.45, 5.0>
  translate  2.4*z
}
#declare Lamp1 = union {
  object { LampBody }
  sphere { // LampBulb
    <0,0,0>,1
    texture {
      TLampBulb
    }
    no_shadow
    hollow
    scale 0.15
    translate  7.1*z
  }
  object { LampGlass }
  scale 3.0
  translate  <65.0, 19.1, 2.5>
}
// The following include file contains the definition for LampTop1
#include "pavement.in4"
#declare LampTop1 = object {
  LampTop1_Raw
  no_shadow
  scale <0.55, 0.55, 0.3>
  rotate <-180.0, 0.0, -180.0>
  translate  7.7*z
}
//
// Include file contains 'LampPost1'
//
#include "pavement.in5"
#declare LampPost1 = object {
  LampPost1_Raw
  no_shadow
}
#declare LampBody1 = union {
  superellipsoid { // LampStick4
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, 135.0>
    translate  <-0.4, -0.4, 6.9>
  }
  superellipsoid { // LampStick5
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, -135.0>
    translate  <0.4, -0.4, 6.9>
  }
  superellipsoid { // LampBase1
    <0.05, 0.05>
    no_shadow
    scale <0.4, 0.4, 0.04>
    translate  6.4*z
  }
  superellipsoid { // LampTopBase1
    <0.05, 0.05>
    no_shadow
    scale <0.55, 0.55, 0.02>
    translate  7.38*z
  }
  superellipsoid { // LampStick6
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, -45.0>
    translate  <0.4, 0.4, 6.9>
  }
  superellipsoid { // LampStick7
    <0.2, 0.0001>
    no_shadow
    scale <0.03, 0.03, 0.5>
    rotate <-8.0, 0.0, 45.0>
    translate  <-0.4, 0.4, 6.9>
  }
  object { LampTop1 }
  object { LampPost1 }
  cylinder { // LampBulbKeepe1
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.04, 0.04, 0.52>
    translate  6.44*z
  }
  cylinder { // LampShadow3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.06>
    translate  6.4*z
  }
  box { // LampShadow4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.03, 0.5>
    rotate <-90.0, 0.0, -45.0>
    translate  6.4*z
  }
  box { // LampShadow5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.03, 0.5>
    rotate <-90.0, 0.0, -135.0>
    translate  6.4*z
  }
  texture {
    TLampPost
  }
}
#declare LampGlass1 = prism {
  conic_sweep
  linear_spline
  0.8,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    TLampGlass
  }
  hollow
  scale <0.45, 0.45, 5.0>
  translate  2.4*z
}
#declare Lamp2 = union {
  object { LampBody1 }
  sphere { // LampBulb1
    <0,0,0>,1
    texture {
      TLampBulb
    }
    no_shadow
    hollow
    scale 0.15
    translate  7.1*z
  }
  object { LampGlass1 }
  scale 3.0
  translate  <32.0, 19.2, 2.5>
}
union { // Lamps
  object { Lamp1 }
  object { Lamp2 }
}


#declare DoorKnobLeft = difference {
  torus { // DoorKnob1
    1.9, 0.2  rotate -x*90
    translate  0.1*z
  }
  box { // DoorKnob2
    <-1, -1, -1>, <1, 1, 1>
    scale 2.5
    translate  2.5*x
  }
  scale <0.5, 1.0, 1.0>
  rotate <-90.0, 0.0, 90.0>
  translate  <48.6, 51.400001, 12.4>
}
#declare DoorKnobRight = difference {
  torus { // DoorKnob3
    1.9, 0.2  rotate -x*90
  }
  box { // DoorKnob4
    <-1, -1, -1>, <1, 1, 1>
    scale 2.5
    translate  2.5*x
  }
  scale <0.5, 1.0, 1.0>
  rotate <-90.0, 0.0, 90.0>
  translate  <50.3, 51.400001, 12.4>
}
#declare DoorKnobs = union {
  object { DoorKnobLeft }
  object { DoorKnobRight }
  texture {
    TDoorKnob
  }
}
union { // Entrance
  box { // CinemaDoor3
    <-1, -1, -1>, <1, 1, 1>
    scale <11.0, 0.2, 4.2>
    translate  <49.450001, 51.600001, 27.55>
  }
  box { // CinemaDoor2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 0.2, 10.0>
    translate  <55.1, 51.600001, 13.0>
  }
  box { // CinemaDoor1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 0.2, 10.0>
    translate  <43.75, 51.600001, 13.0>
  }
  object { DoorKnobs }
  texture {
    TCinemaDoorGlass
  }
}




box { // Roof1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TRoof
  translate <-0.010000, 1.560000, 0.000000>
  }
  scale <50.0, 5.5, 3.0>
  translate  <49.750001, 39.200001, 30.45>
}


box { // Roof
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TWall
  }
  scale <50.0, 80.0, 1.0>
  translate  <49.750001, 117.600002, 32.45>
}


box { // Asphalt1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TCinemaFloor
  }
  scale <50.0, 100.0, 1.0>
  translate  <50.0, 135.0, 1.5>
}


superellipsoid { // TicketDesk
  <0.2, 0.2>
  texture {
    TTicketDesk
  }
  scale <1.0, 3.0, 0.2>
  rotate -45.0*z
  translate  <34.600001, 40.400001, 9.6>
}




#declare SideLeft = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.569619, -1.99518>,
  <1.0, -1.99518>,
  <1.0, 0.023972>,
  <0.024363, 1.0>,
  <-1.569619, 1.0>,
  <-1.569619, -1.99518>
  rotate -x*90
  scale <10.0, 10.0, 30.0>
  rotate -90.0*z
  translate  <28.95, 45.000001, 2.4>
}
#declare TicketHole = merge {
  box { // TicketRoom2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 5.0, 7.5>
    rotate <90.0, 0.0, 45.0>
    translate  <30.544797, 44.455204, 14.65>
  }
  box { // TicketRoom1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 10.0, 6.0>
    rotate <90.0, 0.0, 45.0>
    translate  <29.45, 45.500001, 12.6>
  }
}
difference { // LeftWall
  object { SideLeft }
  object { TicketHole }
  texture {
    TWall
    scale <35.0, 25.0, 1.0>
    rotate <90.0, 0.0, 22.5>
  translate <13.990000, 28.490000, 2.530000>
  }
}


difference { // TicketWindow
  box { // TicketGlass
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 0.1>
    translate  <0.0, 2.0, 0.5>
  }
  cylinder { // TicketGlass2
    <0,0,1>, <0,0,0>, 1 
  }
  texture {
    TTicketGlass
  }
  scale 2.5
  rotate <90.0, 0.0, 45.0>
  translate  <33.55, 41.450001, 9.65>
}


prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.569619, -1.99518>,
  <1.0, -1.99518>,
  <1.0, 0.023972>,
  <0.024363, 1.0>,
  <-1.569619, 1.0>,
  <-1.569619, -1.99518>
  rotate -x*90
  texture {
    TWall
    scale <3.5, 0.832, 1.0>
    rotate <-90.0, 0.0, -67.5>
  translate <0.410000, 1.460000, 1.000000>
  }
  scale <10.0, 10.0, 30.0>
  rotate <-180.0, 0.0, -90.0>
  translate  <68.950001, 45.150001, 32.5>
}


#declare PosterBoxDiff = difference {
  box { // PosterBox1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.75, 4.5>
    translate  <0.0, 26.5, 10.65>
  }
  box { // PosterBox2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.8, 0.75, 4.3>
    translate  <0.0, 26.3, 10.65>
  }
  texture {
    TPosterBox
  }
}
union { // PosterBox
  box { // PosterBox3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TPosterImg
    }
    scale <2.6, 0.01, 4.1>
    translate  <0.0, 27.0, 10.65>
  }
  box { // PosterBox4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TPosterGlass
    }
    scale <2.9, 0.03, 4.4>
    translate  <0.0, 25.85, 10.65>
  }
  object { PosterBoxDiff }
  sphere { // PosterBulb1
    <0,0,0>,1
    texture {
      TPosterBulb
    }
    no_shadow
    hollow
    scale 0.25
    translate  <-2.0, 26.75, 14.7>
  }
  sphere { // PosterBulb2
    <0,0,0>,1
    texture {
      TPosterBulb
    }
    no_shadow
    hollow
    scale 0.25
    translate  <0.0, 26.75, 14.7>
  }
  sphere { // PosterBulb3
    <0,0,0>,1
    texture {
      TPosterBulb
    }
    no_shadow
    hollow
    scale 0.25
    translate  <2.0, 26.75, 14.7>
  }
  sphere { // PosterBulb4
    <0,0,0>,1
    texture {
      TPosterBulb
    }
    no_shadow
    hollow
    scale 0.25
    translate  <2.0, 26.75, 6.6>
  }
  sphere { // PosterBulb5
    <0,0,0>,1
    texture {
      TPosterBulb
    }
    no_shadow
    hollow
    scale 0.25
    translate  <0.0, 26.75, 6.6>
  }
  sphere { // PosterBulb6
    <0,0,0>,1
    texture {
      TPosterBulb
    }
    no_shadow
    hollow
    scale 0.25
    translate  <-2.0, 26.75, 6.6>
  }
  scale 1.3
  rotate -45.0*z
  translate  <39.400001, 14.4, 0.0>
}


box { // Asphalt
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TAsphalt
  }
  scale <50.0, 10.0, 1.0>
  translate  <50.0, 25.0, 1.5>
}


union { // Terbs
  superellipsoid { // Terb10
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <105.0, 15.8, 1.7>
  }
  superellipsoid { // Terb8
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <85.0, 15.8, 1.7>
  }
  superellipsoid { // Terb9
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <95.0, 15.8, 1.7>
  }
  superellipsoid { // Terb4
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <45.0, 15.8, 1.7>
  }
  superellipsoid { // Terb5
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <55.0, 15.8, 1.7>
  }
  superellipsoid { // Terb6
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <65.0, 15.8, 1.7>
  }
  superellipsoid { // Terb7
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <75.0, 15.8, 1.7>
  }
  superellipsoid { // Terb1
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <15.0, 15.8, 1.7>
  }
  superellipsoid { // Terb2
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <25.0, 15.8, 1.7>
  }
  superellipsoid { // Terb3
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <35.0, 15.8, 1.7>
  }
  superellipsoid { // Terb
    <0.2, 0.1>
    scale <5.0, 1.0, 1.0>
    translate  <5.0, 15.8, 1.7>
  }
  texture {
    TRainyTerb
  }
}


#declare Bricks6 = union {
  box { // brick306
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick307
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick308
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick309
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick310
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick311
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick312
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick313
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick314
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick315
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick316
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick317
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick318
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick319
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick320
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick321
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick322
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick323
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick324
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick325
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick326
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick327
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick328
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick329
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick330
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick331
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick332
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick333
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick334
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick335
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick336
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick337
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick338
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick339
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick340
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick341
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick342
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick343
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick344
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick345
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick346
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick347
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick348
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick349
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick350
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick351
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick352
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick353
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick354
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick355
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick356
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  <1.0, 2.0, 0.0>
}
#declare Bricks7 = union {
  box { // brick357
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick358
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick359
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick360
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick361
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick362
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick363
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick364
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick365
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick366
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick367
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick368
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick369
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick370
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick371
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick372
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick373
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick374
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick375
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick376
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick377
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick378
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick379
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick380
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick381
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick382
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick383
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick384
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick385
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick386
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick387
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick388
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick389
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick390
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick391
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick392
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick393
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick394
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick395
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick396
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick397
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick398
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick399
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick400
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick401
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick402
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick403
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick404
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick405
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick406
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick407
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
}
#declare Bricks4 = union {
  box { // brick204
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick205
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick206
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick207
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick208
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick209
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick210
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick211
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick212
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick213
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick214
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick215
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick216
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick217
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick218
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick219
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick220
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick221
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick222
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick223
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick224
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick225
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick226
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick227
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick228
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick229
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick230
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick231
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick232
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick233
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick234
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick235
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick236
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick237
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick238
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick239
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick240
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick241
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick242
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick243
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick244
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick245
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick246
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick247
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick248
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick249
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick250
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick251
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick252
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick253
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick254
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  <1.0, -2.0, 0.0>
}
#declare Bricks5 = union {
  box { // brick255
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick256
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick257
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick258
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick259
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick260
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick261
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick262
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick263
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick264
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick265
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick266
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick267
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick268
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick269
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick270
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick271
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick272
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick273
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick274
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick275
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick276
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick277
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick278
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick279
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick280
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick281
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick282
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick283
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick284
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick285
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick286
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick287
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick288
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick289
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick290
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick291
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick292
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick293
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick294
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick295
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick296
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick297
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick298
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick299
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick300
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick301
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick302
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick303
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick304
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick305
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  -4.0*y
}
#declare Bricks2 = union {
  box { // brick102
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick103
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick104
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick105
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick106
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick107
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick108
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick109
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick110
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick111
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick112
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick113
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick114
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick115
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick116
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick117
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick118
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick119
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick120
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick121
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick122
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick123
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick124
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick125
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick126
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick127
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick128
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick129
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick130
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick131
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick132
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick133
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick134
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick135
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick136
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick137
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick138
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick139
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick140
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick141
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick142
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick143
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick144
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick145
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick146
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick147
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick148
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick149
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick150
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick151
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick152
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  <1.0, -6.0, 0.0>
}
#declare Bricks3 = union {
  box { // brick153
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick154
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick155
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick156
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick157
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick158
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick159
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick160
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick161
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick162
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick163
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick164
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick165
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick166
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick167
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick168
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick169
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick170
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick171
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick172
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick173
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick174
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick175
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick176
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick177
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick178
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick179
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick180
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick181
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick182
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick183
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick184
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick185
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick186
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick187
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick188
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick189
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick190
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick191
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick192
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick193
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick194
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick195
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick196
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick197
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick198
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick199
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick200
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick201
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick202
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick203
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  -8.0*y
}
#declare Bricks1 = union {
  box { // brick51
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick52
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick53
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick54
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick55
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick56
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick57
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick58
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick59
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick60
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick61
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick62
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick63
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick64
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick65
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick66
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick67
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick68
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick69
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick70
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick71
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick72
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick73
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick74
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick75
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick76
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick77
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick78
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick79
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick80
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick81
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick82
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick83
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick84
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick85
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick86
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick87
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick88
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick89
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick90
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick91
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick92
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick93
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick94
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick95
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick96
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick97
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick98
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick99
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick100
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick101
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  <1.0, -10.0, 0.0>
}
#declare Bricks = union {
  box { // brick4
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  8.0*x
  }
  box { // brick3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  6.0*x
  }
  box { // brick5
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  10.0*x
  }
  box { // brick2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  4.0*x
  }
  box { // brick6
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  12.0*x
  }
  box { // brick7
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  14.0*x
  }
  box { // brick8
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  16.0*x
  }
  box { // brick9
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  18.0*x
  }
  box { // brick10
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  20.0*x
  }
  box { // brick11
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  22.0*x
  }
  box { // brick12
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  24.0*x
  }
  box { // brick13
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  26.0*x
  }
  box { // brick14
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  28.0*x
  }
  box { // brick15
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  30.0*x
  }
  box { // brick17
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  34.0*x
  }
  box { // brick18
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  36.0*x
  }
  box { // brick19
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  38.0*x
  }
  box { // brick20
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  40.0*x
  }
  box { // brick21
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  42.0*x
  }
  box { // brick22
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  44.0*x
  }
  box { // brick23
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  46.0*x
  }
  box { // brick24
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  48.0*x
  }
  box { // brick25
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  50.0*x
  }
  box { // brick26
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  52.0*x
  }
  box { // brick27
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  54.0*x
  }
  box { // brick28
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  56.0*x
  }
  box { // brick29
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  58.0*x
  }
  box { // brick30
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  60.0*x
  }
  box { // brick31
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  62.0*x
  }
  box { // brick32
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  64.0*x
  }
  box { // brick33
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  66.0*x
  }
  box { // brick34
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  68.0*x
  }
  box { // brick35
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  70.0*x
  }
  box { // brick36
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  72.0*x
  }
  box { // brick37
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  74.0*x
  }
  box { // brick38
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  76.0*x
  }
  box { // brick39
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  78.0*x
  }
  box { // brick40
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  80.0*x
  }
  box { // brick41
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  82.0*x
  }
  box { // brick42
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  84.0*x
  }
  box { // brick43
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  86.0*x
  }
  box { // brick44
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  88.0*x
  }
  box { // brick45
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  90.0*x
  }
  box { // brick46
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  92.0*x
  }
  box { // brick47
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  94.0*x
  }
  box { // brick48
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  96.0*x
  }
  box { // brick49
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  98.0*x
  }
  box { // brick50
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  100.0*x
  }
  box { // brick1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  2.0*x
  }
  box { // brick16
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
    translate  32.0*x
  }
  box { // brick
    <-1, -1, -1>, <1, 1, 1>
    scale 0.9
  }
  translate  -12.0*y
}
union { // Pavement
  object { Bricks6 }
  object { Bricks7 }
  object { Bricks4 }
  object { Bricks5 }
  object { Bricks2 }
  object { Bricks3 }
  object { Bricks1 }
  object { Bricks }
  texture {
    TRainyBrick
  }
  translate  12.0*y
}


plane { // Plane2
  z,0
  texture {
    TRain
  }
  no_shadow
  rotate 90.0*x
  translate  33.0*y
}


plane { // Plane1
  z,0
  texture {
    TRain
  }
  no_shadow
  rotate 90.0*x
  translate  -6.0*y
}


union { // CinemaNeon
  plane { // cin2
    z,0
    texture {
      TCinemaNeonBack
      scale <1.0, -1.0, 1.0>
  translate <-1.000000, 1.000000, 0.000000>
    }
    no_shadow
    rotate -90.0*x
  }
  plane { // cin1
    z,0
    texture {
      TCinemaNeon
      scale <1.0, -1.0, 1.0>
  translate <-1.000000, 1.000000, 0.000000>
    }
    no_shadow
    rotate -90.0*x
    translate  -0.05*y
  }
  scale <7.0, 1.0, 7.0>
  translate  <44.600001, 33.0, 33.55>
}


