/*
Een houten mannetje, aan touwtjes, zoiets als pinokkio.

links en recht : zoals waneer ik frontaal op het figuur kijk, met de camera
   dus in de +z richting. dan links = -x, rechts = +x

<0,0,0> ERGENS OP HET TORSO.
VOETEN IN STAND : -24.5 Y     (ANKLE_TIE-1Y)
TOPJE VAN HAAR : +17 Y        (HEAD_TIE)
*/

/*
   unit cm !!
*/
#declare cm = 1
#declare m = 100
#declare mm = 0.1

// for fast test renders : #declare PuppetTestFast = TRUE

// --------------- pose ------------------

// lowest in hierarchy
#declare FOOT_LEFT_ANGLE = 0             // rotate feet in floor plane
#declare KNEE_LEFT_ANGLE = 25            // 0=stand, 90=bend. pos angle only
#declare LEG_LOWER_LEFT_ROLL = 10          // should be 0, but usefull to cheat
#declare LEG_LEFT_FORWARD_ANGLE = 100       // 0=stand, 90=sit
#declare LEG_LEFT_ROLL = 10                // 0=move forward, 90=move sideways
// highest

// lowest in hierarchy
#declare FOOT_RIGHT_ANGLE = 0             // rotate feet in floor plane
#declare KNEE_RIGHT_ANGLE = 45              // 0=stand, 90=bend. pos angle only
#declare LEG_LOWER_RIGHT_ROLL = 0          // should be 0, usefull cheat though
#declare LEG_RIGHT_FORWARD_ANGLE = 75      // 0=stand, 90=walk
#declare LEG_RIGHT_ROLL = 90             // 0=move forward, 90=move sideways
// highest

// lowest in hierarchy
#declare ELBOW_LEFT_ANGLE = 90          // 0=straight, 90=L-shape. pos only.
#declare ARM_LOWER_LEFT_ROLL = 135       // pos = outward
#declare ARM_LEFT_WIDE_ANGLE = 15       // 0=stiff, 90=airplane
#declare ARM_LEFT_FORWARD_ANGLE = 90   // 0=straight, 90=reach forward
// highest

// lowest in hierarchy
#declare ELBOW_RIGHT_ANGLE = 45         // 0=straight, 90=L-shape. pos only.
#declare ARM_LOWER_RIGHT_ROLL = 50      // pos=outward
#declare ARM_RIGHT_WIDE_ANGLE = 45     // 0=stiff, 90=airplane
#declare ARM_RIGHT_FORWARD_ANGLE = 180   // 0=straight, 90=reach forward
// highest

#declare HEAD_PITCH = -20            // pos = chin up
#declare HEAD_JAW = -20               // pos = look left

/* --------------------- textures ------------------------ */

#declare Shirt_Cloth = texture
{
   pigment { 
      color rgb <0,0.5,0>
   }
   normal 
   {
      wrinkles 0.75
      scale 1.5
   }
   finish
   {
      ambient 0.2
      diffuse 0.8
      brilliance 1
   }
}

#declare Shorts_Cloth = texture
{
   pigment { color rgb <0.7,0.7,0.5> }
   normal 
   {
      wrinkles 0.80
      scale 2.5
   }
   finish
   {
      ambient 0.2
      diffuse 0.8
      brilliance 1
   }
}

#declare Metal1 = texture
{
   pigment { color rgb<0.85,0.85,1> }
   finish 
   {
      metallic
      specular 1.0
      roughness 0.01
      brilliance 3
   }
}

#declare Rings = pigment 
{
   wood
   ramp_wave
   turbulence 0.01
   color_map
   {
      [0.0 color rgb<0.55,0.45,0.1>]
      [0.50 color rgb<0.45,0.35,0.1>]
      [0.65 color rgb<0.40,0.30,0.1>]
      [0.85 color rgb<0.40,0.30,0.1>]
      [1.0 color rgb<0.55,0.45,0.1>]
   }
   frequency 1
   scale 1/4
}

#declare Wood1 = texture
{
   pigment 
   {
      wood
      ramp_wave
      turbulence 0.01
      color_map
      {
         [0.0 color rgb<0.55,0.45,0.1>]
         [0.50 color rgb<0.45,0.35,0.1>]
         [0.65 color rgb<0.40,0.30,0.1>]
         [0.85 color rgb<0.40,0.30,0.1>]
         [1.0 color rgb<0.55,0.45,0.1>]
      }
      frequency 1
   }
   finish {diffuse 0.8 ambient 0.2 brilliance 0.7}
   scale 1/4
   // over de z as
}

#declare EyeWhite = texture
{
   pigment {color rgb 0.8}
   finish {diffuse 0.8 ambient 0.2 brilliance 1}
}

#declare EyeBlack = texture
{
   pigment {color rgb 0.2}
   finish {diffuse 0.8 ambient 0.2 brilliance 1}
}

#declare HairTex = texture
{
   pigment {color rgb<0.6,0.6,0.4>}
   finish 
   {
      brilliance 1.5
      roughness 0.015
      specular 1.0

      diffuse 0.8
      ambient 0.2
   }
}

/* -------------------- pinokkio's head ------------------- */

#declare WoodyHead = object
{
   #declare posx = 4
   #declare negx = 4
   #declare posy = 7
   #declare negy = 3
   #declare posz = 6
   #declare negz = 4
   difference
   {
      #include "octelips.inc"       // head
      difference                    // chop mouth out of it
      {
         sphere {<0,8,0> 8}
         sphere {<0,26,0> 25}
         translate <0,-1,-6>
      }
      cylinder {<-0.6,-2,1><0.6,-2,1> 3}     // room for rotating pin
   }
   texture {Wood1 rotate <90,0,30> translate <40,0,0>}     
}

// ------------ nose ------------

#declare Nose = object
{
   intersection
   {
      sphere {<0,0,0> 1 scale <0.5,0.5,4> translate <0,1,-5>}
      plane {<0,0,1> 0}
   }
   texture {Wood1 rotate <0,20,0> translate <-30,0,0>}
}

// ----------- eyes ------------

#declare EyeSlab1 = object
{
   difference
   {
      object {#include "octelips.inc" scale 1.01}
      object {#include "octelips.inc" scale 1}
   }
}

#declare EyeSlab2 = object
{
   difference
   {
      object {#include "octelips.inc" scale 1.02}
      object {#include "octelips.inc" scale 1}
   }
}


#declare LeftEye = object
{
   union
   {
      object
      {
         intersection
         {
            cylinder { <1,2,0> <1,2,-10> 0.70}
            object {EyeSlab1}
         }
         texture {EyeWhite}
      }
      object
      {
         intersection
         {
            cylinder { <1,2,0> <1,2,-10> 0.30}
            object {EyeSlab2 scale 1.01}
         }
         texture {EyeBlack}
      }
   }

}

#declare RightEye = object
{
   union
   {
      object
      {
         intersection
         {
            cylinder { <-1,2,0> <-1,2,-10> 0.70}
            object {EyeSlab1}
         }
         texture {EyeWhite}
      }
      object
      {
         intersection
         {
            cylinder { <-1,2,0> <-1,2,-10> 0.30}
            object {EyeSlab2 scale 1.01}
         }
         texture {EyeBlack}
      }
   }

}

// --------- ears ------
#declare Ear_r = object
{
   #declare posx = 1.0
   #declare negx = 0.4
   #declare posy = 0.6
   #declare negy = 1.4
   #declare posz = 0.3
   #declare negz = 0.2
   
   #include "octelips.inc"
   texture {Wood1}         // over z-as (slechte kwaliteit hout)
   translate <4.2,1.5,0>
   
}

#declare Ear_l = object
{
   #declare posx = 0.4
   #declare negx = 1.0
   #declare posy = 0.6
   #declare negy = 1.4
   #declare posz = 0.3
   #declare negz = 0.2
   
   #include "octelips.inc"
   texture {Wood1}         // over z-as (slechte kwaliteit hout)
   translate <-4.2,1.5,0>
}

// ------------- hair ---------------

#declare HairStrand = object
{
   intersection
   {
      torus {4, 0.075 rotate <0,0,90>}
      box {<-0.1, 4.1, 0> <0.1, 0, -4.1>}
      translate <0, -4.1, 0>
   }
   texture {HairTex}
}

#declare S1 = seed(0);

#declare Hair = object
{
   union
   {
      #declare NumStrands = 150
      #declare AngleStep = 360/NumStrands
      #declare Angle = 0
      #while (NumStrands > 0)
         object {
            HairStrand 
            rotate <rand(S1) * 10, Angle, 0>
            translate <0.05,7,0>
         }
         #declare NumStrands = NumStrands - 1
         #declare Angle = Angle + AngleStep
      #end
   }
}



// ------------- construct head ------------

#declare Head = object
{
   union
   {
      object {WoodyHead}
      object {Nose}
      object {LeftEye}
      object {RightEye}
      object {Ear_l}
      object {Ear_r}
      #ifndef (PuppetTestFast)
         object {Hair}
      #end
   }
   translate <0,3,0>          // pivot at bottom head
}

#declare Head_Connect = object
{
   union
   {
      object {Head rotate <HEAD_PITCH,0,0> translate <0,0,-1>}
      object
      {
         union
         {
            cylinder {<-1,0.5,0><1,0.5,0> 0.2}
            cylinder {<0,0.7,0> <0,-4,0> 0.4}
         }
         texture {Metal1}
      }
      rotate <0,HEAD_JAW,0>
   }
}

// -------------- Arms ------------

#declare Arm_Upper = object
{
   union
   {
      cylinder {<0,0,0> <0,-5,0> 1}
      sphere {<0,0,0> 1}
      sphere {<0,-5,0> 1}
   }
   texture {Wood1 rotate <90,0,45> translate <-30,20,0>}     
      // over  de y-as, verplaats -> lijnen
}

#declare Arm_Lower = object
{
   union
   {
      cylinder {<0,0,0> <0,-5,0> 1}
      sphere {<0,0,0> 1}
      sphere {<0,-5,0> 1}
   }
   texture {Wood1 rotate <90,0,-20> translate <20,0,0>} 
      // over  de y-as, verplaats -> lijnen
}

#declare Left_Hand = object
{
   union
   {
      // pink tot ringvinger
      cylinder {<0,0,0> <0,-1.5,0> 0.2 translate <0,-0.9,0> rotate <30, 0, 0>} 
      cylinder {<0,0,0> <0,-1.8,0> 0.2 translate <0,-0.9,0> rotate <10, 0, 10>} 
      cylinder {<0,0,0> <0,-2.0,0> 0.2 translate <0,-0.9,0> rotate <-10, 0, 10>} 
      cylinder {<0,0,0> <0,-1.7,0> 0.2 translate <0,-0.9,0> rotate <-30, 0, 0>} 
      // duim
      cylinder {<0,0,0> <0,-1.2,0> 0.25 translate <0,-0.9,0> rotate <-35, 0, -45>} 
   }
   texture {Wood1 rotate <90,0,0> translate <5,0,0>}     
      // over  de y-as, verplaats -> lijnen
}

#declare Right_Hand = object
{
   union
   {
      // pink tot ringvinger
      cylinder {<0,0,0> <0,-1.5,0> 0.2 translate <0,-0.9,0> rotate <-30, 0, 0>} 
      cylinder {<0,0,0> <0,-1.8,0> 0.2 translate <0,-0.9,0> rotate <-10, 0, 10>} 
      cylinder {<0,0,0> <0,-2.0,0> 0.2 translate <0,-0.9,0> rotate <10, 0, 10>} 
      cylinder {<0,0,0> <0,-1.7,0> 0.2 translate <0,-0.9,0> rotate <30, 0, 0>} 
      // duim
      cylinder {<0,0,0> <0,-1.2,0> 0.25 translate <0,-0.9,0> rotate <35, 0, -45>} 
   }
   texture {Wood1 rotate <60,0,20> translate <60,0,20>}     
      // over  de y-as, verplaats -> lijnen
}


#declare Elbow = object
{
   union
   {
      cylinder {<-1.4, 0, 0> <1.4,0,0> 0.2}
      cylinder {<-1.3, 0, 0> <-1.1,0,0> 0.3}
      cylinder {<1.3, 0, 0> <1.1,0,0> 0.3}
      intersection
      {
         cylinder {<0,0,-.3> <0,0,.3> 1.3}
         cylinder {<0,0,-.4> <0,0,.4> 1.1 inverse}
         box {<-1.3,0,-0.4> <1.3,-1.3,0.4>}
      }
      cylinder {<0,-1.1,0> <0,-1.4,0> 0.3}
      cylinder {<0,-1.1,0> <0,-4,0> 0.2}
   }
   rotate <0,0,180>
   texture {Metal1}
}

#declare Arm_Lower_Left_Connect = object
{
   union
   {
      object {Elbow}
      object {Arm_Lower rotate <ELBOW_LEFT_ANGLE,0,0>}
      object {Left_Hand translate <0,-5,0> rotate <ELBOW_LEFT_ANGLE,0,0>}
   }
   translate<0,-3,0>
   rotate <0,ARM_LOWER_LEFT_ROLL,0>
}

#declare Arm_Left = object
{
   union
   {
      object {Arm_Upper}
      object {Arm_Lower_Left_Connect translate <0,-5,0>}
   }
}

#declare Shoulder = object {Elbow rotate <90,90,0>}

#declare Arm_Left_Connect = object
{
   union
   {
      object {Shoulder}
      object {Arm_Left rotate <0,0,-ARM_LEFT_WIDE_ANGLE>}
   }
   rotate <ARM_LEFT_FORWARD_ANGLE,0,0>
}

#declare Arm_Lower_Right_Connect = object
{
   union
   {
      object {Elbow}
      object {Arm_Lower rotate <ELBOW_RIGHT_ANGLE,0,0>}
      object {Right_Hand translate <0,-5,0> rotate <ELBOW_RIGHT_ANGLE,0,0>}
   }
   translate<0,-3,0>
   rotate <0,-ARM_LOWER_RIGHT_ROLL,0>
}


#declare Arm_Right = object
{
   union
   {
      object {Arm_Upper}
      object {Arm_Lower_Right_Connect translate <0,-5,0>}
   }
}

#declare Arm_Right_Connect = object
{
   union
   {
      object {Shoulder rotate <0,180,0>}
      object {Arm_Right rotate <0,0,ARM_RIGHT_WIDE_ANGLE>}
   }
   rotate <ARM_RIGHT_FORWARD_ANGLE,0,0>
}

// ------------------ legs --------------------

#declare Leg_Upper = object
{
   union
   {
      cylinder {<0,0,0> <0,-5,0> 1.5}
      sphere {<0,0,0> 1.5}
      sphere {<0,-5,0> 1.5}
   }
   texture {Wood1 rotate <110,20,-20> translate <-15,20,0>}     
      // over  de y-as, verplaats -> lijnen
}

#declare Leg_Lower = object
{
   union
   {
      cylinder {<0,0,0> <0,-5,0> 1.5}
      sphere {<0,0,0> 1.5}
      sphere {<0,-5,0> 1.5}
   }
   texture {Wood1 rotate <90,-5,10> translate <20,5,0>}     
      // over  de y-as, verplaats -> lijnen
}

#declare Knee = object
{
   union
   {
      cylinder {<-2 0, 0> <+2,0,0> 0.3}
      cylinder {<-1.9, 0, 0> <-1.6,0,0> 0.4}
      cylinder {<1.9, 0, 0> <1.6,0,0> 0.4}
      intersection
      {
         cylinder {<0,0,-.4> <0,0,.4> 1.9}
         cylinder {<0,0,-.5> <0,0,.5> 1.6 inverse}
         box {<-1.9,0,-0.5> <1.9,-1.9,0.5>}
      }
      cylinder {<0,-1.6,0> <0,-1.9,0> 0.4}
      cylinder {<0,-1.6,0> <0,-4,0> 0.3}
   }
   rotate <0,0,180>
   texture {Metal1}
}

#declare Bottom = object {Knee}

#declare Foot = object
{
   intersection
   {
      #declare posx = 1.5
      #declare negx = 1.5
      #declare posy = 1
      #declare negy = 0.5
      #declare posz = 1.5
      #declare negz = 6
      #include "octelips.inc"
      box {<-1.5,0,-6><1.5,1,1.5>}
   }
   texture {Wood1 rotate <0,5,0> translate <20,0,0>}     // over z-as, verplaats->lijnen
}

#declare Leg_Lower_Right_Connect = object
{
   union
   {
      object {Knee}
      object {Leg_Lower rotate <-KNEE_RIGHT_ANGLE,0,0>}
      object {Foot rotate <0,-FOOT_RIGHT_ANGLE,0>
         translate <0,-7.5,0> rotate <-KNEE_RIGHT_ANGLE,0,0>}
   }
   translate<0,-3.5,0>
   rotate <0,-LEG_LOWER_RIGHT_ROLL,0>      // which should ofcourse be zero
}

#declare Leg_Right = object
{
   union
   {
      object {Leg_Upper}
      object {Leg_Lower_Right_Connect translate <0,-5,0>}
   }
}

#declare Leg_Right_Connect = object
{
   union
   {
      object {Bottom}
      object {Leg_Right rotate <LEG_RIGHT_FORWARD_ANGLE,0,0>}
   }
   rotate <0,-LEG_RIGHT_ROLL,0>
}

#declare Leg_Lower_Left_Connect = object
{
   union
   {
      object {Knee}
      object {Leg_Lower rotate <-KNEE_LEFT_ANGLE,0,0>}
      object {Foot rotate <0,FOOT_LEFT_ANGLE,0>
         translate <0,-7.5,0> rotate <-KNEE_LEFT_ANGLE,0,0>}
   }
   translate<0,-3.5,0>
   rotate <0,LEG_LOWER_LEFT_ROLL,0>      // which should ofcourse be zero
}

#declare Leg_Left = object
{
   union
   {
      object {Leg_Upper}
      object {Leg_Lower_Left_Connect translate <0,-5,0>}
   }
}

#declare Leg_Left_Connect = object
{
   union
   {
      object {Bottom}
      object {Leg_Left rotate <LEG_LEFT_FORWARD_ANGLE,0,0>}
   }
   rotate <0,LEG_LEFT_ROLL,0>
}

// ------------------- Torso -------------------

#declare Torso = object
{
   superellipsoid {<0.25,0.25> scale <5,6,3>}
   texture {Wood1 translate <-3,0,0>}   // Z-as, excentrisch
}

// ----------------------------- cloth ------------------------------

// density = strength * (1-radius%^2)^2

// shirt
#declare Shirt = object
{
   blob
   {
      threshold 0.5        // grens op 56% vd radius met enkele blob.

      // fit around body.
      cylinder {<-8,2,0> <8,2,0> 5 1 scale <0.5,1,1>}      // torso
      cylinder {<-8.25,-1,0> <8.25,-1,0> 5.10 1 scale <0.5,1,1>}    // torso
      cylinder {<-9,-4,0> <9,-4,0> 5.35 1 scale <0.5,1,1>}    // torso
      
      cylinder {<0,0,0>, <0,-1,0>, 3.5, -100 scale <0.65,1,1> translate <4,-4,0>}   
      cylinder {<3,-4,0>, <3,-5.0>, 3.5, -100}
      cylinder {<2,-4,0>, <2,-5.0>, 3.5, -100}
      cylinder {<1,-4,0>, <1,-5.0>, 3.5, -100}           // non-tucked shirt
      cylinder {<0,-4,0>, <0,-5.0>, 3.5, -100}
      cylinder {<-1,-4,0>, <-1,-5.0>, 3.5, -100}
      cylinder {<-2,-4,0>, <-2,-5.0>, 3.5, -100}
      cylinder {<-3,-4,0>, <-3,-5.0>, 3.5, -100}
      cylinder {<0,0,0>, <0,-1.0>, 3.5, -100 scale <0.65,1,1> translate <-4,-4,0>}
 
      sphere {<0,0,0> 4.5 1 scale <0.75,0.30,1> translate <3,5.5,0>}   // shoulders
      sphere {<0,0,0> 4.5 1 scale <0.75,0.30,1> translate <-3,5.5,0>}  // shoulders

      sphere {<0,0,0> 5 1 scale <0.50,1,1> translate <-4.5,4,0>}   // top side
      sphere {<0,0,0> 5 1 scale <0.50,1,1> translate <4.5,4,0>}   // top side

      sphere {<0,0,0> 5 1 scale <0.50,1,1> translate <2.5,4,0>}   // top side
      sphere {<0,0,0> 5 1 scale <0.50,1,1> translate <-2.5,4,0>}   // top side

      // --- right arm
      sphere  {<0,0,0> 3 1 scale <1,1,1> translate <7,5,0>}      // armjoint

      cylinder {<0,-2,0> <0,-4,0>, 2, 3            // upper arm
         rotate <0,0,ARM_RIGHT_WIDE_ANGLE>
         rotate <ARM_RIGHT_FORWARD_ANGLE,0,0>
         translate <7,5,0>
      }
      cylinder {<0,-4,0> <0,-5,0> 1.30, -100          // hollow end
         rotate <0,0,ARM_RIGHT_WIDE_ANGLE>
         rotate <ARM_RIGHT_FORWARD_ANGLE,0,0>
         translate <7,5,0>
      }
      
      // --- left arm

      sphere  {<0,0,0> 3 1 scale <1,1,1> translate <-7,5,0>}      // armjoint

      cylinder {<0,-2,0> <0,-4,0> 2 3           // upper arm
         rotate <0,0,-ARM_LEFT_WIDE_ANGLE>
         rotate <ARM_LEFT_FORWARD_ANGLE,0,0>
         translate <-7,5,0>
      }
      cylinder {<0,-4,0> <0,-5,0> 1.30, -100       // hollow end
         rotate <0,0,-ARM_LEFT_WIDE_ANGLE>
         rotate <ARM_LEFT_FORWARD_ANGLE,0,0>
         translate <-7,5,0>
      }
   }
   texture {Shirt_Cloth}
}

#declare Shorts = object
{
   blob
   {
      threshold 0.5
      cylinder {<-8,-4,0> <8,-4,0> 5 1 scale <0.5,1,1>}    // torso
      cylinder {<-8,-5,0> <8,-5,0> 5 0.5 scale <0.5,1,1>}    // torso

      // left leg
      sphere {<-3.5, -8.5, 0> 4, 1}    // leg joint

      cylinder {<0,-1.5,0><0,-2.5,0>, 4, 1           // hose
         rotate <LEG_LEFT_FORWARD_ANGLE,0,0>
         rotate <0,LEG_LEFT_ROLL,0>
         translate <-3.5, -8.5, 0>
      }

      cylinder {<0,-2.5,0><0,-4,0>, 2.2, -100           // openup end
         rotate <LEG_LEFT_FORWARD_ANGLE,0,0>
         rotate <0,LEG_LEFT_ROLL,0>
         translate <-3.5, -8.5, 0>
      }
      
      // right leg
      sphere {<3.5, -8.5, 0> 4, 1}     // leg joint

      cylinder {<0,-1.5,0><0,-2.5,0>, 4, 1           // hose
         rotate <LEG_RIGHT_FORWARD_ANGLE,0,0>
         rotate <0,-LEG_RIGHT_ROLL,0>
         translate <3.5, -8.5, 0>
      }
      cylinder {<0,-2.5,0><0,-4,0>, 2.2, -100           // openup end
         rotate <LEG_RIGHT_FORWARD_ANGLE,0,0>
         rotate <0,-LEG_RIGHT_ROLL,0>
         translate <3.5, -8.5, 0>
      }

   }

   texture {Shorts_Cloth}
}

// ----------------------tie ropes --------------------------------

#declare Left_Wrist_Tie = <0,-1,0>
#declare Left_Wrist_Tie = Left_Wrist_Tie + <0,-5,0>
#declare Left_Wrist_Tie = vrotate (Left_Wrist_Tie, <ELBOW_LEFT_ANGLE,0,0>)
#declare Left_Wrist_Tie = vrotate (Left_Wrist_Tie, <0,ARM_LOWER_LEFT_ROLL,0>)
#declare Left_Wrist_Tie = Left_Wrist_Tie + <0,-8,0>
#declare Left_Wrist_Tie = vrotate (Left_Wrist_Tie, <0,0,-ARM_LEFT_WIDE_ANGLE>)
#declare Left_Wrist_Tie = vrotate (Left_Wrist_Tie, <ARM_LEFT_FORWARD_ANGLE,0,0>)
#declare Left_Wrist_Tie = Left_Wrist_Tie + <-7,5,0>

#declare Right_Wrist_Tie = <0,-1,0>
#declare Right_Wrist_Tie = Right_Wrist_Tie + <0,-5,0>
#declare Right_Wrist_Tie = vrotate (Right_Wrist_Tie, <ELBOW_RIGHT_ANGLE,0,0>)
#declare Right_Wrist_Tie = vrotate (Right_Wrist_Tie, <0,-ARM_LOWER_RIGHT_ROLL,0>)
#declare Right_Wrist_Tie = Right_Wrist_Tie + <0,-8,0>
#declare Right_Wrist_Tie = vrotate (Right_Wrist_Tie, <0,0,ARM_RIGHT_WIDE_ANGLE>)
#declare Right_Wrist_Tie = vrotate (Right_Wrist_Tie, <ARM_RIGHT_FORWARD_ANGLE,0,0>)
#declare Right_Wrist_Tie = Right_Wrist_Tie + <7,5,0>

#declare Left_Ankle_Tie = <0,-1.5,0>
#declare Left_Ankle_Tie = Left_Ankle_Tie + <0,-5,0>
#declare Left_Ankle_Tie = vrotate(Left_Ankle_Tie, <-KNEE_LEFT_ANGLE,0,0>)
#declare Left_Ankle_Tie = vrotate(Left_Ankle_Tie, <0,LEG_LOWER_LEFT_ROLL,0>)
#declare Left_Ankle_Tie = Left_Ankle_Tie + <0,-8.5,0>
#declare Left_Ankle_Tie = vrotate(Left_Ankle_Tie, <LEG_LEFT_FORWARD_ANGLE,0,0>)
#declare Left_Ankle_Tie = vrotate(Left_Ankle_Tie, <0,LEG_LEFT_ROLL,0>)
#declare Left_Ankle_Tie = Left_Ankle_Tie + <-3.5,-8.5,0>


#declare Right_Ankle_Tie = <0,-1.5,0>
#declare Right_Ankle_Tie = Right_Ankle_Tie + <0,-5,0>
#declare Right_Ankle_Tie = vrotate(Right_Ankle_Tie, <-KNEE_RIGHT_ANGLE,0,0>)
#declare Right_Ankle_Tie = vrotate(Right_Ankle_Tie, <0,-LEG_LOWER_RIGHT_ROLL,0>)
#declare Right_Ankle_Tie = Right_Ankle_Tie + <0,-8.5,0>
#declare Right_Ankle_Tie = vrotate(Right_Ankle_Tie, <LEG_RIGHT_FORWARD_ANGLE,0,0>)
#declare Right_Ankle_Tie = vrotate(Right_Ankle_Tie, <0,-LEG_RIGHT_ROLL,0>)
#declare Right_Ankle_Tie = Right_Ankle_Tie + <+3.5,-8.5,0>

#declare Head_Tie = <0,0,0>
#declare Head_Tie = Head_Tie + <0, 10, -1>
#declare Head_Tie = vrotate (Head_Tie, <HEAD_PITCH,0,0>)
#declare Head_Tie = vrotate (Head_Tie, <0,HEAD_JAW,0>)
#declare Head_Tie = Head_Tie + <0,7,0>

#declare String = object
{
   union
   {
      object
      {  
         intersection
         {
            cylinder {<0,0,0> <0,600,0> 0.1}
            box {<-0.1,0,-0.1> <0.1,600,0>}
         }
         pigment { 
            gradient y
            color_map 
            {
               [0.0 rgb <0.7,0.7,0.5>*1.0]
               [0.1 rgb <0.7,0.7,0.5>*0.5]
               [0.2 rgb <0.7,0.7,0.5>*0.9]
               [0.3 rgb <0.7,0.7,0.5>*0.7]
               [0.4 rgb <0.7,0.7,0.5>*1.0]
               [0.5 rgb <0.7,0.7,0.5>*0.75]
               [0.6 rgb <0.7,0.7,0.5>*0.5]
               [0.7 rgb <0.7,0.7,0.5>*1.0]
               [0.8 rgb <0.7,0.7,0.5>*0.75]
               [0.9 rgb <0.7,0.7,0.5>*0.8]
               [1.0 rgb <0.7,0.7,0.5>*0.6]
            }
            frequency 8
            rotate <0,0,-39>
         }
      }

      object
      {  
         intersection
         {
            cylinder {<0,0,0> <0,600,0> 0.1}
            box {<-0.1,0,0> <0.1,600,0.1>}
         }
         pigment { 
            gradient y
            color_map 
            {
               [0.0 rgb <0.7,0.7,0.5>*1.0]
               [0.1 rgb <0.7,0.7,0.5>*0.5]
               [0.2 rgb <0.7,0.7,0.5>*0.9]
               [0.3 rgb <0.7,0.7,0.5>*0.7]
               [0.4 rgb <0.7,0.7,0.5>*1.0]
               [0.5 rgb <0.7,0.7,0.5>*0.75]
               [0.6 rgb <0.7,0.7,0.5>*0.5]
               [0.7 rgb <0.7,0.7,0.5>*1.0]
               [0.8 rgb <0.7,0.7,0.5>*0.75]
               [0.9 rgb <0.7,0.7,0.5>*0.8]
               [1.0 rgb <0.7,0.7,0.5>*0.6]
            }
            frequency 8
            rotate <0,0,39>
         }
      }
   }
}

#declare Tie_Em_Up = object
{
   union
   {
      object { String translate Left_Wrist_Tie}
      object { String translate Right_Wrist_Tie}
      object { String translate Left_Ankle_Tie}
      object { String translate Right_Ankle_Tie}
      object { String translate Head_Tie}
   }
}

// -----------------------------

#declare Body = object
{
   union
   {
      object {Torso}
      object {Head_Connect translate <0,7,0>}
      object {Arm_Left_Connect translate <-7,5,0>}
      object {Arm_Right_Connect translate <7,5,0>}
      object {Leg_Left_Connect translate <-3.5,-8.5,0>}
      object {Leg_Right_Connect translate <3.5,-8.5,0>}
   }
}

#declare Puppet = object
{
   union
   {
      object {Body}
      #ifndef (PuppetTestFast)
         object {Shorts}
         object {Shirt}
         object {Tie_Em_Up}
      #end
   }
   // translate <0,-8.5, 0>      // pivot op heupen
}

