// Persistence of Vision Ray Tracer Scene Description File
// File: RMREVOLT.POV
// Vers: 3.01
// Desc: Reconstruction of the painting 'La Rvolution' (The Revolution)
//       by Ren Magritte
// Date: 18th October 1997
// Auth: Roland Mnger (email: rmjudge@bluewin.ch)

#declare F = texture {pigment {color <1,0.45,0.05>}
                      finish { brilliance 2
                              specular 0.15 roughness 1/10 reflection 0.1}}
#declare P = pigment {color <0.18,0,0>}
#declare PP = pigment {color <0.75,0.26,0.26>}
#declare T1 = texture { pigment { wood turbulence <0.04, 0.07, 0.2> octaves 2 scale <0.3,0.15,0.75>
                                 color_map { [0.0, 0.25 color <0.75, 0.35, 0.20>
                                                        color <0.75, 0.35, 0.20>]
                                            [0.25, 0.95 color <0.75, 0.35, 0.20>
                                                        color <1   , 0.6 , 0   >]
                                             [0.95, 1.0 color <1   , 0.6 , 0   >
                                                        color <0.75, 0.35, 0.20>]}} finish {diffuse 0.8}}

#declare T2 = texture { pigment { wood turbulence <0.04, 0.07, 0.2> octaves 2 scale <0.3,0.15,0.75>
                                 color_map { [0.0, 0.05 color <0.75, 0.35, 0.20>
                                                        color <0.75, 0.35, 0.20>]
                                            [0.05, 0.75 color <0.75, 0.35, 0.20>
                                                        color <1   , 0.6 , 0   >]
                                             [0.75, 1.0 color <1   , 0.6 , 0   >
                                                        color <0.75, 0.35, 0.20>]}}finish {diffuse 0.8}}
#declare W = pigment { bozo
                       turbulence 0.65
                       octaves 3
                       omega 0.4
                       lambda 3
                       color_map {
                       [0.0, 0.3  color <1,1,1>
                                  color <0.95,0.95,0.95>]
                       [0.3, 0.4  color <0.95,0.95,0.95>
                                  color <0.6, 0.7,1     >]
                       [0.4, 1.00 color <0.6, 0.7,1>
                                  color <0.6, 0.7,1>]}
                       scale <12,6,12.5>}

#declare PW2 = pigment {
    bozo
    color_map {[0.00, 0.1 color <0.2,0.2,0.2>
                           color <0.1,0.1,0.1>]
               [0.1, 0.175 color <0.1,0.1,0.1>
                           color <0,0,0>      ]
               [0.175, 1    color <0,0,0>
                           color <0,0,0>      ]
    }
    turbulence 0.5
    octaves 7
    omega 0.7
    lambda 1.525
    scale <5,2,3> translate <-36,9.75,0>
}

#declare W2 = sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.10 color <0.3,0.33,0.3> ]
            [0.25 PW2 scale 0.15 ]}}}

sky_sphere {W2 rotate <26.5,7,0>}

camera { location  <0,145,-100>
         right     <1.316,  0,    0>
         look_at   <0,148,    0>
         angle 75}

light_source { <0,0,0> color <1,1,1>*1.6 translate <75,230,-200> }

/*Backsteine unten*/
box {<-88.3,87.1,0>,<-58.3,100,22.5> pigment {P}}
box {<-57.7,87.1,0>,<-27.7,100,22.5> pigment {P}}
box {<-27.1,87.1,0>,<2.9,100,22.5> pigment {P}}
box {<3.5,87.1,0>,<33.5,100,22.5> pigment {P}}
box {<34.1,87.1,0>,<64.7,100,22.5> pigment {P}}
box {<65.3,87.1,0>,<95.3,100,22.5> pigment {P}}

/*Backstein Hellflche unten*/
box {<-57.7,100,0>,<-27.7,100.01,22.5> pigment {PP}}
box {<-27.1,100,0>,<2.9,100.01,22.5> pigment {PP}}
box {<3.5,100,0>,<33.5,100.01,22.5> pigment {PP}}
box {<34.1,100,0>,<64.7,100.01,22.5> pigment {PP}}
box {<65.3,100,0>,<95.3,100.01,22.5> pigment {PP}}

/*Backsteine links*/
box {<-73,100.6,0>,<-43,113.5,22.5> pigment {P}}
box {<-57.7,114.1,0>,<-43,127  ,22.5> pigment {P}}
box {<-73,127.6,0>,<-43,140.5,22.5> pigment {P}}
box {<-57.7,141.1,0>,<-43,154  ,22.5> pigment {P}}
box {<-73,154.6,0>,<-43,168.5,22.5> pigment {P}}
box {<-57.7,169.1,0>,<-43,182  ,22.5> pigment {P}}
box {<-73,182.6,0>,<-43,195.5,22.5> pigment {P}}
box {<-57.7,196.1,0>,<-43,209  ,22.5> pigment {P}}
box {<-500,209.6,0>,<-43,222.5,22.5> pigment {P}}

/*Backstein Hellflche links*/
box {<-43,100,0>,<-43.01,113.5,22.5> pigment {PP}}
box {<-43,114.1,0>,<-43.01,127  ,22.5> pigment {PP}}
box {<-43,127.6,0>,<-43.01,140.5,22.5> pigment {PP}}
box {<-43,141.1,0>,<-43.01,154  ,22.5> pigment {PP}}
box {<-43,154.6,0>,<-43.01,168.5,22.5> pigment {PP}}
box {<-43,169.1,0>,<-43.01,182  ,22.5> pigment {PP}}
box {<-43,182.6,0>,<-43.01,195.5,22.5> pigment {PP}}
box {<-43,196.1,0>,<-43.01,209  ,22.5> pigment {PP}}
box {<-43,209.6,0>,<-43.01,222.5,22.5> pigment {PP}}

/*Backsteine links*/
box {<-88.3,196.1,0>,<-58.3,209  ,22.5> pigment {P}}
box {<-88.3,169.1,0>,<-58.3,182  ,22.5> pigment {P}}
box {<-88.3,141.1,0>,<-58.3,154  ,22.5> pigment {P}}
box {<-88.3,114.1,0>,<-58.3,127  ,22.5> pigment {P}}

box {<-103.6,100.6,0>,<-73.6,113.5,22.5> pigment {P}}
box {<-103.6,127.6,0>,<-73.6,140.5,22.5> pigment {P}}
box {<-103.6,154.6,0>,<-73.6,168.5,22.5> pigment {P}}
box {<-103.6,182.6,0>,<-73.6,195.5,22.5> pigment {P}}

/*Mrtel dunkel*/
union {
box {<-100,0,0.1>,<-43.1,250,22.4>}
box {<-40,0,0.1>,<100,99.9,22.4>}
pigment {color <0.42,0.35,0.35>}}

/*Mrtel hell*/
union {
box {<-100,0,0.11>,<-43.09,250,22.4>}
box {<-40,99.9,0.11>,<100,99.91,22.4>}
pigment {color <0.92,0.85,0.85>}}

/*Holz vertikal*/
box {<-14,0,-35>,<-9.5,181,-33> texture {T1 rotate <90,0,0> scale 0.3} no_shadow}
box {<-29,0,-35>,<-26.5,173,-30.5> texture {T1 rotate <90,0,0> scale 0.6} no_shadow}
box {<1.5,0,-35>,<4,173,-30.5> texture {T1 rotate <90,0,-10> scale 0.3 translate <0,0,0>} no_shadow}

/*Querholz unten*/
box {<-29,125.25,-44>,<4.5,127,-43> texture {T2 rotate <0,90,0> translate <0,-30,0> scale 0.1} no_shadow}
box {<-29,125.5,-42>,<4.5,126,-35> texture {T2 rotate <0,90,0> translate <0,-30,0> scale 0.1} no_shadow}

/*Querholz oben*/
union {
box {<-18.5,166.5,-41>,<-4.5,169,-40>}
box {<-18.5,168.5,-40>,<-4.5,169,-35>}
translate <11.5,-167.75,38> rotate <0,1,0> translate <-11.5,167.75,-38>
texture {T2 rotate <0,90,0> translate <0,-30,0> scale 0.1}}

/*Schraube*/
cylinder {<-11.6,167.75,-43>,<-11.6,167.75,-34>,0.34 pigment {color <0.75,0.75,0.75>} finish {diffuse 0.8}}
cylinder {<-11.6,167.75,-43>,<-11.6,167.75,-42.5>,0.6 pigment {color <0.75,0.75,0.75>} finish {diffuse 0.8}}

/*Dreher*/
/*with bend.inc of Chris Colefax*/
   #declare bend_object = object {cylinder {<-13,119,-36>,<-13,127,-36>,0.34 pigment {color <0.35,0.35,0.35>}
                                               finish {ambient 0.6 metallic reflection 0.8}
                                               no_shadow}}
   #declare object_axis1 = <-13,119,-36>
   #declare object_axis2 = <-13,127,-36>
   #declare bend_angle = 40
   #declare bend_direction = x
   #declare bend_smoothness = 50
   #declare bend_start = 0.2
   #declare bend_finish = 0.4
   #include "bend.inc"

   #declare bend_object = object {cylinder {<-13,119,-36>,<-13,114,-36>,0.34 pigment {color <0.35,0.35,0.35>}
                                               finish {ambient 0.6 metallic reflection 0.8}
                                               no_shadow}}
   #declare object_axis1 = <-13,119,-36>
   #declare object_axis2 = <-13,114,-36>
   #declare bend_angle = 40
   #declare bend_direction = -x
   #declare bend_smoothness = 50
   #declare bend_start = 0
   #declare bend_finish = 0
   #include "bend.inc"


/*Bild*/
box {<-35,127.5,-38>,<10.5,167,-37.9> pigment {W translate <-100,50,10>} finish {diffuse 0.7}
    translate <12,-147.75,38> rotate <0,2,0> translate <-12,147.75,-38> no_shadow}


/*Rahmen*/
difference {
union {
difference {
cylinder {<-100,167,-38>,<100,167,-38>,1.45}
plane {x,0 rotate <0,0,45> translate <-35,167,-38>}
plane {x,0 inverse rotate <0,0,-45> translate <10.5,167,-38>}}
difference {
cylinder {<-100,127.5,-38>,<100,127.5,-38>,1.45}
plane {x,0 rotate <0,0,-45> translate <-35,127.5,-38>}
plane {x,0 inverse rotate <0,0,45> translate <10.5,127.5,-38>}}
difference {
cylinder {<10.5,200,-38>,<10.5,100,-38>,1.45}
plane {y,0 inverse rotate <0,0,45> translate <10.5,167,-38>}
plane {y,0 rotate <0,0,-45> translate <10.5,127.5,-38>}}
difference {
cylinder {<-35,200,-38>,<-35,100,-38>,1.45}
plane {y,0 inverse rotate <0,0,-45> translate <-35,167,-38>}
plane {y,0 rotate <0,0,45> translate <-35,127.5,-38>}}}
plane {z,0 inverse translate <0,0,-38>}
texture {F} translate <12,-147.75,38> rotate <0,2,0> translate <-12,147.75,-38> no_shadow}

/*Kugel*/
difference {
sphere {<38,111,6>,11 pigment {color <0.65,0.65,0.65>} finish {brilliance 1.1}}
sphere {<38,111,6>,10}
box {<18,105.5,-14>,<68,106.75,26> rotate <0,0,6> scale <1.05,1,1> pigment {color <0.7,0.7,0.7>}
                                     finish {ambient 0.6 diffuse 0.8 metallic reflection 0.75}}}

/*Unterschrift*/
difference {
  text {ttf "brushscn.ttf", "Magritte", 0.001, 0}
  box {<-1,-1,-1>,<0,1,1> rotate <0,0,-25>}
    pigment {color<1,0.5,0.15>} no_shadow scale 1.65 translate <-67,97,-10>}

/*Logo*/
//That's a secret!

