
// Persistence of Vision Ray Tracer Scene Description File
// File: sharkcam.pov
// Vers: 3
// Desc: Diver in shark cage taking pictures of sharks
// Date: 10/27/97
// Auth: Lance Hetlet

#declare Chrome_Metal1 = texture {
   pigment {
     color rgb<0.659, 0.659, 0.659>
   }
   finish {
     diffuse 0.700
     ambient 0.300
     reflection 0.150
     specular 0.800
     roughness 0.1000
     brilliance 8.000
   }

}

#declare blackeyes1 = texture {
   pigment {
     color rgbf<0.000, 0.000, 0.000, 0.273>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     phong 0.170
     phong_size 1.000
     reflection 0.320
     specular 0.510
     roughness 0.0100
     brilliance 6.896
   }

}

#declare SkinSuit = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     phong 0.180
     phong_size 1.000
     reflection 0.180
     brilliance 4.827
   }

}




#declare MouthPieceTxt = texture {
   pigment {
     color rgb<0.546, 0.550, 0.675>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.680
     specular 0.400
     roughness 0.0100
     brilliance 13.103
   }

}

#declare FaceMask = texture {
   pigment {
     color rgb<0.437, 0.423, 0.888>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare CamTxt = texture {
   pigment {
     color rgb<0.336, 0.398, 0.383>
   }
   finish {
     diffuse 0.500
     ambient 0.550
     phong 0.220
     phong_size 6.100
     reflection 0.430
     brilliance 6.551
   }

}

#declare LensTxt = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.770
     specular 0.400
     roughness 0.0100
   }

}

#declare Fintxt = texture {
   pigment {
     color rgb<0.054, 0.178, 0.671>
   }
   normal {
     bumps 0.5000
     turbulence 0.050
     octaves 2
     lambda 0.500
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0010
   }

}

#declare TankTxt = texture {
   pigment {
     color rgb<0.659, 0.659, 0.161>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.7410
   }

}

#declare Facial = texture {
   pigment {
     color rgb<0.960, 0.800, 0.690>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare Shark1 = texture {
   pigment {
     color rgb<0.000, 0.000, 0.432>
   }
   normal {
     bumps 0.4000
     turbulence 0.050
     omega 2.000
     lambda 0.500
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare Shark3 = texture {
   pigment {
     color rgb<0.000, 0.263, 0.300>
   }
   normal {
     bumps 1.0000
     turbulence 0.050
     omega 2.000
     lambda 0.500
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}


#declare Rusty_Iron1 = texture {
   pigment {
     agate
     color_map {
       [ 0.000  color rgb<0.210, 0.100, 0.100> ]
       [ 0.500  color rgb<0.250, 0.250, 0.010> ]
       [ 0.600  color rgb<0.300, 0.100, 0.100> ]
       [ 0.600  color rgb<0.150, 0.100, 0.100> ]
       [ 1.000  color rgb<0.150, 0.100, 0.100> ]
     }
   }

}

#declare rope = texture {
   pigment {
     onion
     color_map {
       [ 0.000  color rgb<0.000, 0.000, 0.000> ]
       [ 1.000  color rgbf<0.602, 0.602, 0.602, 0.164> ]
     }
   }
   normal {
     bumps 1.0000
     turbulence 0.050
     omega 2.000
     lambda 0.500
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}




#declare Fishy = texture {
   pigment {
     marble
     color_map {
       [ 0.000  color rgb<0.246, 0.189, 1.000> ]
       [ 1.000  color rgb<0.972, 0.958, 0.712> ]
     }
     turbulence 1.100
     frequency 0.500
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}








#declare blackeye = texture {
   pigment {
     color rgb<0.259, 0.000, 0.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}







global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <1.000,0.382,0.388> }

fog {
  fog_type 2    // Ground Fog
  distance     12.0
  color <0.061493,0.071,0.246,0.0,0.0>
  turbulence   <1.0,1.0,1.5>
    omega      0.5
    lambda     2.0
    octaves    2
    turb_depth 1.5
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      6.0
}

camera {  //  Camera Camera
  location  <138.600, -300.800, 102.200>
  direction <0.0,     0.0,  2.5899>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 1.000>
}

// *******  L I G H T S *******
light_source { // AreaL5
  <219.600, -131.150, 331.750>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  atmospheric_attenuation on
}


light_source { // AreaL4
  <206.850, 50.600, 185.600>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  atmospheric_attenuation on
}


light_source { // AreaL003
  <129.250, -133.150, 185.600>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light001
  <35.650, -202.450, 221.300>
  color rgb <-0.651, 0.769, 1.867>
}

light_source { // AreaL002
  <-65.350, 87.200, 90.950>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source { // AreaL001
  <58.500, 87.000, 76.550>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
}




#declare Fish10 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow10 = union {
  sphere { // eyes18
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish10 }
  scale 0.7
  rotate 55.0*z
  translate  <91.450001, -57.700001, 56.700001>
}
#declare Fish9 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow9 = union {
  sphere { // eyes17
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish9 }
  scale 0.7
  rotate 55.0*z
  translate  <88.600001, -66.200001, 55.700001>
}
#declare Fish8 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow8 = union {
  sphere { // eyes16
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish8 }
  scale 0.7
  rotate 55.0*z
  translate  <93.100001, -66.850001, 50.550001>
}
#declare Fish7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow7 = union {
  sphere { // eyes15
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish7 }
  scale 0.7
  rotate 55.0*z
  translate  <96.500001, -57.150001, 53.700001>
}
#declare Fish = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow = union {
  sphere { // eyes
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish }
  scale 0.7
  rotate 55.0*z
  translate  <76.800001, -71.250001, 46.700001>
}
#declare Fish1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow1 = union {
  sphere { // eyes7
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish1 }
  scale 0.7
  rotate 55.0*z
  translate  <82.150001, -70.250001, 42.900001>
}
#declare Fish2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow2 = union {
  sphere { // eyes8
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish2 }
  scale 0.7
  rotate 55.0*z
  translate  <83.450001, -55.350001, 42.950001>
}
#declare Fish3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow3 = union {
  sphere { // eyes9
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish3 }
  scale 0.7
  rotate 55.0*z
  translate  <79.800001, -77.400001, 51.800001>
}
#declare Fish4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow4 = union {
  sphere { // eyes12
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish4 }
  scale 0.7
  rotate 55.0*z
  translate  <84.250001, -60.050001, 50.550001>
}
#declare Fish5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow5 = union {
  sphere { // eyes13
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish5 }
  scale 0.7
  rotate 55.0*z
  translate  <90.950001, -52.700001, 47.900001>
}
#declare Fish6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.178947, 0.000000, 0.505263>, <-2.178947, -0.200000, 0.505263>, <4.859501, -0.200000, 0.000394>, <4.859501, 0.000000, 0.000394>,
      <-0.578947, 0.000000, 2.589474>, <-0.578947, -0.157895, 2.589474>, <-0.843570, -0.157895, 2.000000>, <-0.843570, 0.000000, 2.000000>,
      <-0.410526, 0.000000, 3.747368>, <-0.410526, -0.280000, 3.747368>, <0.663158, -0.280000, 4.000000>, <0.663158, 0.000000, 4.000000>,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.859501, 0.000000, 0.000394>, <4.859501, 0.200000, 0.000394>, <-2.178947, 0.200000, 0.505263>, <-2.178947, 0.000000, 0.505263>,
      <-0.843570, 0.000000, 2.000000>, <-0.843570, 0.157895, 2.000000>, <-0.578947, 0.157895, 2.589474>, <-0.578947, 0.000000, 2.589474>,
      <0.663158, 0.000000, 4.000000>, <0.663158, 0.280000, 4.000000>, <-0.410526, 0.280000, 3.747368>, <-0.410526, 0.000000, 3.747368>,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957895, 0.000000, 6.000000>, <-0.957895, -0.687619, 6.000000>, <1.330261, -0.442884, 8.105263>, <1.330261, 0.001244, 8.105263>,
      <-1.505263, 0.000000, 8.252632>, <-1.505263, -1.095238, 8.252632>, <1.997365, -0.605767, 12.210526>, <1.997365, 0.002488, 12.210526>,
      <-1.926316, 0.000000, 10.505263>, <-1.926316, -1.173913, 10.505263>, <5.476320, 0.284322, 5.789474>, <5.476320, 0.035912, 5.789474>,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.330261, 0.001244, 8.105263>, <1.330261, 0.445371, 8.105263>, <-0.957895, 0.687619, 6.000000>, <-0.957895, 0.000000, 6.000000>,
      <1.997365, 0.002488, 12.210526>, <1.997365, 0.610742, 12.210526>, <-1.505263, 1.095238, 8.252632>, <-1.505263, 0.000000, 8.252632>,
      <5.476320, 0.035912, 5.789474>, <5.476320, -0.212498, 5.789474>, <-1.926316, 1.173913, 10.505263>, <-1.926316, 0.000000, 10.505263>,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.842105, 0.000000, 12.294737>, <-1.842105, -1.006957, 12.294737>, <3.490791, -0.277839, 9.010526>, <3.490791, 0.017956, 9.010526>,
      <-1.757895, 0.000000, 14.084211>, <-1.757895, -0.840000, 14.084211>, <1.505263, -0.840000, 12.231579>, <1.505263, 0.000000, 12.231579>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -0.619048, 16.000000>, <1.252632, -0.619048, 16.000000>, <1.252632, 0.000000, 16.000000>,
      <-0.253481, -0.004049, 17.915789>, <-0.253481, -0.047188, 17.915789>, <0.081011, -0.042524, 18.000000>, <0.081011, 0.000000, 18.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.490791, 0.017956, 9.010526>, <3.490791, 0.313751, 9.010526>, <-1.842105, 1.006957, 12.294737>, <-1.842105, 0.000000, 12.294737>,
      <1.505263, 0.000000, 12.231579>, <1.505263, 0.840000, 12.231579>, <-1.757895, 0.840000, 14.084211>, <-1.757895, 0.000000, 14.084211>,
      <1.252632, 0.000000, 16.000000>, <1.252632, 0.619048, 16.000000>, <-1.000000, 0.619048, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <0.081011, 0.000000, 18.000000>, <0.081011, 0.042524, 18.000000>, <-0.253481, 0.039090, 17.915789>, <-0.253481, -0.004049, 17.915789>
    }
  }
  texture {
    Fishy
  }
  rotate <0.0, -85.0, 0.0>
  translate  <-0.95, -10.8, 7.4>
}
#declare Minnow6 = union {
  sphere { // eyes14
    <0,0,0>,1
    texture {
      blackeye
    }
    scale <0.5, 0.7, 0.5>
    translate  <-15.6, -10.85, 9.0>
  }
  object { Fish6 }
  scale 0.7
  rotate 55.0*z
  translate  <72.000001, -72.450001, 54.600001>
}
union { // School
  object { Minnow10 }
  object { Minnow9 }
  object { Minnow8 }
  object { Minnow7 }
  object { Minnow }
  object { Minnow1 }
  object { Minnow2 }
  object { Minnow3 }
  object { Minnow4 }
  object { Minnow5 }
  object { Minnow6 }
  translate  <6.5, -36.550001, -37.550001>
}


union { // ropes
  cylinder { // Rope4
    <0,0,1>, <0,0,0>, 1
    texture {
      rope
    }
    scale <0.7, 1.0, 50.0>
    rotate <-21.509165, -15.588822, 11.089001>
    translate  <42.550001, 2.4, 0.0>
  }
  cylinder { // Rope3
    <0,0,1>, <0,0,0>, 1
    texture {
      rope
    }
    scale <0.7, 1.0, 50.0>
    rotate <12.275582, -20.539351, 12.164124>
    translate  <40.0, 35.0, 0.0>
  }
  cylinder { // Rope2
    <0,0,1>, <0,0,0>, 1
    texture {
      rope
    }
    scale <0.7, 1.0, 50.0>
    rotate <15.45468, 26.198484, -12.030968>
    translate  <5.0, 35.0, 0.0>
  }
  cylinder { // Rope1
    <0,0,1>, <0,0,0>, 1
    texture {
      rope
    }
    scale <0.7, 1.0, 50.0>
    rotate <-20.751474, 24.68194, -1.952436>
    translate  <4.85, 1.8, 0.0>
  }
  translate  39.5*z
}


#declare fin10 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058904, 0.000136, 0.000000>, <0.058904, -0.508329, 0.000000>, <0.007134, -0.924345, 0.000000>, <-0.056140, -0.924345, 0.000000>,
      <0.058904, 0.000136, 0.500000>, <0.058904, -0.508329, 0.500000>, <0.007134, -0.924345, 0.500000>, <-0.056140, -0.924345, 0.500000>,
      <-0.002523, -0.265855, 1.008597>, <0.012886, -0.535540, 0.845720>, <-0.018176, -0.756191, 0.719490>, <-0.056140, -0.756191, 0.719490>,
      <-0.319938, -1.101732, 1.480435>, <-0.318188, -1.105073, 1.481378>, <-0.318647, -1.107806, 1.482041>, <-0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, -0.924345, 0.000000>, <-0.119415, -0.924345, 0.000000>, <-0.171185, -0.508329, 0.000000>, <-0.171185, 0.000136, 0.000000>,
      <-0.056140, -0.924345, 0.500000>, <-0.119415, -0.924345, 0.500000>, <-0.171185, -0.508329, 0.500000>, <-0.171185, 0.000136, 0.500000>,
      <-0.056140, -0.756191, 0.719490>, <-0.094105, -0.756191, 0.719490>, <-0.125167, -0.535540, 0.845720>, <-0.139387, -0.265855, 0.995838>,
      <-0.320957, -1.107806, 1.481908>, <-0.323266, -1.107806, 1.481774>, <-0.326587, -1.105073, 1.480893>, <-0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.171185, 0.000136, 0.000000>, <-0.171185, 0.508600, 0.000000>, <-0.119415, 0.924616, 0.000000>, <-0.056140, 0.924616, 0.000000>,
      <-0.171185, 0.000136, 0.500000>, <-0.171185, 0.508600, 0.500000>, <-0.119415, 0.924616, 0.500000>, <-0.056140, 0.924616, 0.500000>,
      <-0.139387, -0.265855, 0.995838>, <-0.153607, 0.003829, 1.145955>, <-0.146412, 0.224481, 1.275751>, <-0.109102, 0.224481, 1.282769>,
      <-0.328336, -1.101732, 1.479949>, <-0.330085, -1.098391, 1.479005>, <-0.329627, -1.095658, 1.478343>, <-0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, 0.924616, 0.000000>, <0.007134, 0.924616, 0.000000>, <0.058904, 0.508600, 0.000000>, <0.058904, 0.000136, 0.000000>,
      <-0.056140, 0.924616, 0.500000>, <0.007134, 0.924616, 0.500000>, <0.058904, 0.508600, 0.500000>, <0.058904, 0.000136, 0.500000>,
      <-0.109102, 0.224481, 1.282769>, <-0.071791, 0.224481, 1.289786>, <-0.017932, 0.003829, 1.171473>, <-0.002523, -0.265855, 1.008597>,
      <-0.327317, -1.095658, 1.478476>, <-0.325007, -1.095658, 1.478610>, <-0.321687, -1.098391, 1.479491>, <-0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark1
  }
  rotate <90.0, 0.0, 69.0>
  translate  <0.589789, -0.168513, 5.68732>
}
#declare fin11 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.058904, 0.000136, 0.000000>, <-0.058904, -0.508329, 0.000000>, <-0.007134, -0.924345, 0.000000>, <0.056140, -0.924345, 0.000000>,
      <-0.058904, 0.000136, 0.500000>, <-0.058904, -0.508329, 0.500000>, <-0.007134, -0.924345, 0.500000>, <0.056140, -0.924345, 0.500000>,
      <0.002523, -0.265855, 1.008597>, <-0.012886, -0.535540, 0.845720>, <0.018176, -0.756191, 0.719490>, <0.056140, -0.756191, 0.719490>,
      <0.319938, -1.101732, 1.480435>, <0.318188, -1.105073, 1.481378>, <0.318647, -1.107806, 1.482041>, <0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, -0.924345, 0.000000>, <0.119415, -0.924345, 0.000000>, <0.171185, -0.508329, 0.000000>, <0.171185, 0.000136, 0.000000>,
      <0.056140, -0.924345, 0.500000>, <0.119415, -0.924345, 0.500000>, <0.171185, -0.508329, 0.500000>, <0.171185, 0.000136, 0.500000>,
      <0.056140, -0.756191, 0.719490>, <0.094105, -0.756191, 0.719490>, <0.125167, -0.535540, 0.845720>, <0.139387, -0.265855, 0.995838>,
      <0.320957, -1.107806, 1.481908>, <0.323266, -1.107806, 1.481774>, <0.326587, -1.105073, 1.480893>, <0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.171185, 0.000136, 0.000000>, <0.171185, 0.508600, 0.000000>, <0.119415, 0.924616, 0.000000>, <0.056140, 0.924616, 0.000000>,
      <0.171185, 0.000136, 0.500000>, <0.171185, 0.508600, 0.500000>, <0.119415, 0.924616, 0.500000>, <0.056140, 0.924616, 0.500000>,
      <0.139387, -0.265855, 0.995838>, <0.153607, 0.003829, 1.145955>, <0.146412, 0.224481, 1.275751>, <0.109102, 0.224481, 1.282769>,
      <0.328336, -1.101732, 1.479949>, <0.330085, -1.098391, 1.479005>, <0.329627, -1.095658, 1.478343>, <0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, 0.924616, 0.000000>, <-0.007134, 0.924616, 0.000000>, <-0.058904, 0.508600, 0.000000>, <-0.058904, 0.000136, 0.000000>,
      <0.056140, 0.924616, 0.500000>, <-0.007134, 0.924616, 0.500000>, <-0.058904, 0.508600, 0.500000>, <-0.058904, 0.000136, 0.500000>,
      <0.109102, 0.224481, 1.282769>, <0.071791, 0.224481, 1.289786>, <0.017932, 0.003829, 1.171473>, <0.002523, -0.265855, 1.008597>,
      <0.327317, -1.095658, 1.478476>, <0.325007, -1.095658, 1.478610>, <0.321687, -1.098391, 1.479491>, <0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark1
  }
  rotate <91.426125, -0.679647, -69.713715>
  translate  <-0.589796, -0.168513, 5.68732>
}
#declare BzPtch10 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.628646, 0.437354, 0.626763>, <-0.341841, -0.266226, 0.971255>, <-0.732102, -0.991635, 0.343749>, <-0.710961, -0.970571, 0.349419>,
      <-0.299710, 0.106917, 1.044977>, <-0.280987, -0.253647, 1.077739>, <-0.363086, -0.677174, 0.891473>, <-0.340652, -0.677174, 0.878652>,
      <-0.087701, 0.062892, 1.336903>, <-0.079540, -0.190755, 1.360699>, <0.001663, -0.231334, 1.532315>, <0.026104, -0.231334, 1.523933>,
      <-0.079798, 0.031446, 1.668451>, <-0.075718, -0.150066, 1.680350>, <-0.018940, -0.215101, 1.766157>, <0.013052, -0.215101, 1.761967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.710961, -0.970571, 0.349419>, <-0.689819, -0.949506, 0.355089>, <-0.260263, -0.266226, 0.924634>, <-0.563811, 0.437354, 0.563093>,
      <-0.340652, -0.677174, 0.878652>, <-0.318218, -0.677174, 0.865832>, <-0.199409, -0.253647, 1.031119>, <-0.218132, 0.106917, 0.998356>,
      <0.026104, -0.231334, 1.523933>, <0.050546, -0.231334, 1.515551>, <0.009339, -0.190755, 1.330220>, <0.001178, 0.062892, 1.306423>,
      <0.013052, -0.215101, 1.761967>, <0.045044, -0.215101, 1.757776>, <0.040617, -0.150066, 1.665110>, <0.036537, 0.031446, 1.653212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.563811, 0.437354, 0.563093>, <-0.867359, 1.140933, 0.201551>, <-1.508527, 2.288415, -0.132692>, <-1.511573, 2.288415, -0.127581>,
      <-0.218132, 0.106917, 0.998356>, <-0.236856, 0.467481, 0.965593>, <-1.137333, 2.112317, 0.088463>, <-1.140379, 2.112317, 0.093574>,
      <0.001178, 0.062892, 1.306423>, <-0.006983, 0.316539, 1.282627>, <-0.743094, 1.810435, 0.300196>, <-0.756320, 1.810435, 0.322394>,
      <0.036537, 0.031446, 1.653212>, <0.032456, 0.212958, 1.641313>, <-0.351776, 1.004651, 1.150098>, <-0.378160, 1.004651, 1.161197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.511573, 2.288415, -0.127581>, <-1.514618, 2.288415, -0.122469>, <-0.915451, 1.140933, 0.282271>, <-0.628646, 0.437354, 0.626763>,
      <-1.140379, 2.112317, 0.093574>, <-1.143424, 2.112317, 0.098686>, <-0.318434, 0.467481, 1.012214>, <-0.299710, 0.106917, 1.044977>,
      <-0.756320, 1.810435, 0.322394>, <-0.769545, 1.810435, 0.344592>, <-0.095862, 0.316539, 1.313106>, <-0.087701, 0.062892, 1.336903>,
      <-0.378160, 1.004651, 1.161197>, <-0.404544, 1.004651, 1.172296>, <-0.083878, 0.212958, 1.656553>, <-0.079798, 0.031446, 1.668451>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.079798, 0.031446, 1.668451>, <-0.075718, -0.150066, 1.680350>, <-0.018940, -0.215101, 1.766157>, <0.013052, -0.215101, 1.761967>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.013052, -0.215101, 1.761967>, <0.045044, -0.215101, 1.757776>, <0.040617, -0.150066, 1.665110>, <0.036537, 0.031446, 1.653212>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.036537, 0.031446, 1.653212>, <0.032456, 0.212958, 1.641313>, <-0.351776, 1.004651, 1.150098>, <-0.378160, 1.004651, 1.161197>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.378160, 1.004651, 1.161197>, <-0.404544, 1.004651, 1.172296>, <-0.083878, 0.212958, 1.656553>, <-0.079798, 0.031446, 1.668451>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.491292, 0.143418, 4.608143>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.492899, 0.143418, 4.608143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.492899, 0.143418, 4.608143>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000000, 0.714729, 4.628636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000000, 0.714729, 4.628636>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.491292, 0.143418, 4.608143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.491292, 0.143418, 4.608143>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.492899, 0.143418, 4.608143>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.492899, 0.143418, 4.608143>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000000, 0.714729, 4.628636>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.714729, 4.628636>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.491292, 0.143418, 4.608143>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    Shark1
  }
}
#declare body5 = union {
  object { fin10 }
  object { fin11 }
  object { BzPtch10 }
}
#declare Shark7 = difference {
  object { body5 }
  cylinder { // eyes10
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*y
    translate  <1.509286, 0.441903, 7.9655>
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare BzPtch11 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.046980, 0.437354, 0.459508>, <-0.046980, -0.266226, 0.918226>, <-0.005950, -0.991635, 0.189770>, <0.000000, -0.970571, 0.210834>,
      <-0.046980, 0.106917, 1.003138>, <-0.046980, -0.253647, 1.040873>, <-0.025839, -0.677174, 0.838417>, <0.000000, -0.677174, 0.838417>,
      <-0.046980, 0.062892, 1.314461>, <-0.046980, -0.190755, 1.339618>, <-0.025839, -0.231334, 1.528295>, <0.000000, -0.231334, 1.528295>,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.970571, 0.210834>, <0.005950, -0.949506, 0.231898>, <0.046980, -0.266226, 0.918226>, <0.046980, 0.437354, 0.459508>,
      <0.000000, -0.677174, 0.838417>, <0.025839, -0.677174, 0.838417>, <0.046980, -0.253647, 1.040873>, <0.046980, 0.106917, 1.003138>,
      <0.000000, -0.231334, 1.528295>, <0.025839, -0.231334, 1.528295>, <0.046980, -0.190755, 1.339618>, <0.046980, 0.062892, 1.314461>,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.046980, 0.437354, 0.459508>, <0.046980, 1.140933, 0.000790>, <0.005950, 2.288415, -0.721104>, <0.000000, 2.288415, -0.721104>,
      <0.046980, 0.106917, 1.003138>, <0.046980, 0.467481, 0.965402>, <0.005950, 2.112317, -0.289022>, <0.000000, 2.112317, -0.289022>,
      <0.046980, 0.062892, 1.314461>, <0.046980, 0.316539, 1.289304>, <0.025839, 1.810435, 0.158035>, <0.000000, 1.810435, 0.158035>,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.288415, -0.721104>, <-0.005950, 2.288415, -0.721104>, <-0.046980, 1.140933, 0.000790>, <-0.046980, 0.437354, 0.459508>,
      <0.000000, 2.112317, -0.289022>, <-0.005950, 2.112317, -0.289022>, <-0.046980, 0.467481, 0.965402>, <-0.046980, 0.106917, 1.003138>,
      <0.000000, 1.810435, 0.158035>, <-0.025839, 1.810435, 0.158035>, <-0.046980, 0.316539, 1.289304>, <-0.046980, 0.062892, 1.314461>,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    blackeyes1
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare sharkeyes4 = intersection {
  cylinder { // eyes11
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.5, 0.5, 15.0>
    rotate <90.0, 0.0, -55.0>
    translate  <116.27579, -186.746325, 62.159517>
  }
  object { BzPtch11 }
}
union { // Shark_5
  object { Shark7 }
  object { sharkeyes4 }
  rotate <-5.608039, -8.594135, -49.408745>
  translate  <139.600002, 212.600003, -66.600001>
}








#declare fin6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058904, 0.000136, 0.000000>, <0.058904, -0.508329, 0.000000>, <0.007134, -0.924345, 0.000000>, <-0.056140, -0.924345, 0.000000>,
      <0.058904, 0.000136, 0.500000>, <0.058904, -0.508329, 0.500000>, <0.007134, -0.924345, 0.500000>, <-0.056140, -0.924345, 0.500000>,
      <-0.002523, -0.265855, 1.008597>, <0.012886, -0.535540, 0.845720>, <-0.018176, -0.756191, 0.719490>, <-0.056140, -0.756191, 0.719490>,
      <-0.319938, -1.101732, 1.480435>, <-0.318188, -1.105073, 1.481378>, <-0.318647, -1.107806, 1.482041>, <-0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, -0.924345, 0.000000>, <-0.119415, -0.924345, 0.000000>, <-0.171185, -0.508329, 0.000000>, <-0.171185, 0.000136, 0.000000>,
      <-0.056140, -0.924345, 0.500000>, <-0.119415, -0.924345, 0.500000>, <-0.171185, -0.508329, 0.500000>, <-0.171185, 0.000136, 0.500000>,
      <-0.056140, -0.756191, 0.719490>, <-0.094105, -0.756191, 0.719490>, <-0.125167, -0.535540, 0.845720>, <-0.139387, -0.265855, 0.995838>,
      <-0.320957, -1.107806, 1.481908>, <-0.323266, -1.107806, 1.481774>, <-0.326587, -1.105073, 1.480893>, <-0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.171185, 0.000136, 0.000000>, <-0.171185, 0.508600, 0.000000>, <-0.119415, 0.924616, 0.000000>, <-0.056140, 0.924616, 0.000000>,
      <-0.171185, 0.000136, 0.500000>, <-0.171185, 0.508600, 0.500000>, <-0.119415, 0.924616, 0.500000>, <-0.056140, 0.924616, 0.500000>,
      <-0.139387, -0.265855, 0.995838>, <-0.153607, 0.003829, 1.145955>, <-0.146412, 0.224481, 1.275751>, <-0.109102, 0.224481, 1.282769>,
      <-0.328336, -1.101732, 1.479949>, <-0.330085, -1.098391, 1.479005>, <-0.329627, -1.095658, 1.478343>, <-0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, 0.924616, 0.000000>, <0.007134, 0.924616, 0.000000>, <0.058904, 0.508600, 0.000000>, <0.058904, 0.000136, 0.000000>,
      <-0.056140, 0.924616, 0.500000>, <0.007134, 0.924616, 0.500000>, <0.058904, 0.508600, 0.500000>, <0.058904, 0.000136, 0.500000>,
      <-0.109102, 0.224481, 1.282769>, <-0.071791, 0.224481, 1.289786>, <-0.017932, 0.003829, 1.171473>, <-0.002523, -0.265855, 1.008597>,
      <-0.327317, -1.095658, 1.478476>, <-0.325007, -1.095658, 1.478610>, <-0.321687, -1.098391, 1.479491>, <-0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark3
  }
  rotate <90.0, 0.0, 69.0>
  translate  <0.589789, -0.168513, 5.68732>
}
#declare fin7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.058904, 0.000136, 0.000000>, <-0.058904, -0.508329, 0.000000>, <-0.007134, -0.924345, 0.000000>, <0.056140, -0.924345, 0.000000>,
      <-0.058904, 0.000136, 0.500000>, <-0.058904, -0.508329, 0.500000>, <-0.007134, -0.924345, 0.500000>, <0.056140, -0.924345, 0.500000>,
      <0.002523, -0.265855, 1.008597>, <-0.012886, -0.535540, 0.845720>, <0.018176, -0.756191, 0.719490>, <0.056140, -0.756191, 0.719490>,
      <0.319938, -1.101732, 1.480435>, <0.318188, -1.105073, 1.481378>, <0.318647, -1.107806, 1.482041>, <0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, -0.924345, 0.000000>, <0.119415, -0.924345, 0.000000>, <0.171185, -0.508329, 0.000000>, <0.171185, 0.000136, 0.000000>,
      <0.056140, -0.924345, 0.500000>, <0.119415, -0.924345, 0.500000>, <0.171185, -0.508329, 0.500000>, <0.171185, 0.000136, 0.500000>,
      <0.056140, -0.756191, 0.719490>, <0.094105, -0.756191, 0.719490>, <0.125167, -0.535540, 0.845720>, <0.139387, -0.265855, 0.995838>,
      <0.320957, -1.107806, 1.481908>, <0.323266, -1.107806, 1.481774>, <0.326587, -1.105073, 1.480893>, <0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.171185, 0.000136, 0.000000>, <0.171185, 0.508600, 0.000000>, <0.119415, 0.924616, 0.000000>, <0.056140, 0.924616, 0.000000>,
      <0.171185, 0.000136, 0.500000>, <0.171185, 0.508600, 0.500000>, <0.119415, 0.924616, 0.500000>, <0.056140, 0.924616, 0.500000>,
      <0.139387, -0.265855, 0.995838>, <0.153607, 0.003829, 1.145955>, <0.146412, 0.224481, 1.275751>, <0.109102, 0.224481, 1.282769>,
      <0.328336, -1.101732, 1.479949>, <0.330085, -1.098391, 1.479005>, <0.329627, -1.095658, 1.478343>, <0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, 0.924616, 0.000000>, <-0.007134, 0.924616, 0.000000>, <-0.058904, 0.508600, 0.000000>, <-0.058904, 0.000136, 0.000000>,
      <0.056140, 0.924616, 0.500000>, <-0.007134, 0.924616, 0.500000>, <-0.058904, 0.508600, 0.500000>, <-0.058904, 0.000136, 0.500000>,
      <0.109102, 0.224481, 1.282769>, <0.071791, 0.224481, 1.289786>, <0.017932, 0.003829, 1.171473>, <0.002523, -0.265855, 1.008597>,
      <0.327317, -1.095658, 1.478476>, <0.325007, -1.095658, 1.478610>, <0.321687, -1.098391, 1.479491>, <0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark3
  }
  rotate <91.426125, -0.679647, -69.713715>
  translate  <-0.589796, -0.168513, 5.68732>
}
#declare BzPtch6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.046980, 0.437354, 0.459508>, <-0.046980, -0.266226, 0.918226>, <-0.005950, -0.991635, 0.189770>, <0.000000, -0.970571, 0.210834>,
      <-0.046980, 0.106917, 1.003138>, <-0.046980, -0.253647, 1.040873>, <-0.025839, -0.677174, 0.838417>, <0.000000, -0.677174, 0.838417>,
      <-0.046980, 0.062892, 1.314461>, <-0.046980, -0.190755, 1.339618>, <-0.025839, -0.231334, 1.528295>, <0.000000, -0.231334, 1.528295>,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.970571, 0.210834>, <0.005950, -0.949506, 0.231898>, <0.046980, -0.266226, 0.918226>, <0.046980, 0.437354, 0.459508>,
      <0.000000, -0.677174, 0.838417>, <0.025839, -0.677174, 0.838417>, <0.046980, -0.253647, 1.040873>, <0.046980, 0.106917, 1.003138>,
      <0.000000, -0.231334, 1.528295>, <0.025839, -0.231334, 1.528295>, <0.046980, -0.190755, 1.339618>, <0.046980, 0.062892, 1.314461>,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.046980, 0.437354, 0.459508>, <0.046980, 1.140933, 0.000790>, <0.005950, 2.288415, -0.721104>, <0.000000, 2.288415, -0.721104>,
      <0.046980, 0.106917, 1.003138>, <0.046980, 0.467481, 0.965402>, <0.005950, 2.112317, -0.289022>, <0.000000, 2.112317, -0.289022>,
      <0.046980, 0.062892, 1.314461>, <0.046980, 0.316539, 1.289304>, <0.025839, 1.810435, 0.158035>, <0.000000, 1.810435, 0.158035>,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.288415, -0.721104>, <-0.005950, 2.288415, -0.721104>, <-0.046980, 1.140933, 0.000790>, <-0.046980, 0.437354, 0.459508>,
      <0.000000, 2.112317, -0.289022>, <-0.005950, 2.112317, -0.289022>, <-0.046980, 0.467481, 0.965402>, <-0.046980, 0.106917, 1.003138>,
      <0.000000, 1.810435, 0.158035>, <-0.025839, 1.810435, 0.158035>, <-0.046980, 0.316539, 1.289304>, <-0.046980, 0.062892, 1.314461>,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    Shark3
  }
}
#declare body2 = union {
  object { fin6 }
  object { fin7 }
  object { BzPtch6 }
}
#declare Shark4 = difference {
  object { body2 }
  cylinder { // eyes5
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*y
    translate  <1.509286, 0.441903, 7.9655>
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare BzPtch7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.046980, 0.437354, 0.459508>, <-0.046980, -0.266226, 0.918226>, <-0.005950, -0.991635, 0.189770>, <0.000000, -0.970571, 0.210834>,
      <-0.046980, 0.106917, 1.003138>, <-0.046980, -0.253647, 1.040873>, <-0.025839, -0.677174, 0.838417>, <0.000000, -0.677174, 0.838417>,
      <-0.046980, 0.062892, 1.314461>, <-0.046980, -0.190755, 1.339618>, <-0.025839, -0.231334, 1.528295>, <0.000000, -0.231334, 1.528295>,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.970571, 0.210834>, <0.005950, -0.949506, 0.231898>, <0.046980, -0.266226, 0.918226>, <0.046980, 0.437354, 0.459508>,
      <0.000000, -0.677174, 0.838417>, <0.025839, -0.677174, 0.838417>, <0.046980, -0.253647, 1.040873>, <0.046980, 0.106917, 1.003138>,
      <0.000000, -0.231334, 1.528295>, <0.025839, -0.231334, 1.528295>, <0.046980, -0.190755, 1.339618>, <0.046980, 0.062892, 1.314461>,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.046980, 0.437354, 0.459508>, <0.046980, 1.140933, 0.000790>, <0.005950, 2.288415, -0.721104>, <0.000000, 2.288415, -0.721104>,
      <0.046980, 0.106917, 1.003138>, <0.046980, 0.467481, 0.965402>, <0.005950, 2.112317, -0.289022>, <0.000000, 2.112317, -0.289022>,
      <0.046980, 0.062892, 1.314461>, <0.046980, 0.316539, 1.289304>, <0.025839, 1.810435, 0.158035>, <0.000000, 1.810435, 0.158035>,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.288415, -0.721104>, <-0.005950, 2.288415, -0.721104>, <-0.046980, 1.140933, 0.000790>, <-0.046980, 0.437354, 0.459508>,
      <0.000000, 2.112317, -0.289022>, <-0.005950, 2.112317, -0.289022>, <-0.046980, 0.467481, 0.965402>, <-0.046980, 0.106917, 1.003138>,
      <0.000000, 1.810435, 0.158035>, <-0.025839, 1.810435, 0.158035>, <-0.046980, 0.316539, 1.289304>, <-0.046980, 0.062892, 1.314461>,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    blackeyes1
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare sharkeyes2 = intersection {
  cylinder { // eyes6
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.5, 0.5, 15.0>
    rotate <90.0, 0.0, -55.0>
    translate  <116.27579, -186.746325, 62.159517>
  }
  object { BzPtch7 }
}
union { // Shark_3
  object { Shark4 }
  object { sharkeyes2 }
  rotate -30.0*z
  translate  <-50.100001, 222.000003, -21.9>
}


#declare fin4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058904, 0.000136, 0.000000>, <0.058904, -0.508329, 0.000000>, <0.007134, -0.924345, 0.000000>, <-0.056140, -0.924345, 0.000000>,
      <0.058904, 0.000136, 0.500000>, <0.058904, -0.508329, 0.500000>, <0.007134, -0.924345, 0.500000>, <-0.056140, -0.924345, 0.500000>,
      <-0.002523, -0.265855, 1.008597>, <0.012886, -0.535540, 0.845720>, <-0.018176, -0.756191, 0.719490>, <-0.056140, -0.756191, 0.719490>,
      <-0.319938, -1.101732, 1.480435>, <-0.318188, -1.105073, 1.481378>, <-0.318647, -1.107806, 1.482041>, <-0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, -0.924345, 0.000000>, <-0.119415, -0.924345, 0.000000>, <-0.171185, -0.508329, 0.000000>, <-0.171185, 0.000136, 0.000000>,
      <-0.056140, -0.924345, 0.500000>, <-0.119415, -0.924345, 0.500000>, <-0.171185, -0.508329, 0.500000>, <-0.171185, 0.000136, 0.500000>,
      <-0.056140, -0.756191, 0.719490>, <-0.094105, -0.756191, 0.719490>, <-0.125167, -0.535540, 0.845720>, <-0.139387, -0.265855, 0.995838>,
      <-0.320957, -1.107806, 1.481908>, <-0.323266, -1.107806, 1.481774>, <-0.326587, -1.105073, 1.480893>, <-0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.171185, 0.000136, 0.000000>, <-0.171185, 0.508600, 0.000000>, <-0.119415, 0.924616, 0.000000>, <-0.056140, 0.924616, 0.000000>,
      <-0.171185, 0.000136, 0.500000>, <-0.171185, 0.508600, 0.500000>, <-0.119415, 0.924616, 0.500000>, <-0.056140, 0.924616, 0.500000>,
      <-0.139387, -0.265855, 0.995838>, <-0.153607, 0.003829, 1.145955>, <-0.146412, 0.224481, 1.275751>, <-0.109102, 0.224481, 1.282769>,
      <-0.328336, -1.101732, 1.479949>, <-0.330085, -1.098391, 1.479005>, <-0.329627, -1.095658, 1.478343>, <-0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, 0.924616, 0.000000>, <0.007134, 0.924616, 0.000000>, <0.058904, 0.508600, 0.000000>, <0.058904, 0.000136, 0.000000>,
      <-0.056140, 0.924616, 0.500000>, <0.007134, 0.924616, 0.500000>, <0.058904, 0.508600, 0.500000>, <0.058904, 0.000136, 0.500000>,
      <-0.109102, 0.224481, 1.282769>, <-0.071791, 0.224481, 1.289786>, <-0.017932, 0.003829, 1.171473>, <-0.002523, -0.265855, 1.008597>,
      <-0.327317, -1.095658, 1.478476>, <-0.325007, -1.095658, 1.478610>, <-0.321687, -1.098391, 1.479491>, <-0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark3
  }
  rotate <90.0, 0.0, 69.0>
  translate  <0.589789, -0.168513, 5.68732>
}
#declare fin5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.058904, 0.000136, 0.000000>, <-0.058904, -0.508329, 0.000000>, <-0.007134, -0.924345, 0.000000>, <0.056140, -0.924345, 0.000000>,
      <-0.058904, 0.000136, 0.500000>, <-0.058904, -0.508329, 0.500000>, <-0.007134, -0.924345, 0.500000>, <0.056140, -0.924345, 0.500000>,
      <0.002523, -0.265855, 1.008597>, <-0.012886, -0.535540, 0.845720>, <0.018176, -0.756191, 0.719490>, <0.056140, -0.756191, 0.719490>,
      <0.319938, -1.101732, 1.480435>, <0.318188, -1.105073, 1.481378>, <0.318647, -1.107806, 1.482041>, <0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, -0.924345, 0.000000>, <0.119415, -0.924345, 0.000000>, <0.171185, -0.508329, 0.000000>, <0.171185, 0.000136, 0.000000>,
      <0.056140, -0.924345, 0.500000>, <0.119415, -0.924345, 0.500000>, <0.171185, -0.508329, 0.500000>, <0.171185, 0.000136, 0.500000>,
      <0.056140, -0.756191, 0.719490>, <0.094105, -0.756191, 0.719490>, <0.125167, -0.535540, 0.845720>, <0.139387, -0.265855, 0.995838>,
      <0.320957, -1.107806, 1.481908>, <0.323266, -1.107806, 1.481774>, <0.326587, -1.105073, 1.480893>, <0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.171185, 0.000136, 0.000000>, <0.171185, 0.508600, 0.000000>, <0.119415, 0.924616, 0.000000>, <0.056140, 0.924616, 0.000000>,
      <0.171185, 0.000136, 0.500000>, <0.171185, 0.508600, 0.500000>, <0.119415, 0.924616, 0.500000>, <0.056140, 0.924616, 0.500000>,
      <0.139387, -0.265855, 0.995838>, <0.153607, 0.003829, 1.145955>, <0.146412, 0.224481, 1.275751>, <0.109102, 0.224481, 1.282769>,
      <0.328336, -1.101732, 1.479949>, <0.330085, -1.098391, 1.479005>, <0.329627, -1.095658, 1.478343>, <0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, 0.924616, 0.000000>, <-0.007134, 0.924616, 0.000000>, <-0.058904, 0.508600, 0.000000>, <-0.058904, 0.000136, 0.000000>,
      <0.056140, 0.924616, 0.500000>, <-0.007134, 0.924616, 0.500000>, <-0.058904, 0.508600, 0.500000>, <-0.058904, 0.000136, 0.500000>,
      <0.109102, 0.224481, 1.282769>, <0.071791, 0.224481, 1.289786>, <0.017932, 0.003829, 1.171473>, <0.002523, -0.265855, 1.008597>,
      <0.327317, -1.095658, 1.478476>, <0.325007, -1.095658, 1.478610>, <0.321687, -1.098391, 1.479491>, <0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark3
  }
  rotate <91.426125, -0.679647, -69.713715>
  translate  <-0.589796, -0.168513, 5.68732>
}
#declare BzPtch4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.046980, 0.437354, 0.459508>, <-0.046980, -0.266226, 0.918226>, <-0.005950, -0.991635, 0.189770>, <0.000000, -0.970571, 0.210834>,
      <-0.046980, 0.106917, 1.003138>, <-0.046980, -0.253647, 1.040873>, <-0.025839, -0.677174, 0.838417>, <0.000000, -0.677174, 0.838417>,
      <-0.046980, 0.062892, 1.314461>, <-0.046980, -0.190755, 1.339618>, <-0.025839, -0.231334, 1.528295>, <0.000000, -0.231334, 1.528295>,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.970571, 0.210834>, <0.005950, -0.949506, 0.231898>, <0.046980, -0.266226, 0.918226>, <0.046980, 0.437354, 0.459508>,
      <0.000000, -0.677174, 0.838417>, <0.025839, -0.677174, 0.838417>, <0.046980, -0.253647, 1.040873>, <0.046980, 0.106917, 1.003138>,
      <0.000000, -0.231334, 1.528295>, <0.025839, -0.231334, 1.528295>, <0.046980, -0.190755, 1.339618>, <0.046980, 0.062892, 1.314461>,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.046980, 0.437354, 0.459508>, <0.046980, 1.140933, 0.000790>, <0.005950, 2.288415, -0.721104>, <0.000000, 2.288415, -0.721104>,
      <0.046980, 0.106917, 1.003138>, <0.046980, 0.467481, 0.965402>, <0.005950, 2.112317, -0.289022>, <0.000000, 2.112317, -0.289022>,
      <0.046980, 0.062892, 1.314461>, <0.046980, 0.316539, 1.289304>, <0.025839, 1.810435, 0.158035>, <0.000000, 1.810435, 0.158035>,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.288415, -0.721104>, <-0.005950, 2.288415, -0.721104>, <-0.046980, 1.140933, 0.000790>, <-0.046980, 0.437354, 0.459508>,
      <0.000000, 2.112317, -0.289022>, <-0.005950, 2.112317, -0.289022>, <-0.046980, 0.467481, 0.965402>, <-0.046980, 0.106917, 1.003138>,
      <0.000000, 1.810435, 0.158035>, <-0.025839, 1.810435, 0.158035>, <-0.046980, 0.316539, 1.289304>, <-0.046980, 0.062892, 1.314461>,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    Shark3
  }
}
#declare body1 = union {
  object { fin4 }
  object { fin5 }
  object { BzPtch4 }
}
#declare Shark2 = difference {
  object { body1 }
  cylinder { // eyes3
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*y
    translate  <1.509286, 0.441903, 7.9655>
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare BzPtch5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.046980, 0.437354, 0.459508>, <-0.046980, -0.266226, 0.918226>, <-0.005950, -0.991635, 0.189770>, <0.000000, -0.970571, 0.210834>,
      <-0.046980, 0.106917, 1.003138>, <-0.046980, -0.253647, 1.040873>, <-0.025839, -0.677174, 0.838417>, <0.000000, -0.677174, 0.838417>,
      <-0.046980, 0.062892, 1.314461>, <-0.046980, -0.190755, 1.339618>, <-0.025839, -0.231334, 1.528295>, <0.000000, -0.231334, 1.528295>,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.970571, 0.210834>, <0.005950, -0.949506, 0.231898>, <0.046980, -0.266226, 0.918226>, <0.046980, 0.437354, 0.459508>,
      <0.000000, -0.677174, 0.838417>, <0.025839, -0.677174, 0.838417>, <0.046980, -0.253647, 1.040873>, <0.046980, 0.106917, 1.003138>,
      <0.000000, -0.231334, 1.528295>, <0.025839, -0.231334, 1.528295>, <0.046980, -0.190755, 1.339618>, <0.046980, 0.062892, 1.314461>,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.046980, 0.437354, 0.459508>, <0.046980, 1.140933, 0.000790>, <0.005950, 2.288415, -0.721104>, <0.000000, 2.288415, -0.721104>,
      <0.046980, 0.106917, 1.003138>, <0.046980, 0.467481, 0.965402>, <0.005950, 2.112317, -0.289022>, <0.000000, 2.112317, -0.289022>,
      <0.046980, 0.062892, 1.314461>, <0.046980, 0.316539, 1.289304>, <0.025839, 1.810435, 0.158035>, <0.000000, 1.810435, 0.158035>,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.288415, -0.721104>, <-0.005950, 2.288415, -0.721104>, <-0.046980, 1.140933, 0.000790>, <-0.046980, 0.437354, 0.459508>,
      <0.000000, 2.112317, -0.289022>, <-0.005950, 2.112317, -0.289022>, <-0.046980, 0.467481, 0.965402>, <-0.046980, 0.106917, 1.003138>,
      <0.000000, 1.810435, 0.158035>, <-0.025839, 1.810435, 0.158035>, <-0.046980, 0.316539, 1.289304>, <-0.046980, 0.062892, 1.314461>,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    blackeyes1
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare sharkeyes1 = intersection {
  cylinder { // eyes4
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.5, 0.5, 15.0>
    rotate <90.0, 0.0, -55.0>
    translate  <116.27579, -186.746325, 62.159517>
  }
  object { BzPtch5 }
}
union { // Shark_2
  object { Shark2 }
  object { sharkeyes1 }
  rotate 40.0*z
  translate  <-223.000003, 14.5, -41.900001>
}


#declare fin2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058904, 0.000136, 0.000000>, <0.058904, -0.508329, 0.000000>, <0.007134, -0.924345, 0.000000>, <-0.056140, -0.924345, 0.000000>,
      <0.058904, 0.000136, 0.500000>, <0.058904, -0.508329, 0.500000>, <0.007134, -0.924345, 0.500000>, <-0.056140, -0.924345, 0.500000>,
      <-0.002523, -0.265855, 1.008597>, <0.012886, -0.535540, 0.845720>, <-0.018176, -0.756191, 0.719490>, <-0.056140, -0.756191, 0.719490>,
      <-0.319938, -1.101732, 1.480435>, <-0.318188, -1.105073, 1.481378>, <-0.318647, -1.107806, 1.482041>, <-0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, -0.924345, 0.000000>, <-0.119415, -0.924345, 0.000000>, <-0.171185, -0.508329, 0.000000>, <-0.171185, 0.000136, 0.000000>,
      <-0.056140, -0.924345, 0.500000>, <-0.119415, -0.924345, 0.500000>, <-0.171185, -0.508329, 0.500000>, <-0.171185, 0.000136, 0.500000>,
      <-0.056140, -0.756191, 0.719490>, <-0.094105, -0.756191, 0.719490>, <-0.125167, -0.535540, 0.845720>, <-0.139387, -0.265855, 0.995838>,
      <-0.320957, -1.107806, 1.481908>, <-0.323266, -1.107806, 1.481774>, <-0.326587, -1.105073, 1.480893>, <-0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.171185, 0.000136, 0.000000>, <-0.171185, 0.508600, 0.000000>, <-0.119415, 0.924616, 0.000000>, <-0.056140, 0.924616, 0.000000>,
      <-0.171185, 0.000136, 0.500000>, <-0.171185, 0.508600, 0.500000>, <-0.119415, 0.924616, 0.500000>, <-0.056140, 0.924616, 0.500000>,
      <-0.139387, -0.265855, 0.995838>, <-0.153607, 0.003829, 1.145955>, <-0.146412, 0.224481, 1.275751>, <-0.109102, 0.224481, 1.282769>,
      <-0.328336, -1.101732, 1.479949>, <-0.330085, -1.098391, 1.479005>, <-0.329627, -1.095658, 1.478343>, <-0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.056140, 0.924616, 0.000000>, <0.007134, 0.924616, 0.000000>, <0.058904, 0.508600, 0.000000>, <0.058904, 0.000136, 0.000000>,
      <-0.056140, 0.924616, 0.500000>, <0.007134, 0.924616, 0.500000>, <0.058904, 0.508600, 0.500000>, <0.058904, 0.000136, 0.500000>,
      <-0.109102, 0.224481, 1.282769>, <-0.071791, 0.224481, 1.289786>, <-0.017932, 0.003829, 1.171473>, <-0.002523, -0.265855, 1.008597>,
      <-0.327317, -1.095658, 1.478476>, <-0.325007, -1.095658, 1.478610>, <-0.321687, -1.098391, 1.479491>, <-0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark3
  }
  rotate <90.0, 0.0, 69.0>
  translate  <0.589789, -0.168513, 5.68732>
}
#declare fin3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.058904, 0.000136, 0.000000>, <-0.058904, -0.508329, 0.000000>, <-0.007134, -0.924345, 0.000000>, <0.056140, -0.924345, 0.000000>,
      <-0.058904, 0.000136, 0.500000>, <-0.058904, -0.508329, 0.500000>, <-0.007134, -0.924345, 0.500000>, <0.056140, -0.924345, 0.500000>,
      <0.002523, -0.265855, 1.008597>, <-0.012886, -0.535540, 0.845720>, <0.018176, -0.756191, 0.719490>, <0.056140, -0.756191, 0.719490>,
      <0.319938, -1.101732, 1.480435>, <0.318188, -1.105073, 1.481378>, <0.318647, -1.107806, 1.482041>, <0.320957, -1.107806, 1.481908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, -0.924345, 0.000000>, <0.119415, -0.924345, 0.000000>, <0.171185, -0.508329, 0.000000>, <0.171185, 0.000136, 0.000000>,
      <0.056140, -0.924345, 0.500000>, <0.119415, -0.924345, 0.500000>, <0.171185, -0.508329, 0.500000>, <0.171185, 0.000136, 0.500000>,
      <0.056140, -0.756191, 0.719490>, <0.094105, -0.756191, 0.719490>, <0.125167, -0.535540, 0.845720>, <0.139387, -0.265855, 0.995838>,
      <0.320957, -1.107806, 1.481908>, <0.323266, -1.107806, 1.481774>, <0.326587, -1.105073, 1.480893>, <0.328336, -1.101732, 1.479949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.171185, 0.000136, 0.000000>, <0.171185, 0.508600, 0.000000>, <0.119415, 0.924616, 0.000000>, <0.056140, 0.924616, 0.000000>,
      <0.171185, 0.000136, 0.500000>, <0.171185, 0.508600, 0.500000>, <0.119415, 0.924616, 0.500000>, <0.056140, 0.924616, 0.500000>,
      <0.139387, -0.265855, 0.995838>, <0.153607, 0.003829, 1.145955>, <0.146412, 0.224481, 1.275751>, <0.109102, 0.224481, 1.282769>,
      <0.328336, -1.101732, 1.479949>, <0.330085, -1.098391, 1.479005>, <0.329627, -1.095658, 1.478343>, <0.327317, -1.095658, 1.478476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056140, 0.924616, 0.000000>, <-0.007134, 0.924616, 0.000000>, <-0.058904, 0.508600, 0.000000>, <-0.058904, 0.000136, 0.000000>,
      <0.056140, 0.924616, 0.500000>, <-0.007134, 0.924616, 0.500000>, <-0.058904, 0.508600, 0.500000>, <-0.058904, 0.000136, 0.500000>,
      <0.109102, 0.224481, 1.282769>, <0.071791, 0.224481, 1.289786>, <0.017932, 0.003829, 1.171473>, <0.002523, -0.265855, 1.008597>,
      <0.327317, -1.095658, 1.478476>, <0.325007, -1.095658, 1.478610>, <0.321687, -1.098391, 1.479491>, <0.319938, -1.101732, 1.480435>
    }
  }
  texture {
    Shark3
  }
  rotate <91.426125, -0.679647, -69.713715>
  translate  <-0.589796, -0.168513, 5.68732>
}
#declare BzPtch2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.163043, 0.437354, 0.590115>, <1.751766, -0.266226, 0.793274>, <2.423057, -0.991635, 0.507438>, <2.406806, -0.970571, 0.522102>,
      <1.675636, 0.106917, 0.830879>, <1.641804, -0.253647, 0.847592>, <1.832684, -0.677174, 0.776882>, <1.844128, -0.677174, 0.800048>,
      <1.184783, 0.062892, 1.122986>, <1.168957, -0.190755, 1.142541>, <1.066696, -0.231334, 1.302505>, <1.086782, -0.231334, 1.318760>,
      <0.959467, 0.031446, 1.381594>, <0.951554, -0.150066, 1.391372>, <0.912997, -0.215101, 1.481530>, <0.938409, -0.215101, 1.502096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.406806, -0.970571, 0.522102>, <2.390556, -0.949506, 0.536765>, <1.793379, -0.266226, 0.877516>, <2.204656, 0.437354, 0.674357>,
      <1.844128, -0.677174, 0.800048>, <1.855572, -0.677174, 0.823215>, <1.683417, -0.253647, 0.931834>, <1.717250, 0.106917, 0.915122>,
      <1.086782, -0.231334, 1.318760>, <1.106867, -0.231334, 1.335015>, <1.241995, -0.190755, 1.201650>, <1.257821, 0.062892, 1.182095>,
      <0.938409, -0.215101, 1.502096>, <0.963820, -0.215101, 1.522661>, <1.043959, -0.150066, 1.466155>, <1.051872, 0.031446, 1.456377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.204656, 0.437354, 0.674357>, <2.615933, 1.140933, 0.471198>, <3.244997, 2.288415, 0.114696>, <3.242362, 2.288415, 0.109361>,
      <1.717250, 0.106917, 0.915122>, <1.751082, 0.467481, 0.898409>, <2.857602, 2.112317, 0.306058>, <2.854967, 2.112317, 0.300723>,
      <1.257821, 0.062892, 1.182095>, <1.273647, 0.316539, 1.162539>, <2.465588, 1.810435, 0.521884>, <2.454145, 1.810435, 0.498718>,
      <1.051872, 0.031446, 1.456377>, <1.059785, 0.212958, 1.446600>, <1.643181, 1.004651, 1.116096>, <1.622090, 1.004651, 1.092075>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.242362, 2.288415, 0.109361>, <3.239727, 2.288415, 0.104027>, <2.574320, 1.140933, 0.386956>, <2.163043, 0.437354, 0.590115>,
      <2.854967, 2.112317, 0.300723>, <2.852332, 2.112317, 0.295389>, <1.709469, 0.467481, 0.814167>, <1.675636, 0.106917, 0.830879>,
      <2.454145, 1.810435, 0.498718>, <2.442701, 1.810435, 0.475551>, <1.200609, 0.316539, 1.103430>, <1.184783, 0.062892, 1.122986>,
      <1.622090, 1.004651, 1.092075>, <1.601000, 1.004651, 1.068053>, <0.967379, 0.212958, 1.371816>, <0.959467, 0.031446, 1.381594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.959467, 0.031446, 1.381594>, <0.951554, -0.150066, 1.391372>, <0.912997, -0.215101, 1.481530>, <0.938409, -0.215101, 1.502096>,
      <0.734150, 0.000000, 1.640203>, <0.734150, -0.109377, 1.640203>, <0.759299, -0.198868, 1.660555>, <0.790036, -0.198868, 1.685431>,
      <0.373633, 0.000000, 1.991665>, <0.373633, -0.166836, 1.991665>, <0.419469, -0.303339, 2.028759>, <0.475491, -0.303339, 2.074097>,
      <0.076359, 0.000000, 2.569874>, <0.076359, -0.211544, 2.569874>, <0.169666, -0.384625, 2.617063>, <0.283708, -0.384625, 2.674739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.938409, -0.215101, 1.502096>, <0.963820, -0.215101, 1.522661>, <1.043959, -0.150066, 1.466155>, <1.051872, 0.031446, 1.456377>,
      <0.790036, -0.198868, 1.685431>, <0.820774, -0.198868, 1.710307>, <0.845923, -0.109377, 1.730660>, <0.845923, 0.000000, 1.730660>,
      <0.475491, -0.303339, 2.074097>, <0.531512, -0.303339, 2.119435>, <0.577348, -0.166836, 2.156530>, <0.577348, 0.000000, 2.156530>,
      <0.283708, -0.384625, 2.674739>, <0.397750, -0.384625, 2.732415>, <0.491057, -0.211544, 2.779605>, <0.491057, 0.000000, 2.779605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.051872, 0.031446, 1.456377>, <1.059785, 0.212958, 1.446600>, <1.643181, 1.004651, 1.116096>, <1.622090, 1.004651, 1.092075>,
      <0.845923, 0.000000, 1.730660>, <0.845923, 0.109377, 1.730660>, <0.820774, 0.198868, 1.710307>, <0.790036, 0.198868, 1.685431>,
      <0.577348, 0.000000, 2.156530>, <0.577348, 0.166836, 2.156530>, <0.531512, 0.303339, 2.119435>, <0.475491, 0.303339, 2.074097>,
      <0.491057, 0.000000, 2.779605>, <0.491057, 0.211544, 2.779605>, <0.397750, 0.384625, 2.732415>, <0.283708, 0.384625, 2.674739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.622090, 1.004651, 1.092075>, <1.601000, 1.004651, 1.068053>, <0.967379, 0.212958, 1.371816>, <0.959467, 0.031446, 1.381594>,
      <0.790036, 0.198868, 1.685431>, <0.759299, 0.198868, 1.660555>, <0.734150, 0.109377, 1.640203>, <0.734150, 0.000000, 1.640203>,
      <0.475491, 0.303339, 2.074097>, <0.419469, 0.303339, 2.028759>, <0.373633, 0.166836, 1.991665>, <0.373633, 0.000000, 1.991665>,
      <0.283708, 0.384625, 2.674739>, <0.169666, 0.384625, 2.617063>, <0.076359, 0.211544, 2.569874>, <0.076359, 0.000000, 2.569874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.076359, 0.000000, 2.569874>, <0.076359, -0.211544, 2.569874>, <0.169666, -0.384625, 2.617063>, <0.283708, -0.384625, 2.674739>,
      <-0.220915, 0.000000, 3.148083>, <-0.220915, -0.256251, 3.148083>, <-0.080137, -0.465912, 3.205367>, <0.091925, -0.465912, 3.275382>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.491292, 0.143418, 4.608143>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.283708, -0.384625, 2.674739>, <0.397750, -0.384625, 2.732415>, <0.491057, -0.211544, 2.779605>, <0.491057, 0.000000, 2.779605>,
      <0.091925, -0.465912, 3.275382>, <0.263987, -0.465912, 3.345396>, <0.404765, -0.256251, 3.402680>, <0.404765, 0.000000, 3.402680>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.492899, 0.143418, 4.608143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.491057, 0.000000, 2.779605>, <0.491057, 0.211544, 2.779605>, <0.397750, 0.384625, 2.732415>, <0.283708, 0.384625, 2.674739>,
      <0.404765, 0.000000, 3.402680>, <0.404765, 0.256251, 3.402680>, <0.263987, 0.465912, 3.345396>, <0.091925, 0.465912, 3.275382>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.492899, 0.143418, 4.608143>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000000, 0.714729, 4.628636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.283708, 0.384625, 2.674739>, <0.169666, 0.384625, 2.617063>, <0.076359, 0.211544, 2.569874>, <0.076359, 0.000000, 2.569874>,
      <0.091925, 0.465912, 3.275382>, <-0.080137, 0.465912, 3.205367>, <-0.220915, 0.256251, 3.148083>, <-0.220915, 0.000000, 3.148083>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000000, 0.714729, 4.628636>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.491292, 0.143418, 4.608143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.491292, 0.143418, 4.608143>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.492899, 0.143418, 4.608143>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.492899, 0.143418, 4.608143>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000000, 0.714729, 4.628636>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.316592, 3.271422, 2.857043>, <0.290917, 3.271422, 2.846596>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.203088, 2.099634, 4.476379>, <0.151999, 2.099634, 4.471155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.714729, 4.628636>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.491292, 0.143418, 4.608143>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.290917, 3.271422, 2.846596>, <0.265242, 3.271422, 2.836148>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.151999, 2.099634, 4.471155>, <0.100910, 2.099634, 4.465931>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.203088, 2.099634, 4.476379>, <0.151999, 2.099634, 4.471155>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.151999, 2.099634, 4.471155>, <0.100910, 2.099634, 4.465931>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    Shark3
  }
}
#declare body = union {
  object { fin2 }
  object { fin3 }
  object { BzPtch2 }
}
#declare Shark = difference {
  object { body }
  cylinder { // eyes1
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*y
    translate  <1.509286, 0.441903, 7.9655>
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare BzPtch3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.046980, 0.437354, 0.459508>, <-0.046980, -0.266226, 0.918226>, <-0.005950, -0.991635, 0.189770>, <0.000000, -0.970571, 0.210834>,
      <-0.046980, 0.106917, 1.003138>, <-0.046980, -0.253647, 1.040873>, <-0.025839, -0.677174, 0.838417>, <0.000000, -0.677174, 0.838417>,
      <-0.046980, 0.062892, 1.314461>, <-0.046980, -0.190755, 1.339618>, <-0.025839, -0.231334, 1.528295>, <0.000000, -0.231334, 1.528295>,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.970571, 0.210834>, <0.005950, -0.949506, 0.231898>, <0.046980, -0.266226, 0.918226>, <0.046980, 0.437354, 0.459508>,
      <0.000000, -0.677174, 0.838417>, <0.025839, -0.677174, 0.838417>, <0.046980, -0.253647, 1.040873>, <0.046980, 0.106917, 1.003138>,
      <0.000000, -0.231334, 1.528295>, <0.025839, -0.231334, 1.528295>, <0.046980, -0.190755, 1.339618>, <0.046980, 0.062892, 1.314461>,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.046980, 0.437354, 0.459508>, <0.046980, 1.140933, 0.000790>, <0.005950, 2.288415, -0.721104>, <0.000000, 2.288415, -0.721104>,
      <0.046980, 0.106917, 1.003138>, <0.046980, 0.467481, 0.965402>, <0.005950, 2.112317, -0.289022>, <0.000000, 2.112317, -0.289022>,
      <0.046980, 0.062892, 1.314461>, <0.046980, 0.316539, 1.289304>, <0.025839, 1.810435, 0.158035>, <0.000000, 1.810435, 0.158035>,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.288415, -0.721104>, <-0.005950, 2.288415, -0.721104>, <-0.046980, 1.140933, 0.000790>, <-0.046980, 0.437354, 0.459508>,
      <0.000000, 2.112317, -0.289022>, <-0.005950, 2.112317, -0.289022>, <-0.046980, 0.467481, 0.965402>, <-0.046980, 0.106917, 1.003138>,
      <0.000000, 1.810435, 0.158035>, <-0.025839, 1.810435, 0.158035>, <-0.046980, 0.316539, 1.289304>, <-0.046980, 0.062892, 1.314461>,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.059438, 0.031446, 1.657231>, <-0.059438, -0.150066, 1.669809>, <-0.032691, -0.215101, 1.764147>, <0.000000, -0.215101, 1.764147>,
      <-0.071895, 0.000000, 2.000000>, <-0.071895, -0.109377, 2.000000>, <-0.039542, -0.198868, 2.000000>, <0.000000, -0.198868, 2.000000>,
      <-0.131034, 0.000000, 2.500000>, <-0.131034, -0.166836, 2.500000>, <-0.072069, -0.303339, 2.500000>, <0.000000, -0.303339, 2.500000>,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.215101, 1.764147>, <0.032691, -0.215101, 1.764147>, <0.059438, -0.150066, 1.669809>, <0.059438, 0.031446, 1.657231>,
      <0.000000, -0.198868, 2.000000>, <0.039542, -0.198868, 2.000000>, <0.071895, -0.109377, 2.000000>, <0.071895, 0.000000, 2.000000>,
      <0.000000, -0.303339, 2.500000>, <0.072069, -0.303339, 2.500000>, <0.131034, -0.166836, 2.500000>, <0.131034, 0.000000, 2.500000>,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.059438, 0.031446, 1.657231>, <0.059438, 0.212958, 1.644652>, <0.032691, 1.004651, 1.079017>, <0.000000, 1.004651, 1.079017>,
      <0.071895, 0.000000, 2.000000>, <0.071895, 0.109377, 2.000000>, <0.039542, 0.198868, 2.000000>, <0.000000, 0.198868, 2.000000>,
      <0.131034, 0.000000, 2.500000>, <0.131034, 0.166836, 2.500000>, <0.072069, 0.303339, 2.500000>, <0.000000, 0.303339, 2.500000>,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.004651, 1.079017>, <-0.032691, 1.004651, 1.079017>, <-0.059438, 0.212958, 1.644652>, <-0.059438, 0.031446, 1.657231>,
      <0.000000, 0.198868, 2.000000>, <-0.039542, 0.198868, 2.000000>, <-0.071895, 0.109377, 2.000000>, <-0.071895, 0.000000, 2.000000>,
      <0.000000, 0.303339, 2.500000>, <-0.072069, 0.303339, 2.500000>, <-0.131034, 0.166836, 2.500000>, <-0.131034, 0.000000, 2.500000>,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.234391, 0.000000, 3.000000>, <-0.234391, -0.211544, 3.000000>, <-0.128915, -0.384625, 3.000000>, <0.000000, -0.384625, 3.000000>,
      <-0.337748, 0.000000, 3.500000>, <-0.337748, -0.256251, 3.500000>, <-0.185762, -0.465912, 3.500000>, <0.000000, -0.465912, 3.500000>,
      <-0.510204, 0.000000, 4.000000>, <-0.510204, -0.325463, 4.000000>, <-0.280612, -0.591750, 4.000000>, <0.000000, -0.591750, 4.000000>,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.384625, 3.000000>, <0.128915, -0.384625, 3.000000>, <0.234391, -0.211544, 3.000000>, <0.234391, 0.000000, 3.000000>,
      <0.000000, -0.465912, 3.500000>, <0.185762, -0.465912, 3.500000>, <0.337748, -0.256251, 3.500000>, <0.337748, 0.000000, 3.500000>,
      <0.000000, -0.591750, 4.000000>, <0.280612, -0.591750, 4.000000>, <0.510204, -0.325463, 4.000000>, <0.510204, 0.000000, 4.000000>,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.234391, 0.000000, 3.000000>, <0.234391, 0.211544, 3.000000>, <0.128915, 0.384625, 3.000000>, <0.000000, 0.384625, 3.000000>,
      <0.337748, 0.000000, 3.500000>, <0.337748, 0.256251, 3.500000>, <0.185762, 0.465912, 3.500000>, <0.000000, 0.465912, 3.500000>,
      <0.510204, 0.000000, 4.000000>, <0.510204, 0.325463, 4.000000>, <0.280612, 0.591750, 4.000000>, <0.000000, 0.591750, 4.000000>,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.384625, 3.000000>, <-0.128915, 0.384625, 3.000000>, <-0.234391, 0.211544, 3.000000>, <-0.234391, 0.000000, 3.000000>,
      <0.000000, 0.465912, 3.500000>, <-0.185762, 0.465912, 3.500000>, <-0.337748, 0.256251, 3.500000>, <-0.337748, 0.000000, 3.500000>,
      <0.000000, 0.591750, 4.000000>, <-0.280612, 0.591750, 4.000000>, <-0.510204, 0.325463, 4.000000>, <-0.510204, 0.000000, 4.000000>,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.444855, 0.155535, 4.607186>, <-0.635437, -0.246295, 4.583821>, <-0.336221, -0.675288, 4.521064>, <0.000000, -0.675288, 4.521064>,
      <-0.472379, 0.286836, 5.216287>, <-0.760670, -0.167127, 5.167641>, <-0.391830, -0.758826, 5.042128>, <0.000000, -0.758826, 5.042128>,
      <-0.535362, 0.341965, 5.597138>, <-0.837397, -0.157007, 5.667641>, <-0.494837, -0.815343, 5.542128>, <0.000000, -0.815343, 5.542128>,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.675288, 4.521064>, <0.336221, -0.675288, 4.521064>, <0.635437, -0.246295, 4.583821>, <0.445659, 0.155535, 4.607186>,
      <0.000000, -0.758826, 5.042128>, <0.391830, -0.758826, 5.042128>, <0.760670, -0.167127, 5.167641>, <0.475593, 0.286836, 5.216287>,
      <0.000000, -0.815343, 5.542128>, <0.494837, -0.815343, 5.542128>, <0.863558, -0.157007, 5.667641>, <0.551657, 0.341965, 5.597138>,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.445659, 0.155535, 4.607186>, <0.350360, 0.533130, 4.632466>, <0.336221, 0.714729, 4.628636>, <0.000804, 0.690495, 4.630552>,
      <0.475593, 0.286836, 5.216287>, <0.190516, 0.740798, 5.264932>, <0.391830, 0.837707, 5.257273>, <0.000000, 0.837707, 5.257273>,
      <0.551657, 0.341965, 5.597138>, <0.239755, 0.840938, 5.526634>, <0.050425, 3.271422, 3.027835>, <0.022706, 3.271422, 3.027835>,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000804, 0.690495, 4.630552>, <-0.336221, 0.714729, 4.628636>, <-0.347146, 0.533130, 4.632466>, <-0.444855, 0.155535, 4.607186>,
      <0.000000, 0.837707, 5.257273>, <-0.391830, 0.837707, 5.257273>, <-0.184088, 0.740798, 5.264932>, <-0.472379, 0.286836, 5.216287>,
      <0.022706, 3.271422, 3.027835>, <-0.005013, 3.271422, 3.027835>, <-0.233327, 0.840938, 5.526634>, <-0.535362, 0.341965, 5.597138>,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.530928, 0.339158, 5.964709>, <-0.878601, -0.145609, 6.020628>, <-0.497422, -0.709132, 6.042128>, <0.006540, -0.709132, 6.042128>,
      <-0.526493, 0.336351, 6.332281>, <-0.919805, -0.134211, 6.373615>, <-0.500007, -0.602921, 6.542128>, <0.013081, -0.602921, 6.542128>,
      <-0.855422, 0.183129, 7.000000>, <-0.855422, -0.160242, 7.000000>, <-0.470482, -0.441183, 7.000000>, <0.000000, -0.441183, 7.000000>,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.709132, 6.042128>, <0.510502, -0.709132, 6.042128>, <0.904763, -0.145609, 6.020628>, <0.548942, 0.339158, 5.964709>,
      <0.013081, -0.602921, 6.542128>, <0.526168, -0.602921, 6.542128>, <0.945967, -0.134211, 6.373615>, <0.546226, 0.336351, 6.332281>,
      <0.000000, -0.441183, 7.000000>, <0.470482, -0.441183, 7.000000>, <0.855422, -0.160242, 7.000000>, <0.855422, 0.183129, 7.000000>,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.548942, 0.339158, 5.964709>, <0.193121, 0.823926, 5.908790>, <0.070004, 2.099634, 4.561775>, <0.017893, 2.099634, 4.561775>,
      <0.546226, 0.336351, 6.332281>, <0.146486, 0.806913, 6.290946>, <0.089583, 0.927846, 6.095714>, <0.013081, 0.927846, 6.095714>,
      <0.855422, 0.183129, 7.000000>, <0.855422, 0.526501, 7.000000>, <0.470482, 0.807441, 7.000000>, <0.000000, 0.807441, 7.000000>,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.017893, 2.099634, 4.561775>, <-0.034217, 2.099634, 4.561775>, <-0.183254, 0.823926, 5.908790>, <-0.530928, 0.339158, 5.964709>,
      <0.013081, 0.927846, 6.095714>, <-0.063422, 0.927846, 6.095714>, <-0.133180, 0.806913, 6.290946>, <-0.526493, 0.336351, 6.332281>,
      <0.000000, 0.807441, 7.000000>, <-0.470482, 0.807441, 7.000000>, <-0.855422, 0.526501, 7.000000>, <-0.855422, 0.183129, 7.000000>,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.752496, 0.255073, 7.500000>, <-0.752496, -0.032124, 7.500000>, <-0.410930, -0.261753, 7.500000>, <0.006540, -0.261753, 7.500000>,
      <-0.649570, 0.327017, 8.000000>, <-0.649570, 0.095993, 8.000000>, <-0.351377, -0.082324, 8.000000>, <0.013081, -0.082324, 8.000000>,
      <-0.555556, 0.392420, 8.500000>, <-0.555556, 0.220112, 8.500000>, <-0.305556, 0.111240, 8.500000>, <0.000000, 0.111240, 8.500000>,
      <-0.164340, 0.510146, 9.000000>, <-0.164340, 0.503988, 9.000000>, <-0.084501, 0.498949, 9.000000>, <0.013081, 0.498949, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, -0.261753, 7.500000>, <0.424010, -0.261753, 7.500000>, <0.765576, -0.032124, 7.500000>, <0.765576, 0.255073, 7.500000>,
      <0.013081, -0.082324, 8.000000>, <0.377538, -0.082324, 8.000000>, <0.675731, 0.095993, 8.000000>, <0.675731, 0.327017, 8.000000>,
      <0.000000, 0.111240, 8.500000>, <0.305556, 0.111240, 8.500000>, <0.555556, 0.220112, 8.500000>, <0.555556, 0.392420, 8.500000>,
      <0.013081, 0.498949, 9.000000>, <0.110662, 0.498949, 9.000000>, <0.190501, 0.503988, 9.000000>, <0.190501, 0.510146, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765576, 0.255073, 7.500000>, <0.765576, 0.542271, 7.500000>, <0.424010, 0.771899, 7.500000>, <0.006540, 0.771899, 7.500000>,
      <0.675731, 0.327017, 8.000000>, <0.675731, 0.558040, 8.000000>, <0.377538, 0.736357, 8.000000>, <0.013081, 0.736357, 8.000000>,
      <0.555556, 0.392420, 8.500000>, <0.555556, 0.564728, 8.500000>, <0.305556, 0.673600, 8.500000>, <0.000000, 0.673600, 8.500000>,
      <0.190501, 0.510146, 9.000000>, <0.190501, 0.516304, 9.000000>, <0.110662, 0.521343, 9.000000>, <0.013081, 0.521343, 9.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006540, 0.771899, 7.500000>, <-0.410930, 0.771899, 7.500000>, <-0.752496, 0.542271, 7.500000>, <-0.752496, 0.255073, 7.500000>,
      <0.013081, 0.736357, 8.000000>, <-0.351377, 0.736357, 8.000000>, <-0.649570, 0.558040, 8.000000>, <-0.649570, 0.327017, 8.000000>,
      <0.000000, 0.673600, 8.500000>, <-0.305556, 0.673600, 8.500000>, <-0.555556, 0.564728, 8.500000>, <-0.555556, 0.392420, 8.500000>,
      <0.013081, 0.521343, 9.000000>, <-0.084501, 0.521343, 9.000000>, <-0.164340, 0.516304, 9.000000>, <-0.164340, 0.510146, 9.000000>
    }
  }
  texture {
    blackeyes1
  }
  scale 5.0
  rotate <90.0, 0.0, 35.0>
  translate  <87.250001, -158.450002, 59.950001>
}
#declare sharkeyes = intersection {
  cylinder { // eyes2
    <0,0,1>, <0,0,0>, 1
    texture {
      blackeyes1
    }
    scale <0.5, 0.5, 15.0>
    rotate <90.0, 0.0, -55.0>
    translate  <116.27579, -186.746325, 62.159517>
  }
  object { BzPtch3 }
}
union { // Shark_1
  object { Shark }
  object { sharkeyes }
  rotate 160.0*z
  translate  <63.450001, -282.500004, -56.450001>
}




#declare door = union {
  cylinder { // bar32
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  5.0*x
  }
  cylinder { // bar33
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  10.0*x
  }
  cylinder { // bar34
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  15.0*x
  }
  cylinder { // bar35
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  20.0*x
  }
  texture {
    Chrome_Metal1
  }
}
#declare Door2 = intersection {
  object { door }
  box { // doorway1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty_Iron1
    }
    scale <10.0, 2.0, 14.5>
    translate  <12.5, 0.0, 20.0>
  }
}
#declare FinalDoor = union {
  object { Door2 }
  box { // Frame3
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 1.0, 1.0>
    translate  <11.0, 0.0, 33.5>
  }
  box { // Frame2
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 1.0, 1.0>
    translate  <11.0, 0.0, 6.5>
  }
  texture {
    Rusty_Iron1
  }
  rotate -120.0*z
}
#declare cage = union {
  cylinder { // bar31
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  5.0*y
  }
  cylinder { // bar30
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  10.0*y
  }
  cylinder { // bar29
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  15.0*y
  }
  cylinder { // bar28
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  20.0*y
  }
  cylinder { // bar27
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  25.0*y
  }
  cylinder { // bar26
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  30.0*y
  }
  cylinder { // bar25
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  35.0*y
  }
  cylinder { // bar24
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  40.0*y
  }
  cylinder { // bar23
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <5.0, 40.0, 0.0>
  }
  cylinder { // bar22
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <10.0, 40.0, 0.0>
  }
  cylinder { // bar21
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <15.0, 40.0, 0.0>
  }
  cylinder { // bar20
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <20.0, 40.0, 0.0>
  }
  cylinder { // bar19
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <25.0, 40.0, 0.0>
  }
  cylinder { // bar18
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <30.0, 40.0, 0.0>
  }
  cylinder { // bar17
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <35.0, 40.0, 0.0>
  }
  cylinder { // bar16
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 40.0, 0.0>
  }
  cylinder { // bar15
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 35.0, 0.0>
  }
  cylinder { // bar14
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 30.0, 0.0>
  }
  cylinder { // bar13
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 25.0, 0.0>
  }
  cylinder { // bar12
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 20.0, 0.0>
  }
  cylinder { // bar11
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 15.0, 0.0>
  }
  cylinder { // bar10
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 10.0, 0.0>
  }
  cylinder { // bar7
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  35.0*x
  }
  cylinder { // bar6
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  30.0*x
  }
  cylinder { // bar5
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  25.0*x
  }
  cylinder { // bar4
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  20.0*x
  }
  cylinder { // bar3
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  15.0*x
  }
  cylinder { // bar2
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  10.0*x
  }
  cylinder { // bar1
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  5.0*x
  }
  cylinder { // bar
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
  }
  box { // top1
    <-1, -1, -1>, <1, 1, 1>
    scale <22.0, 22.0, 1.0>
    translate  <20.0, 20.0, 0.0>
  }
  box { // bottom
    <-1, -1, -1>, <1, 1, 1>
    scale <22.0, 22.0, 1.0>
    translate  <20.0, 20.0, 40.0>
  }
  cylinder { // bar8
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  40.0*x
  }
  cylinder { // bar36
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 40.0>
    translate  <40.0, 5.0, 0.0>
  }
  texture {
    Rusty_Iron1
  }
}
#declare removedoor = difference {
  object { cage }
  box { // doorway
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty_Iron1
    }
    scale <10.0, 2.0, 14.5>
    translate  <12.5, 0.0, 20.0>
  }
}
#declare FullCage = union {
  object { removedoor }
  box { // Frame1
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 1.0, 1.0>
    translate  <13.0, 0.0, 4.5>
  }
  box { // Frame
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 1.0, 1.0>
    translate  <13.0, 0.0, 35.5>
  }
  texture {
    Rusty_Iron1
  }
}
union { // FinalCage
  object { FinalDoor }
  object { FullCage }
  texture {
    Rusty_Iron1
  }
  translate  <4.35, 0.0, -0.3>
}


#declare Torso = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.964128, -0.937740, -0.214325>, <-4.100369, -2.875480, -0.171700>, <3.929070, -2.875480, -0.171700>, <2.792828, -0.937740, -0.214325>,
      <-2.870686, -0.852491, 1.977219>, <-3.289328, -2.875480, 2.066213>, <3.289328, -2.875480, 2.066213>, <2.870686, -0.852491, 1.977219>,
      <-3.387018, -0.938750, 4.932330>, <-4.076580, -3.350301, 5.604436>, <4.076580, -3.350301, 5.604436>, <3.387018, -0.938750, 4.932330>,
      <-3.229885, -0.888963, 6.646908>, <-4.118416, -3.606048, 6.841037>, <4.118416, -3.606048, 6.841037>, <3.229885, -0.888963, 6.646908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.792828, -0.937740, -0.214325>, <1.656587, 1.000000, -0.256949>, <-1.827887, 1.000000, -0.256949>, <-2.964128, -0.937740, -0.214325>,
      <2.870686, -0.852491, 1.977219>, <2.452045, 1.170498, 1.888226>, <-2.452045, 1.170498, 1.888226>, <-2.870686, -0.852491, 1.977219>,
      <3.387018, -0.938750, 4.932330>, <2.697455, 1.472800, 4.260223>, <-2.697455, 1.472800, 4.260223>, <-3.387018, -0.938750, 4.932330>,
      <3.229885, -0.888963, 6.646908>, <2.341353, 1.871757, 6.365510>, <-2.341353, 1.871757, 6.365510>, <-3.229885, -0.888963, 6.646908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.229885, -0.888963, 6.646908>, <-4.118416, -3.606048, 6.841037>, <4.118416, -3.606048, 6.841037>, <3.229885, -0.888963, 6.646908>,
      <-3.072751, -0.795541, 8.274217>, <-4.160252, -3.861795, 8.077638>, <4.160252, -3.861795, 8.077638>, <3.072751, -0.795541, 8.274217>,
      <-4.222187, -0.358352, 10.723444>, <-5.355626, -4.543788, 11.797461>, <5.355626, -4.543788, 11.797461>, <4.222187, -0.358352, 10.723444>,
      <-4.884657, -0.191985, 12.970258>, <-5.447694, -4.782529, 14.316790>, <5.447694, -4.782529, 14.316790>, <4.884657, -0.191985, 12.970258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.229885, -0.888963, 6.646908>, <2.341353, 1.871757, 6.365510>, <-2.341353, 1.871757, 6.365510>, <-3.229885, -0.888963, 6.646908>,
      <3.072751, -0.795541, 8.274217>, <1.985250, 2.270714, 8.470796>, <-1.985250, 2.270714, 8.470796>, <-3.072751, -0.795541, 8.274217>,
      <4.222187, -0.358352, 10.723444>, <3.088749, 3.827083, 9.649427>, <-3.088749, 3.827083, 9.649427>, <-4.222187, -0.358352, 10.723444>,
      <4.884657, -0.191985, 12.970258>, <4.321620, 4.398558, 11.623726>, <-4.321620, 4.398558, 11.623726>, <-4.884657, -0.191985, 12.970258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.884657, -0.191985, 12.970258>, <-5.447694, -4.782529, 14.316790>, <5.447694, -4.782529, 14.316790>, <4.884657, -0.191985, 12.970258>,
      <-5.547127, -0.025618, 15.217072>, <-5.539762, -5.021270, 16.836118>, <5.539762, -5.021270, 16.836118>, <5.547127, -0.025618, 15.217072>,
      <-5.310282, -0.261244, 17.685731>, <-6.021480, -5.021270, 18.396885>, <6.021480, -5.021270, 18.396885>, <5.310282, -0.261244, 17.685731>,
      <-4.060998, -0.650877, 18.180891>, <-4.060998, -1.774328, 18.307781>, <4.060998, -1.774328, 18.307781>, <4.060998, -0.650877, 18.180891>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.884657, -0.191985, 12.970258>, <4.321620, 4.398558, 11.623726>, <-4.321620, 4.398558, 11.623726>, <-4.884657, -0.191985, 12.970258>,
      <5.547127, -0.025618, 15.217072>, <5.554492, 4.970033, 13.598025>, <-5.554492, 4.970033, 13.598025>, <-5.547127, -0.025618, 15.217072>,
      <5.310282, -0.261244, 17.685731>, <4.599083, 4.498781, 16.974576>, <-4.599083, 4.498781, 16.974576>, <-5.310282, -0.261244, 17.685731>,
      <4.060998, -0.650877, 18.180891>, <4.060998, 0.472573, 18.054000>, <-4.060998, 0.472573, 18.054000>, <-4.060998, -0.650877, 18.180891>
    }
  }
  texture {
    SkinSuit
  }
  scale <1.0, 1.0, 0.8>
  translate  <1.6, -3.1, 19.7>
}
#declare Bicep = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.272727, 0.000000, 0.000000>, <-0.272727, -0.253837, 0.000000>, <0.272727, -0.253837, 0.000000>, <0.272727, 0.000000, 0.000000>,
      <-2.031502, -0.392982, 1.550877>, <-2.031502, -2.330611, 1.550877>, <2.031502, -2.330611, 1.550877>, <2.031502, -0.392982, 1.550877>,
      <-1.342857, -0.056140, 5.122807>, <-1.342857, -1.954386, 5.628070>, <1.342857, -1.954386, 5.628070>, <1.342857, -0.056140, 5.122807>,
      <-1.565368, 0.028070, 7.277193>, <-1.565368, -1.954386, 8.273684>, <1.565368, -1.954386, 8.273684>, <1.565368, 0.028070, 7.277193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.272727, 0.000000, 0.000000>, <0.272727, 0.253837, 0.000000>, <-0.272727, 0.253837, 0.000000>, <-0.272727, 0.000000, 0.000000>,
      <2.031502, -0.392982, 1.550877>, <2.031502, 1.544646, 1.550877>, <-2.031502, 1.544646, 1.550877>, <-2.031502, -0.392982, 1.550877>,
      <1.342857, -0.056140, 5.122807>, <1.342857, 1.842105, 4.617544>, <-1.342857, 1.842105, 4.617544>, <-1.342857, -0.056140, 5.122807>,
      <1.565368, 0.028070, 7.277193>, <1.565368, 2.010526, 6.280702>, <-1.565368, 2.010526, 6.280702>, <-1.565368, 0.028070, 7.277193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.565368, 0.028070, 7.277193>, <-1.565368, -1.954386, 8.273684>, <1.565368, -1.954386, 8.273684>, <1.565368, 0.028070, 7.277193>,
      <-1.787879, 0.112281, 9.431579>, <-1.787879, -1.954386, 10.919298>, <1.787879, -1.954386, 10.919298>, <1.787879, 0.112281, 9.431579>,
      <-1.787879, 0.112281, 11.431579>, <-1.787879, -1.954386, 12.919298>, <1.787879, -1.954386, 12.919298>, <1.787879, 0.112281, 11.431579>,
      <-0.172764, 1.395301, 11.887719>, <-0.184008, 1.527560, 11.775439>, <0.139030, 1.527560, 11.775439>, <0.150275, 1.395301, 11.887719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.565368, 0.028070, 7.277193>, <1.565368, 2.010526, 6.280702>, <-1.565368, 2.010526, 6.280702>, <-1.565368, 0.028070, 7.277193>,
      <1.787879, 0.112281, 9.431579>, <1.787879, 2.178947, 7.943860>, <-1.787879, 2.178947, 7.943860>, <-1.787879, 0.112281, 9.431579>,
      <1.787879, 0.112281, 11.431579>, <1.787879, 2.178947, 9.943860>, <-1.787879, 2.178947, 9.943860>, <-1.787879, 0.112281, 11.431579>,
      <0.150275, 1.395301, 11.887719>, <0.161519, 1.263042, 12.000000>, <-0.161519, 1.263042, 12.000000>, <-0.172764, 1.395301, 11.887719>
    }
  }
  texture {
    SkinSuit
  }
  scale <1.0, 1.0, 1.2>
  rotate <2.611264, 35.441856, -23.400232>
  translate  <-9.85, -0.05, 22.25>
}
#declare Bicep1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.272727, 0.000000, 0.000000>, <-0.272727, -0.253837, 0.000000>, <0.272727, -0.253837, 0.000000>, <0.272727, 0.000000, 0.000000>,
      <-2.031502, -0.392982, 1.550877>, <-2.031502, -2.330611, 1.550877>, <2.031502, -2.330611, 1.550877>, <2.031502, -0.392982, 1.550877>,
      <-1.342857, -0.056140, 5.122807>, <-1.342857, -1.954386, 5.628070>, <1.342857, -1.954386, 5.628070>, <1.342857, -0.056140, 5.122807>,
      <-1.565368, 0.028070, 7.277193>, <-1.565368, -1.954386, 8.273684>, <1.565368, -1.954386, 8.273684>, <1.565368, 0.028070, 7.277193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.272727, 0.000000, 0.000000>, <0.272727, 0.253837, 0.000000>, <-0.272727, 0.253837, 0.000000>, <-0.272727, 0.000000, 0.000000>,
      <2.031502, -0.392982, 1.550877>, <2.031502, 1.544646, 1.550877>, <-2.031502, 1.544646, 1.550877>, <-2.031502, -0.392982, 1.550877>,
      <1.342857, -0.056140, 5.122807>, <1.342857, 1.842105, 4.617544>, <-1.342857, 1.842105, 4.617544>, <-1.342857, -0.056140, 5.122807>,
      <1.565368, 0.028070, 7.277193>, <1.565368, 2.010526, 6.280702>, <-1.565368, 2.010526, 6.280702>, <-1.565368, 0.028070, 7.277193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.565368, 0.028070, 7.277193>, <-1.565368, -1.954386, 8.273684>, <1.565368, -1.954386, 8.273684>, <1.565368, 0.028070, 7.277193>,
      <-1.787879, 0.112281, 9.431579>, <-1.787879, -1.954386, 10.919298>, <1.787879, -1.954386, 10.919298>, <1.787879, 0.112281, 9.431579>,
      <-1.787879, 0.112281, 11.431579>, <-1.787879, -1.954386, 12.919298>, <1.787879, -1.954386, 12.919298>, <1.787879, 0.112281, 11.431579>,
      <-0.172764, 1.395301, 11.887719>, <-0.184008, 1.527560, 11.775439>, <0.139030, 1.527560, 11.775439>, <0.150275, 1.395301, 11.887719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.565368, 0.028070, 7.277193>, <1.565368, 2.010526, 6.280702>, <-1.565368, 2.010526, 6.280702>, <-1.565368, 0.028070, 7.277193>,
      <1.787879, 0.112281, 9.431579>, <1.787879, 2.178947, 7.943860>, <-1.787879, 2.178947, 7.943860>, <-1.787879, 0.112281, 9.431579>,
      <1.787879, 0.112281, 11.431579>, <1.787879, 2.178947, 9.943860>, <-1.787879, 2.178947, 9.943860>, <-1.787879, 0.112281, 11.431579>,
      <0.150275, 1.395301, 11.887719>, <0.161519, 1.263042, 12.000000>, <-0.161519, 1.263042, 12.000000>, <-0.172764, 1.395301, 11.887719>
    }
  }
  texture {
    SkinSuit
  }
  scale <1.0, 1.0, 1.2>
  rotate <16.190779, -56.91201, 55.971363>
  translate  <8.5, 7.3, 26.25>
}
#declare Forearm = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.841988, 0.000000, 0.000000>, <-0.841988, -0.449005, 0.000000>, <-0.159182, -0.449005, 0.000000>, <-0.159182, 0.000000, 0.000000>,
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <0.382456, -1.000000, 1.887719>, <0.382456, 0.000000, 1.887719>,
      <-1.215181, 0.000000, 3.234848>, <-1.215181, -1.664853, 3.234848>, <0.597637, -1.664853, 3.096277>, <0.597637, 0.000000, 3.096277>,
      <-1.411925, 0.000000, 5.703141>, <-1.411925, -1.851125, 5.703141>, <1.018942, -1.851125, 5.460642>, <1.018942, 0.000000, 5.460642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.159182, 0.000000, 0.000000>, <-0.159182, 0.449005, 0.000000>, <-0.841988, 0.449005, 0.000000>, <-0.841988, 0.000000, 0.000000>,
      <0.382456, 0.000000, 1.887719>, <0.382456, 1.000000, 1.887719>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>,
      <0.597637, 0.000000, 3.096277>, <0.597637, 1.664853, 3.096277>, <-1.215181, 1.664853, 3.234848>, <-1.215181, 0.000000, 3.234848>,
      <1.018942, 0.000000, 5.460642>, <1.018942, 1.851125, 5.460642>, <-1.411925, 1.851125, 5.703141>, <-1.411925, 0.000000, 5.703141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.411925, 0.000000, 5.703141>, <-1.411925, -1.851125, 5.703141>, <1.018942, -1.851125, 5.460642>, <1.018942, 0.000000, 5.460642>,
      <-1.608668, 0.000000, 8.171433>, <-1.608668, -2.037397, 8.171433>, <1.440247, -2.037397, 7.825006>, <1.440247, 0.000000, 7.825006>,
      <-1.608668, 0.000000, 10.639726>, <-1.608668, -2.037397, 10.639726>, <1.608668, -2.037397, 10.639726>, <1.608668, 0.000000, 10.639726>,
      <-1.000000, 0.000000, 12.000000>, <-1.000000, -1.000000, 12.000000>, <1.000000, -1.000000, 12.000000>, <1.000000, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.018942, 0.000000, 5.460642>, <1.018942, 1.851125, 5.460642>, <-1.411925, 1.851125, 5.703141>, <-1.411925, 0.000000, 5.703141>,
      <1.440247, 0.000000, 7.825006>, <1.440247, 2.037397, 7.825006>, <-1.608668, 2.037397, 8.171433>, <-1.608668, 0.000000, 8.171433>,
      <1.608668, 0.000000, 10.639726>, <1.608668, 2.037397, 10.639726>, <-1.608668, 2.037397, 10.639726>, <-1.608668, 0.000000, 10.639726>,
      <1.000000, 0.000000, 12.000000>, <1.000000, 1.000000, 12.000000>, <-1.000000, 1.000000, 12.000000>, <-1.000000, 0.000000, 12.000000>
    }
  }
  texture {
    SkinSuit
  }
  rotate <55.0, 0.0, 15.0>
  translate  <-11.6, 8.6, 17.1>
}
#declare Forearm1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.841988, 0.000000, 0.000000>, <-0.841988, -0.449005, 0.000000>, <-0.159182, -0.449005, 0.000000>, <-0.159182, 0.000000, 0.000000>,
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <0.382456, -1.000000, 1.887719>, <0.382456, 0.000000, 1.887719>,
      <-1.215181, 0.000000, 3.234848>, <-1.215181, -1.664853, 3.234848>, <0.597637, -1.664853, 3.096277>, <0.597637, 0.000000, 3.096277>,
      <-1.411925, 0.000000, 5.703141>, <-1.411925, -1.851125, 5.703141>, <1.018942, -1.851125, 5.460642>, <1.018942, 0.000000, 5.460642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.159182, 0.000000, 0.000000>, <-0.159182, 0.449005, 0.000000>, <-0.841988, 0.449005, 0.000000>, <-0.841988, 0.000000, 0.000000>,
      <0.382456, 0.000000, 1.887719>, <0.382456, 1.000000, 1.887719>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>,
      <0.597637, 0.000000, 3.096277>, <0.597637, 1.664853, 3.096277>, <-1.215181, 1.664853, 3.234848>, <-1.215181, 0.000000, 3.234848>,
      <1.018942, 0.000000, 5.460642>, <1.018942, 1.851125, 5.460642>, <-1.411925, 1.851125, 5.703141>, <-1.411925, 0.000000, 5.703141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.411925, 0.000000, 5.703141>, <-1.411925, -1.851125, 5.703141>, <1.018942, -1.851125, 5.460642>, <1.018942, 0.000000, 5.460642>,
      <-1.608668, 0.000000, 8.171433>, <-1.608668, -2.037397, 8.171433>, <1.440247, -2.037397, 7.825006>, <1.440247, 0.000000, 7.825006>,
      <-1.608668, 0.000000, 10.639726>, <-1.608668, -2.037397, 10.639726>, <1.608668, -2.037397, 10.639726>, <1.608668, 0.000000, 10.639726>,
      <-1.000000, 0.000000, 12.000000>, <-1.000000, -1.000000, 12.000000>, <1.000000, -1.000000, 12.000000>, <1.000000, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.018942, 0.000000, 5.460642>, <1.018942, 1.851125, 5.460642>, <-1.411925, 1.851125, 5.703141>, <-1.411925, 0.000000, 5.703141>,
      <1.440247, 0.000000, 7.825006>, <1.440247, 2.037397, 7.825006>, <-1.608668, 2.037397, 8.171433>, <-1.608668, 0.000000, 8.171433>,
      <1.608668, 0.000000, 10.639726>, <1.608668, 2.037397, 10.639726>, <-1.608668, 2.037397, 10.639726>, <-1.608668, 0.000000, 10.639726>,
      <1.000000, 0.000000, 12.000000>, <1.000000, 1.000000, 12.000000>, <-1.000000, 1.000000, 12.000000>, <-1.000000, 0.000000, 12.000000>
    }
  }
  texture {
    SkinSuit
  }
  rotate <-150.64119, 19.146841, -14.918955>
  translate  <9.75, 0.5, 36.300001>
}
#declare Thigh1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.946165, 0.000000, 0.000000>, <-0.946165, -0.949265, 0.000000>, <0.946165, -0.949265, 0.000000>, <0.946165, 0.000000, 0.000000>,
      <-1.121212, -0.168421, 2.000000>, <-1.121212, -1.336842, 2.000000>, <1.121212, -1.336842, 2.000000>, <1.121212, -0.168421, 2.000000>,
      <-1.367632, -0.308772, 3.943860>, <-1.367632, -1.617544, 3.887719>, <1.367632, -1.617544, 3.887719>, <1.367632, -0.308772, 3.943860>,
      <-1.590410, -0.224561, 5.933467>, <-1.590410, -1.760902, 6.050978>, <1.590410, -1.760902, 6.050978>, <1.590410, -0.224561, 5.933467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.946165, 0.000000, 0.000000>, <0.946165, 0.949265, 0.000000>, <-0.946165, 0.949265, 0.000000>, <-0.946165, 0.000000, 0.000000>,
      <1.121212, -0.168421, 2.000000>, <1.121212, 1.000000, 2.000000>, <-1.121212, 1.000000, 2.000000>, <-1.121212, -0.168421, 2.000000>,
      <1.367632, -0.308772, 3.943860>, <1.367632, 1.000000, 4.000000>, <-1.367632, 1.000000, 4.000000>, <-1.367632, -0.308772, 3.943860>,
      <1.590410, -0.224561, 5.933467>, <1.590410, 1.311779, 5.826417>, <-1.590410, 1.311779, 5.826417>, <-1.590410, -0.224561, 5.933467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.590410, -0.224561, 5.933467>, <-1.590410, -1.760902, 6.050978>, <1.590410, -1.760902, 6.050978>, <1.590410, -0.224561, 5.933467>,
      <-1.813187, -0.140351, 7.933535>, <-1.813187, -1.904261, 8.214237>, <1.813187, -1.904261, 8.214237>, <1.813187, -0.140351, 7.933535>,
      <-1.813187, -0.028070, 10.010325>, <-1.813187, -1.679699, 10.122605>, <1.813187, -1.679699, 10.122605>, <1.813187, -0.028070, 10.010325>,
      <-1.000000, 0.056140, 12.000000>, <-1.000000, -1.168421, 12.000000>, <1.000000, -1.168421, 12.000000>, <1.000000, 0.056140, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.590410, -0.224561, 5.933467>, <1.590410, 1.311779, 5.826417>, <-1.590410, 1.311779, 5.826417>, <-1.590410, -0.224561, 5.933467>,
      <1.813187, -0.140351, 7.933535>, <1.813187, 1.623559, 7.652833>, <-1.813187, 1.623559, 7.652833>, <-1.813187, -0.140351, 7.933535>,
      <1.813187, -0.028070, 10.010325>, <1.813187, 1.623559, 9.898044>, <-1.813187, 1.623559, 9.898044>, <-1.813187, -0.028070, 10.010325>,
      <1.000000, 0.056140, 12.000000>, <1.000000, 1.280702, 12.000000>, <-1.000000, 1.280702, 12.000000>, <-1.000000, 0.056140, 12.000000>
    }
  }
  scale <1.0, 1.2, 0.7>
  rotate 30.0*x
  translate  <0.0, 0.25, 11.55>
}
#declare leg1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.663158, 0.000000, 0.000000>, <-0.663158, -0.714286, 0.000000>, <0.494737, -0.714286, 0.000000>, <0.494737, 0.000000, 0.000000>,
      <-0.831579, 0.000000, 2.000000>, <-0.831579, -0.828571, 2.000000>, <0.663158, -0.828571, 2.000000>, <0.663158, 0.000000, 2.000000>,
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -0.828571, 4.000000>, <1.056140, -0.828571, 4.000000>, <1.056140, 0.000000, 4.000000>,
      <-1.140351, 0.000000, 6.000000>, <-1.140351, -1.076448, 6.000000>, <1.477193, -1.090110, 5.887719>, <1.477193, 0.000000, 5.915789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.494737, 0.000000, 0.000000>, <0.494737, 0.714286, 0.000000>, <-0.663158, 0.714286, 0.000000>, <-0.663158, 0.000000, 0.000000>,
      <0.663158, 0.000000, 2.000000>, <0.663158, 0.828571, 2.000000>, <-0.831579, 0.828571, 2.000000>, <-0.831579, 0.000000, 2.000000>,
      <1.056140, 0.000000, 4.000000>, <1.056140, 0.828571, 4.000000>, <-1.000000, 0.828571, 4.000000>, <-1.000000, 0.000000, 4.000000>,
      <1.477193, 0.000000, 5.915789>, <1.477193, 1.090110, 5.887719>, <-1.140351, 1.076448, 6.000000>, <-1.140351, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.140351, 0.000000, 6.000000>, <-1.140351, -1.076448, 6.000000>, <1.477193, -1.090110, 5.887719>, <1.477193, 0.000000, 5.915789>,
      <-1.280702, 0.000000, 8.000000>, <-1.280702, -1.324324, 8.000000>, <1.898246, -1.351648, 7.775439>, <1.898246, 0.000000, 7.775439>,
      <-1.280702, 0.000000, 10.000000>, <-1.280702, -1.324324, 10.000000>, <1.785965, -1.171429, 10.842105>, <1.785965, 0.000000, 10.842105>,
      <-1.000000, 0.000000, 12.000000>, <-1.000000, -1.000000, 12.000000>, <1.000000, -1.000000, 12.000000>, <1.000000, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.477193, 0.000000, 5.915789>, <1.477193, 1.090110, 5.887719>, <-1.140351, 1.076448, 6.000000>, <-1.140351, 0.000000, 6.000000>,
      <1.898246, 0.000000, 7.775439>, <1.898246, 1.351648, 7.775439>, <-1.280702, 1.324324, 8.000000>, <-1.280702, 0.000000, 8.000000>,
      <1.785965, 0.000000, 10.842105>, <1.785965, 1.171429, 10.842105>, <-1.280702, 1.324324, 10.000000>, <-1.280702, 0.000000, 10.000000>,
      <1.000000, 0.000000, 12.000000>, <1.000000, 1.000000, 12.000000>, <-1.000000, 1.000000, 12.000000>, <-1.000000, 0.000000, 12.000000>
    }
  }
  rotate <0.0, -15.0, -90.0>
  translate  <0.0, -3.1, 0.6>
}
#declare DiverLeg1 = union {
  object { Thigh1 }
  object { leg1 }
  texture {
    SkinSuit
  }
  rotate <-47.0, 0.0, 0.0>
  translate  <3.0, -15.0, 3.5>
}
#declare Thigh = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.946165, 0.000000, 0.000000>, <-0.946165, -0.949265, 0.000000>, <0.946165, -0.949265, 0.000000>, <0.946165, 0.000000, 0.000000>,
      <-1.121212, -0.168421, 2.000000>, <-1.121212, -1.336842, 2.000000>, <1.121212, -1.336842, 2.000000>, <1.121212, -0.168421, 2.000000>,
      <-1.367632, -0.308772, 3.943860>, <-1.367632, -1.617544, 3.887719>, <1.367632, -1.617544, 3.887719>, <1.367632, -0.308772, 3.943860>,
      <-1.590410, -0.224561, 5.933467>, <-1.590410, -1.760902, 6.050978>, <1.590410, -1.760902, 6.050978>, <1.590410, -0.224561, 5.933467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.946165, 0.000000, 0.000000>, <0.946165, 0.949265, 0.000000>, <-0.946165, 0.949265, 0.000000>, <-0.946165, 0.000000, 0.000000>,
      <1.121212, -0.168421, 2.000000>, <1.121212, 1.000000, 2.000000>, <-1.121212, 1.000000, 2.000000>, <-1.121212, -0.168421, 2.000000>,
      <1.367632, -0.308772, 3.943860>, <1.367632, 1.000000, 4.000000>, <-1.367632, 1.000000, 4.000000>, <-1.367632, -0.308772, 3.943860>,
      <1.590410, -0.224561, 5.933467>, <1.590410, 1.311779, 5.826417>, <-1.590410, 1.311779, 5.826417>, <-1.590410, -0.224561, 5.933467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.590410, -0.224561, 5.933467>, <-1.590410, -1.760902, 6.050978>, <1.590410, -1.760902, 6.050978>, <1.590410, -0.224561, 5.933467>,
      <-1.813187, -0.140351, 7.933535>, <-1.813187, -1.904261, 8.214237>, <1.813187, -1.904261, 8.214237>, <1.813187, -0.140351, 7.933535>,
      <-1.813187, -0.028070, 10.010325>, <-1.813187, -1.679699, 10.122605>, <1.813187, -1.679699, 10.122605>, <1.813187, -0.028070, 10.010325>,
      <-1.000000, 0.056140, 12.000000>, <-1.000000, -1.168421, 12.000000>, <1.000000, -1.168421, 12.000000>, <1.000000, 0.056140, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.590410, -0.224561, 5.933467>, <1.590410, 1.311779, 5.826417>, <-1.590410, 1.311779, 5.826417>, <-1.590410, -0.224561, 5.933467>,
      <1.813187, -0.140351, 7.933535>, <1.813187, 1.623559, 7.652833>, <-1.813187, 1.623559, 7.652833>, <-1.813187, -0.140351, 7.933535>,
      <1.813187, -0.028070, 10.010325>, <1.813187, 1.623559, 9.898044>, <-1.813187, 1.623559, 9.898044>, <-1.813187, -0.028070, 10.010325>,
      <1.000000, 0.056140, 12.000000>, <1.000000, 1.280702, 12.000000>, <-1.000000, 1.280702, 12.000000>, <-1.000000, 0.056140, 12.000000>
    }
  }
  scale <1.0, 1.2, 0.7>
  rotate 30.0*x
  translate  <0.0, 0.25, 11.55>
}
#declare leg = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.663158, 0.000000, 0.000000>, <-0.663158, -0.714286, 0.000000>, <0.494737, -0.714286, 0.000000>, <0.494737, 0.000000, 0.000000>,
      <-0.831579, 0.000000, 2.000000>, <-0.831579, -0.828571, 2.000000>, <0.663158, -0.828571, 2.000000>, <0.663158, 0.000000, 2.000000>,
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -0.828571, 4.000000>, <1.056140, -0.828571, 4.000000>, <1.056140, 0.000000, 4.000000>,
      <-1.140351, 0.000000, 6.000000>, <-1.140351, -1.076448, 6.000000>, <1.477193, -1.090110, 5.887719>, <1.477193, 0.000000, 5.915789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.494737, 0.000000, 0.000000>, <0.494737, 0.714286, 0.000000>, <-0.663158, 0.714286, 0.000000>, <-0.663158, 0.000000, 0.000000>,
      <0.663158, 0.000000, 2.000000>, <0.663158, 0.828571, 2.000000>, <-0.831579, 0.828571, 2.000000>, <-0.831579, 0.000000, 2.000000>,
      <1.056140, 0.000000, 4.000000>, <1.056140, 0.828571, 4.000000>, <-1.000000, 0.828571, 4.000000>, <-1.000000, 0.000000, 4.000000>,
      <1.477193, 0.000000, 5.915789>, <1.477193, 1.090110, 5.887719>, <-1.140351, 1.076448, 6.000000>, <-1.140351, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.140351, 0.000000, 6.000000>, <-1.140351, -1.076448, 6.000000>, <1.477193, -1.090110, 5.887719>, <1.477193, 0.000000, 5.915789>,
      <-1.280702, 0.000000, 8.000000>, <-1.280702, -1.324324, 8.000000>, <1.898246, -1.351648, 7.775439>, <1.898246, 0.000000, 7.775439>,
      <-1.280702, 0.000000, 10.000000>, <-1.280702, -1.324324, 10.000000>, <1.785965, -1.171429, 10.842105>, <1.785965, 0.000000, 10.842105>,
      <-1.000000, 0.000000, 12.000000>, <-1.000000, -1.000000, 12.000000>, <1.000000, -1.000000, 12.000000>, <1.000000, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.477193, 0.000000, 5.915789>, <1.477193, 1.090110, 5.887719>, <-1.140351, 1.076448, 6.000000>, <-1.140351, 0.000000, 6.000000>,
      <1.898246, 0.000000, 7.775439>, <1.898246, 1.351648, 7.775439>, <-1.280702, 1.324324, 8.000000>, <-1.280702, 0.000000, 8.000000>,
      <1.785965, 0.000000, 10.842105>, <1.785965, 1.171429, 10.842105>, <-1.280702, 1.324324, 10.000000>, <-1.280702, 0.000000, 10.000000>,
      <1.000000, 0.000000, 12.000000>, <1.000000, 1.000000, 12.000000>, <-1.000000, 1.000000, 12.000000>, <-1.000000, 0.000000, 12.000000>
    }
  }
  rotate -90.0*z
}
#declare DiverLeg = union {
  object { Thigh }
  object { leg }
  texture {
    SkinSuit
  }
}
#declare Fin2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957216, -1.535325, 0.000000>, <-0.620079, -1.973447, 0.000000>, <-0.388109, -1.973447, 0.000000>, <-0.062667, -1.535325, 0.000000>,
      <-1.176744, -1.000000, 0.000000>, <-0.634412, -1.000000, 0.619471>, <-0.376954, -1.000000, 0.619471>, <0.176744, -1.000000, 0.000000>,
      <-1.281106, 0.073717, 0.205121>, <-0.766052, 0.012046, 0.102942>, <-0.245315, 0.012046, 0.102942>, <0.281106, 0.073717, 0.205121>,
      <-1.309859, 0.929862, -0.311613>, <-0.755918, 0.605428, -0.115798>, <-0.216012, 0.605428, -0.115798>, <0.309859, 0.929862, -0.311613>
    }
  }
  texture {
    Fintxt
  }
  scale <3.7, 3.7, 2.0>
  rotate -20.0*x
  translate  <1.9, 4.95, -2.0>
}
#declare Fin1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.957216, -1.535325, 0.000000>, <-0.620079, -1.973447, 0.000000>, <-0.388109, -1.973447, 0.000000>, <-0.062667, -1.535325, 0.000000>,
      <-1.176744, -1.000000, 0.000000>, <-0.634412, -1.000000, 0.619471>, <-0.376954, -1.000000, 0.619471>, <0.176744, -1.000000, 0.000000>,
      <-1.281106, -0.062008, -0.090427>, <-0.766052, -0.131867, -0.227596>, <-0.245315, -0.131867, -0.227596>, <0.281106, -0.062008, -0.090427>,
      <-1.309859, 1.031117, -0.705858>, <-0.755918, 0.616880, -0.472642>, <-0.216012, 0.616880, -0.472642>, <0.309859, 1.031117, -0.705858>
    }
  }
  texture {
    Fintxt
  }
  scale <3.7, 3.7, 2.0>
  rotate -70.0*x
  translate  <4.9, -14.75, 0.4>
}
#declare buttocks = union {
  sphere { // Buttock1
    <0,0,0>,1
    texture {
      SkinSuit
    }
    scale <2.1, 1.75, 1.75>
    translate  <2.65, -4.05, 19.2>
  }
  sphere { // Buttock
    <0,0,0>,1
    texture {
      SkinSuit
    }
    scale <2.1, 1.75, 1.75>
    translate  <0.2, -4.05, 19.2>
  }
}
#declare buttremoval = difference {
  object { buttocks }
  sphere { // Removal
    <0,0,0>,1
    scale <5.9, 4.3, 3.15>
    translate  <1.3, 0.3, 19.15>
  }
  texture {
    SkinSuit
  }
}
#declare Hand = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  24  // control points
  <-0.273126, -0.998358>,
  <-0.135733, -0.998358>,
  <0.001048, -0.998358>,
  <0.143129, -0.999817>,
  <0.276125, -0.999817>,
  <0.998832, -0.505292>,
  <1.517271, 0.018194>,
  <1.517271, 0.456944>,
  <0.632466, -0.19789>,
  <0.874341, 1.081674>,
  <0.675277, 1.080313>,
  <0.362572, -0.089672>,
  <0.478658, 1.224604>,
  <0.259283, 1.224604>,
  <-0.008842, -0.075379>,
  <0.012069, 1.185809>,
  <-0.185425, 1.204934>,
  <-0.373836, -0.062678>,
  <-0.333159, 1.047643>,
  <-0.584822, 1.034031>,
  <-0.65969, 0.309427>,
  <-0.65969, -0.140573>,
  <-0.578016, -0.651961>,
  <-0.273126, -0.998358>
  rotate -x*90
  texture {
    SkinSuit
  }
  scale <2.0, 2.0, 0.5>
  rotate <3.538189, 8.669515, 37.985043>
  translate  <-12.75, 9.65, 16.95>
}
#declare tube = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.887662, -9.460858, 2.593740>, <4.749144, -10.469714, 2.702546>, <4.813636, -10.366802, 4.776642>, <4.974657, -9.322037, 4.625458>,
      <2.509639, -9.046585, 2.626351>, <1.833557, -10.423248, 2.735158>, <1.898050, -10.320337, 4.809253>, <2.596635, -8.907765, 4.658070>,
      <2.636598, -1.954995, 2.658963>, <1.111056, -2.113147, 2.767769>, <1.232506, -2.113147, 4.841865>, <2.800424, -1.954995, 4.690681>,
      <1.322993, -1.005568, 4.023815>, <0.055528, -1.556573, 5.383885>, <1.116253, -1.556573, 6.420932>, <1.935269, -1.005568, 5.558198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.974657, -9.322037, 4.625458>, <5.135678, -8.277272, 4.474275>, <5.026180, -8.452001, 2.484933>, <4.887662, -9.460858, 2.593740>,
      <2.596635, -8.907765, 4.658070>, <3.295219, -7.495192, 4.506886>, <3.185721, -7.669921, 2.517545>, <2.509639, -9.046585, 2.626351>,
      <2.800424, -1.954995, 4.690681>, <4.368343, -1.796843, 4.539498>, <4.162139, -1.796843, 2.550156>, <2.636598, -1.954995, 2.658963>,
      <1.935269, -1.005568, 5.558198>, <2.754285, -0.454562, 4.695464>, <2.590458, -0.454562, 2.663745>, <1.322993, -1.005568, 4.023815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.322993, -1.005568, 4.023815>, <0.055528, -1.556573, 5.383885>, <1.116253, -1.556573, 6.420932>, <1.935269, -1.005568, 5.558198>,
      <0.009389, -0.056140, 5.388667>, <-1.000000, -1.000000, 8.000000>, <1.000000, -1.000000, 8.000000>, <1.070114, -0.056140, 6.425715>,
      <-1.000000, 0.000000, 10.000000>, <-1.000000, -1.000000, 10.000000>, <1.000000, -1.000000, 10.000000>, <1.000000, 0.000000, 10.000000>,
      <-1.000000, 0.000000, 12.000000>, <-1.000000, -1.000000, 12.000000>, <1.000000, -1.000000, 12.000000>, <1.000000, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.935269, -1.005568, 5.558198>, <2.754285, -0.454562, 4.695464>, <2.590458, -0.454562, 2.663745>, <1.322993, -1.005568, 4.023815>,
      <1.070114, -0.056140, 6.425715>, <1.140227, 0.887719, 4.851430>, <1.018777, 0.887719, 2.777334>, <0.009389, -0.056140, 5.388667>,
      <1.000000, 0.000000, 10.000000>, <1.000000, 1.000000, 10.000000>, <-1.000000, 1.000000, 10.000000>, <-1.000000, 0.000000, 10.000000>,
      <1.000000, 0.000000, 12.000000>, <1.000000, 1.000000, 12.000000>, <-1.000000, 1.000000, 12.000000>, <-1.000000, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 12.000000>, <-1.000000, -1.000000, 12.000000>, <1.000000, -1.000000, 12.000000>, <1.000000, 0.000000, 12.000000>,
      <-1.000000, 0.000000, 14.000000>, <-1.000000, -1.000000, 14.000000>, <1.000000, -1.000000, 14.000000>, <1.000000, 0.000000, 14.000000>,
      <-1.000000, 0.000000, 16.000000>, <-1.000000, -1.000000, 16.000000>, <1.000000, -1.000000, 16.000000>, <1.000000, 0.000000, 16.000000>,
      <-1.000000, -1.303624, 17.254668>, <-1.000000, -1.834185, 16.755603>, <1.000000, -1.834185, 16.755603>, <1.000000, -1.303624, 17.254668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 12.000000>, <1.000000, 1.000000, 12.000000>, <-1.000000, 1.000000, 12.000000>, <-1.000000, 0.000000, 12.000000>,
      <1.000000, 0.000000, 14.000000>, <1.000000, 1.000000, 14.000000>, <-1.000000, 1.000000, 14.000000>, <-1.000000, 0.000000, 14.000000>,
      <1.000000, 0.000000, 16.000000>, <1.000000, 1.000000, 16.000000>, <-1.000000, 1.000000, 16.000000>, <-1.000000, 0.000000, 16.000000>,
      <1.000000, -1.303624, 17.254668>, <1.000000, -0.773064, 17.753734>, <-1.000000, -0.773064, 17.753734>, <-1.000000, -1.303624, 17.254668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -1.303624, 17.254668>, <-1.000000, -1.834185, 16.755603>, <1.000000, -1.834185, 16.755603>, <1.000000, -1.303624, 17.254668>,
      <-1.000000, -2.607248, 18.509337>, <-1.000000, -2.668369, 17.511207>, <1.000000, -2.668369, 17.511207>, <1.000000, -2.607248, 18.509337>,
      <-1.000000, -8.308772, 18.912281>, <-1.000000, -6.124279, 17.633449>, <1.000000, -6.124279, 17.633449>, <1.000000, -8.308772, 18.912281>,
      <-1.000000, -9.912050, 17.574874>, <-1.000000, -8.794224, 17.643410>, <1.000000, -8.794224, 17.643410>, <1.000000, -9.912050, 17.574874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -1.303624, 17.254668>, <1.000000, -0.773064, 17.753734>, <-1.000000, -0.773064, 17.753734>, <-1.000000, -1.303624, 17.254668>,
      <1.000000, -2.607248, 18.509337>, <1.000000, -2.546127, 19.507467>, <-1.000000, -2.546127, 19.507467>, <-1.000000, -2.607248, 18.509337>,
      <1.000000, -8.308772, 18.912281>, <1.000000, -10.493265, 20.191113>, <-1.000000, -10.493265, 20.191113>, <-1.000000, -8.308772, 18.912281>,
      <1.000000, -9.912050, 17.574874>, <1.000000, -11.029877, 17.506337>, <-1.000000, -11.029877, 17.506337>, <-1.000000, -9.912050, 17.574874>
    }
  }
  texture {
    TankTxt
  }
  scale 0.55
  rotate <-90.0, 90.0, 0.0>
  translate  <-4.0, -10.15, 37.000001>
}
#declare tank_band = union {
  box { // band
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.2, 0.5>
    translate  <15.95, -10.0, 32.7>
  }
  cylinder { // Band1
    <0,0,1>, <0,0,0>, 1
    texture {
      SkinSuit
    }
    scale <2.2, 2.2, 1.0>
    translate  <17.95, -10.05, 32.2>
  }
  cylinder { // Band
    <0,0,1>, <0,0,0>, 1
    texture {
      SkinSuit
    }
    scale <2.2, 2.2, 1.0>
    translate  <13.9, -10.0, 32.2>
  }
  texture {
    SkinSuit
  }
}
#declare Tank1 = union {
  sphere { // TankSphere1
    <0,0,0>,1
    scale 2.0
    translate  <13.95, -10.0, 38.950001>
  }
  cylinder { // TankCyl1
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 12.5>
    translate  <13.95, -10.0, 26.55>
  }
  texture {
    TankTxt
  }
  translate  4.0*x
}
#declare Tank = union {
  sphere { // TankSphere
    <0,0,0>,1
    scale 2.0
    translate  <13.95, -10.0, 38.950001>
  }
  cylinder { // TankCyl
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 12.5>
    translate  <13.95, -10.0, 26.55>
  }
  texture {
    TankTxt
  }
}
#declare tanks = union {
  object { tank_band }
  object { Tank1 }
  object { Tank }
  translate  <-14.25, 1.0, -5.65>
}
#declare FinalHead = difference {
  sphere { // Head1
    <0,0,0>,1
    texture {
      SkinSuit
    }
    scale <3.0, 4.0, 4.0>
    translate  <1.75, -3.85, 38.700001>
  }
  sphere { // Flesh1
    <0,0,0>,1
    texture {
      SkinSuit
    }
    scale <2.7, 3.5, 3.0>
    translate  <1.75, 0.0, 38.70001>
  }
  translate  -0.1*y
}
#declare face = intersection {
  sphere { // Head
    <0,0,0>,1
    texture {
      Facial
    }
    scale <3.0, 4.0, 4.0>
    translate  <1.75, -3.85, 38.700001>
  }
  sphere { // Flesh
    <0,0,0>,1
    texture {
      Facial
    }
    scale <2.7, 3.5, 3.0>
    translate  <1.75, 0.0, 38.70001>
  }
  texture {
    Facial
  }
  translate  0.05*y
}
#declare nose = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -1.807561, -0.752261>, <-1.000000, -2.415225, 0.415225>, <0.000000, -2.415225, 0.415225>, <1.000000, -1.807561, -0.752261>,
      <-2.000000, -0.807561, -0.752261>, <-0.971930, -4.870506, 4.304590>, <0.028070, -4.870506, 4.304590>, <1.000000, -0.807561, -0.752261>,
      <-1.489362, 0.242236, -0.594811>, <-1.000000, -0.479106, 0.290761>, <0.000000, -0.479106, 0.290761>, <0.489362, 0.242236, -0.594811>,
      <-1.489362, 2.069847, -0.839733>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.489362, 2.069847, -0.839733>
    }
  }
  texture {
    Facial
  }
  scale 0.6
  rotate <90.0, 0.0, 180.0>
  translate  <1.5, -0.2, 39.250001>
}
#declare Camera1 = union {
  cylinder { // Lens2
    <0,0,1>, <0,0,0>, 1
    texture {
      LensTxt
    }
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <6.1, 8.75, 38.55>
  }
  cylinder { // Lens
    <0,0,1>, <0,0,0>, 1
    texture {
      LensTxt
    }
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <5.2, 8.75, 39.900001>
  }
  cylinder { // Lens1
    <0,0,1>, <0,0,0>, 1
    texture {
      LensTxt
    }
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <4.35, 8.75, 38.550001>
  }
  cylinder { // LensApp
    <0,0,1>, <0,0,0>, 1
    texture {
      CamTxt
    }
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  <5.2, 8.05, 38.900001>
  }
  cylinder { // Reel1
    <0,0,1>, <0,0,0>, 1
    texture {
      CamTxt
    }
    scale <2.5, 2.5, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <4.85, 2.45, 44.2>
  }
  cylinder { // Reel
    <0,0,1>, <0,0,0>, 1
    texture {
      CamTxt
    }
    scale <2.5, 2.5, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <4.85, 6.2, 44.2>
  }
  box { // CameraBox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CamTxt
    }
    scale <2.9, 4.45, 3.6>
    translate  <5.2, 4.1, 38.950001>
  }
}
union { // Diver
  object { Torso }
  object { Bicep }
  object { Bicep1 }
  object { Forearm }
  object { Forearm1 }
  object { DiverLeg1 }
  object { DiverLeg }
  object { Fin2 }
  object { Fin1 }
  cylinder { // Neck
    <0,0,1>, <0,0,0>, 1
    texture {
      SkinSuit
    }
    scale <1.0, 1.0, 2.6>
    rotate -10.0*x
    translate  <1.7, -4.2, 33.650001>
  }
  object { buttremoval }
  object { Hand }
  cylinder { // MouthPiece
    <0,0,1>, <0,0,0>, 1
    texture {
      MouthPieceTxt
    }
    scale <-0.65, -0.55, -0.5>
    rotate <-70.0, 0.0, -180.0>
    translate  <1.6, -0.5, 37.100001>
  }
  cylinder { // Mask
    <0,0,1>, <0,0,0>, 1
    texture {
      FaceMask
    }
    scale <2.55, 0.95, 1.0>
    rotate -90.0*x
    translate  <1.75, -0.65, 39.900001>
  }
  object { tube }
  object { tanks }
  object { FinalHead }
  object { face }
  object { nose }
  object { Camera1 }
  scale 0.6
  rotate <-24.84343, 7.116997, -167.318451>
  translate  <16.7, -5.5, 4.5>
}






