

// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: image depart tom dans sa maison
// Date: 15/05/97
// Auth: denis




#include "colors.inc"
#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"
#include "csg.inc"
#include "textures.inc"
#include "stones.inc"




camera {
location<-1, 3, -35>
look_at <1, 1.9, 0>
focal_point <0, 0, -2>
}
//*******************************light
light_source {<-2, 8, -15>color White
spotlight
radius 35
falloff 40
tightness 10
area_light <1, 0, 0>, <0, 0, 1>, 2, 2
point_at <6, 2, -4>
}
light_source {<5, 8, -5>color White
spotlight
radius 40
falloff 45
tightness 10
area_light <1, 0, 0>, <0, 0, 1>, 2, 2
point_at <1, 1, 2>
}
light_source {<-2, 8, -8>color White
area_light <5, 0, 0>, <0, 0, 5>, 5, 5
jitter
adaptive 1

}
light_source {<3, 3, -8>color White
area_light <5, 0, 0>, <0, 0, 5>, 5, 5
jitter
adaptive 1

}




//****************************************sol
plane {y, -10
pigment {checker color White, color Black}
scale 0.5
}

//**************************************** mur fond
plane
{ < 0, 0, 1>, 20
pigment {
gradient x
color_map {
[0.00 color Red ]
[0.60 color Green ]
[0.95 color Black ]
}
}
finish {
ambient 0.4
diffuse 0.5
}
}
//***************************************mur droit

plane
{ < 1, 0, 0>, 9
pigment {
gradient z
color_map {
[0.00 color Red ]
[0.60 color Green ]
[0.95 color Black ]
}
}
finish {
ambient 0.4
diffuse 0.5
}
}


//*****************************************//tete
#declare tete = union {
sphere {
<0, 0, 0>, 2
pigment { GreenYellow }
      finish {
 ambient 0.5
crand 0.05
        roughness .001
             }
    }
//*************pupille
sphere {
<-1, 0.7, -2>, 0.1
pigment { White }
finish {reflection .6}
}
sphere {
<1, 0.7, -2>, 0.1
pigment { White }
finish {reflection .6}
}


// ***************yeux
disc
{
  <1.1, 0.7, -2>  // center position
  z,         // normal vector
  0.5,       // outer radius
  0        // optional hole radius
}
disc
{
  <-1.1, 0.7, -2>  // center position
  z,         // normal vector
  0.5,       // outer radius
  0        // optional hole radius
}
//****************nez
cone
{<0, 0, -1>, 1, <0, -1, -5>, 0
pigment { Red } finish { ambient 0.4 }
}
}// fin de union de la tete
//************************************************TOM GAUCHE


//***********************corps
# declare Corps =
cone
{<0, 7, 0>, 0.3, <0, 4, 0>, 2
pigment {SteelBlue}

}
//*********************pieds
declare Piedroit =
union{
difference {
cone
{< -0.1, 0, 0 > 1.2, < 1.7, 0.2, 0 > 0.2
scale y*0.5 }
box
{
  <-1.5, -1, -1>  // one corner position <X1 Y1 Z1>
  < 2,  0,  1>  // other corner position <X2 Y2 Z2>
}
}
sphere { < 1.7, 0.2 0 > 0.2 //pointe du pied
scale y*0.5
}
cylinder { < 0, 2.3, 0 >, <0, 4.5, 0> 0.4 }//jambes
cylinder { < 0, 0.1, 0 >, <0, 2.3, 0> 0.4 }//cuisse
sphere { < 0.2, 2.3, 0 > 0.4 }//genou
pigment { Green }
}
declare Piedgauche =
union{
difference {
cone
{< -0.1, 0, 0 > 1.2, < 1.7, 0.2, 0 > 0.2
scale y*0.5 }
box
{
  <-1.5, -1, -1>  // one corner position <X1 Y1 Z1>
  < 2,  0,  1>  // other corner position <X2 Y2 Z2>
}
}
sphere { < 1.7, 0.2 0 > 0.2 //pointe du pied
scale y*0.5
}
cylinder { < 0.5, 2.5, 0 >, <0, 4.5, 0> 0.4 }//jambes
cylinder { < 0, 0.1, 0 >, <0.5, 2.5, 0> 0.4 }//cuisse
sphere { < 0.7, 2.5, 0 > 0.4 }//genou
pigment { Green }
}
#declare TomGauche =
union {
object { tete rotate < 25, -100, -20 > translate y*9 }
object { Corps }
object { Piedgauche
rotate y*-20
translate z*0.5
}
object { Piedroit
rotate y*30
translate z*-0.5
}
}
object  { TomGauche
scale 0.8
translate <-6.5,-5,2>
}
//****************************************TOM DROITE
object { tete

rotate < -20, 0, 0 >
rotate < 40,0, 0 >
rotate <0, 50, 0>
translate<7, 0, -2 >

}


//*****************corps
cone
{<0, -2, 0>, 0.3, <0, -5, 0>, 2
pigment {RichBlue}
rotate < 0, 0, 0 >
translate <7, 0, -2 >

}

//***************************************TOM petit
object { tete
scale 0.3
rotate < 20, -90, 0 >
translate <-1.5, -3.5, 3.5 >
}


//*************corps
cone
{<0, -2, 0>, 0, <0, -5, 0>, 2
scale 0.3
pigment {SpicyPink}
translate <-1.5, -3.5, 3.5>
}
//***************************************TOM petit2
object { tete
scale 0.3
rotate < 0, -80, 0 >
rotate <25, 0, 0>
translate <-5.5, -2.5, 15.5 >
}


//*************corps
cone
{<0, -2, 0>, 0, <3, -4, -2>, 2
scale 0.3
pigment {SpicyPink}
translate <-5.5, -2.5, 15.5>
}

//***************************************fauteuil
object { fauteuil
scale 2.1
rotate y*-40
translate < -6, -3.9, 15>
}
//**************************************table
object { table
scale 0.5
rotate y*30
translate < 4.8, -3.5, 11 >
}
//**************************************television
object { Tele
scale 2.5
rotate y*35
translate <5, -0.6, 10 >
}
// *******************************************tableau
object { Cadre
       scale 1
       translate <-2.3, 4.9, 19.8 >
       }















