/*
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


camera {
	location <8,-20,40>
	look_at  <8,0,8>
}

light_source {<10,-20,40> color White}

#declare Blength = 4
#declare Bwidth  = 2
#declare Bheight = 3	// 1 or 3
#declare Bdent	 = 0    // 0 = no, 1 = max
*/
#declare Lego_block =
union {
box {<0.1,0,0.1><((Blength * 8) - 0.1),((Bheight * 3) - 1.5),1.5> }
box {<0.1,0,((Bwidth * 8) - 0.1)><((Blength * 8) - 0.1),((Bheight * 3) - 1.5),((Bwidth * 8) - 1.5)> }

box {<0.1,0,1.5><1.5,((Bheight * 3) - 1.5),((Bwidth * 8) - 1.5)> }
box {<((Blength * 8) - 0.1),0,1.5><((Blength * 8) - 1.5),((Bheight * 3) - 1.5),((Bwidth * 8) - 1.5)> }

#declare Count1 = 0
#declare Count2 = 1

#while (Count1 < Blength)
	#declare Odist1 = (Count1 * 8)
	cylinder {<(Odist1 + 4),((Bheight * 3) - 0.1),4><(Odist1 + 4),((Bheight * 3) + 1.5),4>,2.5 }
	#while (Count2 < Bwidth)
		#declare Odist2 = (Count2 * 8)
		cylinder {<(Odist1 + 4),((Bheight * 3) - 0.1),(Odist2 + 4)><(Odist1 + 4),((Bheight * 3) + 1.5),(Odist2 + 4)>,2.5 }
		#declare Count2 = (Count2 + 1)
	#end
	#declare Count1 = (Count1 + 1)
	#declare Count2 = 1
#end

#declare Count1 = 0
#declare Count2 = 1

difference {
	box {<0.1,((Bheight * 3) - 1.5),0.1><((Blength * 8) - 0.1),((Bheight * 3) - 0.1),((Bwidth * 8) - 0.1)> }
#while (Count1 < Blength)
	#declare Odist1 = (Count1 * 8)
	cylinder {<(Odist1 + 4),0,4><(Odist1 + 4),20,4>,1.25 }
	#while (Count2 < Bwidth)
		#declare Odist2 = (Count2 * 8)
		cylinder {<(Odist1 + 4),0,(Odist2 + 4)><(Odist1 + 4),20,(Odist2 + 4)>,1.25 }
		#declare Count2 = (Count2 + 1)
	#end
	#declare Count1 = (Count1 + 1)
	#declare Count2 = 1
#end
}

#if (Bwidth > 1) #declare Count1 = 1 #else #declare Count1 = (Blength + 1) #end
#declare Count2 = 2

#while (Count1 < Blength)
	#declare Odist1 = ((Count1 -1) * 8)
		difference {
			cylinder {<(Odist1 + 8),0,8><(Odist1 + 8),((Bheight * 3) - 0.1),8>,3.25 }
			cylinder {<(Odist1 + 8),-5,8><(Odist1 + 8),20,8>,2.5 }
		}
		#while (Count2 < Bwidth)
			#declare Odist2 = ((Count2 -1) * 8)
				difference {
				cylinder {<(Odist1 + 8),0,(Odist2 + 8)><(Odist1 + 8),((Bheight * 3) - 0.1),(Odist2 + 8)>,3.25 }
				cylinder {<(Odist1 + 8),-5,(Odist2 + 8)><(Odist1 + 8),20,(Odist2 + 8)>,2.5 }
			}
			#declare Count2 = (Count2 + 1)
		#end
	#declare Count1 = (Count1 + 1)
	#declare Count2 = 2
#end
}

