#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "jeep.pov"

camera
{
 location <20,15,-3>
 look_at <0,6,3>
 angle 80
}

light_source { y*20 White }
light_source { -z*49 White }
light_source
{
 <-125,100,-100> White
 spotlight
 point_at <-51,21,-11>
 atmosphere on
 atmospheric_attenuation on
 radius 20
 falloff 20
}

#declare Toy_Cube = on
#declare Floor = on
#declare Crib = on
#declare Curtains = on
#declare Room = on
#declare Chest = on
#declare bg = on
#declare Ball = on
#declare Horse = on
#declare book = on
#declare mobile = on


/* A book of nursery rhymes */

#declare page = 
union
{
 bicubic_patch
 {
  type 1
  flatness 0.1
  u_steps 3
  v_steps 3
  <-2, 3, 0> <-1, 3, -1> <1, 3, 0> <2, 3, 0>
  <-2, 1, 0> <-1, 1, -1> <1, 1, 0> <2, 1,  0>
  <-2, -1, 0> <-1, -1, -1> <1, -1, 0> <2, -1,  0>
  <-2, -2, 0> <-1, -2, -1> <1, -2, 0> <2, -2, 0>
  pigment
  {
   image_map { tga "humpty.tga" }
   scale <4,5,4>
   translate <2,-2,0> 
  }
  finish
  {
   phong 0.8
   ambient 0.2
  }
  translate x*2
 }

 bicubic_patch
 {
  type 1
  flatness 0.1
  u_steps 3
  v_steps 3
  <-2, 3, 0> <-1, 3, 0> <1, 3, -1> <2, 3, 0>
  <-2, 1, 0> <-1, 1, 0> <1, 1, -1> <2, 1,  0>
  <-2, -1, 0> <-1, -1, 0> <1, -1, -1> <2, -1,  0>
  <-2, -2, 0> <-1, -2, 0> <1, -2, -1> <2, -2, 0>
  pigment
  {
   image_map { tga "jack.tga" }
   scale <4,5,4>
   translate <2,-2,0>
  }
  finish
  {
   phong 0.8
   ambient 0.2
  }
  translate -2*x
 }
}

#if (book=on)
#declare h = 0
#while (h<=5)
object
{
 page
 rotate <90,-45,0>
 translate <5,-3.5+(h/10),13>
}
#declare h = h+1
#end
box
{
 <-4.5,3.5,0.1>
 <4.5,-2.5,0.4>
 pigment { color rgb <0.1,0.6,0.4> }
 rotate <90,-45,0>
 translate <5,-3.5,13>
}
#end


/* The bedroom */

#if (Room=on)
difference
{
 union
 {
  box
  {
   <-50,-50,-50>
   <50,50,50>
   pigment
   { // color rgb <0.7,0.6,0.5> <--- alternative colour instead of the image map
    image_map { tga "clouds.tga" }
    scale 100
    translate -y*10
   }
  }
  box
  {
   <-54,-54,-54>
   <54,54,54>
   pigment { Gray30 }
  }
 }
 box
 {
  <-49,5,0>
  <-55,20,-10>
  pigment { rgbt <1,1,1,1> }
  finish
  {
   reflection 0.2
   specular 0.4
   roughness 0.01
   diffuse 0.8
  }
 }
 box
 {
  <-49,5,-12>
  <-55,20,-22>
  pigment { rgbt <1,1,1,1> }
  finish
  {
   reflection 0.2
   specular 0.4
   roughness 0.01
   diffuse 0.8
  }
 }
 box
 {
  <-49,22,0>
  <-55,37,-10>
  pigment { rgbt <1,1,1,1> }
  finish
  {
   reflection 0.2
   specular 0.4
   roughness 0.01
   diffuse 0.8
  }
 }
 box
 {
  <-49,22,-12>
  <-55,37,-22>
  pigment { rgbt <1,1,1,1> }
  finish
  {
   reflection 0.2
   specular 0.4
   roughness 0.01
   diffuse 0.8
  }
 }
}
#end


/* The following set of code defines the process for making one of those toy cubes with
letters of the alphabet on. It is a #while loop, and the number of cubes on screen is defined
within the #while statement. A series of #switch statements re-sets the options of the cubes'
size, inset, colour, letter, position on screen, and rotation angle, respectively, with each
increment of the step variable */

#if (Toy_Cube=on)
#declare step = 1
#while (step<=3)
#switch (step)
 #case (1)
  #declare cube_size = 0.7
  #declare bevel = 1.6
  #declare shade = <1,0.4,0.6>
  #declare ascii = 65
  #declare position = <0,-3,8>
  #declare rotation = y*15
 #break

 #case (2)
  #declare cube_size = 0.7
  #declare bevel = 1.6
  #declare shade = <0.2,0.4,0.8>
  #declare ascii = 66
  #declare position = <0,-3,-2>
  #declare rotation = -x*3
 #break

 #case (3)
  #declare cube_size = 0.7
  #declare bevel = 1.6
  #declare shade = <0.1,0.5,0.5>
  #declare ascii = 67
  #declare position = <0,-3,5>
  #declare rotation = -y*30
 #break
#end
union {
 difference
 {
  object
  {
   Cube
   pigment { rgb shade }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
  }
  object
  {
   Cube
   pigment { White }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
   scale cube_size
   translate -z*bevel
  }
  object
  {
   Cube
   pigment { White }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
   scale cube_size
   translate z*bevel
  }
  object
  {
   Cube
   pigment { White }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
   scale cube_size
   translate y*bevel
  }
  object
  {
   Cube
   pigment { White }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
   scale cube_size
   translate -y*bevel
  }
  object
  {
   Cube
   pigment { White }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
   scale cube_size
   translate -x*bevel
  }
  object
  {
   Cube
   pigment { White }
   finish
   {
    diffuse 0.8
    ambient 0.2
    specular 0.2
   }
   scale cube_size
   translate x*bevel
  }
 }

 text
 {
  ttf "c:\windows\fonts\verdana.ttf"
  chr(ascii)
  1-bevel+cube_size,0
  pigment { rgb shade }
  finish
  {
   diffuse 0.8
   ambient 0.2
   specular 0.2
  }
  translate <-0.33,-0.36,-((1-bevel+cube_size)/2)>
  scale 1.6
  translate -z*(1-((1-bevel+cube_size)/2))
 }
 text
 {
  ttf "c:\windows\fonts\verdana.ttf"
  chr(ascii)
  1-bevel+cube_size,0
  pigment { rgb shade }
  finish
  {
   diffuse 0.8
   ambient 0.2
   specular 0.2
  }
  translate <-0.33,-0.36,-((1-bevel+cube_size)/2)>
  scale 1.6
  translate -z*(1-((1-bevel+cube_size)/2))
  rotate x*90
 }
 text
 {
  ttf "c:\windows\fonts\verdana.ttf"
  chr(ascii)
  1-bevel+cube_size,0
  pigment { rgb shade }
  finish
  {
   diffuse 0.8
   ambient 0.2
   specular 0.2
  }
  translate <-0.33,-0.36,-((1-bevel+cube_size)/2)>
  scale 1.6
  translate -z*(1-((1-bevel+cube_size)/2))
  rotate -x*90
 }
 text
 {
  ttf "c:\windows\fonts\verdana.ttf"
  chr(ascii)
  1-bevel+cube_size,0
  pigment { rgb shade }
  finish
  {
   diffuse 0.8
   ambient 0.2
   specular 0.2
  }
  translate <-0.33,-0.36,-((1-bevel+cube_size)/2)>
  scale 1.6
  translate -z*(1-((1-bevel+cube_size)/2))
  rotate y*90
 }
 text
 {
  ttf "c:\windows\fonts\verdana.ttf"
  chr(ascii)
  1-bevel+cube_size,0
  pigment { rgb shade }
  finish
  {
   diffuse 0.8
   ambient 0.2
   specular 0.2
  }
  translate <-0.33,-0.36,-((1-bevel+cube_size)/2)>
  scale 1.6
  translate -z*(1-((1-bevel+cube_size)/2))
  rotate y*180
 }
 text
 {
  ttf "c:\windows\fonts\verdana.ttf"
  chr(ascii)
  1-bevel+cube_size,0
  pigment { rgb shade }
  finish
  {
   diffuse 0.8
   ambient 0.2
   specular 0.2
  }
  translate <-0.33,-0.36,-((1-bevel+cube_size)/2)>
  scale 1.6
  translate -z*(1-((1-bevel+cube_size)/2))
  rotate -y*90
 }
 rotate rotation
 translate position
}
#declare step = step + 1
#end
#end


/* this is the floor of the 'room' */

#if (Floor=on)
plane
{
 y,-4
 /*
 texture { DMFWood4 }
 finish
 {
  reflection 0.1
  specular 0.05
  diffuse 0.8
  ambient 0.2
 }
 this is alternative finish and texturing
 */
 pigment { Violet }
 finish
 {
  diffuse 0.8
  ambient 0.7
  crand 0.15
 }
 clipped_by { box { <-50,-50,-50><50,50,50> } }
}
#end


/* this is the crib */

#declare head_board =
difference
{
 prism
 {
  cubic_spline
  -0.25,0.25
  12
  <-3,-4><-3,-3><-3,0><-2,0.5><-1,1.5><0,1.75><1,1.5><2,0.5><3,0><2.25,-2.5><-3,-3><-3,-4>
  scale <1.5,1,1>
  rotate -x*90
 }
 box
 {
  <-5,-1,-5>
  <5,-5,5>
 }
 pigment { rgb <0.6,0.7,0.9> }
}

#declare pillar =
lathe
{
 cubic_spline
 13
 <0,4><0.2,3><0.3,2.3><0.35,2><0.35,1.7><0.3,1.6><0.32,1.48><0.3,1.36><0.35,1.25>
 <0.37,1.13><0.2,0><0.15,-3><0,4>
 pigment { rgb <0.6,0.7,0.9> }
}

#declare leg =
box
{
 <-0.25,-0.8,-0.25>
 <0.25,0.8,0.25>
 pigment { rgb <0.6,0.7,0.9> }
}

#declare post =
box
{
 <-0.25,-3,0.25>
 <0.25,3,-0.25>
 pigment { rgb <0.6,0.7,0.9> }
}

#declare ornament =
union
{
 object { pillar scale <1,0.2,1> scale <1.1,1,1.1> }
 sphere
 {
  0,0.3
  pigment { rgb <0.6,0.7,0.9> }
  translate y*0.9
 }
 translate -y*0.5
}

#declare crib=
union
{
 object { head_board }
 box
 {
  <-0.25,-0.2,-0.25>
  <0.25,-1,-11.25>
  pigment { rgb <0.6,0.7,0.9> }
  translate x*4.3
 }
 box
 {
  <-0.25,-0.2,-0.25>
  <0.25,-1,-11.25>
  pigment { rgb <0.6,0.7,0.9> }
  translate -x*4.3
 }
 box
 {
  <-4.3,-0.2,-10.75>
  <4.3,-1,-11.25>
  pigment { rgb <0.6,0.7,0.9> }
 }
 object
 {
  post
  translate -x*4.3
  translate -y*4
 }
 object
 {
  post
  translate x*4.3
  translate -y*4
 }
 #declare Count = 1
 #while (Count<=10)
  object
  {
   pillar
   translate <4.3,-4,-Count>
  }
  #declare Count = Count+1
 #end
 #declare Count = 1
 #while (Count<=10)
  object
  {
   pillar
   translate <-4.3,-4,-Count>
  }
  #declare Count = Count+1
 #end
 #declare Count = 1
 #while (Count<=8)
  object
  {
   pillar
   translate <-4.55+Count+0.05,-4,0>
  }
  #declare Count = Count+1
 #end
 #declare Count = 1
 #while (Count<=8)
  object
  {
   pillar
   translate <-4.55+Count+0.05,-4,-11>
  }
  #declare Count = Count+1
 #end
 object
 {
  post
  translate <-4.3,-4,-11>
 }
 object
 {
  post
  translate <4.3,-4,-11>
 }
 box
 {
  <-4.55,-7,0.25>
  <4.55,-7.5,-11.25>
  pigment { rgb <0.6,0.7,0.9> }
 }
 object
 {
  leg
  translate <-4.3,-8.3,-11>
 }
 object
 {
  leg
  translate <4.3,-8.3,-11>
 }
 object
 {
  leg
  translate <-4.3,-8.3,0>
 }
 object
 {
  leg
  translate <4.3,-8.3,0>
 }
 object
 {
  ornament
  translate <-4.3,0.4,-11>
 }
 object
 {
  ornament
  translate <4.3,0.4,-11>
 }
 translate <0,6.1,6.5>
}

#if (Crib=on)
object
{
 crib
 translate <-7,0,5>
}
#end


/* these are the curtains */
#if (Curtains=on)
#declare curtain =
bicubic_patch
{
 type 1
 flatness 0.1
 u_steps 3
 v_steps 3
 <-1, 2, 0> <-0.66, 2, -0.25> <0.66, 2, 0.25> <1, 2, 0>
 <-1, 1, 0> <-0.66, 1, -0.25> <0.66, 1, 0.25> <1, 1, 0>
 <-1, -1, 0> <-0.66, -1, -0.25> <0.66, -1, 0.25> <1, -1, 0>
 <-1, -2, 0> <-0.66, -2, -0.25> <0.66, -2, 0.25> <1, -2, 0>
 pigment { Violet }
 finish
 {
  ambient 0.7
  diffuse 0.8
 }
 scale <0.5,1,1>
}
union
{
 object { curtain rotate z*180 translate -0.25*x }
 object { curtain translate 0.25*x }
 object { curtain translate -0.5*x }
 object { curtain rotate z*180 translate 0.5*x }
 object { curtain rotate z*180 translate -0.75*x }
 object { curtain translate 0.75*x }
 scale <0.4,0.6,1.3>
 rotate -y*90
 scale 16
 translate <-47,19,7>
}
union
{
 object { curtain rotate z*180 translate -0.25*x }
 object { curtain translate 0.25*x }
 object { curtain translate -0.5*x }
 object { curtain rotate z*180 translate 0.5*x }
 object { curtain rotate z*180 translate -0.75*x }
 object { curtain translate 0.75*x }
 scale <0.4,0.6,1.3>
 rotate -y*90
 scale 16
 translate <-47,19,-29>
}
#end


/* chest of drawers */

#declare handle =
torus
{
 1.6,0.3
 pigment { White*0.9 }
 finish
 {
  specular 1.0
  ambient 0.2
  diffuse 0.8
 }
 clipped_by { box { <-10,-10,0><10,10,-10> } }
 translate -z*4.2
}

#declare drawer =
union
{
 difference
 {
  object
  {
   Cube
   pigment { rgb <0.6,0.7,0.9>*0.4 }
   finish
   {
    ambient 0.2
    diffuse 0.8
   }
   scale <1.5,0.5,1.1>
  }
  object
  {
   Cube
    scale <1.3,0.5,0.9533>
   translate y*0.66
  }
  scale 4
 }
 object { handle }
}

#declare chest =
union
{
 difference
 {
  object
  {
   Cube
   scale <6.6,7.2,4.7>
  }
  object
  {
   Cube
   scale <6,2,4.4>
   translate -z*0.3001
  }
  object
  {
   Cube
   scale <6,2,4.4>
   translate -z*0.3001
   translate y*4.3
  }
  object
  {
   Cube
   scale <6,2,4.4>
   translate -z*0.3001
   translate -y*4.3
  }
  pigment { White*0.9 }
  finish
  {
   specular 0
   ambient 0.2
   diffuse 0.8
  }
 }
 object
 {
  drawer
  translate <0,0,-0.3001>
 }
 object
 {
  drawer
  translate <0,4.3,-0.3001>
 }
 object
 {
  drawer
  translate <0,-4.3,-2.5>
 }
}

#if (Chest=on)
object
{
 chest
 scale 1.5
 translate <-40.1,6.8,42.95>
}
#end


/* a beach-ball */

#if (Ball=on)
sphere
{
 0,4
 pigment
 {
  checker
  color_map
  {
   [ 0.0 color rgb <1,0,0> ]
   [ 1.0 color rgb <1,1,0> ]
  }
  scale 4
 }
 finish { phong 1.0 }
 translate <0,0,25>
}
#end


/* Rocking Horse */

#declare ear =
cone
{
 0,0.15
 y*0.4,0
}

#declare head =
union
{
 cylinder
 {
  -0.6*x,0.6*x,0.5
 }
 sphere
 {
  0,0.5
  translate -x*0.6
 }
 sphere
 {
  0,0.5
  translate x*0.6
 }
 object
 {
  ear
  translate <-0.5,0.5,0>
  rotate x*45
 }
 object
 {
  ear
  translate <-0.5,0.5,0>
  rotate -x*45
 }
 rotate -z*45
 translate <2.5,0.8,0>
}

#declare neck =
cylinder
{
 -x,x,0.2
 rotate z*45
 translate <1.8,0.7,0>
}

#declare leg =
cylinder
{
 -0.8*x,0.8*x,0.2
 rotate -z*60
}

#declare body =
union
{
 cylinder
 {
  -x,x,0.6
 }
 sphere
 {
  0,0.6
  translate -x
 }
 sphere
 {
  0,0.6
  translate x
 }
 object
 {
  leg
  translate <1.2,-1,0>
  rotate x*30
 }
 object
 {
  leg
  translate <1.2,-1,0>
  rotate -x*30
 }
 object
 {
  leg
  rotate z*120
  translate <-1.2,-1,0>
  rotate x*30
 }
 object
 {
  leg
  rotate z*120
  translate <-1.2,-1,0>
  rotate -x*30
 }
}

#declare rocker =
prism
{
 cubic_spline
 -0.25,0.25
 13
 <-5,2><-4.1,0.8><-4,1><-3.8,1><-2.1,0.3><0,0><2.1,0.3><4,1><4,1>
 <4.1,0.8><0,-0.25><-4.1,0.8><-5,2>
 rotate -x*90
 scale <0.6,1,1>
 pigment { Red*0.5 }
}

#if (Horse=on)
union
{
 object
 {
  body
 }
 object
 {
  neck
  rotate z*7
 }
 object
 {
  head
  rotate z*7
 }
 object
 {
  rocker
  translate <0,-1.8,0.8>
 }
 object
 {
  rocker
  translate <0,-1.8,-0.8>
 }
 rotate y*50
 translate <-8,0.45,-2>
 scale 2.5
 texture { DMFWood2 }
}
#end


/* a mobile */

#if (mobile=on)
light_source { x*100 White }
#declare wire =
union
{
 cylinder
 {
  <0,20,0>
  <0,14,0>
  0.1
 }
 cylinder
 {
  <-7,14,0>
  <7,14,0>
  0.1 
 }
 cylinder
 {
  <0,14,-7>
  <0,14,7>
  0.1
 }
 #declare s=1
 #while (s<=4)
 cylinder
 {
  <0,14,-7>
  <0,12,-7>
  0.1
  rotate y*90*s
 }
 #declare s=s+1
 #end
 texture { T_Chrome_3E }
 rotate y*40
}

#declare duck =
union
{
 prism
 {
  linear_sweep
  quadratic_spline
 -0.25,
  0.25,
  12,
  <-2,2><-1,0.7>,<-0.55,1.2>,<-0.5,1.2>,<-0.4,1.4>,<0,0.5>,<0.8,1.2>, 
  <0.5,-0.5>,<0,-1>,<-0.5,0>,<-1,0.7>,<-2,2>
  pigment { Yellow }
  rotate -x*90
  scale <1.5,1,1>
 } 
 cylinder
 {
  <-0.5,0.8,-0.25001>
  <-0.5,0.8,0.25001>
  0.15
  pigment { Black }
 }
 finish
 {
  phong 0.8
  diffuse 0.2
 }
 rotate y*20
 translate <0,12,-7>
}

#declare Mobile =
union
{
 object { wire }
 #declare d=1
 #while (d<=4)
 object
 {
  duck
  rotate -y*(140+90*d)
 }
 #declare d=d+1
 #end
}

object
{
 Mobile
 scale 0.9
 translate <-6.5,1.3,6.5>
}
#end


/* ...and finally the background */

#if (bg=on)
background { SkyBlue }
plane
{
 y,-2
 pigment { Green }
 clipped_by { plane { x,-55 } }
}
#end
