#include "jeep.inc"
#include "colors.inc"

#declare CSG001 = difference {
  box { // Body
    <-1, -1, -1>, <1, 1, 1>
    scale <4.159851, 7.06819, 2.158913>
    translate  <0.0, -0.50268, 0.092937>
  }
  cylinder { // RearWheelWell
    <0,0,1>, <0,0,0>, 1
    texture {
      InsideGrill
    }
    scale <3.232237, 2.953427, 9.366068>
    rotate 90.0*y
    translate  <-4.553903, -3.488711, -1.910979>
  }
  cylinder { // CockPit
    <0,0,1>, <0,0,0>, 1
    scale <2.858735, 2.579925, 8.992565>
    rotate 90.0*y
    translate  <-4.553903, 3.234966, 1.617483>
  }
  box { // PanelCutout
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <4.405498, 1.095173, 1.856963>
    translate  <0.0, 4.848235, 0.745882>
  }
  texture {
    Paint
  }
  translate  <0.0, 1.316138, 5.593587>
}
#declare Wheel = union {
  torus { // Tire
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.263231, -2.133088, 3.981301>
  }
  disc { // HubCap
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Paint
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.680745, -2.132148, 4.000363>
  }
  scale <1.53496, 1.061561, 0.929944>
  translate  <-2.829281, 0.0, -0.307805>
}
#declare Wheel1 = union {
  torus { // Tire1
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.263231, -2.133088, 3.851254>
  }
  disc { // HubCap1
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Paint
    }
    scale 1.192789
    rotate -90.0*y
    translate  <3.760736, -2.132148, 3.795444>
  }
  scale <1.53496, 1.061561, 0.929944>
  translate  <-10.224379, 0.0, -0.184683>
}
#declare Wheel2 = union {
  torus { // Tire2
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.263231, -2.133088, 3.981301>
  }
  disc { // HubCap2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Paint
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.680745, -2.132148, 4.000363>
  }
  scale <1.53496, 1.061561, 0.929944>
  translate  <-2.039414, 15.116292, -0.307805>
}
#declare Wheel3 = union {
  torus { // Tire3
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.263231, -2.133088, 3.851254>
  }
  disc { // HubCap3
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Paint
    }
    scale 1.192789
    rotate -90.0*y
    translate  <3.760736, -2.132148, 3.795444>
  }
  scale <1.53496, 1.061561, 0.929944>
  translate  <-10.958978, 15.091479, -0.184683>
}
#declare SteeringRim = difference {
  cylinder { // Steering
    <0,0,1>, <0,0,0>, 1
    texture {
      Rubber
    }
    scale <1.5, 1.5, 0.251124>
    translate  <-13.025967, 10.095831, 1.092775>
  }
  cylinder { // SteeringWheel1
    <0,0,1>, <0,0,0>, 1
    texture {
      Rubber
    }
    scale <1.25938, 1.30376, 0.365542>
    translate  <-13.025967, 10.051451, 1.004016>
  }
}
#declare SteeringWheel = union {
  object { SteeringRim }
  cylinder { // Spoke
    <0,0,1>, <0,0,0>, 1
    texture {
      Rubber
    }
    scale <0.086728, 0.064348, 1.046503>
    rotate -90.0*x
    translate  <-12.987298, 8.866125, 1.22909>
  }
  cylinder { // Spoke1
    <0,0,1>, <0,0,0>, 1
    texture {
      Rubber
    }
    scale <0.086728, 0.064348, 1.046503>
    rotate <-90.0, 0.0, -132.476715>
    translate  <-13.913681, 10.869116, 1.22909>
  }
  cylinder { // Spoke2
    <0,0,1>, <0,0,0>, 1
    texture {
      Rubber
    }
    scale <0.086728, 0.064348, 1.046503>
    rotate <-90.0, 0.0, -231.543457>
    translate  <-12.01084, 10.819041, 1.22909>
  }
  cylinder { // SteeringColumn
    <0,0,1>, <0,0,0>, 1
    texture {
      Rubber
    }
    scale <0.230369, 0.247317, 3.397877>
    translate  <-13.013054, 10.073642, -1.981915>
  }
  rotate 37.680851*x
  translate  <10.895447, -2.100288, 1.202454>
}
#declare WindShield = difference {
  box { // WindshieldFrame
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <4.446235, 0.040554, 1.575919>
    translate  <0.0, 7.833647, 9.889979>
  }
  box { // WindshieldGlass
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <4.146657, 0.110212, 1.198316>
    translate  <0.0, 7.833647, 9.912346>
  }
  translate  <0.0, -0.051662, -0.490785>
}
#declare WindScreen = union {
  object { WindShield }
  box { // Wiper1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <0.040277, 0.071932, 1.074051>
    rotate -45.0*y
    translate  <2.659704, 7.90753, 10.015376>
  }
  box { // Wiper2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <0.040277, 0.071932, 1.074051>
    rotate -45.0*y
    translate  <-1.291578, 7.907152, 10.022778>
  }
  box { // WSGlass
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass
    }
    scale <4.142263, 0.010984, 1.212642>
    translate  <-0.024955, 7.771835, 9.40535>
  }
  rotate 10.922429*x
  translate  <0.0, 1.639707, -1.332101>
}
#declare Hood = union {
  box { // UHood
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <3.642216, 3.508609, 0.28894>
    translate  <-12.080573, 11.602332, 6.403274>
  }
  cylinder { // HoodCorner1
    <0,0,1>, <0,0,0>, 1
    texture {
      Paint
    }
    scale <0.514, 0.514, 7.342383>
    rotate -90.0*x
    translate  <-8.446863, 7.769842, 6.181696>
  }
  cylinder { // HoodCorner2
    <0,0,1>, <0,0,0>, 1
    texture {
      Paint
    }
    scale <0.513976, 0.513976, 7.290607>
    rotate -90.0*x
    translate  <-15.738984, 7.801331, 6.178136>
  }
}
#declare EngineCompart = difference {
  box { // FrontBody
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <4.161582, 3.508609, 1.63337>
    translate  <-12.093847, 11.602332, 4.545736>
  }
  cylinder { // RFrontWheelWell
    <0,0,1>, <0,0,0>, 1
    texture {
      Paint
    }
    scale <1.277071, 2.807105, 5.786916>
    rotate -90.0*x
    translate  <-16.216519, 9.88294, 2.333354>
  }
  cylinder { // LFrontWheelWell
    <0,0,1>, <0,0,0>, 1
    texture {
      Paint
    }
    scale <1.277071, 2.807105, 5.786916>
    rotate -90.0*x
    translate  <-7.988083, 9.88294, 2.358545>
  }
  sphere { // Grill1
    <0,0,0>,1
    texture {
      InsideGrill
    }
    scale <0.231, 0.449565, 1.261>
    translate  <-14.095398, 15.123, 4.741568>
  }
  sphere { // Grill2
    <0,0,0>,1
    texture {
      InsideGrill
    }
    scale <0.231, 0.449565, 1.261>
    translate  <-13.109547, 15.12259, 4.741568>
  }
  sphere { // Grill3
    <0,0,0>,1
    texture {
      InsideGrill
    }
    scale <0.231, 0.449565, 1.261>
    translate  <-12.117533, 15.123, 4.742>
  }
  sphere { // Grill4
    <0,0,0>,1
    texture {
      InsideGrill
    }
    scale <0.230685, 0.449565, 1.260785>
    translate  <-11.12259, 15.12259, 4.742>
  }
  sphere { // Grill5
    <0,0,0>,1
    texture {
      InsideGrill
    }
    scale <0.231, 0.449565, 1.260785>
    translate  <-10.102891, 15.12259, 4.742>
  }
}
#declare Headlight1 = intersection {
  sphere { // Reflector
    <0,0,0>,1
    texture {
      Texture01
    }
    scale <0.6, 1.954618, 0.6>
    translate  <0.0, 20.681973, 5.055593>
  }
  sphere { // Lens
    <0,0,0>,1
    texture {
      Glass
    }
    scale 0.6
    translate  <0.0, 18.708089, 5.018401>
  }
  scale 1.5
  translate  <-15.350201, -13.641556, -1.614684>
}
#declare Headlight2 = intersection {
  sphere { // Reflector1
    <0,0,0>,1
    texture {
      Texture01
    }
    scale <0.6, 1.954618, 0.6>
    translate  <0.0, 20.681973, 5.055593>
  }
  sphere { // Lens1
    <0,0,0>,1
    texture {
      Glass
    }
    scale 0.6
    translate  <0.0, 18.708089, 5.018401>
  }
  scale 1.5
  translate  <-8.868375, -13.634027, -1.606116>
}
#declare Front = union {
  object { Hood }
  object { EngineCompart }
  object { Headlight1 }
  object { Headlight2 }
  translate  <12.094308, 0.0, 0.977042>
}
#declare SpareTire = union {
  torus { // Tire4
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.263231, -2.133088, 3.981301>
  }
  disc { // HubCap4
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Paint
    }
    scale 1.192789
    rotate -90.0*y
    translate  <4.680745, -2.132148, 4.000363>
  }
  scale <1.53496, 1.061561, 0.929944>
  rotate -90.0*z
  translate  <4.474455, -0.580131, 3.219482>
}
#declare Fender1 = union {
  box { // FrontFender1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <1.0, 2.480655, 0.164527>
    translate  <5.323634, 13.355439, 6.087139>
  }
  box { // FenderSlope1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <1.0, 1.8097, 0.177414>
    rotate 48.225124*x
    translate  <5.323634, 9.793784, 4.733691>
  }
  box { // RunningBoard1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <1.0, 2.209424, 0.176575>
    translate  <5.323634, 6.515213, 3.458467>
  }
  scale <0.826283, 1.0, 1.0>
  translate  <-9.242721, -0.743112, 0.134799>
}
#declare Fender = union {
  box { // FrontFender
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <1.0, 2.480655, 0.164527>
    translate  <5.323634, 13.355439, 6.087139>
  }
  box { // FenderSlope
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <1.0, 1.8097, 0.177414>
    rotate 48.225124*x
    translate  <5.323634, 9.793784, 4.733691>
  }
  box { // RunningBoard
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <1.0, 2.209424, 0.176575>
    translate  <5.323634, 6.515213, 3.458467>
  }
  scale <0.826, 1.0, 1.0>
  translate  <0.449774, -0.708231, 0.170073>
}
union { // Jeep
  object { CSG001 }
  box { // Bumper
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <4.869819, 0.19404, 0.480324>
    translate  <0.012109, 16.009461, 3.769352>
  }
  box { // Bumper1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paint
    }
    scale <4.869819, 0.19404, 0.480324>
    translate  <-0.114449, -6.73969, 3.963382>
  }
  object { Wheel }
  object { Wheel1 }
  object { Wheel2 }
  object { Wheel3 }
  object { SteeringWheel }
  object { WindScreen }
  object { Front }
  box { // SeatCushion
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SeatCover
    }
    scale <3.821793, 1.103744, 0.360653>
    translate  <0.0, 3.734774, 5.083443>
  }
  box { // SeatBack
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SeatCover
    }
    scale <3.821793, 1.103744, 0.360653>
    rotate 110.105377*x
    translate  <0.0, 2.386106, 6.328368>
  }
  object { SpareTire }
  object { Fender1 }
  object { Fender }
  cylinder { // Taillight
    <0,0,1>, <0,0,0>, 1
    texture {
      RedLens
    }
    scale 0.352845
    rotate -90.0*x
    translate  <-3.408825, -6.820703, 5.234291>
  }
  cylinder { // GasCap
    <0,0,1>, <0,0,0>, 1
    texture {
      Paint
    }
    scale 0.389174
    rotate -90.0*y
    translate  <4.461853, -4.915788, 6.663107>
  }
  rotate -x*90
  rotate y*45
  translate  <-15, -15, -20.140987>
  scale 0.3
}


