// parameters for pavement tiling
#declare x_start = -50
#declare x_finish = 40
#declare y_start = -100
#declare y_finish = 100
#declare tile_size = 4
#declare gap_size = 0.1

// parameter for random tile rotations
#declare perfect = 0
#declare good = 1
#declare fair = 2
#declare rough = 3
#declare chaotic = 5
#declare smoothness = chaotic // rougth, fair or good
#declare randomizer = seed(0)

// create the basic tile
#declare the_tile = box
  {
   <-(tile_size/2)+(gap_size/2), -(tile_size/2)+(gap_size/2), -(tile_size/4)>,
   < (tile_size/2)-(gap_size/2),  (tile_size/2)-(gap_size/2), 0 >
  }

// we nee counters
#declare x_current = x_start
#declare offset_flag = 0 // to implement row offset

union {
#while (x_current < x_finish)
  #declare y_current = y_start
  #while (y_current < y_finish)
    object { the_tile
      texture {
        light_concrete
          translate <50*rand(randomizer),40*rand(randomizer),20*rand(randomizer)>
          rotate <0,0,5*rand(randomizer)>
      }
      rotate <smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer)), 0.1*smoothness*(0.5-rand(randomizer))>
      translate < x_current, y_current+(offset_flag*(tile_size/2)), 0>
    }
    #declare y_current = y_current + tile_size
  #end
  #declare x_current = x_current + tile_size
  // update the offset_flag between rows
  #if (offset_flag = 0)
    #declare offset_flag = 1
  #else
    #declare offset_flag = 0
  #end
#end

// global transformation for this particular scene
rotate x*-90
rotate y*90
translate y*0.42
translate z*-5
}

