/*************************

           Dig In! 
      by Dale Cieslak
     dciesla@uakron.edu
          
 *************************/
#include "colors.inc"
#include "textures.inc"
#include "drink.inc"
#include "fork.inc"

// the camera
camera
{
  location  <0.0 , 14.0 , 1.0>
  look_at   <0.0 , 0.1 , 1.0>
}

// fill light
light_source
   {
   <0 0 0>
   color red 0.65  green 0.65 blue 0.75  // light's color
   translate <0, 12, 4>
   shadowless
   }

// main light source
light_source
   {
   <0, 20, 5>
   color red .87 green .85 blue 0.65
   area_light <3, 0, 0>, <0, 0, 3>, 3, 3
   adaptive 1
   jitter
   }

// fill light
light_source
   {
   <0, -3, -12>
   color red 0.35 green 0.35 blue 0.35
   shadowless
   }

// the head shape
#declare HEAD =
blob
   {
   threshold 0.15
   // jawline
   sphere
      {
      < 0.0 0.0 0.0 >, 1.5, 10
      scale < 1 0.9 1.2 >
      rotate < 35 0 0>
      translate < 0 0 1.5>
      }
   // left cheek
   sphere
      {
      < 0.0 0.0 0.0 >, 1.5, 10
      scale < .75 .9 .7 >
      rotate < -65 0 0>
      translate < -.25 .45 1.1>
      }
   // right cheek
   sphere
      {
      < 0.0 0.0 0.0 >, 1.5, 10
      scale < .75 .9 .7 >
      rotate < -65 0 0>
      translate < .25 .45 1.1>
      }
   // forehead
   sphere
      {
      < 0.0 0.0 0.0 >, 1.25, 10
      scale < 1.25 1.25 1 >
      translate < 0 0 2>
      }
   // the nose
   sphere
      {
      < 0.0 0.0 0.0>, 1.25, 1
      scale <.165 .185 .175>
      translate < 0 1.20 1.6>
      }
   sphere
      {
      < 0.0 0.0 0.0>, 1.25, 1
      scale <.165 .185 .175>
      translate < 0 1.22 1.5>
      }
   sphere
      {
      < 0.0 0.0 0.0>, 1.15, 1
      scale <.165 .185 .175>
      translate < 0 1.27 1.4>
      }
   sphere
      {
      < 0.0 0.0 0.0>, 1.15, 1
      scale <.165 .185 .175>
      translate < 0 1.33 1.25>
      }
   sphere
      {
      < 0.0 0.0 0.0>, 1.15, 1
      scale <.165 .185 .175>
      translate < 0 1.41 1.15>
      }
   sphere
      {
      < 0.0 0.0 0.0 >, 1.15, 1
      scale <.185 .185 .175>
      translate < 0 1.47 1.05>
      }
   // left nostril
   sphere
      {
      < 0.0 0.0 0.0 >, .35, 2
      scale <.35 .35 .35>
      translate < -.15 1.42 1>
      }
   // right nostril
   sphere
      {
      < 0.0 0.0 0.0 >, .35, 2
      scale <.35 .35 .35>
      translate < .15 1.42 1>
      }
   // mouth
   cylinder
      {
      <0.0 0.0 1>,
      <0.0 0.0 0.0>, 1, 2
      scale <.25 .5 .20>
      rotate <35 0 0>
      translate < .1 1.2 .5>
      }
   cylinder
      {
      <0.0 0.0 1>,
      <0.0 0.0 0.0>, 1, 2
      scale <.25 .5 .20>
      rotate <35 0 0>
      translate < -.1 1.2 .5>
      }
   cylinder
      {
      <0.0 0.0 1>,
      <0.0 0.0 0.0>, 1, -2
      scale <.325 .20 .10>  // .325 .2 .2
      rotate <35 0 0>
      translate <0 1.35 .575>
      }
   // ears
   // left ear
   sphere
      {
      <0.0 0.0 0.0>, 1, 2
      scale <.25 .1 .45>
      rotate <0 0 335>
      translate <1.53 0 1.21>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1, 2
      scale <.2 .1 .35>
      rotate <0 0 320>
      translate <1.45 0 1.0>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1, -2
      scale <.25 .2 .3>
      translate <1.50 0 1.20>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1, -1.5
      scale <.15 .15 .15>
      translate <1.48 0 1.05>
      }
   // right ear
   sphere
      {
      <0.0 0.0 0.0>, 1, 2
      scale <.25 .1 .45>
      rotate <0 0 25>
      translate <-1.53 0 1.21>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1, 2
      scale <.2 .1 .35>
      rotate <0 0 40>
      translate <-1.45 0 1.0>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1, -2
      scale <.25 .2 .3>
      translate <-1.51 0 1.20>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1, -1.5
      scale <.15 .15 .15>
      translate <-1.48 0 1.05>
      }
   pigment
      {
      image_map
         {
         gif "facemap.gif"
         map_type 0
         interpolate 2
         once
         }
      rotate <90 0 0>
      translate <-.455 0 .05>
      scale < 4 3 3>
      }
   finish {ambient 0.3}
   rotate < 0 0 0>
   }

// eye texture
// adapted from Lorenzo Quintana Juez's eye texture
#declare Iris =
   pigment
      {
      radial
      frequency 80
      color_map
         {
         [ 0.0 rgb 0 ]
         [ 0.4 rgb <.2,.1,.05> ]
         [ 0.4 rgb <.4,.3,.25> ]
         [ 1.0 rgb <.4,.3,.25> ]
         }
      rotate 90*x
      }

#declare EyeBall =
   texture
      {
      pigment
         {
         gradient z
         pigment_map
            {
            [ 0.0000 rgb 0 ]
            [ 0.0048 rgb 0 ]
            [ 0.0048 Iris ]
            [ 0.0350 Iris ]
            [ 0.0450 rgb 0 ]
            [ 0.0450 rgb <.9,.85,.88> ]
            [ 1.0000 rgb <.9,.85,.88> ]
            }
         }
      finish
         {
         diffuse .8
         ambient .3
         specular 2
         roughness .004
         }
      scale <1,1,4>
      translate -2*z
   }

// eye
#declare EYE =
   sphere
      {
      <0, 0, 0>, 1
      texture
         {
         EyeBall
         scale .5
         rotate <90 0 0>
         }
      }

#declare EYE_MUSCLE =
   difference
      {
      sphere
         {
         <0, 0, 0>, 1.0
         }
      cylinder
         {
         <0, 0, 0>,<0, 1.5, 0>,  .75
         }
      pigment {color red .9 green .5 blue .5}
      finish {ambient 0.3 specular 2 roughness .004}
      }

#declare BOT_EYELID =
   difference
      {
      sphere
         {
         <0, 0, 0>, 1.0
         }
      box
         {
         <-1.3, -1.3, 0>,
         <1.3, 1.3, 1.3>
         }
      pigment {color red .8 green .6 blue .5}
      finish {ambient 0.3}
      }

#declare TOP_EYELID =
   difference
      {
      sphere
         {
         <0, 0, 0>, 1.0
         }
      box
         {
         <-1.3, -1.3, -1.3>,
         <1.3, 1.3, 0>
         }
      pigment {color red .8 green .6 blue .5}
      finish {ambient 0.3}
      }

#declare EYELIDS =
   union
      {
      object
         {
         BOT_EYELID
         rotate <-25 0 0>
         }
      object
         {
         TOP_EYELID
         rotate <45 0 0>
         }
      }

#declare HAIR =
blob
   {
   threshold .15
   sphere
      {
      <0.0 0.0 0.0>, 1.25, 10
      scale <1.25 1.26 1>
      translate <0.2 0 2.4>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1.25, 10
      scale <1.225 1 1.25>
      translate <0 .35 0>
      rotate <180 0 0>
      translate <.175 0 1.75>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1.25, 10
      scale <1.20 1 1.25>
      translate <0 .35 0>
      rotate <180 0 0>
      translate <.125 0 1.5>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1.25, 10
      scale <1.25 1.26 1>
      translate <-0.2 0 2.4>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1.25, 10
      scale <1.225 1 1.25>
      translate <0 .35 0>
      rotate <180 0 0>
      translate <-.175 0 1.75>
      }
   sphere
      {
      <0.0 0.0 0.0>, 1.25, 10
      scale <1.20 1 1.25>
      translate <0 .35 0>
      rotate <180 0 0>
      translate <-.125 0 1.5>
      }
   pigment
      {
      image_map
         {
         gif "hairmap.gif"
         map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
         interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
         transmit 20 .75
         transmit 18 1
         once
         }
      rotate <135 0 0>
      translate <-.5 0 0>
      scale < 4 4 4>
      }
   normal
      {
      bump_map
         {
         gif "hairmap.gif"
         map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
         interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
         bump_size 2
         use_color
         once
         }
      rotate <135 0 0>
      translate <-.5 0 0>
      scale < 4 4 4>

      }
   finish
      {
      ambient 0.4
      phong 0.05
      phong_size 1
      }
   }

#declare BODY =
blob
   {
   threshold .15
   cylinder
      {
      <0.0 0.0 3.0>,
      <0.0 0.0 0.0>, 1, 2
      scale <1.7 .75 1>
      rotate <180 0 0>
      translate <-.9 .25 .5>
      }
   cylinder
      {
      <0.0 0.0 3.0>,
      <0.0 0.0 0.0>, 1, 2
      scale <1.7 .75 1>
      rotate <180 0 0>
      translate <.9 .25 .5>
      }
   cylinder
      {
      <0.0 0.0 3.0>,
      <0.0 0.0 0.0>, 1, 2
      scale <1.8 .75 1>
      rotate <180 0 0>
      translate <0 .25 .5>
      }
   cylinder
      {
      <0.0 0.0 0.0>,
      <0.0 0.0 2.0>, .75, 2
      rotate <170 0 0>
      rotate <0 315 0>
      translate <2.0 0 .5>
      }
   cylinder
      {
      <0.0 0.0 0.0>,
      <0.0 0.0 2.0>, .75, 2
      rotate <200 0 0>
      rotate <0 85 0>
      translate <-2.0 0 .75>
      }
   cylinder
      {
      <0.0 0.0 0.0>,
      <0.0 0.0 1.5>, .65, 2
      rotate <260 0 0>
      rotate <0 355 0>
      translate <-4 1.20 .5>
      }
   cylinder
      {
      <0.0 0.0 0.0>,
      <0.0 0.0 1.5>, .65, 2
      translate <0 1.00 .25>
      rotate <250 0 0>
      rotate <0 355 0>
      translate <3.4 0 0>
      }
   pigment
      {
      color blue 1
      }
   rotate <350 0 0>
   }

#declare RIGHTHAND =
blob
   {
   threshold .19
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .26>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-4.67 3.5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .4>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-4.67 3.5 .1>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .45 .45>
      translate <0 0 .2>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-4.45 3.6 0>
      }
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .28>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-4.24 3.5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-4.24 3.5 .15>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .45 .45>
      translate <0 0 .2>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-4.02 3.6 0>
      }
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .3>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.81 3.5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.81 3.5 .25>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .45 .45>
      translate <0 0 .2>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.59 3.6 0>
      }
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .3>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.38 3.5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 .3>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.38 3.5 .15>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 .7>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.25 3.25 .15>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 .8>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <-3.23 3.25 .15>
      }
   pigment
      {
      color red .8 green .6 blue .5
      }
   finish
      {
      ambient 0.3
      }

   scale <.57 .85 .77>
   translate <-1.7 .20 .1>
   }

#declare LEFTHAND =
blob
   {
   threshold .19
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .26>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <4.67 .5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .4>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <4.67 .5 .1>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .45 .45>
      translate <0 0 2.4>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <4.45 .6 0>
      }
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .28>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <4.24 .5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <4.24 .5 .15>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .45 .45>
      translate <0 0 2.4>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <4.02 .6 0>
      }
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .3>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.81 .5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.81 .5 .25>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .45 .45>
      translate <0 0 2.4>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.59 .6 0>
      }
   cylinder
      {
      <0.0 0.0 2.0>,
      <0.0 0.0 0.0>, .8, 3
      scale <.45 .55 .3>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.38 .5 0>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 2.5>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.38 .5 .15>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 2.9>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.25 .25 .15>
      }
   sphere
      {
      <0.0 0.0 0.0>, .8, 1
      scale <.45 .55 .45>
      translate <0 0 3.0>
      rotate <180 0 0>
      rotate <10 0 0>
      translate <3.23 .25 .15>
      }
   pigment
      {
      color red .8 green .6 blue .5
      }
   finish
      {
      ambient 0.3
      }

   scale <.57 .85 .77>
   translate <1.30 .60 0>
   }

/**********************

    The actual scene

 **********************/

// The complete head
union
{
  object
     {
     EYE
     rotate <10 350 13>
     scale <.25 .15 .25>
     translate <-.37 1.245 1.5>
     }
  object
     {
     EYE_MUSCLE
     scale <.25 .15 .25>
     rotate <0 0 15>
     translate <-.37 1.24 1.5>
     }
  object
     {
     EYELIDS
     scale <.25 .15 .25>
     rotate <0 0 15>
     translate <-.4 1.275 1.5>
     }
  object
     {
     EYE
     rotate <10 10 347>
     scale <.25 .15 .25>
     translate <.37 1.245 1.5>
     }
  object
     {
     EYE_MUSCLE
     scale <.25 .15 .25>
     rotate <0 0 345>
     translate <.37 1.24 1.5>
     }
  object
     {
     EYELIDS
     scale <.25 .15 .25>
     rotate <0 0 345>
     translate <.4 1.275 1.5>
     }
  object {
     HEAD
     }
  object
     {
     HAIR
     }

  rotate <350 0 0>
  translate <0 1.25 0>
  }

// the complete body
object
   {
   BODY
   }

object
   {
   RIGHTHAND
   }

object
   {
   LEFTHAND
   }


// the table
box
   {
   <-1, -1, -1>  // one corner position <X1 Y1 Z1>
   < 1,  1,  1>  // other corner position <X2 Y2 Z2>
   scale < 8 4 .1>
   translate <0 0 2.5>
   rotate <180 0 0>
   translate <0 5 0>
   pigment
      {
      image_map
         {
         gif "cloth.gif"
         map_type 0 // planar
         interpolate 2
         }
      scale <3 3 3>
      }
   finish
      {
      ambient 0.3
      }
   }

// the plate
blob
   {
   threshold .15
   cylinder
      {
      <0 0 0>, <0 0 .5>, 2.5, 2
      scale <1 1 .05>
      translate <0 0 .1>
      }
   cylinder
      {
      <0 0 0>, <0 0 .5>, 2.25, 2
      scale <1 1 .05>
      translate <0 0 .15>
      }
   cylinder
      {
      <0 0 0>, <0 0 .5>, 2.1, -4
      scale <1 1 .06>
      translate <0 0 .04>
      }
   pigment
      {
      color red .9 green .9 blue .9
      }
   finish
      {
      ambient 0.5
      phong .5
      phong_size 50
      }
   translate <0 0 2.25>
   rotate <180 0 0>
   translate <0 2.5 0>
   }

// the wall
box
   {
   <-1, -1, -1>
   < 1,  1,  1>
   pigment
      {
      image_map
         {
         tga "wallpaper.tga"
         map_type 0
         }
      rotate <90 0 0>
      scale <.125 .125 .125>
      }
      
   scale <20 .1 20>
   translate <0 15 0>
   rotate <180 0 0>
   }

// the glass of milk
object
   {
   DRINK
   scale <.35 .35 .35>
   translate <0 0 2>
   rotate <180 0 0>
   translate <2.25 5.5 0>
   }

// the fork
object
   {
   FORK
   scale <.65 .6 .6>
   translate <0 0 .35>
   rotate <180 0 0>
   translate <-2.85 3.35 0>
   }

#declare NoodlePigment =
pigment
   {
   bozo
   pigment_map
      {
      [0.0
       marble
       turbulence 0.5
       color_map
          {
          [0.0 red 1 green 1 blue 1 transmit 1]
          [0.5 red 1 green 1 blue 1 transmit 1]
          [0.5 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .4 transmit 0]
          }
       rotate <25 10 0>
       scale .25
      ]
      [0.6
       marble
       turbulence 0.5
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.5 red 1 green 1 blue 1 transmit 1]
          [0.5 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <25 10 0>
       scale .25
      ]
      [0.6
       marble
       turbulence 0.5
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.5 red 1 green 1 blue 1 transmit 1]
          [0.5 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <5 30 0>
       scale .25
      ]
      [0.95
       marble
       turbulence 0.3
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.5 red 1 green 1 blue 1 transmit 1]
          [0.5 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <5 30 0>
       scale .5
      ]
      [0.95 color red 1 green 1 blue 1 transmit 1]
      [1.0  color red 1 green 1 blue 1 transmit 1]
      }
   }

#declare Noodle2Pigment =
pigment
   {
   bozo
   pigment_map
      {
      [0.0
       marble
       turbulence 0.5
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.25 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <25 10 0>
       scale .25
      ]
      [0.6
       marble
       turbulence 0.5
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.25 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <25 10 0>
       scale .25
      ]
      [0.6
       marble
       turbulence 0.5
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.25 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <5 30 0>
       scale .25
      ]
      [0.95
       marble
       turbulence 0.3
       color_map
          {
          [0.0  red 1 green 1 blue 1 transmit 1]
          [0.25 red .5 green .4 blue .3 transmit 0]
          [1.0 red 1 green .6 blue .3 transmit 0]
          }
       rotate <5 30 0>
       scale .5
      ]
      [0.95 color red 1 green 1 blue 1 transmit 1]
      [1.0  color red 1 green 1 blue 1 transmit 1]
      }
   }

#declare NoodleTexture =
texture
       {
       pigment {NoodlePigment}
       finish {ambient 0.3}
       scale .5
       translate <0 .85 0>
       }

#declare Noodle2Texture =
texture
       {
       pigment {Noodle2Pigment}
       finish {ambient 0.3}
       scale .5
       translate <0 .85 0>
       }

//spaghetti1
blob
   {
    threshold .25
    sphere
       {
       <0 1 0>, 1, 2
       }
    sphere
       {
       <1 1.5 0>, 1, 2
       scale <1 1 1.25>
       }
    sphere
       {
       <1.5 1.5 0>, 1, 2
       scale <.5 .5 1.5>
       }
    sphere
       {
       <-.75 1.5 0>, 1, 2
       }
    sphere
       {
       <.5 2 0>, 1, 2
       }
    sphere
       {
       <-1 1 0>, 1, 2
       scale <1 1 2>
       }
    sphere
       {
       <0 .25 0>, 1, 2
       scale <1 1 1.5>
       }
    sphere
       {
       <.25 .5 0>, 1, 2
       scale <1 1 3>
       }
    sphere
       {
       <0 2.5 .5>, 1, 2
       scale <.1 .1 3>
       }
    sphere
       {
       <0 2.6 1>, 1, 2
       scale <.1 .1 3>
       }
    sphere
       {
       <.16 7 1.5>, 1, 2
       scale <.1 .1 3>
       }
    sphere
       {
       <.25 7 2>, 1, 2
       scale <.1 .1 3>
       }
    sphere
       {
       <.14 7 2.5>, 1, 2
       scale <.12 .12 2>
       }
    sphere
       {
       <.21 7 3>, 1, 2
       scale <.13 .13 2>
       }
    sphere
       {
       <.13 7 3.25>, 1, 2
       scale <.15 .15 2.25>
       }
    
    scale <1 1 .15>
    translate <0 3.75 0>

    texture
       {
       NoodleTexture
       }
    texture
       {
       pigment
          {
          bozo
          color_map
             {
             [0.0 red 1 transmit .4]
             [0.35 red 1 transmit .65]
             [0.55 red 1 transmit .75]
             [1.0 red 1 green 1 blue 1 transmit 1]
             }
          scale .55
          }
       finish {ambient 0.3}
       }
    scale <1 1 2>
    translate <0 ,-2, -2.35>
    hollow
    }

//spaghetti2
blob
   {
    threshold .25
    sphere
       {
       <0 1 0>, 1, 2
       }
    sphere
       {
       <1 1.5 0>, 1, 2
       }
    sphere
       {
       <.5 2 0>, 1, 2
       }
    sphere
       {
       <-1 1 0>, 1, 2
       scale <1 1 1.5>
       }
    sphere
       {
       <0 .25 0>, 1, 2
       scale <1 1 1.5>
       }
    sphere
       {
       <.25 .5 0>, 1, 2
       scale <1 1 1>
       }
    scale <1 1 .125>

    texture
       {
       Noodle2Texture
       rotate <10 0 45>
       }
    translate <0 3.75 0>
    scale <1 1 1.9>
    translate <0 ,-2, -2.36>
    }


