

// File: fapeluch.pov
// Vers: 3.01
// Desc: Image for Childhood IRTC
// Date: 12/22/97
// Auth: Franck Angella


#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

camera
{
    location <0.0, 1.0, -6.0>
    look_at <0.0, 0.0, 0.0>
}

light_source
{
    <1.0, 1.0, -5.0>
    color rgb <1.0, 2.0, 5.0>
    spotlight
    point_at <0.0, 0.0, 0.0>
    radius 10.0
    tightness 10.0
    falloff 25.0
}

light_source
{
    <1.0, 1.0, -5.0>
    color rgb <0.125, 0.125, 0.2>
    shadowless
}

#declare Qualite = 5000.0

/******************************************************/

#declare R1 = seed(1)

#declare Latte = box
{
    <-1000.0, -1.4, -1.0>
    <1000.0, -1.5, 1.0>
    texture
    {
        T_Wood5
        finish { reflection 0.08 }
        scale 5.0
        rotate 90.0*y
    }
}

#declare Sol = union
{
    object { Latte }
    object { Latte translate 2.1*z translate rand(R1)*10.0*x }
    object { Latte translate -2.1*z translate rand(R1)*10.0*x }
    object { Latte translate 4.2*z translate rand(R1)*10.0*x }
    object { Latte translate -4.2*z translate rand(R1)*10.0*x }
    object { Latte translate 6.3*z translate rand(R1)*10.0*x }
    object { Latte translate 8.4*z translate rand(R1)*10.0*x }
    object { Latte translate 10.5*z translate rand(R1)*10.0*x }
    object { Latte translate 12.6*z translate rand(R1)*10.0*x }
    object { Latte translate -6.3*z translate rand(R1)*10.0*x }
    object { Latte translate -8.4*z translate rand(R1)*10.0*x }
    object { Latte translate -10.5*z translate rand(R1)*10.0*x }
    object { Latte translate -12.6*z translate rand(R1)*10.0*x }
}

#declare Murs = union
{
    box
    {
        <-100.0, -2.0, 12.59>
        <100.0, 100.0, 30.0>
        pigment
        {
           image_map
           {
               tga "papier.tga"
           }
           scale <3.0, 3.0, 3.0>
        }
    }
    box
    {
        <-100.0, -2.0, -12.59>
        <100.0, 100.0, -30.0>
        pigment
        {
           image_map
           {
               tga "papier.tga"
           }
           scale <3.0, 3.0, 3.0>
        }
    }
    box
    {
        <-12.59, -2.0, -100.0>
        <-30.0, 100.0, 100.0>
        pigment
        {
           image_map
           {
               tga "papier.tga"
           }
           scale <3.0, 3.0, 3.0>
           rotate 90.0*y
        }
    }
    box
    {
        <12.59, -2.0, -100.0>
        <30.0, 100.0, 100.0>
        pigment
        {
           image_map
           {
               tga "papier.tga"
           }
           scale <3.0, 3.0, 3.0>
           translate -1.0*x
           rotate 90.0*y
        }
    }
}

#declare Plinthes = union
{
    box
    {
        <-100.0, -2.0, 11.5>
        <100.0, -0.4, 30.0>
    }
    box
    {
        <-100.0, -2.0, -11.5>
        <100.0, -0.4, -30.0>
    }
    box
    {
        <-11.5, -2.0, -100.0>
        <-30.0, -0.4, 100.0>
    }
    box
    {
        <11.5, -2.0, -100.0>
        <30.0, -0.4, 100.0>
    }
    texture
    {
        pigment { White }
        finish { reflection 0.05 }
    }
}

#declare Plafond = box
{
    <-110.0, 99.0, -110.0>
    <110.0, 101.0, 110.0>
    pigment { White }
}

/******************************************************/

#declare Decor = union
{
    object { Sol }
    object { Murs }
    object { Plafond }
    object { Plinthes }
    rotate -5.0*y
}


/******************************************************/

#declare S1 = seed(1)
#declare S2 = seed(2)
#declare S3 = seed(3)
#declare S4 = seed(4)
#declare S5 = seed(5)
#declare S6 = seed(6)

#declare Nb = Qualite
#declare EpaisseurBase = 0.04
#declare dEpaisseurBase = 0.05
#declare RayonEntortillement = 0.05
#declare dRayonEntortillement = 0.1
#declare HauteurEntortillement = 0.2
#declare dHauteurEntortillement = 0.05
#declare AngleEntortillement = 10.0
#declare dAngleEntortillement = 4.0
#declare PasEntortillement = 5.0

/****************************************************/
/* CORPS                                            */
/****************************************************/

#declare Rx = 1.0
#declare Ry = 1.0
#declare Rz = 1.0
#declare Co = 1.0

#declare Corps = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    scale <Rx, Ry, Rz>
    pigment { Pink }
}

#declare Duvet = union
{
    #while (Co <= Nb)
           #declare Alpha = 2.0*pi*rand(S1)
           #declare Beta = 2.0*pi*rand(S2)
           #declare X = Rx*cos(Alpha)*cos(Beta)
           #declare Z = Rz*sin(Alpha)*cos(Beta)
           #declare Y = Ry*sin(Beta)
           #declare N = sqrt(X*X+Y*Y+Z*Z)
           #declare Rayon = RayonEntortillement+dRayonEntortillement*2.0*(rand(S3)-0.5)
           #declare Base = EpaisseurBase+dEpaisseurBase*2.0*(rand(S4)-0.5)
           #declare Hauteur = HauteurEntortillement+dHauteurEntortillement*2.0*(rand(S5)-0.5)
           #declare Angle = AngleEntortillement+dAngleEntortillement*2.0*(rand(S6)-0.5)
           #declare NbCones = Angle/PasEntortillement
           #declare Co2 = 0.0
           #while (Co2 < NbCones)
                  #declare X1 = (Co2/NbCones)*Hauteur
                  #declare X2 = ((Co2+1.0)/NbCones)*Hauteur
                  #declare RayonCourant1 = Rayon*(1.0-(Co2/NbCones))
                  #declare RayonCourant2 = Rayon*(1.0-((Co2+1.0)/NbCones))
                  #declare Y1 = RayonCourant1*cos((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Y2 = RayonCourant2*cos(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z1 = RayonCourant1*sin((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z2 = RayonCourant2*sin(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare B1 = Base*(1.0-(Co2/NbCones))
                  #declare B2 = Base*(1.0-((Co2+1.0)/NbCones))
                  cone
                  {
                        <X1, Y1, Z1>, B1
                        <X2, Y2, Z2>, B2
                        translate N*x
                        rotate y*Alpha*(180.0/pi)
                        rotate z*Beta*(180.0/pi)
                        pigment { Pink }
                  }
                  #declare Co2 = Co2+1.0
           #end
           #declare Co = Co+1.0
    #end
}

/****************************************/

object { Corps scale <0.7, 1.1, 0.5> translate -0.2*y translate 0.1*z }
object { Duvet scale <0.7, 1.1, 0.5> translate -0.2*y translate 0.1*z }

/****************************************/


/****************************************************/
/* TETE                                             */
/****************************************************/

#declare Rx = 1.0
#declare Ry = 1.0
#declare Rz = 1.0
#declare Co = 1.0

#declare Corps = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    scale <Rx, Ry, Rz>
    pigment { Pink }
}

#declare Duvet = union
{
    #while (Co <= Nb)
           #declare Alpha = 2.0*pi*rand(S1)
           #declare Beta = 2.0*pi*rand(S2)
           #declare X = Rx*cos(Alpha)*cos(Beta)
           #declare Z = Rz*sin(Alpha)*cos(Beta)
           #declare Y = Ry*sin(Beta)
           #declare N = sqrt(X*X+Y*Y+Z*Z)
           #declare Rayon = RayonEntortillement+dRayonEntortillement*2.0*(rand(S3)-0.5)
           #declare Base = EpaisseurBase+dEpaisseurBase*2.0*(rand(S4)-0.5)
           #declare Hauteur = HauteurEntortillement+dHauteurEntortillement*2.0*(rand(S5)-0.5)
           #declare Angle = AngleEntortillement+dAngleEntortillement*2.0*(rand(S6)-0.5)
           #declare NbCones = Angle/PasEntortillement
           #declare Co2 = 0.0
           #while (Co2 < NbCones)
                  #declare X1 = (Co2/NbCones)*Hauteur
                  #declare X2 = ((Co2+1.0)/NbCones)*Hauteur
                  #declare RayonCourant1 = Rayon*(1.0-(Co2/NbCones))
                  #declare RayonCourant2 = Rayon*(1.0-((Co2+1.0)/NbCones))
                  #declare Y1 = RayonCourant1*cos((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Y2 = RayonCourant2*cos(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z1 = RayonCourant1*sin((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z2 = RayonCourant2*sin(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare B1 = Base*(1.0-(Co2/NbCones))
                  #declare B2 = Base*(1.0-((Co2+1.0)/NbCones))
                  cone
                  {
                        <X1, Y1, Z1>, B1
                        <X2, Y2, Z2>, B2
                        translate N*x
                        rotate y*Alpha*(180.0/pi)
                        rotate z*Beta*(180.0/pi)
                        pigment { Pink }
                  }
                  #declare Co2 = Co2+1.0
           #end
           #declare Co = Co+1.0
    #end
}

/****************************************/

object { Corps scale <0.6, 0.4, 0.9> rotate -10.0*y rotate 10.0*z rotate 5.0*x translate 1.2*y translate -0.4*z }
object { Duvet scale <0.6, 0.4, 0.9> rotate -10.0*y rotate 10.0*z rotate 5.0*x translate 1.2*y translate -0.4*z }

/****************************************/


/****************************************************/
/* PIED 1                                           */
/****************************************************/

#declare Rx = 1.0
#declare Ry = 1.0
#declare Rz = 1.0
#declare Co = 1.0

#declare Corps = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    scale <Rx, Ry, Rz>
    pigment { Pink }
}

#declare Duvet = union
{
    #while (Co <= Nb)
           #declare Alpha = 2.0*pi*rand(S1)
           #declare Beta = 2.0*pi*rand(S2)
           #declare X = Rx*cos(Alpha)*cos(Beta)
           #declare Z = Rz*sin(Alpha)*cos(Beta)
           #declare Y = Ry*sin(Beta)
           #declare N = sqrt(X*X+Y*Y+Z*Z)
           #declare Rayon = RayonEntortillement+dRayonEntortillement*2.0*(rand(S3)-0.5)
           #declare Base = EpaisseurBase+dEpaisseurBase*2.0*(rand(S4)-0.5)
           #declare Hauteur = HauteurEntortillement+dHauteurEntortillement*2.0*(rand(S5)-0.5)
           #declare Angle = AngleEntortillement+dAngleEntortillement*2.0*(rand(S6)-0.5)
           #declare NbCones = Angle/PasEntortillement
           #declare Co2 = 0.0
           #while (Co2 < NbCones)
                  #declare X1 = (Co2/NbCones)*Hauteur
                  #declare X2 = ((Co2+1.0)/NbCones)*Hauteur
                  #declare RayonCourant1 = Rayon*(1.0-(Co2/NbCones))
                  #declare RayonCourant2 = Rayon*(1.0-((Co2+1.0)/NbCones))
                  #declare Y1 = RayonCourant1*cos((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Y2 = RayonCourant2*cos(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z1 = RayonCourant1*sin((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z2 = RayonCourant2*sin(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare B1 = Base*(1.0-(Co2/NbCones))
                  #declare B2 = Base*(1.0-((Co2+1.0)/NbCones))
                  cone
                  {
                        <X1, Y1, Z1>, B1
                        <X2, Y2, Z2>, B2
                        translate N*x
                        rotate y*Alpha*(180.0/pi)
                        rotate z*Beta*(180.0/pi)
                        pigment { Pink }
                  }
                  #declare Co2 = Co2+1.0
           #end
           #declare Co = Co+1.0
    #end
}

/****************************************/

object { Corps scale <0.7, 0.2, 0.2> rotate -10.0*z rotate -45.0*y translate -1.2*y translate -0.7*x }
object { Duvet scale <0.7, 0.2, 0.2> rotate -10.0*z rotate -45.0*y translate -1.2*y translate -0.7*x }

/****************************************/

/****************************************************/
/* PIED 2                                           */
/****************************************************/

#declare Rx = 1.0
#declare Ry = 1.0
#declare Rz = 1.0
#declare Co = 1.0

#declare Corps = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    scale <Rx, Ry, Rz>
    pigment { Pink }
}

#declare Duvet = union
{
    #while (Co <= Nb)
           #declare Alpha = 2.0*pi*rand(S1)
           #declare Beta = 2.0*pi*rand(S2)
           #declare X = Rx*cos(Alpha)*cos(Beta)
           #declare Z = Rz*sin(Alpha)*cos(Beta)
           #declare Y = Ry*sin(Beta)
           #declare N = sqrt(X*X+Y*Y+Z*Z)
           #declare Rayon = RayonEntortillement+dRayonEntortillement*2.0*(rand(S3)-0.5)
           #declare Base = EpaisseurBase+dEpaisseurBase*2.0*(rand(S4)-0.5)
           #declare Hauteur = HauteurEntortillement+dHauteurEntortillement*2.0*(rand(S5)-0.5)
           #declare Angle = AngleEntortillement+dAngleEntortillement*2.0*(rand(S6)-0.5)
           #declare NbCones = Angle/PasEntortillement
           #declare Co2 = 0.0
           #while (Co2 < NbCones)
                  #declare X1 = (Co2/NbCones)*Hauteur
                  #declare X2 = ((Co2+1.0)/NbCones)*Hauteur
                  #declare RayonCourant1 = Rayon*(1.0-(Co2/NbCones))
                  #declare RayonCourant2 = Rayon*(1.0-((Co2+1.0)/NbCones))
                  #declare Y1 = RayonCourant1*cos((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Y2 = RayonCourant2*cos(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z1 = RayonCourant1*sin((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z2 = RayonCourant2*sin(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare B1 = Base*(1.0-(Co2/NbCones))
                  #declare B2 = Base*(1.0-((Co2+1.0)/NbCones))
                  cone
                  {
                        <X1, Y1, Z1>, B1
                        <X2, Y2, Z2>, B2
                        translate N*x
                        rotate y*Alpha*(180.0/pi)
                        rotate z*Beta*(180.0/pi)
                        pigment { Pink }
                  }
                  #declare Co2 = Co2+1.0
           #end
           #declare Co = Co+1.0
    #end
}

/****************************************/

object { Corps scale <0.8, 0.2, 0.2> rotate 70.0*y translate -1.2*y translate 0.6*x }
object { Duvet scale <0.8, 0.2, 0.2> rotate 70.0*y translate -1.2*y translate 0.6*x }

/****************************************/


/****************************************************/
/* BRAS 1                                           */
/****************************************************/

#declare Rx = 1.0
#declare Ry = 1.0
#declare Rz = 1.0
#declare Co = 1.0

#declare Corps = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    scale <Rx, Ry, Rz>
    pigment { Pink }
}

#declare Duvet = union
{
    #while (Co <= Nb)
           #declare Alpha = 2.0*pi*rand(S1)
           #declare Beta = 2.0*pi*rand(S2)
           #declare X = Rx*cos(Alpha)*cos(Beta)
           #declare Z = Rz*sin(Alpha)*cos(Beta)
           #declare Y = Ry*sin(Beta)
           #declare N = sqrt(X*X+Y*Y+Z*Z)
           #declare Rayon = RayonEntortillement+dRayonEntortillement*2.0*(rand(S3)-0.5)
           #declare Base = EpaisseurBase+dEpaisseurBase*2.0*(rand(S4)-0.5)
           #declare Hauteur = HauteurEntortillement+dHauteurEntortillement*2.0*(rand(S5)-0.5)
           #declare Angle = AngleEntortillement+dAngleEntortillement*2.0*(rand(S6)-0.5)
           #declare NbCones = Angle/PasEntortillement
           #declare Co2 = 0.0
           #while (Co2 < NbCones)
                  #declare X1 = (Co2/NbCones)*Hauteur
                  #declare X2 = ((Co2+1.0)/NbCones)*Hauteur
                  #declare RayonCourant1 = Rayon*(1.0-(Co2/NbCones))
                  #declare RayonCourant2 = Rayon*(1.0-((Co2+1.0)/NbCones))
                  #declare Y1 = RayonCourant1*cos((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Y2 = RayonCourant2*cos(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z1 = RayonCourant1*sin((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z2 = RayonCourant2*sin(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare B1 = Base*(1.0-(Co2/NbCones))
                  #declare B2 = Base*(1.0-((Co2+1.0)/NbCones))
                  cone
                  {
                        <X1, Y1, Z1>, B1
                        <X2, Y2, Z2>, B2
                        translate N*x
                        rotate y*Alpha*(180.0/pi)
                        rotate z*Beta*(180.0/pi)
                        pigment { Pink }
                  }
                  #declare Co2 = Co2+1.0
           #end
           #declare Co = Co+1.0
    #end
}

/****************************************/

object { Corps scale <1.0, 0.2, 0.2> rotate -45.0*y translate -0.7*x }
object { Duvet scale <1.0, 0.2, 0.2> rotate -45.0*y translate -0.7*x }

/****************************************/

/****************************************************/
/* BRAS 2                                           */
/****************************************************/

#declare Rx = 1.0
#declare Ry = 1.0
#declare Rz = 1.0
#declare Co = 1.0

#declare Corps = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    scale <Rx, Ry, Rz>
    pigment { Pink }
}

#declare Duvet = union
{
    #while (Co <= Nb)
           #declare Alpha = 2.0*pi*rand(S1)
           #declare Beta = 2.0*pi*rand(S2)
           #declare X = Rx*cos(Alpha)*cos(Beta)
           #declare Z = Rz*sin(Alpha)*cos(Beta)
           #declare Y = Ry*sin(Beta)
           #declare N = sqrt(X*X+Y*Y+Z*Z)
           #declare Rayon = RayonEntortillement+dRayonEntortillement*2.0*(rand(S3)-0.5)
           #declare Base = EpaisseurBase+dEpaisseurBase*2.0*(rand(S4)-0.5)
           #declare Hauteur = HauteurEntortillement+dHauteurEntortillement*2.0*(rand(S5)-0.5)
           #declare Angle = AngleEntortillement+dAngleEntortillement*2.0*(rand(S6)-0.5)
           #declare NbCones = Angle/PasEntortillement
           #declare Co2 = 0.0
           #while (Co2 < NbCones)
                  #declare X1 = (Co2/NbCones)*Hauteur
                  #declare X2 = ((Co2+1.0)/NbCones)*Hauteur
                  #declare RayonCourant1 = Rayon*(1.0-(Co2/NbCones))
                  #declare RayonCourant2 = Rayon*(1.0-((Co2+1.0)/NbCones))
                  #declare Y1 = RayonCourant1*cos((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Y2 = RayonCourant2*cos(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z1 = RayonCourant1*sin((Co2/NbCones)*Angle*2.0*pi/180.0)
                  #declare Z2 = RayonCourant2*sin(((Co2+1.0)/NbCones)*Angle*2.0*pi/180.0)
                  #declare B1 = Base*(1.0-(Co2/NbCones))
                  #declare B2 = Base*(1.0-((Co2+1.0)/NbCones))
                  cone
                  {
                        <X1, Y1, Z1>, B1
                        <X2, Y2, Z2>, B2
                        translate N*x
                        rotate y*Alpha*(180.0/pi)
                        rotate z*Beta*(180.0/pi)
                        pigment { Pink }
                  }
                  #declare Co2 = Co2+1.0
           #end
           #declare Co = Co+1.0
    #end
}

/****************************************/

object { Corps scale <1.0, 0.2, 0.2> translate 0.4*x rotate 100.0*y rotate -25.0*x translate 0.7*x translate 0.2*y }
object { Duvet scale <1.0, 0.2, 0.2> translate 0.4*x rotate 100.0*y rotate -25.0*x translate 0.7*x translate 0.2*y }

/****************************************/


#declare Bloc = union
{
    box
    {
        <0.0, 0.0, -0.25>
        <1.0, 0.2, 0.25>
    }
    box
    {
        <-0.1, 0.1999, -0.2>
        <1.2, 0.3, 0.2>
    }
    texture
    {
        pigment { rgb <0.0, 1.5, 0.0> }
        finish { reflection 0.2 }
        normal { crackle 0.1 }
        scale 0.2
    }
}

#declare Canon = difference
{
    cylinder
    {
        <-0.2, 0.0, 0.0>
        <2.0, 0.0, 0.0>
        0.2
    }
    cylinder
    {
        <-0.21, 0.0, 0.0>
        <2.01, 0.0, 0.0>
        0.18
    }
    box
    {
        <1.7, -0.05, -1.0>
        <1.9, 0.05, 1.0>
    }
    box
    {
        <1.7, -0.05, -1.0>
        <1.9, 0.05, 1.0>
        rotate 45.0*x
    }
    box
    {
        <1.7, -0.05, -1.0>
        <1.9, 0.05, 1.0>
        rotate 90.0*x
    }
    texture { T_Silver_1C normal { bumps 0.3 } scale 0.07 finish { metallic } }
}

#declare Reservoir = union
{
    cylinder
    {
        <0.1, 0.4, 0.0>
        <0.15, 0.4, 0.0>
        0.15
    }
    cylinder
    {
        <1.0, 0.4, 0.0>
        <0.95, 0.4, 0.0>
        0.15
    }
    cylinder
    {
        <0.0, 0.4, 0.0>
        <1.1, 0.4, 0.0>
        0.1
    }
    sphere
    {
        <1.1, 0.4, 0.0>
        0.1
    }
    sphere
    {
        <0.0, 0.4, 0.0>
        0.1
    }
    texture
    {
        pigment { rgb <1.5, 0.0, 0.5> }
        finish { reflection 0.2 }
    }
}

#declare Crosse = difference
{
    torus
    {
        0.8
        0.15
        rotate 90.0*x
    }
    box
    {
        <-10.0, 0.0, -10.0>
        <10.0, 10.0, 10.0>
    }
    box
    {
        <-10.0, -10.0, -10.0>
        <0.0, 10.0, 10.0>
        rotate 50.0*z
    }
    box
    {
        <-10.0, -10.0, -0.12>
        <10.0, 10.0, -10.0>
    }
    box
    {
        <-10.0, -10.0, 0.12>
        <10.0, 10.0, 10.0>
    }
    translate <-0.2, -0.2, 0.0>
    texture
    {
        pigment { Green }
        finish { reflection 0.5 metallic }
        normal { crackle 0.1 }
        scale 0.2
    }
}

#declare Arriere = union
{
    cone
    {
        <-0.1999, 0.0, 0.0>, 0.23
        <-0.4, 0.0, 0.0>, 0.1
    }
    cylinder
    {
        <-0.5, 0.0, 0.0>
        <-0.3, 0.0, 0.0>
        0.05
    }
    texture { T_Silver_1C }
}

#declare Viseur = union
{
    cylinder
    {
        <1.61, 0.5, 0.0>
        <1.64, 0.5, 0.0>
        0.16
        texture
        {
            pigment { rgbt <1.0, 1.0, 1.0, 0.9> }
            finish { reflection 0.5 }
        }
    }
    union
    {
        box
        {
            <1.6, 0.17, -0.05>
            <1.65, 0.31, 0.05>
        }
        difference
        {
            cylinder
            {
                <1.6, 0.5, 0.0>
                <1.65, 0.5, 0.0>
                0.2
            }
            cylinder
            {
                <1.5, 0.5, 0.0>
                <1.7, 0.5, 0.0>
                0.15
            }
        }
        cylinder
        {
            <1.6, 0.5, 0.0>
            <1.65, 0.5, 0.0>
            0.02
        }
        texture { T_Silver_1C normal { bumps 0.3 } scale 0.07 finish { metallic } }
    }
}

#declare Lampes = union
{
    difference
    {
        cylinder
        {
            <1.2, 0.0, -0.25>
            <1.4, 0.0, -0.25>
            0.05
        }
        cylinder
        {
            <1.2, 0.0, -0.25>
            <1.5, 0.0, -0.25>
            0.02
        }
        texture { T_Silver_1C normal { bumps 0.3 } scale 0.07 finish { metallic } }
    }
    difference
    {
        cylinder
        {
            <1.2, 0.0, 0.25>
            <1.4, 0.0, 0.25>
            0.05
        }
        cylinder
        {
            <1.2, 0.0, 0.25>
            <1.5, 0.0, 0.25>
            0.02
        }
        texture { T_Silver_1C normal { bumps 0.3 } scale 0.07 finish { metallic } }
    }
    cylinder
    {
        <1.3, 0.0, -0.25>
        <5.0, 0.0, -0.25>
        0.01
        pigment { rgbt <4.0, 0.0, 0.0, 0.8> }
        no_shadow
    }
    light_source
    {
        <1.31, 0.0, -0.25>
        color rgb <5.0, 0.0, 0.0>
    }
}

/**********************************/

#declare Arme = union
{
    object { Bloc }
    object { Canon }
    object { Reservoir }
    object { Crosse }
    object { Arriere }
    object { Viseur }
    object { Lampes }
}

/**********************************/

/**********************************/

#declare Eye = union
{
    sphere
    {
        <0.0, 0.0, 0.0>
        0.1
        texture
        {
            pigment { White }
            finish { reflection 0.5 }
        }
        scale <1.0, 1.0, 0.8>
    }
    sphere
    {
        <0.0, 0.0, -0.05>
        0.06
        texture
        {
            pigment { Black }
            finish { reflection 0.5 }
        }
    }
}

#declare Nez = sphere
{
    <0.0, 0.0, 0.0>
    0.08
    texture
    {
        pigment { Black }
        finish { reflection 0.1 }
    }
    scale <1.2, 1.0, 0.7>
    translate <0.0, -0.2, -1.0> rotate -10.0*y rotate 10.0*z rotate 5.0*x translate 1.2*y translate -0.4*z
}

#declare Yeux = union
{
    object { Eye translate <0.2, 0.0, -0.9> rotate -10.0*y rotate 10.0*z rotate 5.0*x translate 1.2*y translate -0.4*z }
    object { Eye translate <-0.2, 0.0, -0.9> rotate -10.0*y rotate 10.0*z rotate 5.0*x translate 1.2*y translate -0.4*z }
}

/**********************************/

object { Yeux }
object { Nez }

/**********************************/

#declare Ballon = sphere
{
    <3.7, -0.55, 4.0>
    1.0
    texture
    {
        pigment
        {
            bozo
            pigment_map
            {
                [0.0 Red ]
                [0.5 White ]
                [1.0 Yellow ]
            }
            turbulence 1.0
        }
        finish { reflection 0.2 phong 1.0 }
    }
}

#declare Boite1 = superellipsoid
{
   <0.15, 0.15>
   scale <0.5, 0.5, 0.5>
   rotate 10.0*y
   translate <1.3, -0.85, -2.0>
   texture
   {
       pigment { rgbf <1.5, 0.0, 0.0, 0.5> }
       finish { reflection 0.05 phong 1.0 }
   }
}

#declare Boite2 = superellipsoid
{
   <0.15, 0.15>
   scale <0.5, 0.5, 0.5>
   rotate -50.0*y
   translate <-3.0, -0.85, 0.0>
   texture
   {
       pigment { rgbf <0.0, 0.0, 1.5, 0.5> }
       finish { reflection 0.05 phong 1.0 }
   }
}

#declare Cerceau = torus
{
    2.0, 0.1
    translate <4.0, -1.3, 0.5>
    texture
    {
        pigment
        {
            gradient x
            pigment_map
            {
                [0.0 White ]
                [0.5 Blue ]
                [1.0 White ]
            }
        }
        finish { reflection 0.05 phong 1.0 }
        rotate 45.0*z
    }
}

#declare Jouets = union
{
    object { Ballon }
    object { Boite1 }
    object { Boite2 }
    object { Cerceau }
}

/**********************************/

/**********************************/

#declare Dessin = box
{
    <-1.0, 0.00001, -1.5>
    <1.0, 0.000011, 1.5>
    texture
    {
        pigment
        {
            image_map
            {
                tga "dessin.tga"
                interpolate 2
            }
            scale <2.0, 3.0, 1.0>
            translate <1.0, 1.5, 0.0>
            rotate 90.0*x
        }
        finish { ambient 1.0 }
    }
    rotate 15.0*y
    translate <-2.0, -1.4, -1.0>
}

/**********************************/

/**********************************/

#declare Tube = union
{
    difference
    {
        cone
        {
            <0.0, 0.0, 0.0>, 1.0
            <2.0, 0.0, 0.0>, 0.25
        }
        box
        {
            <-10.0, 0.0, -10.0>
            <10.0, 10.0, 10.0>
            rotate z*atan2(0.25, 2.0)*180.0/pi
        }
        box
        {
            <-10.0, 0.0, -10.0>
            <10.0, -10.0, 10.0>
            rotate -z*atan2(0.25, 2.0)*180.0/pi
        }
        texture
        {
            pigment { image_map { tga "tube.tga" } }
            finish { reflection 0.1 }
            scale 2.0
            translate 0.5*x
        }
    }
    union
    {
        cone
        {
            <1.999, 0.0, 0.0> 0.245
            <2.1, 0.0, 0.0> 0.05
            texture { T_Silver_1A }
        }
        difference
        {
            cylinder
            {
                <2.0, 0.0, 0.0>
                <2.25, 0.0, 0.0>
                0.1
                texture { T_Silver_1A normal { spiral1 0.1 } scale <0.1, 0.02, 0.1> rotate 90.0*z }
            }
            cylinder
            {
                <2.0, 0.0, 0.0>
                <2.3, 0.0, 0.0>
                0.08
                pigment { Black }
            }
        }
    }
    cone
    {
        <2.25, 0.0, 0.0>, 0.08
        <2.8, 0.0, 0.0>, 0.0
        pigment { Red filter 0.7 }
    }
    sphere
    {
        <2.85, 0.0, 0.0>
        0.05
        pigment { Red filter 0.7 }
    }
    sphere
    {
        <2.97, 0.0, 0.0>
        0.08
        pigment { Red filter 0.7 }
    }
}

/**********************************/

/**********************************/

#declare LargeurFlaque = 20.0
#declare HauteurFlaque =  0.3

#declare Flaque = difference
{
  blob
  {
    #declare NSPHERE = 50
    #declare COUNT = 1
    #declare R1 = seed(100)
    #declare R2 = seed(101)
    #declare R3 = seed(102)
    threshold 0.3
    #while (COUNT<NSPHERE)
      #declare X = LargeurFlaque*(rand(R1)-0.5)*cos(pi*rand(R2))
      #declare Z = LargeurFlaque*(rand(R1)-0.5)*sin(pi*rand(R2))
      #declare Y = 10.0*HauteurFlaque*0.5*(1.0+rand(R3))
      sphere { <X, 0.0, Z>, Y, 1.0 }
      #declare COUNT = COUNT+1
    #end
    sturm
    scale <0.5, 0.3, 0.5>
  }
  box { <-LargeurFlaque, HauteurFlaque, -LargeurFlaque> <LargeurFlaque, 5.0*HauteurFlaque, LargeurFlaque> }
   texture
{
  pigment { Red filter 0.65 }
  finish
  {
    ambient 0.0
    diffuse 0.0
    reflection 0.8
    refraction 1.0
    ior 1.33
    specular 1.0
    roughness 0.001
    fade_distance 5.0
    fade_power 1.0
  }
}
}

/**********************************/


/**********************************/

#declare LargeurCorpsCommode = 2.0
#declare ProfondeurCorpsCommode = 1.5
#declare HauteurCorpsCommode = 1.6
#declare HauteurTiroir = 0.4
#declare LargeurTiroir = 1.8
#declare BordTiroir = 0.05
#declare RayonBoutonTiroir = 0.05
#declare EpaisseurMoulureTiroir = 0.02
#declare RayonPiedCommode = 0.2

#declare Pieds = union
{
    sphere
    {
        <LargeurCorpsCommode/2.0-2.0*RayonPiedCommode, 0.0, 2.0*RayonPiedCommode>
        RayonPiedCommode
    }
    sphere
    {
        <-LargeurCorpsCommode/2.0+2.0*RayonPiedCommode, 0.0, 2.0*RayonPiedCommode>
        RayonPiedCommode
    }
     sphere
    {
        <LargeurCorpsCommode/2.0-2.0*RayonPiedCommode, 0.0, ProfondeurCorpsCommode-2.0*RayonPiedCommode>
        RayonPiedCommode
    }
    sphere
    {
        <-LargeurCorpsCommode/2.0+2.0*RayonPiedCommode, 0.0, ProfondeurCorpsCommode-2.0*RayonPiedCommode>
        RayonPiedCommode
    }
}

#declare PlateauCommode = box
{
    <-LargeurCorpsCommode/2.0-BordTiroir, HauteurCorpsCommode-0.0001, -BordTiroir>
    <LargeurCorpsCommode/2.0+BordTiroir, HauteurCorpsCommode+BordTiroir, ProfondeurCorpsCommode+BordTiroir>
}

#declare MoulureTiroir = difference
{
    box
    {
        <-0.8*LargeurTiroir/2.0, -0.4*HauteurTiroir/2.0, -EpaisseurMoulureTiroir>
        <0.8*LargeurTiroir/2.0, 0.4*HauteurTiroir/2.0, 0.001>
    }
    cylinder
    {
        <-0.8*LargeurTiroir/2.0, -0.4*HauteurTiroir/2.0, -2.0*EpaisseurMoulureTiroir>
        <-0.8*LargeurTiroir/2.0, -0.4*HauteurTiroir/2.0, 0.001>
        BordTiroir
    }
    cylinder
    {
        <0.8*LargeurTiroir/2.0, -0.4*HauteurTiroir/2.0, -2.0*EpaisseurMoulureTiroir>
        <0.8*LargeurTiroir/2.0, -0.4*HauteurTiroir/2.0, 0.001>
        BordTiroir
    }
    cylinder
    {
        <0.8*LargeurTiroir/2.0, 0.4*HauteurTiroir/2.0, -2.0*EpaisseurMoulureTiroir>
        <0.8*LargeurTiroir/2.0, 0.4*HauteurTiroir/2.0, 0.001>
        BordTiroir
    }
    cylinder
    {
        <-0.8*LargeurTiroir/2.0, 0.4*HauteurTiroir/2.0, -2.0*EpaisseurMoulureTiroir>
        <-0.8*LargeurTiroir/2.0, 0.4*HauteurTiroir/2.0, 0.001>
        BordTiroir
    }
    translate y*HauteurTiroir/2.0
}

#declare Tiroir = union
{
    object { MoulureTiroir }
    difference
    {
        box
        {
            <-LargeurTiroir/2.0+0.01, 0.0, 0.0>
            <LargeurTiroir/2.0-0.01, HauteurTiroir-0.01, ProfondeurCorpsCommode-BordTiroir>
        }
        box
        {
            <-LargeurTiroir/2.0+0.01+BordTiroir, BordTiroir, BordTiroir>
            <LargeurTiroir/2.0-0.01-BordTiroir, HauteurTiroir+1.0, ProfondeurCorpsCommode-2.0*BordTiroir>
        }
    }
    sphere
    {
        <0.0, HauteurTiroir/2.0, -EpaisseurMoulureTiroir-RayonBoutonTiroir*0.9>
        RayonBoutonTiroir
    }
}

#declare CorpsCommode = difference
{
    box
    {
        <-LargeurCorpsCommode/2.0, 0.0, 0.0>
        <LargeurCorpsCommode/2.0, HauteurCorpsCommode, ProfondeurCorpsCommode>
    }
    box
    {
        <-LargeurTiroir/2.0, (LargeurCorpsCommode-LargeurTiroir)/2.0, -1.0>
        <LargeurTiroir/2.0, (LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir, ProfondeurCorpsCommode-0.1>
    }
    box
    {
        <-LargeurTiroir/2.0, (LargeurCorpsCommode-LargeurTiroir)/2.0, -1.0>
        <LargeurTiroir/2.0, (LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir, ProfondeurCorpsCommode-0.1>
        translate ((LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir)*y
    }
    box
    {
        <-LargeurTiroir/2.0, (LargeurCorpsCommode-LargeurTiroir)/2.0, -1.0>
        <LargeurTiroir/2.0, (LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir, ProfondeurCorpsCommode-0.1>
        translate ((LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir)*2.0*y
    }
}

#declare Commode = union
{
    object { CorpsCommode }
    object { PlateauCommode }
    object { Pieds }
    object { Tiroir translate <0.0, (LargeurCorpsCommode-LargeurTiroir)/2.0+0.001, -ProfondeurCorpsCommode/1.5> }
    object { Tiroir translate <0.0, (LargeurCorpsCommode-LargeurTiroir)/2.0+(LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir+0.001, -ProfondeurCorpsCommode/3.0> }
    object { Tiroir translate <0.0, (LargeurCorpsCommode-LargeurTiroir)/2.0+((LargeurCorpsCommode-LargeurTiroir)/2.0+HauteurTiroir)*2.0+0.001, -BordTiroir> }
    translate y*RayonPiedCommode
    texture
    {
        pigment
        {
            wood
            pigment_map
            {
                [0.0 White ]
                [0.9 White ]
                [1.0 Gray ]
            }
            turbulence 0.1
        }
        scale 0.05
        rotate <15.0, -25.0, 60.0>
        finish { reflection 0.033 }
    }
}

/**************************************/

object { Decor }
object { Arme scale <1.5, 1.5, 1.5> rotate 55.0*y rotate -10.0*x rotate -5.0*z translate <-1.3, 0.5, -0.1> }
object { Jouets }
object { Dessin }
object { Tube rotate z*atan2(0.25, 2.0)*180.0/pi scale 0.5 rotate 120.0*y translate <-0.8, -1.4, 0.2> }
object { Flaque scale <0.1, 0.05, 0.1> translate <-2.0, -1.4, -1.1> }
object { Commode scale <2.5, 2.5, 2.5> translate <-5.0, -1.4, 11.5-2.0*2.5*1.5> rotate -5.0*y }

