// Persistence of Vision Raytracer
// Panneaux dcoratifs en bois.

/******************************************************************************
   A faire:
******************************************************************************/

#ifndef(PANNEAU_INIT)
   #declare Panneau_seed=seed(2)
   #declare Panneau_T=
       texture { pigment { P_WoodGrain4A color_map { M_Wood7A }} rotate 91*x}
       texture {
          pigment { P_WoodGrain4B color_map { M_Wood7B }}
          //normal {wood turbulence <0.04, 0.04, 1> octaves 4
          //   scale <0.05, 0.05, 1> * 0.66 bump_size .1}
          finish {specular 1 roughness 0.0001 reflection 0.05}
          rotate 91*x
          }
   #declare Panneau_T2=
       texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 91*y}
       texture {
          pigment { P_WoodGrain4B color_map { M_Wood8B }}
          //normal {wood turbulence <0.04, 0.04, 1> octaves 4
          //   scale <0.05, 0.05, 1> * 0.66 bump_size .1}
          finish {specular 1 roughness 0.0001 reflection 0.05}
          rotate 91*y
          }
   #declare PANNEAU_INIT=1
#end


/******************************************************************************

        objets

******************************************************************************/

union{
   object{
      //box {0, <Panneau_x, 100, 1>}
      prism {
         linear_sweep linear_spline
         0, 100,
         7,
         <0, .5>, < .5,  1>, <Panneau_x-.5, 1>, <Panneau_x, .5>,
         <Panneau_x-.5, 0>, <.5, 0>, <0, .5>
         }
      texture {Panneau_T translate 1000*rand(Panneau_seed) scale 10 rotate 360*rand(Panneau_seed)*z}
      }
   object{
      union{
         cylinder {0, Panneau_x*x, 1 scale <1, 1, 2>}
         sphere {0, 1 scale <2, 1, 2>}
         sphere {0, 1 scale <2, 1, 2> translate Panneau_x*x}
         }
      texture {Panneau_T2 translate 1000*rand(Panneau_seed) scale 10}
      translate 100*y
      }
   object{ //plinthe
      union{
         box {0, <Panneau_x, 10, 2>}
         cylinder {0, 10*y, 1.999}
         cylinder {0, 10*y, 1.998 translate Panneau_x*x}
         }
      //pigment {rgb <1, .9, .8>}
      pigment {White}
      finish {ambient .15}
      }
   object{
      intersection{
         union{
            cylinder {<0, 25, 0>, <Panneau_x*.75, 100, 0>, 1.5 scale <1, 1, 1/3> translate <0, 0, 1>}
            cylinder {<0, 25, 0>, <Panneau_x*.75, 100, 0>, 0.5 scale <1, 1, 2> translate <0, 0, 1>}
            }
         box {<0, 50, 0>, <Panneau_x/2, 99, 4>}
         }
      texture {
         Panneau_T2
         translate 1000*rand(Panneau_seed)*x
         scale 10
         rotate z*degrees(atan2 (100-25, Panneau_x*.75-0))
         }
      }
   object{
      intersection{
         union{
            cylinder {<0, 75, 0>, <Panneau_x*.75, 0, 0>, 1.5 scale <1, 1, 1/3> translate <0, 0, 1>}
            cylinder {<0, 75, 0>, <Panneau_x*.75, 0, 0>, 0.5 scale <1, 1, 2> translate <0, 0, 1>}
            }
         box {<0, 50, 0>, <Panneau_x/2, 0, 4>}
         }
      texture {
         Panneau_T2
         translate 1000*rand(Panneau_seed)*x
         scale 10
         rotate z*degrees(atan2 (0-75, Panneau_x*.75-0))
         }
      }
   object{
      intersection{
         union{
            cylinder {<Panneau_x, 25, 0>, <Panneau_x*.25, 100, 0>, 1.5 scale <1, 1, 1/3> translate <0, 0, 1>}
            cylinder {<Panneau_x, 25, 0>, <Panneau_x*.25, 100, 0>, 0.5 scale <1, 1, 2> translate <0, 0, 1>}
            }
         box {<Panneau_x, 50, 0>, <Panneau_x/2, 99, 4>}
         }
      texture {
         Panneau_T2
         translate 1000*rand(Panneau_seed)*x
         scale 10
         rotate z*degrees(atan2 (100-25, Panneau_x*.25-Panneau_x))
         }
      }
   object{
      intersection{
         union{
            cylinder {<Panneau_x, 75, 0>, <Panneau_x*.25, 0, 0>, 1.5 scale <1, 1, 1/3> translate <0, 0, 1>}
            cylinder {<Panneau_x, 75, 0>, <Panneau_x*.25, 0, 0>, 0.5 scale <1, 1, 2> translate <0, 0, 1>}
            }
         box {<Panneau_x, 50, 0>, <Panneau_x/2, 0, 4>}
         }
      texture {
         Panneau_T2
         translate 1000*rand(Panneau_seed)*x
         scale 10
         rotate z*degrees(atan2 (0-75, Panneau_x*.25-Panneau_x))
         }
      }
   }

