// Persistence of Vision Raytracer
// Theme "Childhood" 07-08/97: L'Enfant et les sortilges
// Sizes in cm

global_settings {
   max_trace_level 10 // 6; 8atteint
   adc_bailout 1/255
   assumed_gamma 1.9
   radiosity{
      distance_maximum 300     // def.   0, essais=500, puis 35
      brightness       3.3     // def.   3.3
      count            200     // def. 100
      error_bound        0.38  // def.   0.4
      gray_threshold     0.0   // def.   0.5 was 0.5
      low_error_factor   0.8   // def.   0.8
      minimum_reuse      0.015 // def.   0.015
      nearest_count     10     // def.   6
      recursion_limit    2     // def.   1
      }
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"

#include "decor.inc"
#include "soucoupe.inc"
#include "fauteuil.inc"
#include "theiere1.inc"

#declare WideLight = 1

#declare Vue_1= camera {
   perspective
   location  <200, 30, -130>
   up        y
   right     -4/3 * x
   look_at   <100, 30, 0>
   angle 60 //Attention: angle  la base et non sur la diagonale!
}

#declare Lampes=union{
   object {
      light_source {
         <-150, 150, -140>
         color rgb <1, .9, .8>*.3
         }
      }
   object {
      light_source {
         <150, 150, -140>
         color rgb <1, .9, .8>*.3
         }
      }
   object {
      light_source {
         <00, 50, 120>
         color rgb <.8, .3, 0>
         }
      }
   }

#declare Lampes_E=union{
   object {
      light_source {
         <-150, 150, -140>
         color rgb <.7, .7, .6>*.5//was <.9, .7, .5>
         }
      }
   object {
      light_source {
         <200, 150, -140>
         color rgb <.7, .7, .6>*.5
         }
      }
   object {
      light_source {
         <-10, 40, 120>
         color rgb <.8, .3, 0>//green was .3
         area_light
         <20, 0, 0> <0, 20, 0> // lights spread out across this distance (x * y)
         4, 4
         adaptive 0 jitter
         }
      }
   }

/******************************************************************************

        Scne complte

******************************************************************************/

union{
   object {Decor translate <0, 0, 0>}
   union{
      union{
         object {#include "tasse.inc" translate 3*y rotate 10*z}
         object {#include "jambet1.inc" translate <-3, 0, 0> rotate -90*y}
         object {#include "jambet2.inc" translate <3, 0, 0> rotate -90*y}
         object {Soucoupe rotate 10*z}
         translate 32*y scale 0.9 translate <-30, 0, -30>
         }
      union{
         object {Theiere1}
         object {#include "theiere2.inc" scale <.7, .8, 0.8> translate <32, 15, 0> rotate 0*y}
         object {#include "theiere3.inc" scale <1, 1, 1> translate <-35, 15, 0> rotate 0*y}
         object {#include "jambex.inc" translate <-3, 0, 0> rotate -130*y}
         translate 30*y scale .7 rotate -50*y translate <22, 0, 22>
         }
      scale 0.8 rotate -150*y translate <120, 0, 50>
      }
   union{
      object{#include "fauteu1.inc"}
      object {Fauteuil_Coussin translate <0, 35, 0>}
      object {Fauteuil_Dossier translate <0, 60, 17>}
      object {Fauteuil_Accoudoir rotate -2*x translate <15, 53, 0>}
      object {Fauteuil_Accoudoir rotate -2*x translate <-15, 53, 0>}
      scale <-1, 1, 1> rotate 125*0*y rotate <-5, 0, 5> translate <-50, 5, 50>
      }
   union{
      object{#include "bergere2.inc"}
      object{#include "bergere3.inc"}
      scale <-1, 1, 1> rotate -100*y translate <-130, 25, 30>
      }

#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
rotate 0*y
}

camera {Vue_1}
