// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Un oso de dibujos animados.
//--
// This file contains:
//  A cartoon bear.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#declare HeadBase =
    blob {
        threshold .5
        sphere { <-.05, 0, 0>, .25, 1 }
        sphere { <.05, 0, 0>, .25, 1 }
        cylinder {
            <0, 0, 0>, <0, 0, -.2>, .1, 1
            scale <2, 1, .9>
            translate <0, -.075, 0>
        }
        sphere {
            0, .075, -.5
            scale <1, 1.25, .5>
            translate <-.05, .02, -.155>
        }
        sphere {
            0, .075, -.5
            scale <1, 1.25, .5>
            translate <.05, .02, -.155>
        }
/*        sphere {
            0, .075, -.5
//            scale <.5, .5, .5>
            translate <0, .02, -.25>
        }*/
        texture { T_BearMain }
        scale 1
    }

#declare Ears =
    union {
        union {
            blob {
                threshold .5
                sphere { <0, 0, 0>, .15, 1 }
                sphere { <0, 0, -.05>, .1, -1 }
                scale <1, 1, .5>
                translate -.1 * x
            }
            blob {
                threshold .5
                sphere { <0, 0, 0>, .15, 1 }
                sphere { <0, 0, -.05>, .1, -1 }
                scale <1, 1, .5>
                translate .1 * x
            }
            texture { T_BearMain }
        }
        union {
            blob {
                threshold .5
                sphere { <0, 0, 0>, .15, 1 }
                sphere { <0, 0, -.05>, .1, -1 }
                scale <1, 1, .5> * .9
                translate -.1 * x
            }
            blob {
                threshold .5
                sphere { <0, 0, 0>, .15, 1 }
                sphere { <0, 0, -.05>, .1, -1 }
                scale <1, 1, .5> * .9
                translate .1 * x
            }
            texture {
                pigment { White }
                finish { F_Cartoon9 }
            }
        }
        translate <0, .2, .05>
    }

#declare Eye =
    union {
        sphere {
            <0, 0, 0>, .06
            scale <1, 1.25, 1>
            texture { T_WhiteZone }
        }
        sphere {
            <0, 0, -.08>, .02
            texture {
                pigment { Gray10 }
                finish { F_Cartoon9 }
            }
        }
        scale <1, 1, .1>
    }

#declare Eyes =
    union {
        object {
            Eye
            translate -.05 * x
        }
        object {
            Eye
            translate .05 * x
        }
        translate <0, .02, -.15>
        no_shadow
    }

#declare Nose =
    sphere {
        <0, 0, 0>, .015
        texture {
            pigment { Gray10 }
            finish { F_Cartoon9 }
        }
        scale <2, 1, 1>
        translate <0, -.01, -.2>
    }

#declare Muzzle =
    blob {
        threshold .5
        cylinder { <0, -.1, 0>, <0, -.1, -.2>, .1, 1 scale <1.5, .5, .85> }
        cylinder { <0, 0, 0>, <0, 0, -.2>, .1, -1 scale <2, .5, 1.1> }
        texture { T_WhiteZone }
        rotate -5 * x
        translate <0, -.075, 0>
    }

#declare Tongue =
    union {
        sphere { <-.01, 0, 0>, .03 }
        sphere { <.01, 0, 0>, .03 }
        texture {
            pigment { Magenta }
            finish { F_Cartoon9 }
        }
        scale <1.5, .75, 2>
        translate <0, -.1, -.16>
        rotate -5 * x
        translate <0, -.014, 0>
    }

#declare BearHead =
    union {
        object { HeadBase }
        object { Ears }
        object { Eyes }
        object { Nose }
        object { Muzzle }
        object { Tongue }
        rotate -10 * x
        translate <0, .95, 0>
    }

#declare BodyBase =
    blob {
        threshold .5
        cylinder {
            <0, .4, 0>, <0, .6, 0>, .4, 1
            scale <.8, 1, .5>
        }
        cylinder {
            <0, .4, 0>, <0, .9, 0>, .1, 1
            scale <.8, 1, .6>
        }
        sphere {
            <0, .5, 0>, .2, 1
            scale <.8, 1, .5>
            translate <0, 0, -.05>
        }
        sphere {
            <-.15, .7, 0>, .1, 1
            scale <1, 1, .5>
        }
        sphere {
            <.15, .7, 0>, .1, 1
            scale <1, 1, .5>
        }
        sphere {
            <-.185, .6875, 0>, .1, 1
            scale <1, 1, .55>
        }
        sphere {
            <.185, .6875, 0>, .1, 1
            scale <1, 1, .55>
        }
        sphere {
            <-.22, .65, 0>, .1, 1
            scale <1, 1, .6>
        }
        sphere {
            <.22, .65, 0>, .1, 1
            scale <1, 1, .6>
        }
        sphere { <-.3, .75, 0>, .2, -1 }
        sphere { <.3, .75, 0>, .2, -1 }
        texture { T_BearMain }
    }

#declare BodyFront =
    blob {
        threshold .5
        cylinder {
            <0, .425, 0>, <0, .575, 0>, .4, 1
            scale <.8, 1, .5>
        }
        sphere {
            <0, .5, 0>, .2, 1
            scale <.8, 1, .5>
            translate <0, 0, -.05>
        }
        cylinder {
            <0, .425, 0>, <0, .575, 0>, .4, -1
            scale <.8, 1, .5>
            translate <0, 0, .1>
        }
        scale <.8, 1, 1.1>
        texture { T_WhiteZone }
    }

#declare BearBody =
    union {
        object { BodyBase }
        object { BodyFront }
        scale <1, 1, 1.25>
    }

#declare LArmBlob =
    blob {
        threshold .5
        sphere {
            <.13, .7, 0>, .1, 1
            scale <1, 1, .75>
        }
        sphere {
            <.155, .6875, 0>, .1, 1
            scale <1, 1, .75>
        }
        sphere {
            <.175, .675, 0>, .1, 1
            scale <1, 1, .75>
        }
        sphere {
            <.3, .75, 0>, .2, -1
        }
        cylinder { <.225, .625, 0>, <.225, .55, 0>, .1, 1 }
        cylinder { <.225, .45, 0>, <.225, .2, 0>, .1, 1 }
        cylinder {
            <-.05, .45, 0>, <0, .2, 0>, .1, -1
            scale <.4, 1, 2>
            translate <.175, 0, 0>
        }
        cylinder {
            <0, .2, -.2>, <0, .2, .2>, .1, -1
            scale <.5, 1, 1>
            translate <.2, 0, 0>
        }
        cylinder {    // Finger
            <.225, .25, -.05>, <.225, .2, -.075>, .025, 1
        }
    }

#declare BearLArm =
    difference {
        object { LArmBlob }
        box { <.325, .225, -.025>, <.125, .1, -.02> }
        box { <.325, .225, .025>, <.125, .1, .02> }
        texture { T_BearMain }
        translate <-.01, .01, 0>
    }

#declare RArmTrans =
    transform {
        translate  -.5 * y
        rotate 30 * x
        translate  .5 * y
    }

#declare RArmBlob =
    blob {
        threshold .5
        sphere {
            <.13, .7, 0>, .1, 1
            scale <1, 1, .75>
        }
        sphere {
            <.155, .6875, 0>, .1, 1
            scale <1, 1, .75>
        }
        sphere {
            <.175, .675, 0>, .1, 1
            scale <1, 1, .75>
        }
        sphere {
            <.3, .75, 0>, .2, -1
        }
        cylinder { <.225, .625, 0>, <.225, .55, 0>, .1, 1 }
        cylinder {
            <.225, .45, 0>, <.225, .2, 0>, .1, 1
            transform RArmTrans
        }
        cylinder {
            <-.05, .45, 0>, <0, .2, 0>, .1, -1
            scale <.4, 1, 2>
            translate <.175, 0, 0>
            transform RArmTrans
        }
        cylinder {
            <0, .2, -.2>, <0, .2, .2>, .1, -1
            scale <.5, 1, 1>
            translate <.2, 0, 0>
            transform RArmTrans
        }
        cylinder {    // Finger
            <.225, .25, -.05>, <.225, .2, -.075>, .025, 1
            transform RArmTrans
        }
    }

#declare BearRArm =
    difference {
        object { RArmBlob }
        box {
            <.325, .225, -.025>, <.125, .1, -.02>
            transform RArmTrans
        }
        box {
            <.325, .225, .025>, <.125, .1, .02>
            transform RArmTrans
        }
        texture { T_BearMain }
        translate <-.01, .01, 0>
        scale <-1, 1, 1>
        translate -.71 * y
        rotate 30 * x
        translate .71 * y
    }

#declare BearLLeg =
    blob {
        threshold .5
        cylinder { <0, .4, 0>, <0, .09, -.05>, .15, 1 }
        cylinder { <0, 0, -.05>, <0, -.2, .025>, .1, 1 }
        cylinder { <0, -.25, .025>, <.05, -.25, -.1>, .1, 1 }
        translate .075 * x
        texture { T_BearMain }
    }

#declare BearRLeg =
    object {
        BearLLeg
        scale <-1, 1, 1>
    }

#declare Bear =
    union {
        object { BearHead }
        object { BearBody scale <1, 1, 1.1> }
        object { BearLArm scale <1, 1, 1.1> }
        object { BearRArm scale <1, 1, 1.1> }
        object { BearLLeg scale <1, 1, 1.1> }
        object { BearRLeg scale <1, 1, 1.1> }
        translate .3 * y
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
