// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una casa de dibujo animado.
//--
// This file contains:
//  A cartoon house.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#declare WallsY = 2
#declare WallsMagic = 6
#declare RoofMagic = 6

#declare WallsInnerSide =
    intersection {
        sphere { <0, WallsY * .5, WallsMagic - 1.75>, WallsMagic }
        sphere { <0, WallsY * .5, -WallsMagic + 1.75>, WallsMagic }
        sphere { <WallsMagic - 1.75, WallsY * .5, 0>, WallsMagic }
        sphere { <-WallsMagic + 1.75, WallsY * .5, 0>, WallsMagic }
        plane { -y, .1 }
        plane { y, WallsY + .1 }
    }

#declare WallsOutterSide =
    intersection {
        sphere { <0, WallsY * .5, WallsMagic - 2>, WallsMagic }
        sphere { <0, WallsY * .5, -WallsMagic + 2>, WallsMagic }
        sphere { <WallsMagic - 2, WallsY * .5, 0>, WallsMagic }
        sphere { <-WallsMagic + 2, WallsY * .5, 0>, WallsMagic }
        plane { -y, 0 }
        plane { y, WallsY }
    }

#declare DoorHole =
    union {
        cylinder {
            <0, WallsY - .75, 0>,
            <0, WallsY - .75, -WallsMagic + 1.9>, .5
        }
        box {
            <-.5, -.01, 0>,
            <.5, WallsY - .75, -WallsMagic + 1.9>
        }
        scale <1.25, 1, 1>
    }

#declare WindowHole =
    intersection {
        cylinder {
            <0, 0, 0>,
            <0, 0, -WallsMagic + 1.9>, 2
            translate -1.5 * x
        }
        cylinder {
            <0, 0, 0>,
            <0, 0, -WallsMagic + 1.9>, 2
            translate 1.5 * x
        }
        cylinder {
            <0, 0, 0>,
            <0, 0, -WallsMagic + 1.9>, 2
            translate -1.5 * y
        }
        cylinder {
            <0, 0, 0>,
            <0, 0, -WallsMagic + 1.9>, 2
            translate 1.5 * y
        }
    }

#declare Window =
    union {
        box {
            <-.5, -.5, 0>, <.5, .5, -.1>
            texture {
                pigment {
                    bozo
                    color_map {
                        [ .5 MidnightBlue ]
                        [ .5 MediumBlue ]
                    }
                    scale <5, 1, 1> * .1
                }
                finish { F_Cartoon9 }
                rotate 45 * z
            }
        }
        difference {
            box { <-.5, -.5, 0>, <.5, .5, -.15> }
            object { WindowHole scale <.8, .8, 1> translate .1 * z }
        }
        box { <-.5, -.05, 0>, <.5, .05, -.15> }
        box { <-.5, -.05, 0>, <.5, .05, -.15> rotate 90 * z }
        texture {
            pigment { ForestGreen }
            finish { F_Cartoon9 }
        }
    }

#declare WallsBase =
    intersection {
        object { WallsOutterSide }
        object { WallsInnerSide inverse }
    }

#declare Walls =
    difference {
        object { WallsBase }
        object { DoorHole translate -.5 * x }
        object { WindowHole translate <1, WallsY - .75, 0> }
        object { WindowHole translate <0, WallsY - .75, 0> rotate -90 * y }
        object { WindowHole translate <0, WallsY - .75, 0> rotate 90 * y }
        texture {
            pigment { Yellow }
            finish { F_Cartoon9 }
        }
    }

#declare QuarterRoof =
    intersection {
        cylinder {
            <-10.1, 0, -RoofMagic + 2>, <10.1, 0, -RoofMagic + 2>, RoofMagic
            scale <1, 1 / RoofMagic, 1 / RoofMagic * 3>
            inverse
        }
        cylinder {
            <-10, 0, -RoofMagic + 2>, <10, 0, -RoofMagic + 2>, RoofMagic
            scale <1, 1.05 / RoofMagic, 1 / RoofMagic * 3>
        }
        box { <0, 0, 0>, <10, -10, -10> rotate 45 * y }
        object {
            WallsOutterSide
            scale <1.05, 1, 1.05>
            translate -WallsY * y
        }
        scale <1, 2, 1>
    }

#declare Roof =
//    difference {
        union {
            object { QuarterRoof }
            object { QuarterRoof rotate 90 * y }
            object { QuarterRoof rotate 180 * y }
            object { QuarterRoof rotate -90 * y }
//        }
//        cylinder { <0, 0, 0>, <0, -2, 0>, .25 }
        texture {
            pigment { Red }
            finish { F_Cartoon9 }
        }
        scale <1, 2, 1>
        translate (WallsY * 3 + .1) * y
    }

#declare Door =
    union {
        #declare DoorPos = -.75
        #while (DoorPos < 1)
            box { <DoorPos, 0, 0>, <DoorPos +.225, WallsY, -.1> }
            #declare DoorPos = DoorPos + .25
        #end
        box { <-.8, .3, -.1>, <.8, .525, -.3> }
        box { <-.8, 1, -.1>, <.8, 1.225, -.3> }
        box {
            <-.8, 0, 0>, <.8, WallsY, -.05>
            texture { pigment { Black } }
        }
        sphere {
            <.49, .75, -.17>, .075
            texture {
                pigment { Red }
                finish { F_Cartoon9 }
            }
        }
        texture {
            pigment { ForestGreen }
            finish { F_Cartoon9 }
        }
        translate -1.5 * z
    }

#declare Chimney =
    union {
        cone { <-.05, .375, 0>, .15, <-.1, .5, 0>, 0 open }
        cone { <0, 0, 0>, .08, <-.05, .3, 0>, .1 open }
        cylinder { <-.125, .25, 0>, <-.185, .325, 0>, .015 }
        cylinder { <.01, .3, -.075>, <0, .4, -.135>, .015 }
        texture {
            pigment { Gray50 }
            finish { F_Cartoon9 }
        }
        scale 1.5
    }

#declare Smoke =
    blob {
        threshold .5
        sphere { <-.05, .3, 0>, .1, 1 }
        sphere { <0, .375, 0>, .15, 1 }
        sphere { <.05, .55, 0>, .2, 1 }
        sphere { <0, .85, 0>, .3, 1 }
        sphere { <.05, 1.6, 0>, .45, 1 }
        scale 1.5
        texture {
            pigment { Gray70 }
            finish { F_Cartoon9 }
        }
    }

#declare House =
    union {
        object { Walls }
        object { Roof }
        object { Door translate -.5 * x }
        object {
            Window
            rotate -10 * y
            translate <1, WallsY - .75, .15 - 1.8>
        }
        object {
            Window
            translate <0, WallsY - .75, .1 - 1.8>
            rotate -90 * y
        }
        object {
            Window
            translate <0, WallsY - .75, .1 - 1.8>
            rotate 90 * y
        }
        object {
            Chimney
            translate <-1.5, WallsY +.1, 0>
        }
        object {
            Smoke
            translate <-1.5, WallsY +.1, 0>
        }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
