// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Un generador de arboles.
//--
// This file contains:
//  A tree generator.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#declare Leafes =
    blob {
        threshold 1
        #declare LeafCount = 10
        #while (LeafCount > 0)
            sphere {
                0, 4 * rand(LeafRand1) + .5, 5
                scale <1, .25, 1>
                rotate (90 * rand(LeafRand2) - 45) * z
                rotate 360 * rand(LeafRand2) * y
                translate 2 * rand(LeafRand2) * y
            }
            #declare LeafCount = LeafCount - 1
        #end // while
        texture {
            pigment { ForestGreen }
            finish { F_Cartoon9 }
        }
        translate <0, TreeTrunkY + 2, 0>
    }

#declare BranchZone = 360 / Branches
#declare RootZone = 360 / Roots
#declare Trunk =
    blob {
        threshold .5
        cylinder { <0, 0, 0>, <0, TreeTrunkY, 0>, 1, 1 }
        #while (Branches > 0)
            cylinder {
                <.2, TreeTrunkY, 0>, <2, TreeTrunkY + 2, 0>, .5, 1
                rotate (BranchZone * rand(TrunkRand)
                        + BranchZone * Branches) * y
            }
            #declare Branches = Branches - 1
        #end // while
        #while (Roots > 0)
            #declare RotateRoot =
                RootZone * rand(TrunkRand) + RootZone * Roots
            cylinder {
                <0, .1, 0>, <1, 0, 0>, .4, 1
                scale <1, 1, .5>
                rotate RotateRoot * y
            }
            cylinder {
                <1, 0, 0>, <1.5, -.5, 0> .2, 1
                scale <1, 1, .5>
                rotate RotateRoot * y
            }
            #declare Roots = Roots - 1
        #end // while
        texture {
            pigment { Brown }
            finish { F_Cartoon9 }
        }
    }

#declare Tree =
    union {
        object { Leafes }
        object { Trunk }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
