
// Persistence of Vision Ray Tracer Scene Description File
// File: chldmisc.inc
// Vers: 1.00
// Desc: Misc elements for "Ice Cream!" scene.
// Date: 15th Dec 1997.
// Auth: Chris Hernandez



// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "FOLIAGE.INC"

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.35
	   diffuse 0.35
	   specular 0.3
       roughness 0.01
	   //reflection 0.05
	}
}

#declare Concrete = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgb <0.850, 0.850, 0.850> ]
         [ 0.33 color rgb <0.885, 0.885, 0.885> ]
         [ 0.66 color rgb <0.835, 0.835, 0.835> ]
         [ 1.00 color rgb <0.815, 0.815, 0.815> ]
      }
      turbulence 1
   }
   finish { ambient 0.4 diffuse 0.35 crand 0.1 }

   normal {
      average
      normal_map {
         [ 1 bozo 0.6 turbulence 0.75 ]
         [ 0.1 crackle 0.1 ]
      }
      scale 0.5
   }
   //scale 0.35
}


#declare Child_SidewalkUnit = object {
   union {
      difference {
         box { <-1.5, -0.15, -1> <0, 0.01, 0> }
         cylinder { -10*z, 10*z, 0.01 translate <-1.5, 0, 0> scale <1, 1.5, 1> }
         cylinder { -10*z, 10*z, 0.01 translate < 0.0, 0, 0> scale <1, 1.5, 1> }
      }
      box {
         <-1.4, -0.15, -0.9> <-0.1, 0.015, -0.1>
         texture {
            Concrete
            finish { crand 0.2 }
            normal { bozo 0.5 turbulence 2.5 scale 0.1 }
         }
      }
   }
   texture { Concrete }
}

#declare Child_Sidewalk = object {
   union {
      object { Child_SidewalkUnit translate -x*30.0 }
      object { Child_SidewalkUnit translate -x*28.5 }
      object { Child_SidewalkUnit translate -x*27.0 }
      object { Child_SidewalkUnit translate -x*25.5 }
      object { Child_SidewalkUnit translate -x*24.0 }
      object { Child_SidewalkUnit translate -x*22.5 }
      object { Child_SidewalkUnit translate -x*21.0 }
      object { Child_SidewalkUnit translate -x*19.5 }
      object { Child_SidewalkUnit translate -x*18.0 }
      object { Child_SidewalkUnit translate -x*16.5 }
      object { Child_SidewalkUnit translate -x*15.0 }
      object { Child_SidewalkUnit translate -x*13.5 }
      object { Child_SidewalkUnit translate -x*12.0 }
      object { Child_SidewalkUnit translate -x*10.5 }
      object { Child_SidewalkUnit translate -x*09.0 }
      object { Child_SidewalkUnit translate -x*07.5 }
      object { Child_SidewalkUnit translate -x*06.0 }
      object { Child_SidewalkUnit translate -x*04.5 }
      object { Child_SidewalkUnit translate -x*03.0 }
      object { Child_SidewalkUnit translate -x*01.5 }
      object { Child_SidewalkUnit translate  x*0.00 }
      object { Child_SidewalkUnit translate  x*01.5 }
      object { Child_SidewalkUnit translate  x*03.0 }
      object { Child_SidewalkUnit translate  x*04.5 }
      object { Child_SidewalkUnit translate  x*06.0 }
      object { Child_SidewalkUnit translate  x*07.5 }
      object { Child_SidewalkUnit translate  x*09.0 }
      object { Child_SidewalkUnit translate  x*10.5 }
      object { Child_SidewalkUnit translate  x*12.0 }
      object { Child_SidewalkUnit translate  x*13.5 }
      object { Child_SidewalkUnit translate  x*15.0 }
      object { Child_SidewalkUnit translate  x*16.5 }
      object { Child_SidewalkUnit translate  x*18.0 }
      object { Child_SidewalkUnit translate  x*19.5 }
      object { Child_SidewalkUnit translate  x*21.0 }
      object { Child_SidewalkUnit translate  x*22.5 }
      object { Child_SidewalkUnit translate  x*24.0 }
      object { Child_SidewalkUnit translate  x*25.5 }
      object { Child_SidewalkUnit translate  x*27.0 }
      object { Child_SidewalkUnit translate  x*28.5 }
      object { Child_SidewalkUnit translate  x*30.0 }
   }
}


#declare Child_Shrub = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.1, 1> translate y*0.5 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}


#declare Child_FencePaling = object {
   union {
      box { <-0.075, 0, 0> <0.075, 0.8, 0.01> }
      difference {
         cylinder { 0*z, 0.01*z, 0.15 translate x*0.075 }
         plane { -x, 0 }
         plane {  y, 0 }
         scale <1, 2.5, 1>
         translate y*0.8
      }
      difference {
         cylinder { 0*z, 0.01*z, 0.15 translate -x*0.075 }
         plane { x, 0 }
         plane { y, 0 }
         scale <1, 2.5, 1>
         translate y*0.8
      }
   }
   scale <0.8, 1, 1>
   texture { TempTexture }
}

#declare Child_Fence = object {
   union {
      object { Child_FencePaling translate x*0.00 }
      object { Child_FencePaling translate x*0.25 }
      object { Child_FencePaling translate x*0.50 }
      object { Child_FencePaling translate x*0.75 }
      object { Child_FencePaling translate x*1.00 }
      object { Child_FencePaling translate x*1.25 }
      object { Child_FencePaling translate x*1.50 }
      object { Child_FencePaling translate x*1.75 }
      object { Child_FencePaling translate x*2.00 }
      box { <0, 0.7, -0.01> <2, 0.8, 0> }
      box { <0, 0.15, -0.01> <2, 0.25, 0> }
   }
   texture { TempTexture }
}


#declare Child_Flesh = texture {
   pigment { color red 0.96 green 0.80 blue 0.69 }
   finish { ambient 0.35 diffuse 0.35 crand 0.02 }
   normal { wrinkles 0.15 turbulence 0.25 scale 0.01 }
}

#declare Child_LeftArm_JointFlex = on

/*
#declare Child_LeftArm = object {
   union {

      //---- Upper Arm

      union {
         //-- Shirt Cuff
         union {
            cone {
               0.1*x, 0.0725, 0.3*x, 0.08
               open
               scale <0.9, 1.15, 1>
               translate -y*0.0175
            }
            torus {
               0.078, 0.003
               rotate z*90
               scale <2.5, 1.15, 1>
               translate <0.3*0.9, -0.0175, 0>
            }
            texture {
               pigment { color rgb <0.925, 0.925, 0.975> }
               finish  { ambient 0.4 diffuse 0.45 crand 0.035 }
               normal  { wrinkles 0.30 turbulence 0.5 scale <0.015, 0.03, 0.02> }
            }
         }
         //-- Upper Arm
         cone { 0.2*x, 0.07, 0.42*x, 0.0625 }
         #if ( Child_LeftArm_JointFlex = on )
            rotate -y*10
            translate <0, 0, -0.070>
         #end
      }

      //---- Forearm and lower hand
      union {
         cone { 0.4*x, 0.065, 0.75*x, 0.025 }
         sphere { 0*x, 0.065 scale <3.5,1,1> translate <0.4, 0, 0> }
         cone { 0.74*x, 0.03, 0.81*x, 0.045 scale <1. 0.45, 1> translate y*0.01 }
         difference {
            sphere { 0*x, 0.045 scale <0.65, 0.47, 1> translate <0.81, 0.01, 0> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.037, 0.0375> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.038, 0.0160> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.038, -0.090> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.037, -0.030> }
         }
         sphere { 0*x, 0.03 scale <1.5, 0.9, 1> translate <0.74, 0, 0> }
      }

      //---- Pinkie
      union {
         sphere { 0*x, 0.025 scale <0.6, 0.3, 0.33> rotate z*10 }
         sphere { 0*x, 0.025 scale <0.58, 0.25, 0.28> translate <0.015,0.002,0> }
         sphere { 0*x, 0.025 scale <0.53, 0.20, 0.26> rotate -z*7 translate <0.030,0.002,0> }
         rotate -y*10
         rotate -z*8
         translate <0.833, 0.020, 0.0375>
      }

      //---- Ring Finger
      union {
         sphere { 0*x, 0.03 scale <0.63, 0.3, 0.325> rotate z*13 }
         sphere { 0*x, 0.03 scale <0.60, 0.23, 0.30> rotate z*00 translate <0.019,0.0035,0> }
         sphere { 0*x, 0.03 scale <0.57, 0.20, 0.30> rotate -z*9 translate <0.034,0.0035,0> }
         rotate -y*05
         rotate -z*4
         translate <0.842, 0.021, 0.016>
      }

      //---- Middle Finger
      union {
         sphere { 0*x, 0.03 scale <0.77, 0.3, 0.32>  rotate z*15 }
         sphere { 0*x, 0.03 scale <0.70, 0.24, 0.30> rotate z*00 translate <0.023,0.004,0> }
         sphere { 0*x, 0.03 scale <0.55, 0.22, 0.28> rotate -z*8 translate <0.042,0.003,0> }
         rotate z*3
         translate <0.84, 0.024, -0.009>
      }

      //---- Index Finger
      union {
         sphere { 0*x, 0.03 scale <0.74, 0.35, 0.35> rotate z*10 }
         sphere { 0*x, 0.03 scale <0.70, 0.31, 0.33> rotate z*00 translate <0.023,0.004,0> }
         sphere { 0*x, 0.03 scale <0.60, 0.27, 0.30> rotate -z*8 translate <0.042,0.003,0> }
         rotate y*05
         rotate -z*5
         translate <0.83, 0.0175, -0.03>
      }

      //---- Thumb
      union {
         sphere { 0*x, 0.04 scale <0.7, 0.45, 0.5> rotate y*7 }
         sphere {
            0*x, 0.03
            scale <0.775, 0.4, 0.3>
            rotate -z*8 rotate y*10
            translate <0.02, -0.005, -0.014>
         }
         sphere {
            0*x, 0.03
            scale <0.52, 0.28, 0.21>
            rotate -z*8 rotate -y*25
            translate <0.045, -0.008, -0.013>
         }
         rotate -z*5
         rotate y*28
         translate <0.76, -0.005, -0.025>
      }
   }
   texture { Child_Flesh }
}
*/


#declare Child_LeftArm = object {
   union {

      //---- Upper Arm

      union {
         //-- Shirt Cuff
         union {
            cone {
               0.1*x, 0.0725, 0.3*x, 0.08
               open
               scale <0.9, 1.15, 1>
               translate -y*0.0175
            }
            torus {
               0.078, 0.003
               rotate z*90
               scale <2.5, 1.15, 1>
               translate <0.3*0.9, -0.0175, 0>
            }
            texture {
               pigment { color rgb <0.925, 0.925, 0.975> }
               finish  { ambient 0.4 diffuse 0.45 crand 0.035 }
               normal  { wrinkles 0.30 turbulence 0.5 scale <0.015, 0.03, 0.02> }
            }
         }
         //-- Upper Arm
         cone { 0.2*x, 0.07, 0.42*x, 0.0625 }
         #if ( Child_LeftArm_JointFlex = on )
            rotate -y*10
            translate <0, 0, -0.070>
         #end
      }

      //---- Forearm and lower hand
      union {
         cone { 0.4*x, 0.065, 0.75*x, 0.025 }
         sphere { 0*x, 0.065 scale <3.5,1,1> translate <0.4, 0, 0> }
         cone { 0.74*x, 0.0285, 0.81*x, 0.045 scale <1, 0.45, 1> translate y*0.01 }
         difference {
            sphere { 0*x, 0.045 scale <0.65, 0.45, 1> translate <0.81, 0.01, 0> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.037, 0.0375> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.038, 0.0160> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.038, -0.090> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <0.81, 0.037, -0.030> }
            plane { x, 0 translate x*0.81 }
         }
         sphere { 0*x, 0.03 scale <1.5, 0.9, 1> translate <0.74, 0, 0> }
      }

      //---- Pinkie
      union {
         sphere { 0*x, 0.025 scale <0.6, 0.3, 0.33> rotate z*10 }
         sphere { 0*x, 0.025 scale <0.58, 0.25, 0.28> translate <0.015,0.002,0> }
         sphere { 0*x, 0.025 scale <0.53, 0.20, 0.26> rotate -z*7 translate <0.030,0.002,0> }
         rotate -y*10
         rotate -z*8
         translate <0.833, 0.020, 0.0375>
      }

      //---- Ring Finger
      union {
         sphere { 0*x, 0.03 scale <0.63, 0.3, 0.325> rotate z*13 }
         sphere { 0*x, 0.03 scale <0.60, 0.23, 0.30> rotate z*00 translate <0.019,0.0035,0> }
         sphere { 0*x, 0.03 scale <0.57, 0.20, 0.30> rotate -z*9 translate <0.034,0.0035,0> }
         rotate -y*05
         rotate -z*4
         translate <0.842, 0.021, 0.016>
      }

      //---- Middle Finger
      union {
         sphere { 0*x, 0.03 scale <0.77, 0.3, 0.32>  rotate z*15 }
         sphere { 0*x, 0.03 scale <0.70, 0.24, 0.30> rotate z*00 translate <0.023,0.004,0> }
         sphere { 0*x, 0.03 scale <0.55, 0.22, 0.28> rotate -z*8 translate <0.042,0.003,0> }
         rotate z*3
         translate <0.84, 0.024, -0.009>
      }

      //---- Index Finger
      union {
         sphere { 0*x, 0.03 scale <0.74, 0.35, 0.35> rotate z*10 }
         sphere { 0*x, 0.03 scale <0.70, 0.31, 0.33> rotate z*00 translate <0.023,0.004,0> }
         sphere { 0*x, 0.03 scale <0.60, 0.27, 0.30> rotate -z*8 translate <0.042,0.003,0> }
         rotate y*05
         rotate -z*8
         translate <0.824, 0.0165, -0.035>
      }

      //---- Thumb
      union {
         sphere { 0*x, 0.04 scale <0.7, 0.45, 0.5> rotate y*7 }
         sphere {
            0*x, 0.03
            scale <0.775, 0.4, 0.3>
            rotate -z*8 rotate y*10
            translate <0.02, -0.005, -0.014>
         }
         sphere {
            0*x, 0.03
            scale <0.52, 0.28, 0.21>
            rotate -z*8 rotate -y*25
            translate <0.045, -0.008, -0.013>
         }
         rotate -z*5
         rotate y*28
         translate <0.76, -0.005, -0.025>
      }
   }
   texture { Child_Flesh }
}



#declare Child_RightArm_JointFlex = on

#declare Child_RightArm = object {
   union {

      //---- Upper Arm

      union {
         //-- Shirt Cuff
         union {
            cone {
               -0.1*x, 0.0725, -0.3*x, 0.08
               open
               scale <0.9, 1.15, 1>
               translate -y*0.0175
            }
            torus {
               0.078, 0.003
               rotate z*90
               scale <2.5, 1.15, 1>
               translate <-0.3*0.9, -0.0175, 0>
            }
            texture {
               pigment { color rgb <0.925, 0.925, 0.975> }
               finish  { ambient 0.4 diffuse 0.45 crand 0.035 }
               normal  { wrinkles 0.30 turbulence 0.5 scale <0.015, 0.03, 0.02> }
            }
         }
         //-- Upper Arm
         cone { -0.2*x, 0.07, -0.42*x, 0.0625 }
         #if ( Child_LeftArm_JointFlex = on )
            rotate y*10
            translate <0, 0, -0.070>
         #end
      }

      //---- Forearm and lower hand
      union {
         cone { -0.4*x, 0.065, -0.75*x, 0.025 }
         sphere { -0*x, 0.065 scale <3.5,1,1> translate <-0.4, 0, 0> }
         cone { -0.74*x, 0.03, -0.81*x, 0.045 scale <1. 0.45, 1> translate y*0.01 }
         difference {
            sphere { 0*x, 0.045 scale <0.65, 0.47, 1> translate <-0.81, 0.01, 0> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <-0.81, 0.037, 0.0375> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <-0.81, 0.038, 0.0160> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <-0.81, 0.038, -0.090> }
            sphere { 0*x, 0.015 scale <1, 0.6, 0.55> translate <-0.81, 0.037, -0.030> }
         }
         sphere { 0*x, 0.03 scale <1.5, 0.9, 1> translate <-0.74, 0, 0> }
      }

      //---- Pinkie
      union {
         sphere { 0*x, 0.025 scale <0.6, 0.3, 0.33> rotate z*10 }
         sphere { 0*x, 0.025 scale <0.58, 0.25, 0.28> translate <-0.015,0.002,0> }
         sphere { 0*x, 0.025 scale <0.53, 0.20, 0.26> rotate -z*7 translate <-0.030,0.002,0> }
         rotate y*10
         rotate -z*8
         translate <-0.833, 0.020, 0.0375>
      }

      //---- Ring Finger
      union {
         sphere { 0*x, 0.03 scale <0.63, 0.3, 0.325> rotate z*13 }
         sphere { 0*x, 0.03 scale <0.60, 0.23, 0.30> rotate z*00 translate <-0.019,0.0035,0> }
         sphere { 0*x, 0.03 scale <0.57, 0.20, 0.30> rotate -z*9 translate <-0.034,0.0035,0> }
         rotate y*05
         rotate -z*4
         translate <-0.842, 0.021, 0.016>
      }

      //---- Middle Finger
      union {
         sphere { 0*x, 0.03 scale <0.77, 0.3, 0.32>  rotate z*15 }
         sphere { 0*x, 0.03 scale <0.70, 0.24, 0.30> rotate z*00 translate <-0.023,0.004,0> }
         sphere { 0*x, 0.03 scale <0.55, 0.22, 0.28> rotate -z*8 translate <-0.042,0.003,0> }
         rotate -z*3
         translate <-0.84, 0.024, -0.009>
      }

      //---- Index Finger
      union {
         sphere { 0*x, 0.03 scale <0.74, 0.35, 0.35> rotate z*10 }
         sphere { 0*x, 0.03 scale <0.70, 0.31, 0.33> rotate z*00 translate <-0.023,0.004,0> }
         sphere { 0*x, 0.03 scale <0.60, 0.27, 0.30> rotate -z*8 translate <-0.042,0.003,0> }
         rotate -y*05
         rotate -z*5
         translate <-0.83, 0.0175, -0.03>
      }

      //---- Thumb
      union {
         sphere { 0*x, 0.04 scale <0.7, 0.45, 0.5> rotate y*7 }
         sphere {
            0*x, 0.03
            scale <0.775, 0.4, 0.3>
            rotate -z*8 rotate -y*10
            translate <-0.02, -0.005, -0.014>
         }
         sphere {
            0*x, 0.03
            scale <0.52, 0.28, 0.21>
            rotate -z*8 rotate y*25
            translate <-0.045, -0.008, -0.013>
         }
         rotate -z*5
         rotate -y*28
         translate <-0.76, -0.005, -0.025>
      }
   }
   texture { Child_Flesh }
}



#declare Child_SLTexture = texture {
   pigment {
	  bozo
	  color_map {
		 [ 0.0 color rgb <0.80, 0.80, 0.80>*0.92 ]
		 [ 0.2 color rgb <0.80, 0.80, 0.80>*1.00 ]
		 [ 0.8 color rgb <0.80, 0.80, 0.80>*0.90 ]
		 [ 0.9 color rgb <0.80, 0.80, 0.80>*0.94 ]
		 [ 1.0 color rgb <0.80, 0.80, 0.80>*0.98 ]
	  }
	  turbulence 0.9 //0.5
   }
   finish { ambient 0.40 diffuse 0.3 specular 0.25 roughness 0.035 crand 0.05 metallic }
   scale 0.05
}

#declare Child_StreetLight = object {
   union {
      difference {
         cylinder { 0*y, 0.7*y, 0.125 }
         difference {
            box { <-0.07, 0.15, 0> <0.07, 0.55, -10> }
            box { <-0.05, 0.17, 10> <0.05, 0.53, -10> }
            cylinder { 0*y, 0.7*y, 0.115 }
            rotate -y*90
         }
      }
      union {
         cone { 0*z, 0.015, -0.03*z, 0.0075 }
         torus { 0.025, 0.005 rotate x*90 translate -z*0.03 }
         scale 0.5
         translate <0, 0.34, -0.123 >
         texture {
            pigment { color rgb <0.9, 0.9, 0.9> }
            finish  { ambient 0.35 diffuse 0.35 specular 0.4 roughness 0.01 reflection 0.15 }
         }
         rotate -y*77
      }
      torus { 0.125, 0.015 scale <1, 1, 1> }
      cone { 0.7*y, 0.125, 1.2*y, 0.0575 }
      torus { 0.0575, 0.02 scale <1, 2, 1> translate y*1.15 }
      cylinder { 0.9*y, 3.7*y, 0.0575 }
      difference {
         torus { 0.40, 0.0575 rotate x*90 }
         plane { y, 0 }
         plane { -x, 0 rotate z*10 }
         translate <0.40, 3.7, 0>
      }
      union {
         cylinder { 0*x, 1.2*x, 0.0575 }
         union {
            difference {
               sphere { 0*x, 0.325 }
               plane { y, 0 }
               plane { -x, 0 }
               scale <1, 0.5, 0.75>
            }
            difference {
               sphere { 0*x, 0.325 }
               plane { y, 0 }
               plane { x, 0 }
               scale <1.4, 0.5, 0.75>
            }
            difference {
               torus { 0.30, 0.025 }
               plane {  -x, 0 }
               scale <1, 1, 0.75>
            }
            difference {
               torus { 0.30, 0.025 }
               plane { x, 0 }
               scale <1.4, 1, 0.75>
            }
            union {
               difference {
                  sphere { 0*x, 0.25 }
                  plane { -y, 0 }
                  plane { -x, 0 }
                  scale <1, 0.455, 0.75>
               }
               difference {
                  sphere { 0*x, 0.25 }
                  plane { -y, 0 }
                  plane { x, 0 }
                  scale <1.4, 0.455, 0.75>
               }
               texture {
                  pigment { color rgbft <0.85, 0.85, 0.85, 0.25, 0.15> }
                  finish {
                     ambient 0.35 diffuse 0.35 specular 0.5
                     roughness 0.01 reflection 0.15 refraction on ior 1.5
                  }
                  normal {
                     average
                     normal_map {
                        [ 1 gradient z scallop_wave scale 0.05 ]
                        [ 1 gradient x scallop_wave scale 0.05 ]
                     }
                  }
               }
               hollow
               no_shadow
            }
            //light_source { <0, -0.1, 0> color rgb <1,1,1>*0.95  }
            translate <1.475, -0.04, 0>
         }
         torus { 0.0575, 0.015 rotate z*90 scale <2,1,1> translate x*1.15 }
         translate <0.40, 0.40, 0>
         rotate z*10
         translate y*3.635
      }
   }
   texture { Child_SLTexture }
   rotate y*90
}



// ===================== END OF FILE
