
// ----------- Shrubs.inc -----------

// A POV 3.0x include file by Chris Hernandez.
// Contains assorted foliage/leaf/grass textures. Any improvements
// or comments are welcome. My email address (as at Dec 97) is
// chrish@australia.net.au




// ------ Foliage 1.  A dark green foliage, suitable for dense bushes.

#declare CBH_Foliage1A = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.423, 0.627, 0.000, 0.400> ]
         [ 0.75 color rgbt <0.560, 0.667, 0.196, 0.400> ]
         [ 0.90 color rgbt <0.067, 0.667, 0.196, 0.400> ]
         [ 1.00 color rgbt <0.145, 0.627, 0.353, 0.400> ]
      }
      turbulence 1.5
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate z*70
}

#declare CBH_Foliage1B = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.413, 0.627, 0.000, 0.000> ]
         [ 0.60 color rgbt <0.570, 0.667, 0.196, 0.000> ]
         [ 0.80 color rgbt <0.067, 0.667, 0.196, 0.000> ]
         [ 1.00 color rgbt <0.145, 0.627, 0.353, 0.000> ]
      }
      turbulence 2
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.05
   }
   scale 0.2
}

#declare CBH_Foliage1C = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.423, 0.627, 0.000, 0.000> ]
         [ 0.60 color rgbt <0.560, 0.667, 0.196, 0.000> ]
         [ 0.80 color rgbt <0.067, 0.667, 0.196, 0.000> ]
         [ 1.00 color rgbt <0.145, 0.627, 0.353, 0.000> ]
      }
      turbulence 1.5
   }
   //normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   normal { bumps 1 turbulence 0.25 rotate x*65 scale 0.45 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate y*70
}

#declare CBH_Foliage1 = // --- Layer textures
   texture { CBH_Foliage1A }
   texture { CBH_Foliage1B }
   texture { CBH_Foliage1C }



// ------ Foliage 2.  A medium green to brown foliage, suitable for lighter bushes.

#declare CBH_Foliage2A = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.623, 0.627, 0.000, 0.400> ]
         [ 0.75 color rgbt <0.760, 0.667, 0.196, 0.400> ]
         [ 0.90 color rgbt <0.067, 0.667, 0.196, 0.400> ]
         [ 1.00 color rgbt <0.345, 0.627, 0.353, 0.400> ]
      }
      turbulence 1.5
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate z*70
}

#declare CBH_Foliage2B = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.613, 0.827, 0.000, 0.000> ]
         [ 0.60 color rgbt <0.770, 0.867, 0.196, 0.000> ]
         [ 0.80 color rgbt <0.067, 0.867, 0.196, 0.000> ]
         [ 1.00 color rgbt <0.345, 0.827, 0.353, 0.000> ]
      }
      turbulence 2
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.05
   }
   scale 0.2
}

#declare CBH_Foliage2C = texture {
   pigment {
      marble //bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.623, 0.877, 0.300, 0.000> ]
         [ 0.60 color rgbt <0.790, 0.917, 0.496, 0.000> ]
         [ 0.80 color rgbt <0.667, 0.767, 0.496, 0.000> ]
         [ 1.00 color rgbt <0.445, 0.677, 0.353, 0.000> ]
      }
      turbulence 1.5
   }
   normal { bumps 1 turbulence 0.25 rotate x*65 scale 0.45 }
   finish {
      ambient 0.30
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate y*70
}

#declare CBH_Foliage2 = // --- Layer textures
   texture { CBH_Foliage2A }
   texture { CBH_Foliage2B }
   texture { CBH_Foliage2C }




// ------ Foliage 3.  Similar to Foliage2, but has some subtle differences.

#declare CBH_Foliage3A = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.623, 0.627, 0.000, 0.400> ]
         [ 0.75 color rgbt <0.760, 0.667, 0.196, 0.400> ]
         [ 0.90 color rgbt <0.067, 0.667, 0.196, 0.400> ]
         [ 1.00 color rgbt <0.345, 0.627, 0.353, 0.400> ]
      }
      turbulence 1.5
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate z*70
}

#declare CBH_Foliage3B = texture {
   pigment {
      granite //bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.613, 0.827, 0.000, 0.000> ]
         [ 0.60 color rgbt <0.770, 0.867, 0.196, 0.000> ]
         [ 0.80 color rgbt <0.067, 0.867, 0.196, 0.000> ]
         [ 1.00 color rgbt <0.345, 0.827, 0.353, 0.000> ]
      }
      turbulence 2
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.05
   }
   scale 0.2
}

#declare CBH_Foliage3C = texture {
   pigment {
      granite //bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.723, 0.877, 0.300, 0.000> ]
         [ 0.60 color rgbt <0.790, 0.917, 0.496, 0.000> ]
         [ 0.80 color rgbt <0.767, 0.767, 0.496, 0.000> ]
         [ 1.00 color rgbt <0.445, 0.377, 0.353, 0.000> ]
      }
      turbulence 1.5
   }
   normal { bumps 1 turbulence 0.25 rotate x*65 scale 0.45 }
   finish {
      ambient 0.30
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate y*70
}

#declare CBH_Foliage3 = // --- Layer textures
   texture { CBH_Foliage3A }
   texture { CBH_Foliage3B }
   texture { CBH_Foliage3C }



// ------ Foliage 4.  A sparse green foliage, for use with trees and larger plants.

#declare CBH_Foliage4A = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.60 color rgbt <0.623, 0.627, 0.000, 0.400> ]
         [ 0.75 color rgbt <0.760, 0.667, 0.196, 0.400> ]
         [ 0.90 color rgbt <0.067, 0.667, 0.196, 0.400> ]
         [ 1.00 color rgbt <0.345, 0.627, 0.353, 0.400> ]
      }
      turbulence 1.5
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate z*70
}

#declare CBH_Foliage4B = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.45 color rgbt <0.613, 0.827, 0.000, 0.000> ]
         [ 0.60 color rgbt <0.770, 0.867, 0.196, 0.000> ]
         [ 0.80 color rgbt <0.067, 0.867, 0.196, 0.000> ]
         [ 1.00 color rgbt <0.345, 0.827, 0.353, 0.000> ]
      }
      turbulence 2
   }
   normal { bozo 1 turbulence 0.25 rotate x*65 scale 0.2 }
   finish {
      ambient 0.3
	  diffuse 0.25
      crand 0.05
   }
   scale 0.2
}

#declare CBH_Foliage4C = texture {
   pigment {
      crackle //bozo
      colour_map {
         [ 0.00 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.000, 0.000, 0.000, 1.000> ]
         [ 0.30 color rgbt <0.623, 0.877, 0.300, 0.000> ]
         [ 0.60 color rgbt <0.790, 0.917, 0.496, 0.000> ]
         [ 0.80 color rgbt <0.667, 0.767, 0.496, 0.000> ]
         [ 1.00 color rgbt <0.445, 0.677, 0.353, 0.000> ]
      }
      turbulence 1.5
   }
   normal { bumps 1 turbulence 0.25 rotate x*65 scale 0.45 }
   finish {
      ambient 0.30
	  diffuse 0.25
      crand 0.1
   }
   scale 0.2
   rotate y*70
}

#declare CBH_Foliage4 = // --- Layer textures
   texture { CBH_Foliage4A }
   texture { CBH_Foliage4B }
   texture { CBH_Foliage4C }




// ------------------------------------------------------------------------------------------
// Some simple bushes, used in my scene "Ice Cream Man!" for the Nov-Dec 97 IRTC.
// ------------------------------------------------------------------------------------------

/*

#declare Q229_Shrub1 = object {
   union {
      sphere { 0*y, 0.35 scale <0.8, 3.5, 0.8> translate y*1.35 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage4 }
   }
}

#declare Q229_Shrub2 = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.1, 1> translate y*0.5 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}

#declare Q229_Shrub3 = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.3, 1> translate y*0.45 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage2 }
   }
}

#declare Q229_Shrub4 = object {
   union {
      sphere { 0*y, 0.35 scale <0.8, 1.6, 0.6> translate y*0.65 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage2 }
   }
}

#declare Q229_Shrub5 = object {
   union {
      sphere { 0*y, 0.35 scale <1.4, 1.6, 1> translate y*0.6 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}

#declare Q229_Shrub6 = object {
   union {
      sphere { 0*y, 0.08 scale <1, 0.8, 1> translate -z*0.085 rotate y*000 }
      sphere { 0*y, 0.09 scale <1, 0.8, 1> translate -z*0.085 rotate y*120 }
      sphere { 0*y, 0.07 scale <1, 0.8, 1> translate -z*0.085 rotate y*240 }
      texture { CBH_Foliage1 }
   }
   scale <2.25, 2.65, 2.25>
   clipped_by { plane { -y, 0 } }
}

*/

// ------------------------------------------------------------------------------------------
// A grass texture.
// ------------------------------------------------------------------------------------------

#declare CBH_Grass1 = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgb <0.7, 0.9, 0.3> ]
         [ 0.33 color rgb <0.6, 0.8, 0.3> ]
         [ 0.66 color rgb <0.6, 0.95, 0.3> ]
         [ 1.00 color rgb <0.65, 0.7, 0.3> ]
      }
      turbulence 2 //1
   }
   finish { ambient 0.35 diffuse 0.35 crand 0.15 }
   normal {
      bump_map {
         gif "grass1.gif"
         map_type 0
         interpolate 2
         use_color
         bump_size 40 //20
      }
      rotate -x*90
      scale <0.01, 1, 0.01>
   }
}
