
// Persistence of Vision Ray Tracer Scene Description File
// File: icecream.pov
// Vers: 1.00

// Desc: --------* ICE CREAM!!!! *--------
//         Picture of a child running after an ice cream truck, taken from
//         the child's point of view. In the background are the 2 houses
//         my parents have lived in during my childhood.
//         Environment can be set to midday or sunset using the render
//         controls below. The bush in the foreground was created using
//         v3.0 of Sonya Roberts tree include file. My thanks to her.
//         Created for the Nov-Dec 1997 round of the IRTC.

// Date: 31st Dec 1997
// Auth: Chris Hernandez


// ==== Standard POV includes ===
#include "colors.inc"   // Standard Color definitions
#include "SKIES.INC"

// ==== Custom Includes ====
//#include "TALBINGO.INC"    // * These are kept here for reference. Include instructions
//#include "TRUCK.INC"       //    are now in the body of the scene. Done to streamline
//#include "GIFTREES.INC"    //    the scene controls (see below).
//#include "FOLIAGE.INC"
//#include "229.INC"
#include "CHLDMISC.INC"



// ------------- Some housekeeping def's.

global_settings { max_trace_level 10 assumed_gamma 2.2 }

background { color rgb <0.6, 0.6, 0.6> }

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.35
	   diffuse 0.35
	   specular 0.3
       roughness 0.01
	   //reflection 0.05
	}
}

#declare RedT = texture { pigment { color rgb <1,0,0> } finish { ambient 0.6 } }


//---Put reference lines on origin for placement purposes.
//cylinder { -100*x, 100*x, 0.01 texture { RedT } }
//cylinder { -100*x, 100*x, 0.01 translate -z*3.5 texture { RedT } }





// ******************************************************************************************
// -------------------------------------- Main Scene ----------------------------------------
// ******************************************************************************************



//==================================== Scene Controls ======================================

//   * These controls make it easier to debug the scene. They enable quick switching from
//     high to low quality renders, and also make it easy to change environments. You can
//     also toggle on/off the scene elements which take up a lot of memory.

   #declare None = off
   #declare Sunset = 1               //-------- Environmental controls
   #declare Daytime = 2
   #declare Environment = Sunset

   #declare Q229_Switch = on         //-------- Switch on/off scene elements
   #declare Talbingo_Switch = on
   #declare Truck_Switch = on
   #declare GIFTrees = on
   #declare SR_Tree = on

   #declare AreaLights = on         //-------- Rendering controls
   #declare FocalBlur = off

//==========================================================================================


// ---------------------------------------- Position houses and truck

#if ( Q229_Switch = on )
   #include "229.INC"
   object { Q229_Main translate <-7.5, -0.05, 10.2> scale 1.1 }
#end


#if ( Talbingo_Switch = on )
   #include "TALBINGO.INC"
   object { Talbingo  translate <9.25, 0, 8.25> scale 1.1 }
#end


#if ( Truck_Switch = on )
   #include "TRUCK.INC"
   object { IceCreamTruck translate <-10, -0.15, -5.75> } //<-9.5, -0.15, -5.5>
#end




// ---------------------------------------- Other elements in scene

// ---- Sidewalk/kerbing on house side of street

object { Child_Sidewalk }

difference {
   box { <-30, -0.15, -3> <30, 0.01, -1> }
   sphere { 0*x, 0.1 scale <16, 1.5, 2.5> translate <4.8, 0.01, -3.15> texture { Concrete } }
   sphere { 0*x, 0.1 scale <15, 1.5, 2.5> translate <-2.0, 0.01, -3.15> texture { Concrete } }
   texture { CBH_Grass1 }
}

// ---- Kerbside; subtract driveway bits
difference {
   box { <-30, -0.15, -3> <30, 0.01, -3.2> }
   sphere { 0*x, 0.1 scale <16, 1.5, 2> translate <4.8, 0.01, -3.15> }
   sphere { 0*x, 0.1 scale <16, 1.5, 2> translate <-16.25, 0.01, -3.15> }
   sphere { 0*x, 0.1 scale <15, 1.5, 2> translate <-2.0, 0.01, -3.15> }
   cylinder { -10*z, 10*z, 0.065 translate <-14, -0.075, 0> }
   texture { Concrete }
}

// ---- Driveway for 229
difference {
   box { <-2, -0.15, -3> <2, 0.02, -0.5> }
   plane { -x, 0 rotate -y*6 translate < 1.2, 0, -3> }
   plane {  x, 0 rotate  y*6 translate <-1.2, 0, -3> }
   sphere { 0*x, 0.1 scale <16, 1.5, 2> translate <0, 0.01, -3.15> }
   translate <4.8, 0, 0>
   texture { Concrete }
}

difference {
   box { <-2, -0.15, -3> <2, 0.02, -0.5> }
   plane { -x, 0 rotate -y*6 translate < 1.2, 0, -3> }
   plane {  x, 0 rotate  y*6 translate <-1.2, 0, -3> }
   sphere { 0*x, 0.1 scale <16, 1.5, 2> translate <0, 0.01, -3.15> }
   translate <-16.25, 0, 0>
   texture { Concrete }
}

// ---- Driveway for Talbingo
difference {
   box { <-1.3, -0.15, -3.01> <1.0, 0.02, -1> }
   sphere { 0*x, 0.1 scale <16, 1.5, 2> translate <0, 0.01, -3.15> }
   translate <-1.8, 0, 0>
   texture { Concrete /*Talbingo_PavingTexture*/ }
}


// ---- Main hollow for road surface

#declare Child_RoadLines = texture {
   pigment {
      gradient x
      colour_map {
         [ 0.00 color rgb <0.4, 0.4, 0.4> ]
         [ 0.20 color rgb <0.4, 0.4, 0.4> ]
         [ 0.20 color rgb <1, 1, 1> ]
         [ 0.80 color rgb <1, 1, 1> ]
         [ 0.80 color rgb <0.4, 0.4, 0.4> ]
         [ 1.00 color rgb <0.4, 0.4, 0.4> ]
      }
      scale <3, 1, 1>
   }
   finish { ambient 0.35 diffuse 0.35 }
}
texture {
   pigment {
      gradient z
      colour_map {
         [ 0.00 color rgbt <0.4, 0.4, 0.4, 0> ]
         [ 0.48 color rgbt <0.4, 0.4, 0.4, 0> ]
         [ 0.48 color rgbt <1, 1, 1, 1> ]
         [ 0.52 color rgbt <1, 1, 1, 1> ]
         [ 0.52 color rgbt <0.4, 0.4, 0.4, 0> ]
         [ 1.00 color rgbt <0.4, 0.4, 0.4, 0> ]
      }
      scale <1, 1, 5>
      translate z*0.3
   }
   finish { ambient 0.35 diffuse 0.35 crand 0.075 }
   normal { bozo 0.3 turbulence 1.5 scale 0.1 }
}


difference {
   plane { y, 0 texture { pigment { colour rgb <0, 1, 0> } } }
   box { <-30, -0.15, -14> <30, 10, 0> }
   texture { Child_RoadLines }
}


// ---- Sidewalk/kerbing on opposite site of street
box { <-30, -0.15, 3> <30, -0.01, 3.2> translate -z*14 texture { Concrete } }
object { Child_Sidewalk translate -z*12.75 }



// ---- Nature strip in forground; done w/ h-fields for greater detail.

#declare Child_NSTexture = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgb <0.7, 0.9, 0.3> ]
         [ 0.33 color rgb <0.6, 0.8, 0.3> ]
         [ 0.66 color rgb <0.6, 0.95, 0.3> ]
         [ 1.00 color rgb <0.65, 0.7, 0.3> ]
      }
      turbulence 2 //1
   }
   finish { ambient 0.35 diffuse 0.35 crand 0.15 }
}

#declare Child_NatureStrip = object {
   union {
      height_field {
         gif "grass1.gif"
         translate <-0.5, 0, -0.5>
         water_level 0.01
         scale <15, 0.10, 1.5>
         translate <-15, -0.10, 1.5>
         translate -x*15
         texture { Child_NSTexture }
      }
      height_field {
         gif "grass1.gif"
         translate <-0.5, 0, -0.5>
         water_level 0.01
         scale <15, 0.10, 1.5>
         translate <-15, -0.10, 1.5>
         translate -x*0
         texture { Child_NSTexture }
      }
      height_field {
         gif "grass1.gif"
         translate <-0.5, 0, -0.5>
         water_level 0.01
         scale <15, 0.10, 1.5>
         translate <-15, -0.10, 1.5>
         translate  x*15
         texture { Child_NSTexture }
      }
      height_field {
         gif "grass1.gif"
         translate <-0.5, 0, -0.5>
         water_level 0.01
         scale <15, 0.10, 1.5>
         translate <-15, -0.10, 1.5>
         translate x*30
         texture { Child_NSTexture }
      }
   }
}

object { Child_NatureStrip translate <0, 0.05, -13.5> }


// ---- Bush in foreground right. Calls Sonya Roberts trees.inc v3.0  -  Thanks Sonya!

#if ( SR_Tree = on )

   object {
      #declare BaseLen = 0.095
      #declare BarkTexture=0
      #declare LeafShape=0
      #declare Leaves = texture { pigment { color YellowGreen } finish { ambient 0.28 diffuse 0.3 } }
      #declare LeafTexture=1
      #declare MinXDeg=35
      #declare MaxXDeg=60
      #declare LengthInc=0.9 //.15
      #declare MaxSplits=4
      #declare MinSplits=3
      #declare IncSplits=1.3
      #declare IncXDeg = 5 //10
      #include "trees.inc"
      translate <-11.70, -0.1, -12.5>
   }

#end


#declare Child_ExtraDriveway = object {
   union {
      box { <-1.2, -0.15, 0> <1.2, 0.01, -1.75> }
      box {
         <-1.1, -0.15, -0.1> <1.1, 0.02, -1.65>
         texture {
            Concrete
            finish { crand 0.2 }
            normal { bozo 0.5 turbulence 2.5 scale 0.1 }
         }
      }
      texture { Concrete }
   }
}

object { Child_ExtraDriveway translate <-16.85, 0.04, -11> }
object { Child_Fence scale <1, 0.75, 1> translate <-15, 0, -18> }
object { Child_Fence scale <1, 0.75, 1> translate <-13, 0, -18> }

object { Child_StreetLight scale <0.925, 1.125, 0.925> translate <-14.5, 0, -2.9> }
object { Child_StreetLight no_shadow scale <0.925, 1.125, 0.925> translate < 3.5, 0, -2.9> }




// ------ Put in shell of extra "house"  between light and scene, for added realism
//        in reflections and partial blocking of light source.

union {
   difference {
      box { <-4.5, 0, 0> <4.5, 5, 10> }
      box { <-4.4, 0.1, 0.1> <4.4, 4.9, 9.9> }
   }
   difference {
      box {
         <-4.5/sqrt(2), -4.5/sqrt(2), 0> <4.5/sqrt(2), 4.5/sqrt(2), 10>
         rotate z*45
         scale <1, 0.35, 1>
         clipped_by { plane { -y, 0 } }
      }
      plane { z, 0 rotate x*45 }
      plane { -z, -10 rotate -x*45 }
      translate y*5
   }
   scale 1.3
   translate < 16.25, 0, -25>
   texture { TempTexture }
}



// ---- Treeline in the background. Each tree is a picture of a tree material_mapped
//      onto very thin boxes. Definitions for these are in giftrees.inc

#if ( GIFTrees = on )

   #include "GIFTREES.INC"

   object { CBH_GIFTree1 scale 1.0 translate <20, 0, 20> }
   object { CBH_GIFTree1 scale 1.3 translate <15, 0, 30> }
   object { CBH_GIFTree1 scale 1.1 translate <-7, 0, 25> }
   object { CBH_GIFTree2 scale 1.0 translate < 7, 0, 25> }
   object { CBH_GIFTree2 scale 1.0 translate < 35, 0, 20> }
   object { CBH_GIFTree4 scale 1.0 translate <-12, 0, 20> }
   object { CBH_GIFTree4 scale 1.6 translate < 37, 0, 25> }
   object { CBH_GIFTree4 scale 1.4 translate < 5, 0, 25> }
   object { CBH_GIFTree5 scale 1.0 translate <13, 0, 30> }

   object { CBH_GIFTree1 scale 1.3 translate <35, 0, 50> }
   object { CBH_GIFTree3 scale 1.3 translate <-15, 0, 50> }
   object { CBH_GIFTree4 scale 1.3 translate <10, 0, 50> }

#end



// ---- Position Child's arms

object { Child_LeftArm rotate z*5 rotate x*28 rotate -y*65 translate <-16.5, 0.9, -15.40> }
object { Child_RightArm rotate -z*5 rotate x*28 rotate y*133 translate <-16.41, 0.9, -15.46> }



// ---- Camera Definition

camera {
  //direction <0, 0, 1>
  //location <0,0,0>
  //rotate -z*45
  location <-16.5, 1.2, -15.5> // <0.0 , 9 ,-25.0>
  sky <0.035, 1, 0>
  look_at  <-6.75, 1.5, 0>  // <-1, 1.5, 0.0>
  angle 52 //55
  #if ( FocalBlur = on )
     blur_samples 50
     aperture 0.025
     confidence 0.985
     focal_point <-6.75, 1.5, 0>
  #end
}








// ******************************************************************************************
// --------------------------------------- Environment --------------------------------------
// ******************************************************************************************


#if ( Environment = Sunset )

// -------------------------------- light sources ---------------
light_source { <50, 0, 0> color rgb <1.000, 0.498, 0.000>*0.05  }
light_source { <0, 50, 0> color rgb <1.000, 0.498, 0.000>*0.05 }
light_source { <-10, 0.2, -50> color rgb <1.000, 0.498, 0.000>*0.15 }

#if ( AreaLights = on )

light_source {
   <0, 5, -50>
   color rgb <1.000, 0.498, 0.000>*0.5
   area_light <5,0,0>, <0,5,0>, 6, 6 //7, 7
   jitter
   adaptive 2
}

light_source {
   <-50, 5, -50>
   color rgb <1.000, 0.498, 0.000>*0.1
   area_light <5,0,0>, <0,5,0>, 3, 3
   jitter
   adaptive 0
}

light_source {
   < 32.5, 7.5, -50>
   color rgb <1.000, 0.498, 0.000>*0.25
   area_light <5,0,0>, <0,5,0>, 3, 3
   jitter
   adaptive 0
   looks_like {
      sphere {
         x*0, 1
         //texture { pigment {color rgb <0,1,0.25>} finish {ambient 1} }

         texture {
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
               emitting
               spherical_mapping
               linear
               color_map {
                  [ 0 color rgbt <1, 0.35, 0, 0.75> ]
                  [ 1 color rgbt <1, 0.45, 0, -0.75> ]
               }
               samples 10
            }
         }

         hollow
         scale 4.5
      }
   }
}

#end


#if ( AreaLights = off )

light_source {
   <0, 5, -50>
   color rgb <1.000, 0.498, 0.000>*0.5
}

light_source {
   <-50, 5, -50>
   color rgb <1.000, 0.498, 0.000>*0.1
}

light_source {
   < 32.5, 7.5, -50>
   color rgb <1.000, 0.498, 0.000>*0.25
   looks_like {
      sphere {
         x*0, 1
         texture {
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
               emitting
               spherical_mapping
               linear
               color_map {
                  [ 0 color rgbt <1, 0.35, 0, 0.75> ]
                  [ 1 color rgbt <1, 0.45, 0, -0.75> ]
               }
               samples 10
            }
         }

         hollow
         scale 4.5
      }
   }
}

#end


//  Darin Dugger's "Kite" clouds, taken from clouds.inc and slightly modified for sunset.

#declare T_Cloud2 =
texture {
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.80, .75, .75, 0>
                      color rgbf<.95, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.95, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }

    finish {
        ambient 0.30 //0.9
        diffuse 0.90 //0.1
    }
}

#declare T_Cloud3 =
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.85, .75, .75, 0>
                      color rgbf<.95, .9, .9, .9> ]
            [0.4, 0.7 color rgbf<.95, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 0.35 //1.0
        diffuse 0.85 //0.0
    }
}
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.85, .75, .75, 0>
                      color rgbf<.95, .9, .9, .9> ]
            [0.4, 0.6 color rgbf<.95, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 0.35 //0.95
        diffuse 0.85 //0.0
    }
scale .9
translate y*-0.15
}

#declare O_Cloud2 =
union {
    plane { -y, -500
        texture {
            T_Cloud3
            scale 600
        }
    }
    plane { -y, -3000
        texture {
            T_Cloud2
            scale <900,1,6000>
            translate x*3000
            rotate -30*y
        }
    }
}

#declare P_Cloud4 =
pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 SkyBlue * 1.00 ]
        [0.50 color rgb <1.000, 0.815, 0.709>*0.85 ]
        [1.00 color rgb <1.0, 0.5, 0.0>*0.5 ]
    }
    scale <0.5, 0.15, 1>
}


sky_sphere {
	pigment {
		gradient y
        /*
		pigment_map {
			[0.00 rgb <0.847, 0.749, 0.847> ] // horizon
			[0.10 SkyBlue ]                   // horizon
			[0.20 P_Cloud4 ]
		}
        */
        pigment_map {
			[0.00 rgb <0.847, 0.449, 0.247> ] // horizon
			//[0.05 SkyBlue]                   // horizon
			[0.15 P_Cloud4 scale 1 rotate y*0 ]
		}
	}
}
object { O_Cloud2 scale <1.65, 1, 1.65> rotate y*0 inverse }

fog {  // Add very thin fog to fade out smoothly to infinity.
   fog_type 1
   distance 25000
   turbulence 0.5
   color rgbft <0.807, 0.549, 0.347, 0, 0.05> //<0.847, 0.449, 0.247, 0, 0.1>
}

#end



#if ( Environment = Daytime )     // ----- Bright day/Daytime environment.

// -------------------------------- light sources ---------------
light_source { <50, 0, 0> color rgb <0.6, 0.6, 0.6>  }
light_source { <0, 50, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <-50, 0, -50> color rgb <0.6, 0.6, 0.6> }



// ***********************************
//  Darin Dugger's "Kite" clouds
// ***********************************

#declare T_Cloud2 =
texture {
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }

    finish {
        ambient 0.9
        diffuse 0.1
    }
}

#declare T_Cloud3 =
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 1.0
        diffuse 0.0
    }
}
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.6 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 0.95
        diffuse 0.0
    }
scale .9
translate y*-0.15
}


#declare O_Cloud2 =
union {
    plane { -y, -500
        texture {
            T_Cloud3
            scale 600
        }
    }
    plane { -y, -3000
        texture {
            T_Cloud2
            scale <900,1,6000>
            translate x*3000
            rotate -30*y
        }
    }
}

sky_sphere {
	pigment {
		gradient y
		pigment_map {
			[0.00 rgb <0.847, 0.749, 0.847> ] // horizon
			[0.10 SkyBlue ]                   // horizon
			[0.20 P_Cloud4 ]
		}
	}
}
object { O_Cloud2 scale <1.75, 1, 1.75> inverse }

fog {
   fog_type 1
   distance 25000
   turbulence 0.5
   color rgbft <0.847, 0.749, 0.847, 0, 0.1>
}

#end


#if ( Environment = off )    // ----- turns off environment, just lights. 

// -------------------------------- light sources ---------------
light_source { <50, 0, 0> color rgb <0.6, 0.6, 0.6>  }
light_source { <0, 50, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <-50, 0, -50> color rgb <0.6, 0.6, 0.6> }

#end


// ******************************** END OF FILE
