//steam engine
#declare ringer =
union{
  cylinder { 0*x,  1.5*x,  .03
       rotate <0,0,-35>
       translate <1,3.5,0>
  }
  cylinder { 0*x,  1.6*x,  .03
       rotate <0,0,-20>
       rotate <0,75,0>
       translate <2.25,2.65,0>
  }
  texture {black1}

}

#declare smokestack =
union {

cylinder { 5*y,  6.5*y,  1
  hollow
  texture {
    pigment { colour Clear }
    halo {
      linear
      max_value 1
      cylindrical_mapping
      emitting
      turbulence .7
      colour_map {
        [0.0 color rgbt <1, 1, 1, 1>]
        [0.2 color rgbt <.8, .8, .8, .5>]
        [0.4 color rgbt <1, 1, 0, 1>]
        [0.6 color rgbt <.8, .8, .8, .5>]
        [0.8 color rgbt <1, 0, 0, .5>]
        [1.0 color rgbt <1, 1, 1,1>]
      }
      scale 0.6
      samples 10
      aa_level 0
      aa_threshold 0.3
    }
  }
  scale <1.5,1,1.5>
}

cylinder { 6.5*y,  8.5*y,  1
  hollow
  texture {
    pigment { colour Clear }
    halo {
      linear
      max_value 1
      cylindrical_mapping
      emitting
      turbulence .8
      colour_map {
        [0.0 color rgbt <1, 1, 1, 1>]
        [0.2 color rgbt <.8, .8, .8, .5>]
        [0.4 color rgbt <1, 1, 0, 1>]
        [0.6 color rgbt <.8, .8, .8, .5>]
        [0.8 color rgbt <1, 0, 0, .5>]
        [1.0 color rgbt <1, 1, 1,1>]
      }
      scale 0.6
      samples 10
      aa_level 0
      aa_threshold 0.3
    }
  }
  scale <7,.5,1.5>
  rotate <0,180,0>
  translate <3.5,3,0>
}

union {
torus
{
  .5,
  0.1
  translate <0,2.5,0>
}

torus
{
  .5,
  0.2
  translate <0,1.4,0>
}

torus
{
  1,
  0.2
  translate <0,4.8,0>
}

torus
{
  1.45,
  0.1
  translate <0,4.5,0>
}

torus
{
  1.41,
  0.1
  translate <0,4,0>
}
 texture {stripes2}
}

union{
cone
{
  4.5*y,  1.5,
  5*y, 1
   open

}

cylinder
{
  4*y,  4.5*y,  1.5
  open

}

cone
{
  2.5*y,  0.55,
  4*y, 1.5
   open

}

cylinder
{
  1.5*y,  2.5*y,  .55
  open

}


//pigment {color White}
texture {black1 }
}
translate <-3.5,0,0>
}

#declare boiler =
union{
 sphere { < -5.75, 0, 0 >, .2 pigment { color rgbft <1,1,1,1,1> } hollow}
light_source { < -5.75, 0, 0 > color rgb <1, 1, 1>
spotlight
    point_at <-100, 0, 0>
    radius 70
    falloff 70
    atmospheric_attenuation on
 }
/*
cylinder
{
  -5.75*x,  -5.45*x,  .21 hollow
 }
*/
cylinder
{
  -5*x,  2.5*x,  1.5
 }

sphere
{
  <-12.5, 0, 0>
  1.5
  scale <.4,1,1.025>
}

texture {stripes3
             scale <2,1,1>}


}

#declare cab =
union {
light_source { < 2.5, .1, 0 > color rgb <1, .25, 0> atmosphere off  }
torus
{
  0.1,
  0.025
  texture {white1 }
  rotate <0,0,90>
  translate <2.25,2.7,0>
}

difference {
superellipsoid
{
  <.25, .5>
  hollow
}

torus
{
  0.4,
  0.35
  rotate <90,0,0>
  translate <-1.2,-1.2,-.75>
}

torus
{
  0.4,
  0.35
  rotate <90,0,0>
  translate <-1.2,-1.2,.75>
}

union{
superellipsoid
{
  <.25, .5>

}

torus
{
  0.4,
  0.35
  rotate <90,0,0>
  translate <-1.2,-1.2,-.75>
}

torus
{
  0.4,
  0.35
  rotate <90,0,0>
  translate <-1.2,-1.2,.75>
}
scale <.9,.9,.9>
}

superellipsoid
{
  <0.5, .5 >
  scale <.35,.4,1.5>
  translate <-.4,.4,0>

  }

difference{
superellipsoid
{
  <0.5, .5 >
  scale <1.5,.4,.8>
  translate <0,.5,0>
  }

 cylinder
{
  -1.25*x,  .5*x,  .5
  scale <1,1,1.2>
  translate <0,-.08,0>

}

}
plane
{ -x, 0}

 texture {white1 }
 scale <3,2.4,2.6>
 translate <5,.6,0>
}

}

#declare wheelset1 =
union {

object {wheel2
 translate <4.3,-2.4,-1.75>
 }

 object {wheel1
 translate <1.8,-1.8,-1.75>
 }

 object {wheel1
 translate <-1.25,-1.8,-1.75>
 }

 object {wheel2
 translate <-3.5,-2.4,-1.75>
 }
}



#declare wheelset2 =
union {

object {wheel2
 rotate <180,0,0>
 translate <4.3,-2.4,-1.75>
 }

 object {wheel1
 rotate <180,0,0>
 translate <1.8,-1.8,-1.75>
 }

 object {wheel1
 rotate <180,0,0>
 translate <-1.25,-1.8,-1.75>
 }

 object {wheel2
 rotate <180,0,0>
 translate <-3.5,-2.4,-1.75>
 }

}

#declare fullwheelset1 =
union {
object {wheelset1}
object {wheelset2
        translate <0,0,3.5>
        }
}


#declare piston1 =
union{


cylinder
{
  1*x,  2.5*x,  .5
   translate <-5.3,-1.75,-1.75>
}



sphere
{
  <0, 0, 0>
  0.5
  scale <.7,1,1>
  translate <-4.4,-1.75,-1.75>
}

texture {black1}
}

#declare piston2 =
union{


cylinder
{
  1*x,  2.5*x,  .5
   translate <-5.3,-1.75,1.75>
}



sphere
{
  <0, 0, 0>
  0.5
  scale <.7,1,1>
  translate <-4.4,-1.75,1.75>
}

texture {black1}
}





#declare cowcatcher =

difference {
cone
{
  -1*y,  1.5,
  -2.2*y, 2.5

}

cone
{
  -.9*y,  1.5,
  -2.3*y, 2.5
  translate <.3,0,0>

}

plane
{
  -x,
  0.00
}

#declare Count = 0 #while (Count < 17)
box
{
  <0, -1.1, -.1>
  < -2.5, -2.1, -.2>
    rotate <0,(Count* -5),0>
}

box
{
  <0, -1.1, -.1>
  < -2.5, -2.1, -.2>
    rotate <0,(Count* 5),0>
}
#declare Count = Count + 1 #end

texture {red1}

   translate <-4.2,-.5,0>
}

//steam engine for room.pov

#declare carriage=
union{
 box
{
  <-4.25, -1.5, -1.4>
  < 5, -2.1, 1.4>
  texture {black1 }
}

object {joint
         rotate <0,180,0>
         translate <5.5,-2.2,0>
         texture {black1}}
}


#declare engine =
union {

 object {carriage}
 object {smokestack}
 object {boiler}
 object {cab}
 object {fullwheelset1}
 object  {piston1}
 object  {piston2}
 object {bell_apparatus}
 object {ringer}
 object {cowcatcher}

 }

