#declare Crank_Wheel_Polygon_1 =
prism {
	linear_sweep
	linear_spline
	0, 0.18
	10,
	<-0.23,2.38>,<-0.60,2.10>,<-0.90,0.89>,<-0.15,-0.17>,<0.90,-0.17>,
	<1.70,0.50><1.85,0.95>,<1.48,2.10>,<1.00,2.45>,<-0.23,2.38>
	translate <-0.44,0,-1.13>
	rotate 180*y
	scale 0.87
}

#declare Crank_Wheel_Red =
difference {
	union {
		// disk
		difference {
			object { Crank_Wheel_Polygon_1 }
			object { Crank_Wheel_Polygon_1 scale <0.95,1,0.95> translate -0.03*y }
		}
		#if (d_Crank = 2)
		// add wood texture to top
		object { Crank_Wheel_Polygon_1 scale <1,0.20,1> translate 0.15*y
			texture {
				pigment {
    				wood
					color_map { m_Wood_Red }
					turbulence 0.03
    				scale 0.11
    				translate <20, 0, 0>
				}
				finish {
    				ambient .2
        			diffuse .6
        			phong .08
        			phong_size 20
				}
				scale 2
    		}
		}
		#end
		// axle
		cylinder { <0,-0.62,0><0,0,0> 0.10 }
		#if (d_Crank = 2)
		cylinder { <0,-0.28,0><0,0,0> 0.16 }
		cylinder { <0,-0.010,0><0,0.22,0> 0.22 }
		cylinder { <0,-0.62,0><0,0,0> 0.05 translate 0.10*z rotate -30*y }
		// pins
		#declare ang = 0
		#while (ang < 331)
			union {
				cylinder { <0,0.18,0><0,0.42,0> 0.045 }
				sphere { <0,0.42,0> 0.045 }
				translate -1*x rotate ang*y
			}
			#declare ang = ang + 30
		#end
	#end
	}
	// hole in pole
	cylinder { <0,-0.05,0><0,0.47,0> 0.15 }
	#if (d_Crank = 2)
	texture { pigment { Red }
 		  finish { phong 0.8 phong_size 20 }
	}
	#else
	texture { pigment { Red } }
	#end
}

#declare Crank_Frame =
union {
	// base
	prism {
		linear_sweep
		linear_spline
		-0.04, 0.04,
		7,
		<1.05,0.44>,<1.35,0>,<0.79,-0.88>,<-0.79,-0.88>,<-1.35,0>,<-1.05,0.44>,<1.05,0.44>
	}
	// upright
	difference {
		union {
			prism {
				linear_sweep
				linear_spline
				-0.03, 0.03,
				5,
				<0.80,0>,<0.40,2.40>,<-0.40,2.40>,<-0.80,0>,<0.80,0>
			}
			#if (d_Crank = 2)
			// rounded corners
			cylinder { <0,-0.03,0><0,0.03,0> 0.05 translate <-0.35,0,2.37> }
			cylinder { <0,-0.03,0><0,0.03,0> 0.05 translate <0.35,0,2.37> }
			box { <-0.35,-0.03,2.37><0.35,0.03,2.42> }
			// vertical rib
			prism {
				linear_sweep
				linear_spline
				-0.03, 0.03,
				6,
				<0,0>,<0,1.75>,<0.18,1.75>,<0.18,1.50>,<0.35,0>,<0,0>
				rotate 90*z
			}
			// ring
			cylinder { <0,-0.25,2.10><0,0.18,2.10> 0.30 }
			#end
		}
		// hole in ring
		cylinder { <0,-0.30,2.10><0,0.20,2.10> 0.24 }
		rotate -90*x
	}
	#if (d_Crank =2)
	// cylinders on base
	cylinder { <0.55,0.06,0><0.55,0.06,-0.88> 0.06 }
	cylinder { <-0.55,0.06,0><-0.55,0.06,-0.88> 0.06 }
	// vertical rounded supports
	box { <-0.53,0,-0.28><-0.57,0.15,0.28> }
	cylinder { <-0.53,0.23,0><-0.57,0.23,0> 0.28 scale <1,0.7,1> }
	box { <0.53,0,-0.28><0.57,0.15,0.28> }
	cylinder { <0.53,0.23,0><0.57,0.23,0> 0.28 scale <1,0.7,1> }
	#end

	#if (d_Crank = 2)
	texture {
		pigment { Blue }
 		finish { phong 0.8 phong_size 20 }
	}
	#else
	pigment { Blue }
	#end
}

#declare Crank_Lever =
union {
	// flat part
	prism {
		linear_sweep
		linear_spline
		-0.02, 0.02
		5,
		<-0.35,0><0.35,0>,<0.25,-0.80><-0.25,-0.80><-0.35,0>
	}
	#if (d_Crank = 2)
	// add rounded corners
	cylinder { <-0.29,-0.02,0><-0.29,0.02,0> 0.06 }
	cylinder { <0.29,-0.02,0><0.29,0.02,0> 0.06 }
	box { <-0.29,-0.02,0><0.29,0.02,0.06> }
	// hub
	cylinder { <0,-0.10,-0.3><0,0.40,-0.3> 0.20 }
	// key portion of hub
	box { <-0.14,-0.10,-0.66><0.14,0,-0.3> }
	// angled part
	union {
		prism {
			linear_sweep
			linear_spline
			-0.02, 0.02
			5,
			<-0.25,0><0.25,0>,<0.14,-1.1><-0.14,-1.1><-0.25,0>
		}
		// round off end
		cylinder { <0,-0.02,0><0,0.02,0> 0.14 translate <0,0,-1.12> }
		// vertical rib
		box { <-0.02,0,0.4><0.02,0.35,-1.1> }
		rotate 10*x
		translate <0,0,-0.77>
	}
	#end
	// handle post
	cylinder { <0,0,0><0,1.1,0> 0.09
		 clipped_by { plane {-y,-0.02} rotate 10*x  }
		 translate <0,0.15,-1.85>
	}

	#if (d_Crank = 2)
	texture {
		pigment { rgb <0.0,0.30,0.0> }
		finish { phong 0.8 phong_size 20 }
	}
	#else
	pigment { Green }
	#end
}

#declare Crank =
union {
	object { Crank_Frame rotate <0,0,0> translate <0,0,0> }
	union {
		object { Crank_Wheel_Red rotate 30 *y rotate <90,0,0> translate <0,2.13,0.38> }
	 	object { Crank_Lever rotate <-90,0,0> translate <0,2.39,-0.38> }
		translate -2.13*y
		// this rotates the wheel/crank
		rotate 240*z
		translate 2.13*y
	}
}

#declare Crank_Wheel_Polygon_2 =
prism {
	linear_sweep
	linear_spline
	0, 0.18
	10,
	<-0.23,2.38>,<-0.60,2.10>,<-0.90,0.89>,<-0.07,-0.17>,<0.78,-0.20>,
	<1.76,0.65><1.85,0.95>,<1.48,2.10>,<1.00,2.45>,<-0.23,2.38>
	translate <-0.44,0,-1.13>
	rotate 180*y
	scale 0.87
}

#declare Crank_Wheel_Yellow =
difference {
	union {
		// disk
		difference {
			object { Crank_Wheel_Polygon_2 }
			object { Crank_Wheel_Polygon_2 scale <0.95,1,0.95> translate -0.03*y }
		}
		#if (d_Crank = 2)
		// add wood texture to top
		object { Crank_Wheel_Polygon_2 scale <1,0.20,1> translate 0.15*y
			texture {
				pigment {
    				wood
					color_map { m_Wood_Yellow }
					turbulence 0.04
    				scale 0.07
    				translate <10, 0, 0>
				}
				finish {
    				ambient .2
        			diffuse .6
        			phong .08
        			phong_size 20
				}
				scale 2
    		}
		}
		#end
		// axle
		cylinder { <0,-0.57,0><0,0,0> 0.10 }
		#if (d_Crank = 2)
		cylinder { <0,-0.28,0><0,0,0> 0.16 }
		cylinder { <0,-0.010,0><0,0.22,0> 0.22 }
		cylinder { <0,-0.57,0><0,0,0> 0.05 translate 0.10*z rotate -30*y }
		// pins
		#declare ang = 0
		#while (ang < 331)
			union {
				cylinder { <0,0.18,0><0,0.42,0> 0.045 }
				sphere { <0,0.42,0> 0.045 }
				translate -1*x rotate ang*y
			}
			#declare ang = ang + 30
		#end
		// cam
		union {
			cylinder { <0,0,0><0,0.25,0> 0.05 }
			box { <0,0,-0.05><0.50,0.25,0.05> }
			box { <0,0,-0.05><0.35,0.15,0.05> rotate 50*z translate <0.50,0,0> }
			translate<-0.60,-0.25,0>
			rotate -5*y
			translate -1.0*x
		}
	#end
	}
	// hole in pole
	cylinder { <0,-0.05,0><0,0.47,0> 0.15 }
	#if (d_Crank = 2)
	texture { pigment { Yellow }
 		  finish { phong 0.8 phong_size 20 }
	}
	#else
	texture { pigment { Yellow } }
	#end
}

/*
union {
	object { Base rotate 0*y translate <0,0,0> }
	object { Crank_Wheel_Yellow rotate 160*y translate <3,1.44,0.60> }
	object { Crank translate <3,0.70,-1.10> }
	object { Gate rotate 168*y translate <0,1,0> }
	object { Gate_Rubber_Band scale <1.02,1.3,1.45> rotate 4*z rotate 112*y translate <-1.50,1.25,1.90> }
	object { Lamppost rotate 159*y translate <-2.65,1.77,0.48> }

}
*/
