#declare t_Gutter =
texture { pigment { Red }
 		  finish { phong 0.8 phong_size 20 }
}

#declare Gutter_Straight =
union {
	// shell
	difference {
		cylinder { <0,0,-0.5><0,0,0.5>, 0.5 }
		cylinder { <0,0,-0.51><0,0,0.51>, 0.44 }
		plane { -y, 0 }
	}
	#if (d_Gutter = 2)
	// flat bottom of shell
	intersection {
		cylinder { <0,0,-0.5><0,0,0.5>, 0.5 }
		box { <-0.5,-0.5,-0.51><0.5,-0.35,0.51> }
	}
	// ridge in center
	cylinder { <0,-0.35,-0.5><0,-0.35,0.5>, 0.06 }
	// rounded edges
	difference {
		cylinder { <-0.54,0,-0.5><-0.54,0,0.5>, 0.10 }
		plane { y, 0 }
	}
	difference {
		cylinder { <0.54,0,-0.5><0.54,0,0.5>, 0.10 }
		plane { y, 0 }
	}
	#end
	texture { t_Gutter }
}

#declare Gutter_Round =
union {
	// shell
	difference {
		torus { 1.0, 0.5 }
		torus { 1.0, 0.44 }
		plane { -y, 0 }
	}
	#if (d_Gutter = 2)
	// flat bottom of shell
	intersection {
		torus { 1.0, 0.5 }
		box { <-1.51,-0.5,-1.51><1.51,-0.35,1.51> }
	}
	// ridge in center
	object { torus { 1.0, 0.06 } translate -0.35*y }
	// rounded edges
	difference {
		object { torus { 1.54, 0.10 } }
		plane { y, 0 }
	}
	difference {
		object { torus { 0.46, 0.10 } }
		plane { y, 0 }
	}
	#end
	texture { t_Gutter }
}

#declare Gutter_Round_Quarter =
difference {
	object { Gutter_Round }
	plane { x, 0 }
	plane { z, 0 }
	texture { t_Gutter }
	translate -1*x
}

#declare Gutter_Pin =
union {
	cylinder { <0,0,0><0,-0.1,0> 0.2 clipped_by { plane {x,0.1} } }
	cylinder { <0,-0.1,0><0,-0.45,0> 0.05 }
	texture { t_Gutter }
}

#declare Gutter_Post_1 =
union {
	difference {
		cylinder { <0,0,0><0,-1.5,0> 0.15 }
	 	box { <-0.2,-1.6,-0.2><0,-1.37,0.2> }
		rotate -90*y
	}
	triangle { <0,0,-0.01><0.55,0,0.01><0,-0.9,0> }
	texture { t_Gutter }
}

#declare Gutter_Post_2 =
union {
	difference {
		cylinder { <0,0,0><0,-1.5,0> 0.15 }
	 	box { <-0.2,-1.6,-0.2><0,-1.37,0.2> }
	}
	triangle { <0,0,-0.01><0.55,0,0.01><0,-0.9,0> }
	triangle { <0,0,-0.01><-0.55,0,0.01><0,-0.9,0> }
	texture { t_Gutter }
}

#declare Gutter_Post_3 =
union {
	cylinder { <0,0,0><0,-1.1,0> 0.15 }
	triangle { <0,0,-0.01><0.65,0,0.01><0,-0.7,0> }
	triangle { <0,0,-0.01><-0.65,0,0.01><0,-0.7,0> }
	texture { t_Gutter }
}

#declare Gutter =
union {
	object { Gutter_Straight scale <1,1,3> translate -1.5*z }
	object { Gutter_Round_Quarter rotate 0*y translate <0,0,0> }
	object { Gutter_Round_Quarter rotate 180*y translate <-2.0,0,2> }
	object { Gutter_Straight scale <1,1,1.0> translate <-2,0,2.5> }
	object { Gutter_Round_Quarter rotate -90*y translate <-1.0,0,4> }
	object { Gutter_Straight scale <1,1,1.0> rotate 90*y translate <-0.5,0,4> }
	object { Gutter_Round_Quarter rotate 90*y translate <0,0,4> }
	object { Gutter_Round_Quarter rotate 0*y translate <1,0,5> }
	object { Gutter_Straight scale <1,1,1.0> rotate 90*y translate <-0.5,0,6> }

	#if (d_Gutter = 2)
	// pins on end of straight piece
	object { Gutter_Pin translate <-0.6,0,-2.8> }
	object { Gutter_Pin rotate 180*y translate <0.6,0,-2.8> }
	// posts
	object { Gutter_Post_1 translate <-0.7,-0.50,6> }
	object { Gutter_Post_2 rotate -90*y translate < 1.0,-0.50,5> }
	object { Gutter_Post_3 rotate  90*y translate <-2.0,-0.50,2.5> }
	#end

	texture { t_Gutter }
	translate 3*z
}
