
// Persistence of Vision Ray Tracer Scene Description File
// Desc: Mousetrap Game, Tinker Toys and Legos
// Date: 11/05/97
// Auth: Mark J. Murphy

#version 3

// detail levels -  0 -> ommit  1 -> low detail  2 -> high detail

#declare d_Gutter   = 2
#declare d_Tinker   = 2
#declare d_Dice     = 2
#declare d_Trap     = 2
#declare d_Base     = 2
#declare d_Gate     = 2
#declare d_Crank    = 2
#declare d_Lamppost = 2
#declare d_Board    = 2
#declare d_Lego     = 2
#declare d_Floor    = 2
#declare d_Wall     = 2
#declare d_Outlet   = 2

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"
#include "finish.inc"
#include "Glass.inc"
#include "Gutter.inc"
#include "Tinker.inc"
#include "Dice.inc"
#include "Trap.inc"
#include "Base.inc"
#include "Gate.inc"
#include "Lamppost.inc"
#include "Board.inc"
#include "Crank.inc"
#include "Lego.inc"
#include "Floor.inc"
#include "Wall.inc"
#include "Outlet.inc"

global_settings
{
  assumed_gamma 1.0
  radiosity {
  		brightness 3.3
    	count 200
    	distance_maximum 5
    	error_bound 0.33
    	gray_threshold 0.5
    	low_error_factor 0.8
    	minimum_reuse 0.015
    	nearest_count 10
    	recursion_limit 1
	}
}

camera
{
	location  <11.3,3.5, -4.9>
  	direction 1.5*z
  	right     4/3*x
  	look_at   < 4,3.5, 0.2>
}

light_source
{
  0*x
  color rgb <1,1,1>
  translate <0, 0, -30>
}

light_source
{
  0*x
  color rgb <1,1,1>
  spotlight
  translate <40, 30, 0>
  point_at <2,3,6>
  radius 5
  tightness 30
  falloff 8
}

light_source
{
  0*x
  color rgb<0.5,0.5,0.5>
  shadowless
  translate <-10, 40, -20>
}

light_source { <0,30,0> color rgb <1,1,1> }

// board
#if (d_Board > 0)
	object { Board rotate 180*y translate <0,0,0> }
#end

// crank / wheels / lever / boot
union {
	#if (d_Base > 0)
		object { Base rotate 0*y translate <0,0,0> }
	#end
	#if (d_Crank > 0)
	object { Crank_Wheel_Yellow rotate 160*y translate <3,1.44,0.60> }
	object { Crank translate <3,0.70,-1.10> }
	#end
	#if (d_Gate > 0)
	object { Gate rotate 168*y translate <0,1,0> }
	object { Gate_Rubber_Band scale <1.02,1.3,1.45> rotate 4*z rotate 112*y translate <-1.50,1.25,1.90> }
	#end
	#if (d_Lamppost > 0)
	object { Lamppost rotate 159*y translate <-2.65,1.77,0.48> }
	#end
	rotate 178*y
	translate <-1,0,4.4>
}

// gutter
#if (d_Gutter > 0)
	object { Gutter rotate -5*x rotate 255*y translate <3.5,0.8,2> }
#end

// trap
#if (d_Trap > 0)
	object { Trap rotate -90*y translate <-2,0,1> }
#end

// house
#if (d_Tinker > 0)
	object {
		Tinker_House
		 	rotate  87*y
			translate <-23,-0.1,8>
	}
#end

// die and ball
#if (d_Dice > 0)
	union {
		object { Dice_1 rotate 90*x rotate 28*y translate <3.4,0.3, 3.7> }
		object { Dice_1 rotate 90*y rotate 73*y translate <4.3,0.3, 4.5> }
	}
	// ball
	sphere {
		<0,0,0> 0.35
		texture { T_Silver_3E }
		translate <1.2,0.35,0.3>
	}
#end

// lego plane
#if (d_Lego > 0)
	object { Lego_Plane rotate < -90, 38,180> translate <-7.3,5.04,14.2> }
#end

// floor
#if (d_Floor > 0)
	object { Floor rotate <0,0,0> translate <-100,-0.1,-50> }
#end

// walls
#if (d_Wall > 0)
	object { Wall translate <-50,0,25> }
	object { Wall rotate -90*y translate <-60,0,15> }
	object { Outlet rotate    -90*y translate < -60.2, 13,12> }
#end
