
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.02
// Desc: Space Clock, Time can be set ***
// Date: 13.12.1997
// Auth: (c) N.B. 1997

#declare Plastic_TEX=
texture{
   finish{
      brilliance .6
      diffuse .9
      ambient .2
      phong .5
      phong_size 10
   }
   pigment{color rgb <.5,.5,1>}
}

#declare Acrylic_TEX=
texture{
   finish{
      diffuse .9
      ambient .1
      reflection .15
      phong .5
      phong_size 10
   }
   pigment{color rgbt <1,1,1,.9>}
}

#declare Hour_Num = 12
#declare Hour_Ang = 360 / Hour_Num
#declare Col_Case = 0

#declare S_HND_R01=.05
#declare S_HND_L01=2.8
#declare S_HND_L02=.5

#declare M_HND_R01=.1
#declare M_HND_L01=2.4
#declare M_HND_L02=.4

#declare H_HND_R01=.15
#declare H_HND_L01=2
#declare H_HND_L02=.3

// ***Set Time:
#declare HOURS=2
#declare MINUTES=25
#declare SECONDS=42

#declare Chi_Clock=
union{
   intersection{
      text { ttf "tt0167m_.ttf" "NB1997" 1, 0
         translate x*-1.8
         scale .3
         translate <0,.65,-.12>
      }
      sphere {0, 1.2
         scale <1,1,.11>*1.02
      }
   }

   cylinder {<0,0,0><0,0,.5>3.8
      texture{Plastic_TEX pigment{color rgb <0,0,0>}}
   }
   sphere {0, 1.2
      scale <1,1,.11>
      texture{Plastic_TEX pigment{color rgb <1,.5,0>}}
   }

   // numbers
   #while (Hour_Num >= 1)
      union{
         text { ttf "tt0167m_.ttf" str(Hour_Num,2,0) .5, 0
            #if (Hour_Num > 9)
               scale .95
               translate x*.3
            #end
            translate <-.7,-.25,0>
            rotate z*Hour_Ang*Hour_Num
            translate y*2.6
         }
         sphere {0, .15
            translate y*1.8
            texture{Plastic_TEX pigment{color rgb <1,.5,0>}}
         }
         cone {<0,1,0>.35<0,1.7,0>0
            scale <1,1,.2>
            texture{Plastic_TEX pigment{color rgb <1,.5,0>}}
         }
         rotate z*-Hour_Ang*Hour_Num
         texture{Plastic_TEX
            #switch (Col_Case)
               #case (0)
                  pigment{color rgb <.5,.5,1>}
                  #declare Col_Case = 1
               #break
               #case (1)
                  pigment{color rgb <1,1,0>}
                  #declare Col_Case = 2
               #break
               #case (2)
                  pigment{color rgb <1,0,.5>}
                  #declare Col_Case = 0
               #break
            #end
         }
      }
      #declare Hour_Num = Hour_Num - 1
   #end

   //clock
   union{
      torus{3.7,.5 rotate x*90}
      torus{3.7,.5 rotate x*90 translate z*3}
      cylinder {<0,0,3><0,0,3.5>3.7}
      cylinder {<0,0,-.2><0,0,0>3.7  texture{Acrylic_TEX} }
      difference{
         cylinder {<0,0,3><0,0,0>(3.7+.5)}
         cylinder {<0,0,2><0,0,-1>(3.7-.5)}
      }
      cylinder {<0,0,.3><0,0,.6>.1
        texture{Plastic_TEX pigment {color rgb <1,.5,0>} }
      }
      sphere {<0,0,.3>.2
        texture{Plastic_TEX pigment {color rgb <1,.5,0>} }
      }

      //second hand
      union{
         cylinder{<0,-S_HND_L02,0><0,S_HND_L01,0>S_HND_R01}
         sphere{<0,S_HND_L01,0>S_HND_R01}
         sphere{<0,-S_HND_L02,0>S_HND_R01}
         translate z*.4
         rotate z*360/60*SECONDS*-1
         texture{Plastic_TEX pigment {color rgb <1,1,1>} }
      }

      //minute hand
      union{
         cylinder{<0,-M_HND_L02,0><0,M_HND_L01,0>M_HND_R01}
         sphere{<0,M_HND_L01,0>M_HND_R01}
         sphere{<0,-M_HND_L02,0>M_HND_R01}
         translate z*.6
         rotate z*(360/60*MINUTES+360/(60*60)*SECONDS)*-1
         texture{Plastic_TEX pigment {color rgb <1,1,1>} }
       }

      //hour hand
      union{
         cylinder{<0,-H_HND_L02,0><0,H_HND_L01,0>H_HND_R01}
         sphere{<0,H_HND_L01,0>H_HND_R01}
         sphere{<0,-H_HND_L02,0>H_HND_R01}
         translate z*.8
         rotate z*(360/12*HOURS+360/(60*12)*MINUTES)*-1
         texture{Plastic_TEX pigment {color rgb <1,1,1>} }
      }
      translate z*-1
   }
   //knob
   union{
      sphere{ 0, .7}
      torus{.7+.4,.4
         scale <1,.5,1>
      }
      translate <0,3.7+.5+.7,.5>
      texture{Plastic_TEX pigment {color rgb <1,.5,0>}}
   }
   //stand
   #declare Std_Num = 8
   #declare Std_Ang = 360/Std_Num
   union{
      #while ( Std_Num >= 0)
         sphere{ <0,0,2>, .5
            rotate y*Std_Ang*Std_Num
            #declare Std_Num = Std_Num - 1
         }
      #end
      translate <0,-(3.7+.5+.5),1>
      texture{Plastic_TEX pigment {color rgb <1,.5,0>}}
   }
   translate y*(3.7+.5+.5+.5)
   texture{Plastic_TEX}
}

//object { Chi_Clock scale 10 rotate y*-25 translate <-190,0,80>}
