
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: MISCELLANEOUS OBJECTS
// Date: 30.12.1997
// Auth: (c) N.B. 1997

// paper texture

#declare PAP_TEX=
texture{
   finish{
      brilliance .8
      diffuse .9
      ambient .2
      phong .01
      phong_size 1
   }
   normal{ bumps .1 scale 20 }
   pigment{color rgb <.95,.95,.92>}
}

// notebook cover texture

#declare COV_TEX=
texture{
   finish{
      diffuse .9
      ambient .2
      reflection .1
      phong .3
      phong_size 10
   }
   normal{ bumps .1 scale 20 }
   pigment{ color rgb < .5, .5, 1 >*.7 }
}

// PAPER CLIP, BENDING ANGLES CAN BE SET

/*
#declare I_Ang01 = -5 //10
#declare O_Ang01 = 20 //40
#declare O_Ang02 = -120 //-80
#declare O_Ang03 = 25 //40
#declare Segm01 = 2.5 //2.5
*/
#declare P_CL01=
union{
   cylinder{ < -1, 0, 0 > < 1, 0, 0 > .5 }
   intersection{
      torus{ 2, .5 }
      box{ < 0, -1, 0 > < 3, 1, -3 > }
      translate < 1, 0, 2 >
   }
   intersection{
      torus{ 2, .5 }
      box{ < 0, -1, 0 > < -3, 1, -3 > }
      translate < -1, 0, 2 >
   }
   cylinder{ < 3, 0, 2 > < 3, 0, 21+2 > .5 }
   cylinder{ < -3, 0, 2 > < -3, 0, 16+2 > .5 }
   difference{
      torus{ 2, .5 }
      box{ < 0, -1, 0 > < -3, 1, -3 > }
      box{ < -.5, -1, 0 > < 3, 1, -3 > rotate y*I_Ang01}
      translate < -1, 0, 16+2 >
   }
   cylinder{ < 0, 0, 0 > < 0, 0, -12.5 > .5
      translate x*2
      rotate y*I_Ang01
      translate < -1, 0, 16+2 >
   }
   difference{
      torus{ 2, .5 }
      box{ < -3, -1, 0 > < 3, 1, -3 > }
      box{ < 3, -1, 0 > < -3, 1, 3 > rotate y*-O_Ang01}
      translate < 1, 0, 21+2 >
   }
   cylinder{ < 2, 0, 0 > < 2, 0, Segm01 > .5
      rotate y*-O_Ang01
      translate < 1, 0, 21+2 >
   }
   difference{
      torus{ 2, .5 }
      box{ < -3, -1, 0 > < 3, 1, -3 > }
      box{ < -3, -1, 0 > < 3, 1, -3 >  rotate y*-O_Ang02}
      translate z*Segm01
      rotate y*-O_Ang01
      translate < 1, 0, 21+2 >
   }
   cylinder{ < -2, 0, 0 > < -2, 0, -Segm01 > .5
      rotate y*-O_Ang02
      translate z*Segm01
      rotate y*-O_Ang01
      translate < 1, 0, 21+2 >
   }
   difference{
      torus{ 2, .5}
      box{ < -3, -1, 0 > < 3, 1, 3 > }
      box{ < -3, -1, 0 > < 3, 1, -3 >  rotate y*-O_Ang03}
      translate z*-Segm01
      rotate y*-O_Ang02
      translate z*Segm01
      rotate y*-O_Ang01
      translate < 1, 0, 21+2 >
   }
   cylinder{ < -2, 0, 0 > < -2, 0, -17 > .5
      rotate y*-O_Ang03
      translate z*-Segm01
      rotate y*-O_Ang02
      translate z*Segm01
      rotate y*-O_Ang01
      translate < 1, 0, 21+2 >
   }
translate y*.5
texture{T_Copper_3C}
}

//object {P_CL01 translate z*-13}

// NOTEBOOK SPIRAL

#declare Branch_Length = 290
#declare Curvature = 5
#declare R01= .5

#declare XX1 = 0
#declare YY1 = 0
#declare ZZ1 = 0
#declare NW01 = 50
#declare NS01 = 36
#declare KOUNT0 = NS01*NW01
#declare dX = Branch_Length/KOUNT0
#declare ANG = 0
#declare dANG = 2*pi/NS01
#declare KOUNT1 = KOUNT0

#declare Spiral01=
union{
#while (KOUNT1>=0)
   #declare YY1=sin(ANG)*Curvature
   #declare ZZ1=cos(ANG)*Curvature
   sphere{0,R01 translate <XX1,YY1,ZZ1>}
   #declare XX2=(XX1+dX)
   #declare ANG=ANG+dANG
   #declare YY2=sin(ANG)*Curvature
   #declare ZZ2=cos(ANG)*Curvature
   cylinder{<XX1,YY1,ZZ1><XX2,YY2,ZZ2>,R01}
   #declare XX1=XX2
   #declare KOUNT1=KOUNT1-1
#end
//translate x*-(Branch_Length)
translate y*(Curvature + R01)
//rotate z*90
texture{T_Chrome_3C}
}

// NOTEBOOK PAGES + COVER

#declare Boo_Thk01 = 8
#declare Cov_Thk01 = .5
#declare Num_Pgs01 = 24
#declare Pag_Thk01 = (Boo_Thk01-2*Cov_Thk01)/(Num_Pgs01+1)
#declare Pag_Rnd01 = seed (87)

#declare Pages01=
union{
   box{<(297-Branch_Length)/-2,Boo_Thk01-Cov_Thk01,0><297-(297-Branch_Length)/2,Boo_Thk01,210>}
   box{<(297-Branch_Length)/-2,0,0><297-(297-Branch_Length)/2,Cov_Thk01,210>}
   #while( Num_Pgs01 >= 0)
      box{<297/-2,0,0><297-297/2,Pag_Thk01,210>
         texture{PAP_TEX }
         translate y*Cov_Thk01
         translate y*Pag_Thk01*Num_Pgs01
         rotate y*2*(0.5-rand(Pag_Rnd01))
         translate x*Branch_Length/2
      }
      #declare Num_Pgs01 = Num_Pgs01 - 1
   #end
rotate x*degrees ( atan2 ( (Curvature + R01-4),210) )
translate y*(Curvature + R01-4)
texture{COV_TEX}
}

// NOTEBOOK

#declare N_Book01=
union{
   object{Spiral01}
   object{Pages01}
}

// plane {y,0 texture{PAP_TEX pigment{color rgb <1,.5,0>}}}
