
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: BLOBSTER_37
// Date: 18.11.97
// Auth: N.B.(c)1997


//-------------------------------------------------------------------------------
// IMPORTANT
// Units are arbitrary, consider 1:25 or 1:24 scale model, mm.
// To raytrace BLOBSTER_37 add the following lines in the main file:
/*
// needed for all chrome parts:
#include "metals.inc"

// "on" - default textures used, set this to "off" to use custom textures:
#declare DEFAULTS_FLAG = on

// choose between coupe, "off" and convertible, "on":
#declare CONVERT_FLAG = off

// choose between "normal", "on" and "low resolution" radiator grill, "off":
// use "low resolution" to avoid aliasing.
#declare GRILL_FLAG = on

// this .inc file:
#include "f_37_01.inc"

// BLOBSTER_37 object:
object { CAR01 translate y*13 }
*/
//-------------------------------------------------------------------------------

#if ( DEFAULTS_FLAG = on )

//TEXTURES:
// Tyres:
#declare TTEX =
   texture{
      finish{
         ambient <0.9,0.85,.8>*.2
         diffuse .95
         phong .05
         phong_size 3
      }
      pigment{color rgb <0.9,0.85,.8>*.2}
   }

// Chrome parts:
#declare WTEX = texture{T_Chrome_4D}

// Default yellow paint:
#declare BTEX =
   texture{
      finish {
         ambient <1,.9,.05>*.3
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.3
      }
      normal {bumps 0.05 scale 20}
      pigment{color rgb <1,.9,.05>}
   }

// body:
#declare BTEX01 = texture { BTEX }
// roof:
#declare BTEX02 = texture { BTEX }
// front fenders:
#declare BTEX03 = texture { BTEX }
// rear fenders:
#declare BTEX04 = texture { BTEX }

// Default yellow upholstery:
#declare STEX =
   texture{
      finish {
         ambient <1,.9,.1>*.4
         diffuse 0.7
         specular 0.80
         roughness 1/80
      }
      normal {wood .1  scale <2,100,1>*.8 rotate y*90}
      pigment{color rgb <1,.9,.1>}
   }

// Glass:
#declare GTEX =
texture{
   finish{
      ambient <0.9,0.95,1>*0.1
      diffuse 0.1
      reflection 0.1
      refraction 1
      ior 1.45
      specular 0.8
      roughness 0.003
   }
   pigment{color rgbf <0.9,0.95,1,.85>}
}

// Front lamps:
/*
#declare LTEX =
texture{
   finish{
      ambient <0.2,0.1,.17>
     reflection 0.5
      specular 0.8
      roughness 0.003
      phong 1
      phong_size 400
   }
   normal {wood .3  scale <15,.15,.15> rotate x*-30}
   pigment{
      color rgb <0.7,1,.92,>
   }
}
*/

#declare LTEX =
   texture{T_Chrome_4D
      normal {wood .3  scale <15,.15,.15> rotate x*-30}
   }

#end

#declare INNR01=8.5
#declare OUTR01=13
#declare SMOO01=(OUTR01-INNR01)/2
#declare SMOO02=.5
#declare SM0s01=.5
#declare WIDT01=11

#declare TY01=
difference{
   union{
      cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01))><0,0,(WIDT01/2-(SMOO01*SM0s01))*-1>OUTR01}
      torus {INNR01+SMOO01,SMOO01 scale <1,SM0s01,1> rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01))*-1}
      torus {INNR01+SMOO01,SMOO01 scale <1,SM0s01,1> rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01))}
      torus {OUTR01*.99,SMOO02 scale <1,(WIDT01/2-(SMOO01*SM0s01))/(SMOO02*.96),1> rotate x*90 }
   }
   cylinder {<0,0,(WIDT01/2)*1.5><0,0,(WIDT01/2)*-1.5>INNR01}
texture{TTEX}
}

#declare STEP01=1

#declare TY02=
union{
   difference{
       union{
          torus {INNR01-.3,STEP01 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-STEP01)*-1}
          torus {INNR01-.3,STEP01 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-STEP01)*1}
          cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01)-STEP01)*1><0,0,(WIDT01/2-(SMOO01*SM0s01)-STEP01)*-1>INNR01-.3+STEP01}
          }
       cylinder {<0,0,(WIDT01/2-STEP01*2)*1.5><0,0,(WIDT01/2-STEP01*2)*-1.5>INNR01-.3-STEP01}
   }
    difference{
       union{
          torus {INNR01-(STEP01+.3),1 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-2)*-1}
          torus {INNR01-(STEP01+.3),1 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-2)*1}
          cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01)-2)*1><0,0,(WIDT01/2-(SMOO01*SM0s01)-2)*-1>INNR01-(STEP01*2+.3)}
          }
       cylinder {<0,0,(WIDT01/2-2)*1.5><0,0,(WIDT01/2-2)*-1.5>INNR01-.3-STEP01*2}
   }
   difference{
         sphere {0,1  scale<INNR01-.3-STEP01*1.9,INNR01-.3-STEP01*1.9,1> translate z*-1}
      #declare SECT01 = 5
      #declare ANGL01 = 360/SECT01
      #declare ANGL00 = 0
      #while (SECT01>0)
         box{<0,0,-5><1,1,5> rotate z*-45 scale <9,12,1>
                    translate x*(INNR01-5)
                    rotate z*ANGL00
                    }
         #declare SECT01 = SECT01-1
         #declare ANGL00 = ANGL00 + ANGL01
      #end
      cylinder{<0,0,-1.5><0,0,-5>,2.5}
      cylinder{<0,0,-1><0,0,5>,INNR01-.3-STEP01*1.9}
   }
   difference{
      cylinder{<0,0,-1><0,0,-3.5>,1.6}
      #declare SECT01 = 6
      #declare ANGL01 = 360/SECT01
      #declare ANGL00 = 0
      #while (SECT01>0)
         box{<0,3,-2.5><2,-3,-5>
                    translate x*1.35
                    rotate z*ANGL00
                    }
         #declare SECT01 = SECT01-1
         #declare ANGL00 = ANGL00 + ANGL01
      #end
      cylinder{<0,0,-3><0,0,-5>,1}
      }
   difference{
      cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01))*1.1><0,0,(WIDT01/2-(SMOO01*SM0s01))*-1.1>INNR01}
      cylinder {<0,0,(WIDT01/2)*1.5><0,0,(WIDT01/2)*-1.5>INNR01-.3}
      }
texture{WTEX}
}

#declare INNR01=8.5
#declare OUTR01=14
#declare SMOO01=(OUTR01-INNR01)/2
#declare SMOO02=.5
#declare SM0s01=.5
#declare WIDT01=11

#declare TY011=
difference{
   union{
      cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01))><0,0,(WIDT01/2-(SMOO01*SM0s01))*-1>OUTR01}
      torus {INNR01+SMOO01,SMOO01 scale <1,SM0s01,1> rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01))*-1}
      torus {INNR01+SMOO01,SMOO01 scale <1,SM0s01,1> rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01))}
      torus {OUTR01*.99,SMOO02 scale <1,(WIDT01/2-(SMOO01*SM0s01))/(SMOO02*.96),1> rotate x*90 }
   }
   cylinder {<0,0,(WIDT01/2)*1.5><0,0,(WIDT01/2)*-1.5>INNR01}
texture{TTEX}
}

// FRONT FENDER (left):

#declare RADI01 = .65
#declare STRE01 = 3
#declare DENS01 = STRE01*pow((1-pow(RADI01,2)),2)

#declare BODY01l=
difference{
blob{ threshold DENS01
   sphere{0,1,STRE01 scale <15.7/(RADI01*2),21.2/(RADI01*2),8/(RADI01*2)>
          rotate z*-108
          rotate y*-3
          translate <3.1,-.6,0>}
   cylinder{<0,0,0><0,0,-1>1,-7 scale <7/(RADI01*2),7/(RADI01*2),5/(RADI01*2)>}
   cylinder{<0,0,.5><0,0,-.5>1,STRE01*-1 scale <30/(RADI01*2),1/(RADI01*2),20/(RADI01*2)>
          rotate z*1.5 translate <0,-2.2,0>}
   cylinder{<0,0,0><0,0,-1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01> translate <12,0,-5.4>}
   sphere{0,1,STRE01 scale <18/(RADI01*2),11/(RADI01*2),7.5/(RADI01*2)> rotate y*10 translate <3,1.5,6>}
   sphere{0,1,STRE01 scale <12/(RADI01*2),3.95/(RADI01*2),2.5/(RADI01*2)> rotate y*3 translate<-2.4,4.745,3.4>}
   sphere{0,1,STRE01 scale <13/(RADI01*2),8/(RADI01*2),4/(RADI01*2)> rotate y*3 translate <1,1,3.4>}
   sturm
   }
   cylinder{<0,0,.2><0,0,-1>1 scale <4.7,4.7,8>}

   blob{ threshold DENS01
   sphere{0,1,STRE01 scale <15.7/(RADI01*2),21.2/(RADI01*2),8/(RADI01*2)>
          rotate z*-108
          rotate y*-3
          translate <3.1,-.6,0>}
      cylinder{<0,0,0><0,0,-1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01> translate <12,0,-5.4>}
      scale .95
      }
   box{<-15,-1.5,10><15,-10,-10>}
   cylinder{<-1,0,0><0,0,0>1 scale <5,5,2.5> rotate z*-30 translate<-5.5,4.75,3.4>}
   difference{
      box{<-4.5,0,-9><-10,-5,15>}
      cylinder {<-1,0,0,><0,0,0>1 scale <5,2,12> rotate z*5 translate <-4.3,0,9.3>}
      }
texture{BTEX03}
}

// FRONT FENDER (right):

#declare RADI01 = .65
#declare STRE01 = 3
#declare DENS01 = STRE01*pow((1-pow(RADI01,2)),2)

#declare BODY01r=
difference{
blob{ threshold DENS01
   sphere{0,1,STRE01 scale <15.7/(RADI01*2),21.2/(RADI01*2),8/(RADI01*2)>
          rotate z*-108
          rotate y*3
          translate <3.1,-.6,0>}
   cylinder{<0,0,0><0,0,1>1,-7 scale <7/(RADI01*2),7/(RADI01*2),5/(RADI01*2)>}
   cylinder{<0,0,.5><0,0,-.5>1,STRE01*-1 scale <30/(RADI01*2),1/(RADI01*2),20/(RADI01*2)>
          rotate z*1.5 translate <0,-2.2,0>}
   cylinder{<0,0,0><0,0,1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01> translate <12,0,5.4>}
   sphere{0,1,STRE01 scale <18/(RADI01*2),11/(RADI01*2),7.5/(RADI01*2)> rotate y*-10 translate <3,1.5,-6>}
   sphere{0,1,STRE01 scale <12/(RADI01*2),3.95/(RADI01*2),2.5/(RADI01*2)> rotate y*-3 translate<-2.4,4.745,-3.4>}
   sphere{0,1,STRE01 scale <13/(RADI01*2),8/(RADI01*2),4/(RADI01*2)> rotate y*-3 translate <1,1,-3.4>}
   sturm
   }
   cylinder{<0,0,-.2><0,0,1>1 scale <4.7,4.7,8>}

   blob{ threshold DENS01
   sphere{0,1,STRE01 scale <15.7/(RADI01*2),21.2/(RADI01*2),8/(RADI01*2)>
          rotate z*-108
          rotate y*3
          translate <3.1,-.6,0>}
      cylinder{<0,0,0><0,0,1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01> translate <12,0,5.4>}
      scale .95
      }
   box{<-15,-1.5,-10><15,-10,10>}
   cylinder{<-1,0,0><0,0,0>1 scale <5,5,2.5> rotate z*-30 translate<-5.5,4.75,-3.4>}
   difference{
      box{<-4.5,0,9><-10,-5,-15>}
      cylinder {<-1,0,0,><0,0,0>1 scale <5,2,12> rotate z*5 translate <-4.3,0,-9.3>}
      }
texture{BTEX03}
}

// REAR FENDER (left):

#declare BODY02l=
difference{
blob{ threshold DENS01
   cylinder{<0,0,0><0,0,2>,1,STRE01 scale <19.5/(RADI01*2),26.7/(RADI01*2),10/(RADI01*2)>
          rotate z*28
          translate <42.5,-3.6,.2>}
   cylinder{<0,0,0><0,0,-1>1,-7 scale <6.6/(RADI01*2),6.8/(RADI01*2),5/(RADI01*2)>
   translate <39.8,1.3,0>}
   cylinder{<0,0,0><0,0,-1>1,-7 scale <6.7/(RADI01*2),7/(RADI01*2),5/(RADI01*2)>
   translate <39.8,0,0>}
   cylinder{<0,0,.5><0,0,-.5>1,STRE01*-1 scale <30/(RADI01*2),1/(RADI01*2),30/(RADI01*2)>
   rotate z*3 translate <39.8,-1.5,0>}
   cylinder{<0,0,0><0,0,-1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01>
   translate <47,1.3,-5.7>}
   cylinder{<0,0,0><0,0,-1>1,-.7 scale <10/RADI01,20/RADI01,5/RADI01>
    rotate y*-5 translate <52,1.3,-5>}
   sturm
}
   cylinder{<0,0,.2><0,0,-1>1 scale <4.7,4.7,8> translate <39.8,1.3,0>}
   box{<1,0,0.2><-1,-1,-1> scale <4.7,4.7,8> translate <39.8,1.3,0>}
   box{<1,0,1><-1,-1,-.5> scale <20,20,30> rotate z*3 translate <39.8,-1.5,0>}
   box{<-20,20,0><20,-20,20> translate <39.8,1.3,10>}
   blob{ threshold DENS01
      sphere{0,1,STRE01 scale <19.5/(RADI01*2),26.7/(RADI01*2),10/(RADI01*2)>
      rotate z*28 scale <.95,.9,.9> translate <42.3,-3.6,.2>}
      cylinder{<0,0,0><0,0,-1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01>
      translate <47,1.3,-5.3>}
      cylinder{<0,0,0><0,0,-1>1,-.7 scale <10/RADI01,20/RADI01,5/RADI01>
      rotate y*-5 translate <52,1.3,-4.8>}
      }
   texture{BTEX04}
   }

// REAR FENDER (right):

#declare BODY02r=
difference{
blob{ threshold DENS01
   cylinder{<0,0,0><0,0,-2>,1,STRE01 scale <19.5/(RADI01*2),26.7/(RADI01*2),10/(RADI01*2)>
          rotate z*28
          translate <42.5,-3.6,-.2>}
   cylinder{<0,0,0><0,0,1>1,-7 scale <6.6/(RADI01*2),6.8/(RADI01*2),5/(RADI01*2)>
   translate <39.8,1.3,0>}
   cylinder{<0,0,0><0,0,1>1,-7 scale <6.7/(RADI01*2),7/(RADI01*2),5/(RADI01*2)>
   translate <39.8,0,0>}
   cylinder{<0,0,.5><0,0,-.5>1,STRE01*-1 scale <30/(RADI01*2),1/(RADI01*2),30/(RADI01*2)>
   rotate z*3 translate <39.8,-1.5,0>}
   cylinder{<0,0,0><0,0,1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01>
   translate <47,1.3,5.7>}
   cylinder{<0,0,0><0,0,1>1,-.7 scale <10/RADI01,20/RADI01,5/RADI01>
    rotate y*5 translate <52,1.3,5>}
   sturm
}
   cylinder{<0,0,-.2><0,0,1>1 scale <4.7,4.7,8> translate <39.8,1.3,0>}
   box{<1,0,-0.2><-1,-1,1> scale <4.7,4.7,8> translate <39.8,1.3,0>}
   box{<1,0,-1><-1,-1,.5> scale <20,20,30> rotate z*3 translate <39.8,-1.5,0>}
   box{<-20,20,0><20,-20,-20> translate <39.8,1.3,-10>}
   blob{ threshold DENS01
      sphere{0,1,STRE01 scale <19.5/(RADI01*2),26.7/(RADI01*2),10/(RADI01*2)>
      rotate z*28 scale <.95,.9,.9> translate <42.3,-3.6,-.2>}
      cylinder{<0,0,0><0,0,1>1,-2 scale <10/RADI01,10/RADI01,2/RADI01>
      translate <47,1.3,5.3>}
      cylinder{<0,0,0><0,0,1>1,-.7 scale <10/RADI01,20/RADI01,5/RADI01>
      rotate y*-5 translate <52,1.3,4.8>}
      }
   texture{BTEX04}
   }

// FRONT LAMP:

#declare RADI01 = .7
#declare STRE01 = 3
#declare DENS01 = STRE01*pow((1-pow(RADI01,2)),2)
#declare L001=
difference{
   blob{ threshold DENS01
      cylinder{<0,0,-.2><0,0,0>,1,STRE01 scale <2.1/RADI01,2.9/RADI01,.5>}
   }
   box {<-3,4,-1><0.2,-4,1>}
}
#declare L002=
difference{
   sphere{0,1 scale <1.9,2.7,1.1>}
   box {<-3,4,-2><0.2,-4,2>}
}
#declare L0011=
union{
   object {L001 translate x*-0.20000001}
   object {L001 rotate z*180 translate x*0.20000001}
    translate z*-.07
texture{WTEX}
}
#declare L0021=
union{
   object {L002 translate x*-0.20000001}
   object {L002 rotate z*180 translate x*0.20000001}
    translate z*-.15
texture{LTEX}
}
#declare L003=
union{
   object {L0011}
   object {L0021}
rotate y*90
}


// RUNNING BOARD (left):

#declare BODY03l=
union{
    cylinder{<0,.6,.6><26,.6,.6>.6}
    cylinder{<0,.2,.2><26,.2,.2>.2}
    box{<0,.6,0><26,.2,6>}
    box{<0,1.2,.4><26,.5,6>}
    box{<0,0,.2><26,.5,6>}
    scale <1,1,2>
    rotate z*.5
    translate <9,-1.45,-2.7>
texture{BTEX}
}

// RUNNING BOARD (right):

#declare BODY03r=
union{
    cylinder{<0,.6,-.6><26,.6,-.6>.6}
    cylinder{<0,.2,-.2><26,.2,-.2>.2}
    box{<0,.6,0><26,.2,-6>}
    box{<0,1.2,-.4><26,.5,-6>}
    box{<0,0,-.2><26,.5,-6>}
    scale <1,1,2>
    rotate z*.5
    translate <9,-1.45,2.7>
texture{BTEX}
}

#declare RADI01 = .7
#declare STRE01 = 3
#declare DENS01 = STRE01*pow((1-pow(RADI01,2)),2)

#declare BODY00=
difference{
   blob{ threshold DENS01
      sphere{0,1,STRE01 scale <50/RADI01,35/RADI01,12/RADI01> rotate z*3}
      sphere{0,1,-1 scale <100/RADI01,8.5/RADI01,50/RADI01> translate y*-18}
      sphere{0,1,-.8 scale <100/RADI01,7/RADI01,50/RADI01> rotate z*1 translate y*22}
      sphere{0,1,-1.5 scale <70/RADI01,5/RADI01,50/RADI01> rotate z*1 translate y*20}
      sphere{0,1,-.4 scale <100/RADI01,5/RADI01,70/RADI01> rotate z*2 translate y*18}

      sphere{0,1,-1 scale <30/RADI01,5/RADI01,50/RADI01> rotate z*-8 translate <17,19>}
      sphere{0,1,-.6 scale <5/RADI01,9/RADI01,10/RADI01> rotate z*10 translate <40,-10,0>}

      #declare BANG01=52
      #declare BANGNN=5
      #declare BANG00=BANG01/BANGNN
      #declare BANG0I=22
      #while (BANGNN>0)

      sphere{0,1,-.9
      scale <(7-(1/BANGNN))/RADI01,30/RADI01,50/RADI01>
      translate <21,0,0>
      rotate z*BANG0I
      scale <1,.8,1>
      translate <22,0,0>}
      #declare BANG0I=BANG0I+BANG00
      #declare BANGNN=BANGNN-1
      #end
      }
   box{<-60,-9,-40><60,-40,40>}
   box{<-60,20,-40><60,40,40>}
}

#declare BODY=
difference{
   union{
      difference{
         object {BODY00
            translate x*-44
            rotate y*.5
            translate x*44}
         box {<-60,50,0><60,-50,50>}

         box {<-60,-.1,-20><0,.1,20> rotate y*-25 rotate z*2 translate <-26,10.1,0>}
         box {<-.1,-.1,-20><.1,10,20> rotate z*-5 rotate y*-25 rotate z*2 translate <-26,10.1,0>}
         cylinder {<0,0,-20><0,0,20>.1 rotate y*-25 rotate z*2 translate <-26,10.1,0>}
         translate z*0.000000001
      }
      difference{
         object {BODY00
            translate x*-44
            rotate y*-.5
            translate x*44}
         box {<-60,50,0><60,-50,-50>}

         box {<-60,-.1,-20><0,.1,20> rotate y*25 rotate z*2 translate <-26,10.1,0>}
         box {<-.1,-.1,-20><.1,10,20> rotate z*-5 rotate y*25 rotate z*2 translate <-26,10.1,0>}
         cylinder {<0,0,-20><0,0,20>.1 rotate y*25 rotate z*2 translate <-26,10.1,0>}
         translate z*-0.000000001
      }
   }
   
#if (GRILL_FLAG = on) // normal grill

#declare GRRA01= 17.5
#declare GRST01= 40
#declare GRYY00= 14
#declare GRYY0N= 5
#declare GRYY0D= (GRYY00+GRYY0N)/GRST01
#declare GRYY0I=GRYY00
#declare GRXX0I=GRRA01*cos(asin(GRYY00/GRRA01))
union{
#while (GRST01>0)
       cylinder {<0,0,.2><0,0,10>,.1 translate <GRXX0I,GRYY0I,0>}
       cylinder {<10,0,.2><0,0,.2>,.1 translate <GRXX0I,GRYY0I,0>}
       box {<10,-.1,.2><0,.1,10> translate <GRXX0I,GRYY0I,0>}

       cylinder {<0,0,-.2><0,0,-10>,.1 translate <GRXX0I,GRYY0I,0>}
       cylinder {<10,0,-.2><0,0,-.2>,.1 translate <GRXX0I,GRYY0I,0>}
       box {<10,-.1,-.2><0,.1,-10> translate <GRXX0I,GRYY0I,0>}
       #declare GRYY0I=GRYY0I-GRYY0D
       #declare GRXX0I=GRRA01*cos(asin(GRYY0I/GRRA01))
       #declare GRST01=GRST01-1
#end
translate x*GRRA01*-1
rotate y*180
translate <-47.5,-5,0>
}

#end

#if (GRILL_FLAG = off) // "low resolution" grill

#declare GRRA01= 17.5
#declare GRST01= 12
#declare GRYY00= 14
#declare GRYY0N= 5
#declare GRYY0D= (GRYY00+GRYY0N)/GRST01
#declare GRYY0I=GRYY00
#declare GRXX0I=GRRA01*cos(asin(GRYY00/GRRA01))
union{
#while (GRST01>0)
       cylinder {<0,0,.2><0,0,10>,.35 translate <GRXX0I,GRYY0I,0>}
       cylinder {<10,0,.2><0,0,.2>,.35 translate <GRXX0I,GRYY0I,0>}
       box {<10,-.35,.2><0,.35,10> translate <GRXX0I,GRYY0I,0>}

       cylinder {<0,0,-.2><0,0,-10>,.35 translate <GRXX0I,GRYY0I,0>}
       cylinder {<10,0,-.2><0,0,-.2>,.35 translate <GRXX0I,GRYY0I,0>}
       box {<10,-.35,-.2><0,.35,-10> translate <GRXX0I,GRYY0I,0>}
       #declare GRYY0I=GRYY0I-GRYY0D
       #declare GRXX0I=GRRA01*cos(asin(GRYY0I/GRRA01))
       #declare GRST01=GRST01-1
#end
translate x*GRRA01*-1
rotate y*180
translate <-47.5,-5.3,0>
}

#end

box {<-.1,-20,-20><.1,20,0> rotate z*-3 rotate y*-5 translate <-20,0,0>}
box {<-.1,-20,-20><.1,20,0> rotate z*-1.5 rotate y*5 translate <3,0,0>}
box {<-.1,-20,20><.1,20,0> rotate z*-3 rotate y*5 translate <-20,0,0>}
box {<-.1,-20,20><.1,20,0> rotate z*-1.5 rotate y*-5 translate <3,0,0>}

intersection{
   sphere{0,1 scale <50,30,12>*.9 rotate z*3}
   union{
      box {<-20,-4,-20><3,20,20>}
      box {<-10,0,-20><0,20,20> rotate z*-15 translate x*3}
      }
 // texture{BTEX finish{ambient <1,.9,.05>*.35 reflection 0.1}}
 texture {STEX rotate y*90 rotate z*90}
 }
scale <1,.9,1.14>
}

#declare WSHI01=
intersection{
   difference{
      sphere{ 0,1 scale <6,10,9.5>  rotate z*-15}
      sphere{ 0,1 scale <6,10,9.5>-.15  rotate z*-15}
      box {<0,12,12><12,-12,-12> rotate z*-15}
      box {<-12,-5,12><12,-12,-12> rotate z*-15}
   }
merge{
   cylinder {<0,0,-6><0,0,6>1  scale <10,9,1>  translate <-5,0,0>}
   sphere{ 0,1 scale <10,9,3.5>  translate <-5,0,-6>}
   sphere{ 0,1 scale <10,9,3.5>  translate <-5,0,6>}
   }
translate <-19,10,0>
scale <1,.9,1.15>
scale 1.98 rotate z*1.5 translate <74,8,0>
texture {GTEX}
}

#declare SEAT01=
union{
   superellipsoid{<.7,.5>
      translate <1,1,0> scale <3.9,8.7,9.5>
      rotate z*-15 translate x*-2}
   superellipsoid{<.7,.5>
      scale<4,7,9.5>
      rotate z*80 translate <-4,0,0>}
scale <1,.9,1.15>
scale 1.98 rotate z*1.5 translate <74,8,0>
texture {STEX}
}

#declare STWH01=
union{
   torus{7,.5 texture {BTEX}}
   sphere {0,1 scale <2,.8,2> translate y*.5 texture {BTEX}}
   cone{<0,0,0>.7,<0,0,7>0.3 scale <1,.7,1> texture {WTEX}}
   cone{<0,0,0>.7,<0,0,7>0.3 scale <1,.7,1> rotate y*120 texture {WTEX}}
   cone{<0,0,0>.7,<0,0,7>0.3 scale <1,.7,1> rotate y*-120 texture {WTEX}}
   cylinder {<0,0.5,0><0,-12,0>2 texture {BTEX}}
 rotate <90,90 0>}

#declare BUMP01=
union{
   difference{
      blob{ threshold .7
         cylinder {<0,0,-.5><0,0,.5>1,4 scale <9,3,20>}
      }
      blob{ threshold .7
         cylinder {<0,0,-.5><0,0,.5>1,4 scale <9,3,20>*.9}
      }
      blob{ threshold .7
         cylinder {<0,0,-.5><0,0,.5>1,4 scale <7,10,20.5>}
      }
      box{<0,5,30><10,-5,-30>}
   }
   cylinder {<4,0,0><-5,0,0>.6 scale <1,1,.7> translate z*12}
   cylinder {<4,0,0><-5,0,0>.6 scale <1,1,.7> translate z*-12}
texture{WTEX}
}


// roadster / coupe selection 01
#if ( CONVERT_FLAG = off )

// threshold
#declare BLOB_DENS01 = .5

// strength
#declare BLOB_STRN01 = .75

// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / BLOB_STRN01 ) )

#declare R_part01=
blob{ threshold BLOB_DENS01

   #declare BLOB_STRN01 = .8
   #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / BLOB_STRN01 ) )

   cylinder{<0,0,-1><0,0,1>,1,BLOB_STRN01
      scale <2/BLOB_A_R01,.7/BLOB_A_R01,.7>
      rotate z*-2
   }
   sphere {0,1,BLOB_STRN01
      scale <2/BLOB_A_R01,1/BLOB_A_R01,.7/BLOB_A_R01>
      rotate z*-2
   }
   sphere {0,1,BLOB_STRN01
      scale <2/BLOB_A_R01,1/BLOB_A_R01,1/BLOB_A_R01>*2
      translate y*-2
   }

   #declare BLOB_STRN01 = -5
   #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / abs ( BLOB_STRN01 ) ) )

   cylinder{<0,0,-1><0,0,1>,1,BLOB_STRN01
      scale <1.9/BLOB_A_R01,.9/BLOB_A_R01,1>
      rotate z*-5
      translate <-.68,-.5,0>
   }
 }

#declare ROOF01=
union{
   difference{
      object{R_part01}
      object{R_part01 scale .95}
      box{<-10,-10,-10><10,-.2,10>}
      cylinder{<0,0,-1><0,0,1>,1
         scale <1.9,.95,1>*1.2
         rotate z*-5
         translate <-.68,-.8,0>
      }
      superellipsoid { < 0.2, 0.3 > scale <1,1.2,1> translate <-3,-.8,0>}
      superellipsoid { < 0.01, 0.7 > scale <1.5,.3,.8> rotate z*15 translate <3,.4,0>}
      scale <12,12,18>
      translate <-3.2,26.4,0>
      texture {BTEX02}
   }
   intersection{
      difference{
         object{R_part01}
         object{R_part01 scale .95}
         cylinder{<0,0,-1><0,0,1>,1
            scale <1.9,.9,1>*1.2
            rotate z*-5
            translate <-.68,-.8,0>
         }
      }
      superellipsoid { < 0.01, 0.7 > scale <1.5,.3,.8> rotate z*15 translate <3,.4,0>}
      scale <12,12,18>
      translate <-3.2,26.4,0>
      texture {GTEX}
   }
}
#end

#declare CAR01=
union{
   //wheels
   object {TY01 translate <0,0,-29>}
   object {TY02 translate <0,0,-29>}
   object {TY011 translate <120.5,1,-29>}
   object {TY02 translate <120.5,1,-29>}

   object {TY01 rotate y*180 translate <0,0,29>}
   object {TY02 rotate y*180 translate <0,0,29>}
   object {TY011 rotate y*180 translate <120.5,1,29>}
   object {TY02 rotate y*180 translate <120.5,1,29>}

   // front fenders
   object {BODY01l scale 3 translate <-.5,-4.5,-29>}
   object {BODY01r scale 3 translate <-.5,-4.5,29>}

   // rear fenders
   object {BODY02l scale 3 translate <1,-4.5,-29>}
   object {BODY02r scale 3 translate <1,-4.5,29>}

   // front lamps
   object {L003 scale <.71,0.71,0.71> rotate x*-2 rotate z*-29.5 translate<-5.5,4.75,3.4>
      scale 3 translate <-.5,-4.5,-28.95>}
   object {L003 scale <.71,0.71,0.71> rotate x*2 rotate z*-29.5 translate<-5.5,4.75,-3.4>
      scale 3 translate <-.5,-4.5,28.95>}

   // running boards
   object {BODY03l scale 3 translate <-.5,-4.5,-29>}
   object {BODY03r scale 3 translate <-.5,-4.5,29>}

   // body
   object {BODY scale 1.98 rotate z*1.5 translate <74.2,8,0> texture{BTEX01}}

   // windshield
   object {WSHI01}

   // seats
   object {SEAT01 translate x*-1}

   // steering wheel
   object {STWH01 scale 1.1 rotate z*20 translate <46,28,-9>}

   // front bumper
   object {BUMP01 scale 1.45 rotate z*1.5 translate <-17,-6.5,0>}

   // roadster / coupe selection 02
   #if ( CONVERT_FLAG = off )
      object {ROOF01 translate <74,8,0>}
   #end
}
