
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: 1:25 scale model kit "CADILLAC'59" V8 engine
// Date: 01.12.97
// Auth: N.B.(c)1997

// units are mm

/*
background {color rgb 0.9}

camera {
   location <-100,70,-150>

   //location <0,0,-200>
   look_at <0,0,0>
   angle 30
   }

light_source { <2000, 2000, -5000> rgb 1 }

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"
#include "golds.inc"
*/

// default texture:
#declare DEF_TEX=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 10
   }
   pigment{
      color rgb .8
   }
}

// wooden texture:
#declare M_FLOOR_WOOD =
color_map {
    [0.00 color rgb <1.0, 0.60, 0.35>*.98]
    [0.40 color rgb <1.0, 0.7, 0.45> ]
    [0.60 color rgb <1.0, 0.7, 0.45> ]
    [1.00 color rgb <1.0, 0.60, 0.35>*.98]
}

#declare P_FLOOR_WOOD =
pigment {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.07
    omega 0.7
    lambda 2.5
    color_map { M_Wood19A }
    rotate x*4
}

#declare T_Wood19 =
    texture {pigment{ P_FLOOR_WOOD color_map {M_FLOOR_WOOD}}}

#declare FLOOR_TEX=
texture{T_Wood19 rotate <5,-5,0>
   finish{
      diffuse .9
      ambient <1.0, 0.7, 0.45>*.2
      //reflection .05
      phong .2
      phong_size 10
      }
  normal {wrinkles .1  scale <1,1,3>*2}
}


// paint:
#declare MTEX01 =
   texture{
      finish {
         ambient .2
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.1
      }
      normal {bumps 0.05 scale .5}
}
#declare MTEX02 =
   texture{
      finish {
         ambient .2
         diffuse 0.9
         phong 0.2
         phong_size 5
      }
}

#declare MTEX_G_BLUE = texture { MTEX01 pigment{color rgb <0,0,.5>}}
#declare MTEX_G_BLACK = texture { MTEX01 finish{ambient .1} pigment{color rgb 0.15}}
#declare MTEX_M_BLACK = texture { MTEX02 finish{ambient .1} pigment{color rgb 0.2}}

//paper:
#declare PAP_TEX=
texture{
   finish{
      diffuse .9
      brilliance .8
      ambient .2
      phong .5
      phong_size 10
   }
   pigment{
      color rgb 1
   }
}


// engine part01 (trans.):
#declare MTR_PRT01=
union{
   cylinder{ <0,0,0> <0,2,0> 2.5 }
   cone{ <0,2,0> 2.5 <0,7,0> 5 }
   cone{ <0,7,0> 5 <0,9,0> 4.5 }
   cylinder{ <0,9,0> <0,10,0> 3.5 }
   cylinder{ <0,10,0> <0,20.5,0> 4 }
   superellipsoid { <1,.3>
      scale <4.5,4.5,2>
      rotate x*90
      translate y*13.5
   }
   torus { 4, 0.5 translate y*18.5}
   cone{ <0,20.5,0> 4 <0,26,0> 7.5 }
   cylinder{ <0,26,0> <0,27.5,0> 7.5 }
   intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-2.5> <10,31,2.5> }
   }
  intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-3.5> <-10,31,3.5> }
   }
   intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-.5> <-10,28,.5> }
      rotate y*-90
   }
   intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-.5> <-10,28,.5> }
      rotate y*90
   }
   cylinder{ <0,27.5,0> <0,28.5,0> 8.5 }
   torus { 5, 0.5 translate y*21.5}
   intersection{
      superellipsoid { <.2,.2>}
      box{<0,-1.5,-1.5><-1.5,1.5,1.5>}
      scale <2,5.3,6.3> translate <-4.5,15,0>
   }
   superellipsoid { <.1,.2> scale <.5,6,7> translate <-4.5,15,0> }
   difference{
      intersection{
         superellipsoid { <1.8,.1> }
         box{<0,-1.5,-1.5><.5,1.5,1.5>}
         rotate x*90
         scale <10,5.3,6.3>
      }
      cylinder{ <0,0,4><0,0,10>1 scale <4,1.5,1> translate x*5}
      translate <-4.5,15,0>
   }
   superellipsoid { <.2,.2>
      translate z*-1
      scale < 1.5,3.5,3 >
      translate <-3,15,0>
      }
   superellipsoid { <1,.3>
      translate y*-1
      scale <2,2,1.5>
      rotate x*90
      translate <0,6,6>
   }
   superellipsoid { <1,.3>
      translate y*-1
      scale <3.5,3.5,.75>
      rotate x*90
      translate <0,7.5,6>
   }
   intersection{
      sphere{ 0, 2.5 }
      box{<-3,-3,-3><3,0,3>}
      translate <-2.5,27,7>
   }
   cylinder{<0,0,0><0,1,0> 2.5 translate <-2.5,27,7>}
   cylinder{<0,1,0><0,1.5,0> 3 translate <-2.5,27,7>}
   prism {
     linear_sweep
     .5,-.5,
     4,
     <0,0>, <1,0>, <0,-1>, <0,0>
     scale <3,1,5>
     rotate x*-90
     rotate y*-90
     translate <0,5.5,3>
   }
}


// engine part02 (cyl.):
#declare MTR_PRT02=
union{
   difference{
      cylinder{ <0,0,0> <0,22.5,0> 4 scale<1.5,1,1>translate x*-3}
      box{ <2,0,-5><10,22,5>}
   }

// cylinder block, valve cover
   #declare CYL01=
   union{
      box{<0,0,3> <-12,22,-3>}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*4}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*5}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*9}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*10}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*14}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*15}
      box{<0,-.5,3.3> <-9,.5,-3.3> translate y*21.5}

      superellipsoid{ <.1, .05 > scale <.3,11.3,3.3 > translate <-12,11,0>}
      difference{
         union{
            superellipsoid{ <.2, .2 > scale <3,10.5,3 >}
            superellipsoid{ <.2, .2 > scale <3.3,10.8,.2 > translate z*-1 }
            superellipsoid{ <.2, .2 > scale <3.3,10.8,.2 > translate z*1 }
            box{<-.15,-.75,-.5><.2,.75,.5> translate <-3,9.2,0>}
            box{<-.15,-.75,-.5><.2,.75,.5> translate <-3,-9.2,0>}

         }
         cylinder{<-4,0,0><4,0,0>.6 translate <0,-4,3>}
         cylinder{<-4,0,0><4,0,0>.6 translate <0,4,3>}
         cylinder{<-4,0,0><4,0,0>.6 translate <0,-4,-3>}
         cylinder{<-4,0,0><4,0,0>.6 translate <0,4,-3>}
         translate <-12,11,0>
      }
   }
   object{CYL01 rotate y*-45 translate z*-.5}
   object{CYL01 rotate y*45 translate z*.5}

   text { ttf "arial.ttf" "CADILLAC" .5, 0
      translate <-2.5,-.3,-.3>
      scale <1.5,1.2,1>
      rotate z*90
      rotate y*90
      translate x*-3
      translate <-12,11,0>
      rotate y*-45 translate z*-.5
   }
   text { ttf "arial.ttf" "CADILLAC" .5, 0
      translate <-2.5,-.3,-.3>
      rotate z*180
      scale <1.5,1.2,1>
      rotate z*90
      rotate y*90
      translate x*-3
      translate <-12,11,0>
      rotate y*45 translate z*.5
   }


   box{<-9,0,5> <2,22,-5>}
   box{<-1,-.7,5.3> <1,.7,-5.3> translate y*4.5}
   box{<-1,-.7,5.3> <1,.7,-5.3> translate y*9.5}
   box{<-1,-.7,5.3> <1,.7,-5.3> translate y*14.5}
   box{<-1,-.5,5.3> <1,.5,-5.3> translate y*21.5}
   superellipsoid{ <.1, .05 > scale <.3,11.2,5.3 > translate <2,11,0>}
   intersection{
      superellipsoid{ <.2, .2 >}
      box{<0,-1.5,-1.5> <1.5,1.5,1.5> }
      scale <6,5,4.5 > translate <2,5,0>
   }
   intersection{
      superellipsoid{ < .23, .23 >}
      box{<0,-1.5,-1.5> <1.5,0,1.5> }
      translate <-1,1,0>
      scale <5,5,4.5 >
      rotate z*45
      translate <8.45,9,0>
   }
   intersection{
      superellipsoid{ < 1.8, .2 > translate x*.1}
      box{<0,-1.5,-1.5> <1.5,1.5,1.5> }
      scale <3.5,11,4.5 >
      translate <2,11,0>
   }

// water pump:
   union{
      intersection{
         torus{3,.75 rotate z*90}
         box{<-5,0,0><5,5,5>}
         translate <0,0,4.5>
      }
      intersection{
         torus{3,.75 rotate z*90}
         box{<-5,0,0><5,5,-5>}
         translate <0,0,-4.5>
      }
      cylinder{<0,3,-4.5><0,3,4.5>.75}
      superellipsoid{<0.2,0.2> scale <2,1.5,1.5> translate y*3}
      superellipsoid{<1,.2> rotate y*90 translate <-2,3,0>}
      cylinder{<0,0,0><0,4,0>3 translate x*3}
      translate <-8.5,22,0>
   }

   #declare CARB01=
   union{
      superellipsoid{ <.5, .5 >
         scale <1.3,2,.4 >
         translate <-11,11,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,.4 >
         translate <-11,7,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,.4 >
         translate <-11,15,0>
      }
   }

   // carb. manifold:
   object{CARB01 translate z*-3 rotate y*45 }
   object{CARB01 translate z*3 rotate y*-45 }
   intersection{
      union{
         torus {11.5,.5 scale <1,2,1>}
         torus {11.5,.5 scale <1,2,1> translate y*3}
         torus {11.5,.5 scale <1,2,1> translate y*5}
         torus {11.5,.5 scale <1,2,1> translate y*-3}
         torus {11.5,.5 scale <1,2,1> translate y*-5}
         box{<-11,-5,-3><-12,5,3>}
      }
      box{<-20,-10,-10><0,10,10>}
      translate y*11
   }

   // carb.
   union{
      superellipsoid{ <.2,.1> translate x*-1 scale <.3,.7,1.2>*2.6 translate y*17}
      superellipsoid{ <1,.1> translate x*-1 rotate y*90 scale 1 translate <0,19.5,-4.5>}
      cylinder{<0,0,0><-3,0,0>2 translate y*16}
      superellipsoid{ <.2,.1> translate x*-1 scale <.3,.7,1.2>*2.6 translate y*12}
      superellipsoid{ <1,.1> translate x*-1 rotate y*90 scale 1 translate <0,9,3>}
      cylinder{<0,0,0><-3,0,0>2 translate y*11}
      superellipsoid{ <.2,.1> translate x*-1 scale <.3,.7,1.2>*2.6 translate y*7}
      superellipsoid{ <1,.1> translate x*-1 scale 1 translate <0,11,-3>}
      cylinder{<0,0,0><-3,0,0>2 translate y*6}
   translate x*-12
   texture{T_Chrome_4D}
   }

// ignition coil
   union{
      cone{<0,0,0>1.5<0,0.5,0>0}
      cylinder{<0,0,0><0,-6,0>1.5}
      cylinder{<0,-1,0><0,-2,0>2}
      cylinder{<0,-5.5,0><0,-6,0>2}
      cylinder{<0,-6,0><0,-7,0>.5}
   translate <-12,8,-5>
   texture { MTEX_G_BLACK }
   }

//"cylinder head":
   #declare CYL02=
   union{
      superellipsoid{ <.5, .5 >
         scale <1.3,2,2 >
         translate <-11,11,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,2 >
         translate <-11,2,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,2 >
         translate <-11,20,0>
      }
      cylinder{ <0,-10,0> <0,10,0>1
         translate <-11,11,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,14.5,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,16.5,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,7.5,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,5.5,0>
      }
   }
   object{CYL02 translate z*-3 rotate y*-45 }
   object{CYL02 translate z*3 rotate y*45 }

   //right exhaust manifold
   union{
      sphere{ <-11,20,-4>1.2}
      cylinder{ <-11,20,-4><-11,20,0>1.2}
      sphere{ <-11,11,-4>1.2}
      cylinder{ <-11,11,-4><-11,11,0>1.2}
      sphere{ <-11,2,-4>1.2}
      cylinder{ <-11,2,-4><-11,2,0>1.2}
      intersection{
         union{
            torus{ 11,1.2 rotate x*90
               translate <0,20,-4>
            }
            torus{ 11,1.2 rotate x*90
               translate <0,2,-4>
            }
            cylinder{<-11,11,-4><-6,11,-4>1.2}
         }
         box{<-20,20,-10><-6,2,10>}
      }
      translate z*-2
      rotate y*-45

      texture{T_Chrome_4D}
   }

   //left exhaust manifold
   union{
      sphere{ <-11,20,4>1.2}
      cylinder{ <-11,20,4><-11,20,0>1.2}
      sphere{ <-11,11,4>1.2}
      cylinder{ <-11,11,4><-11,11,0>1.2}
      sphere{ <-11,2,4>1.2}
      cylinder{ <-11,2,4><-11,2,0>1.2}
      intersection{
         union{
            torus{ 16,1.2 rotate x*90
               translate <5,20,4>
            }
            cylinder{<-11,11,4><-8,11,4>1.2}
         }
         box{<-20,20,-10><-8,2,10>}
      }
      intersection{
         torus{ 3,1.2 rotate x*90
            translate <-8,2,4>
         }
         box{<-20,20,-10><-5,2,10>}
      }
      intersection{
         torus{ 15,1.2 rotate x*90
            translate <7,11,4>
         }
         box{<-20,11,-10><-5,2,10>}
      }
      sphere{<-8,11,4>1.2}
      sphere{ <-11,2,4>1.2}
      translate z*2
      rotate y*45

      texture{T_Chrome_4D}
   }
}

//engine part03 (starter):
#declare MTR_PRT03=
union{
   cylinder{<0,0,0><0,8,0>2}
   cylinder{<0,1.5,0><0,6.5,0>2.5}
   cylinder{<0,8,0><0,9,0>.5}
   cylinder{<3.5,.5,0><3.5,6.5,0>1}
   cylinder{<3.5,.5,0><3.5,1.5,0>1.5}
   cylinder{<3.5,5.5,0><3.5,6.5,0>1.5}
   translate <-2.5,0,7>
}

// engine part04 (belts, etc.):
#declare MTR_PRT04=
union{
   difference{
      union{
         cylinder{<0,0,0><0,7,0>2}
         cylinder{<0,4,0><0,7,0>3 texture { MTEX_M_BLACK }}
      }
      cylinder{<0,5,0><0,8,0>2  texture { MTEX_G_BLUE }}
      cylinder{<0,-1,0><0,8,0>1 texture { MTEX_G_BLUE }}
      translate x*-2
   }
   cylinder{<-9,4,0><-9,7,0>3 texture { MTEX_M_BLACK }}
   box{<-9,5,-3><-2,6,-2> texture { MTEX_M_BLACK }}
   box{<-9,6,3><-2,7,2> texture { MTEX_M_BLACK }}

//generator
   cylinder{<-14,4,-16><-14,5,-16>1.5  texture { MTEX_M_BLACK }}
   cylinder{<-14,3.5,-16><-14,4,-16>2.5}
   cylinder{<-14,3,-16><-14,3.5,-16>3}
   prism {
     linear_sweep
     0.5,0,
     9,
     <-2.5,1>, <-.5,3.5>, <.5,3.5>, <2.5,1>,
     <2.5,-1>, <.5,-3.5>, <-.5,-3.5>, <-2.5,-1>,<-2.5,1>
     rotate y*-90
     translate <-14,3,-16>
   }
   cylinder{<-17.5,3,-16><-17.5,3.5,-16>.5}
   cylinder{<-10.5,3,-16><-10.5,3.5,-16>.5}

   cylinder{<-14,3,-16><-14,-2,-16>2.5 }
   cylinder{<-14,-2,-16><-14,-4,-16>2}
   cylinder{<-14,-4,-16><-14,-3.5,-16>.25}
   cylinder{<-14,5,-16><-14,5.5,-16>.25}

   box{<-20,4,-3><0,5,-2> rotate y*-48 translate x*-2 texture { MTEX_M_BLACK }}
   box{<-17,4,3><0,5,2> rotate y*-78 translate x*-9 texture { MTEX_M_BLACK }}

// ac unit:
   cylinder{<-18,6,-13><-18,7,-13>2.5  texture { MTEX_M_BLACK }}
   difference{
      cylinder{<-18,7,-13><-18,7.5,-13>2}
      cylinder{<-18,6,-13><-18,8,-13>1}
   }
   cylinder{<-18,7,-13><-18,7.5,-13>.4}
   cylinder{<-18,0,-13><-18,6,-13>2}
   cylinder{<-18,-1,-13><-18,0,-13>1.5}
   torus{2,.25 translate <-18,1.5,-13>}
   cylinder{<-19,-2,-13><-19,-1,-13>.5}
   cylinder{<-17,-2,-13><-17,-1,-13>.5}

   box{<-20.4,6,-3><0,7,-2> rotate y*-37.5 translate x*-2  texture { MTEX_M_BLACK }}
   box{<-16,6,3><0,7,2> rotate y*-57.5 translate x*-9  texture { MTEX_M_BLACK }}

   cylinder{<-16,5,14><-16,6,14>3  texture { MTEX_M_BLACK }}
   cylinder{<-16,6,14><-16,7,14>.4 texture { MTEX_G_BLUE }}
   cylinder{<-16,5,14><-16,3,14>2}
   sphere{0,2.75 scale <1,0.2,1> translate<-16,5.8,14> texture { MTEX_G_BLUE }}
   torus{2.75,.25 translate<-16,6,14> texture { MTEX_G_BLUE }}

   box{<19.5,5,-3><0,6,-2> rotate y*-135 translate x*-2 texture { MTEX_M_BLACK }}
   box{<16,5,3><0,6,2> rotate y*-116.3 translate x*-9 texture { MTEX_M_BLACK }}

// oil filter mount:
   difference{
      prism {
        linear_sweep
        0.5,0,
        6,
        <0,-4>, <-8,-4>, <-8,-2.4>, <0,2>, <2,0>, <0,-4>
      }
      prism {
        linear_sweep
        1,0.25,
        6,
        <0,-5>, <-7.6,-5>, <-7.6,-2.4>, <0,1.5>, <2,0>, <0,-5>
      }
      rotate y*-90
      translate <-16,3,14>
      texture { MTEX_G_BLUE }
   }

   cylinder { <0,0,-.5><-7,0,-.5>.5 rotate y*-115 translate <-16,3.25,14> texture { MTEX_G_BLUE }}
   sphere { <-7,0,-.5>.5 rotate y*-115 translate <-16,3.25,14> texture { MTEX_G_BLUE }}

   cylinder{<-16,3,14><-16,-1,14>2}
   cylinder{<-16,3,16><-16,-1,16>.5}
   cylinder{<-16,3,12><-16,-1,12>.5  texture { T_Chrome_4D }}

//air comp.
   #declare COMP01=
   intersection{
      union{
         cylinder{<0,0,0><-4.5,0,0>1.5}
         sphere{0, 2 scale <.3,1,1.5> translate <-4.5,0,0>}
         cylinder{<-4.2,0,0><-4.5,0,0>2 scale <1,1,1.5>}
         cylinder{<-3.6,0,0><-3.9,0,0>2 scale <1,1,1.5>}
         cylinder{<-3,0,0><-3.3,0,0>2 scale <1,1,1.5>}
         cylinder{<-2.4,0,0><-2.7,0,0>2 scale <1,1,1.5>}
      }
      box{<-6,-3,-2.2><1,3,1.5>}
      texture { T_Chrome_4D }
   }

   object { COMP01 rotate y*45 translate <-16,1,14> }
   object { COMP01 rotate x*180 rotate y*-45 translate <-16,1,14> }

// power steering pump
   cylinder{<-16,-1,14><-16,-5,14>2}
   cylinder{<-16,-3,14><-20,-3,14>.5}
   cylinder{<-20,-3,14><-20.3,-3,14>1}

// oil filter:
   union{
      cylinder {<-6,0,0><0,0,0>3}
      cylinder {<-4,0,0><0,0,0>3.2}
      sphere{ 0, 3.5 scale <.2,1,1> translate x*-6 texture { MTEX_G_BLACK }}
      cylinder {<-6,0,0><-7,0,0>.4 texture { MTEX_G_BLACK }}
      cylinder {<-5,0,0><-5,0,4>.4}
      box{<-.5,0,-3.2><0,3.2,2.5>}
      translate <-13.5,0.3,4>
      texture { MTEX_G_BLUE }
   }
}

// fan:
#declare FAN=
union{
   cylinder{<0,-.3,0><0,.3,0> 2.5 }
   cylinder{<0,-3,0><0,0,0> 1.5 }
   sphere { <1.25,.3,0> .3}
   sphere { <-1.25,.3,0> .3}
   sphere { <0,.3,1.25> .3}
   sphere { <0,.3,-1.25> .3}
   #declare FAN_NUM=6
   #declare FAN_ANG=360/(FAN_NUM+1)
   #while (FAN_NUM >=0)
      union{
         difference{
            superellipsoid {<0.2,0.5> scale<3,.2,1.6> }
            superellipsoid {<0.2,0.5> translate <0,0,1.6> scale<3.2,2,1.6>}
            translate x*3
         }

         sphere { <.7,.2,.6> .3}
         sphere { <.7,.2,-.6> .3}
         sphere { <1.8,.2,0> .3}
         sphere { <3,.2,0> .3}
         box{<-2,-.15,-.7><2,.15,.7>}

         rotate x*2
         rotate z*-1
         translate x*3
         rotate y*(FAN_NUM*FAN_ANG)
      }
      #declare FAN_NUM=FAN_NUM-1
   #end
   scale .9
}

//air cleaner:
#declare FILT02=
union{
   torus{ 10, .3 translate y*2.5}
   torus{ 7.5, .3 translate y*5.7 texture { T_Gold_4C }}
   cylinder{<0,0,0><0,.8,0>.2 translate y*6.1}
   cylinder{<-.5,0,0><-.5,.6,0>.1 translate y*6.1}
   cylinder{<.5,0,0><.5,.6,0>.1 translate y*6.1}
   #declare FILT01=
   difference{
      union{
         superellipsoid{ <.8,.1>
            rotate y*90
            translate x*-1
            scale <2,1,2>
         }
         superellipsoid{ <.8,.5>
            rotate y*90
            scale <.4,1.2,2.4>
            translate x*-4
         }
      }
      superellipsoid{ <.8,.1>
            rotate y*90
            translate x*-1
            scale <3,1,2>*.8
      }
      translate <-9.2,3.9,0>
   }
   object{FILT01 rotate y*60}
   object{FILT01 rotate y*-60}
   difference{
      lathe {
         linear_spline
         12,
         <9, 0>, <10, 2.5>, <9.5, 5.3>, <8.5, 5.3>, <8.5, 5.7>,
         <6.5, 5.7>, <6.5, 5.3>, <6.3, 5.3>, <6.3, 5.9>, <.8, 5.9>,
         <.8, 6.1>, <0, 6.1>
      }
      cylinder {<-12,0,0><12,0,0>10 rotate y*15 scale <1,.2,.85>}
   }
    texture { MTEX_G_BLACK }
}


#declare C_59V801=
union{
   object{MTR_PRT01 translate y*-28.5 texture { MTEX_G_BLUE }}
   object{MTR_PRT02 translate x*-2 rotate y*180 texture { MTEX_G_BLUE }}
   object{MTR_PRT03 texture { MTEX_G_BLACK }}
   object{MTR_PRT04 translate y*22.5 rotate y*180 texture { MTEX_G_BLACK }}
   object{FAN translate <-9,(22.5+9),0> rotate y*180 texture { MTEX_G_BLACK }}
   object{FILT02 rotate y*24 translate <-19,-(28.5+30),4> rotate y*(-81+180)}

   cylinder{<0,0,0><0,-30,0>,.5 translate y*-(28.5) texture { T_Chrome_4D }}
   superellipsoid{<0.03,0.03> translate y*-1 scale <30,20,35/2>
      texture { FLOOR_TEX scale 120 rotate y*98 translate <50,30,-10>}
      translate y*-(30+28.5)
      rotate y*-81
   }
}

#declare MANUAL01=
superellipsoid{<0.5,0.05>
   translate y*1
   texture {PAP_TEX
   pigment{
      image_map{ gif "man021a.gif" }
      translate <-.5,-.5,0>
      rotate x*90
      rotate y*180
      scale 2
      }
   }
   scale <185/2,3,145/2>
}

/*
object{C_59V801
   rotate y*-208
   translate <-50,(20+30+28.5),-187>
}

object{MANUAL01
   rotate y*-34
   translate <96,0,-178>
}

object{C_59V801
   rotate y*145
   rotate x*-40
}

camera{
   location<-100,300,-450>
   angle 45
   right 4/3*x
   look_at <0,0,0>
}

light_source {<-500,500,-500>
//light_source {<500,500,-500>
color rgb <1,1,1>}

// table

box{<-750,0,-300><750,-25,700>
finish{ambient .3 diffuse 0.8 /* reflection 0.15 */ phong 0.1 phong_size 10}
//normal{ bumps .1 scale .5}

pigment{ color rgb <.9,.9,.9>}} */
