
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.02
// Desc: IRTC (The Internet Raytracing Competition) "Childhood" Nov-Dec 1997
// Date: 30.12.1997
// Auth: (c) N.B.( beliaev@utu.fi ) 1997


// -------------------------------------------------------------------------------
// THIS FILE IS INCLUDED HERE ONLY BECAUSE I WANTED TO SHARE MY MODEL WITH OTHERS.
// I ASK THE JUDGES NOT TO USE IT FOR THE PURPOSE OF EVALUATION OF MY IMAGE.
// THANKS.
//
// SOME OF THE IMAGE_MAPS ARE MISSING TO AVOID POSSIBLE COPYRIGHT CONFLICTS.
// -------------------------------------------------------------------------------


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metals.inc"
#include "woods.inc"

background {color rgb <0,0,0>}
sky_sphere {
   pigment {
      gradient y
      color_map {
        [0.0 color rgb 0 ]
        [1.0 color rgb <0.4,0.4,0.5>*.7 ]
      }
      scale 2
      translate -1
    }
}

// table wood texture

#declare MBEECHA =
color_map {
    [0.00 color rgb <1,1/1.45,1/2.7>]
    [0.4 color rgb <1,1/1.3,1/1.7> ]
    [0.6 color rgb <1,1/1.3,1/1.7> ]
    [1.00 color rgb <1,1/1.45,1/2.7>]
}
#declare MBEECHB =
color_map {
    [0.00 0.50 color rgbt <.9,.9/2,.9/4,.6>*.95
               color rgbt <1,1/1.3,1/1.7,.7> ]
    [0.50 1.00 color Clear color Clear]
}

#declare P_BEECH_GRAINA =
pigment {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.075
    omega 0.45
    lambda 2.3
    color_map { MBEECHA }
    rotate x*4
}
#declare P_BEECH_GRAINB =
pigment {
    bozo
    color_map { MBEECHB }
    scale <0.005, 0.005, 0.9>*.7
}

#declare TBEECH =
    texture {
       finish{
          diffuse .7
          ambient <1,.8,.6>*.2
          phong .5
          phong_size 100
          reflection .05}
       pigment{ P_BEECH_GRAINA color_map { MBEECHA }}}
    texture {
       finish{
          diffuse .7
          ambient <1,.85,.7>*.2
          phong .5
          phong_size 100
          reflection .05}
       // normal{bozo 0.5 scale <0.013, 0.013, 0.75>}
       pigment{ P_BEECH_GRAINB color_map { MBEECHB }}}

// BLUE_RED CAR:

// tyres texture
#declare TTEX =
   texture{
      finish{
         ambient <0.9,0.85,.8>*.2
         diffuse .95
         phong .05
         phong_size 3
      }
      pigment{color rgb <0.9,0.85,.8>*.2}
   }

// chrome parts:
#declare WTEX = texture{T_Chrome_4D}

// paint texture
#declare BTEX0 =
   texture{
      finish {
         ambient .2
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.2
      }
      normal {bumps 0.05 scale 20}
   }

#declare BTEX = texture { BTEX0 pigment{color rgb <0,0,.5>}}

// body texture
// #declare BTEX01 = texture { BTEX }
// roof texture
#declare BTEX02 = texture { BTEX0 pigment{color rgb <0,0,.5>}}
// front fenders texture
#declare BTEX03 = texture { BTEX0
   pigment {
   gradient x
      color_map{
         [ 0 color rgb <1,0.4,0>]
         [ 0.5 color rgb <1,0,0>]
         [ 1 color rgb <1,0,0>]
      }
      scale 60
      translate x*-15
   }
}
// rear fenders texture
#declare BTEX04 = texture { BTEX0 pigment{color rgb <0,0,.5>}}

// upholstery texture
#declare STEX =
   texture{
      finish {
         ambient .4
         diffuse 0.7
         specular 0.80
         roughness 1/80
      }
      normal {wood .1  scale <2,100,1>*.8 rotate y*90}
      pigment{color rgb <1,0,0>}
   }

// windshield glass texture
#declare GTEX =
texture{
   finish{
      ambient <0,0,.5>*0.1
      diffuse 0.1
      reflection 0.3
      refraction 1
      ior 1.45
      specular 0.8
      roughness 0.003
   }
   pigment{color rgbft <0,0,.5,.9,.5>}
}

// front lamps texture
#declare LTEX =
   texture{T_Chrome_4D
      normal {wood .3  scale <15,.15,.15> rotate x*-30}
   }


#declare BTEX01 =
//texture { pigment { color rgb <0,0,.5> } }
texture { pigment {
   gradient x
      color_map{
         [ 0 color rgb <1,0.4,0>]
         [ 0.5 color rgb <1,0,0>]
         [ 1 color rgb <1,0,0>]
      }
      scale 100
      translate x*-45
   }
}
texture { BTEX0
   pigment {
      image_map {
         gif "zzzz3.gif"
         map_type 2
         transmit 35 1
         once
      }
      scale 200
      rotate z*-90
      translate x*-45
   }
}

#declare CONVERT_FLAG = off
#declare DEFAULTS_FLAG = off
#declare GRILL_FLAG = off
#include "f_37_01.inc"
object {CAR01 rotate y*-135 translate <-110,13,300>}

// TABLE

box{<-750,0,-300><750,-25,700>
//finish{ambient .3 diffuse 0.8 /* reflection 0.15 */ phong 0.1 phong_size 10}
//normal{ bumps .1 scale .5}
//pigment{ color rgb <.9,.9,.9>}
texture {TBEECH scale 100 rotate <2,98,0>}
}


// enamel texture

#declare PAINT_L01=
texture {
   finish {
      brilliance 0.5
      diffuse 0.9
      ambient 0.2
      phong 0.5
      phong_size 50
   }
   pigment {
      image_map {
         gif "paint.gif"
         map_type 2
         once
      }
      scale 22
      translate y*1
   }
}
#declare P_CHROME =
texture{ T_Chrome_4C
   normal { bumps .1 scale 2 }
}

#declare CAN01=
union {
   difference {
      intersection {
         superellipsoid { < 1, 0.1 >
            translate z*1
            rotate x*-90
            scale 15
         }
         box { < -16, 0, -16 > < 16, 26.5, 16 > texture { P_CHROME }}
      }
      cylinder { < 0, 5, 0 > < 0, 30, 0 > 10 texture { P_CHROME }}
      cylinder { < 0, 5, 0 > < 0, 25.5, 0 > 14 texture { P_CHROME }}
   }
   torus { 15, .75 scale < 1, 1.25/.75, 1 > translate y*26.5 texture { P_CHROME }}
   texture { P_CHROME }
   texture { PAINT_L01 }
}

#declare O_CHROME =
texture{ T_Chrome_4C
   normal { bumps .1 scale 2 }
   pigment {
      bozo
      turbulence .5
      color_map {
            [0 color rgb <.75,.75,.75> ]
            [0.2 color rgb <.75,.75,.75> ]
            [0.5 color rgb <0,0,.5> ]
            [0.6 color rgb <0,0,.5> ]
            [0.8 color rgb <.75,.75,.75> ]
            [1 color rgb <.75,.75,.75> ]
      }
      scale 10
   }
}

#declare CAN02=
union {
   difference {
      intersection {
         superellipsoid { < 1, 0.1 >
            translate z*1
            rotate x*-90
            scale 15
         }
         box { < -16, 0, -16 > < 16, 26.5, 16 > texture { O_CHROME }}
      }
      cylinder { < 0, 5, 0 > < 0, 30, 0 > 10 texture { O_CHROME }}
      cylinder { < 0, 5, 0 > < 0, 25.5, 0 > 14 texture { O_CHROME }}
   }
   torus { 15, .75 scale < 1, 1.25/.75, 1 > translate y*26.5 texture { O_CHROME }}
   texture { O_CHROME }
   texture { PAINT_L01 }
}

#declare CUP01=
union{
   difference {
      union {
         intersection {
            superellipsoid { < 1, 0.1 >
               translate z*1
               rotate x*-90
               scale 10
            }
            box { < -16, 0, -16 > < 16, 6, 16 > }
         }
         cylinder { < 0, 5, 0 > < 0, 6, 0 > 12.5}
         torus { 12.5, 0.5 translate y*5.5}
      }
      superellipsoid { < 1, 0.1 >
         translate z*1
         rotate x*-90
         scale 9
         translate y*1
      }
      cylinder { < 0, 5.5, 0 > < 0, 7, 0 > 9.5}
   }
   torus { 9.5, 0.5 translate y*5.5}
}

#declare PAINT01=
cylinder { < 0, 5, 0 > < 0, 15, 0 > 14 }

#declare PAINT_CAN01=
union{
   object { CAN01 }
   object { CUP01 translate y*22 }
}

#declare PAINT_CAN02=
union{
   object { CAN02 }
   object { PAINT01 }
}

// PAINT CANS

object { PAINT_CAN01
   texture { BTEX pigment {color rgb <1,0,0> } }
   translate < -185, 0, -120 >
}

object { PAINT_CAN01
   texture { T_Gold_4C }
   rotate y*108
   translate < -125, 0, -120 >
}

object { PAINT_CAN01
   texture { BTEX pigment {color rgb <1,0.5,0.6>*1.1 } }
   rotate y*43
   translate < -129, 0, -192 >
}

object { PAINT_CAN02
   texture { BTEX pigment {color rgb <0,0,0.5> } }
   rotate y*-123
   translate < -145, 0, -149 >
}

object { CUP01
   translate y*-6
   rotate x*180
   texture { O_CHROME }
   translate < -179, 0, -157 >
}

// RC CAR

#include "rad_car.inc"
object{ RAD_CAR01
   scale 25
   rotate y*2
   translate <70,0,180>
}

// REMOTE CONTROL

object {CONTROL01 scale 30 rotate y*39 translate <90,0,400> }

// glue bottle texture

#declare ADH_L01=
texture {
   finish {
      brilliance 0.5
      diffuse 0.9
      ambient 0.2
      phong 0.5
      phong_size 50
   }
   pigment {
      image_map {
         gif "adh.gif"
         map_type 2
         once
      }
      scale 24
   }
}

#declare ADH_TEX=
texture {
   finish {
      brilliance 0.5
      diffuse 0.9
      ambient 0.2
      reflection .05
      phong 0.5
      phong_size 20
   }
   normal { bumps .1 scale 1/100 }
   //pigment { color rgb .1 }
   pigment{
      bozo
      turbulence 2
      color_map{
         [ 0 color rgb .12 ]
         [ 0.5 color rgb .1 ]
         [ 1 color rgb .12 ]
      }
      scale 1/100
   }
}

#declare ADH01=
union{
   difference{
      union{
         cone { <0,28,0>17 <0,56,0>7.5 }
         cylinder{ <0,3,0> <0,28,0>17 }
         difference{
            cylinder{ <0,0,0> <0,24,0>17.01 texture {ADH_L01} translate y*3.2}
            box{<0,-5,-50,><50,50,50> translate x*10}
         }
         torus { 17-3, 3 translate y*3}
         cylinder{ <0,3,0> <0,0,0>17-3 }
      }
      box{<0,-5,-50,><50,50,50> rotate z*-14 translate x*10}
      cylinder{<0,0,-50,><0,0,50>3 translate <-(7+3),(32+3),0>}
      box{<-10,0,-50,><0,50,50> translate <-7,(32+3),0>}
      box{<-10,0,-50,><0,20,50> translate <-(7+3),32,0>}
   }
   cylinder{ <0,56,0> <0,58,0>6 }
   cylinder{ <0,58,0> <0,59,0>9 }
   #declare COUNTR = 28
   #declare ANG01 = 360/COUNTR
   #while ( COUNTR >= 0 )
      cylinder{ <0,59,0> <0,58+10,0>.5 translate x*-8.5 rotate y*ANG01*COUNTR }
      #declare COUNTR = COUNTR - 1
   #end
   cylinder{ <0,58,0> <0,58+11,0>8.5 }
   cone { <0,58+11,0>8.5 <0,58+22,0>1.5 }
   cylinder{ <0,58+22,0> <0,58+27,0>1.5 }
   cylinder{ <0,58+27,0> <0,58+27+35,0>.5 texture{T_Chrome_4D} }

   texture { ADH_TEX }
}

// GLUE BOTTLE

object { ADH01 rotate y*-169 translate < -178, 0, -77 >}

// PEN02 (RED & BLUE)
#declare PEN_02=
union{
   #declare PEN_ERR01=0
   #declare PEN_PIG01= pigment{color rgb <.9,.2,.25>*.9}
   #declare PEN_PIG02= pigment{color rgb <.9,.2,.25>*.9}
   #declare PEN_RAD01=0.8/2
   #declare PEN_WID01=8
   #include "m_pen01.inc"
   object{PEN01}
   #declare PEN_ERR01=0
   #declare PEN_PIG01= pigment{color rgb <.25,.2,.7>*.9}
   #declare PEN_PIG02= pigment{color rgb <.25,.2,.7>*.9}
   #declare PEN_RAD01=0.8/2
   #declare PEN_WID01=6
   #include "m_pen01.inc"
   object{PEN01 rotate x*180 translate <0,PEN_RAD01*2,(8+6)>}
   scale 10
   }

object{PEN_02 rotate y*131 translate <-98,0,550>}

// threshold
#declare BLOB_DENS01 = .5
// strength
#declare BLOB_STRN01 = .6
// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / BLOB_STRN01 ) )

#declare PAINT_BLOB=
intersection{
   blob{ threshold BLOB_DENS01
      sphere { 0, 1, BLOB_STRN01
         scale 10/BLOB_A_R01
         scale <1,.15,1>
      }
      sphere { 0, 1, BLOB_STRN01
         scale 3/BLOB_A_R01 translate <-10,0,-2>
         scale <1,.15,1>
      }
      sphere { 0, 1, BLOB_STRN01
         scale 2/BLOB_A_R01 translate <7,0,-8>
         scale <1,.2,1>
      }
      sphere { 0, 1, BLOB_STRN01
         scale 3.5/BLOB_A_R01 translate <3,0,9>
         scale <1,.15,1>
      }
      sphere { 0, 1, BLOB_STRN01
         scale 1/BLOB_A_R01 translate <-3,0,-9>
         scale <1,.35,1>
      }
      cylinder { <0,0,0><0,50,0>, 100, -1
         scale <1,.05,1> translate <0,6,0>
      }
   }
   sphere {0, 20 scale <1,.05,1>}
   texture { BTEX pigment { color rgb <0,0,.5>}}
   scale <1,.5,1>
}

// PAINT BLOB:

object {PAINT_BLOB translate < -109, 0, -138 > }

// threshold
#declare BLOB_DENS01 = .7
// strength
#declare BLOB_STRN01 = 5
// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / BLOB_STRN01 ) )

#declare Brush_Prt01=
union{
   difference{
      blob{ threshold BLOB_DENS01
         sphere { 0, 1, BLOB_STRN01
            scale 2.5/BLOB_A_R01
            scale <.9,1,1>
         }
         sphere { 0, 1, BLOB_STRN01
            scale 2.5/BLOB_A_R01 translate <-3.5,0,0>
         }
         sphere { 0, 1, BLOB_STRN01
            scale 2.5/BLOB_A_R01 translate <3.5,0,0>
         }
      }
      box{<0,-5,-5><5,5,5> translate <3.5,0,0>}
   }
   cone {<-25,0,0> 1.5 <-0.100120337,0,0>2.49799438 translate x*-3.5}
}

// threshold
#declare BLOB_DENS01 = .5
// strength
#declare BLOB_STRN01 = .7
// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / BLOB_STRN01 ) )

#declare Brush_Prt02=
blob{ threshold BLOB_DENS01
   cylinder { <0,0,0> <250,0,0> 2.1/BLOB_A_R01 BLOB_STRN01}
   sphere { <0,0,0> 2.5/BLOB_A_R01 BLOB_STRN01 scale <5,1,1> translate x*25}
translate <3.5,0,0>
}

#declare Brush_Prt03=
sphere{ 0,2 scale <3,1,1> translate <-30,0,0> }

#declare Brush=
union{
   object{Brush_Prt01 texture { O_CHROME translate x*-5} }
   object{Brush_Prt02 texture { BTEX  pigment { color rgb <.5,.25,0>} } }
   object{Brush_Prt03
   texture { BTEX
      normal { bumps 2 scale <1,.1,.1>*.2 }
      pigment { color rgb <0,0,.5>} }
   }
}

// PAINT BRUSH

object{Brush
   translate <-253.5,2.1,0>
   rotate z*-.5
   translate x*228.5
   rotate  y*56
   translate < -87, 0, -197 >
}

// CADILLAC V8 ENGINE

#include "motor01.inc"
object{C_59V801
   rotate y*-208
   translate <-50,(20+30+28.5),-187>
}

// MANUAL

object{MANUAL01
   rotate y*-34
   translate <96,0,-178>
}

// CADILLAC WHEELS

#include "pink59.inc"
object{C_59WH01
   translate <59,10,-234>
}

object{C_59WH01
   translate <44,10,-199>
}

// CADILLAC REAR BUMPER

object{R_BUMP01 rotate y*40 translate <65,17+6,-195>}

// MODEL KIT PARTS

object{BASE01
   translate z*3.15
   rotate y*-78
   rotate x*-1
   translate <135,7.5+6,-135>
}

// CADILAC FRONT END

object {FRONT01
   translate y*(13.5+2.5+5.5)
   rotate y*15
   translate <-57,0,-130>
}

// DINOSAUR

#include "din01.inc"
object{DIN00 scale 5 translate <115,6,-128>}

// CLOCK

#include "chi_clock.inc"
object { Chi_Clock scale 8 rotate y*-25 translate <-195,0,117>}

// PEN01 (YELLOW)

      #declare PEN_ERR01=1
      #declare PEN_PIG01= pigment{color rgb <1,.6,.1>}
      #declare PEN_PIG02= pigment{color rgb <.2,.2,.2>}
      #declare PEN_RAD01=0.8/2
      #declare PEN_WID01=12
      #include "m_pen01.inc"
      object{PEN01
         //translate <0,PEN_RAD01*2,>
         scale 10
         rotate y*-245
         translate <-250,0,15>
         }

// CHOCKOLATE

#include "foil01.inc"
object{TB_CHOCK
   rotate y*129
   translate <-28,0,170>
}


#declare I_Ang01 = 10
#declare O_Ang01 = 40
#declare O_Ang02 = -80
#declare O_Ang03 = 40
#declare Segm01 = 2.5

// PAPER CLIP01

#include "chi_misc01.inc"
object {P_CL01 rotate y*-14 translate <-33,0,409>}

#declare I_Ang01 = -5
#declare O_Ang01 = 20
#declare O_Ang02 = -120
#declare O_Ang03 = 25
#declare Segm01 = 2.5

// PAPER CLIP02

#include "chi_misc01.inc"
object {P_CL01 rotate y*32 translate <-69,0,462>}

// NOTEBOOK

object {N_Book01 rotate y*-25 translate <-260,0,530>}


// SPACE FIGHTER

#include "tie01.inc"
object{FI01 translate y*150.06 scale .2 rotate y*58 translate <180,0,-20>}

#declare BTEX0 =
   texture{
      finish {
         ambient .2
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.2
      }
      normal {bumps 0.05 scale 20}
   }

// CADILLAC BODY

object{C59_01
   texture { BTEX0 pigment {color rgb <1,0.5,0.6>*1.1 } }
   rotate y*42
   translate <55,0,-25>
}

// CADILLAC STEERING WHEEL

object{ STW_C59_01
   translate <-22,0,-138>
   rotate y*-10
}

// MODEL KIT BOX

object{ BOX01
   rotate y*26
   translate <271,0,100>
}

// glass ball texture

#declare Chi_Glass01 =
texture{
   finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      refraction 1
      ior 1.5
      reflection 0.2
      caustics 0.6
   }
   normal {bumps 0.05 scale 20}
   pigment { color rgbf<1.0, 1.0, 1.0, 0.7> }
}

// GLASS BALLS

sphere { <0,1,0> 1 scale 12.5 translate <69,0,10> texture {Chi_Glass01}}
sphere { <0,1,0> 1 scale 10 translate <47,0,-13> texture {Chi_Glass01}}

// CADILLAC FRONT SEATS

#switch (0)

// PLASIC

#include "seat01.inc"
object{SEAT01 rotate y*44 translate <9,0,87>}

#switch (1)

// PAINTED

#include "seat01.inc"
object{SEAT01 rotate y*-26 translate <-45,0,30>}

#declare RAB_Case=
difference{
   union{
      box{ <-12.5,0,0><12.5,10.5,33> }

      #declare Count = 17
      #declare Dist= 25/18
      #declare R_CYL01=
      union{
         #while (Count>=0)
            cylinder { <0,0,0><0,0,33> .6
               translate x*Dist*Count
            }
            #declare Count = Count-1
         #end
         translate x*Dist*17/-2
       }
       object{ R_CYL01 }
       object{ R_CYL01 translate y*10.5 }

       #declare Count = 7
       #declare Dist= 10.5/8
       #declare R_CYL01=
       union{
          #while (Count>=0)
             cylinder { <0,0,0><0,0,33> .6
                translate x*Dist*Count
             }
             #declare Count = Count-1
          #end
          translate x*Dist*7/-2
          rotate z*90
       }
       object{ R_CYL01 translate <-12.5,10.5/2,0>}
       object{ R_CYL01 translate <12.5,10.5/2,0>}
   }
   box{ <-12.5+.5,.5,-1><12.5-.5,10.5-.5,33-.5>}
   cylinder{ <0,10.5/2,32><0,10.5/2,34>4.5 }
   translate y*.6
}

#declare RAB_Err =
superellipsoid{ <.2,.7>
   translate <0,1,0>
   scale <12.2,4.5,20>
   translate <0,1,9>
   texture{DEF_TEX}
}

// eraser texture

#declare Err_TEX=
texture{
   finish{
      diffuse .7
      ambient .3
      phong 1
      phong_size 30
   }
   pigment{
      color rgbt <.8,.8,.8,.15>
   }
}

// eraser case texture

#declare Case_TEX=
texture{
   finish{
      diffuse .95
      ambient .3
      phong .5
      phong_size 2
   }
   pigment{
      color rgbt <1,.95,.3,.05>*.9
   }
}


#declare RABBIT=
union{
   object{RAB_Case texture{Case_TEX}}
   object{RAB_Err texture{Err_TEX}}
}


// ERASER

object{RABBIT rotate y*240 translate <-78,0,-25>}

camera{
   location<-100,300,-450>
   angle 45
   right 4/3*x
   look_at <0,0,0>
}

light_source {<-500,500,-500>
//light_source {<500,500,-500>
color rgb <1,1,1>}
