
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: 1:25 scale model kit "CADILLAC'59"
// Date: 01.12.97
// Auth: N.B.(c)1997

// units are mm

/*
background {color rgb 0.9}

camera {
   location <-100,70,-150>

   //location <0,0,-200>
   look_at <0,0,0>
   angle 30
   }

light_source { <2000, 2000, -5000> rgb 1 }

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"
#include "golds.inc"

// default texture:
#declare DEF_TEX=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 10
   }
   pigment{
      color rgb .8
   }
}
*/

#declare PINK_PLASTIC=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 20
   }
   pigment{
      color rgb <1,0.5,0.6>
   }
}

#declare TTEX =
   texture{
      finish{
         ambient <0.9,0.85,.8>*.2
         diffuse .95
         phong .05
         phong_size 3
      }
   pigment{color rgb <0.9,0.85,.8>*.2}
}

// tire:

#declare TIRE_PRT00=
union{
   torus{ 14, 1 scale < 1,3,1 >}
   torus{ 10, 3.6 scale < 1,.265,1 > translate y*2.8}
   torus{ 10, 3.6 scale < 1,.265,1 > translate y*2.8}
   lathe {
      linear_spline
      6,
      <0, -3.3>,<13, -3.3>,<14, -3>,
      <14, 3>, <13, 3.3>, <0, 3.3>
      }
   difference{
      cylinder{<0,-3.74,0><0,3.74,0>11.5}
      cylinder{<0,-5,0><0,5,0>10.5}
   }
}

#declare TIRE_PRT01=
difference{
   object{TIRE_PRT00}
   cylinder{<0,-5,0><0,5,0>11.5}
}

#declare TIRE_PRT02=
intersection{
   difference{
      object{TIRE_PRT00}
      cylinder{<0,-5,0><0,5,0>8}
   }
   cylinder{<0,-5,0><0,5,0>11.5}
}

#declare WHEEL01=
lathe {
         linear_spline
         17,
         <0, -3.5>,<8, -3.5>,
         <8, 0>, <8, 3.6>, <7.3, 3.7>, <5.5, 1.5>, <5, 4>,
         <4.5, 4>, <4.2, 3.5>, <4, 3.5>, <3.7, 3>, <3.5, 3>,
         <3.2, 2.5>, <3, 2.5>, <1.8, 2.8>, <1.8, 2.7>,<0, 2.7>
      }

#declare WHEEL02=
union{
#declare WH_NUM01 = 11
#declare WH_ANG01 = 360 / (WH_NUM01+1)
#while ( WH_NUM01 >= 0)
   prism {
      linear_sweep
      .2,-.2,
      5,
      <0,0>, <5, 4.3>, <7.3, 3.7>, <7.3,0>, <0,0>
      rotate x*-90
      translate y*-.7
      rotate y*WH_ANG01*WH_NUM01
   }
   #declare WH_NUM01 = WH_NUM01 - 1
#end
}

#declare C_59WH01=
union{
  object{TIRE_PRT01 texture{ TTEX } }
  object{TIRE_PRT02 texture{ TTEX pigment { color rgb <0.95,0.95,0.9> } } }
  object{WHEEL01 texture{ T_Chrome_4D } }
  object{WHEEL02 texture{ T_Chrome_4D } }
}

#declare R_BUMP01=
union{

difference{
   union{
      #declare SIDE = -1
      #include "bump01.inc"
      object{R_Bump_Prt02}

      #declare SIDE = 1
      #include "bump01.inc"
      object{R_Bump_Prt02}

      #declare No_Rows01 = 3
      #while ( No_Rows01 > 0)
         cylinder{<0,0,0><0,0,-2>0.4
            translate < 0,-9+Dist_br01*No_Rows01,4.7>
         }
      #declare No_Rows01 = No_Rows01-1
      #end
      box{<-.3,-4.3,4.7><.3,-9,3.7>}
      cylinder{<0,0,0><0,0,5>0.5
         translate < 0,-2,0>
      }
   }
   superellipsoid { < 0.3, 0.3 >
      translate <0,-1,-1>
      scale < 7,3,5>
      translate <0,-10,5>
   }
   box{<-7,2,0><7,-5,-5>
      rotate x*-30
      translate <0,-16,3.5>
   }
   // texture {DEF_TEX}
   texture {T_Chrome_4D}
}

#declare SIDE=1
#include "bump01.inc"
object{ R_Bump_Prt03 scale <1,1,.9> translate <-26.5*SIDE, 0, 7> }

#declare SIDE=-1
#include "bump01.inc"
object{ R_Bump_Prt03 scale <1,1,.9> translate <-26.5*SIDE, 0, 7> }
}

#declare BASE01=

union{
   cylinder{<0,0,0><0,-7.5,0>3.15}
   cylinder{<0,0,0><0,0,-160>1.7}
   cylinder{<0,0,0><-200,0,0>1.7}
   sphere{0, 1.7}
   cylinder{<-115,0,0><-115,-7.5,0>3.15}
   cylinder{<-115,0,0><-115,0,-160>1.7}
   cylinder{<0,0,-95><-115,0,-95>1.7}
   cylinder{<-73,0,0><-73,0,-95>1.7}

   cylinder{ <0,0,-20><-8,0,-20>1.6}
   sphere{<-8,0,-20>, 1.6}
   cylinder{ <0,0,-60><-8,0,-60>1.6}
   sphere{<-8,0,-60>, 1.6}

   cylinder{ <0,0,-20><8,0,-20>1.6 translate x*-73}
   sphere{<8,0,-20>, 1.6 translate x*-73}
   cylinder{ <0,0,-60><8,0,-60>1.6 translate x*-73}
   sphere{<8,0,-60>, 1.6 translate x*-73}

   cylinder{ <0,0,-20><-8,0,-20>1.6 translate x*-73}
   sphere{<-8,0,-20>, 1.6 translate x*-73}
   cylinder{ <0,0,-73><-8,0,-73>1.6 translate x*-73}
   sphere{<-8,0,-73>, 1.6 translate x*-73}

   #declare B_PRT01=
   union{
      cylinder { <-10,2,4><-10,-2,4>.75}
      prism {
         linear_sweep
         linear_spline
         1, -1, 14,
         <0, 0>
         <0, -56>, <-13, -56>, <-13, -71>, <-25, -71>, < -25, -3>,
         <-18, -3>, <-18, 4>, <-12, 4>, <-12, 7>, <-9, 7>,
         <-4.5, 4>, <-2.5, 0>,
         <0, 0>
         texture {PINK_PLASTIC normal {bumps .1 scale .1} }
      }
      superellipsoid {<.2,.2> scale <4,3,21> translate <-11,0,-31>}
      prism {
         linear_sweep
         cubic_spline
         2, -2, 7,
         <-2,0> <0, 0>
         <12, -.5>, <5.3, -10>, <0, -12>,
         <0, 0> <0, 2>
         translate <-25,0,-3>
      }
      cylinder { <0,3,0><0,-3,0>.75 translate <-16,0,-6>}
      cylinder { <0,3,0><0,-3,0>.75 translate <-23,0,-6>}
      cylinder { <0,3,0><0,-3,0>.75 translate <-23,0,-12>}
   }
   object { B_PRT01 translate <-9,0,-14> }
   object { B_PRT01 rotate z*180 translate <-64,0,-14> }
   texture {PINK_PLASTIC}
}

#declare FRONT01=
union{

union{
   #declare SIDE1 = -1
   #declare SIDE=1
   #include "front01.inc"
   object{FRONT_LAMP01 scale .95}
   object{FRONT_BUMP01 translate y*-10}

   #declare SIDE=-1
   #include "front01.inc"
   object{FRONT_LAMP01 scale .95}
   object{FRONT_BUMP01 translate y*-10}

   object{FRONT_BUMP02 translate y*-16.5}
   translate x*-31.5
}

union{
   #declare SIDE1 = 1
   #declare SIDE=1
   #include "front01.inc"
   object{FRONT_LAMP01 scale .95}
   object{FRONT_BUMP01 translate y*-10}

   #declare SIDE=-1
   #include "front01.inc"
   object{FRONT_LAMP01 scale .95}
   object{FRONT_BUMP01 translate y*-10}

   object{FRONT_BUMP02 translate y*-16.5}
   translate x*31.5
}

difference{
   union{
      #declare SIDE=1
      #include "front01.inc"
      object{FRONT_BUMP03}

      #declare SIDE=-1
      #include "front01.inc"
      object{FRONT_BUMP03}

      #declare GRILL02=
      union{
         #declare No_Rows01 = 3
         #while ( No_Rows01 > 0)
            cylinder{<0,0,0><0,0,-2>0.4
               translate < 0,-9+Dist_br01*No_Rows01,4.7>
            }
         #declare No_Rows01 = No_Rows01-1
         #end
         box{<-.3,-4.3,4.7><.3,-9,3.7>}
      }
      object{GRILL02
         translate y*<0,2.5,1>
      }
      object{GRILL02
         translate y*<0,-4,1>
      }
   }
   box{<-8*.9,2,-10><8*.9,-5,-1> translate <0,-13.5,4.5>}
   translate <0,-2.5,-3.5>
}

union{
#declare SIDE=1
   #include "front01.inc"
   object{L_PLATE01}

   #declare SIDE=-1
   #include "front01.inc"
   object{L_PLATE01}

   scale <.9,.85,.9>
   translate <0,-13.5,4>
   translate <0,-2.5,-3.5>
}
texture{T_Chrome_4D}
}

#declare C59_01 =
union{
   difference{
      union{
         #declare SIDE = 1
         #include "body01_59.inc"
         object{HANDLE01}
         object{B_SIDE01}
         object{SIDE_CHROME01}
         object{FIN_CHROME01}
         object{HOOD_CHROME01}
         object{TRUNK01}
         object{HOOD01}
         #declare SIDE = -1
         #include "body01_59.inc"
         object{HANDLE01}
         object{B_SIDE01}
         object{SIDE_CHROME01}
         object{FIN_CHROME01}
         object{HOOD_CHROME01}
         object{TRUNK01}
         object{HOOD01}
      }
      superellipsoid{<.3,.3> translate z*1 scale 31 translate z*53}
      superellipsoid{<.3,.3> translate z*-1 scale 31 scale <1,1,1.3> translate z*163.5}
      box{<28,-3,30><-28,-15,5> translate z*206}

      superellipsoid{<.4,.1> scale <37,7,70> translate y*-7.5 }
      superellipsoid{<.4,.6> scale <35,14,70> translate <0,-6,104> }
   }
   cylinder {<0,0,-1><0,0,-12>4.5 translate <-27,-4.5,222.5>}
   cylinder {<0,0,-1><0,0,-12>4.5 translate <27,-4.5,222.5>}

/*
   object {FRONT01
      rotate y*180
      translate <0,0,222.5> //-120>
   }
   object{R_BUMP01} */


   translate z*-120
   translate y*21.5
   //texture {BTEX pigment {color rgb <1,0.5,0.6>*1.1 }}
}

#declare STW_Part01 =
union{
   torus{ (18.57-1.5)/2 1.5/2}
   #declare STW_Num01 = 47
   #while (STW_Num01 >= 0)
     sphere {<(18.57-1.5)/2, .7, 0> .3
        rotate y*360/48*STW_Num01
     }
     #declare STW_Num01 = STW_Num01 - 1
   #end
}

#declare STW_Part02 =
union{
   torus{ 6 .4 scale <1,1.5,1>}
   sphere{ < -6, 0, 0 >.7 }
   sphere{ < 6, 0, 0 >.7 }
   cylinder{ < -(18.57-1.5)/2, 0, 0> < -6, 0, 0 > .7 }
   cylinder{ < (18.57-1.5)/2, 0, 0> < 6, 0, 0 > .7 }
   difference{
      cone { < -6, 0, 0 > .7 < 0, 5, 0> 1.2 }
      box{ < -10, .5, 5 > < 0, 5, -5> rotate z*degrees(atan2(5,6)) translate y*5}
   }
   difference{
      cone { < -6, 0, 0 > .7 < 0, 5, 0> 1.2 }
      box{ < -10, .5, 5 > < 0, 5, -5> rotate z*degrees(atan2(5,6)) translate y*5}
      rotate y*180
   }
   sphere { 0, 2 scale <1,2,1> translate y*4 }
   texture { T_Chrome_4D }
}

#declare STW_C59_01=
union{
   difference{
      object{STW_Part01}
      box{<-25,-5,-4><25,5,4>}
   }
   intersection{
      object{STW_Part01}
      box{<-25,-5,-4><25,5,4>}
      texture { BTEX0 pigment {color rgb <1,0.5,0.6>*1.1 } }
   }

   object{STW_Part02
      translate y*.5
   }

   union{
      cylinder{<0,0,0><0,24,0>2.92/2}
      cylinder{<0,0,0><0,12,0>3.5/2}
      cylinder{<0,0,0><0,1.5,0>2}
      cylinder{<0,2,0><0,2.5,0>1.9}
      cylinder{<0,2.5-.75,0><2.8,2.5-.75,0>.6}
      sphere{<2.8,2.5-.75,0>.6}
      translate y*5
   }

   union{
      cylinder{<0,0,0><-5.5,0,0>.3}
      sphere{<0,0,0>.3}
      sphere{<-5.5,0,0>.5}
      difference{
         sphere{<0,0,0>.5 scale <2.5, 1, 1>}
         box{<-5, -5, -5> <0, 5, 5>}
         translate x*-5.5
      }
      rotate z*10
      translate <-2,5.75,0>
      texture { T_Chrome_4D }
   }

   union{
      cylinder{<0,0,0><-6.5,0,0>.3}
      sphere{<0,0,0>.3}
      sphere{<-6.5,0,0>.5}
      difference{
         sphere{<0,0,0>.5 scale <2.5, 1, 1>}
         box{<-5, -5, -5> <0, 5, 5>}
         translate x*-6.5
      }
      rotate z*10
      rotate y*180
      translate <3,2.5-.75+5,0>
      texture { T_Chrome_4D }
   }
   texture { BTEX0 pigment {color rgb 1.1} }

   translate y*-29
   rotate x*(90+degrees(atan2((18.57/2-2.92/2),29)))
   translate y*2.92/2
   rotate x*11.5
}

#declare PAP_TEX=
texture{
   finish{
      diffuse .9
      brilliance .8
      ambient .2
      phong .5
      phong_size 10
   }
   pigment{
      color rgb <190/255, 202/255, 203/255>
   }
}

#declare BOX01 =
difference{
   union{
      sphere { <0,0,0>1 translate y*1 }
      sphere { <0,0,295>1 translate y*1 }
      sphere { <235,0,0>1 translate y*1 }
      sphere { <235,0,295>1 translate y*1 }

      cylinder { <0,0,0> <0,0,295>1 translate y*1 }
      cylinder { <235,0,0> <235,0,295>1 translate y*1 }
      cylinder { <0,0,295> <235,0,295>1 translate y*1 }
      cylinder { <0,0,0> <235,0,0>1 translate y*1 }

      cylinder { <0,0,0> <0,92,0>1 translate y*1 }
      cylinder { <0,0,295> <0,92,295>1 translate y*1 }
      cylinder { <235,0,0> <235,92,0>1 translate y*1 }
      cylinder { <235,0,295> <235,92,295>1 translate y*1 }

      box { <0,0,0> <235,2,295>}

      box { <1,0,0> <-1,92,295> translate y*1
         texture{PAP_TEX
            pigment{
               image_map{ gif "box02.gif" }
               translate <-1,0,0>
               scale <295,92,1>
               rotate y*90
            }
         }
      }
      box { <235-1,0,0> <235+1,92,295> translate y*1 }
      box { <0,0,295-1> <235,92,295+1> translate y*1}
      box { <0,0,1> <235,92,-1> translate y*1
         texture{PAP_TEX
            pigment{
               image_map{ gif "box01.gif" }
               //translate <.5,.5,0>
               scale <235,92,1>
            }
         }
      }

      texture{PAP_TEX}
   }
   box { <.2,1.2,.2> <235-.2,100,295-.2>
      texture{PAP_TEX pigment{color rgb .7} }
   }
}
