
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: "CADILLAC'59" MODEL KIT FRONT SEAT
// Date: 30.12.1997
// Auth: (c) N.B. 1997

#declare PINK_PLASTIC=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 20
   }
   pigment{
      color rgb <1,0.5,0.6>
   }
}

#declare S_TEX00=
texture{
   finish{
      diffuse .9
      ambient .2
      brilliance .95
      reflection .1
      phong 1
      phong_size 100
   }
   normal {wrinkles .1 scale .5 }
   pigment{
      color rgb .8
   }
}

//#switch (0)

   #case (0)
      #declare S_TEX01 = texture {PINK_PLASTIC}
      #declare S_TEX02 = texture {PINK_PLASTIC}
      #declare S_TEX03 = texture {PINK_PLASTIC}
   #break

   #case (1)
      #declare S_TEX01 = texture {S_TEX00 pigment {color rgb <1,0.5,0.6>*1.1 } }
      #declare S_TEX02 = texture {S_TEX00 pigment {color rgb 1.1}}
      #declare S_TEX03 = texture {T_Chrome_4D}
   #break
#end

#declare S_Part01=
difference{
   #declare BLOB_DENS01 = .5
   #declare BLOB_STRN01 = .8
   #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   blob{ threshold BLOB_DENS01
      cylinder{<4,0,-1><11,0,2.5> 4/BLOB_A_R01, BLOB_STRN01 scale <1,.5,1>}
      sphere{ 0, 4.5/BLOB_A_R01, BLOB_STRN01 scale <2.7,.9,1.1> rotate y*-45 translate x*10}
   }
   box{<-5,-5,0><20,5,-10>}
   scale <1,.9,1>
   rotate x*-90
   rotate y*90
}

#declare S_Part02 =
union{
   #declare S_Num = 4
   #while ( S_Num >= 0 )
      superellipsoid {<.5,.5>
         rotate x*90
         translate <0,-1,-.9>
         scale <8.5,1,1.7>
         rotate x*-S_Num*5
         translate z*-3*S_Num
         translate y*-pow(.3*S_Num,2)
      }
      #declare S_Num = S_Num-1
   #end
   superellipsoid {<.4,.4>
      rotate x*90
      translate <0,-1,-1>
      scale <8.5,4.5,3.5>
      rotate x*-45
      translate <0,-1.8,-14.3>
   }
   translate y*1
   rotate x*41
   texture{S_TEX01 }
}

#declare S_Part03=
union{
   difference{
      superellipsoid {<.4,.4>
         rotate x*90
         translate <0,1,0>
         scale <11,5,11.5>
         translate <0,-4,4>
      }
      box{<20,20,20><-20,0,-20>}
      box{<20,20,0><-20,-20,20>}
   }
   intersection{
      superellipsoid {<.4,.4>
         rotate x*90
         translate <0,1,0>
         scale <11.5,5,12>
         translate <0,-4,4>
      }
      box{<20,0,-20><-20,-1.5,0>}
   }
   difference{
      superellipsoid {<.5,.4>
         rotate x*90
         translate <0,1,0>
         scale <11,5,11.5>
         translate <0,-4,4>
      }
      box{<20,20,20><-20,0,-20>}
      box{<20,20,0><-20,-20,-20>}
   }
   intersection{
      superellipsoid {<.5,.4>
         rotate x*90
         translate <0,1,0>
         scale <11.5,5,12>
         translate <0,-4,4>
      }
      box{<20,0,0><-20,-1.5,20>}
   }
   translate z*-10.7
}

#declare S_Part04=
union{
   difference{
      superellipsoid {<.4,.5>
         scale <10,21.5,3.5>
         rotate x*14
      }
      box{<-20,0,-20><20,-30,20>}
      translate <0,0,1.5>
   }
   difference{
      superellipsoid {<.4,.5>
         scale <10.3,21.8,3.5>
         rotate x*14
      }
      box{<-20,30,-20><20,-30,0> rotate x*14}
      box{<-20,0,-20><20,-30,20>}
      translate <0,0,1.5>
   }
   intersection{
      superellipsoid {<.4,.5>
         scale <10.5,22,3.5>
      }
      box{<-20,30,-.75><20,3,.75>}
      rotate x*14
      translate <0,0,1.5>
      texture { S_TEX03 }
   }
   #declare S_Num = 3
   intersection{
      union{
         #while ( S_Num >= 0 )
            superellipsoid {<.4,.4>
               translate <0,-.9,0>
               scale <6.5,1.7,.5>
               translate z*-1.7
               translate y*3*S_Num
            }
            #declare S_Num = S_Num-1
         #end
      }
      superellipsoid {<.4,.7>
         scale <6.5,10,4>
      }
      translate y*3.5
      rotate x*14
      texture { S_TEX01 }
   }
   intersection{
      union{
         superellipsoid {<.4,.1>
            translate <0,1,0>
            scale <4,2.6,.5>
            translate z*-1.7
         }
         superellipsoid {<.4,.1>
            translate <0,1,0>
            scale <7,2.6,2>
            translate y*5.1
         }
         translate y*12.2
      }
      superellipsoid {<.4,.5>
         scale <10,21.5,4>*1.02
         translate <0,0,1.5>
      }
      rotate x*14
      texture { S_TEX01 }
   }
}

#declare S_Part05 =
union{
   difference{
      torus {5,.75 rotate z*90}
      box{<-5,-8,0><5,8,-8>}
      box{<-5,0,-8><5,8,8> rotate x*14}
   }
   sphere {<0,-5,0>.75}
   cylinder{<0,0,5><0,5,5>.75 rotate x*14 }
   sphere {<0,5,5>.75 rotate x*14 }
}

#declare SEAT01=
union{
   object { S_Part01 scale <1,.7,1> translate <-8,0,-.5> }
   object { S_Part01  scale <1,.7,1> translate <8,0,-.5> }
   object { S_Part02  scale <1,.7,1> translate <0,0,-.5> }
   object { S_Part03 }
   object { S_Part04 }
   object { S_Part05 rotate z*-12 translate <-10.1,4,-2.5> texture { S_TEX03 }}
   object { S_Part05 rotate z*12 translate <10.1,4,-2.5> texture { S_TEX03 }}
   texture{S_TEX02}
   translate y*4
}
