
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.02
// Desc: "Space Superiority Starfighter"
// Date: 30.12.1997
// Auth: (c) N.B. 1997

/*

camera{
   location<-10,30,-40>
   location<-10,20,-30>*80
   //location<0,0,-40>
   //location<0,0,-800>
   //location<0,1500,0>
   angle 15
   right 4/3*x
   look_at <0,0,0>
}

light_source {<-500,500,-500>
//light_source {<500,500,-500>
color rgb <1,1,1>}

#include "metals.inc"
*/


#declare FI_TEX=
texture{
   finish{
      diffuse .9
      ambient .2
      brilliance .7
      phong .9
      phong_size 20
   }
   pigment{color rgb <.2,.2,.22>}
}


#declare SW_PART01=
prism {
  linear_sweep
  linear_spline
  0,
   -2,
  7,
  < 82.18, 150.06>, < -82.18, 150.06>, < -130.41, 0>,
  < -82.18, -150.06>, < 82.18, -150.06>, < 130.41, 0>,
  < 82.18, 150.06>
}

#declare SW_PART01=
prism {
  linear_sweep
  linear_spline
  0,
   -2,
  7,
  < 82.18, 150.06>, < -82.18, 150.06>, < -130.41, 0>,
  < -82.18, -150.06>, < 82.18, -150.06>, < 130.41, 0>,
  < 82.18, 150.06>
}

#declare SW_PART02=
prism {
  linear_sweep
  linear_spline
  2,
   -4,
  42,
  < 119.20, 7.15>, < 79.44, 132.03>, < 35.88, 52.49>,
  < 21.69, 21.61>, < 28.32, 10.36>, < 58.36, 7.14>,
  < 119.20, 7.15>

  < -119.20, 7.15>, < -79.44, 132.03>, < -35.88, 52.49>,
  < -21.69, 21.61>, < -28.32, 10.36>, < -58.36, 7.14>,
  < -119.20, 7.15>

  < 119.20, -7.15>, < 79.44, -132.03>, < 35.88, -52.49>,
  < 21.69, -21.61>, < 28.32, -10.36>, < 58.36, -7.14>,
  < 119.20, -7.15>

  < -119.20, -7.15>, < -79.44, -132.03>, < -35.88, -52.49>,
  < -21.69, -21.61>, < -28.32, -10.36>, < -58.36, -7.14>,
  < -119.20, -7.15>

  < 70.17, 141.13 >, < 24.91, 58.50 >, < 7.19, 30.94 >,
  < -7.19, 30.94 >,  < -24.91, 58.50 >, < -70.17, 141.13 >,
  < 70.17, 141.13 >

  < 70.17, -141.13 >, < 24.91, -58.50 >, < 7.19, -30.94 >,
  < -7.19, -30.94 >, < -24.91, -58.50 >, < -70.17, -141.13 >,
  < 70.17, -141.13 >
}

#declare SW_PART03=
difference{
    cylinder { < 0,-8,0><0,5,0> 42 }
    #declare COUNT = 5
    #while( COUNT >= 0)
       box{<0,-20,38> <10,20,-38> rotate z*30 translate x*34 rotate y*60*COUNT }
       box{<0,-20,38> <10,20,-38> rotate z*-45 translate y*-2 translate x*34 rotate y*60*COUNT }
       #declare COUNT = COUNT - 1
    #end
}

#declare SW_PART04=
prism {
  linear_sweep
  linear_spline
  2.5,
   -2.5,
  4,
  < 0, 0>, < 0, -16>, < 16, 0>,
  < 0, 0>
  rotate x*-90
}

#declare WPIL_PART01=
lathe {
  linear_spline
  13,
  <0, 102.2>, <10.7, 102.2>, <10.7, 85.8>, <12.5, 85.8>, <12.5, 78.6>,
  <10.7, 78.6>, <10.7, 66.1>, <12.5, 66.1>, <12.5, 62.5>, <10.7, 62.5>,
  <10.7, 38>, <0, 38>, <0, 102.2>
}

#declare WPIL_PART02=
prism {
  linear_sweep
  linear_spline
  10.7/2,
  -10.7/2,
  5,
  < 69.7, 12.5 >, < 45.4, 19.1 >,
  < 45.4, -19.1 >, < 69.7, -12.5 >,
  < 69.7, 12.5 >
  rotate z*90
}

#declare WPIL_PART03=
prism {
  linear_sweep
  linear_spline
  14.3/2,
  -14.3/2,
  6,
  < 50, 0 >, < 42.8, 25 >, < 32.7, 26.7 >,
  < 32.7, -26.7 >, < 42.8, -25 >, < 50, 0 >
  rotate z*90
}

#declare WPIL_PART04=
prism {
  linear_sweep
  linear_spline
  28.5/2,
  -28.5/2,
  9,
  < 62.5, 1.8 >, < 52.2, 5.4 >, < 49.7, 12.5 >, < 37, 16 >,
  < 37, -16 >, < 49.7, -12.5 >, < 52.2, -5.4 >, < 62.5, -1.8 >,
  < 62.5, 1.8 >
  rotate z*90
}


#declare SW01=
union{
  difference{
      object{SW_PART01}
      object{SW_PART02}
   }
   object{SW_PART01 scale .99 translate y*-2 texture{T_Chrome_1B}}
   difference{
      object{SW_PART01}
      object{SW_PART02}
      translate y*-4
   }
   object{SW_PART03}
   #declare COUNT = 5
   #while( COUNT >= 0)
      object{SW_PART04 translate <5,-8,0> rotate y*60*COUNT }
      #declare COUNT = COUNT - 1
   #end
   translate y*(102.2+8)
}

#declare WING01=
union{
   object{SW01}
   object{WPIL_PART01}
   object{WPIL_PART02}
   object{WPIL_PART03}
   object{WPIL_PART04}
}


#declare FUS01=
union{
   intersection{
      union{
         difference{
            sphere{0, 43}
            cylinder{<0,0,.4><0,0,-.4>45 rotate x*15}
            cylinder{<0,0,.4><0,0,-.4>45 rotate x*-15}
            cylinder{<0,0,.4><0,0,-.4>45 rotate x*45}
            cylinder{<0,0,.4><0,0,-.4>45 rotate x*-45}
         }
         intersection{
            sphere{0, 44 scale <1,1,.965>}
            box{ < 45, 9, 45 > < -45, -9, -45 > }
         }
         intersection{
            sphere{0, 44 scale <1,.96,1>}
            box{ < 45, 45, 5 > < -45, -45, -5 > }
         }
      }
      box{ < 35.7, 45, 31.4 > < -33.8, -45, -38.9 > }
   }
   box{ < 0, 30, 3.5 > < 37.5, -30, -3.5 > }
   cylinder{ <0,0,0><5,0,0> 3.5/2 translate <37.5-1,30-3.5,0>
      pigment{color rgb <3,0,0>}
   }
   cylinder{ <0,0,0><5,0,0> 3.5/2 translate <37.5-1,-30+3.5,0>
      pigment{color rgb <3,0,0>}
   }

   cylinder{ <0,0,0><-30,0,0> 5 scale <1,1,2> translate <0,15,-37+10>}
   cylinder{ <0,0,0><-30,0,0> 5 scale <1,1,2> translate <0,-15,-37+10>}

   #declare GUN01=
   difference{
      lathe {
         linear_spline
         9,
         <0, 0>, <1.79/2, 0>, <1.79/2, 7.15-1.43-2.86>,
         <1.79/2+.51, 7.15-1.43-2.86>, < 1.79/2+.51, 7.15-2.86>,
         <1.79/2,7.15-2.86>, <1.79/2,7.15>, <0,7.15>,
         <0, 0>
      }
      cylinder{<0,-2,0><0,8,0>.5
         pigment{color rgb <3,0,0>}
      }
      scale 1.5
      rotate z*90
   }
   object { GUN01 translate <-30,15,-37+5> }
   object { GUN01 translate <-30,-15,-37+5> }

   difference{
      sphere{ 0, 42 }
      box{<-40,0,0><40,-3.5,-10> translate <0,7.15/-2,-41>}
      box{<-40,0,0><40,3.5,-10> translate <0,7.15/2,-41>}

      box{<-40,0,0><40,-10.72,10> translate <0,10.72/-2,35.7>}
      box{<-40,0,0><40,10.72,10> translate <0,10.72/2,35.7>}

      box{<-3.74,0,0><40,-10,10> translate <0,-(10.72/2 +10.72+3.45),35.7>}
      box{<-3.74,0,0><40,10,10> translate <0,(10.72/2 +10.72+3.45),35.7>}
   }
   sphere{ 0, 41 texture{T_Chrome_1B}}
   union{
      difference{
         cone{<0,0,0>35.73/2+4.72<7.86,0,0>35.73/2}
         difference{
            cylinder{<3,0,0><10,0,0>16}
            cylinder{<2,0,0><12,0,0>13.5}
         }
         prism {
            linear_sweep
            linear_spline
            5,-5,7,
            <10*cos(0),10*sin(0)>,
            <10*cos(pi/3),10*sin(pi/3)>,
            <10*cos(pi*2/3),10*sin(pi*2/3)>,
            <10*cos(pi),10*sin(pi)>,
            <10*cos(pi*4/3),10*sin(pi*4/3)>,
            <10*cos(pi*5/3),10*sin(pi*5/3)>,
            <10*cos(0),10*sin(0)>
            rotate z*90
            rotate x*30
            translate x*7.86
         }
      }
      #declare COUNT=35
      #while( COUNT >= 0)
         box{<7.86,13,0.5><2,16.5,-0.5> rotate x*10*COUNT }
         #declare COUNT = COUNT - 1
      #end
      translate x*35.7
   }
   cylinder{<0,0,0><-2,0,0>25 translate x*-33.8}
   #declare COUNT=7
      #while( COUNT >= 0)
         union{
            prism {
               linear_sweep
               linear_spline
               .5,-.5,4,
               < 0, 0 >, < 0,-14.5 >, < -11, 0 >, < 0, 0 >
            }
            cylinder{< 0,0,-14.5 > < -11, 0, 0 > .5}
            translate z*-10
            rotate x*360/8*COUNT
            translate x*-35.5
         }
         #declare COUNT = COUNT - 1
      #end

      difference{
         #declare COUNT=8
         prism {
            linear_sweep
            linear_spline
            -5,0,COUNT+1,
            #while( COUNT >= 0)
               <10*cos(pi/4*COUNT),10*sin(pi/4*COUNT)>
               #if (COUNT > 0 )
                  ,
               #end
               #declare COUNT = COUNT - 1
            #end
         }
         #declare COUNT=8
         prism {
            linear_sweep
            linear_spline
            -6,1,COUNT+1,
            #while( COUNT >= 0)
               <9*cos(pi/4*COUNT),9*sin(pi/4*COUNT)>
               #if (COUNT > 0 )
                  ,
               #end
               #declare COUNT = COUNT - 1
            #end
         }
         rotate z*90
         translate x*-48
      }
      difference{
         cylinder{< -10.5, 0, 0 > < 0, 0, 0 > 24}
            #declare COUNT=7
            #while( COUNT >= 0)
            box{ <-20,0,10><1,20,-10>
               rotate z*degrees(atan2(14.5,11))
               translate y*22.5
               rotate x*360/8*COUNT
               rotate x*360/16
            }
            #declare COUNT = COUNT - 1
         #end
         texture{T_Chrome_1B}
         translate x*-35.5
      }
}
#declare FI01=
union{
   object{WING01}
   object{WING01 rotate z*180}
   object{FUS01}
   texture{FI_TEX}
   rotate x*-90
   rotate y*-90
}

// object{FI01 translate y*150.06}
