//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 42 textures and 246 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/30/1997    (30.12.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.465,1.000> }

fog {
  fog_type 2    // Ground Fog
  distance     12.0
  color <1.0,1.0,1.0,0.0,0.2>
  turbulence   <1.0,1.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    2
    turb_depth 0.0
  up           <0,0,1>
  fog_offset   -10.0
  fog_alt      1.8
}

camera {  //  Camera Camera01
  location  <-4.683, 37.956, 4.580>
  direction <0.0,     0.0,  1.8272>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.328, -0.219, 1.027>
}

// *******  L I G H T S *******
light_source {   // Light2
  <-43.600, 22.532, 6.661>
  color rgb <0.886, 0.886, 0.886>
  atmospheric_attenuation on
}

light_source {   // Light001
  <-14.522, 47.299, 24.303>
  color rgb <1.349, 1.349, 1.349>
}


// ********  TEXTURES  *******
//

#include "oworld.inc"



// ********  REFERENCED OBJECTS  *******

#declare asi = object {
  cylinder { // asi
    <0,0,1>, <0,0,0>, 1
    scale <0.860713, 1.348217, 6.780395>
    translate  <-1.323223, 0.0, -7.103617>
  }
}


#declare upne3 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  9  // control points
  <0.434132, 0.224518>,
  <-0.976256, 0.150838>,
  <-2.788206, -0.019878>,
  <-0.969824, -0.197099>,
  <0.43354, -0.240225>,
  <1.360695, -0.006979>,
  <0.434132, 0.224518>,
  <-0.976256, 0.150838>,
  <-2.788206, -0.019878>
  rotate <90,0,90>
  scale <0.712918, 1.0, 0.164975>
  rotate <180.0, -90.0, 0.0>
  translate  <-0.093665, -2.307965, 0.09962>
}
#declare joints = difference {
  sphere { // jyoint
    <0,0,0>,1
    scale <0.139033, 0.215713, 1.011178>
    translate  <0.98415, 3.173462, -0.330199>
  }
  box { // jyoint_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.231854, 0.251043, 0.251673>
    translate  <0.974526, 3.175608, -0.27984>
  }
}
#declare wind_load = object {
  sphere { // wind_load
    <0,0,0>,1
    scale <0.138862, 1.125936, 0.151718>
    translate  <0.980937, 4.519314, 1.175417>
  }
}
//
// Include file contains 'bk_wing_r'
//
#include "oworld.in1"
#declare bk_wing_r = object {
  bk_wing_r_Raw
  texture {
    wing_tex
  }
  scale <-0.035618, -0.712508, -2.104642>
  rotate -180.0*x
  translate  <1.464809, 2.581149, -0.16362>
}
#declare bk_wing_cut_t = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.185272, 1.014391>,
  <-0.287363, 1.832653>,
  <-1.0, -1.0>,
  <2.831791, -1.419464>,
  <0.652352, 0.008775>,
  <-0.067852, 0.53503>,
  <-0.185272, 1.014391>,
  <-0.287363, 1.832653>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.014825, 1.0, 0.362531>
  rotate <-90.0, -76.272385, -90.0>
  translate  <1.274335, 3.414971, -1.379942>
}
#declare bk_wing_csg = difference {
  object { bk_wing_r }
  box { // jyoint_cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.231854, 0.251043, 0.251673>
    translate  <1.46114, 1.338774, -0.030718>
  }
  object { bk_wing_cut_t }
  translate  <-0.486614, 1.836835, -0.249121>
}
#declare bv_wing = union {
  object { joints }
  cylinder { // bar
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.04, 0.04, 0.814437>
    translate  <0.984037, 3.177651, -0.693803>
  }
  cylinder { // pin
    <0,0,1>, <0,0,0>, 1
    scale <0.027495, 0.130239, 0.114151>
    rotate <48.915009, 0.0, 0.0>
    translate  <0.98198, 3.083687, 1.575759>
  }
  cylinder { // pin1
    <0,0,1>, <0,0,0>, 1
    scale <0.027495, 0.130239, 0.114151>
    rotate <132.089325, 0.0, 0.0>
    translate  <0.98198, 3.105583, -2.122128>
  }
  object { wind_load }
  object { // wind_load1->wind_load
    wind_load
    scale <1.0, 0.85, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.583694, -0.6>
  }
  object { // wind_load2->wind_load
    wind_load
    scale <1.0, 0.7225, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 1.064834, -1.2>
  }
  object { // wind_load3->wind_load
    wind_load
    scale <1.0, 0.614125, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 1.458803, -1.8>
  }
  object { // wind_load4->wind_load
    wind_load
    scale <1.0, 0.585987, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 1.554743, -2.4>
  }
  cylinder { // back_up_lope
    <0,0,1>, <0,0,0>, 1
    texture {
      rope_tex
    }
    scale <0.02, 0.02, 2.527818>
    rotate <-42.39851, 0.0, 0.0>
    translate  <0.981584, 1.380615, -0.188941>
  }
  cylinder { // back_down_rope
    <0,0,1>, <0,0,0>, 1
    texture {
      rope_tex
    }
    scale <0.01, 0.01, 2.645205>
    rotate <41.699604, 0.0, 0.0>
    translate  <0.981584, 3.143452, -2.249861>
  }
  sphere { // bhjoint
    <0,0,0>,1
    scale <0.075577, 0.230057, 0.231443>
    translate  <0.98137, 1.409792, -0.25908>
  }
  cylinder { // joint_cover
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.09, 0.09, 0.3>
    rotate 0.0*x
    translate  <0.984352, 3.174848, -0.39857>
  }
  cylinder { // bw_pipe3
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.074535, 0.032789, 1.237768>
    rotate -90.0*x
    translate  <0.981107, 3.150785, 1.47837>
  }
  cylinder { // bw_pipe2
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.074535, 0.032789, 1.248035>
    rotate -90.0*x
    translate  <0.981107, 3.140122, -1.997939>
  }
  cylinder { // bw_pipe
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.074921, 0.032789, 1.237768>
    translate  <0.981107, 3.172112, -2.02993>
  }
  cylinder { // bw_pipe1
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.074921, 0.032789, 1.237768>
    translate  <0.981107, 3.172112, 0.257034>
  }
  object { bk_wing_csg }
  translate  <0.184964, -1.836835, 0.220429>
}
#declare bhwings = union {
  object { bv_wing }
  object { // bv_wing1->bv_wing
    bv_wing
    rotate 0.0*x
    translate  <0.8, 0.0, 0.0>
  }
  object { // bv_wing2->bv_wing
    bv_wing
    rotate 0.0*x
    translate  <1.6, 0.0, 0.0>
  }
  cylinder { // h_bar
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.068789, 0.219102, 4.549681>
    rotate -90.0*y
    translate  <4.236479, 1.30684, -0.033401>
  }
  translate  0.30165*x
}
#declare ctr_fan = object {
  box { // ctr_fan
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.058844, -0.004514, -0.17844>
    rotate <-180.0, 0.0, 130.0>
    translate  <-0.000848, 0.0, 0.288679>
  }
}
#declare taiatu_mado = union {
  cylinder { // mado_gluss
    <0,0,1>, <0,0,0>, 1
    texture {
      madogluss
    }
    scale <1.0, 1.0, 0.2>
    translate  <-0.013662, 0.0, -0.119956>
  }
  torus { // MADOWAKU
    1.5, 0.2  rotate -x*90
    scale <0.72, 0.72, 0.653187>
    rotate 11.197577*z
  }
  scale <0.3, 0.3, 0.300462>
  rotate <0.0, -67.618385, 0.0>
  translate  <3.520329, -5.167743, 1.080597>
}
#declare plo_hane = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <0.28717, -0.665909>,
  <0.762329, -1.038327>,
  <0.865906, -1.563762>,
  <0.996007, -1.55905>,
  <1.046559, 2.437602>,
  <0.955826, 2.307815>,
  <0.28717, -0.665909>
  rotate -x*90
  scale <1.070383, 2.653821, -0.041154>
  rotate -40.0*y
  translate  <-0.777779, 4.25885, -0.331457>
}
#declare propela = union {
  cylinder { // proring
    <0,0,1>, <0,0,0>, 1
    scale <0.936621, 0.936621, 0.414073>
    translate  0.098209*z
  }
  object { // plo_hane6->plo_hane
    plo_hane
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // plo_hane4->plo_hane
    plo_hane
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // plo_hane2->plo_hane
    plo_hane
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { plo_hane }
  texture {
    Chrome_Tex
  }
}
#declare move_shaft = object {
  cylinder { // move_shaft
    <0,0,1>, <0,0,0>, 1
    scale <0.15, 0.15, 4.161279>
    translate  <0.003321, -0.750713, 0.251536>
  }
}
#declare move_shafts = union {
  object { // move_shaft1->move_shaft
    move_shaft
    rotate 0.0*x
    translate  <-0.005424, 1.506071, 0.0>
  }
  object { move_shaft }
  texture {
    Chrome_Tex
  }
  scale <1.0, 1.009821, 1.0>
}
#declare rope_covers = difference {
  cylinder { // rope_cover
    <0,0,1>, <0,0,0>, 1
    scale <0.267036, 0.267036, 0.415209>
    rotate <90.0, 0.0, 0.0>
    translate  <0.683094, -2.583744, 0.027902>
  }
  box { // cover_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.208993, 0.079283, 0.285986>
    translate  <0.893429, -2.805343, 0.026445>
  }
  scale <4.761905, 3.062556, 4.761905>
  rotate <-90.0, 0.0, 0.0>
  translate  <-3.253249, -0.12522, -13.060281>
}
#declare pros = union {
  object { propela }
  object { // propela3->propela
    propela
    rotate -90.0*z
    translate  12.0*z
  }
  object { // propela2->propela
    propela
    rotate -60.0*z
    translate  8.0*z
  }
  object { // propela1->propela
    propela
    rotate -30.0*z
    translate  4.0*z
  }
  object { // move_shafts3->move_shafts
    move_shafts
    scale <1.0, 1.0, 1.2>
    rotate -180.0*z
    translate  <0.0, 0.0, -5.107374>
  }
  object { // move_shafts2->move_shafts
    move_shafts
    rotate -120.0*z
    translate  8.0*z
  }
  object { // move_shafts1->move_shafts
    move_shafts
    rotate -60.0*z
    translate  4.0*z
  }
  object { move_shafts }
  cylinder { // shaft
    <0,0,1>, <0,0,0>, 1
    scale <0.292405, 0.292405, 22.570311>
    translate  <0.0, 0.0, -6.644926>
  }
  cone { // bk_jikuuke
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.271605, 1.297028, 2.467506>
    rotate <0.0, 0.0, 0.0>
    translate  <0.020389, -0.030706, -7.605958>
  }
  cylinder { // move_ring
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.906148, 0.906148, 1.297165>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.000421, 0.007646, -4.951559>
  }
  object { rope_covers }
  cylinder { // move_ring1
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Tex
    }
    scale <0.577476, 0.577476, 0.806161>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.023898, 0.007646, 15.029926>
  }
  scale <0.21, 0.21, 0.326525>
  rotate 90.0*x
  translate  <0.683182, -4.264504, 0.026296>
}
#declare side_move_out = object {
  cylinder { // side_move_out
    <0,0,1>, <0,0,0>, 1
    texture {
      rope_tex
    }
    scale <0.02, 0.05, 7.876238>
    rotate -90.0*y
    translate  <8.506402, -2.805714, 0.236793>
  }
}
#declare fan_rope = object {
  cylinder { // fan_rope
    <0,0,1>, <0,0,0>, 1
    scale <0.022297, 0.02, 3.519315>
    rotate <0.0, 84.039139, 0.0>
    translate  <1.165189, -9.478816, 0.306944>
  }
}
#declare sub_bar = object {
  cylinder { // sub_bar
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 3.766345>
    rotate <0.0, 79.929581, 0.0>
    translate  <0.74762, -2.27352, 0.039232>
  }
}
#declare bhjoint3 = object {
  sphere { // bhjoint3
    <0,0,0>,1
    scale <0.199554, 0.119974, 0.254726>
    translate  <3.422993, -9.487483, 0.525636>
  }
}
#declare bhjoint1 = object {
  sphere { // bhjoint1
    <0,0,0>,1
    scale <0.251995, 0.119974, 0.167324>
    translate  <3.95718, -2.265078, 0.589629>
  }
}


#declare aircut = union {
  box { // aircut3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.139642, 2.007559, 0.264146>
    rotate -90.0*z
    translate  <17.596441, -18.522252, -5.798527>
  }
  box { // aircut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.139642, 2.007559, 0.264146>
    translate  <17.596441, -18.522252, -5.798527>
  }
  cylinder { // airlight
    <0,0,1>, <0,0,0>, 1
    texture {
      Meca_Chrome2
    }
    scale <1.69868, 1.69868, 0.22271>
    translate  <17.585496, -18.589749, -5.950117>
  }
  texture {
    Meca_Chrome1
  }
}
#declare hlight = difference {
  cylinder { // airlight1
    <0,0,1>, <0,0,0>, 1
    texture {
      LightT
    }
    scale <1.9, 1.9, 0.249104>
    translate  <17.61358, -18.589749, -6.02041>
  }
  object { aircut }
}
#declare airport = union {
  cone { // airport1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal1
    }
    scale <2.7, 2.713097, 1.0>
    translate  <14.047755, -21.016628, -3.128152>
  }
  translate  <3.507149, 2.456343, -3.724301>
}
#declare port = union {
  object { hlight }
  object { airport }
  cylinder { // airtube
    <0,0,1>, <0,0,0>, 1
    texture {
      Meca_Chrome3
    }
    scale <1.285848, 1.3, 7.404656>
    translate  <17.584621, -18.570654, -13.559415>
  }
  translate  <-1.402933, 2.505238, -2.698482>
}
#declare CYLi = object {
  sphere { // CYLi
    <0,0,0>,1
    scale <31.934948, 2.586661, 11.533484>
    rotate 180.0*x
    translate  -16.778696*z
  }
}
#declare LightSP = object {
  sphere { // LightSP
    <0,0,0>,1
    texture {
      LightT
    }
    scale <1.452907, 0.594319, 0.287568>
    translate  <12.536996, 0.0, -5.337538>
  }
}
#declare pipe = object {
  cylinder { // pipe
    <0,0,1>, <0,0,0>, 1
    texture {
      Meca_Chrome2
    }
    scale <-0.1, -0.5, -9.133039>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.0, -2.867382, -2.952883>
  }
}
#declare tank = difference {
  sphere { // MecaSphere
    <0,0,0>,1
    scale <-1.0, -4.09622, -8.64433>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, -10.130291, -5.77986>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.27372, 4.389914, 4.497713>
    rotate 180.0*x
    translate  <-0.06843, -10.277138, -10.940657>
  }
  texture {
    Meca_Chrome2
  }
  scale <1.0, 0.461009, 0.784403>
  translate  <0.0, -7.438082, -0.431193>
}
#declare city_pro = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.136901, -1.002522>,
  <-0.133408, -2.016005>,
  <0.085341, -2.021017>,
  <0.08845, -0.991983>,
  <0.325329, -0.754397>,
  <0.32842, 0.729176>,
  <0.043743, 1.8847>,
  <-0.435845, 1.879604>,
  <-0.429858, 0.213076>,
  <-0.136901, -1.002522>
  rotate -x*90
  scale <2.0, 3.0, 0.03757>
  rotate <0.0, 100.0, 0.0>
  translate  <0.009162, 6.975351, 0.0>
}




// ********  OBJECTS  *******

#declare guide_board = lathe {
  cubic_spline
  8  // control points
  <0.029357, -0.982108>,
  <0.024054, -0.412314>,
  <1.045395, -0.189099>,
  <2.00355, 0.180629>,
  <2.365306, 0.917588>,
  <2.063506, 1.010468>,
  <0.011106, 1.008963>,
  <0.031895, 1.004632>
  rotate <90,0,90>
  texture {
    sahnpan_body
  }
  scale <0.335358, 0.139792, 0.163642>
  rotate 39.725079*x
  translate  <-0.012297, -0.03689, 0.405787>
}
#declare guide = union {
  box { // guide_board_in
    <-1, -1, -1>, <1, 1, 1>
    texture {
      message_tex
  translate <-1.005946, -1.004452, 0.748169>
    }
    scale <0.43851, 0.193783, 0.030012>
    rotate 39.530025*x
    translate  <-0.009006, -0.132476, 0.532851>
  }
  object { guide_board }
  cylinder { // guide_pole
    <0,0,1>, <0,0,0>, 1
    texture {
      sahnpan_body
    }
    scale <0.363306, 0.049066, 0.453275>
    translate  <0.0, -0.008198, 0.004099>
  }
  scale 0.15
  rotate -136.216629*z
  translate  <-4.724752, 34.916896, 3.799089>
}
#declare bousi1 = lathe {
  cubic_spline
  6  // control points
  <1.0, -1.0>,
  <1.79879, -0.19067>,
  <2.014965, 0.185429>,
  <1.756658, 0.425663>,
  <0.003834, 0.608804>,
  <0.996007, 0.648597>
  rotate <90,0,90>
  texture {
    hat
  }
  scale <0.440771, 0.4, 0.663306>
  rotate <-16.554201, 0.0, 0.0>
  translate  <0.075903, -0.252698, 12.292764>
}
#declare ude4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.902260, 0.000000, 0.391337>, <-0.902260, -0.388754, 0.391337>, <-0.496243, -0.706825, 0.391337>, <0.000000, -0.706825, 0.391337>,
      <-0.902260, 0.000000, 0.745139>, <-0.902260, -0.388754, 0.745139>, <-0.496243, -0.706825, 0.745139>, <0.000000, -0.706825, 0.745139>,
      <-0.902260, 0.000000, 1.175028>, <-0.902260, -0.461858, 1.175028>, <-0.496243, -0.839743, 1.175028>, <0.000000, -0.839743, 1.175028>,
      <-0.902260, 0.000000, 1.452743>, <-0.902260, -0.461858, 1.452743>, <-0.496243, -0.839743, 1.452743>, <0.000000, -0.839743, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.706825, 0.391337>, <0.496243, -0.706825, 0.391337>, <0.902260, -0.388754, 0.391337>, <0.902260, 0.000000, 0.391337>,
      <0.000000, -0.706825, 0.745139>, <0.496243, -0.706825, 0.745139>, <0.902260, -0.388754, 0.745139>, <0.902260, 0.000000, 0.745139>,
      <0.000000, -0.839743, 1.175028>, <0.496243, -0.839743, 1.175028>, <0.902260, -0.461858, 1.175028>, <0.902260, 0.000000, 1.175028>,
      <0.000000, -0.839743, 1.452743>, <0.496243, -0.839743, 1.452743>, <0.902260, -0.461858, 1.452743>, <0.902260, 0.000000, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.902260, 0.000000, 0.391337>, <0.902260, 0.388754, 0.391337>, <0.496243, 0.706825, 0.391337>, <0.000000, 0.706825, 0.391337>,
      <0.902260, 0.000000, 0.745139>, <0.902260, 0.388754, 0.745139>, <0.496243, 0.706825, 0.745139>, <0.000000, 0.706825, 0.745139>,
      <0.902260, 0.000000, 1.175028>, <0.902260, 0.461858, 1.175028>, <0.496243, 0.839743, 1.175028>, <0.000000, 0.839743, 1.175028>,
      <0.902260, 0.000000, 1.452743>, <0.902260, 0.461858, 1.452743>, <0.496243, 0.839743, 1.452743>, <0.000000, 0.839743, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.706825, 0.391337>, <-0.496243, 0.706825, 0.391337>, <-0.902260, 0.388754, 0.391337>, <-0.902260, 0.000000, 0.391337>,
      <0.000000, 0.706825, 0.745139>, <-0.496243, 0.706825, 0.745139>, <-0.902260, 0.388754, 0.745139>, <-0.902260, 0.000000, 0.745139>,
      <0.000000, 0.839743, 1.175028>, <-0.496243, 0.839743, 1.175028>, <-0.902260, 0.461858, 1.175028>, <-0.902260, 0.000000, 1.175028>,
      <0.000000, 0.839743, 1.452743>, <-0.496243, 0.839743, 1.452743>, <-0.902260, 0.461858, 1.452743>, <-0.902260, 0.000000, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.902260, 0.000000, 1.452743>, <-0.902260, -0.461858, 1.452743>, <-0.496243, -0.839743, 1.452743>, <0.000000, -0.839743, 1.452743>,
      <-0.902260, 0.000000, 1.730459>, <-0.902260, -0.461858, 1.730459>, <-0.496243, -0.839743, 1.730459>, <0.000000, -0.839743, 1.730459>,
      <-0.902260, 0.000000, 2.238424>, <-0.902260, -0.566601, 2.238424>, <-0.496243, -0.977676, 2.209323>, <0.000000, -0.977676, 2.209323>,
      <-0.913733, 0.000000, 2.736289>, <-0.913733, -0.544598, 2.736289>, <-0.502553, -0.963925, 2.721738>, <0.000000, -0.963925, 2.721738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.839743, 1.452743>, <0.496243, -0.839743, 1.452743>, <0.902260, -0.461858, 1.452743>, <0.902260, 0.000000, 1.452743>,
      <0.000000, -0.839743, 1.730459>, <0.496243, -0.839743, 1.730459>, <0.902260, -0.461858, 1.730459>, <0.902260, 0.000000, 1.730459>,
      <0.000000, -0.977676, 2.209323>, <0.496243, -0.977676, 2.209323>, <0.902260, -0.566601, 2.238424>, <0.902260, 0.000000, 2.238424>,
      <0.000000, -0.963925, 2.721738>, <0.502553, -0.963925, 2.721738>, <0.913733, -0.544598, 2.736289>, <0.913733, 0.000000, 2.736289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.902260, 0.000000, 1.452743>, <0.902260, 0.461858, 1.452743>, <0.496243, 0.839743, 1.452743>, <0.000000, 0.839743, 1.452743>,
      <0.902260, 0.000000, 1.730459>, <0.902260, 0.461858, 1.730459>, <0.496243, 0.839743, 1.730459>, <0.000000, 0.839743, 1.730459>,
      <0.902260, 0.000000, 2.238424>, <0.902260, 0.566601, 2.238424>, <0.496243, 1.030183, 2.238424>, <0.000000, 1.030183, 2.238424>,
      <0.913733, 0.000000, 2.736289>, <0.913733, 0.544598, 2.736289>, <0.502553, 0.990178, 2.736289>, <0.000000, 0.990178, 2.736289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.839743, 1.452743>, <-0.496243, 0.839743, 1.452743>, <-0.902260, 0.461858, 1.452743>, <-0.902260, 0.000000, 1.452743>,
      <0.000000, 0.839743, 1.730459>, <-0.496243, 0.839743, 1.730459>, <-0.902260, 0.461858, 1.730459>, <-0.902260, 0.000000, 1.730459>,
      <0.000000, 1.030183, 2.238424>, <-0.496243, 1.030183, 2.238424>, <-0.902260, 0.566601, 2.238424>, <-0.902260, 0.000000, 2.238424>,
      <0.000000, 0.990178, 2.736289>, <-0.502553, 0.990178, 2.736289>, <-0.913733, 0.544598, 2.736289>, <-0.913733, 0.000000, 2.736289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.913733, 0.000000, 2.736289>, <-0.913733, -0.544598, 2.736289>, <-0.502553, -0.963925, 2.721738>, <0.000000, -0.963925, 2.721738>,
      <-0.925206, 0.000000, 3.234153>, <-0.925206, -0.522595, 3.234153>, <-0.508863, -0.950173, 3.234153>, <0.000000, -0.950173, 3.234153>,
      <-0.912831, 0.000000, 4.026857>, <-0.912831, -0.550000, 4.026857>, <-0.502057, -1.000000, 4.026857>, <0.000000, -1.000000, 4.026857>,
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-0.550000, -1.000000, 4.500000>, <0.000000, -1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.963925, 2.721738>, <0.502553, -0.963925, 2.721738>, <0.913733, -0.544598, 2.736289>, <0.913733, 0.000000, 2.736289>,
      <0.000000, -0.950173, 3.234153>, <0.508863, -0.950173, 3.234153>, <0.925206, -0.522595, 3.234153>, <0.925206, 0.000000, 3.234153>,
      <0.000000, -1.000000, 4.026857>, <0.502057, -1.000000, 4.026857>, <0.912831, -0.550000, 4.026857>, <0.912831, 0.000000, 4.026857>,
      <0.000000, -1.000000, 4.500000>, <0.550000, -1.000000, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.913733, 0.000000, 2.736289>, <0.913733, 0.544598, 2.736289>, <0.502553, 0.990178, 2.736289>, <0.000000, 0.990178, 2.736289>,
      <0.925206, 0.000000, 3.234153>, <0.925206, 0.522595, 3.234153>, <0.508863, 0.950173, 3.234153>, <0.000000, 0.950173, 3.234153>,
      <0.912831, 0.000000, 4.026857>, <0.912831, 0.550000, 4.026857>, <0.502057, 1.000000, 4.026857>, <0.000000, 1.000000, 4.026857>,
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.550000, 1.000000, 4.500000>, <0.000000, 1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.990178, 2.736289>, <-0.502553, 0.990178, 2.736289>, <-0.913733, 0.544598, 2.736289>, <-0.913733, 0.000000, 2.736289>,
      <0.000000, 0.950173, 3.234153>, <-0.508863, 0.950173, 3.234153>, <-0.925206, 0.522595, 3.234153>, <-0.925206, 0.000000, 3.234153>,
      <0.000000, 1.000000, 4.026857>, <-0.502057, 1.000000, 4.026857>, <-0.912831, 0.550000, 4.026857>, <-0.912831, 0.000000, 4.026857>,
      <0.000000, 1.000000, 4.500000>, <-0.550000, 1.000000, 4.500000>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>
    }
  }
  scale <0.287957, 0.260576, 0.389511>
  rotate <-4.460895, -12.248513, 8.300891>
  translate  <1.48364, -0.350324, 7.422516>
}
#declare momo10 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.150887, 0.230326, -0.018524>, <-0.145697, 0.125182, -0.014919>, <-0.103348, 0.043424, -0.012116>, <-0.000009, 0.043424, -0.012116>,
      <-0.211950, 0.210825, 0.386757>, <-0.204660, 0.107193, 0.376660>, <-0.145173, 0.026611, 0.368809>, <-0.000013, 0.026611, 0.368809>,
      <-0.231603, 0.175131, 1.038066>, <-0.223637, 0.063136, 1.024418>, <-0.158633, -0.023950, 1.013805>, <-0.000014, -0.023950, 1.013805>,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000009, 0.043424, -0.012116>, <0.103330, 0.043424, -0.012116>, <0.146775, 0.130309, -0.015095>, <0.150810, 0.241644, -0.018912>,
      <-0.000013, 0.026611, 0.368809>, <0.145147, 0.026611, 0.368809>, <0.206174, 0.112246, 0.377153>, <0.211843, 0.221980, 0.387844>,
      <-0.000014, -0.023950, 1.013805>, <0.158606, -0.023950, 1.013805>, <0.225291, 0.068597, 1.025083>, <0.231486, 0.187187, 1.039535>,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.150810, 0.241644, -0.018912>, <0.154846, 0.352979, -0.022729>, <0.115415, 0.405634, -0.017058>, <-0.000028, 0.405634, -0.017058>,
      <0.211843, 0.221980, 0.387844>, <0.217512, 0.331714, 0.398536>, <0.162123, 0.404429, 0.408185>, <-0.000040, 0.404429, 0.408185>,
      <0.231486, 0.187187, 1.039535>, <0.237681, 0.305776, 1.053986>, <0.177156, 0.401478, 1.073866>, <-0.000044, 0.401478, 1.073866>,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000028, 0.405634, -0.017058>, <-0.115472, 0.405634, -0.017058>, <-0.156077, 0.335470, -0.022129>, <-0.150887, 0.230326, -0.018524>,
      <-0.000040, 0.404429, 0.408185>, <-0.162203, 0.404429, 0.408185>, <-0.219241, 0.314456, 0.396855>, <-0.211950, 0.210825, 0.386757>,
      <-0.000044, 0.401478, 1.073866>, <-0.177243, 0.401478, 1.073866>, <-0.239569, 0.287126, 1.051713>, <-0.231603, 0.175131, 1.038066>,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>,
      <-0.331731, 0.202532, 2.831148>, <-0.320321, 0.015753, 2.831148>, <-0.227215, -0.102524, 2.819123>, <-0.000020, -0.102524, 2.819123>,
      <-0.323254, 0.124480, 3.222072>, <-0.312136, 0.009682, 3.222072>, <-0.221408, -0.079583, 3.222072>, <-0.000019, -0.079583, 3.222072>,
      <-0.233289, 0.161055, 3.514342>, <-0.224392, 0.070207, 3.514342>, <-0.159169, -0.001095, 3.514342>, <-0.000014, -0.001095, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>,
      <-0.000020, -0.102524, 2.819123>, <0.227175, -0.102524, 2.819123>, <0.322690, 0.024861, 2.831148>, <0.331563, 0.222638, 2.831148>,
      <-0.000019, -0.079583, 3.222072>, <0.221370, -0.079583, 3.222072>, <0.314444, 0.015280, 3.222072>, <0.323090, 0.136837, 3.222072>,
      <-0.000014, -0.001095, 3.514342>, <0.159141, -0.001095, 3.514342>, <0.226052, 0.074678, 3.514342>, <0.232267, 0.171774, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>,
      <0.331563, 0.222638, 2.831148>, <0.340436, 0.420415, 2.831148>, <0.253745, 0.725712, 2.796334>, <-0.000063, 0.725712, 2.796334>,
      <0.323090, 0.136837, 3.222072>, <0.331736, 0.258395, 3.222072>, <0.247261, 0.420547, 3.222072>, <-0.000061, 0.420547, 3.222072>,
      <0.232267, 0.171774, 3.514342>, <0.238483, 0.268869, 3.514342>, <0.177754, 0.398391, 3.514342>, <-0.000044, 0.398391, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>,
      <-0.000063, 0.725712, 2.796334>, <-0.253870, 0.725712, 2.796334>, <-0.343141, 0.389312, 2.831148>, <-0.331731, 0.202532, 2.831148>,
      <-0.000061, 0.420547, 3.222072>, <-0.247383, 0.420547, 3.222072>, <-0.334372, 0.239278, 3.222072>, <-0.323254, 0.124480, 3.222072>,
      <-0.000044, 0.398391, 3.514342>, <-0.177842, 0.398391, 3.514342>, <-0.242185, 0.251903, 3.514342>, <-0.233289, 0.161055, 3.514342>
    }
  }
  scale <0.8, 0.663339, 0.549969>
  rotate <32.829437, -3.135816, 142.676239>
  translate  <0.972813, -1.180343, 6.086959>
}
#declare ude2 = union {
  object { ude4 }
  object { momo10 }
  texture {
    suhada
  }
  translate  <-0.268603, 0.055641, 0.553074>
}
#declare hair = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.964225, -5.903881, 2.973370>, <-2.490845, -5.937703, 1.573960>, <-2.030343, -5.937703, 2.041230>, <-1.535555, -5.901196, 1.340325>,
      <-3.116393, -5.283057, 3.140531>, <-3.916885, -5.294768, 1.647740>, <-3.053356, -5.294768, 0.885353>, <-2.330874, -5.294768, 0.479566>,
      <-3.941197, -4.073173, 3.520731>, <-4.937747, -4.027642, 1.700298>, <-3.988185, -4.061090, 0.446049>, <-3.001462, -4.044366, 0.286194>,
      <-4.016084, -3.035070, 3.646452>, <-4.889294, -3.057897, 0.850149>, <-3.989994, -3.063336, 0.370583>, <-2.998681, -3.038578, 0.216876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-4.016084, -3.035070, 3.646452>, <-4.889294, -3.057897, 0.850149>, <-3.989994, -3.063336, 0.370583>, <-2.998681, -3.038578, 0.216876>,
      <-4.090971, -1.996967, 3.772172>, <-4.840841, -2.088152, 0.000000>, <-3.991802, -2.065582, 0.295118>, <-2.995901, -2.032791, 0.147559>,
      <-4.116856, -0.997699, 3.772172>, <-4.966002, -1.096015, 0.000000>, <-3.877034, -0.836046, 0.024593>, <-2.938517, -0.918023, 0.012297>,
      <-4.142740, 0.015563, 3.699507>, <-5.091164, -0.103879, 0.000000>, <-3.938517, 0.081977, 0.012297>, <-2.969259, 0.040989, 0.006148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-4.142740, 0.015563, 3.699507>, <-5.091164, -0.103879, 0.000000>, <-3.938517, 0.081977, 0.012297>, <-2.969259, 0.040989, 0.006148>,
      <-4.168625, 1.028825, 3.626841>, <-5.216326, 0.888257, 0.000000>, <-4.000000, 1.000000, 0.000000>, <-3.000000, 1.000000, 0.000000>,
      <-4.194510, 2.017324, 3.480532>, <-5.341488, 1.880394, 0.000000>, <-4.000000, 2.000000, 0.000000>, <-3.000000, 2.000000, 0.000000>,
      <-4.267627, 2.778779, 3.334223>, <-5.503757, 2.577183, 0.000000>, <-4.048165, 2.785505, 0.000000>, <-3.050774, 2.836520, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-4.267627, 2.778779, 3.334223>, <-5.503757, 2.577183, 0.000000>, <-4.048165, 2.785505, 0.000000>, <-3.050774, 2.836520, 0.000000>,
      <-4.340745, 3.540234, 3.187914>, <-5.666026, 3.273972, 0.000000>, <-4.096330, 3.571010, 0.000000>, <-3.101548, 3.673039, 0.000000>,
      <-4.467350, 4.520934, 3.041605>, <-5.891761, 4.248161, 0.000000>, <-4.198359, 4.565792, 0.000000>, <-3.203577, 4.667821, 0.000000>,
      <-4.593955, 5.501633, 2.895296>, <-6.117496, 5.222350, 0.000000>, <-4.300387, 5.290969, 0.000000>, <-3.305606, 5.643345, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.535555, -5.901196, 1.340325>, <-1.040767, -5.864689, 0.639421>, <-0.533182, -5.864689, 0.516456>, <-0.019197, -5.864689, 0.479566>,
      <-2.330874, -5.294768, 0.479566>, <-1.608392, -5.294768, 0.073779>, <-0.823973, -5.294768, -0.049186>, <-0.029667, -5.294768, -0.086076>,
      <-3.001462, -4.044366, 0.286194>, <-2.014738, -4.027642, 0.126338>, <-1.032143, -4.027642, 0.003373>, <-0.037162, -4.027642, -0.033517>,
      <-2.998681, -3.038578, 0.216876>, <-2.007369, -3.013821, 0.063169>, <-1.028368, -3.013821, -0.059797>, <-0.037026, -3.013821, -0.096686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-2.998681, -3.038578, 0.216876>, <-2.007369, -3.013821, 0.063169>, <-1.028368, -3.013821, -0.059797>, <-0.037026, -3.013821, -0.096686>,
      <-2.995901, -2.032791, 0.147559>, <-2.000000, -2.000000, 0.000000>, <-1.024593, -2.000000, -0.122966>, <-0.036890, -2.000000, -0.159855>,
      <-2.938517, -0.918023, 0.012297>, <-2.000000, -1.000000, 0.000000>, <-1.024593, -1.000000, -0.122966>, <-0.036890, -1.000000, -0.159855>,
      <-2.969259, 0.040989, 0.006148>, <-2.000000, 0.000000, 0.000000>, <-1.012297, 0.000000, -0.061483>, <-0.018445, 0.000000, -0.079928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-2.969259, 0.040989, 0.006148>, <-2.000000, 0.000000, 0.000000>, <-1.012297, 0.000000, -0.061483>, <-0.018445, 0.000000, -0.079928>,
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>,
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>,
      <-3.050774, 2.836520, 0.000000>, <-2.053383, 2.887534, 0.000000>, <-1.055993, 2.938548, 0.000000>, <-0.019101, 2.936672, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-3.050774, 2.836520, 0.000000>, <-2.053383, 2.887534, 0.000000>, <-1.055993, 2.938548, 0.000000>, <-0.019101, 2.936672, 0.000000>,
      <-3.101548, 3.673039, 0.000000>, <-2.106767, 3.775068, 0.000000>, <-1.111985, 3.877097, 0.000000>, <-0.038201, 3.873345, 0.000000>,
      <-3.203577, 4.667821, 0.000000>, <-2.208796, 4.769849, 0.000000>, <-1.214014, 4.871878, 0.000000>, <-0.035561, 4.867848, 0.000000>,
      <-3.305606, 5.643345, 0.000000>, <-2.310825, 5.995721, 0.000000>, <-1.316043, 5.674085, 0.000000>, <-0.071435, 5.900867, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.019197, -5.864689, 0.479566>, <0.494788, -5.864689, 0.442676>, <1.053565, -5.864689, 0.713201>, <1.593146, -5.901196, 1.377215>,
      <-0.029667, -5.294768, -0.086076>, <0.764640, -5.294768, -0.122966>, <1.628169, -5.294768, 0.147559>, <2.504190, -5.294768, 0.516456>,
      <-0.037162, -4.027642, -0.033517>, <0.957820, -4.027642, -0.070407>, <2.039512, -4.027642, 0.200118>, <2.993554, -4.044366, 0.323083>,
      <-0.037026, -3.013821, -0.096686>, <0.954317, -3.013821, -0.133576>, <2.032053, -3.013821, 0.136949>, <2.982380, -3.030381, 0.253766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.037026, -3.013821, -0.096686>, <0.954317, -3.013821, -0.133576>, <2.032053, -3.013821, 0.136949>, <2.982380, -3.030381, 0.253766>,
      <-0.036890, -2.000000, -0.159855>, <0.950814, -2.000000, -0.196745>, <2.024593, -2.000000, 0.073779>, <2.971205, -2.016395, 0.184448>,
      <-0.036890, -1.000000, -0.159855>, <0.950814, -1.000000, -0.196745>, <2.024593, -1.000000, 0.073779>, <3.024593, -1.000000, 0.049186>,
      <-0.018445, 0.000000, -0.079928>, <0.975407, 0.000000, -0.098373>, <2.012297, 0.000000, 0.036890>, <3.012297, 0.000000, 0.024593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.018445, 0.000000, -0.079928>, <0.975407, 0.000000, -0.098373>, <2.012297, 0.000000, 0.036890>, <3.012297, 0.000000, 0.024593>,
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>,
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>,
      <-0.019101, 2.936672, 0.000000>, <1.017791, 2.934796, 0.000000>, <2.014904, 2.881142, 0.000000>, <3.012017, 2.827487, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.019101, 2.936672, 0.000000>, <1.017791, 2.934796, 0.000000>, <2.014904, 2.881142, 0.000000>, <3.012017, 2.827487, 0.000000>,
      <-0.038201, 3.873345, 0.000000>, <1.035583, 3.869593, 0.000000>, <2.029808, 3.762283, 0.000000>, <3.024034, 3.654973, 0.000000>,
      <-0.035561, 4.867848, 0.000000>, <1.142892, 4.863818, 0.000000>, <2.137118, 4.756509, 0.000000>, <3.131344, 4.649199, 0.000000>,
      <-0.071435, 5.900867, 0.000000>, <1.173172, 6.127649, 0.000000>, <2.128883, 5.558160, 0.000000>, <3.103851, 5.739712, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.593146, -5.901196, 1.377215>, <2.132726, -5.937703, 2.041230>, <2.712992, -5.937703, 1.573960>, <2.260890, -5.903881, 2.973370>,
      <2.504190, -5.294768, 0.516456>, <3.380210, -5.294768, 0.885353>, <4.125073, -5.294768, 1.647740>, <3.413058, -5.283057, 3.140531>,
      <2.993554, -4.044366, 0.323083>, <3.947595, -4.061090, 0.446049>, <5.135942, -4.027642, 1.700298>, <4.287131, -4.122442, 3.520731>,
      <2.982380, -3.030381, 0.253766>, <3.932706, -3.046940, 0.370583>, <5.165833, -3.013821, 0.850149>, <4.311185, -3.372217, 3.672731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <2.982380, -3.030381, 0.253766>, <3.932706, -3.046940, 0.370583>, <5.165833, -3.013821, 0.850149>, <4.311185, -3.372217, 3.672731>,
      <2.971205, -2.016395, 0.184448>, <3.917818, -2.032791, 0.295118>, <5.195724, -2.000000, 0.000000>, <4.335240, -2.621993, 3.824731>,
      <3.024593, -1.000000, 0.049186>, <4.024593, -1.000000, 0.024593>, <5.256606, -0.960310, 0.000000>, <4.379099, -0.993390, 3.772172>,
      <3.012297, 0.000000, 0.024593>, <4.012297, 0.000000, 0.012297>, <5.317311, 0.037846, 0.000000>, <4.422959, 0.018493, 3.699392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <3.012297, 0.000000, 0.024593>, <4.012297, 0.000000, 0.012297>, <5.317311, 0.037846, 0.000000>, <4.422959, 0.018493, 3.699392>,
      <3.000000, 1.000000, 0.000000>, <4.000000, 1.000000, 0.000000>, <5.378016, 1.036002, 0.000000>, <4.466819, 1.030376, 3.626612>,
      <3.000000, 2.000000, 0.000000>, <4.000000, 2.000000, 0.000000>, <5.438721, 2.034157, 0.000000>, <4.510678, 2.017518, 3.480503>,
      <3.012017, 2.827487, 0.000000>, <4.009130, 2.773832, 0.000000>, <5.505687, 2.722348, 0.000000>, <4.561500, 2.746409, 3.334395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <3.012017, 2.827487, 0.000000>, <4.009130, 2.773832, 0.000000>, <5.505687, 2.722348, 0.000000>, <4.561500, 2.746409, 3.334395>,
      <3.024034, 3.654973, 0.000000>, <4.018260, 3.547664, 0.000000>, <5.572652, 3.410539, 0.000000>, <4.612322, 3.475300, 3.188287>,
      <3.131344, 4.649199, 0.000000>, <4.125569, 4.541889, 0.000000>, <5.740119, 4.396417, 0.000000>, <4.678531, 4.461030, 3.042178>,
      <3.103851, 5.739712, 0.000000>, <4.078819, 5.921264, 0.000000>, <5.907585, 5.382295, 0.000000>, <4.828067, 5.668855, 2.896070>
    }
  }
  texture {
    hair_tex
    scale <1.0, 3.882094, 1.093776>
    rotate <-1.080682, 0.290629, -89.881706>
  translate <0.436052, 0.320330, 0.007407>
  }
  scale <0.1696, 0.256426, 0.302987>
  rotate <-91.565079, 0.0, 180.0>
  translate  <0.150695, 0.275379, 10.682305>
}
#declare atama = lathe {
  cubic_spline
  6  // control points
  <1.0, -1.0>,
  <1.141469, -0.999647>,
  <1.820675, -0.4933>,
  <2.210003, 0.62674>,
  <1.726989, 1.024603>,
  <1.0, 1.0>
  rotate <90,0,90>
  texture {
    suhada
  }
  scale <0.274547, 0.261858, 0.627747>
  translate  <0.142993, -0.541095, 10.991212>
}
#declare head = union {
  object { hair }
  object { atama }
  scale 1.2
  translate  <-0.056938, 0.12353, -2.248963>
}
#declare ude3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.902260, 0.000000, 0.391337>, <-0.902260, -0.388754, 0.391337>, <-0.496243, -0.706825, 0.391337>, <0.000000, -0.706825, 0.391337>,
      <-0.902260, 0.000000, 0.745139>, <-0.902260, -0.388754, 0.745139>, <-0.496243, -0.706825, 0.745139>, <0.000000, -0.706825, 0.745139>,
      <-0.902260, 0.000000, 1.175028>, <-0.902260, -0.461858, 1.175028>, <-0.496243, -0.839743, 1.175028>, <0.000000, -0.839743, 1.175028>,
      <-0.902260, 0.000000, 1.452743>, <-0.902260, -0.461858, 1.452743>, <-0.496243, -0.839743, 1.452743>, <0.000000, -0.839743, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.706825, 0.391337>, <0.496243, -0.706825, 0.391337>, <0.902260, -0.388754, 0.391337>, <0.902260, 0.000000, 0.391337>,
      <0.000000, -0.706825, 0.745139>, <0.496243, -0.706825, 0.745139>, <0.902260, -0.388754, 0.745139>, <0.902260, 0.000000, 0.745139>,
      <0.000000, -0.839743, 1.175028>, <0.496243, -0.839743, 1.175028>, <0.902260, -0.461858, 1.175028>, <0.902260, 0.000000, 1.175028>,
      <0.000000, -0.839743, 1.452743>, <0.496243, -0.839743, 1.452743>, <0.902260, -0.461858, 1.452743>, <0.902260, 0.000000, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.902260, 0.000000, 0.391337>, <0.902260, 0.388754, 0.391337>, <0.496243, 0.706825, 0.391337>, <0.000000, 0.706825, 0.391337>,
      <0.902260, 0.000000, 0.745139>, <0.902260, 0.388754, 0.745139>, <0.496243, 0.706825, 0.745139>, <0.000000, 0.706825, 0.745139>,
      <0.902260, 0.000000, 1.175028>, <0.902260, 0.461858, 1.175028>, <0.496243, 0.839743, 1.175028>, <0.000000, 0.839743, 1.175028>,
      <0.902260, 0.000000, 1.452743>, <0.902260, 0.461858, 1.452743>, <0.496243, 0.839743, 1.452743>, <0.000000, 0.839743, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.706825, 0.391337>, <-0.496243, 0.706825, 0.391337>, <-0.902260, 0.388754, 0.391337>, <-0.902260, 0.000000, 0.391337>,
      <0.000000, 0.706825, 0.745139>, <-0.496243, 0.706825, 0.745139>, <-0.902260, 0.388754, 0.745139>, <-0.902260, 0.000000, 0.745139>,
      <0.000000, 0.839743, 1.175028>, <-0.496243, 0.839743, 1.175028>, <-0.902260, 0.461858, 1.175028>, <-0.902260, 0.000000, 1.175028>,
      <0.000000, 0.839743, 1.452743>, <-0.496243, 0.839743, 1.452743>, <-0.902260, 0.461858, 1.452743>, <-0.902260, 0.000000, 1.452743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.902260, 0.000000, 1.452743>, <-0.902260, -0.461858, 1.452743>, <-0.496243, -0.839743, 1.452743>, <0.000000, -0.839743, 1.452743>,
      <-0.902260, 0.000000, 1.730459>, <-0.902260, -0.461858, 1.730459>, <-0.496243, -0.839743, 1.730459>, <0.000000, -0.839743, 1.730459>,
      <-0.902260, 0.000000, 2.238424>, <-0.902260, -0.566601, 2.238424>, <-0.496243, -0.977676, 2.209323>, <0.000000, -0.977676, 2.209323>,
      <-0.913733, 0.000000, 2.736289>, <-0.913733, -0.544598, 2.736289>, <-0.502553, -0.963925, 2.721738>, <0.000000, -0.963925, 2.721738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.839743, 1.452743>, <0.496243, -0.839743, 1.452743>, <0.902260, -0.461858, 1.452743>, <0.902260, 0.000000, 1.452743>,
      <0.000000, -0.839743, 1.730459>, <0.496243, -0.839743, 1.730459>, <0.902260, -0.461858, 1.730459>, <0.902260, 0.000000, 1.730459>,
      <0.000000, -0.977676, 2.209323>, <0.496243, -0.977676, 2.209323>, <0.902260, -0.566601, 2.238424>, <0.902260, 0.000000, 2.238424>,
      <0.000000, -0.963925, 2.721738>, <0.502553, -0.963925, 2.721738>, <0.913733, -0.544598, 2.736289>, <0.913733, 0.000000, 2.736289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.902260, 0.000000, 1.452743>, <0.902260, 0.461858, 1.452743>, <0.496243, 0.839743, 1.452743>, <0.000000, 0.839743, 1.452743>,
      <0.902260, 0.000000, 1.730459>, <0.902260, 0.461858, 1.730459>, <0.496243, 0.839743, 1.730459>, <0.000000, 0.839743, 1.730459>,
      <0.902260, 0.000000, 2.238424>, <0.902260, 0.566601, 2.238424>, <0.496243, 1.030183, 2.238424>, <0.000000, 1.030183, 2.238424>,
      <0.913733, 0.000000, 2.736289>, <0.913733, 0.544598, 2.736289>, <0.502553, 0.990178, 2.736289>, <0.000000, 0.990178, 2.736289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.839743, 1.452743>, <-0.496243, 0.839743, 1.452743>, <-0.902260, 0.461858, 1.452743>, <-0.902260, 0.000000, 1.452743>,
      <0.000000, 0.839743, 1.730459>, <-0.496243, 0.839743, 1.730459>, <-0.902260, 0.461858, 1.730459>, <-0.902260, 0.000000, 1.730459>,
      <0.000000, 1.030183, 2.238424>, <-0.496243, 1.030183, 2.238424>, <-0.902260, 0.566601, 2.238424>, <-0.902260, 0.000000, 2.238424>,
      <0.000000, 0.990178, 2.736289>, <-0.502553, 0.990178, 2.736289>, <-0.913733, 0.544598, 2.736289>, <-0.913733, 0.000000, 2.736289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.913733, 0.000000, 2.736289>, <-0.913733, -0.544598, 2.736289>, <-0.502553, -0.963925, 2.721738>, <0.000000, -0.963925, 2.721738>,
      <-0.925206, 0.000000, 3.234153>, <-0.925206, -0.522595, 3.234153>, <-0.508863, -0.950173, 3.234153>, <0.000000, -0.950173, 3.234153>,
      <-0.912831, 0.000000, 4.026857>, <-0.912831, -0.550000, 4.026857>, <-0.502057, -1.000000, 4.026857>, <0.000000, -1.000000, 4.026857>,
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-0.550000, -1.000000, 4.500000>, <0.000000, -1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.963925, 2.721738>, <0.502553, -0.963925, 2.721738>, <0.913733, -0.544598, 2.736289>, <0.913733, 0.000000, 2.736289>,
      <0.000000, -0.950173, 3.234153>, <0.508863, -0.950173, 3.234153>, <0.925206, -0.522595, 3.234153>, <0.925206, 0.000000, 3.234153>,
      <0.000000, -1.000000, 4.026857>, <0.502057, -1.000000, 4.026857>, <0.912831, -0.550000, 4.026857>, <0.912831, 0.000000, 4.026857>,
      <0.000000, -1.000000, 4.500000>, <0.550000, -1.000000, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.913733, 0.000000, 2.736289>, <0.913733, 0.544598, 2.736289>, <0.502553, 0.990178, 2.736289>, <0.000000, 0.990178, 2.736289>,
      <0.925206, 0.000000, 3.234153>, <0.925206, 0.522595, 3.234153>, <0.508863, 0.950173, 3.234153>, <0.000000, 0.950173, 3.234153>,
      <0.912831, 0.000000, 4.026857>, <0.912831, 0.550000, 4.026857>, <0.502057, 1.000000, 4.026857>, <0.000000, 1.000000, 4.026857>,
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.550000, 1.000000, 4.500000>, <0.000000, 1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.990178, 2.736289>, <-0.502553, 0.990178, 2.736289>, <-0.913733, 0.544598, 2.736289>, <-0.913733, 0.000000, 2.736289>,
      <0.000000, 0.950173, 3.234153>, <-0.508863, 0.950173, 3.234153>, <-0.925206, 0.522595, 3.234153>, <-0.925206, 0.000000, 3.234153>,
      <0.000000, 1.000000, 4.026857>, <-0.502057, 1.000000, 4.026857>, <-0.912831, 0.550000, 4.026857>, <-0.912831, 0.000000, 4.026857>,
      <0.000000, 1.000000, 4.500000>, <-0.550000, 1.000000, 4.500000>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>
    }
  }
  scale <0.287957, 0.260576, 0.389511>
  rotate <-1.890145, 7.914842, 7.873334>
  translate  <1.304141, -0.426633, 7.457097>
}
#declare momo7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.150887, 0.230326, -0.018524>, <-0.145697, 0.125182, -0.014919>, <-0.103348, 0.043424, -0.012116>, <-0.000009, 0.043424, -0.012116>,
      <-0.211950, 0.210825, 0.386757>, <-0.204660, 0.107193, 0.376660>, <-0.145173, 0.026611, 0.368809>, <-0.000013, 0.026611, 0.368809>,
      <-0.231603, 0.175131, 1.038066>, <-0.223637, 0.063136, 1.024418>, <-0.158633, -0.023950, 1.013805>, <-0.000014, -0.023950, 1.013805>,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000009, 0.043424, -0.012116>, <0.103330, 0.043424, -0.012116>, <0.146775, 0.130309, -0.015095>, <0.150810, 0.241644, -0.018912>,
      <-0.000013, 0.026611, 0.368809>, <0.145147, 0.026611, 0.368809>, <0.206174, 0.112246, 0.377153>, <0.211843, 0.221980, 0.387844>,
      <-0.000014, -0.023950, 1.013805>, <0.158606, -0.023950, 1.013805>, <0.225291, 0.068597, 1.025083>, <0.231486, 0.187187, 1.039535>,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.150810, 0.241644, -0.018912>, <0.154846, 0.352979, -0.022729>, <0.115415, 0.405634, -0.017058>, <-0.000028, 0.405634, -0.017058>,
      <0.211843, 0.221980, 0.387844>, <0.217512, 0.331714, 0.398536>, <0.162123, 0.404429, 0.408185>, <-0.000040, 0.404429, 0.408185>,
      <0.231486, 0.187187, 1.039535>, <0.237681, 0.305776, 1.053986>, <0.177156, 0.401478, 1.073866>, <-0.000044, 0.401478, 1.073866>,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000028, 0.405634, -0.017058>, <-0.115472, 0.405634, -0.017058>, <-0.156077, 0.335470, -0.022129>, <-0.150887, 0.230326, -0.018524>,
      <-0.000040, 0.404429, 0.408185>, <-0.162203, 0.404429, 0.408185>, <-0.219241, 0.314456, 0.396855>, <-0.211950, 0.210825, 0.386757>,
      <-0.000044, 0.401478, 1.073866>, <-0.177243, 0.401478, 1.073866>, <-0.239569, 0.287126, 1.051713>, <-0.231603, 0.175131, 1.038066>,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>,
      <-0.331731, 0.202532, 2.831148>, <-0.320321, 0.015753, 2.831148>, <-0.227215, -0.102524, 2.819123>, <-0.000020, -0.102524, 2.819123>,
      <-0.323254, 0.124480, 3.222072>, <-0.312136, 0.009682, 3.222072>, <-0.221408, -0.079583, 3.222072>, <-0.000019, -0.079583, 3.222072>,
      <-0.233289, 0.161055, 3.514342>, <-0.224392, 0.070207, 3.514342>, <-0.159169, -0.001095, 3.514342>, <-0.000014, -0.001095, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>,
      <-0.000020, -0.102524, 2.819123>, <0.227175, -0.102524, 2.819123>, <0.322690, 0.024861, 2.831148>, <0.331563, 0.222638, 2.831148>,
      <-0.000019, -0.079583, 3.222072>, <0.221370, -0.079583, 3.222072>, <0.314444, 0.015280, 3.222072>, <0.323090, 0.136837, 3.222072>,
      <-0.000014, -0.001095, 3.514342>, <0.159141, -0.001095, 3.514342>, <0.226052, 0.074678, 3.514342>, <0.232267, 0.171774, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>,
      <0.331563, 0.222638, 2.831148>, <0.340436, 0.420415, 2.831148>, <0.253745, 0.725712, 2.796334>, <-0.000063, 0.725712, 2.796334>,
      <0.323090, 0.136837, 3.222072>, <0.331736, 0.258395, 3.222072>, <0.247261, 0.420547, 3.222072>, <-0.000061, 0.420547, 3.222072>,
      <0.232267, 0.171774, 3.514342>, <0.238483, 0.268869, 3.514342>, <0.177754, 0.398391, 3.514342>, <-0.000044, 0.398391, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>,
      <-0.000063, 0.725712, 2.796334>, <-0.253870, 0.725712, 2.796334>, <-0.343141, 0.389312, 2.831148>, <-0.331731, 0.202532, 2.831148>,
      <-0.000061, 0.420547, 3.222072>, <-0.247383, 0.420547, 3.222072>, <-0.334372, 0.239278, 3.222072>, <-0.323254, 0.124480, 3.222072>,
      <-0.000044, 0.398391, 3.514342>, <-0.177842, 0.398391, 3.514342>, <-0.242185, 0.251903, 3.514342>, <-0.233289, 0.161055, 3.514342>
    }
  }
  texture {
    suhada
  }
  scale <0.8, 0.663339, 0.549969>
  rotate <15.38503, 17.184889, 140.249863>
  translate  <1.223605, -1.015183, 5.928857>
}
#declare ude1 = union {
  object { ude3 }
  object { momo7 }
  texture {
    suhada
  }
  translate  <-2.371978, 0.055641, 0.553074>
}
#declare scaf = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-1.964225, -5.903881, 2.973370>, <-2.490845, -5.937703, 1.573960>, <-2.030343, -5.937703, 2.041230>, <-1.535555, -5.901196, 1.340325>,
      <-3.116393, -5.283057, 3.140531>, <-3.916885, -5.294768, 1.647740>, <-3.053356, -5.294768, 0.885353>, <-2.330874, -5.294768, 0.479566>,
      <-3.941197, -4.073173, 3.520731>, <-4.937747, -4.027642, 1.700298>, <-3.988185, -4.061090, 0.446049>, <-3.001462, -4.044366, 0.286194>,
      <-3.902682, -3.047671, 3.646452>, <-4.889294, -3.057897, 0.850149>, <-3.989994, -3.063336, 0.370583>, <-2.998681, -3.038578, 0.159938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-3.902682, -3.047671, 3.646452>, <-4.889294, -3.057897, 0.850149>, <-3.989994, -3.063336, 0.370583>, <-2.998681, -3.038578, 0.159938>,
      <-3.864166, -2.022168, 3.772172>, <-4.840841, -2.088152, 0.000000>, <-3.991802, -2.065582, 0.295118>, <-2.995901, -2.032791, 0.033683>,
      <-4.116856, -0.997699, 3.772172>, <-4.966002, -1.096015, 0.000000>, <-3.877034, -0.836046, 0.024593>, <-2.938517, -0.918023, -0.101579>,
      <-4.142740, 0.040086, 3.699507>, <-5.091164, -0.077129, 0.000000>, <-3.938517, 0.106957, 0.012297>, <-2.985135, 0.065968, -0.107727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-4.142740, 0.040086, 3.699507>, <-5.091164, -0.077129, 0.000000>, <-3.938517, 0.106957, 0.012297>, <-2.985135, 0.065968, -0.107727>,
      <-4.168625, 1.077871, 3.626841>, <-5.216326, 0.941757, 0.000000>, <-4.000000, 1.049959, 0.000000>, <-3.000000, 1.049959, -0.113875>,
      <-4.194510, 2.035054, 3.480532>, <-5.341488, 1.902461, 0.000000>, <-4.000000, 2.018278, 0.000000>, <-3.000000, 2.018278, -0.113875>,
      <-4.267627, 2.772385, 3.334223>, <-5.503757, 2.577175, 0.000000>, <-4.048165, 2.778898, 0.000000>, <-3.067183, 2.828296, -0.113875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-4.267627, 2.772385, 3.334223>, <-5.503757, 2.577175, 0.000000>, <-4.048165, 2.778898, 0.000000>, <-3.067183, 2.828296, -0.113875>,
      <-4.340745, 3.509716, 3.187914>, <-5.666026, 3.251890, 0.000000>, <-4.096330, 3.539517, 0.000000>, <-3.101548, 3.638314, -0.113875>,
      <-4.467350, 4.459346, 3.041605>, <-5.891761, 4.195215, 0.000000>, <-4.198359, 4.502783, 0.000000>, <-3.234293, 4.703317, -0.113875>,
      <-4.721931, 5.553184, 2.895296>, <-6.287977, 5.305368, 0.000000>, <-4.372276, 5.729524, 0.000000>, <-3.381561, 6.416146, -0.113875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-1.535555, -5.901196, 1.340325>, <-1.040767, -5.864689, 0.639421>, <-0.533182, -5.864689, 0.516456>, <-0.019197, -5.864689, 0.479566>,
      <-2.330874, -5.294768, 0.479566>, <-1.608392, -5.294768, 0.073779>, <-0.823973, -5.294768, -0.049186>, <-0.029667, -5.294768, -0.086076>,
      <-3.001462, -4.044366, 0.286194>, <-2.014738, -4.027642, 0.126338>, <-1.032143, -4.027642, -0.142083>, <-0.037162, -4.027642, -0.178973>,
      <-2.998681, -3.038578, 0.159938>, <-2.007369, -3.013821, -0.050706>, <-1.016046, -3.013821, -0.253199>, <-0.024703, -3.013821, -0.290089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-2.998681, -3.038578, 0.159938>, <-2.007369, -3.013821, -0.050706>, <-1.016046, -3.013821, -0.253199>, <-0.024703, -3.013821, -0.290089>,
      <-2.995901, -2.032791, 0.033683>, <-2.000000, -2.000000, -0.227751>, <-0.999949, -2.000000, -0.364315>, <-0.012245, -2.000000, -0.401205>,
      <-2.938517, -0.918023, -0.101579>, <-2.000000, -1.000000, -0.227751>, <-0.999949, -1.000000, -0.364315>, <-0.012245, -1.000000, -0.401205>,
      <-2.985135, 0.065968, -0.107727>, <-2.000000, 0.024980, -0.227751>, <-0.987652, 0.024980, -0.302833>, <0.006190, 0.024980, -0.321277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-2.985135, 0.065968, -0.107727>, <-2.000000, 0.024980, -0.227751>, <-0.987652, 0.024980, -0.302833>, <0.006190, 0.024980, -0.321277>,
      <-3.000000, 1.049959, -0.113875>, <-2.000000, 1.049959, -0.227751>, <-0.975355, 1.049959, -0.241350>, <0.024645, 1.049959, -0.241350>,
      <-3.000000, 2.018278, -0.113875>, <-2.000000, 2.018278, -0.227751>, <-0.975355, 2.018278, -0.241350>, <0.024645, 2.018278, -0.241350>,
      <-3.067183, 2.828296, -0.113875>, <-2.053383, 2.877694, -0.227751>, <-1.031348, 2.927092, -0.241350>, <0.005334, 2.925276, -0.241350>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-3.067183, 2.828296, -0.113875>, <-2.053383, 2.877694, -0.227751>, <-1.031348, 2.927092, -0.241350>, <0.005334, 2.925276, -0.241350>,
      <-3.101548, 3.638314, -0.113875>, <-2.106767, 3.737110, -0.227751>, <-1.087341, 3.835907, -0.241350>, <-0.013557, 3.832273, -0.241350>,
      <-3.234293, 4.703317, -0.113875>, <-2.270228, 4.903851, -0.227751>, <-1.222361, 4.994384, -0.241350>, <-0.011030, 4.990809, -0.241350>,
      <-3.381561, 6.416146, -0.113875>, <-2.390846, 7.102768, -0.227751>, <-0.567668, 9.243504, -0.241350>, <-0.019580, 9.246427, -0.241350>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-0.019197, -5.864689, 0.479566>, <0.494788, -5.864689, 0.442676>, <1.053565, -5.864689, 0.713201>, <1.593146, -5.901196, 1.377215>,
      <-0.029667, -5.294768, -0.086076>, <0.764640, -5.294768, -0.122966>, <1.628169, -5.294768, 0.147559>, <2.504190, -5.294768, 0.516456>,
      <-0.037162, -4.027642, -0.178973>, <0.957820, -4.027642, -0.215862>, <2.039512, -4.027642, 0.200118>, <3.055139, -4.044366, 0.323083>,
      <-0.024703, -3.013821, -0.290089>, <0.966639, -3.013821, -0.326978>, <2.032053, -3.013821, 0.023073>, <3.043965, -3.030381, 0.196828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <-0.024703, -3.013821, -0.290089>, <0.966639, -3.013821, -0.326978>, <2.032053, -3.013821, 0.023073>, <3.043965, -3.030381, 0.196828>,
      <-0.012245, -2.000000, -0.401205>, <0.975458, -2.000000, -0.438095>, <2.024593, -2.000000, -0.153972>, <3.032791, -2.016395, 0.070573>,
      <-0.012245, -1.000000, -0.401205>, <0.975458, -1.000000, -0.438095>, <2.024593, -1.000000, -0.153972>, <3.024593, -1.000000, -0.064689>,
      <0.006190, 0.024980, -0.321277>, <1.000051, 0.024980, -0.339722>, <2.012297, 0.024980, -0.190861>, <3.027895, 0.024980, -0.089282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <0.006190, 0.024980, -0.321277>, <1.000051, 0.024980, -0.339722>, <2.012297, 0.024980, -0.190861>, <3.027895, 0.024980, -0.089282>,
      <0.024645, 1.049959, -0.241350>, <1.024645, 1.049959, -0.241350>, <2.000000, 1.049959, -0.227751>, <3.000000, 1.049959, -0.113875>,
      <0.024645, 2.018278, -0.241350>, <1.024645, 2.018278, -0.241350>, <2.000000, 2.018278, -0.227751>, <3.000000, 2.018278, -0.113875>,
      <0.005334, 2.925276, -0.241350>, <1.042436, 2.923459, -0.241350>, <2.014904, 2.871504, -0.227751>, <3.027741, 2.819549, -0.113875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <0.005334, 2.925276, -0.241350>, <1.042436, 2.923459, -0.241350>, <2.014904, 2.871504, -0.227751>, <3.027741, 2.819549, -0.113875>,
      <-0.013557, 3.832273, -0.241350>, <1.060227, 3.828640, -0.241350>, <2.029808, 3.724730, -0.227751>, <3.024034, 3.620820, -0.113875>,
      <-0.011030, 4.990809, -0.241350>, <1.200301, 4.987233, -0.241350>, <2.196932, 4.892014, -0.227751>, <3.161251, 4.685826, -0.113875>,
      <-0.019580, 9.246427, -0.241350>, <0.528509, 9.249350, -0.241350>, <2.291025, 6.962254, -0.227751>, <3.345042, 6.335037, -0.113875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <1.593146, -5.901196, 1.377215>, <2.132726, -5.937703, 2.041230>, <2.712992, -5.937703, 1.573960>, <2.260890, -5.903881, 2.973370>,
      <2.504190, -5.294768, 0.516456>, <3.380210, -5.294768, 0.885353>, <4.125073, -5.294768, 1.647740>, <3.413058, -5.283057, 3.140531>,
      <3.055139, -4.044366, 0.323083>, <4.070766, -4.061090, 0.446049>, <5.135942, -4.027642, 1.700298>, <4.237862, -4.073173, 3.520731>,
      <3.043965, -3.030381, 0.196828>, <4.055877, -3.046940, 0.370583>, <5.165833, -3.013821, 0.850149>, <4.286551, -3.259381, 3.600004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <3.043965, -3.030381, 0.196828>, <4.055877, -3.046940, 0.370583>, <5.165833, -3.013821, 0.850149>, <4.286551, -3.259381, 3.600004>,
      <3.032791, -2.016395, 0.070573>, <4.040989, -2.032791, 0.295118>, <5.195724, -2.000000, 0.000000>, <4.335240, -2.445589, 3.679276>,
      <3.024593, -1.000000, -0.064689>, <4.024593, -1.000000, 0.024593>, <5.256606, -0.960310, 0.000000>, <4.379099, -0.993390, 3.772172>,
      <3.027895, 0.024980, -0.089282>, <4.012297, 0.024980, 0.012297>, <5.317311, 0.062255, 0.000000>, <4.422959, 0.042991, 3.699392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <3.027895, 0.024980, -0.089282>, <4.012297, 0.024980, 0.012297>, <5.317311, 0.062255, 0.000000>, <4.422959, 0.042991, 3.699392>,
      <3.000000, 1.049959, -0.113875>, <4.000000, 1.049959, 0.000000>, <5.378016, 1.084820, 0.000000>, <4.466819, 1.079372, 3.626612>,
      <3.000000, 2.018278, -0.113875>, <4.000000, 2.018278, 0.000000>, <5.438721, 2.051353, 0.000000>, <4.510678, 2.035241, 3.480503>,
      <3.027741, 2.819549, -0.113875>, <4.009130, 2.767594, 0.000000>, <5.505687, 2.717742, 0.000000>, <4.561500, 2.741040, 3.334395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 2 v_steps 2,
      <3.027741, 2.819549, -0.113875>, <4.009130, 2.767594, 0.000000>, <5.505687, 2.717742, 0.000000>, <4.561500, 2.741040, 3.334395>,
      <3.024034, 3.620820, -0.113875>, <4.018260, 3.516910, 0.000000>, <5.572652, 3.384130, 0.000000>, <4.612322, 3.446839, 3.188287>,
      <3.161251, 4.685826, -0.113875>, <4.125569, 4.479637, 0.000000>, <5.740119, 4.338774, 0.000000>, <4.678531, 4.401340, 3.042178>,
      <3.345042, 6.335037, -0.113875>, <4.399060, 5.707821, 0.000000>, <6.072592, 5.447292, 0.000000>, <4.962956, 5.496513, 2.896070>
    }
  }
  texture {
    weare_tex1
  }
  scale <0.324648, 0.19723, 0.30137>
  rotate <-91.565079, 0.0, 180.0>
  translate  <0.147389, 0.18465, 9.150557>
}
#declare body1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.136734, 0.000000, 0.000000>, <-1.136734, -0.333703, 0.000000>, <-0.696198, -0.557324, -0.016395>, <-0.034113, -0.557324, -0.016395>,
      <-1.136734, 0.000000, 0.497092>, <-1.136734, -0.333703, 0.497092>, <-0.696198, -0.557324, 0.483605>, <-0.034113, -0.557324, 0.483605>,
      <-1.136734, 0.000000, 0.994184>, <-1.136734, -0.333703, 0.994184>, <-0.696198, -0.557324, 0.983605>, <-0.034113, -0.557324, 0.983605>,
      <-1.040009, 0.000000, 1.491277>, <-1.040009, -0.333703, 1.491277>, <-0.636762, -0.557324, 1.483605>, <-0.030720, -0.557324, 1.483605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.034113, -0.557324, -0.016395>, <0.627971, -0.557324, -0.016395>, <1.202571, -0.381233, 0.000000>, <1.202571, 0.000000, 0.000000>,
      <-0.034113, -0.557324, 0.483605>, <0.627971, -0.557324, 0.483605>, <1.202571, -0.381233, 0.500000>, <1.202571, 0.000000, 0.500000>,
      <-0.034113, -0.557324, 0.983605>, <0.627971, -0.557324, 0.983605>, <1.202571, -0.381233, 1.000000>, <1.202571, 0.000000, 1.000000>,
      <-0.030720, -0.557324, 1.483605>, <0.575323, -0.557324, 1.483605>, <1.101286, -0.381233, 1.500000>, <1.101286, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.202571, 0.000000, 0.000000>, <1.202571, 0.381233, 0.000000>, <0.654287, 1.439946, -0.005226>, <-0.007798, 1.439946, -0.005226>,
      <1.202571, 0.000000, 0.500000>, <1.202571, 0.381233, 0.500000>, <0.654287, 1.360310, 0.488392>, <-0.007798, 1.360310, 0.488392>,
      <1.202571, 0.000000, 1.000000>, <1.202571, 0.381233, 1.000000>, <0.654287, 1.280674, 0.982009>, <-0.007798, 1.280674, 0.982009>,
      <1.101286, 0.000000, 1.500000>, <1.101286, 0.381233, 1.500000>, <0.599411, 1.201038, 1.475626>, <-0.006631, 1.201038, 1.475626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.007798, 1.439946, -0.005226>, <-0.669883, 1.439946, -0.005226>, <-1.136734, 0.333703, 0.000000>, <-1.136734, 0.000000, 0.000000>,
      <-0.007798, 1.360310, 0.488392>, <-0.669883, 1.360310, 0.488392>, <-1.136734, 0.333703, 0.497092>, <-1.136734, 0.000000, 0.497092>,
      <-0.007798, 1.280674, 0.982009>, <-0.669883, 1.280674, 0.982009>, <-1.136734, 0.333703, 0.994184>, <-1.136734, 0.000000, 0.994184>,
      <-0.006631, 1.201038, 1.475626>, <-0.612674, 1.201038, 1.475626>, <-1.040009, 0.333703, 1.491277>, <-1.040009, 0.000000, 1.491277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.040009, 0.000000, 1.491277>, <-1.040009, -0.333703, 1.491277>, <-0.636762, -0.557324, 1.483605>, <-0.030720, -0.557324, 1.483605>,
      <-0.943283, 0.000000, 1.988369>, <-0.943283, -0.333703, 1.988369>, <-0.577326, -0.557324, 1.983605>, <-0.027326, -0.557324, 1.983605>,
      <-0.758917, 0.000000, 2.513661>, <-0.758917, -0.333703, 2.513661>, <-0.464208, -0.528880, 2.492081>, <-0.021287, -0.528880, 2.492081>,
      <-0.761661, 0.000000, 2.731574>, <-0.761661, -0.310221, 2.731574>, <-0.466026, -0.532061, 2.729411>, <-0.021715, -0.532061, 2.729411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.030720, -0.557324, 1.483605>, <0.575323, -0.557324, 1.483605>, <1.101286, -0.381233, 1.500000>, <1.101286, 0.000000, 1.500000>,
      <-0.027326, -0.557324, 1.983605>, <0.522674, -0.557324, 1.983605>, <1.000000, -0.381233, 2.000000>, <1.000000, 0.000000, 2.000000>,
      <-0.021287, -0.528880, 2.492081>, <0.421634, -0.528880, 2.492081>, <0.806029, -0.381233, 2.526849>, <0.806029, 0.000000, 2.526849>,
      <-0.021715, -0.532061, 2.729411>, <0.422596, -0.532061, 2.729411>, <0.808198, -0.354407, 2.746795>, <0.808198, 0.000000, 2.746795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.101286, 0.000000, 1.500000>, <1.101286, 0.381233, 1.500000>, <0.599411, 1.201038, 1.475626>, <-0.006631, 1.201038, 1.475626>,
      <1.000000, 0.000000, 2.000000>, <1.000000, 0.381233, 2.000000>, <0.544535, 1.121402, 1.969244>, <-0.005465, 1.121402, 1.969244>,
      <0.806029, 0.000000, 2.526849>, <0.806029, 0.381233, 2.526849>, <0.439238, 0.677557, 2.526849>, <-0.003682, 0.677557, 2.526849>,
      <0.808198, 0.000000, 2.746795>, <0.808198, 0.354407, 2.746795>, <0.440256, 0.629879, 2.746795>, <-0.004056, 0.629879, 2.746795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006631, 1.201038, 1.475626>, <-0.612674, 1.201038, 1.475626>, <-1.040009, 0.333703, 1.491277>, <-1.040009, 0.000000, 1.491277>,
      <-0.005465, 1.121402, 1.969244>, <-0.555465, 1.121402, 1.969244>, <-0.943283, 0.333703, 1.988369>, <-0.943283, 0.000000, 1.988369>,
      <-0.003682, 0.677557, 2.526849>, <-0.446603, 0.677557, 2.526849>, <-0.758917, 0.333703, 2.513661>, <-0.758917, 0.000000, 2.513661>,
      <-0.004056, 0.629879, 2.746795>, <-0.448367, 0.629879, 2.746795>, <-0.761661, 0.310221, 2.731574>, <-0.761661, 0.000000, 2.731574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.761661, 0.000000, 2.731574>, <-0.761661, -0.310221, 2.731574>, <-0.466026, -0.532061, 2.729411>, <-0.021715, -0.532061, 2.729411>,
      <-0.764405, 0.000000, 2.949488>, <-0.764405, -0.286740, 2.949488>, <-0.467845, -0.535242, 2.966741>, <-0.022144, -0.535242, 2.966741>,
      <-0.848218, 0.000000, 3.370843>, <-0.848218, -0.286740, 3.370843>, <-0.519142, -0.535242, 3.390562>, <-0.024572, -0.535242, 3.390562>,
      <-0.848218, 0.000000, 3.792199>, <-0.848218, -0.286740, 3.792199>, <-0.519142, -0.676122, 3.807433>, <-0.024572, -0.676122, 3.807433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.021715, -0.532061, 2.729411>, <0.422596, -0.532061, 2.729411>, <0.808198, -0.354407, 2.746795>, <0.808198, 0.000000, 2.746795>,
      <-0.022144, -0.535242, 2.966741>, <0.423558, -0.535242, 2.966741>, <0.810366, -0.327581, 2.966741>, <0.810366, 0.000000, 2.966741>,
      <-0.024572, -0.535242, 3.390562>, <0.469999, -0.535242, 3.390562>, <0.899219, -0.327581, 3.390562>, <0.899219, 0.000000, 3.390562>,
      <-0.024572, -0.676122, 3.807433>, <0.469999, -0.676122, 3.807433>, <0.899219, -0.327581, 3.814382>, <0.899219, 0.000000, 3.814382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.808198, 0.000000, 2.746795>, <0.808198, 0.354407, 2.746795>, <0.440256, 0.629879, 2.746795>, <-0.004056, 0.629879, 2.746795>,
      <0.810366, 0.000000, 2.966741>, <0.810366, 0.327581, 2.966741>, <0.441273, 0.582202, 2.966741>, <-0.004429, 0.582202, 2.966741>,
      <0.899219, 0.000000, 3.390562>, <0.899219, 0.327581, 3.390562>, <0.439238, 0.726324, 3.763153>, <-0.003682, 0.726324, 3.763153>,
      <0.899219, 0.000000, 3.814382>, <0.899219, 0.327581, 3.814382>, <0.464447, 0.682262, 3.986867>, <-0.004298, 0.682262, 3.986867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.004056, 0.629879, 2.746795>, <-0.448367, 0.629879, 2.746795>, <-0.761661, 0.310221, 2.731574>, <-0.761661, 0.000000, 2.731574>,
      <-0.004429, 0.582202, 2.966741>, <-0.450130, 0.582202, 2.966741>, <-0.764405, 0.286740, 2.949488>, <-0.764405, 0.000000, 2.949488>,
      <-0.003682, 0.726324, 3.763153>, <-0.446603, 0.726324, 3.763153>, <-0.848218, 0.286740, 3.370843>, <-0.848218, 0.000000, 3.370843>,
      <-0.004298, 0.682262, 3.986867>, <-0.473044, 0.682262, 3.986867>, <-0.848218, 0.286740, 3.792199>, <-0.848218, 0.000000, 3.792199>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.848218, 0.000000, 3.792199>, <-0.848218, -0.286740, 3.792199>, <-0.519142, -0.676122, 3.807433>, <-0.024572, -0.676122, 3.807433>,
      <-0.848218, 0.000000, 4.213554>, <-0.848218, -0.286740, 4.213554>, <-0.519142, -0.817003, 4.224305>, <-0.024572, -0.817003, 4.224305>,
      <-0.848218, 0.000000, 4.634910>, <-0.848218, -0.286740, 4.634910>, <-0.519142, -0.817003, 4.648125>, <-0.024572, -0.817003, 4.648125>,
      <-0.848218, 0.000000, 5.056265>, <-0.848218, -0.286740, 5.056265>, <-0.519142, -0.535242, 5.085843>, <-0.024572, -0.535242, 5.085843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.024572, -0.676122, 3.807433>, <0.469999, -0.676122, 3.807433>, <0.899219, -0.327581, 3.814382>, <0.899219, 0.000000, 3.814382>,
      <-0.024572, -0.817003, 4.224305>, <0.469999, -0.817003, 4.224305>, <0.899219, -0.327581, 4.238202>, <0.899219, 0.000000, 4.238202>,
      <-0.024572, -0.817003, 4.648125>, <0.469999, -0.817003, 4.648125>, <0.899219, -0.327581, 4.662022>, <0.899219, 0.000000, 4.662022>,
      <-0.024572, -0.535242, 5.085843>, <0.469999, -0.535242, 5.085843>, <0.899219, -0.327581, 5.085843>, <0.899219, 0.000000, 5.085843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.899219, 0.000000, 3.814382>, <0.899219, 0.327581, 3.814382>, <0.464447, 0.682262, 3.986867>, <-0.004298, 0.682262, 3.986867>,
      <0.899219, 0.000000, 4.238202>, <0.899219, 0.327581, 4.238202>, <0.489656, 0.638200, 4.210582>, <-0.004914, 0.638200, 4.210582>,
      <0.899219, 0.000000, 4.662022>, <0.899219, 0.327581, 4.662022>, <0.489656, 0.582202, 4.662022>, <-0.004914, 0.582202, 4.662022>,
      <0.899219, 0.000000, 5.085843>, <0.899219, 0.327581, 5.085843>, <0.489656, 0.511762, 5.085843>, <-0.004914, 0.511762, 5.085843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.004298, 0.682262, 3.986867>, <-0.473044, 0.682262, 3.986867>, <-0.848218, 0.286740, 3.792199>, <-0.848218, 0.000000, 3.792199>,
      <-0.004914, 0.638200, 4.210582>, <-0.499485, 0.638200, 4.210582>, <-0.848218, 0.286740, 4.213554>, <-0.848218, 0.000000, 4.213554>,
      <-0.004914, 0.582202, 4.662022>, <-0.499485, 0.582202, 4.662022>, <-0.848218, 0.286740, 4.634910>, <-0.848218, 0.000000, 4.634910>,
      <-0.004914, 0.511762, 5.085843>, <-0.499485, 0.511762, 5.085843>, <-0.848218, 0.286740, 5.056265>, <-0.848218, 0.000000, 5.056265>
    }
  }
  texture {
    weare_tex
  }
  scale <1.233908, 0.838678, 0.701533>
  translate  <0.0, -0.425096, 5.590959>
}
#declare momo4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.150887, 0.230326, -0.018524>, <-0.145697, 0.125182, -0.014919>, <-0.103348, 0.043424, -0.012116>, <-0.000009, 0.043424, -0.012116>,
      <-0.211950, 0.210825, 0.386757>, <-0.204660, 0.107193, 0.376660>, <-0.145173, 0.026611, 0.368809>, <-0.000013, 0.026611, 0.368809>,
      <-0.231603, 0.175131, 1.038066>, <-0.223637, 0.063136, 1.024418>, <-0.158633, -0.023950, 1.013805>, <-0.000014, -0.023950, 1.013805>,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000009, 0.043424, -0.012116>, <0.103330, 0.043424, -0.012116>, <0.146775, 0.130309, -0.015095>, <0.150810, 0.241644, -0.018912>,
      <-0.000013, 0.026611, 0.368809>, <0.145147, 0.026611, 0.368809>, <0.206174, 0.112246, 0.377153>, <0.211843, 0.221980, 0.387844>,
      <-0.000014, -0.023950, 1.013805>, <0.158606, -0.023950, 1.013805>, <0.225291, 0.068597, 1.025083>, <0.231486, 0.187187, 1.039535>,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <0.150810, 0.241644, -0.018912>, <0.154846, 0.352979, -0.022729>, <0.115415, 0.405634, -0.017058>, <-0.000028, 0.405634, -0.017058>,
      <0.211843, 0.221980, 0.387844>, <0.217512, 0.331714, 0.398536>, <0.162123, 0.404429, 0.408185>, <-0.000040, 0.404429, 0.408185>,
      <0.231486, 0.187187, 1.039535>, <0.237681, 0.305776, 1.053986>, <0.177156, 0.401478, 1.073866>, <-0.000044, 0.401478, 1.073866>,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000028, 0.405634, -0.017058>, <-0.115472, 0.405634, -0.017058>, <-0.156077, 0.335470, -0.022129>, <-0.150887, 0.230326, -0.018524>,
      <-0.000040, 0.404429, 0.408185>, <-0.162203, 0.404429, 0.408185>, <-0.219241, 0.314456, 0.396855>, <-0.211950, 0.210825, 0.386757>,
      <-0.000044, 0.401478, 1.073866>, <-0.177243, 0.401478, 1.073866>, <-0.239569, 0.287126, 1.051713>, <-0.231603, 0.175131, 1.038066>,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>,
      <-0.331731, 0.202532, 2.831148>, <-0.320321, 0.015753, 2.831148>, <-0.227215, -0.102524, 2.819123>, <-0.000020, -0.102524, 2.819123>,
      <-0.323254, 0.124480, 3.222072>, <-0.312136, 0.009682, 3.222072>, <-0.221408, -0.079583, 3.222072>, <-0.000019, -0.079583, 3.222072>,
      <-0.233289, 0.161055, 3.514342>, <-0.224392, 0.070207, 3.514342>, <-0.159169, -0.001095, 3.514342>, <-0.000014, -0.001095, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>,
      <-0.000020, -0.102524, 2.819123>, <0.227175, -0.102524, 2.819123>, <0.322690, 0.024861, 2.831148>, <0.331563, 0.222638, 2.831148>,
      <-0.000019, -0.079583, 3.222072>, <0.221370, -0.079583, 3.222072>, <0.314444, 0.015280, 3.222072>, <0.323090, 0.136837, 3.222072>,
      <-0.000014, -0.001095, 3.514342>, <0.159141, -0.001095, 3.514342>, <0.226052, 0.074678, 3.514342>, <0.232267, 0.171774, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>,
      <0.331563, 0.222638, 2.831148>, <0.340436, 0.420415, 2.831148>, <0.253745, 0.725712, 2.796334>, <-0.000063, 0.725712, 2.796334>,
      <0.323090, 0.136837, 3.222072>, <0.331736, 0.258395, 3.222072>, <0.247261, 0.420547, 3.222072>, <-0.000061, 0.420547, 3.222072>,
      <0.232267, 0.171774, 3.514342>, <0.238483, 0.268869, 3.514342>, <0.177754, 0.398391, 3.514342>, <-0.000044, 0.398391, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>,
      <-0.000063, 0.725712, 2.796334>, <-0.253870, 0.725712, 2.796334>, <-0.343141, 0.389312, 2.831148>, <-0.331731, 0.202532, 2.831148>,
      <-0.000061, 0.420547, 3.222072>, <-0.247383, 0.420547, 3.222072>, <-0.334372, 0.239278, 3.222072>, <-0.323254, 0.124480, 3.222072>,
      <-0.000044, 0.398391, 3.514342>, <-0.177842, 0.398391, 3.514342>, <-0.242185, 0.251903, 3.514342>, <-0.233289, 0.161055, 3.514342>
    }
  }
  texture {
    sox_tex
  }
  scale <1.0, 1.0, 1.06164>
  translate  <-0.069347, -0.203668, -1.684777>
}
#declare momo5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.211950, 0.326972, -0.036467>, <-0.204660, 0.171896, -0.030751>, <-0.145173, 0.051313, -0.040958>, <-0.000013, 0.051313, -0.040958>,
      <-0.211950, 0.294892, 0.386757>, <-0.204660, 0.149937, 0.376660>, <-0.145173, 0.037222, 0.368809>, <-0.000013, 0.037222, 0.368809>,
      <-0.286483, 0.306381, 1.019166>, <-0.276629, 0.110452, 1.005518>, <-0.196222, -0.041898, 0.994906>, <-0.000017, -0.041898, 0.994906>,
      <-0.329426, 0.276208, 1.652601>, <-0.318095, 0.064794, 1.645777>, <-0.225636, -0.083222, 1.635616>, <-0.000020, -0.083222, 1.635616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000013, 0.051313, -0.040958>, <0.145147, 0.051313, -0.040958>, <0.206174, 0.179458, -0.030111>, <0.211843, 0.343665, -0.035054>,
      <-0.000013, 0.037222, 0.368809>, <0.145147, 0.037222, 0.368809>, <0.206174, 0.157005, 0.377153>, <0.211843, 0.310495, 0.387844>,
      <-0.000017, -0.041898, 0.994906>, <0.196188, -0.041898, 0.994906>, <0.278675, 0.120006, 1.006183>, <0.286337, 0.327471, 1.020635>,
      <-0.000020, -0.083222, 1.635616>, <0.225597, -0.083222, 1.635616>, <0.320448, 0.075103, 1.646110>, <0.329259, 0.298965, 1.653336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.211843, 0.343665, -0.035054>, <0.217512, 0.507871, -0.039997>, <0.162123, 0.583682, -0.026473>, <-0.000040, 0.583682, -0.026473>,
      <0.211843, 0.310495, 0.387844>, <0.217512, 0.463986, 0.398536>, <0.162123, 0.565698, 0.408185>, <-0.000040, 0.565698, 0.408185>,
      <0.286337, 0.327471, 1.020635>, <0.294000, 0.534936, 1.035086>, <0.219134, 0.702359, 1.054966>, <-0.000054, 0.702359, 1.054966>,
      <0.329259, 0.298965, 1.653336>, <0.338070, 0.522827, 1.660561>, <0.251982, 0.791975, 1.656446>, <-0.000062, 0.791975, 1.656446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000040, 0.583682, -0.026473>, <-0.162203, 0.583682, -0.026473>, <-0.219241, 0.482047, -0.042183>, <-0.211950, 0.326972, -0.036467>,
      <-0.000040, 0.565698, 0.408185>, <-0.162203, 0.565698, 0.408185>, <-0.219241, 0.439847, 0.396855>, <-0.211950, 0.294892, 0.386757>,
      <-0.000054, 0.702359, 1.054966>, <-0.219242, 0.702359, 1.054966>, <-0.296336, 0.502309, 1.032814>, <-0.286483, 0.306381, 1.019166>,
      <-0.000062, 0.791975, 1.656446>, <-0.252106, 0.791975, 1.656446>, <-0.340757, 0.487621, 1.659425>, <-0.329426, 0.276208, 1.652601>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.329426, 0.276208, 1.652601>, <-0.318095, 0.064794, 1.645777>, <-0.225636, -0.083222, 1.635616>, <-0.000020, -0.083222, 1.635616>,
      <-0.372370, 0.246035, 2.286037>, <-0.359562, 0.019137, 2.286037>, <-0.255049, -0.124546, 2.276327>, <-0.000022, -0.124546, 2.276327>,
      <-0.454074, 0.252826, 3.242212>, <-0.438457, 0.019665, 3.242212>, <-0.311012, -0.161637, 3.242212>, <-0.000027, -0.161637, 3.242212>,
      <-0.325943, 0.253404, 3.406331>, <-0.313513, 0.110463, 3.406331>, <-0.222385, -0.001723, 3.406331>, <-0.000019, -0.001723, 3.406331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000020, -0.083222, 1.635616>, <0.225597, -0.083222, 1.635616>, <0.320448, 0.075103, 1.646110>, <0.329259, 0.298965, 1.653336>,
      <-0.000022, -0.124546, 2.276327>, <0.255005, -0.124546, 2.276327>, <0.362221, 0.030201, 2.286037>, <0.372181, 0.270459, 2.286037>,
      <-0.000027, -0.161637, 3.242212>, <0.310958, -0.161637, 3.242212>, <0.441699, 0.031034, 3.242212>, <0.453845, 0.277924, 3.242212>,
      <-0.000019, -0.001723, 3.406331>, <0.222346, -0.001723, 3.406331>, <0.315832, 0.117498, 3.406331>, <0.324516, 0.270269, 3.406331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.329259, 0.298965, 1.653336>, <0.338070, 0.522827, 1.660561>, <0.251982, 0.791975, 1.656446>, <-0.000062, 0.791975, 1.656446>,
      <0.372181, 0.270459, 2.286037>, <0.382141, 0.510718, 2.286037>, <0.284830, 0.881591, 2.257926>, <-0.000070, 0.881591, 2.257926>,
      <0.453845, 0.277924, 3.242212>, <0.465990, 0.524814, 3.242212>, <0.347327, 0.854154, 3.242212>, <-0.000086, 0.854154, 3.242212>,
      <0.324516, 0.270269, 3.406331>, <0.333200, 0.423040, 3.406331>, <0.248352, 0.626829, 3.406331>, <-0.000061, 0.626829, 3.406331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000062, 0.791975, 1.656446>, <-0.252106, 0.791975, 1.656446>, <-0.340757, 0.487621, 1.659425>, <-0.329426, 0.276208, 1.652601>,
      <-0.000070, 0.881591, 2.257926>, <-0.284970, 0.881591, 2.257926>, <-0.385177, 0.472934, 2.286037>, <-0.372370, 0.246035, 2.286037>,
      <-0.000086, 0.854154, 3.242212>, <-0.347498, 0.854154, 3.242212>, <-0.469692, 0.485987, 3.242212>, <-0.454074, 0.252826, 3.242212>,
      <-0.000061, 0.626829, 3.406331>, <-0.248474, 0.626829, 3.406331>, <-0.338373, 0.396345, 3.406331>, <-0.325943, 0.253404, 3.406331>
    }
  }
  scale <1.0, 1.0, 0.8>
  rotate <-1.379681, 0.0, 0.0>
  translate  <-0.032159, -0.291667, 1.99743>
}
#declare shoe2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.406423, -0.868942, -0.413510>, <-0.406423, -0.907017, -0.413510>, <-0.229284, -0.938168, -0.413510>, <-0.012781, -0.938168, -0.413510>,
      <-0.875519, 0.000000, 0.137907>, <-0.875519, -0.550000, 0.137907>, <-0.481535, -1.000000, 0.137907>, <0.000000, -1.000000, 0.137907>,
      <-0.816594, 0.000000, 0.954648>, <-0.816594, -0.550000, 0.954648>, <-0.550000, -1.000000, 1.000000>, <0.000000, -1.000000, 1.000000>,
      <-0.808587, -0.015181, 1.468505>, <-0.800926, -0.550000, 1.484296>, <-0.463763, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.012781, -0.938168, -0.413510>, <0.203722, -0.938168, -0.413510>, <0.380861, -0.907017, -0.413510>, <0.380861, -0.868942, -0.413510>,
      <0.000000, -1.000000, 0.137907>, <0.481535, -1.000000, 0.137907>, <0.875519, -0.550000, 0.137907>, <0.875519, 0.000000, 0.137907>,
      <0.000000, -1.000000, 1.000000>, <0.550000, -1.000000, 1.000000>, <0.816594, -0.550000, 0.954648>, <0.816594, 0.000000, 0.954648>,
      <0.000000, -1.000000, 1.500000>, <0.463763, -1.000000, 1.500000>, <0.784050, -0.550000, 1.470400>, <0.791382, -0.015181, 1.454826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.380861, -0.868942, -0.413510>, <0.380861, -0.830868, -0.413510>, <0.203722, -0.799716, -0.413510>, <-0.012781, -0.799716, -0.413510>,
      <0.875519, 0.000000, 0.137907>, <0.875519, 0.550000, 0.137907>, <0.481535, 1.857290, 0.068701>, <0.000000, 1.857290, 0.068701>,
      <0.816594, 0.000000, 0.954648>, <0.816594, 0.550000, 0.954648>, <0.550000, -0.463665, 0.832724>, <0.000000, -0.463665, 0.832724>,
      <0.791382, -0.015181, 1.454826>, <0.784050, 0.519637, 1.439253>, <0.463763, -0.026547, 1.384998>, <0.000000, -0.026547, 1.384998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.012781, -0.799716, -0.413510>, <-0.229284, -0.799716, -0.413510>, <-0.406423, -0.830868, -0.413510>, <-0.406423, -0.868942, -0.413510>,
      <0.000000, 1.857290, 0.068701>, <-0.481535, 1.857290, 0.068701>, <-0.875519, 0.550000, 0.137907>, <-0.875519, 0.000000, 0.137907>,
      <0.000000, -0.463665, 0.832724>, <-0.550000, -0.463665, 0.832724>, <-0.816594, 0.550000, 0.954648>, <-0.816594, 0.000000, 0.954648>,
      <0.000000, -0.026547, 1.384998>, <-0.463763, -0.026547, 1.384998>, <-0.800926, 0.519637, 1.452713>, <-0.808587, -0.015181, 1.468505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.808587, -0.015181, 1.468505>, <-0.800926, -0.550000, 1.484296>, <-0.463763, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>,
      <-0.785257, -0.030363, 1.982361>, <-0.785257, -0.550000, 2.013944>, <-0.377526, -1.000000, 2.000000>, <0.000000, -1.000000, 2.000000>,
      <-0.686007, -0.405427, 2.570652>, <-0.686007, -0.550000, 2.529167>, <-0.377304, -1.000000, 2.529167>, <0.000000, -1.000000, 2.529167>,
      <-0.405785, -0.782021, 4.257990>, <-0.516080, -0.823730, 4.259494>, <-0.162520, -0.855320, 4.285456>, <0.000000, -0.855320, 4.285456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -1.000000, 1.500000>, <0.463763, -1.000000, 1.500000>, <0.784050, -0.550000, 1.470400>, <0.791382, -0.015181, 1.454826>,
      <0.000000, -1.000000, 2.000000>, <0.377526, -1.000000, 2.000000>, <0.751506, -0.550000, 1.986152>, <0.751506, -0.030363, 1.955005>,
      <0.000000, -1.000000, 2.529167>, <0.377304, -1.000000, 2.529167>, <0.686007, -0.550000, 2.529167>, <0.686007, -0.405427, 2.570652>,
      <0.000000, -0.855320, 4.285456>, <0.162520, -0.855320, 4.285456>, <0.295490, -0.823730, 4.285456>, <0.295490, -0.782021, 4.270971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.791382, -0.015181, 1.454826>, <0.784050, 0.519637, 1.439253>, <0.463763, -0.026547, 1.384998>, <0.000000, -0.026547, 1.384998>,
      <0.751506, -0.030363, 1.955005>, <0.751506, 0.489274, 1.923858>, <0.377526, 0.410572, 1.937271>, <0.000000, 0.410572, 1.937271>,
      <0.686007, -0.405427, 2.570652>, <0.686007, -0.260854, 2.612138>, <0.377304, 0.261354, 2.612138>, <0.000000, 0.261354, 2.612138>,
      <0.295490, -0.782021, 4.270971>, <0.295490, -0.740313, 4.256486>, <0.145412, -0.703653, 4.256486>, <-0.008554, -0.703653, 4.256486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.026547, 1.384998>, <-0.463763, -0.026547, 1.384998>, <-0.800926, 0.519637, 1.452713>, <-0.808587, -0.015181, 1.468505>,
      <0.000000, 0.410572, 1.937271>, <-0.377526, 0.410572, 1.937271>, <-0.785257, 0.489274, 1.950778>, <-0.785257, -0.030363, 1.982361>,
      <0.000000, 0.261354, 2.612138>, <-0.377304, 0.261354, 2.612138>, <-0.686007, -0.260854, 2.612138>, <-0.686007, -0.405427, 2.570652>,
      <-0.008554, -0.703653, 4.256486>, <-0.162520, -0.703653, 4.256486>, <-0.295490, -0.740313, 4.256486>, <-0.405785, -0.782021, 4.257990>
    }
  }
  texture {
    shoe_tex
  }
  scale <0.366679, 0.593548, 0.307837>
  rotate 88.684425*x
  translate  <0.0, 0.319469, -1.648088>
}
#declare foot2 = union {
  object { momo4 }
  object { momo5 }
  object { shoe2 }
  texture {
    suhada
  }
  scale <1.6, 1.3, 0.8>
  translate  <-0.833262, 2.732966, -1.43373>
}
#declare momo8 = union {
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.150887, 0.230326, -0.018524>, <-0.145697, 0.125182, -0.014919>, <-0.103348, 0.043424, -0.012116>, <-0.000009, 0.043424, -0.012116>,
      <-0.211950, 0.210825, 0.386757>, <-0.204660, 0.107193, 0.376660>, <-0.145173, 0.026611, 0.368809>, <-0.000013, 0.026611, 0.368809>,
      <-0.231603, 0.175131, 1.038066>, <-0.223637, 0.063136, 1.024418>, <-0.158633, -0.023950, 1.013805>, <-0.000014, -0.023950, 1.013805>,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000009, 0.043424, -0.012116>, <0.103330, 0.043424, -0.012116>, <0.146775, 0.130309, -0.015095>, <0.150810, 0.241644, -0.018912>,
      <-0.000013, 0.026611, 0.368809>, <0.145147, 0.026611, 0.368809>, <0.206174, 0.112246, 0.377153>, <0.211843, 0.221980, 0.387844>,
      <-0.000014, -0.023950, 1.013805>, <0.158606, -0.023950, 1.013805>, <0.225291, 0.068597, 1.025083>, <0.231486, 0.187187, 1.039535>,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <0.150810, 0.241644, -0.018912>, <0.154846, 0.352979, -0.022729>, <0.115415, 0.405634, -0.017058>, <-0.000028, 0.405634, -0.017058>,
      <0.211843, 0.221980, 0.387844>, <0.217512, 0.331714, 0.398536>, <0.162123, 0.404429, 0.408185>, <-0.000040, 0.404429, 0.408185>,
      <0.231486, 0.187187, 1.039535>, <0.237681, 0.305776, 1.053986>, <0.177156, 0.401478, 1.073866>, <-0.000044, 0.401478, 1.073866>,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000028, 0.405634, -0.017058>, <-0.115472, 0.405634, -0.017058>, <-0.156077, 0.335470, -0.022129>, <-0.150887, 0.230326, -0.018524>,
      <-0.000040, 0.404429, 0.408185>, <-0.162203, 0.404429, 0.408185>, <-0.219241, 0.314456, 0.396855>, <-0.211950, 0.210825, 0.386757>,
      <-0.000044, 0.401478, 1.073866>, <-0.177243, 0.401478, 1.073866>, <-0.239569, 0.287126, 1.051713>, <-0.231603, 0.175131, 1.038066>,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.281667, 0.188832, 1.934607>, <-0.271979, 0.039444, 1.927783>, <-0.192924, -0.063237, 1.916464>, <-0.000017, -0.063237, 1.916464>,
      <-0.331731, 0.202532, 2.831148>, <-0.320321, 0.015753, 2.831148>, <-0.227215, -0.102524, 2.819123>, <-0.000020, -0.102524, 2.819123>,
      <-0.323254, 0.124480, 3.222072>, <-0.312136, 0.009682, 3.222072>, <-0.221408, -0.079583, 3.222072>, <-0.000019, -0.079583, 3.222072>,
      <-0.233289, 0.161055, 3.514342>, <-0.224392, 0.070207, 3.514342>, <-0.159169, -0.001095, 3.514342>, <-0.000014, -0.001095, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000017, -0.063237, 1.916464>, <0.192890, -0.063237, 1.916464>, <0.273991, 0.046729, 1.928115>, <0.281525, 0.204912, 1.935341>,
      <-0.000020, -0.102524, 2.819123>, <0.227175, -0.102524, 2.819123>, <0.322690, 0.024861, 2.831148>, <0.331563, 0.222638, 2.831148>,
      <-0.000019, -0.079583, 3.222072>, <0.221370, -0.079583, 3.222072>, <0.314444, 0.015280, 3.222072>, <0.323090, 0.136837, 3.222072>,
      <-0.000014, -0.001095, 3.514342>, <0.159141, -0.001095, 3.514342>, <0.226052, 0.074678, 3.514342>, <0.232267, 0.171774, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <0.281525, 0.204912, 1.935341>, <0.289058, 0.363096, 1.942567>, <0.215450, 0.563595, 1.935100>, <-0.000053, 0.563595, 1.935100>,
      <0.331563, 0.222638, 2.831148>, <0.340436, 0.420415, 2.831148>, <0.253745, 0.725712, 2.796334>, <-0.000063, 0.725712, 2.796334>,
      <0.323090, 0.136837, 3.222072>, <0.331736, 0.258395, 3.222072>, <0.247261, 0.420547, 3.222072>, <-0.000061, 0.420547, 3.222072>,
      <0.232267, 0.171774, 3.514342>, <0.238483, 0.268869, 3.514342>, <0.177754, 0.398391, 3.514342>, <-0.000044, 0.398391, 3.514342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 2 v_steps 2,
      <-0.000053, 0.563595, 1.935100>, <-0.215557, 0.563595, 1.935100>, <-0.291355, 0.338219, 1.941431>, <-0.281667, 0.188832, 1.934607>,
      <-0.000063, 0.725712, 2.796334>, <-0.253870, 0.725712, 2.796334>, <-0.343141, 0.389312, 2.831148>, <-0.331731, 0.202532, 2.831148>,
      <-0.000061, 0.420547, 3.222072>, <-0.247383, 0.420547, 3.222072>, <-0.334372, 0.239278, 3.222072>, <-0.323254, 0.124480, 3.222072>,
      <-0.000044, 0.398391, 3.514342>, <-0.177842, 0.398391, 3.514342>, <-0.242185, 0.251903, 3.514342>, <-0.233289, 0.161055, 3.514342>
    }
  }
  texture {
    sox_tex
  }
  scale <1.0, 1.0, 1.024656>
  translate  <-0.016207, -0.12359, -1.550671>
}
#declare momo9 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.211950, 0.327032, -0.017647>, <-0.204660, 0.155524, -0.030938>, <-0.145173, 0.022163, -0.041272>, <-0.000013, 0.022163, -0.041272>,
      <-0.211950, 0.294892, 0.386757>, <-0.204660, 0.149937, 0.376660>, <-0.145173, 0.037222, 0.368809>, <-0.000013, 0.037222, 0.368809>,
      <-0.286483, 0.306381, 1.019166>, <-0.276629, 0.110452, 1.005518>, <-0.196222, -0.041898, 0.994906>, <-0.000017, -0.041898, 0.994906>,
      <-0.329426, 0.276208, 1.652601>, <-0.318095, 0.064794, 1.645777>, <-0.225636, -0.083222, 1.635616>, <-0.000020, -0.083222, 1.635616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000013, 0.022163, -0.041272>, <0.145147, 0.022163, -0.041272>, <0.206174, 0.163887, -0.030290>, <0.211843, 0.345493, -0.016216>,
      <-0.000013, 0.037222, 0.368809>, <0.145147, 0.037222, 0.368809>, <0.206174, 0.157005, 0.377153>, <0.211843, 0.310495, 0.387844>,
      <-0.000017, -0.041898, 0.994906>, <0.196188, -0.041898, 0.994906>, <0.278675, 0.120006, 1.006183>, <0.286337, 0.327471, 1.020635>,
      <-0.000020, -0.083222, 1.635616>, <0.225597, -0.083222, 1.635616>, <0.320448, 0.075103, 1.646110>, <0.329259, 0.298965, 1.653336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.211843, 0.345493, -0.016216>, <0.217512, 0.527100, -0.002143>, <0.162123, 0.610944, 0.011551>, <-0.000040, 0.610944, 0.011551>,
      <0.211843, 0.310495, 0.387844>, <0.217512, 0.463986, 0.398536>, <0.162123, 0.565698, 0.408185>, <-0.000040, 0.565698, 0.408185>,
      <0.286337, 0.327471, 1.020635>, <0.294000, 0.534936, 1.035086>, <0.219134, 0.702359, 1.054966>, <-0.000054, 0.702359, 1.054966>,
      <0.329259, 0.298965, 1.653336>, <0.338070, 0.522827, 1.660561>, <0.251982, 0.791975, 1.656446>, <-0.000062, 0.791975, 1.656446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000040, 0.610944, 0.011551>, <-0.162203, 0.610944, 0.011551>, <-0.219241, 0.498539, -0.004356>, <-0.211950, 0.327032, -0.017647>,
      <-0.000040, 0.565698, 0.408185>, <-0.162203, 0.565698, 0.408185>, <-0.219241, 0.439847, 0.396855>, <-0.211950, 0.294892, 0.386757>,
      <-0.000054, 0.702359, 1.054966>, <-0.219242, 0.702359, 1.054966>, <-0.296336, 0.502309, 1.032814>, <-0.286483, 0.306381, 1.019166>,
      <-0.000062, 0.791975, 1.656446>, <-0.252106, 0.791975, 1.656446>, <-0.340757, 0.487621, 1.659425>, <-0.329426, 0.276208, 1.652601>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.329426, 0.276208, 1.652601>, <-0.318095, 0.064794, 1.645777>, <-0.225636, -0.083222, 1.635616>, <-0.000020, -0.083222, 1.635616>,
      <-0.372370, 0.246035, 2.286037>, <-0.359562, 0.019137, 2.286037>, <-0.255049, -0.124546, 2.276327>, <-0.000022, -0.124546, 2.276327>,
      <-0.454074, 0.252826, 3.242212>, <-0.438457, 0.019665, 3.242212>, <-0.311012, -0.161637, 3.242212>, <-0.000027, -0.161637, 3.242212>,
      <-0.325943, 0.253404, 3.406331>, <-0.313513, 0.110463, 3.406331>, <-0.222385, -0.001723, 3.406331>, <-0.000019, -0.001723, 3.406331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000020, -0.083222, 1.635616>, <0.225597, -0.083222, 1.635616>, <0.320448, 0.075103, 1.646110>, <0.329259, 0.298965, 1.653336>,
      <-0.000022, -0.124546, 2.276327>, <0.255005, -0.124546, 2.276327>, <0.362221, 0.030201, 2.286037>, <0.372181, 0.270459, 2.286037>,
      <-0.000027, -0.161637, 3.242212>, <0.310958, -0.161637, 3.242212>, <0.441699, 0.031034, 3.242212>, <0.453845, 0.277924, 3.242212>,
      <-0.000019, -0.001723, 3.406331>, <0.222346, -0.001723, 3.406331>, <0.315832, 0.117498, 3.406331>, <0.324516, 0.270269, 3.406331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.329259, 0.298965, 1.653336>, <0.338070, 0.522827, 1.660561>, <0.251982, 0.791975, 1.656446>, <-0.000062, 0.791975, 1.656446>,
      <0.372181, 0.270459, 2.286037>, <0.382141, 0.510718, 2.286037>, <0.284830, 0.881591, 2.257926>, <-0.000070, 0.881591, 2.257926>,
      <0.453845, 0.277924, 3.242212>, <0.465990, 0.524814, 3.242212>, <0.347327, 0.854154, 3.242212>, <-0.000086, 0.854154, 3.242212>,
      <0.324516, 0.270269, 3.406331>, <0.333200, 0.423040, 3.406331>, <0.248352, 0.626829, 3.406331>, <-0.000061, 0.626829, 3.406331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.000062, 0.791975, 1.656446>, <-0.252106, 0.791975, 1.656446>, <-0.340757, 0.487621, 1.659425>, <-0.329426, 0.276208, 1.652601>,
      <-0.000070, 0.881591, 2.257926>, <-0.284970, 0.881591, 2.257926>, <-0.385177, 0.472934, 2.286037>, <-0.372370, 0.246035, 2.286037>,
      <-0.000086, 0.854154, 3.242212>, <-0.347498, 0.854154, 3.242212>, <-0.469692, 0.485987, 3.242212>, <-0.454074, 0.252826, 3.242212>,
      <-0.000061, 0.626829, 3.406331>, <-0.248474, 0.626829, 3.406331>, <-0.338373, 0.396345, 3.406331>, <-0.325943, 0.253404, 3.406331>
    }
  }
  scale <1.0, 1.0, 0.8>
  rotate -1.037578*x
  translate  <-0.018431, -0.277078, 2.024183>
}
#declare shoe3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.406423, -0.868942, -0.413510>, <-0.406423, -0.907017, -0.413510>, <-0.229284, -0.938168, -0.413510>, <-0.012781, -0.938168, -0.413510>,
      <-0.875519, 0.000000, 0.137907>, <-0.875519, -0.550000, 0.137907>, <-0.481535, -1.000000, 0.137907>, <0.000000, -1.000000, 0.137907>,
      <-0.816594, 0.000000, 0.954648>, <-0.816594, -0.550000, 0.954648>, <-0.550000, -1.000000, 1.000000>, <0.000000, -1.000000, 1.000000>,
      <-0.808587, -0.015181, 1.468505>, <-0.800926, -0.550000, 1.484296>, <-0.463763, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.012781, -0.938168, -0.413510>, <0.203722, -0.938168, -0.413510>, <0.380861, -0.907017, -0.413510>, <0.380861, -0.868942, -0.413510>,
      <0.000000, -1.000000, 0.137907>, <0.481535, -1.000000, 0.137907>, <0.875519, -0.550000, 0.137907>, <0.875519, 0.000000, 0.137907>,
      <0.000000, -1.000000, 1.000000>, <0.550000, -1.000000, 1.000000>, <0.816594, -0.550000, 0.954648>, <0.816594, 0.000000, 0.954648>,
      <0.000000, -1.000000, 1.500000>, <0.463763, -1.000000, 1.500000>, <0.784050, -0.550000, 1.470400>, <0.791382, -0.015181, 1.454826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.380861, -0.868942, -0.413510>, <0.380861, -0.830868, -0.413510>, <0.203722, -0.799716, -0.413510>, <-0.012781, -0.799716, -0.413510>,
      <0.875519, 0.000000, 0.137907>, <0.875519, 0.550000, 0.137907>, <0.481535, 1.857290, 0.068701>, <0.000000, 1.857290, 0.068701>,
      <0.816594, 0.000000, 0.954648>, <0.816594, 0.550000, 0.954648>, <0.550000, -0.463665, 0.832724>, <0.000000, -0.463665, 0.832724>,
      <0.791382, -0.015181, 1.454826>, <0.784050, 0.519637, 1.439253>, <0.463763, -0.026547, 1.384998>, <0.000000, -0.026547, 1.384998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.012781, -0.799716, -0.413510>, <-0.229284, -0.799716, -0.413510>, <-0.406423, -0.830868, -0.413510>, <-0.406423, -0.868942, -0.413510>,
      <0.000000, 1.857290, 0.068701>, <-0.481535, 1.857290, 0.068701>, <-0.875519, 0.550000, 0.137907>, <-0.875519, 0.000000, 0.137907>,
      <0.000000, -0.463665, 0.832724>, <-0.550000, -0.463665, 0.832724>, <-0.816594, 0.550000, 0.954648>, <-0.816594, 0.000000, 0.954648>,
      <0.000000, -0.026547, 1.384998>, <-0.463763, -0.026547, 1.384998>, <-0.800926, 0.519637, 1.452713>, <-0.808587, -0.015181, 1.468505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.808587, -0.015181, 1.468505>, <-0.800926, -0.550000, 1.484296>, <-0.463763, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>,
      <-0.785257, -0.030363, 1.982361>, <-0.785257, -0.550000, 2.013944>, <-0.377526, -1.000000, 2.000000>, <0.000000, -1.000000, 2.000000>,
      <-0.686007, -0.405427, 2.570652>, <-0.686007, -0.550000, 2.529167>, <-0.377304, -1.000000, 2.529167>, <0.000000, -1.000000, 2.529167>,
      <-0.405785, -0.782021, 4.257990>, <-0.516080, -0.823730, 4.259494>, <-0.162520, -0.855320, 4.285456>, <0.000000, -0.855320, 4.285456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -1.000000, 1.500000>, <0.463763, -1.000000, 1.500000>, <0.784050, -0.550000, 1.470400>, <0.791382, -0.015181, 1.454826>,
      <0.000000, -1.000000, 2.000000>, <0.377526, -1.000000, 2.000000>, <0.751506, -0.550000, 1.986152>, <0.751506, -0.030363, 1.955005>,
      <0.000000, -1.000000, 2.529167>, <0.377304, -1.000000, 2.529167>, <0.686007, -0.550000, 2.529167>, <0.686007, -0.405427, 2.570652>,
      <0.000000, -0.855320, 4.285456>, <0.162520, -0.855320, 4.285456>, <0.295490, -0.823730, 4.285456>, <0.295490, -0.782021, 4.270971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.791382, -0.015181, 1.454826>, <0.784050, 0.519637, 1.439253>, <0.463763, -0.026547, 1.384998>, <0.000000, -0.026547, 1.384998>,
      <0.751506, -0.030363, 1.955005>, <0.751506, 0.489274, 1.923858>, <0.377526, 0.410572, 1.937271>, <0.000000, 0.410572, 1.937271>,
      <0.686007, -0.405427, 2.570652>, <0.686007, -0.260854, 2.612138>, <0.377304, 0.261354, 2.612138>, <0.000000, 0.261354, 2.612138>,
      <0.295490, -0.782021, 4.270971>, <0.295490, -0.740313, 4.256486>, <0.145412, -0.703653, 4.256486>, <-0.008554, -0.703653, 4.256486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.026547, 1.384998>, <-0.463763, -0.026547, 1.384998>, <-0.800926, 0.519637, 1.452713>, <-0.808587, -0.015181, 1.468505>,
      <0.000000, 0.410572, 1.937271>, <-0.377526, 0.410572, 1.937271>, <-0.785257, 0.489274, 1.950778>, <-0.785257, -0.030363, 1.982361>,
      <0.000000, 0.261354, 2.612138>, <-0.377304, 0.261354, 2.612138>, <-0.686007, -0.260854, 2.612138>, <-0.686007, -0.405427, 2.570652>,
      <-0.008554, -0.703653, 4.256486>, <-0.162520, -0.703653, 4.256486>, <-0.295490, -0.740313, 4.256486>, <-0.405785, -0.782021, 4.257990>
    }
  }
  texture {
    shoe_tex
  }
  scale <0.366679, 0.593548, 0.307837>
  rotate 88.684425*x
  translate  <0.0, 0.319469, -1.648088>
}
#declare foot3 = union {
  object { momo8 }
  object { momo9 }
  object { shoe3 }
  texture {
    suhada
  }
  scale <1.6, 1.3, 0.8>
  translate  <0.260462, 2.65443, -1.43373>
}
#declare Group2 = union {
  object { foot2 }
  object { foot3 }
  texture {
    suhada
  }
  translate  <0.405687, -3.05724, 3.883228>
}
#declare girl = union {
  object { bousi1 }
  object { ude2 }
  object { head }
  object { ude1 }
  object { scaf }
  object { body1 }
  object { Group2 }
  rotate <-1.781294, 0.897446, -0.013952>
  translate  <5.995515, 0.0, -16.55478>
}
#declare ro_udes1 = union {
  cylinder { // ro_ude1
    <0,0,1>, <0,0,0>, 1
    scale <0.758891, 0.758891, 5.098032>
    rotate <91.384209, 0.0, 0.0>
    translate  <3.616637, 5.162827, 6.971145>
  }
  cylinder { // ro_ude3
    <0,0,1>, <0,0,0>, 1
    scale <0.758891, 0.758891, 5.098032>
    rotate <99.759995, 0.0, 0.0>
    translate  <3.576621, 10.945193, 7.883513>
  }
  sphere { // ude_kan5
    <0,0,0>,1
    scale 0.898613
    translate  <3.616153, 5.36934, 6.993408>
  }
  sphere { // kata1
    <0,0,0>,1
    scale <1.554269, 1.0, 1.0>
    translate  <3.313028, 0.055956, 7.120224>
  }
  texture {
    Chrome_Metal1
  }
  rotate 179.138046*z
  translate  <0.053292, -0.019942, 0.0>
}
#declare asis1 = union {
  object { // asi3->asi
    asi
    rotate 0.0*y
    translate  <0.028158, 0.0, -7.124359>
  }
  cylinder { // asi1
    <0,0,1>, <0,0,0>, 1
    scale <0.860713, 1.348217, 6.780395>
    translate  <-1.323223, 0.0, -7.103617>
  }
  sphere { // ude_kan3
    <0,0,0>,1
    scale <0.898613, 1.414895, 1.001869>
    translate  <-1.329632, 0.0, -7.176947>
  }
  sphere { // ude_kan4
    <0,0,0>,1
    scale <0.898613, 1.414895, 1.001869>
    translate  <-1.329632, 0.0, -0.28582>
  }
  sphere { // Ro_asi
    <0,0,0>,1
    scale <1.170425, 2.050431, 1.005011>
    rotate 0.0*z
    translate  <-1.35037, -0.027584, -14.074914>
  }
  texture {
    Chrome_Metal1
  }
  translate  2.684559*x
}
#declare bousi = lathe {
  cubic_spline
  8  // control points
  <1.0, -1.0>,
  <2.0, -0.5>,
  <2.302401, 0.553951>,
  <1.278649, 0.457918>,
  <1.071472, 0.969917>,
  <0.486302, 1.008642>,
  <0.00171, 1.003553>,
  <0.001881, 1.007174>
  rotate <90,0,90>
  texture {
    bots_hat
  }
  translate  <-0.139287, 0.0, 11.351859>
}
#declare atamas = union {
  object { bousi }
  sphere { // kubi
    <0,0,0>,1
    scale 1.446647
    translate  <-0.063807, 0.0, 7.784421>
  }
  cylinder { // kao
    <0,0,1>, <0,0,0>, 1
    scale <1.41786, 1.487503, 3.158942>
    translate  <-0.069643, 0.0, 8.055277>
  }
  texture {
    Chrome_Metal1
  }
}
#declare asis = union {
  object { // asi2->asi
    asi
    rotate 0.0*y
    translate  <0.028158, 0.0, -7.124359>
  }
  object { asi }
  sphere { // ude_kan1
    <0,0,0>,1
    scale <0.898613, 1.414895, 1.001869>
    translate  <-1.329632, 0.0, -7.176947>
  }
  sphere { // ude_kan2
    <0,0,0>,1
    scale <0.898613, 1.414895, 1.001869>
    translate  <-1.329632, 0.0, -0.28582>
  }
  sphere { // Ro_asi1
    <0,0,0>,1
    scale <1.123639, 1.968468, 0.964837>
    rotate 0.0*z
    translate  <-1.297223, -0.073557, -14.061237>
  }
  texture {
    Chrome_Metal1
  }
}
#declare ro_udes = union {
  cylinder { // ro_ude
    <0,0,1>, <0,0,0>, 1
    scale <0.758891, 0.758891, 5.098032>
    rotate <-7.180347, -39.088921, -1.849968>
    translate  <6.698381, -0.802279, 3.074142>
  }
  cylinder { // ro_ude2
    <0,0,1>, <0,0,0>, 1
    scale <0.758891, 0.758891, 5.098032>
    rotate <-12.013752, -44.162758, 0.074696>
    translate  <10.434177, -1.822493, -0.702475>
  }
  sphere { // ude_kan
    <0,0,0>,1
    scale 0.898613
    translate  <6.884173, -0.856645, 3.036316>
  }
  sphere { // kata
    <0,0,0>,1
    scale <1.554269, 1.0, 1.0>
    translate  <3.047831, 0.0, 7.120224>
  }
  texture {
    Chrome_Metal1
  }
}
#declare bots = union {
  object { ro_udes1 }
  object { asis1 }
  object { atamas }
  object { asis }
  object { ro_udes }
  cylinder { // ro_body
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal1
    }
    scale <2.808318, 1.542495, 7.6305>
    translate  <0.0, -0.120555, -0.060277>
  }
  scale 0.6
  translate  <2.179298, 1.934683, -6.938539>
}
#declare bot_and_girl = union {
  object { girl }
  object { bots }
  scale 0.03
  rotate 30.777296*z
  translate  <-5.005385, 35.589854, 4.277029>
}
#declare kabes = union {
  sphere { // kabe
    <0,0,0>,1
    scale <0.011139, 0.271308, 0.065461>
    rotate 22.853489*z
    translate  <-4.485708, 34.862084, 2.781238>
  }
  sphere { // kabe1
    <0,0,0>,1
    scale <-0.009929, 0.238808, 0.065461>
    rotate 60.176418*z
    translate  <-4.979354, 34.417712, 2.783344>
  }
  sphere { // kabe2
    <0,0,0>,1
    scale <-0.016692, -0.561082, -0.065461>
    rotate <-180.0, 0.0, -5.89274>
    translate  <-4.532212, 35.677132, 2.781238>
  }
  sphere { // kabe3
    <0,0,0>,1
    scale <-0.012217, -0.528642, -0.065461>
    rotate <-180.0, 0.0, -79.459541>
    translate  <-5.704831, 34.437245, 2.781238>
  }
  sphere { // kabe4
    <0,0,0>,1
    scale <0.007427, 0.061809, 0.065461>
    rotate -26.392481*z
    translate  <-4.409925, 34.562396, 2.781238>
  }
  sphere { // kabe5
    <0,0,0>,1
    scale <0.006961, 0.08359, 0.065461>
    rotate -72.792564*z
    translate  <-4.69239, 34.321268, 2.781238>
  }
  sphere { // kabe6
    <0,0,0>,1
    scale <0.003903, 0.121095, 0.065461>
    rotate 29.149012*z
    translate  <-4.375478, 34.403941, 2.781238>
  }
  sphere { // kabe7
    <0,0,0>,1
    scale <0.003903, 0.121095, 0.065461>
    rotate 55.881516*z
    translate  <-4.519266, 34.278264, 2.781238>
  }
  sphere { // kabe8
    <0,0,0>,1
    scale <0.004935, 0.068814, 0.065461>
    rotate -48.502983*z
    translate  <-4.368251, 34.254504, 2.781238>
  }
}
#declare CSG001 = difference {
  object { kabes }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.095843, 1.117861, 0.059996>
    translate  <-5.384749, 35.310541, 2.720132>
  }
  texture {
    pastel_wall
  }
}
#declare TapSwp001 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  12  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-0.184559, 0.871836>,
  <-0.697648, 1.08291>,
  <-0.790289, 1.026699>,
  <-1.008308, 1.142244>,
  <-1.09139, 1.047836>,
  <-0.960968, 0.851552>,
  <-1.003944, 0.693742>,
  <-0.768534, 0.2762>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    pastel_hex
  }
  translate  <-5.461254, 35.302739, 1.782582>
}
#declare kabecsg = union {
  object { CSG001 }
  object { TapSwp001 }
  translate  <-0.066819, 0.328953, 1.01961>
}
union { // near
  object { guide }
  object { bot_and_girl }
  object { kabecsg }
  translate  <0.008088, 0.183278, 0.18416>
}




#declare HgtFld5 = object {
  height_field {
    tga "MIDORI.TGA"
    water_level 0.282
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    green_oka
  }
  scale <8.107047, 3.034482, 0.543489>
  translate  <0.8, -1.2, 0.8>
}
#declare HgtFld6 = object {
  height_field {
    tga "GAKE2.TGA"
    water_level 0.118
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    gake
  }
  scale <9.0, 4.209394, 1.5>
  translate  <0.75, -0.1, -0.05>
}
union { // oka2
  object { HgtFld5 }
  object { HgtFld6 }
  scale <300.0, 58.0, 80.0>
  rotate 88.179337*z
  translate  <1095.268851, -2630.86802, -19.385978>
}


#declare HgtFld2 = object {
  height_field {
    tga "MIDORI.TGA"
    water_level 0.282
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    green_oka
  }
  scale <7.983411, 2.988204, 0.535201>
  translate  <0.8, -1.2, 0.8>
}
#declare HgtFld001 = object {
  height_field {
    tga "GAKE2.TGA"
    water_level 0.1309
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    gake
  }
  hollow
  scale <9.0, 4.209394, 1.5>
  translate  <0.75, -0.1, -0.05>
}
#declare oka = union {
  object { HgtFld2 }
  object { HgtFld001 }
  rotate 22.422733*z
  translate  <10.090586, -23.16723, 2.748101>
}
#declare HgtFld3 = object {
  height_field {
    tga "MIDORI.TGA"
    water_level 0.282
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    green_oka
  }
  scale <8.107047, 3.034482, 0.543489>
  translate  <0.8, -1.2, 0.8>
}
#declare HgtFld4 = object {
  height_field {
    tga "GAKE2.TGA"
    water_level 0.118
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    gake
  }
  scale <9.0, 4.209394, 1.5>
  translate  <0.75, -0.1, -0.05>
}
#declare oka1 = union {
  object { HgtFld3 }
  object { HgtFld4 }
  rotate -3.896359*z
  translate  <-20.98384, -26.631157, 2.628929>
}
#declare okas = union {
  object { oka }
  object { oka1 }
  translate  <9.505019, -10.158543, 0.0>
}
#declare nizia = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      rainbow_t
    }
    scale <9.378242, 9.378242, 0.0001>
    rotate -90.0*x
    translate  <5.204665, -37.803068, 2.665804>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      rin_cut
    }
    scale <5.934202, 5.895854, 1.630132>
    rotate -90.0*x
    translate  <5.204665, -38.501778, 2.665804>
  }
  translate  1.272925*y
}
union { // gate
  object { okas }
  object { nizia }
}


sphere { // sora
  <0,0,0>,1
  texture {
    sora_tex
  }
  scale <341.557617, 351.240143, 5.480494>
  translate  <5.726, 0.0, 14.28486>
}


plane { // Plane001
  z,0
  texture {
    sea_tex
  }
}




#declare backwing = union {
  object { upne3 }
  object { // upne6->upne3
    upne3
    scale <1.234208, 1.0, 0.994288>
    rotate -180.0*y
    translate  <9.417724, 0.0, 0.190344>
  }
  translate  <-0.078743, 2.655109, -0.14241>
}
#declare Netank = union {
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-0.359655, -0.019139, 0.003670>, <-0.359655, -0.016320, 0.003670>, <-0.197810, -0.062015, 0.045169>, <0.019893, -0.062015, 0.047064>,
      <-1.419033, -0.176294, 0.464436>, <-1.419033, -0.328279, 0.483672>, <-0.780468, -0.596870, 0.483672>, <0.000000, -0.596870, 0.483672>,
      <-1.565152, -0.156407, 0.534454>, <-1.565152, -0.339642, 0.549549>, <-0.900594, -0.656609, 0.756962>, <0.073749, -0.656609, 0.754082>,
      <-2.179038, -0.147884, 0.784779>, <-2.179038, -0.333960, 0.800255>, <-1.203559, -0.703545, 0.900736>, <0.063262, -0.703545, 0.909510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.019893, -0.062015, 0.047064>, <0.237597, -0.062015, 0.048958>, <0.479085, -0.063700, 0.039485>, <0.479085, -0.065758, 0.039485>,
      <0.000000, -0.596870, 0.483672>, <0.780468, -0.596870, 0.483672>, <1.419033, -0.328279, 0.483672>, <1.419033, -0.176294, 0.464436>,
      <0.073749, -0.656609, 0.754082>, <1.048093, -0.656609, 0.751202>, <1.600838, -0.339642, 0.541406>, <1.600838, -0.156407, 0.526311>,
      <0.063262, -0.703545, 0.909510>, <1.330084, -0.703545, 0.918284>, <2.239046, -0.333960, 0.816611>, <2.239046, -0.147884, 0.800963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.479085, -0.065758, 0.039485>, <0.479085, -0.067817, 0.039485>, <0.380632, -0.021481, 0.000011>, <0.091411, -0.021481, 0.004814>,
      <1.419033, -0.176294, 0.464436>, <1.419033, -0.024309, 0.445199>, <0.780468, 0.318148, 0.450881>, <0.000000, 0.318148, 0.450881>,
      <1.600838, -0.156407, 0.526311>, <1.600838, 0.026829, 0.511215>, <1.025055, 0.437626, 0.594934>, <0.033433, 0.400694, 0.586334>,
      <2.239046, -0.147884, 0.800963>, <2.239046, 0.038193, 0.785315>, <1.318565, 0.476636, 0.812976>, <0.043104, 0.458170, 0.798634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.091411, -0.021481, 0.004814>, <-0.197810, -0.021481, 0.009617>, <-0.359655, -0.021958, 0.003670>, <-0.359655, -0.019139, 0.003670>,
      <0.000000, 0.318148, 0.450881>, <-0.780468, 0.318148, 0.450881>, <-1.419033, -0.024309, 0.445199>, <-1.419033, -0.176294, 0.464436>,
      <0.033433, 0.400694, 0.586334>, <-0.958189, 0.363761, 0.577733>, <-1.565152, 0.026829, 0.519358>, <-1.565152, -0.156407, 0.534454>,
      <0.043104, 0.458170, 0.798634>, <-1.232356, 0.439704, 0.784292>, <-2.179038, 0.038193, 0.769302>, <-2.179038, -0.147884, 0.784779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-2.179038, -0.147884, 0.784779>, <-2.179038, -0.333960, 0.800255>, <-1.203559, -0.703545, 0.900736>, <0.063262, -0.703545, 0.909510>,
      <-2.792923, -0.139361, 1.035104>, <-2.792923, -0.328279, 1.050961>, <-1.506524, -0.750480, 1.044510>, <0.052775, -0.750480, 1.064937>,
      <-1.584992, -0.139361, 2.445620>, <-1.584992, -0.357692, 2.467951>, <-0.776215, -0.873683, 2.287864>, <0.047680, -0.859475, 2.270748>,
      <-1.472280, -0.075167, 2.828612>, <-1.472280, -0.483646, 2.861722>, <-0.754089, -0.854403, 2.771679>, <0.047178, -0.847299, 2.756896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.063262, -0.703545, 0.909510>, <1.330084, -0.703545, 0.918284>, <2.239046, -0.333960, 0.816611>, <2.239046, -0.147884, 0.800963>,
      <0.052775, -0.750480, 1.064937>, <1.612074, -0.750480, 1.085365>, <2.877255, -0.328279, 1.091816>, <2.877255, -0.139361, 1.075615>,
      <0.047680, -0.859475, 2.270748>, <0.871574, -0.845267, 2.253632>, <1.620926, -0.357692, 2.448621>, <1.620926, -0.139361, 2.426418>,
      <0.047178, -0.847299, 2.756896>, <0.848444, -0.840195, 2.742114>, <1.546385, -0.483646, 2.839608>, <1.546385, -0.075167, 2.806562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <2.239046, -0.147884, 0.800963>, <2.239046, 0.038193, 0.785315>, <1.318565, 0.476636, 0.812976>, <0.043104, 0.458170, 0.798634>,
      <2.877255, -0.139361, 1.075615>, <2.877255, 0.049556, 1.059414>, <1.612074, 0.515646, 1.031018>, <0.052775, 0.515646, 1.010935>,
      <1.620926, -0.139361, 2.426418>, <1.620926, 0.078970, 2.404216>, <0.862695, 0.613014, 2.291623>, <-0.005840, 0.613014, 2.291623>,
      <1.546385, -0.075167, 2.806562>, <1.546385, 0.333312, 2.773517>, <0.844005, 0.680305, 2.707167>, <0.020418, 0.680305, 2.713362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.043104, 0.458170, 0.798634>, <-1.232356, 0.439704, 0.784292>, <-2.179038, 0.038193, 0.769302>, <-2.179038, -0.147884, 0.784779>,
      <0.052775, 0.515646, 1.010935>, <-1.506524, 0.515646, 0.990851>, <-2.792923, 0.049556, 1.019246>, <-2.792923, -0.139361, 1.035104>,
      <-0.005840, 0.613014, 2.291623>, <-0.874374, 0.613014, 2.291623>, <-1.584992, 0.078970, 2.423288>, <-1.584992, -0.139361, 2.445620>,
      <0.020418, 0.680305, 2.713362>, <-0.803168, 0.680305, 2.719558>, <-1.472280, 0.333312, 2.795502>, <-1.472280, -0.075167, 2.828612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-1.472280, -0.075167, 2.828612>, <-1.472280, -0.483646, 2.861722>, <-0.754089, -0.854403, 2.771679>, <0.047178, -0.847299, 2.756896>,
      <-1.359568, -0.010972, 3.211605>, <-1.359568, -0.609599, 3.255494>, <-0.731962, -0.835123, 3.255494>, <0.046676, -0.835123, 3.243044>,
      <-0.890055, 0.000000, 4.116518>, <-0.890055, -0.550000, 4.116518>, <-0.456262, -0.852441, 4.210803>, <0.006849, -0.852441, 4.186280>,
      <-0.727366, 0.000000, 5.017702>, <-0.727366, -0.550000, 5.017702>, <-0.383424, -0.852441, 5.064844>, <0.003410, -0.852441, 5.052583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.047178, -0.847299, 2.756896>, <0.848444, -0.840195, 2.742114>, <1.546385, -0.483646, 2.839608>, <1.546385, -0.075167, 2.806562>,
      <0.046676, -0.835123, 3.243044>, <0.825315, -0.835123, 3.230595>, <1.471844, -0.609599, 3.230595>, <1.471844, -0.010972, 3.186706>,
      <0.006849, -0.852441, 4.186280>, <0.469959, -0.852441, 4.161757>, <0.854496, -0.550000, 4.161757>, <0.854496, 0.000000, 4.161757>,
      <0.003410, -0.852441, 5.052583>, <0.390244, -0.852441, 5.040321>, <0.709558, -0.550000, 5.040321>, <0.709558, 0.000000, 5.040321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <1.546385, -0.075167, 2.806562>, <1.546385, 0.333312, 2.773517>, <0.844005, 0.680305, 2.707167>, <0.020418, 0.680305, 2.713362>,
      <1.471844, -0.010972, 3.186706>, <1.471844, 0.587655, 3.142818>, <0.825315, 0.747597, 3.122711>, <0.046676, 0.747597, 3.135102>,
      <0.854496, 0.000000, 4.161757>, <0.854496, 0.550000, 4.161757>, <0.469959, 0.786860, 4.092447>, <0.006849, 0.786860, 4.116768>,
      <0.709558, 0.000000, 5.040321>, <0.709558, 0.550000, 5.040321>, <0.390244, 0.811453, 4.988923>, <0.003410, 0.811453, 5.001084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.020418, 0.680305, 2.713362>, <-0.803168, 0.680305, 2.719558>, <-1.472280, 0.333312, 2.795502>, <-1.472280, -0.075167, 2.828612>,
      <0.046676, 0.747597, 3.135102>, <-0.731962, 0.747597, 3.147493>, <-1.359568, 0.587655, 3.167717>, <-1.359568, -0.010972, 3.211605>,
      <0.006849, 0.786860, 4.116768>, <-0.456262, 0.786860, 4.141090>, <-0.890055, 0.550000, 4.116518>, <-0.890055, 0.000000, 4.116518>,
      <0.003410, 0.811453, 5.001084>, <-0.383424, 0.811453, 5.013245>, <-0.727366, 0.550000, 5.017702>, <-0.727366, 0.000000, 5.017702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-0.727366, 0.000000, 5.017702>, <-0.727366, -0.550000, 5.017702>, <-0.383424, -0.852441, 5.064844>, <0.003410, -0.852441, 5.052583>,
      <-0.564678, 0.000000, 5.918885>, <-0.564678, -0.550000, 5.918885>, <-0.310586, -0.852441, 5.918885>, <-0.000029, -0.852441, 5.918885>,
      <-0.564678, 0.000000, 6.940087>, <-0.564678, -0.550000, 6.940087>, <-0.310586, -0.852441, 6.940087>, <-0.000029, -0.852441, 6.940087>,
      <-0.017422, -0.021557, 7.769449>, <-0.017422, -0.021509, 7.769449>, <-0.015900, -0.021470, 7.769449>, <-0.014039, -0.021470, 7.769449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.003410, -0.852441, 5.052583>, <0.390244, -0.852441, 5.040321>, <0.709558, -0.550000, 5.040321>, <0.709558, 0.000000, 5.040321>,
      <-0.000029, -0.852441, 5.918885>, <0.310528, -0.852441, 5.918885>, <0.564620, -0.550000, 5.918885>, <0.564620, 0.000000, 5.918885>,
      <-0.000029, -0.852441, 6.940087>, <0.310528, -0.852441, 6.940087>, <0.564620, -0.550000, 6.940087>, <0.564620, 0.000000, 6.940087>,
      <-0.014039, -0.021470, 7.769449>, <-0.012179, -0.021470, 7.769449>, <-0.010657, -0.021509, 7.769449>, <-0.010657, -0.021557, 7.769449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.709558, 0.000000, 5.040321>, <0.709558, 0.550000, 5.040321>, <0.390244, 0.811453, 4.988923>, <0.003410, 0.811453, 5.001084>,
      <0.564620, 0.000000, 5.918885>, <0.564620, 0.550000, 5.918885>, <0.310528, 0.836046, 5.885399>, <-0.000029, 0.836046, 5.885399>,
      <0.564620, 0.000000, 6.940087>, <0.564620, 0.550000, 6.940087>, <0.310528, 0.852441, 6.873115>, <-0.000029, 0.852441, 6.873115>,
      <-0.010657, -0.021557, 7.769449>, <-0.010657, -0.021605, 7.769449>, <-0.012179, -0.021644, 7.769449>, <-0.014039, -0.021644, 7.769449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.003410, 0.811453, 5.001084>, <-0.383424, 0.811453, 5.013245>, <-0.727366, 0.550000, 5.017702>, <-0.727366, 0.000000, 5.017702>,
      <-0.000029, 0.836046, 5.885399>, <-0.310586, 0.836046, 5.885399>, <-0.564678, 0.550000, 5.918885>, <-0.564678, 0.000000, 5.918885>,
      <-0.000029, 0.852441, 6.873115>, <-0.310586, 0.852441, 6.873115>, <-0.564678, 0.550000, 6.940087>, <-0.564678, 0.000000, 6.940087>,
      <-0.014039, -0.021644, 7.769449>, <-0.015900, -0.021644, 7.769449>, <-0.017422, -0.021605, 7.769449>, <-0.017422, -0.021557, 7.769449>
    }
  }
  texture {
    sahnpan_check
  }
  scale 3.0
  rotate 90.0*x
  translate  <4.635344, 5.202245, 5.499508>
}
#declare joint_wing = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  9  // control points
  <0.551233, 0.14146>,
  <-0.468903, 0.061595>,
  <-0.46491, -0.057602>,
  <0.555396, -0.1175>,
  <1.143756, -0.049616>,
  <1.139762, 0.069582>,
  <0.551233, 0.14146>,
  <-0.468903, 0.061595>,
  <-0.46491, -0.057602>
  rotate <90,0,90>
  scale 3.0
  rotate 180.0*z
  translate  <4.614266, -6.321849, 0.751392>
}
#declare hbwing = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.005465, 0.019128, 0.000000>, <-1.005465, -0.063603, 0.000000>, <-0.511744, -0.114647, 0.000000>, <0.038256, -0.114647, 0.000000>,
      <-0.284067, 0.019128, 0.500000>, <-0.284067, -0.063603, 0.500000>, <0.111282, -0.114647, 0.500000>, <0.349769, -0.114647, 0.500000>,
      <-0.284067, 0.019128, 1.000000>, <-0.284067, -0.063603, 1.000000>, <0.111282, -0.114647, 1.000000>, <0.349769, -0.114647, 1.000000>,
      <-0.310874, 0.019128, 1.746764>, <-0.310874, -0.063603, 1.746764>, <0.138114, -0.114647, 1.742646>, <0.363185, -0.114647, 1.621323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.038256, -0.114647, 0.000000>, <0.588256, -0.114647, 0.000000>, <0.606913, 0.007444, -0.049186>, <0.612378, 0.010930, -0.049186>,
      <0.349769, -0.114647, 0.500000>, <0.588256, -0.114647, 0.500000>, <0.606913, 0.007444, 0.450814>, <0.612378, 0.010930, 0.450814>,
      <0.349769, -0.114647, 1.000000>, <0.588256, -0.114647, 1.000000>, <0.885232, 0.007444, 0.983605>, <0.890697, 0.010930, 0.983605>,
      <0.363185, -0.114647, 1.621323>, <0.588256, -0.114647, 1.500000>, <0.885232, 0.007444, 1.483605>, <0.890697, 0.010930, 1.483605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.612378, 0.010930, -0.049186>, <0.617843, 0.014416, -0.049186>, <0.320867, 0.202090, -0.032791>, <-0.089973, 0.202090, -0.016395>,
      <0.612378, 0.010930, 0.450814>, <0.617843, 0.014416, 0.450814>, <0.320867, 0.202090, 0.467209>, <0.221540, 0.202090, 0.483605>,
      <0.890697, 0.010930, 0.983605>, <0.896162, 0.014416, 0.983605>, <0.599186, 0.202090, 1.000000>, <0.360699, 0.202090, 1.000000>,
      <0.890697, 0.010930, 1.483605>, <0.896162, 0.014416, 1.483605>, <0.599186, 0.202090, 1.500000>, <0.374165, 0.202090, 1.621323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.089973, 0.202090, -0.016395>, <-0.500814, 0.202090, 0.000000>, <-1.005465, 0.101859, 0.000000>, <-1.005465, 0.019128, 0.000000>,
      <0.221540, 0.202090, 0.483605>, <0.122212, 0.202090, 0.500000>, <-0.284067, 0.101859, 0.500000>, <-0.284067, 0.019128, 0.500000>,
      <0.360699, 0.202090, 1.000000>, <0.122212, 0.202090, 1.000000>, <-0.284067, 0.101859, 1.000000>, <-0.284067, 0.019128, 1.000000>,
      <0.374165, 0.202090, 1.621323>, <0.149143, 0.202090, 1.742646>, <-0.310874, 0.101859, 1.746764>, <-0.310874, 0.019128, 1.746764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.310874, 0.019128, 1.746764>, <-0.310874, -0.063603, 1.746764>, <0.138114, -0.114647, 1.742646>, <0.363185, -0.114647, 1.621323>,
      <-0.337682, 0.019128, 2.493528>, <-0.337682, -0.063603, 2.493528>, <0.164947, -0.114647, 2.485291>, <0.376601, -0.114647, 2.242646>,
      <-1.005465, 0.019128, 2.516395>, <-1.005465, -0.063603, 2.516395>, <-0.511744, -0.114647, 2.500000>, <0.038256, -0.114647, 2.500000>,
      <-1.013663, 0.019128, 3.016395>, <-1.013663, -0.063603, 3.016395>, <-0.511744, -0.114647, 3.000000>, <0.038256, -0.114647, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.363185, -0.114647, 1.621323>, <0.588256, -0.114647, 1.500000>, <0.885232, 0.007444, 1.483605>, <0.890697, 0.010930, 1.483605>,
      <0.376601, -0.114647, 2.242646>, <0.588256, -0.114647, 2.000000>, <0.885232, 0.007444, 1.983605>, <0.890697, 0.010930, 1.983605>,
      <0.038256, -0.114647, 2.500000>, <0.588256, -0.114647, 2.500000>, <1.278722, 0.007444, 2.500000>, <1.284187, 0.010930, 2.500000>,
      <0.038256, -0.114647, 3.000000>, <0.588256, -0.114647, 3.000000>, <1.278722, 0.007444, 3.000000>, <1.284187, 0.010930, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.890697, 0.010930, 1.483605>, <0.896162, 0.014416, 1.483605>, <0.599186, 0.202090, 1.500000>, <0.374165, 0.202090, 1.621323>,
      <0.890697, 0.010930, 1.983605>, <0.896162, 0.014416, 1.983605>, <0.599186, 0.202090, 2.000000>, <0.387630, 0.202090, 2.242646>,
      <1.284187, 0.010930, 2.500000>, <1.289652, 0.014416, 2.500000>, <0.599186, 0.202090, 2.500000>, <0.049186, 0.202090, 2.500000>,
      <1.284187, 0.010930, 3.000000>, <1.289652, 0.014416, 3.000000>, <0.599186, 0.202090, 3.000000>, <0.049186, 0.202090, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.374165, 0.202090, 1.621323>, <0.149143, 0.202090, 1.742646>, <-0.310874, 0.101859, 1.746764>, <-0.310874, 0.019128, 1.746764>,
      <0.387630, 0.202090, 2.242646>, <0.176074, 0.202090, 2.485291>, <-0.337682, 0.101859, 2.493528>, <-0.337682, 0.019128, 2.493528>,
      <0.049186, 0.202090, 2.500000>, <-0.500814, 0.202090, 2.500000>, <-1.005465, 0.101859, 2.516395>, <-1.005465, 0.019128, 2.516395>,
      <0.049186, 0.202090, 3.000000>, <-0.500814, 0.202090, 3.000000>, <-1.013663, 0.101859, 3.016395>, <-1.013663, 0.019128, 3.016395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.013663, 0.019128, 3.016395>, <-1.013663, -0.063603, 3.016395>, <-0.511744, -0.114647, 3.000000>, <0.038256, -0.114647, 3.000000>,
      <-1.021861, 0.019128, 3.516395>, <-1.021861, -0.063603, 3.516395>, <-0.511744, -0.114647, 3.500000>, <0.038256, -0.114647, 3.500000>,
      <-0.354373, 0.019128, 3.498313>, <-0.354373, -0.063603, 3.498313>, <0.164947, -0.114647, 3.490076>, <0.376601, -0.114647, 3.745038>,
      <-0.327418, 0.019128, 4.249157>, <-0.327418, -0.063603, 4.249157>, <0.170905, -0.114647, 4.253236>, <0.379581, -0.114647, 4.376618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.038256, -0.114647, 3.000000>, <0.588256, -0.114647, 3.000000>, <1.278722, 0.007444, 3.000000>, <1.284187, 0.010930, 3.000000>,
      <0.038256, -0.114647, 3.500000>, <0.588256, -0.114647, 3.500000>, <1.278722, 0.007444, 3.500000>, <1.284187, 0.010930, 3.500000>,
      <0.376601, -0.114647, 3.745038>, <0.588256, -0.114647, 4.000000>, <0.885232, 0.007444, 4.000000>, <0.890697, 0.010930, 4.000000>,
      <0.379581, -0.114647, 4.376618>, <0.588256, -0.114647, 4.500000>, <0.885232, 0.007444, 4.500000>, <0.890697, 0.010930, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.284187, 0.010930, 3.000000>, <1.289652, 0.014416, 3.000000>, <0.599186, 0.202090, 3.000000>, <0.049186, 0.202090, 3.000000>,
      <1.284187, 0.010930, 3.500000>, <1.289652, 0.014416, 3.500000>, <0.599186, 0.202090, 3.500000>, <0.049186, 0.202090, 3.500000>,
      <0.890697, 0.010930, 4.000000>, <0.896162, 0.014416, 4.000000>, <0.599186, 0.202090, 4.000000>, <0.387630, 0.202090, 3.745038>,
      <0.890697, 0.010930, 4.500000>, <0.896162, 0.014416, 4.500000>, <0.599186, 0.202090, 4.500000>, <0.390560, 0.202090, 4.376618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.049186, 0.202090, 3.000000>, <-0.500814, 0.202090, 3.000000>, <-1.013663, 0.101859, 3.016395>, <-1.013663, 0.019128, 3.016395>,
      <0.049186, 0.202090, 3.500000>, <-0.500814, 0.202090, 3.500000>, <-1.021861, 0.101859, 3.516395>, <-1.021861, 0.019128, 3.516395>,
      <0.387630, 0.202090, 3.745038>, <0.176074, 0.202090, 3.490076>, <-0.354373, 0.101859, 3.498313>, <-0.354373, 0.019128, 3.498313>,
      <0.390560, 0.202090, 4.376618>, <0.181934, 0.202090, 4.253236>, <-0.327418, 0.101859, 4.249157>, <-0.327418, 0.019128, 4.249157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.327418, 0.019128, 4.249157>, <-0.327418, -0.063603, 4.249157>, <0.170905, -0.114647, 4.253236>, <0.379581, -0.114647, 4.376618>,
      <-0.300462, 0.019128, 5.000000>, <-0.300462, -0.063603, 5.000000>, <0.176864, -0.114647, 5.016395>, <0.382560, -0.114647, 5.008198>,
      <-0.201283, 0.019128, 5.466940>, <-0.201283, -0.063603, 5.466940>, <0.176864, -0.114647, 5.516395>, <0.243400, -0.114647, 5.491802>,
      <-1.005465, 0.019128, 6.000000>, <-1.005465, -0.063603, 6.000000>, <-0.511744, -0.114647, 6.000000>, <-0.100903, -0.114647, 5.983605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.379581, -0.114647, 4.376618>, <0.588256, -0.114647, 4.500000>, <0.885232, 0.007444, 4.500000>, <0.890697, 0.010930, 4.500000>,
      <0.382560, -0.114647, 5.008198>, <0.588256, -0.114647, 5.000000>, <0.885232, 0.007444, 5.000000>, <0.890697, 0.010930, 5.000000>,
      <0.243400, -0.114647, 5.491802>, <0.309937, -0.114647, 5.467209>, <0.606913, 0.007444, 5.467209>, <0.612378, 0.010930, 5.467209>,
      <-0.100903, -0.114647, 5.983605>, <0.309937, -0.114647, 5.967209>, <0.606913, 0.007444, 5.967209>, <0.612378, 0.010930, 5.967209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.890697, 0.010930, 4.500000>, <0.896162, 0.014416, 4.500000>, <0.599186, 0.202090, 4.500000>, <0.390560, 0.202090, 4.376618>,
      <0.890697, 0.010930, 5.000000>, <0.896162, 0.014416, 5.000000>, <0.599186, 0.202090, 5.000000>, <0.393490, 0.202090, 5.008198>,
      <0.612378, 0.010930, 5.467209>, <0.617843, 0.014416, 5.467209>, <0.320867, 0.202090, 5.467209>, <0.254331, 0.202090, 5.491802>,
      <0.612378, 0.010930, 5.967209>, <0.617843, 0.014416, 5.967209>, <0.320867, 0.202090, 5.967209>, <-0.089973, 0.202090, 5.983605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.390560, 0.202090, 4.376618>, <0.181934, 0.202090, 4.253236>, <-0.327418, 0.101859, 4.249157>, <-0.327418, 0.019128, 4.249157>,
      <0.393490, 0.202090, 5.008198>, <0.187794, 0.202090, 5.016395>, <-0.300462, 0.101859, 5.000000>, <-0.300462, 0.019128, 5.000000>,
      <0.254331, 0.202090, 5.491802>, <0.187794, 0.202090, 5.516395>, <-0.201283, 0.101859, 5.466940>, <-0.201283, 0.019128, 5.466940>,
      <-0.089973, 0.202090, 5.983605>, <-0.500814, 0.202090, 6.000000>, <-1.005465, 0.101859, 6.000000>, <-1.005465, 0.019128, 6.000000>
    }
  }
  scale <1.664744, 1.0, 1.549136>
  rotate <-90.0, 0.0, -90.0>
}
#declare body = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.421042, -0.415834, -2.398291>, <-0.471264, -0.460309, -2.383032>, <-0.266922, -0.468577, -2.380196>, <-0.007727, -0.468577, -2.380196>,
      <-0.893430, -0.149396, -1.196356>, <-1.000000, -0.720497, -1.444047>, <-0.566395, -0.772014, -1.503106>, <-0.016395, -0.772014, -1.503106>,
      <-0.893430, -0.128431, 1.000000>, <-1.000000, -0.550000, 1.000000>, <-0.566395, -0.628371, 1.000000>, <-0.016395, -0.628371, 1.000000>,
      <-0.893430, -0.128431, 1.500000>, <-1.000000, -0.550000, 1.500000>, <-0.566395, -0.628371, 1.500000>, <-0.016395, -0.628371, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.007727, -0.468577, -2.380196>, <0.251469, -0.468577, -2.380196>, <0.471264, -0.460309, -2.383032>, <0.412027, -0.412662, -2.399379>,
      <-0.016395, -0.772014, -1.503106>, <0.533605, -0.772014, -1.503106>, <1.000000, -0.720497, -1.444047>, <0.874302, -0.129637, -1.173705>,
      <-0.016395, -0.628371, 1.000000>, <0.533605, -0.628371, 1.000000>, <1.000000, -0.550000, 1.000000>, <0.874302, -0.098373, 1.000000>,
      <-0.016395, -0.628371, 1.500000>, <0.533605, -0.628371, 1.500000>, <1.000000, -0.550000, 1.500000>, <0.874302, -0.098373, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.412027, -0.412662, -2.399379>, <0.352790, -0.365016, -2.415725>, <0.259195, -0.296784, -2.439134>, <0.000000, -0.296784, -2.439134>,
      <0.874302, -0.129637, -1.173705>, <0.748604, 0.461223, -0.903362>, <0.550000, 0.886364, -0.415987>, <0.000000, 0.886364, -0.415987>,
      <0.874302, -0.098373, 1.000000>, <0.748604, 0.353255, 1.000000>, <0.550000, 1.000000, 1.000000>, <0.000000, 1.000000, 1.000000>,
      <0.874302, -0.098373, 1.500000>, <0.748604, 0.353255, 1.500000>, <0.550000, 1.000000, 1.500000>, <0.000000, 1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.296784, -2.439134>, <-0.259195, -0.296784, -2.439134>, <-0.370819, -0.371358, -2.413549>, <-0.421042, -0.415834, -2.398291>,
      <0.000000, 0.886364, -0.415987>, <-0.550000, 0.886364, -0.415987>, <-0.786860, 0.421705, -0.948665>, <-0.893430, -0.149396, -1.196356>,
      <0.000000, 1.000000, 1.000000>, <-0.550000, 1.000000, 1.000000>, <-0.786860, 0.293138, 1.000000>, <-0.893430, -0.128431, 1.000000>,
      <0.000000, 1.000000, 1.500000>, <-0.550000, 1.000000, 1.500000>, <-0.786860, 0.293138, 1.500000>, <-0.893430, -0.128431, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.893430, -0.128431, 1.500000>, <-1.000000, -0.550000, 1.500000>, <-0.566395, -0.628371, 1.500000>, <-0.016395, -0.628371, 1.500000>,
      <-0.893430, -0.128431, 2.000000>, <-1.000000, -0.550000, 2.000000>, <-0.566395, -0.628371, 2.000000>, <-0.016395, -0.628371, 2.000000>,
      <-0.893430, -0.128431, 2.500000>, <-1.000000, -0.550000, 2.500000>, <-0.566395, -0.628371, 2.500000>, <-0.016395, -0.628371, 2.500000>,
      <-0.893430, -0.128431, 3.000000>, <-1.000000, -0.550000, 3.000000>, <-0.566395, -0.628371, 3.000000>, <-0.016395, -0.628371, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016395, -0.628371, 1.500000>, <0.533605, -0.628371, 1.500000>, <1.000000, -0.550000, 1.500000>, <0.874302, -0.098373, 1.500000>,
      <-0.016395, -0.628371, 2.000000>, <0.533605, -0.628371, 2.000000>, <1.000000, -0.550000, 2.000000>, <0.874302, -0.098373, 2.000000>,
      <-0.016395, -0.628371, 2.500000>, <0.533605, -0.628371, 2.500000>, <1.000000, -0.550000, 2.500000>, <0.874302, -0.098373, 2.500000>,
      <-0.016395, -0.628371, 3.000000>, <0.533605, -0.628371, 3.000000>, <1.000000, -0.550000, 3.000000>, <0.874302, -0.098373, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.874302, -0.098373, 1.500000>, <0.748604, 0.353255, 1.500000>, <0.550000, 1.000000, 1.500000>, <0.000000, 1.000000, 1.500000>,
      <0.874302, -0.098373, 2.000000>, <0.748604, 0.353255, 2.000000>, <0.550000, 1.000000, 2.000000>, <0.000000, 1.000000, 2.000000>,
      <0.874302, -0.098373, 2.500000>, <0.748604, 0.353255, 2.500000>, <0.550000, 1.000000, 2.500000>, <0.000000, 1.000000, 2.500000>,
      <0.874302, -0.098373, 3.000000>, <0.748604, 0.353255, 3.000000>, <0.550000, 1.000000, 3.000000>, <0.000000, 1.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 1.500000>, <-0.550000, 1.000000, 1.500000>, <-0.786860, 0.293138, 1.500000>, <-0.893430, -0.128431, 1.500000>,
      <0.000000, 1.000000, 2.000000>, <-0.550000, 1.000000, 2.000000>, <-0.786860, 0.293138, 2.000000>, <-0.893430, -0.128431, 2.000000>,
      <0.000000, 1.000000, 2.500000>, <-0.550000, 1.000000, 2.500000>, <-0.786860, 0.293138, 2.500000>, <-0.893430, -0.128431, 2.500000>,
      <0.000000, 1.000000, 3.000000>, <-0.550000, 1.000000, 3.000000>, <-0.786860, 0.293138, 3.000000>, <-0.893430, -0.128431, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.893430, -0.128431, 3.000000>, <-1.000000, -0.550000, 3.000000>, <-0.566395, -0.628371, 3.000000>, <-0.016395, -0.628371, 3.000000>,
      <-0.893430, -0.128431, 3.500000>, <-1.000000, -0.550000, 3.500000>, <-0.566395, -0.628371, 3.500000>, <-0.016395, -0.628371, 3.500000>,
      <-0.893430, -0.128431, 4.000000>, <-1.000000, -0.550000, 4.000000>, <-0.566395, -0.628371, 4.000000>, <-0.016395, -0.628371, 4.000000>,
      <-0.773523, -0.139185, 4.492316>, <-0.865791, -0.539920, 4.492316>, <-0.490380, -0.609846, 4.492316>, <-0.014195, -0.609846, 4.492316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016395, -0.628371, 3.000000>, <0.533605, -0.628371, 3.000000>, <1.000000, -0.550000, 3.000000>, <0.874302, -0.098373, 3.000000>,
      <-0.016395, -0.628371, 3.500000>, <0.533605, -0.628371, 3.500000>, <1.000000, -0.550000, 3.500000>, <0.874302, -0.098373, 3.500000>,
      <-0.016395, -0.628371, 4.000000>, <0.533605, -0.628371, 4.000000>, <1.000000, -0.550000, 4.000000>, <0.874302, -0.098373, 4.000000>,
      <-0.014195, -0.609846, 4.492316>, <0.461990, -0.609846, 4.492316>, <0.865791, -0.539920, 4.492316>, <0.756962, -0.112365, 4.492316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.874302, -0.098373, 3.000000>, <0.748604, 0.353255, 3.000000>, <0.550000, 1.000000, 3.000000>, <0.000000, 1.000000, 3.000000>,
      <0.874302, -0.098373, 3.500000>, <0.748604, 0.353255, 3.500000>, <0.550000, 1.000000, 3.500000>, <0.000000, 1.000000, 3.500000>,
      <0.874302, -0.098373, 4.000000>, <0.748604, 0.353255, 4.000000>, <0.550000, 1.000000, 4.000000>, <0.000000, 1.000000, 4.000000>,
      <0.756962, -0.112365, 4.492316>, <0.648134, 0.315189, 4.492316>, <0.476185, 0.892243, 4.492316>, <0.000000, 0.892243, 4.492316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 3.000000>, <-0.550000, 1.000000, 3.000000>, <-0.786860, 0.293138, 3.000000>, <-0.893430, -0.128431, 3.000000>,
      <0.000000, 1.000000, 3.500000>, <-0.550000, 1.000000, 3.500000>, <-0.786860, 0.293138, 3.500000>, <-0.893430, -0.128431, 3.500000>,
      <0.000000, 1.000000, 4.000000>, <-0.550000, 1.000000, 4.000000>, <-0.786860, 0.293138, 4.000000>, <-0.893430, -0.128431, 4.000000>,
      <0.000000, 0.892243, 4.492316>, <-0.476185, 0.892243, 4.492316>, <-0.681256, 0.261551, 4.492316>, <-0.773523, -0.139185, 4.492316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.773523, -0.139185, 4.492316>, <-0.865791, -0.539920, 4.492316>, <-0.490380, -0.609846, 4.492316>, <-0.014195, -0.609846, 4.492316>,
      <-0.653616, -0.149938, 4.984632>, <-0.731581, -0.529840, 4.984632>, <-0.414364, -0.591321, 4.984632>, <-0.011995, -0.591321, 4.984632>,
      <-0.448675, -0.210819, 5.570723>, <-0.502193, -0.532513, 5.499491>, <-0.284440, -0.580357, 5.499491>, <-0.008234, -0.580357, 5.499491>,
      <-0.029135, -0.417446, 5.918565>, <-0.032610, -0.420801, 5.918565>, <-0.018470, -0.421425, 5.918565>, <-0.000535, -0.421425, 5.918565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.014195, -0.609846, 4.492316>, <0.461990, -0.609846, 4.492316>, <0.865791, -0.539920, 4.492316>, <0.756962, -0.112365, 4.492316>,
      <-0.011995, -0.591321, 4.984632>, <0.390375, -0.591321, 4.984632>, <0.731581, -0.529840, 4.984632>, <0.639623, -0.126358, 4.984632>,
      <-0.008234, -0.580357, 5.499491>, <0.267973, -0.580357, 5.499491>, <0.502193, -0.532513, 5.499491>, <0.439069, -0.192469, 5.570723>,
      <-0.000535, -0.421425, 5.918565>, <0.017401, -0.421425, 5.918565>, <0.032610, -0.420801, 5.918565>, <0.028511, -0.417206, 5.918565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.756962, -0.112365, 4.492316>, <0.648134, 0.315189, 4.492316>, <0.476185, 0.892243, 4.492316>, <0.000000, 0.892243, 4.492316>,
      <0.639623, -0.126358, 4.984632>, <0.547664, 0.277124, 4.984632>, <0.402370, 0.784486, 4.984632>, <0.000000, 0.784486, 4.984632>,
      <0.439069, -0.192469, 5.570723>, <0.375944, 0.147575, 5.641956>, <0.276206, 0.498536, 5.595047>, <0.000000, 0.498536, 5.595047>,
      <0.028511, -0.417206, 5.918565>, <0.024412, -0.413611, 5.918565>, <0.017935, -0.408463, 5.918565>, <0.000000, -0.408463, 5.918565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.892243, 4.492316>, <-0.476185, 0.892243, 4.492316>, <-0.681256, 0.261551, 4.492316>, <-0.773523, -0.139185, 4.492316>,
      <0.000000, 0.784486, 4.984632>, <-0.402370, 0.784486, 4.984632>, <-0.575652, 0.229963, 4.984632>, <-0.653616, -0.149938, 4.984632>,
      <0.000000, 0.498536, 5.595047>, <-0.276206, 0.498536, 5.595047>, <-0.395156, 0.110874, 5.641956>, <-0.448675, -0.210819, 5.570723>,
      <0.000000, -0.408463, 5.918565>, <-0.017935, -0.408463, 5.918565>, <-0.025659, -0.414090, 5.918565>, <-0.029135, -0.417446, 5.918565>
    }
  }
  texture {
    sahnpan_body
  }
  hollow
  scale 1.5
  rotate 90.0*x
  translate  <4.622997, -4.191227, 0.554605>
}
#declare bodys = difference {
  object { body }
  cylinder { // body_cut
    <0,0,1>, <0,0,0>, 1
    scale <0.321049, 0.122279, 2.534897>
    rotate -90.0*y
    translate  <5.873114, -2.810011, -0.005005>
  }
}
#declare ship = union {
  object { backwing }
  object { Netank }
  object { joint_wing }
  object { bhwings }
  object { // bhwings1->bhwings
    bhwings
    translate  4.697589*x
  }
  object { hbwing }
  object { bodys }
  cylinder { // shaft_cover
    <0,0,1>, <0,0,0>, 1 open
    texture {
      wing_tex
    }
    scale <0.324857, 0.133154, 2.534897>
    rotate -90.0*y
    translate  <5.873114, -2.807731, -0.006795>
  }
  texture {
    wing_tex
  }
  translate  0.028692*z
}
#declare mesure_fan = union {
  sphere { // ring_sin
    <0,0,0>,1
    scale <0.122443, 0.264853, 0.118227>
  }
  cylinder { // ctl_ring
    <0,0,1>, <0,0,0>, 1
    scale <-0.026431, -0.026431, 1.0>
    rotate <90.0, 0.0, -180.0>
    translate  <0.0, -0.038679, 0.0>
  }
  object { // ctr_fan11->ctr_fan
    ctr_fan
    rotate 30.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan10->ctr_fan
    ctr_fan
    rotate 60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan9->ctr_fan
    ctr_fan
    rotate 90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan8->ctr_fan
    ctr_fan
    rotate <-180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan7->ctr_fan
    ctr_fan
    rotate <-180.0, 30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan6->ctr_fan
    ctr_fan
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan5->ctr_fan
    ctr_fan
    rotate <-180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan4->ctr_fan
    ctr_fan
    rotate <-180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan3->ctr_fan
    ctr_fan
    rotate -90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan2->ctr_fan
    ctr_fan
    rotate -60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // ctr_fan1->ctr_fan
    ctr_fan
    rotate -30.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { ctr_fan }
  cylinder { // jikuwuke
    <0,0,1>, <0,0,0>, 1
    scale <0.059437, 0.059437, 0.286009>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.003131, 0.666362, -0.001812>
  }
  texture {
    Chrome_Tex
  }
  rotate 180.0*z
  translate  <4.603926, -4.764951, 2.455281>
}
#declare baloon_top = lathe {
  quadratic_spline
  5  // control points
  <0.320753, -1.924902>,
  <0.306977, -1.377398>,
  <0.524111, -0.725259>,
  <0.341734, 0.007142>,
  <0.012459, 0.473754>
  rotate <90,0,90>
  texture {
    sahnpan_body
  }
  scale <1.50817, 1.632383, 1.14101>
  rotate 89.582993*x
  translate  <4.632416, -17.560325, 5.452326>
}
#declare mado_FRONT = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  7  // control points
  <-0.277217, 0.684402>,
  <-1.264987, 0.258734>,
  <-1.267151, -0.24623>,
  <-0.262374, -0.654324>,
  <-0.277217, 0.684402>,
  <-1.264987, 0.258734>,
  <-1.267151, -0.24623>
  rotate <90,0,90>
  texture {
    madogluss
  }
  scale <1.373611, 1.364945, 1.908844>
  rotate <180.0, 0.0, 180.0>
  translate  <4.634299, -10.938096, 2.623221>
}
#declare FRONT_GLUSS = difference {
  object { mado_FRONT }
  box { // GLUSS_CUT
    <-1, -1, -1>, <1, 1, 1>
    texture {
      madogluss
    }
    scale <0.906384, 0.899595, 0.895709>
    translate  <4.624997, -11.809299, 1.892035>
  }
}
#declare WAKU_TATE = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.068156>,
  <1.0, -0.907789>,
  <1.003993, 0.924368>,
  <-1.0, 1.080151>,
  <-1.0, -1.068156>
  rotate -x*90
  scale <-0.182643, -0.902478, -0.085192>
  rotate <90.0, 90.0, 0.0>
  translate  <4.626338, -11.460551, 0.839665>
}
#declare WAKU1 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <0.795559, 0.930024>,
  <-0.811198, 0.927954>,
  <-0.308706, -0.420747>,
  <0.312409, -0.42466>,
  <0.795559, 0.930024>,
  <-0.811198, 0.927954>,
  <-0.308706, -0.420747>
  rotate -x*90
  scale <1.0, 0.86, 0.060178>
  translate  <4.621027, -12.091511, 0.960187>
}
#declare WAKU = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <0.795559, 0.930024>,
  <-0.811198, 0.927954>,
  <-0.308706, -0.420747>,
  <0.312409, -0.42466>,
  <0.795559, 0.930024>,
  <-0.811198, 0.927954>,
  <-0.308706, -0.420747>
  rotate -x*90
  scale <1.088857, 0.999167, 0.052708>
  translate  <4.621027, -12.240904, 0.656452>
}
#declare WAKUS = union {
  object { WAKU_TATE }
  object { WAKU1 }
  object { WAKU }
}
#declare front_panel = union {
  object { FRONT_GLUSS }
  object { WAKUS }
  texture {
    wing_tex
  }
  scale <1.0, 0.974469, 1.012766>
  translate  <0.0, -0.204249, 0.127656>
}
#declare RIGHT_MADOS = union {
  object { taiatu_mado }
  object { // taiatu_mado3->taiatu_mado
    taiatu_mado
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -3.6, 0.0>
  }
  object { // taiatu_mado2->taiatu_mado
    taiatu_mado
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -2.4, 0.0>
  }
  object { // taiatu_mado1->taiatu_mado
    taiatu_mado
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.2, 0.0>
  }
}
#declare taiatu_mado4 = union {
  cylinder { // mado_gluss1
    <0,0,1>, <0,0,0>, 1
    texture {
      madogluss
    }
    scale <1.0, 1.0, 0.2>
    translate  <-0.013662, 0.0, -0.119956>
  }
  torus { // MADOWAKU1
    1.5, 0.2  rotate -x*90
    scale <0.72, 0.72, 0.653187>
    rotate 11.197577*z
  }
  scale <0.3, 0.3, 0.300462>
  rotate <0.0, -67.618385, 0.0>
  translate  <3.520329, -5.167743, 1.080597>
}
#declare RIGHT_MADOS1 = union {
  object { taiatu_mado4 }
  object { // taiatu_mado5->taiatu_mado
    taiatu_mado
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -3.6, 0.0>
  }
  object { // taiatu_mado6->taiatu_mado
    taiatu_mado
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -2.4, 0.0>
  }
  object { // taiatu_mado7->taiatu_mado
    taiatu_mado
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.2, 0.0>
  }
  rotate <180.0, 44.324429, 180.0>
  translate  <7.475573, 0.0, 4.321805>
}
#declare mados = union {
  object { RIGHT_MADOS }
  object { RIGHT_MADOS1 }
  texture {
    wing_tex
  }
}
#declare fin_wing1 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  12  // control points
  <-0.194349, 1.077474>,
  <-0.122594, 1.33693>,
  <-0.07406, 1.469735>,
  <0.057397, 1.479331>,
  <0.121885, 1.33469>,
  <0.077112, 1.084183>,
  <0.146363, -0.236591>,
  <-0.143248, 0.139966>,
  <-0.098629, 1.091117>,
  <-0.194349, 1.077474>,
  <-0.122594, 1.33693>,
  <-0.07406, 1.469735>
  rotate <90,0,90>
  texture {
    sahnpan_body
  }
  scale <2.035227, 1.848093, 1.094798>
  rotate -90.0*x
  translate  <5.758881, -10.537184, 0.01816>
}
#declare fin_wing = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  12  // control points
  <-0.194349, -1.077474>,
  <-0.122594, -1.33693>,
  <-0.07406, -1.469735>,
  <0.057397, -1.479331>,
  <0.121885, -1.33469>,
  <0.077112, -1.084183>,
  <0.146363, 0.236591>,
  <-0.143248, -0.139966>,
  <-0.098629, -1.091117>,
  <-0.194349, -1.077474>,
  <-0.122594, -1.33693>,
  <-0.07406, -1.469735>
  rotate <90,0,90>
  scale <2.035227, 1.848093, 1.094798>
  rotate -90.0*x
  translate  <3.521085, -10.537184, 0.01816>
}
#declare fan_wings = union {
  object { // fan_rope1->fan_rope
    fan_rope
    rotate <0.0, 12.052798, 0.0>
    translate  <3.363901, 0.0, 0.618518>
  }
  object { fan_rope }
  object { fin_wing1 }
  object { fin_wing }
}
#declare main_fans = union {
  object { pros }
  object { // pros1->pros
    pros
    rotate <0.0, 0.0, 0.0>
    translate  <7.865993, 0.0, 0.0>
  }
  object { side_move_out }
  cylinder { // side_shaft
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.1, 7.727761>
    rotate -90.0*y
    translate  <8.493723, -2.258926, 0.026296>
  }
  object { // side_move_in->side_move_out
    side_move_out
    texture {
      rope_tex
    }
    rotate <0.0, 0.0, 0.0>
    translate  -0.426501*z
  }
  object { fan_wings }
  object { // sub_bar1->sub_bar
    sub_bar
    rotate <180.0, -20.07052, -180.0>
    translate  <9.176664, 0.0, -0.176872>
  }
  object { sub_bar }
  object { // bhjoint4->bhjoint3
    bhjoint3
    rotate <0.0, 0.0, 0.0>
    translate  2.412292*x
  }
  object { bhjoint3 }
  object { bhjoint1 }
  object { // bhjoint2->bhjoint1
    bhjoint1
    rotate <0.0, 0.0, 0.0>
    translate  <1.323053, 0.0, 0.0>
  }
  texture {
    wing_tex
  }
}
union { // new_baloon
  object { ship }
  object { mesure_fan }
  object { baloon_top }
  object { front_panel }
  object { mados }
  object { main_fans }
  torus { // body_joint
    1.5, 0.1  rotate -x*90
    texture {
      sahnpan_body
    }
    scale <0.215019, 1.423518, 1.040125>
    translate  <4.595281, -7.003442, 2.984964>
  }
  torus { // body_joint1
    1.5, 0.1  rotate -x*90
    texture {
      sahnpan_body
    }
    scale <0.149255, 0.903619, 1.040125>
    rotate <-1.578544, 0.0, 0.0>
    translate  <4.595281, -6.772376, 2.060701>
  }
  scale 0.125
  rotate <-3.673033, -3.11056, -10.478554>
  translate  <-1.478832, 27.17817, 2.225275>
}


#declare planets = difference {
  sphere { // planet2
    <0,0,0>,1
    texture {
      planet_tex1
    }
    hollow
    scale <9633.869141, 7791.900391, 6665.316895>
    translate  <2957.096653, -8591.381119, -2576.307031>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    texture {
      z_fog
    }
    scale <-12138.027344, -2718.781982, -5021.416992>
    rotate <-90.008736, -0.780681, 1.548431>
    translate  <3159.93111, -423.542617, -1162.763559>
  }
  translate  <-1194.080802, -23727.115187, -187.894997>
}
union { // backs
  object { planets }
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    texture {
      z_fog
    }
    scale <7191.747559, 3830.642578, 2439.268799>
    rotate <-94.354149, 1.136703, -0.021733>
    translate  <1319.211178, -23069.345337, -1417.48886>
  }
  disc { // Disc2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      z_fog
    }
    scale <16314.993164, 3018.28418, 2380.890869>
    rotate <-94.354149, 1.136703, -0.021733>
    translate  <1681.096596, -22655.19982, -1417.48886>
  }
  rotate 0.974128*y
}


#declare airports = union {
  object { port }
  object { // port3->port
    port
    rotate 90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // port2->port
    port
    rotate -180.0*z
  }
  object { // port1->port
    port
    rotate -90.0*z
  }
}
#declare Group004 = union {
  object { // CYLi1->CYLi
    CYLi
    texture {
      LightT
    }
    rotate -90.0*z
  }
  object { CYLi }
  texture {
    LightT
  }
}
#declare oblights = union {
  object { // LightSP5->LightSP
    LightSP
    rotate 60.0*z
    translate  0.0*y
  }
  object { // LightSP4->LightSP
    LightSP
    rotate 120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // LightSP3->LightSP
    LightSP
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // LightSP2->LightSP
    LightSP
    rotate -120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // LightSP1->LightSP
    LightSP
    rotate -60.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { LightSP }
}
#declare CSG13 = union {
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate 30.0*z
}
#declare CSG12 = union {
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate 60.0*z
}
#declare CSG11 = union {
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate 90.0*z
}
#declare CSG10 = union {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate 120.0*z
}
#declare CSG9 = union {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate 150.0*z
}
#declare CSG8 = union {
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate 180.0*z
}
#declare CSG7 = union {
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate -150.0*z
}
#declare CSG6 = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate -120.0*z
}
#declare CSG5 = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate -90.0*z
}
#declare CSG4 = union {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate -60.0*z
}
#declare CSG3 = union {
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
  rotate -30.0*z
}
#declare CSG002 = union {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.063262, 1.107451, 1.442418>
    rotate -98.864182*x
    translate  <0.0, -5.036729, -0.661893>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.0, -0.142145, -3.861179>
    rotate <8.100866, 0.0, -180.0>
    translate  <0.0, -5.147131, -1.358271>
  }
}
#declare Group001 = union {
  object { CSG13 }
  object { CSG12 }
  object { CSG11 }
  object { CSG10 }
  object { CSG9 }
  object { CSG8 }
  object { CSG7 }
  object { CSG6 }
  object { CSG5 }
  object { CSG4 }
  object { CSG3 }
  object { CSG002 }
}
//
// Include file contains 'RotSwp001'
//
#include "oworld.in2"
#declare RotSwp001 = object {
  RotSwp001_Raw
  scale <2.0, 2.0, 3.0>
}
#declare RotSwp002 = lathe {
  linear_spline
  4  // control points
  <1.0, -1.0>,
  <1.518054, -0.581244>,
  <1.524808, 0.531946>,
  <1.007986, 1.01198>
  rotate <90,0,90>
  scale <1.4, 1.415867, 6.427222>
  translate  8.68535*z
}
#declare Group003 = union {
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 18.0>
    rotate 60.0*z
    translate  <-2.022168, 1.108069, -0.457149>
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 18.0>
    rotate 120.0*z
    translate  <-1.9707, -1.197214, -0.457149>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 18.0>
    rotate 180.0*z
    translate  <0.051468, -2.305283, -0.457149>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 18.0>
    rotate -120.0*z
    translate  <2.022168, -1.108069, -0.457149>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 18.0>
    rotate -60.0*z
    translate  <1.9707, 1.197214, -0.457149>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 18.0>
    translate  <-0.051468, 2.305283, -0.457149>
  }
}
#declare deffracter = union {
  disc { // disc5
    <0,0,0>, <0,0,1>, 1.0
    scale 4.441949
    translate  7.642681*z
  }
  disc { // disc4
    <0,0,0>, <0,0,1>, 1.0
    texture {
      LightT
    }
    scale 4.441949
    translate  6.642681*z
  }
  disc { // disc3
    <0,0,0>, <0,0,1>, 1.0
    scale 4.441949
    translate  5.642681*z
  }
  disc { // disc2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      LightT
    }
    scale 4.441949
    translate  4.642681*z
  }
  disc { // disc001
    <0,0,0>, <0,0,1>, 1.0
    scale 4.441949
    translate  3.642681*z
  }
  texture {
    Lightdif
  }
}
#declare TapSwp3 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  7  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.499151, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.523111, 0.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <1.0, 2.424255, 0.881312>
  rotate <-90.0, 0.0, 120.0>
  translate  <2.334545, 1.362478, 11.236429>
}
#declare TapSwp2 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  7  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.499151, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.523111, 0.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <1.0, 2.424255, 0.881312>
  rotate <-90.0, 0.0, -120.0>
  translate  <-2.347213, 1.340536, 11.236429>
}
#declare TapSwp4 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  7  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.499151, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.523111, 0.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <1.0, 2.424255, 0.881312>
  rotate -90.0*x
  translate  <0.012668, -2.703014, 11.236429>
}
#declare Group002 = union {
  object { TapSwp3 }
  object { TapSwp2 }
  object { TapSwp4 }
}
#declare Group006 = union {
  object { // pipe5->pipe
    pipe
    rotate <0.0, 0.0, 60.0>
    translate  0.0*y
  }
  object { // pipe4->pipe
    pipe
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // pipe3->pipe
    pipe
    rotate <0.0, 0.0, -180.0>
    translate  0.0*x
  }
  object { // pipe2->pipe
    pipe
    rotate <0.0, 0.0, -120.0>
    translate  0.0*y
  }
  object { // pipe1->pipe
    pipe
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { pipe }
  object { // tank5->tank
    tank
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tank4->tank
    tank
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tank3->tank
    tank
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tank2->tank
    tank
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tank1->tank
    tank
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { tank }
}
#declare TapSwp002 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    LightT
  }
  scale <1.0, 1.0, 17.569517>
  rotate 180.0*x
  translate  <0.0, 0.0, 32.980614>
}
#declare TapTOp = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-1.0, 1.0>,
  <-0.500849, 0.003993>,
  <-1.0, -1.0>,
  <-0.003993, -0.496855>,
  <1.0, -1.0>,
  <0.488869, 0.003993>,
  <1.0, 1.0>,
  <0.003993, 0.500849>,
  <-1.0, 1.0>,
  <-0.500849, 0.003993>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    Meca_Chrome1
  }
  scale <1.379998, 1.37, 24.116659>
  rotate <180.0, 0.0, 180.0>
  translate  39.323981*z
}
#declare Tower = union {
  object { TapSwp002 }
  object { TapTOp }
}
#declare jetnose = union {
  object { Group001 }
  object { RotSwp001 }
  object { RotSwp002 }
  object { Group003 }
  object { deffracter }
  object { Group002 }
  object { Group006 }
  cylinder { // BaseCylinder
    <0,0,1>, <0,0,0>, 1
    texture {
      Meca_Chrome2
    }
    scale <14.0, 14.0, 2.0>
    rotate <0.0, 0.0, 0.167395>
    translate  -7.396335*z
  }
  object { Tower }
  texture {
    Meca_Chrome1
  }
}
#declare city__ring = lathe {
  linear_spline
  4  // control points
  <1.0, -1.0>,
  <2.0, -0.5>,
  <2.0, 0.5>,
  <1.0, 1.0>
  rotate <90,0,90>
  scale <0.8, 0.8, 0.4>
  translate  -0.024969*x
}
#declare city_wing = union {
  object { city__ring }
  object { // city_pro3->city_pro
    city_pro
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // city_pro2->city_pro
    city_pro
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // city_pro1->city_pro
    city_pro
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { city_pro }
  texture {
    Meca_Chrome2
  }
  scale <3.75, 3.75, 1.875>
  rotate <-180.0, 0.0, -20.0>
  translate  <0.031617, -0.016844, 18.357806>
}
union { // CityMeca
  object { airports }
  object { Group004 }
  object { oblights }
  object { jetnose }
  sphere { // BaseLight
    <0,0,0>,1
    texture {
      Meca_Chrome1
    }
    scale <-29.903234, -29.9, -11.136609>
    translate  -16.878561*z
  }
  cone { // base_cone
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Meca_Chrome1
    }
    scale <43.081284, 43.081284, 19.67864>
    rotate -180.0*x
    translate  <0.041496, -0.021713, -2.953778>
  }
  object { city_wing }
  scale <6.0, 6.0, 3.0>
  rotate -180.0*x
  translate  <160.654663, -1331.198183, 124.518208>
}


