// Lightposts for playground
// Robert Fremin 1997
// objects:
//		lightpost1
//		lightpost2
//		lightpost3  (this one is not complete, used in my scene)


#declare LIGHTPOWER = 500	// distance to fade-off point



//
// A smaller lightpost
//

#declare lamp =
cone
{
	y*-.25 .1 y*.25 .3
	pigment { White }
#if (night)
	finish { Luminous }
#else
	finish { ambient .5 specular .3 phong .3 }
#end
}

#declare lightpost1 =
union
{
	cylinder { y*0 y*1 .15 }
	cone { y*1 .15 y*1.25 .1 }
	cylinder { y*1.2 y*3.5 .1 }
	#if (night)
		light_source
		{
			y*3.75 color Gray50
			fade_distance LIGHTPOWER fade_power 2
			looks_like { lamp }
//			area_light x*2 y*2 3 3
//			jitter
		}
	#else
		object { lamp translate y*3.75 }
	#end
	cone { y*4 .4 y*4.2 0 }

	scale <50,100,50>

	pigment { Gray90 }
	finish { phong .3 metallic }
}

// --------------------------------------------------------------------------


//
// A larger "road" lightpost
//

#declare lamp2 =
cylinder
{
//	x*.1 x*.97 .145
	x*-.4 x*.47 .145
	scale <1,.6,1>
	pigment { White }
#if (night)
	finish { Luminous }
#else
	finish { ambient .5 specular .3 phong .3 }
#end
}

#declare lightpost2 =
union
{
	cone { y*0 .2 y*.05 .15 pigment { Black } finish { specular .4 ambient .1 } }
	cylinder { y*0 y*1.9 .15 }

	// hatch
	union
	{
		#declare HRad = .14
		cylinder { y*.4 y*.9 HRad translate z*-HRad*.18 }

		intersection
		{
			cylinder { y*(.4-HRad) y*(.9+HRad) HRad translate z*-HRad*.18 }
			cylinder { z*0 z*-HRad*1.18 HRad translate y*.4 }
		}

		intersection
		{
			cylinder { y*(.4-HRad) y*(.9+HRad) HRad translate z*-HRad*.18 }
			cylinder { z*0 z*-HRad*1.18 HRad translate y*.9 }
		}

		cylinder { z*-HRad*1.18+y*.4 z*-HRad*1.25+y*.4 .02 }
		cylinder { z*-HRad*1.18+y*.9 z*-HRad*1.25+y*.9 .02 }

		translate y*.4
	}

	cone { y*1.9 .15 y*2 .11 }
	cylinder { y*2 y*3.9 .11 }
	cone { y*3.9 .11 y*4 .08 }
	cylinder { y*4 y*6 .08 }
	difference
	{
		cylinder { x*-.1 x*1 .15 scale <1,.6,1> rotate z*10 translate y*6 }
		object { lamp2 translate x*.5 rotate z*10 translate y*5.95 }
	}
	#if (night)
		light_source {
			0
			White
			fade_distance LIGHTPOWER
			fade_power 2
			looks_like { lamp2 }
//			area_light x*.5 y*.5 4 4
//			jitter
			translate x*.5 rotate z*10 translate y*5.95
		}
	#else
		object { lamp2 translate x*.5 rotate z*10 translate y*5.95 }
	#end

	scale <80,100,80>

	pigment { Grey }
	finish { specular .2 metallic }
}


//
//	"fake lamp"
//

#declare lightpost3 =
union
{
	cone { y*0 .2 y*.05 .15 pigment { Black } finish { specular .4 ambient .1 } }
	cylinder { y*0 y*2.1 .15 }

	// hatch
	union
	{
		#declare HRad = .14
		cylinder { y*.4 y*.9 HRad translate z*-HRad*.18 }

		intersection
		{
			cylinder { y*(.4-HRad) y*(.9+HRad) HRad translate z*-HRad*.18 }
			cylinder { z*0 z*-HRad*1.18 HRad translate y*.4 }
		}

		intersection
		{
			cylinder { y*(.4-HRad) y*(.9+HRad) HRad translate z*-HRad*.18 }
			cylinder { z*0 z*-HRad*1.18 HRad translate y*.9 }
		}

		cylinder { z*-HRad*1.18+y*.4 z*-HRad*1.25+y*.4 .02 }
		cylinder { z*-HRad*1.18+y*.9 z*-HRad*1.25+y*.9 .02 }

		translate y*.4
	}

	cone { y*2.1 .15 y*2.2 .13 }
	cylinder { y*2.2 y*3.9 .13 }

	scale <80,100,80>

	pigment { Grey }
	finish { specular .2 metallic }
}
