
// Persistence of Vision Ray Tracer Scene Description File
// File: childhood.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: started 11/26/97, finished 12/31/97
// Auth: Jared Saxton
//

#version 3

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "glass.inc"
#include "shampoo.inc"
#include "drain.inc"
#include "people.inc"
#include "boat.inc"
#include "witch.pov"

global_settings
{
  assumed_gamma 1.0
}

#declare display_knobs=1
#declare display_faucet=1
#declare display_tiles=1
#declare display_tub=1
#declare display_area_lights=1
#declare display_walls=1
#declare display_shampoo=1
#declare display_drain_switch=1
#declare display_water=1
#declare display_people=1

#declare knob_glass=texture{pigment{rgbf<1,1,0.85,0.9>} finish{F_Glass2}}
//#declare tile_tex=texture{pigment{SkyBlue} normal{quilted 1 control0 0 control1 0} finish{phong 1.0} scale 1}
#declare bottle_tex=texture{pigment { color rgbf<1.0, 1.0, 1.0, 1.0>} finish{ F_Glass1}}
#declare wall_tex_1=texture{pigment{bozo color_map{[0.0 0.3 color Clear color rgbf<0.18,0.31,0.18,0.6>][0.3 0.5 color rgbf<0.18,0.31,0.18,0.6> color Clear][0.5 1.0 color Clear color Clear]} turbulence 0.5 scale<1,5,1>}}
#declare wall_tex_2=texture{pigment{bozo color_map{[0.0 0.3 color Clear color rgbf<0.18,0.31,0.18,0.6>][0.3 0.5 color rgbf<0.18,0.31,0.18,0.6> color Clear][0.5 1.0 color Clear color Clear]} turbulence 0.5 scale<5,1,1>}}
#declare white_spots_1=texture{pigment{bozo color_map{[0.0 0.8 color Clear color rgbf<1,1,1,0.95>][0.8 1.0 color rgbf<1,1,1,0.95> color Clear]} turbulence 0.1 scale 0.4}}
#declare white_spots_2=texture{pigment{bozo color_map{[0.0 0.8 color rgbf<1,1,1,0.9> color Clear ][0.8 1.0 color Clear color rgbf<1,1,1,0.95>]} turbulence 0.1 scale 0.4}}
#declare DarkOrchid = color red 0.1 green 0.05 blue 0.3

// ----------------------------------------
//camera{location<4, -3, -26.0> direction 1.5*z right 4/3*x look_at <-4, -6,  0.0>}
camera{location<5, -3, -26.0> direction 1.5*z right 4/3*x look_at <-3, -6,  0.0>}

//camera{location<25, -6.5, -6> direction 1.5*z right 4/3*x look_at <11.5,-7,-5>}
//camera{location<10, -12, -35> direction 1.5*z right 4/3*x look_at <11.5,-7,-5>}

#if(display_area_lights=1)
 light_source
 {0*x color rgb <1,1,0.8> area_light <8, 0, 0> <0, 0, 8>
  4,4 adaptive 0 jitter translate <35, 48, -20>
 }

// light_source
// {0*x color rgb<0.225,0.2,0.25> area_light <8, 0, 0> <0, 0, 8>
//  4,4 adaptive 0 jitter translate <40, -8, -20>
// }

 light_source{0*x color rgb <0.1,0.1,0.4> area_light <8, 0, 0> <0, 0, 8>
  4, 4 adaptive 0 jitter translate <-13,45, -30>}

#else
 light_source{0*x color rgb <1,1,0.8> translate <35, 48, -20>}

// light_source{0*x color rgb<0.225,0.2,0.25> translate <40, -8, -20>}

 light_source{0*x color rgb <0.1,0.1,0.4> translate <-13,45, -30>}
#end




// ----------------------------------------
#default{pigment{Blue} finish{phong 1.0}}
#background{White}

#declare hot_knob=object{
union{
 merge{
  #declare z_rot=0
  #while(z_rot<=360)
   difference{
    sphere{<0,0,0>,1 scale<0.25,1,1.5>}
    box{<-10,-10,-10>,<10,10,-1.4>}
    box{<-10,-10,10>,<10,10,0.75>}
    rotate z*z_rot
    texture{knob_glass}
   }
   #declare z_rot=z_rot+20
  #end
 }
 union{
  cylinder{<0,0,10>,<0,0,-1.400001>,0.275 texture{T_Chrome_2C}}
  cylinder{<0,0,-1.4>,<0,0,-1.40001>,0.275 pigment{Black}}
  cylinder{<0,0,-1.4>,<0,0,-1.4001>,0.25 pigment{White}}
  union{
   box{<-0.1,-0.15,-1.4>,<-0.08,0.15,-1.4002>}
   box{<-0.1,0.01,-1.4>,<0.1,-0.01,-1.4002>}
   box{<0.1,-0.15,-1.4>,<0.08,0.15,-1.4002>}
   pigment{Black}
  }
  rotate<0,0,121>
 }
 sphere{<0,0,0>,0.275 scale<1,1,0.005> translate<0,0,-1.4> texture{bottle_tex}}
}
}

#declare plain_knob=object{
 union{
  merge{
   #declare z_rot=0
   #while(z_rot<=360)
    difference{
     sphere{<0,0,0>,1 scale<0.25,1,1.5>}
     box{<-10,-10,-10>,<10,10,-1.4>}
     box{<-10,-10,10>,<10,10,0.75>}
     rotate z*z_rot
     texture{knob_glass}
    }
    #declare z_rot=z_rot+20
   #end
  }
  union{
   cylinder{<0,0,10>,<0,0,-1.400001>,0.275 texture{T_Chrome_2C}}
   cylinder{<0,0,-1.4>,<0,0,-1.40001>,0.275 pigment{Black}}
   cylinder{<0,0,-1.4>,<0,0,-1.4001>,0.25 pigment{White}}
   difference{
    box{<0.245,0.245,-1.4>,<-0.245,-0.2,-1.4002>}
	box{<-10,-10,-10>,<0,10,10> rotate<0,0,-20> translate<0,0.25,0>}
	box{<0,-10,-10>,<10,10,10> rotate<0,0,20> translate<0,0.25,0>}
    pigment{Black}
   }
   rotate<0,0,-142>
  }
  sphere{<0,0,0>,0.275 scale<1,1,0.005> translate<0,0,-1.4> texture{bottle_tex}}
 }
}


#declare cold_knob=object{
 union{
  merge{
   #declare z_rot=0
   #while(z_rot<=360)
    difference{
     sphere{<0,0,0>,1 scale<0.25,1,1.5>}
     box{<-10,-10,-10>,<10,10,-1.4>}
     box{<-10,-10,10>,<10,10,0.75>}
     rotate z*z_rot
     texture{knob_glass}
    }
    #declare z_rot=z_rot+20
   #end
  }
  union{
   cylinder{<0,0,10>,<0,0,-1.400001>,0.275 texture{T_Chrome_2C}}
   cylinder{<0,0,-1.4>,<0,0,-1.40001>,0.275 pigment{Black}}
   cylinder{<0,0,-1.4>,<0,0,-1.4001>,0.25 pigment{White}}
   difference{
    cylinder{<0,0,-1.4>,<0,0,-1.4002>,0.12 scale<1,1.25,1>}
    cylinder{<0,0,-10>,<0,0,10>,0.1 scale<1,1.25,1>}
    box{<0,0.03,-10>,<10,-0.03,10>}
    pigment{Black}
   }
   rotate<0,0,16>
  }
  sphere{<0,0,0>,0.275 scale<1,1,0.005> translate<0,0,-1.4> texture{bottle_tex}}
 }
}

#declare knob_back=object{
 union{
  cylinder{<0,0,0>,<0,0,-0.25>,1.5}
  torus{1.25,0.25 rotate<90,0,0> translate<0,0,-0.25>}
  cylinder{<0,0,0>,<0,0,-1>,0.25}
  texture{pigment{Gray50}}
  texture{T_Chrome_2C}
 }
}

#declare faucet=object{
 union{
  cylinder{<0,0,0>,<0,0,-3>,1.25}
  intersection{
   difference{
    torus{2,1.25 rotate<0,0,90> translate<0,-2,-3>}
    torus{2,1.1 rotate<0,0,90> translate<0,-2,-3>}
   }
   box{<10,-2,-3>,<-10,10,-10>}
  }
 }
}

#declare tub=object{
 union{
  cylinder{<-6.5,-9,-1>,<10.5,-9,-1>,1}
  cylinder{<-12.5,-9,-7>,<-12.5,-9,-41>,1}
  cylinder{<16.5,-9,-7>,<16.5,-9,-41>,1}
  box{<-6.5,-23,0>,<10.5,-9,-2>}
  box{<-13.5,-23,-7>,<-11.5,-9,-41>}
  box{<15.5,-23,-7>,<17.5,-9,-41>}

  cylinder{<18.5,-9,0>,<18.5,-9,-48>,1}
  difference{
   box{<-13.5,-23,0>,<18.5,-8,-48>}
   box{<-12.5,-22,-7>,<16.5,100,-41>}
   box{<-6.5,-22,-1>,<10.5,100,-47>}
   cylinder{<-6.5,-9,-7>,<-6.5,100,-7>,6}
   cylinder{<10.5,-9,-7>,<10.5,100,-7>,6}
   cylinder{<-6.5,-9,-41>,<-6.5,100,-41>,6}
   cylinder{<10.5,-9,-41>,<10.5,100,-41>,6}

   cylinder{<-6.5,-22,-7>,<-6.5,100,-7>,5}
   cylinder{<10.5,-22,-7>,<10.5,100,-7>,5}
   cylinder{<-6.5,-22,-41>,<-6.5,100,-41>,5}
   cylinder{<10.5,-22,-41>,<10.5,100,-41>,5}

  }
  difference{
   union{
    torus{6,1 translate<-6.5,-9,-7>}
    torus{6,1 translate<10.5,-9,-7>}
    torus{6,1 translate<-6.5,-9,-41>}
    torus{6,1 translate<10.5,-9,-41>}
   }
   box{<-100,-22,-7>,<100,100,-41>}
   box{<-6.5,-22,100>,<10.5,100,-100>}
  }
 }
}

#if(display_tiles=1)
 #declare one_tile=object{
  union{
   box{<-1.825,-1.825,-0.155>,<1.825,1.825,1>}
   cylinder{<-1.825,-1.825,-0.005>,<-1.825,1.825,-0.005>,0.15}
   cylinder{<1.825,-1.825,-0.005>,<1.825,1.825,-0.005>,0.15}
   cylinder{<1.825,1.825,-0.005>,<-1.825,1.825,-0.005>,0.15}
   cylinder{<1.825,-1.825,-0.005>,<-1.825,-1.825,-0.005>,0.15}
   sphere{<1.825,1.825,-0.005>,0.15}
   sphere{<-1.825,1.825,-0.005>,0.15}
   sphere{<1.825,-1.825,-0.005>,0.15}
   sphere{<-1.825,-1.825,-0.005>,0.15}
  }
 }

 #declare tile_wall=object{
  union{
   #declare ytrans=-24
   #while(ytrans<=48)
    #declare xtrans=-100
    #while(xtrans<=100)
     object{one_tile translate<xtrans,ytrans,0>}
     #declare xtrans=xtrans+4
    #end
    #declare ytrans=ytrans+4
   #end
  }
 }

#end

//*** MAIN SCENE ***

#if(display_knobs=1)
 object{hot_knob translate<-4,0,-1.5>}
 object{knob_back translate<-4,0,0>}
 object{plain_knob translate<0,0,-1.5>}
 object{knob_back translate<0,0,0>}
 object{cold_knob translate<4,0,-1.5>}
 object{knob_back translate<4,0,0>}
#end

#if(display_faucet=1)
 object{faucet translate<0,-3.5,0> texture{T_Chrome_2C} texture{white_spots_1}}
#end

#if(display_tub=1)
 object{tub pigment{White}}
#end

#if(display_tiles=1)
 object{tile_wall texture{pigment{DarkOrchid}} texture{white_spots_1} texture{white_spots_2 translate<10,10,10>}}
 object{tile_wall rotate y*-90 translate<-13.5,0,0> texture{pigment{DarkOrchid}} texture{white_spots_1} texture{white_spots_2 translate<10,10,10>}}
 difference{
  box{<-13.5,-48,-0.5>,<-13,48,0>}
  cylinder{<-13,-48,-0.5>,<-13,48,-0.5>,0.4}
  texture{pigment{White}} texture{wall_tex_1} texture{wall_tex_2}
 }
 difference{
  box{<-13.5,-8,0>,<-13,-7.5,-50>}
  cylinder{<-13,-7.5,10>,<-13,-7.5,-60>,0.45}
  texture{pigment{White}} texture{wall_tex_1} texture{wall_tex_2}
 }
 difference{
  box{<-20,-8,0>,<100,-7.5,-0.5>}
  cylinder{<-100,-7.5,-0.5>,<100,-7.5,-0.5>,0.45}
  texture{pigment{White}} texture{wall_tex_1} texture{wall_tex_2}
 }
#end

#if(display_walls=1)
 union{
  box{<-100,-23,50>,<-13.4,100,-50>}
  box{<-13.25,-23,-0.1>,<100,100,10>}
  texture{pigment{White}} texture{wall_tex_1} texture{wall_tex_2}
 }
 union{
  box{<-100,70,100>,<100,80,-100>}
  box{<-13.25,-23,-50>,<100,100,-60>}
  box{<70,-23,50>,<71,100,-50>}
  box{<-100,-23,100>,<100,-30,-100>}
  texture{pigment{White}}
 }
#end

#if(display_shampoo=1)
 object{shampoo_labeled scale 0.85 rotate y*19 translate<-10.75,-8,-1.7> texture{bottle_tex}}
#end

#if(display_drain_switch=1)
 object{drain_switch translate<0,-12,-1> texture{T_Chrome_2C} texture{white_spots_2}}
#end

#if(display_water=1)
 blob
 {
  threshold 0.6
  sphere { < 0.75,0,0>,1,1}
  sphere { < 0.5,0,-0.5>,1,1}
  sphere { <1,0,0>,1,1}
  sphere { <-0.375,0,0>,1,1}
  sphere { <-0.75,0,-2>,1,0.65}
  sphere { <-0.35,0,-1>,1,0.15}
  sphere { <0,0,-1.56>,1,0.25}
  scale<1,0.2,1>
  scale 1.45
  translate<-11.85,-8.1,-1.8>
  texture{T_Glass1 finish{phong 1.0 ambient 0.76}}
 }
 difference{
  plane{y, -13}
  object{bullet translate<-4,-12.6,-5>}
  texture{T_Glass1 finish{phong 1.0 ambient 0.76} normal{waves 0.7 scale 0.125 translate<-4,-12.8,-5>}}
 }
 object{boat translate<-4,-12.6,-5> texture{pigment{color rgb<0.1,0.5,0.4>}}}
#end

#if(display_people=1)
 object{person_1 pigment{Blue} scale 0.8 rotate<0,0,0> translate<-12.5,-8,-2>}
 object{person_2 pigment{Red} scale 0.8 rotate<0,-87,0> translate<-12.5,-8,-4.25>}
 object{person_3 pigment{BlueViolet} scale 0.8 rotate<0,20,0> translate<-2.5,-13.5,-5>}
#end

object{being scale 2 rotate y*160 translate<6, 12, -35.0>}
