
// Persistence of Vision Ray Tracer Object Description File
// File: rhammer.inc
// Vers: 3
// Desc: Toy Rubber Hammer object definitition
// Date: 15/11/97
// Auth: Tony Ewen
#include "colors.inc"

#declare KidsHammer =
merge
{
 difference
 {
  sphere
  {
   0,
   2.25
   translate x * 2.25
  }
  cylinder { <.25,0,0> <5,0,0> 5 }
 }
 cone
 {
  <.25, 0, 0 > 1
  < 1.5, 0, 0> .75
 }
 cone
 {
  < 1.5, 0, 0> .75
  < 3.5, 0, 0> .6
 }
 cylinder
 {
  < 3.5, 0, 0 >
  < 5.25, 0, 0 > .6
 }
 lathe
 {
  linear_spline
  3
  <.6, 0 >, <1, 1 >, < .75, 2.25>
  rotate z * -90
  translate x * 5.25
 }

 sphere
 {
  0 * x
  0.75
  scale < .1, 1, 1 >
  translate x * 7.5
 }
 
 difference
 {
  cylinder { <6.25, 0, 1.5> < 6.25, 0, .5 >  0.8125 }
  torus {  0.8125, .25 rotate x * 90 translate < 6.25, 0, .825 > }
 }
 sphere
 {
  0, .75
  scale <1, 1, .5 >
  translate < 6.25, 0, -1.375 >
 }
 difference
 {
  cylinder { <6.25, 0, -1 > <6.25, 0, 0 > .5 }
  torus { .5, .125 rotate x * 90 translate <6.25, 0, -1> }
 }
 pigment { color Yellow }
 scale <1, .75, 1>
}

