
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Interior of the Hagia Sophia, Istanbul
// Date: Feb 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "tgeng.inc"
#include "lamp.inc"

#declare Structure = off
#declare Test_only = off
#declare Final_run = off
#declare Atmos = off

camera
{
  location  <158 , 76 , 0>
  look_at   <0 , 76 , 1>
  angle 80
}

background {color <1,1,0.9>}

#if (Final_run = off)

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <158 , 76 , 0>
  atmosphere off
}

#else

light_source {<0,600,500> color White}

light_source {<43,40,-36> color <1,1,0.9>
	fade_distance 70
	fade_power 1
	atmosphere off
}
light_source {<24,80,90> color <.7,.6,.4>
	fade_distance 30
	fade_power 1
	atmosphere off
}

#if (Atmos= on)

atmosphere
{
  type 1
  samples 20
  distance 20  // old = 20
  scattering 0.4
  aa_level 8
  aa_threshold 0.2
  jitter 0.5
  color rgbft <1.00,1.00,0.9,.4,.8>
}

#end

#end

// Ground Plane
box {<-200,0,500><500,-1,-500>
	texture {checker texture{T_Floor1} texture{T_Floor2} scale <10,7,7>}
}

#if (Structure = on)

#include "columns.inc"
#include "entab.inc"

#if (Test_only = off)

#include "mdome.inc"
object {Top_dome}

#include "pendentive.inc"
object {Pend}

#include "endsec.inc"
object {End_bay}
object {End_bay scale <-1,1,1>}

#include "qrtr.inc"
object {Part_bldg}
object {Part_bldg scale <1,1,-1>}
object {Part_bldg scale <-1,1,1>}
object {Part_bldg scale <-1,1,-1>}

#end
// PLACE TEST ONLY ITEM HERE

#include "swall.inc"
object {S_wall1}
object {S_wall2}

#end

#include "shield.inc"
object {Shield rotate <0,0,90> rotate <0,-1,0> translate <0,89,64> translate <-85,0,0>}
object {Shield translate <0,89,64> rotate <0,-55,0> translate <-85,0,0>}
object {Shield rotate <0,0,-90> translate <0,89,64> rotate <0,-125,0> translate <-85,0,0>}
object {Shield rotate <0,0,180> rotate <0,1,0> translate <0,89,64> rotate <0,-180,0> translate <-85,0,0>}

object {Shield rotate <0,0,90> rotate <0,-1,0> translate <0,89,64> translate <-85,0,0> scale <-1,1,1>}
object {Shield rotate <0,0,180> rotate <0,1,0> translate <0,89,64> rotate <0,-180,0> translate <-85,0,0>  scale <-1,1,1>}

#declare Count = 0
#while (Count < 12)
	object {Lamp3 texture{T_rail} translate <0,21,48> rotate <0,(Count * 30),0>}
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 4)
	object {Lamp3 texture{T_rail} translate <0,21,63> rotate <0,(Count * 90),0>}
	#declare Count = (Count + 1)
#end

object {Lamp3 texture{T_rail} translate <55,21,55>}
object {Lamp3 texture{T_rail} translate <55,21,-55>}
object {Lamp3 texture{T_rail} translate <-55,21,55>}
object {Lamp3 texture{T_rail} translate <-55,21,-55>}

object {Lamp4 texture{T_rail} translate <0,30,0>}
