
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: INC file for 13geng.pov
// Date: Feb 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

// THE ROUND COLUMN

#declare Column1 =
union {
	box {<-5,0,-5><5,1.25,5> texture{T_Render}}
	cylinder {<0,1.25,0><0,1.75,0>,4.5 texture{T_Render}}
	torus {4.5,0.25 sturm translate <0,1.5,0> texture{T_Render}}

	difference {
		cylinder {<0,1.75,0><0,3.25,0>,4 texture{T_Render}}
		torus {4,0.25 sturm translate <0,2.5,0> texture{T_Render}}
	}

	torus {4,0.25 sturm translate <0,2,0> texture{T_Render}}
	torus {4,0.25 sturm translate <0,3,0> texture{T_Render}}
	cylinder {<0,3.25,0><0,3.75,0>,3.5 texture{T_Render}}
	torus {3.5,0.25 sturm translate <0,3.5,0> texture{T_Render}}

	cylinder {<0,3.75,0><0,46,0>,3.25}			// main column

	cylinder {<0,41,0><0,41.5,0>,3.75 texture{T_Render}}
	cylinder {<0,46,0><0,46.5,0>,3.75 texture{T_Render}}

	difference {
		box {<4.25,46.5,4.25><-4.25,47,-4.25> texture{T_Render}}
		
		box {<2,40,4.25><-2,60,8.5> rotate <0,45,0> texture{T_Render}}
		box {<2,40,4.25><-2,60,8.5> rotate <0,135,0> texture{T_Render}}
		box {<2,40,4.25><-2,60,8.5> rotate <0,-45,0> texture{T_Render}}
		box {<2,40,4.25><-2,60,8.5> rotate <0,-135,0> texture{T_Render}}
	}
		
	difference {		
		box {<4.5,47,4.5><-4.5,47.75,-4.5> texture{T_Render}}
		
		box {<2,40,4.75><-2,60,8.5> rotate <0,45,0> texture{T_Render}}
		box {<2,40,4.75><-2,60,8.5> rotate <0,135,0> texture{T_Render}}
		box {<2,40,4.75><-2,60,8.5> rotate <0,-45,0> texture{T_Render}}
		box {<2,40,4.75><-2,60,8.5> rotate <0,-135,0> texture{T_Render}}
	}
	
	difference {
		box {<4.75,47.75,4.75><-4.75,48.75,-4.75> texture{T_Render}}
		
		box {<2,40,5.5><-2,60,8.5> rotate <0,45,0> texture{T_Render}}
		box {<2,40,5.5><-2,60,8.5> rotate <0,135,0> texture{T_Render}}
		box {<2,40,5.5><-2,60,8.5> rotate <0,-45,0> texture{T_Render}}
		box {<2,40,5.5><-2,60,8.5> rotate <0,-135,0> texture{T_Render}}
	}
	
	difference {
		box {<5,50,5><-5,48.75,-5> texture{T_Render}}
		
		box {<2,40,6.5><-2,60,8.5> rotate <0,45,0> texture{T_Render}}
		box {<2,40,6.5><-2,60,8.5> rotate <0,135,0> texture{T_Render}}
		box {<2,40,6.5><-2,60,8.5> rotate <0,-45,0> texture{T_Render}}
		box {<2,40,6.5><-2,60,8.5> rotate <0,-135,0> texture{T_Render}}
	}
	
	box {<5.5,50,5.5><-5.5,50.75,-5.5> texture{T_Render2}}

	box {<-0.5,47.75,-5.5><0.5,48.75,5.5> texture{T_Render2}}
	box {<-1,48.75,-5.5><1,50,5.5> texture{T_Render2}}
	box {<-5.5,47.75,-0.5><5.5,48.75,0.5> texture{T_Render2}}
	box {<-5.5,48.75,-1><5.5,50,1> texture{T_Render2}}
}

// THE SQUARE COLUMN

#declare Column2 =
union {
	box {<-5,0,-5><5,1.25,5> texture{T_Render}}
	box {<4.5,1.25,4.5><-4.5,1.75,-4.5> texture{T_Render}}

	cylinder {<4.5,1.5,4.5><-4.5,1.5,4.5>,0.25 texture{T_Render}}
	cylinder {<4.5,1.5,4.5><4.5,1.5,-4.5>,0.25 texture{T_Render}}
	cylinder {<-4.5,1.5,4.5><-4.5,1.5,-4.5>,0.25 texture{T_Render}}
	cylinder {<4.5,1.5,-4.5><-4.5,1.5,-4.5>,0.25 texture{T_Render}}
	sphere {<4.5,1.5,4.5>,0.25 texture{T_Render}}
	sphere {<-4.5,1.5,4.5>,0.25 texture{T_Render}}
	sphere {<4.5,1.5,-4.5>,0.25 texture{T_Render}}
	sphere {<-4.5,1.5,-4.5>,0.25 texture{T_Render}}

	difference {
		box {<4,1.75,4><-4,3.25,-4> texture{T_Render}}

		cylinder {<4,2.5,5><-4,2.5,5>,0.25 texture{T_Render}}
		cylinder {<5,2.5,4><5,2.5,-4>,0.25 texture{T_Render}}
		cylinder {<-4,2.5,5><-4,2.5,-5>,0.25 texture{T_Render}}
		cylinder {<5,2.5,-4><-5,2.5,-4>,0.25 texture{T_Render}}
	}

	cylinder {<4,2,4><-4,2,4>,0.25 texture{T_Render}}
	cylinder {<4,2,4><4,2,-4>,0.25 texture{T_Render}}
	cylinder {<-4,2,4><-4,2,-4>,0.25 texture{T_Render}}
	cylinder {<4,2,-4><-4,2,-4>,0.25 texture{T_Render}}
	sphere {<4,2,4>,0.25 texture{T_Render}}
	sphere {<-4,2,4>,0.25 texture{T_Render}}
	sphere {<4,2,-4>,0.25 texture{T_Render}}
	sphere {<-4,2,-4>,0.25 texture{T_Render}}

	cylinder {<4,3,4><-4,3,4>,0.25 texture{T_Render}}
	cylinder {<4,3,4><4,3,-4>,0.25 texture{T_Render}}
	cylinder {<-4,3,4><-4,3,-4>,0.25 texture{T_Render}}
	cylinder {<4,3,-4><-4,3,-4>,0.25 texture{T_Render}}
	sphere {<4,3,4>,0.25 texture{T_Render}}
	sphere {<-4,3,4>,0.25 texture{T_Render}}
	sphere {<4,3,-4>,0.25 texture{T_Render}}
	sphere {<-4,3,-4>,0.25 texture{T_Render}}

	box {<3.5,3.25,3.5><-3.5,3.75,-3.5> texture{T_Render}}

	torus {3.5,0.25 sturm translate <0,3.5,0> texture{T_Render}}

	box {<3.25,3.75,3.25><-3.25,46,-3.25>}			// main column

	box {<3.75,41,3.75><-3.75,41.5,-3.75> texture{T_Render}}
	box {<3.75,46,3.75><-3.75,46.5,-3.75> texture{T_Render}}

	box {<4.25,46.5,4.25><-4.25,47,-4.25> texture{T_Render}}
	box {<4.5,47,4.5><-4.5,47.75,-4.5> texture{T_Render}}
	box {<4.75,47.75,4.75><-4.75,48.75,-4.75> texture{T_Render}}
	box {<5,50,5><-5,48.75,-5> texture{T_Render}}
	box {<5.5,50,5.5><-5.5,50.75,-5.5> texture{T_Render}}

	box {<-0.5,47.75,-5.5><0.5,48.75,5.5> texture{T_Render2}}
	box {<-1,48.75,-5.5><1,50,5.5> texture{T_Render2}}
	box {<-5.5,47.75,-0.5><5.5,48.75,0.5> texture{T_Render2}}
	box {<-5.5,48.75,-1><5.5,50,1> texture{T_Render2}}
}

#declare Arch1 =
difference {
	union {
		difference {
			box {<0,0,-4.5><10.85,9.25,4.5>}
			cylinder {<9.85,0,-4.75><9.85,0,4.75>,7.85}
		}
		cylinder {<0,5.75,-5><0,5.75,5>,2 texture{T_Render2}}
		cylinder {<0,5.75,-4.75><0,5.75,4.75>,2.5}
		box {<0,0,-4.75><2.8,2.5,4.75>}
		box {<0,0,-5><2.5,2,5> texture{T_Render2}}
		difference {
			union {
				cylinder {<9.85,0,-5><9.85,0,5>,7.35 texture{T_Render2}}
				cylinder {<9.85,0,-4.75><9.85,0,4.75>,7.85}
			}
			cylinder {<9.85,0,-6><9.85,0,6>,5.35  texture{T_Render2}}
		}
	}
	box {<20,0,20><-20,-20,-20>}
	box {<0,30,30><-30,-30,-30>}
	box {<9.85,40,40><40,-40,-40>}
}

#declare Arch2 =
difference {
	union {
		difference {
			box {<0,0,-2.5><7.85,7.55,2.5>}
			cylinder {<6.85,0,-5><6.85,0,5>,6.05}
		}
		cylinder {<0,5.05,-3><0,5.05,3>,1.5 texture{T_Render2}}
		cylinder {<0,5.05,-2.75><0,5.05,2.75>,1.75}
		box {<0,0,-2.75><0.97,2.25,2.75>}
		box {<0,0,-3><1.15,2,3> texture{T_Render2}}
		difference {
			union {
				cylinder {<6.85,0,-3><6.85,0,3>,6.05 texture{T_Render2}}
				cylinder {<6.85,0,-2.75><6.85,0,2.75>,6.3}
			}
			cylinder {<9.85,0,-6><9.85,0,6>,4.05  texture{T_Render2}}
		}
	}
	box {<20,0,20><-20,-20,-20>}
	box {<0,30,30><-30,-30,-30>}
	box {<9.85,40,40><40,-40,-40>}
}


#declare Column1_group =
union {
	object {Column1}
	object {Arch1 translate <0,50.75,0> texture{T_Render}}
	object {Arch1 texture{T_Render} scale <-1,1,1> translate <0,50.75,0>}
}

#declare Column2_group =
union {
	object {Column2}
	object {Arch1 translate <0,50.75,0> texture{T_Render}}
	object {Arch1 texture{T_Render} scale <-1,1,1> translate <0,50.75,0>}
}

#declare Column3_group =
union {
	object {Column1 scale .6}
	object {Arch2 translate <0,30.45,0> texture{T_Render}}
	object {Arch2 texture{T_Render} scale <-1,1,1> translate <0,30.45,0>}
}

#declare Column4_group =
union {
	object {Column2 scale .6}
	object {Arch2 translate <0,30.45,0> texture{T_Render}}
	object {Arch2 texture{T_Render} scale <-1,1,1> translate <0,30.45,0>}
}

